      module test_reaclib_mod
      implicit none

      contains

      subroutine do_test
         use const_def
         use const_lib
         use chem_def
         use chem_lib
         use reaclib_def
         use reaclib_lib
         use weak_lib

         character (len=256) :: fname
         integer :: nnuc, ierr, iounit, ir, lo, hi
         integer, dimension(:), pointer :: Z, A ! will be allocated by chem_read_ZA
      	character(len=iso_name_length), pointer :: names(:)
      	type(nuclide_set), pointer :: set(:)
         type (nuclide_data) :: nuclides 
            ! contents will be allocated by extract_nuclides_from_chem_isos
      	type(reaction_data) :: rates
            ! contents will be allocated by extract_reaclib_rates
         logical :: use_weaklib
      	double precision :: lambda, dlambda_dlnT
      	double precision :: rlambda, drlambda_dlnT
         character (len=32) :: my_mesa_dir
      	
      	include 'formats.dek'
         
         ierr = 0
         
         nullify(Z, A, names, set)
         
         my_mesa_dir = '../..'         
         call const_init(my_mesa_dir,ierr)     
      	if (ierr /= 0) then
      	   write(*,*) 'const_init failed'
      	   stop 1
      	end if        
         
         call chem_init('isotopes.data', ierr)
         if (ierr /= 0) stop 1
                  
         call weak_init('', ierr)
         if (ierr /= 0) stop 1
         
         call reaclib_init(ierr)   
         if (ierr /= 0) stop 1

         call test_create_handle
         
         fname = 'test_reaclib.jina'
      	call chem_read_ZA(fname, Z, A, nnuc, ierr)
         if (ierr /= 0) stop 1
      	
      	allocate(names(nnuc), set(nnuc))
      	
      	call generate_nuclide_names(Z, A, names)
      	
      	call generate_nuclide_set(names, set)
	
      	call extract_nuclides_from_chem_isos(set, nuclides, ierr)
         if (ierr /= 0) stop 1
         
         use_weaklib = .false.
         call extract_reaclib_rates(set, nuclides, rates, use_weaklib, ierr)
         if (ierr /= 0) stop 1
         
         !call test1_rate; stop

         iounit = 6
      	call output_reaclib_rates(iounit, rates, nuclides, short_format)
      	
      	write(*,*)
      	write(*,*) 'test_parse_handle'
      	do ir = 1, rates% nreactions
      	   if (rates% reaction_flag(ir) == 'e') cycle
      	   if (rates% reaction_flag(ir) == 'w') cycle
      	   call test_parse_handle(rates% reaction_handle(ir))
      	   call test_parse_handle(rates% reverse_handle(ir))
      	end do
      	
      	if (.false.) then
         	call reaclib_indices_for_reaction('r_ne20_pa_f17', rates, lo, hi, ierr)
            if (ierr /= 0) stop 2
            write(*,3) 'r_ne20_pa_f17 lo hi', lo, hi
         	call reaclib_indices_for_reaction('r_f17_ap_ne20', rates, lo, hi, ierr)
            if (ierr /= 0) stop 3
            write(*,3) 'r_f17_ap_ne20 lo hi', lo, hi
      	end if
         
         call free_reaction_data(rates)
         
         call free_nuclide_data(nuclides)
         
      	deallocate(names, set)
      	
      	call reaclib_shutdown

         write(*,*) 'done'
         
         contains
         
         subroutine test1_rate
            character (len=128) :: handle
            real*8 :: T9, lambda, rlambda
            integer :: ierr, lo, hi
            logical, parameter :: forward_only = .false.
            include 'formats.dek'
            ierr = 0
            T9 = 1d0
            handle = 'r_na23_pa_ne20'

            call reaclib_indices_for_reaction(handle, rates, lo, hi, ierr)
            if (ierr /= 0) then
               write(*,*) 'failed in reaclib_indices_for_reaction ' // trim(handle)
               return
            end if

            call reaclib_reaction_rates( &
               lo, hi, T9, rates, chem_isos, forward_only,&
               lambda, dlambda_dlnT, &
               rlambda, drlambda_dlnT, &
               ierr)      
            if (ierr /= 0) then
               write(*,*) 'failed in reaclib_reaction_rates ' // trim(handle)
               return
            end if
            write(*,1) trim(handle) // ' lambda', lambda
            write(*,1) trim(handle) // ' rlambda', rlambda
            write(*,2) 'lo', lo
            write(*,2) 'hi', hi
            write(*,*)
            
         end subroutine test1_rate
         
      end subroutine do_test 
      
      
      subroutine test_parse_handle(handle)
         use chem_def
         use reaclib_lib, only: reaclib_parse_handle, reaclib_create_handle
         character (len=*), intent(in) :: handle
         integer :: num_in, num_out, iso_ids(20), ierr, cnt, i
         character (len=10) :: op
         character (len=100) :: new_handle
         ierr = 0
         if (len_trim(handle) == 0) return
         call reaclib_parse_handle(handle, num_in, num_out, iso_ids, op, ierr)
         if (ierr /= 0) stop 1
         call reaclib_create_handle(num_in, num_out, iso_ids, new_handle)
         if (new_handle == handle) return
         write(*,*) 'problem with parse handle'
         write(*,*) 'handle ' // trim(handle)
         write(*,*) 'new_handle ' // trim(new_handle)
         cnt = 0
         write(*,*) trim(handle)
         do i=1,num_in
            cnt = cnt+1
            write(*,*) trim(chem_isos% name(iso_ids(cnt)))
         end do
         write(*,*) trim(op)
         do i=1,num_out
            cnt = cnt+1
            write(*,*) trim(chem_isos% name(iso_ids(cnt)))
         end do
         write(*,*)
         stop 1    
      end subroutine test_parse_handle
      
      
      subroutine test_create_handle
         use chem_def
         use chem_lib, only: lookup_ZN_isomeric_state
         use reaclib_lib, only: reaclib_parse_handle, reaclib_create_handle
         integer :: num_in, num_out, iso_ids(20), ierr, ial26_1, ial16_2
         character (len=10) :: op
         character (len=100) :: new_handle
         ierr = 0
         num_in = 8
         iso_ids(1:num_in) = (/ ic12, ih1, ihe4, io16, ih1, ih3, ic14, ih2 /)
         ial26_1 = lookup_ZN_isomeric_state(13, 13, 1)
         ial16_2 = lookup_ZN_isomeric_state(13, 13, 2)
         num_out = 3
         iso_ids(num_in+1:num_in+num_out) = (/ ial26_1, ial26, ial16_2 /)
         call reaclib_create_handle(num_in, num_out, iso_ids, new_handle)
         write(*,*) 'test_create_handle ' // trim(new_handle)
         call reaclib_parse_handle(new_handle, num_in, num_out, iso_ids, op, ierr)
         if (ierr /= 0) stop 1
      end subroutine test_create_handle


      end module test_reaclib_mod




      program test_reaclib
      use test_reaclib_mod
      implicit none
      call do_test
      end program
