! ***********************************************************************
!
!  Copyright (C) 2010  Bill Paxton
!
!  MESA is free software; you can use it and/or modify
!  it under the combined terms and restrictions of the MESA MANIFESTO
!  and the GNU General Library Public License as published
!  by the Free Software Foundation; either version 2 of the License,
!  or (at your option) any later version.
!
!  You should have received a copy of the MESA MANIFESTO along with
!  this software; if not, it is available at the mesa website:
!  http://mesa.sourceforge.net/
!
!  MESA is distributed in the hope that it will be useful,
!  but WITHOUT ANY WARRANTY; without even the implied warranty of
!  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
!  See the GNU Library General Public License for more details.
!
!  You should have received a copy of the GNU Library General Public License
!  along with this software; if not, write to the Free Software
!  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
!
! ***********************************************************************

      module rates_def
      use utils_def, only: integer_dict
      use reaclib_def, only: reaction_data
      use const_def, only: dp
      
      
      implicit none

      ! reactions
               
         integer, parameter :: ir_h1_h1_wk_h2 = 1 ! p(p, e+nu)h2
         integer, parameter :: irpp_to_he3 = ir_h1_h1_wk_h2+1 ! p(p, e+nu)h2(p, g)he3
         integer, parameter :: ir_h1_h1_ec_h2 = irpp_to_he3+1  ! p(e-p, nu)h2
         integer, parameter :: irpep_to_he3 = ir_h1_h1_ec_h2+1  ! p(e-p, nu)h2(p, g)he3
         integer, parameter :: ir_h2_h2_to_he4 = irpep_to_he3+1 ! h2(h2, g)he4
         integer, parameter :: ir_h1_he3_wk_he4 = ir_h2_h2_to_he4+1 ! he3(p, e+nu)he4
         integer, parameter :: ir_h2_he3_to_h1_he4 = ir_h1_he3_wk_he4+1 ! he3(d, p)he4
         integer, parameter :: ir_he3_he3_to_h1_h1_he4 = ir_h2_he3_to_h1_he4+1 ! he3(he3, 2p)he4
         integer, parameter :: ir_h1_h1_he4_to_he3_he3 = ir_he3_he3_to_h1_h1_he4+1 ! he4(2p, he3)he3
         integer, parameter :: ir_he3_ag_be7 = ir_h1_h1_he4_to_he3_he3+1 ! he3(he4, g)be7
         integer, parameter :: ir34_pp2 = ir_he3_ag_be7+1 ! he4(he3, g)be7(e-, nu)li7(p, a)he4
         integer, parameter :: ir34_pp3 = ir34_pp2+1 ! he4(he3, g)be7(p, g)b8(e+, nu)be8(, a)he4
         integer, parameter :: ir_he4_he4_he4_to_c12 = ir34_pp3+1 ! triple alpha to c12 
         integer, parameter :: ir_c12_to_he4_he4_he4 = ir_he4_he4_he4_to_c12+1 ! c12 to 3 alpha
         integer, parameter :: ir_li7_pa_he4 = ir_c12_to_he4_he4_he4+1 ! li7(p, a)he4
         integer, parameter :: ir_be7_ec_li7 = ir_li7_pa_he4+1 ! be7(e-, nu)li7
         integer, parameter :: irbe7ec_li7_aux = ir_be7_ec_li7+1 ! be7(e-, nu)li7(p, a)he4 
         integer, parameter :: ir_h2_be7_to_h1_he4_he4 = irbe7ec_li7_aux+1 ! be7(d, p)2he4
         integer, parameter :: ir_he3_be7_to_h1_h1_he4_he4 = ir_h2_be7_to_h1_he4_he4+1 ! be7(he3, 2p)2he4
         integer, parameter :: irbe7pg_b8_aux = ir_he3_be7_to_h1_h1_he4_he4+1 ! be7(p, g)b8(e+, nu)be8(, a)he4
         integer, parameter :: ir_b8_wk_he4_he4 = irbe7pg_b8_aux+1 ! b8(p=>n)be8=>2 he4
         integer, parameter :: ir_b8_gp_be7 = ir_b8_wk_he4_he4+1 ! be7(p, g)b8
         integer, parameter :: irc12_to_c13 = ir_b8_gp_be7+1 ! c12(p, g)n13(e+nu)c13
         integer, parameter :: irc12_to_n14 = irc12_to_c13+1 ! c12(p, g)n13(e+nu)c13(p, g)n14
         integer, parameter :: ir_c12_ap_n15 = irc12_to_n14+1 ! c12(a, p)n15
         integer, parameter :: irc12ap_to_o16 = ir_c12_ap_n15+1 ! c12(a, p)n15(p, g)o16
         integer, parameter :: irc12ng_to_o16 = irc12ap_to_o16+1 ! c12(n, g)c13(a, n)o16
         integer, parameter :: ir_c12_ag_o16 = irc12ng_to_o16+1
         integer, parameter :: ir1212a = ir_c12_ag_o16+1 ! c12(c12, a)ne20
         integer, parameter :: ir1212p = ir1212a+1 ! c12(c12, p)na23
         integer, parameter :: ir1212 = ir1212p+1 ! c12 + c12 -> ne20 + he4; rate includes -> na23 + h1
         integer, parameter :: ir1216_to_mg24 = ir1212+1 ! ! c12 + o16 -> mg24 + he4
         integer, parameter :: ir1216_to_si28 = ir1216_to_mg24+1 ! ! c12 + o16 -> si28
         integer, parameter :: ir_c13_an_o16 = ir1216_to_si28+1 ! c13(a, n)o16
         integer, parameter :: ir_n13_ap_o16 = ir_c13_an_o16+1 ! n13(a, p)o16
         integer, parameter :: ir_n13_gp_c12 = ir_n13_ap_o16+1 ! n13(g, p)c12
         integer, parameter :: irn14pg_aux = ir_n13_gp_c12+1 ! n14(p, g)o15
         integer, parameter :: irn14_to_n15 = irn14pg_aux+1 ! n14(p, g)o15(e+nu)n15
         integer, parameter :: irn14_to_o16 = irn14_to_n15+1 ! n14(p, g)o15(e+nu)n15(p, g)o16
         integer, parameter :: irn14_to_c12 = irn14_to_o16+1 ! n14(p, g)o15(e+nu)n15(p, a)c12
         integer, parameter :: ir_n14_ap_o17 = irn14_to_c12+1 ! n14(a, p)o17
         integer, parameter :: irn14ecap = ir_n14_ap_o17+1 ! n14(e-, nu)c14
         integer, parameter :: ir_n14_ag_f18 = irn14ecap+1 ! n14(a, g)f18
         integer, parameter :: irn14ag_to_o18 = ir_n14_ag_f18+1 ! n14(a, g)f18(e+nu)o18
         integer, parameter :: irn14ag_to_ne20_2n = irn14ag_to_o18+1 ! n14(a,g)f18(e+nu)o18(a,g)ne22(g,n)ne21(g,n)ne20
         integer, parameter :: irn14ag_to_ne22 = irn14ag_to_ne20_2n+1 ! n14(a, g)f18(e+nu)o18(a, g)ne22

         integer, parameter :: irn14ag_lite = irn14ag_to_ne22+1 ! n14 + 1.5 alpha => ne20
         integer, parameter :: ir_n14_gp_c13 = irn14ag_lite+1 ! n14(g, p)c13
         integer, parameter :: irn15pg_aux = ir_n14_gp_c13+1 ! n15(p, g)o16
         integer, parameter :: ir_n15_pa_c12 = irn15pg_aux+1 ! n15(p, a)c12
         integer, parameter :: irn15pa_aux = ir_n15_pa_c12+1 ! n15(p, a)c12
         integer, parameter :: ir_n15_ap_o18 = irn15pa_aux+1 ! n15(a, p)o18
         integer, parameter :: ir_o14_ag_ne18 =ir_n15_ap_o18+1 ! o14(a, g)ne18
         integer, parameter :: ir_o14_ap_f17 = ir_o14_ag_ne18+1 ! o14(a, p)f17
         integer, parameter :: ir_o14_gp_n13 = ir_o14_ap_f17+1 ! o14(g, p)n13
         integer, parameter :: ir_o15_ap_f18 = ir_o14_gp_n13+1 ! o15(a, p)f18
         integer, parameter :: ir_o15_ag_ne19 = ir_o15_ap_f18+1 ! o15(a, g)ne19 
         integer, parameter :: ir_o15_gp_n14 = ir_o15_ag_ne19+1 ! o15(g, p)n14
         integer, parameter :: iro16_to_o17 = ir_o15_gp_n14+1 ! o16(p, g)f17(e+nu)o17
         integer, parameter :: iro16_to_n14 = iro16_to_o17+1 ! o16(p, g)f17(e+nu)o17(p, a)n14
         integer, parameter :: ir_o16_ap_f19 = iro16_to_n14+1 ! o16(a, p)f19
         integer, parameter :: iro16ap_aux = ir_o16_ap_f19+1 ! o16(a, p)f19
         integer, parameter :: iro16ap_to_ne20 = iro16ap_aux+1 ! o16(a, p)f19(p, a)ne20
         integer, parameter :: ir_o16_ag_ne20 = iro16ap_to_ne20+1 ! o16(a, g)ne20
         integer, parameter :: ir_o16_gp_n15 = ir_o16_ag_ne20+1 ! o16(g, p)n15
         integer, parameter :: iro16gp_aux = ir_o16_gp_n15+1 ! o16(g, p)n15 
         integer, parameter :: iro16gp_to_c12 = iro16gp_aux+1 ! o16(g, p)n15(p, a)c12
         integer, parameter :: ir_o16_ga_c12 = iro16gp_to_c12+1 ! o16(g, a)c12
         integer, parameter :: iro16ng_to_mg24 = ir_o16_ga_c12+1 ! o16(n, g)o17(a, g)ne21(a, n)mg24
         integer, parameter :: ir1616 = iro16ng_to_mg24+1 ! o16 + o16 -> si28 + he4
         integer, parameter :: ir1616a = ir1616+1 ! o16(o16, a)si28 
         integer, parameter :: ir1616ppa = ir1616a+1 ! o16(o16, p)p31(p, a)si28 
         integer, parameter :: ir1616ppg = ir1616ppa+1 ! o16(o16, p)p31(p, g)s32 
         integer, parameter :: ir1616p = ir1616ppg+1 ! o16(o16, p)p31 
         integer, parameter :: ir1616p_aux = ir1616p+1 ! o16(o16, p)p31
         integer, parameter :: ir1616g = ir1616p_aux+1 ! o16(o16, g)s32 
         integer, parameter :: ir_o17_pa_n14 = ir1616g+1 ! o17(p, a)n14
         integer, parameter :: ir_o17_ag_ne21 = ir_o17_pa_n14+1 ! o17(a, g)ne21
         integer, parameter :: iro17_to_o18 = ir_o17_ag_ne21+1 ! o17(p, g)f18(e+nu)o18
         integer, parameter :: ir_o18_pa_n15 = iro17_to_o18+1 ! o18(p, a)n15 and n15(a, p)o18
         integer, parameter :: ir_o18_ag_ne22 = ir_o18_pa_n15+1 ! o18(a, g)ne22 
         integer, parameter :: ir_f17_pa_o14 = ir_o18_ag_ne22+1 ! f17(p, a)o14
         integer, parameter :: ir_f17_ap_ne20 = ir_f17_pa_o14+1 ! f17(a, p)ne20
         integer, parameter :: ir_f17_gp_o16 = ir_f17_ap_ne20+1 ! f17(g, p)o16
         integer, parameter :: ir_f18_ap_ne21 = ir_f17_gp_o16+1 ! f18(a, p)ne21
         integer, parameter :: ir_f18_pa_o15 = ir_f18_ap_ne21+1 ! f18(p, a)o15
         integer, parameter :: ir_f18_gp_o17 = ir_f18_pa_o15+1 ! f18(g, p)o17
         integer, parameter :: irf19pg_aux = ir_f18_gp_o17+1 ! f19(p, g)ne20
         integer, parameter :: ir_f19_pa_o16 = irf19pg_aux+1 ! f19(p, a)o16
         integer, parameter :: irf19pa_aux = ir_f19_pa_o16+1 ! f19(p, a)o16
         integer, parameter :: ir_f19_ap_ne22 = irf19pa_aux+1 ! f19(a, p)ne22
         integer, parameter :: ir_f19_gp_o18 = ir_f19_ap_ne22+1 ! f19(g, p)o18
         integer, parameter :: irne18ap_to_mg22 = ir_f19_gp_o18+1 ! ne18(a, p)na21(p, g)mg22
         integer, parameter :: irne18ap_to_mg24 = irne18ap_to_mg22+1 ! ne18(a, p)na21(p, g)mg22 -> mg24
         integer, parameter :: irne18ag_to_mg24 = irne18ap_to_mg24+1 ! ne18(a, g)mg22 -> mg24
         integer, parameter :: irne19pg_to_mg21 = irne18ag_to_mg24+1 ! ne19(p, g)na20(p, g)mg21
         integer, parameter :: irne19pg_to_mg22 = irne19pg_to_mg21+1 ! ne19(p, g)na20(p, g)mg21(e+nu)na21(p, g)mg22 
         integer, parameter :: irne19pg_to_mg24 = irne19pg_to_mg22+1 ! ne19(p, g)na20(p, g)mg21(e+nu)na21(p, g)mg22 -> mg24
         integer, parameter :: ir_ne19_ga_o15 = irne19pg_to_mg24+1 ! ne19(g, a)o15 
         integer, parameter :: irne20pg_to_mg22 = ir_ne19_ga_o15+1 ! ne20(p, g)na21(p, g)mg22 
         integer, parameter :: irne20pg_to_mg24 = irne20pg_to_mg22+1 ! ne20(p, g)na21(p, g)mg22 -> mg24
         integer, parameter :: ir_ne20_ag_mg24 = irne20pg_to_mg24+1 ! ne20(a, g)mg24
         integer, parameter :: ir_ne20_ga_o16 = ir_ne20_ag_mg24+1 ! ne20(g, a)o16
         integer, parameter :: ir_ne20_gp_f19 = ir_ne20_ga_o16+1 ! ne20(g, p)f19
         integer, parameter :: irne20gp_aux = ir_ne20_gp_f19+1 ! ne20(g, p)f19
         integer, parameter :: irne20gp_to_o16 = irne20gp_aux+1 ! ne20(g, p)f19(p, a)o16
         integer, parameter :: ir_ne20_ap_na23 = irne20gp_to_o16+1 ! ne20(a, p)na23
         integer, parameter :: irne20ap_aux = ir_ne20_ap_na23+1 ! ne20(a, p)na23
         integer, parameter :: irne20ap_to_mg24 = irne20ap_aux+1 ! ne20(a, p)na23(p, g)mg24
         integer, parameter :: irne20ng_to_mg24 = irne20ap_to_mg24+1 ! ne20(n, g)ne21(a, n)mg24
         integer, parameter :: ir_ne22_ag_mg26 = irne20ng_to_mg24+1 ! ne22(a, g)mg26
         integer, parameter :: ir_ne22_ga_o18 = ir_ne22_ag_mg26+1 ! ne22(g, a)o18
         integer, parameter :: irne22ag_fake = ir_ne22_ga_o18+1 ! ne22(0.5a, g)mg24
         integer, parameter :: irne22ga_fake = irne22ag_fake+1 ! ne22(g, 0.5a)ne20
         integer, parameter :: ir_na23_gp_ne22 = irne22ga_fake+1 ! na23(g, p)ne22
         integer, parameter :: ir_na23_ap_mg26 = ir_na23_gp_ne22+1 ! na23(a, p)mg26 
         integer, parameter :: irna23ap_aux = ir_na23_ap_mg26+1 ! na23(a, p)mg26 
         integer, parameter :: ir_na23_pa_ne20 = irna23ap_aux+1 ! na23(p, a)ne20 
         integer, parameter :: irna23pa_aux = ir_na23_pa_ne20+1 ! na23(p, a)ne20 
         integer, parameter :: irna23pg_aux = irna23pa_aux+1 ! na23(p, g)mg24 
         integer, parameter :: ir_mg24_ap_al27 = irna23pg_aux+1 ! mg24(a, p)al27 
         integer, parameter :: irmg24ap_aux = ir_mg24_ap_al27+1 ! mg24(a, p)al27 
         integer, parameter :: irmg24ap_to_si28 = irmg24ap_aux+1 
         integer, parameter :: ir_mg24_ag_si28 = irmg24ap_to_si28+1 ! mg24(a, g)si28 
         integer, parameter :: ir_mg24_ga_ne20 = ir_mg24_ag_si28+1 ! mg24(g, a)ne20
         integer, parameter :: ir_mg24_gp_na23 = ir_mg24_ga_ne20+1 ! mg24(g, p)na23 
         integer, parameter :: irmg24gp_aux = ir_mg24_gp_na23+1 ! mg24(g, p)na23 
         integer, parameter :: irmg24gp_to_ne20 = irmg24gp_aux+1 ! mg24(g, p)na23(p, a)ne20 

         integer, parameter :: iral27pg_aux = irmg24gp_to_ne20+1 ! al27(p, g)si28
         integer, parameter :: ir_al27_gp_mg26 = iral27pg_aux+1 ! al27(g, p)mg26
         integer, parameter :: ir_al27_pa_mg24 = ir_al27_gp_mg26+1 ! al27(p, a)mg24 
         integer, parameter :: iral27pa_aux = ir_al27_pa_mg24+1 ! al27(p, a)mg24 
         integer, parameter :: ir_al27_ap_si30 = iral27pa_aux+1 ! al27(a, p)si30
         integer, parameter :: ir_si28_ap_p31 = ir_al27_ap_si30+1 ! si28(a, p)p31 
         integer, parameter :: irsi28ap_aux = ir_si28_ap_p31+1 ! si28(a, p)p31 
         integer, parameter :: irsi28ap_to_s32 = irsi28ap_aux+1 
         integer, parameter :: ir_si28_ag_s32 = irsi28ap_to_s32+1 ! si28(a, g)s32 
         integer, parameter :: ir_si28_gp_al27 = ir_si28_ag_s32+1 ! si28(g, p)al27
         integer, parameter :: irsi28gp_aux = ir_si28_gp_al27+1 ! si28(g, p)al27
         integer, parameter :: ir_si28_ga_mg24 = irsi28gp_aux+1 ! si28(g, a)mg24
         integer, parameter :: irsi28gp_to_mg24 = ir_si28_ga_mg24+1 

         integer, parameter :: ir_p31_pg_s32 = irsi28gp_to_mg24+1 ! p31(g, p)si30 
         integer, parameter :: irp31pg_aux = ir_p31_pg_s32+1 ! p31(p, g)s32 
         integer, parameter :: ir_p31_pa_si28 = irp31pg_aux+1 ! p31(p, a)si28 
         integer, parameter :: irp31pa_aux = ir_p31_pa_si28+1 ! p31(p, a)si28 
         integer, parameter :: ir_s32_ap_cl35 = irp31pa_aux+1 ! s32(a, p)cl35 
         integer, parameter :: irs32ap_aux = ir_s32_ap_cl35+1 ! s32(a, p)cl35 
         integer, parameter :: irs32ap_to_ar36 = irs32ap_aux+1 ! 
         integer, parameter :: ir_s32_ag_ar36 = irs32ap_to_ar36+1 ! s32(a, g)ar36 
         integer, parameter :: ir_s32_gp_p31 = ir_s32_ag_ar36+1 ! s32(g, p)p31 
         integer, parameter :: irs32gp_aux = ir_s32_gp_p31+1 ! s32(g, p)p31 
         integer, parameter :: ir_s32_ga_si28 = irs32gp_aux+1 ! s32(g, a)si28 
         integer, parameter :: irs32gp_to_si28 = ir_s32_ga_si28+1 !    
         integer, parameter :: ircl35pg_aux = irs32gp_to_si28+1 ! cl35(p, g)ar36
         integer, parameter :: ir_cl35_pa_s32 = ircl35pg_aux+1 ! cl35(p, a)s32 
         integer, parameter :: ircl35pa_aux = ir_cl35_pa_s32+1 ! cl35(p, a)s32 
         integer, parameter :: ir_ar36_ap_k39 = ircl35pa_aux+1 ! ar36(a, p)k39

         integer, parameter :: irar36ap_to_ca40 = ir_ar36_ap_k39+1 !  
         integer, parameter :: ir_ar36_ag_ca40 = irar36ap_to_ca40+1 ! ar36(a, g)ca40 
         integer, parameter :: ir_ar36_gp_cl35 = ir_ar36_ag_ca40+1 ! ar36(g, p)cl35
         integer, parameter :: irar36gp_aux = ir_ar36_gp_cl35+1 ! ar36(g, p)cl35
         integer, parameter :: ir_ar36_ga_s32 = irar36gp_aux+1 ! ar36(g, a)s32 
         integer, parameter :: irar36gp_to_s32 = ir_ar36_ga_s32+1 ! 
         integer, parameter :: irk39pg_aux = irar36gp_to_s32+1 ! k39(p, g)ca40 
         integer, parameter :: ir_k39_pa_ar36 = irk39pg_aux+1 ! k39(p, a)ar36
         integer, parameter :: ir_ca40_ap_sc43 = ir_k39_pa_ar36+1 ! ca40(a, p)sc43 
         integer, parameter :: irca40ap_aux = ir_ca40_ap_sc43+1 ! ca40(a, p)sc43 

         integer, parameter :: irca40ap_to_ti44 = irca40ap_aux+1 !
         integer, parameter :: ir_ca40_ag_ti44 = irca40ap_to_ti44+1 ! ca40(a, g)ti44 
         integer, parameter :: ir_ca40_gp_k39 = ir_ca40_ag_ti44+1 ! ca40(g, p)k39 
         integer, parameter :: irca40gp_aux = ir_ca40_gp_k39+1 ! ca40(g, p)k39 
         integer, parameter :: ir_ca40_ga_ar36 = irca40gp_aux+1 ! ca40(g, a)ar36 
         integer, parameter :: irca40gp_to_ar36 = ir_ca40_ga_ar36+1 !  
         integer, parameter :: irsc43pg_aux = irca40gp_to_ar36+1 ! sc43(p, g)ti44 
         integer, parameter :: ir_sc43_pa_ca40 = irsc43pg_aux+1 ! sc43(p, a)ca40 
         integer, parameter :: irsc43pa_aux = ir_sc43_pa_ca40+1 ! sc43(p, a)ca40 
         integer, parameter :: ir_ti44_ap_v47 = irsc43pa_aux+1 ! ti44(a, p)v47 

         integer, parameter :: irti44ap_to_cr48 = ir_ti44_ap_v47+1 ! 
         integer, parameter :: ir_ti44_ag_cr48 = irti44ap_to_cr48+1 ! ti44(a, g)cr48
         integer, parameter :: ir_ti44_gp_sc43 = ir_ti44_ag_cr48+1 ! ti44(g, p)sc43 
         integer, parameter :: irti44gp_aux = ir_ti44_gp_sc43+1 ! ti44(g, p)sc43 
         integer, parameter :: ir_ti44_ga_ca40 = irti44gp_aux+1 ! ti44(g, a)ca40 
         integer, parameter :: irti44gp_to_ca40 = ir_ti44_ga_ca40+1
         integer, parameter :: irv47pg_aux = irti44gp_to_ca40+1 ! v47(p, g)cr48 
         integer, parameter :: ir_v47_pa_ti44 = irv47pg_aux+1 ! v47(p, a)ti44 

         integer, parameter :: ir_cr48_ap_mn51 = ir_v47_pa_ti44+1 ! cr48(a, p)mn51 
         integer, parameter :: ircr48ap_to_fe52 = ir_cr48_ap_mn51+1
         integer, parameter :: ir_cr48_ag_fe52 = ircr48ap_to_fe52+1 ! cr48(a, g)fe52
         integer, parameter :: ir_cr48_gp_v47 = ir_cr48_ag_fe52+1 ! cr48(g, p)v47 
         integer, parameter :: ircr48gp_aux = ir_cr48_gp_v47+1 ! cr48(g, p)v47 
         integer, parameter :: ir_cr48_ga_ti44 = ircr48gp_aux+1 ! cr48(g, a)ti44
         integer, parameter :: ircr48gp_to_ti44 = ir_cr48_ga_ti44+1
         integer, parameter :: irmn51pg_aux = ircr48gp_to_ti44+1 ! mn51(p, g)fe52 
         integer, parameter :: ir_mn51_pa_cr48 = irmn51pg_aux+1 ! mn51(p, a)cr48 

         integer, parameter :: irfe52aprot = ir_mn51_pa_cr48+1 ! fe52(a, prot)co55 
         integer, parameter :: irfe52ap_aux = irfe52aprot+1 ! fe52(a, p)co55 
         integer, parameter :: irfe52ap_to_ni56 = irfe52ap_aux+1 ! fe52(a, p)co55(p, g)ni56
         integer, parameter :: ir_fe52_gp_mn51 = irfe52ap_to_ni56+1 ! fe52(g, p)mn51 
         integer, parameter :: irfe52gp_aux = ir_fe52_gp_mn51+1 ! fe52(g, p)mn51 
         
         integer, parameter :: ir_fe52_ag_ni56 = irfe52gp_aux+1 ! fe52(a, g)ni56
         integer, parameter :: ir_ni56_ga_fe52 = ir_fe52_ag_ni56+1 ! ni56(g, a)fe52         
         integer, parameter :: ir_fe54_ag_ni58 = ir_ni56_ga_fe52+1 ! fe54(a, g)ni58
         integer, parameter :: ir_ni58_ga_fe54 = ir_fe54_ag_ni58+1 ! ni58(g, a)fe54         
         integer, parameter :: ir_fe56_ag_ni60 = ir_ni58_ga_fe54+1 ! fe56(a, g)ni60
         
         integer, parameter :: ir_ni60_ga_fe56 = ir_fe56_ag_ni60+1 ! ni60(g, a)fe56
         integer, parameter :: ir_fe58_ag_ni62 = ir_ni60_ga_fe56+1 ! fe58(a, g)ni62
         integer, parameter :: ir_ni62_ga_fe58 = ir_fe58_ag_ni62+1 ! ni62(g, a)fe58
         
         ! ni56 + 2neut <=> ni58
         integer, parameter :: irni56ng_to_ni58 = ir_ni62_ga_fe58 + 1   ! ni56(neutg)ni57(neutg)ni58
         integer, parameter :: irni58gn_to_ni56 = irni56ng_to_ni58 + 1  ! ni58(gneut)ni57(gneut)ni56
         integer, parameter :: irni56ng_aux = irni58gn_to_ni56 + 1      ! ni56(neutg)ni57 
         integer, parameter :: irni57gn_aux = irni56ng_aux + 1          !            ni57(gneut)ni56 
         integer, parameter :: irni57ng_aux = irni57gn_aux + 1          ! ni57(neutg)ni58 
         integer, parameter :: irni58gn_aux = irni57ng_aux + 1          !            ni58(gneut)ni57

         ! ni58 + 2neut <=> ni60
         integer, parameter :: irni58ng_to_ni60 = irni58gn_aux + 1      ! ni58(neutg)ni59(neutg)ni60
         integer, parameter :: irni60gn_to_ni58 = irni58ng_to_ni60 + 1  ! ni60(gneut)ni59(gneut)ni58
         integer, parameter :: irni58ng_aux = irni60gn_to_ni58 + 1      ! ni58(neutg)ni59 
         integer, parameter :: irni59gn_aux = irni58ng_aux + 1          !            ni59(gneut)ni58 
         integer, parameter :: irni59ng_aux = irni59gn_aux + 1          ! ni59(neutg)ni60 
         integer, parameter :: irni60gn_aux = irni59ng_aux + 1          !            ni60(gneut)ni59

         ! ni60 + 2neut <=> ni62
         integer, parameter :: irni60ng_to_ni62 = irni60gn_aux + 1      ! ni60(neutg)ni61(neutg)ni62
         integer, parameter :: irni62gn_to_ni60 = irni60ng_to_ni62 + 1  ! ni62(gneut)ni61(gneut)ni60
         integer, parameter :: irni60ng_aux = irni62gn_to_ni60 + 1      ! ni60(neutg)ni61 
         integer, parameter :: irni61gn_aux = irni60ng_aux + 1          !            ni61(gneut)ni60 
         integer, parameter :: irni61ng_aux = irni61gn_aux + 1          ! ni61(neutg)ni62 
         integer, parameter :: irni62gn_aux = irni61ng_aux + 1          !            ni62(gneut)ni61

         ! ni62 + 2neut <=> ni64
         integer, parameter :: irni62ng_to_ni64 = irni62gn_aux + 1      ! ni62(neutg)ni63(neutg)ni64
         integer, parameter :: irni64gn_to_ni62 = irni62ng_to_ni64 + 1  ! ni64(gneut)ni63(gneut)ni62
         integer, parameter :: irni62ng_aux = irni64gn_to_ni62 + 1      ! ni62(neutg)ni63 
         integer, parameter :: irni63gn_aux = irni62ng_aux + 1          !            ni63(gneut)ni62 
         integer, parameter :: irni63ng_aux = irni63gn_aux + 1          ! ni63(neutg)ni64 
         integer, parameter :: irni64gn_aux = irni63ng_aux + 1          !            ni64(gneut)ni63

         integer, parameter :: ir_fe52_ga_cr48 = irni64gn_aux+1 ! fe52(g, a)cr48
         integer, parameter :: irfe52gp_to_cr48 = ir_fe52_ga_cr48+1
         integer, parameter :: irfe52ng_to_fe54 = irfe52gp_to_cr48+1 ! fe52(n, g)fe53(neut, g)fe54
         integer, parameter :: irfe52ng_aux = irfe52ng_to_fe54+1 ! fe52(n, g)fe53
         integer, parameter :: irfe52neut_to_fe54 = irfe52ng_aux+1 ! fe52(neut, g)fe53(neut, g)fe54
         integer, parameter :: irfe53ng_aux = irfe52neut_to_fe54+1 ! fe53(n, g)fe54
         integer, parameter :: irfe53gn_aux = irfe53ng_aux+1 ! fe53(g, n)fe52
         integer, parameter :: irfe54gn_to_fe52 = irfe53gn_aux+1 ! fe54(g, n)fe53
         integer, parameter :: irfe54gn_aux = irfe54gn_to_fe52+1 ! fe54(g, n)fe53
         integer, parameter :: irfe54g_to_fe52 = irfe54gn_aux+1 ! fe54(g, neut)fe53(g, neut)fe52
         integer, parameter :: irfe54protg = irfe54g_to_fe52+1 ! fe54(prot, g)co55
         integer, parameter :: irfe54a_to_ni56 = irfe54protg+1 ! fe54 + alpha -> ni56 + 2 neut
         
         integer, parameter :: irfe54ng_aux = irfe54a_to_ni56+1 ! fe54(neut, g)fe55                        
         integer, parameter :: irfe55ng_aux = irfe54ng_aux+1 ! fe55(neut, g)fe56  
         integer, parameter :: irfe55gn_aux = irfe55ng_aux+1 ! fe55(g, neut)fe54                            
         integer, parameter :: irfe56gn_aux = irfe55gn_aux+1 ! fe56(g, neut)fe55                            
         integer, parameter :: irfe54ng_to_fe56 = irfe56gn_aux+1 ! fe54(neut, g)fe55(neut, g)fe56
         integer, parameter :: irfe56gn_to_fe54 = irfe54ng_to_fe56+1 ! fe56(g, neut)fe55(g, neut)fe54
         
         integer, parameter :: irfe56ng_aux = irfe56gn_to_fe54+1 ! fe56(neut, g)fe57                        
         integer, parameter :: irfe57ng_aux = irfe56ng_aux+1 ! fe57(neut, g)fe58  
         integer, parameter :: irfe57gn_aux = irfe57ng_aux+1 ! fe57(g, neut)fe56                            
         integer, parameter :: irfe58gn_aux = irfe57gn_aux+1 ! fe58(g, neut)fe57                            
         integer, parameter :: irfe56ng_to_fe58 = irfe58gn_aux+1 ! fe56(neut, g)fe57(neut, g)fe58
         integer, parameter :: irfe58gn_to_fe56 = irfe56ng_to_fe58+1 ! fe58(g, neut)fe57(g, neut)fe56
         
         integer, parameter :: irfe58ng_aux = irfe58gn_to_fe56+1 ! fe58(neut, g)fe59                        
         integer, parameter :: irfe59ng_aux = irfe58ng_aux+1 ! fe59(neut, g)fe60  
         integer, parameter :: irfe59gn_aux = irfe59ng_aux+1 ! fe59(g, neut)fe58                            
         integer, parameter :: irfe60gn_aux = irfe59gn_aux+1 ! fe60(g, neut)fe59                            
         integer, parameter :: irfe58ng_to_fe60 = irfe60gn_aux+1 ! fe58(neut, g)fe59(neut, g)fe60
         integer, parameter :: irfe60gn_to_fe58 = irfe58ng_to_fe60+1 ! fe60(g, neut)fe59(g, neut)fe58
         integer, parameter :: irfe60ec_to_cr48_12n = irfe60gn_to_fe58+1
         
         integer, parameter :: irfe60ng_aux = irfe60ec_to_cr48_12n+1 ! fe60(neut, g)fe61                        
         integer, parameter :: irfe61ng_aux = irfe60ng_aux+1 ! fe61(neut, g)fe62  
         integer, parameter :: irfe61gn_aux = irfe61ng_aux+1 ! fe61(g, neut)fe60                            
         integer, parameter :: irfe62gn_aux = irfe61gn_aux+1 ! fe62(g, neut)fe61                            
         integer, parameter :: irfe60ng_to_fe62 = irfe62gn_aux+1 ! fe60(neut, g)fe61(neut, g)fe62
         integer, parameter :: irfe62gn_to_fe60 = irfe60ng_to_fe62+1 ! fe62(g, neut)fe61(g, neut)fe60
         
         integer, parameter :: irfe62ng_aux = irfe62gn_to_fe60+1 ! fe62(neut, g)fe63                        
         integer, parameter :: irfe63ng_aux = irfe62ng_aux+1 ! fe63(neut, g)fe64  
         integer, parameter :: irfe63gn_aux = irfe63ng_aux+1 ! fe63(g, neut)fe62                            
         integer, parameter :: irfe64gn_aux = irfe63gn_aux+1 ! fe64(g, neut)fe63                            
         integer, parameter :: irfe62ng_to_fe64 = irfe64gn_aux+1 ! fe62(neut, g)fe63(neut, g)fe64
         integer, parameter :: irfe64gn_to_fe62 = irfe62ng_to_fe64+1 ! fe64(g, neut)fe63(g, neut)fe62




         integer, parameter :: irfe52aprot_to_ni56 = irfe64gn_to_fe62+1 ! fe52(a, prot)co55(prot, g)ni56
         integer, parameter :: irni56gprot_to_fe52 = irfe52aprot_to_ni56+1 ! ni56(g, prot)co55(prot, a)fe52 
         integer, parameter :: irfe52aprot_to_fe54 = irni56gprot_to_fe52+1 ! fe52(a, prot)co55(g, prot)fe54
         integer, parameter :: irfe54prot_to_fe52 = irfe52aprot_to_fe54+1 ! fe54(prot, g)co55(prot, a)fe52
         integer, parameter :: irfe54prot_to_ni56 = irfe54prot_to_fe52+1 ! fe54(prot, g)co55(prot, g)ni56
         integer, parameter :: irni56gprot_to_fe54 = irfe54prot_to_ni56+1 ! ni56(g, prot)co55(g, prot)fe54 
         integer, parameter :: irfe52aprot_aux = irni56gprot_to_fe54+1 ! fe52(a, prot)co55 
         integer, parameter :: irco55prota_aux = irfe52aprot_aux+1 ! co55(prot, a)fe52 
         integer, parameter :: irfe54protg_aux = irco55prota_aux+1 ! fe54(prot, g)co55
         integer, parameter :: irco55gprot_aux = irfe54protg_aux+1 ! co55(g, prot)fe54 
         integer, parameter :: irni56gprot_aux = irco55gprot_aux+1 ! ni56(g, prot)co55 
         integer, parameter :: irco55protg_aux = irni56gprot_aux+1 ! co55(prot, g)ni56 

         integer, parameter :: irfe54aprot_to_ni58 = irco55protg_aux+1 ! fe54(a, prot)co57(prot, g)ni58
         integer, parameter :: irni58gprot_to_fe54 = irfe54aprot_to_ni58+1 ! ni58(g, prot)co57(prot, a)fe54 
         integer, parameter :: irfe54aprot_to_fe56 = irni58gprot_to_fe54+1 ! fe54(a, prot)co57(g, prot)fe56
         integer, parameter :: irfe56prot_to_fe54 = irfe54aprot_to_fe56+1 ! fe56(prot, g)co57(prot, a)fe54
         integer, parameter :: irfe56prot_to_ni58 = irfe56prot_to_fe54+1 ! fe56(prot, g)co57(prot, g)ni58
         integer, parameter :: irni58gprot_to_fe56 = irfe56prot_to_ni58+1 ! ni58(g, prot)co57(g, prot)fe56 
         integer, parameter :: irfe54aprot_aux = irni58gprot_to_fe56+1 ! fe54(a, prot)co57 
         integer, parameter :: irco57prota_aux = irfe54aprot_aux+1 ! co57(prot, a)fe54 
         integer, parameter :: irfe56protg_aux = irco57prota_aux+1 ! fe56(prot, g)co57
         integer, parameter :: irco57gprot_aux = irfe56protg_aux+1 ! co57(g, prot)fe56 
         integer, parameter :: irni58gprot_aux = irco57gprot_aux+1 ! ni58(g, prot)co57 
         integer, parameter :: irco57protg_aux = irni58gprot_aux+1 ! co57(prot, g)ni58 

         integer, parameter :: irfe56aprot_to_ni60 = irco57protg_aux+1 ! fe56(a, prot)co59(prot, g)ni60
         integer, parameter :: irni60gprot_to_fe56 = irfe56aprot_to_ni60+1 ! ni60(g, prot)co59(prot, a)fe56 
         integer, parameter :: irfe56aprot_to_fe58 = irni60gprot_to_fe56+1 ! fe56(a, prot)co59(g, prot)fe58
         integer, parameter :: irfe58prot_to_fe56 = irfe56aprot_to_fe58+1 ! fe58(prot, g)co59(prot, a)fe56
         integer, parameter :: irfe58prot_to_ni60 = irfe58prot_to_fe56+1 ! fe58(prot, g)co59(prot, g)ni60
         integer, parameter :: irni60gprot_to_fe58 = irfe58prot_to_ni60+1 ! ni60(g, prot)co59(g, prot)fe58 
         integer, parameter :: irfe56aprot_aux = irni60gprot_to_fe58+1 ! fe56(a, prot)co59 
         integer, parameter :: irco59prota_aux = irfe56aprot_aux+1 ! co59(prot, a)fe56 
         integer, parameter :: irfe58protg_aux = irco59prota_aux+1 ! fe58(prot, g)co59
         integer, parameter :: irco59gprot_aux = irfe58protg_aux+1 ! co59(g, prot)fe58 
         integer, parameter :: irni60gprot_aux = irco59gprot_aux+1 ! ni60(g, prot)co59 
         integer, parameter :: irco59protg_aux = irni60gprot_aux+1 ! co59(prot, g)ni60 

         integer, parameter :: irfe58aprot_to_ni62 = irco59protg_aux+1 ! fe58(a, prot)co61(prot, g)ni62
         integer, parameter :: irni62gprot_to_fe58 = irfe58aprot_to_ni62+1 ! ni62(g, prot)co61(prot, a)fe58 
         integer, parameter :: irfe58aprot_to_fe60 = irni62gprot_to_fe58+1 ! fe58(a, prot)co61(g, prot)fe60
         integer, parameter :: irfe60prot_to_fe58 = irfe58aprot_to_fe60+1 ! fe60(prot, g)co61(prot, a)fe58
         integer, parameter :: irfe60prot_to_ni62 = irfe60prot_to_fe58+1 ! fe60(prot, g)co61(prot, g)ni62
         integer, parameter :: irni62gprot_to_fe60 = irfe60prot_to_ni62+1 ! ni62(g, prot)co61(g, prot)fe60 
         integer, parameter :: irfe58aprot_aux = irni62gprot_to_fe60+1 ! fe58(a, prot)co61 
         integer, parameter :: irco61prota_aux = irfe58aprot_aux+1 ! co61(prot, a)fe58 
         integer, parameter :: irfe60protg_aux = irco61prota_aux+1 ! fe60(prot, g)co61
         integer, parameter :: irco61gprot_aux = irfe60protg_aux+1 ! co61(g, prot)fe60 
         integer, parameter :: irni62gprot_aux = irco61gprot_aux+1 ! ni62(g, prot)co61 
         integer, parameter :: irco61protg_aux = irni62gprot_aux+1 ! co61(prot, g)ni62 

         integer, parameter :: irfe56ec_fake_to_cr56 = irco61protg_aux+1 ! fe56 + 2 e- => cr56
         integer, parameter :: irco55g_prot = irfe56ec_fake_to_cr56+1 ! co55(g, prot)fe54 
         integer, parameter :: irco55prot_a = irco55g_prot+1 ! co55(p, a)fe52 
         integer, parameter :: irco55pa_aux = irco55prot_a+1 ! co55(p, a)fe52 
         integer, parameter :: irco55protg = irco55pa_aux+1 ! co55(prot, g)ni56 
         integer, parameter :: irco55pg_aux = irco55protg+1 ! co55(p, g)ni56 
         integer, parameter :: irni56g_prot = irco55pg_aux+1 ! ni56(g, p)co55 
         integer, parameter :: irni56gp_aux = irni56g_prot+1 ! ni56(g, p)co55 
         integer, parameter :: irni56gp_to_fe52 = irni56gp_aux+1 ! ni56(g, p)co55(p, a)fe52 
         integer, parameter :: irni56ec_to_fe54 = irni56gp_to_fe52+1 ! ni56 + 2 e- => 56/54*fe54
         
         integer, parameter :: irfe60aprot_to_ni64 = irni56ec_to_fe54 + 1 ! fe60(a, prot)co63(prot, g)ni64
         integer, parameter :: irni64gprot_to_fe60 = irfe60aprot_to_ni64 + 1 ! ni64(g, prot)co63(prot, a)fe60 
         integer, parameter :: irfe60aprot_to_fe62 = irni64gprot_to_fe60 + 1 ! fe60(a, prot)co63(g, prot)fe62
         integer, parameter :: irfe62prot_to_fe60 = irfe60aprot_to_fe62 + 1 ! fe62(prot, g)co63(prot, a)fe60
         integer, parameter :: irfe62prot_to_ni64 = irfe62prot_to_fe60 + 1 ! fe62(prot, g)co63(prot, g)ni64
         integer, parameter :: irni64gprot_to_fe62 = irfe62prot_to_ni64 + 1 ! ni64(g, prot)co63(g, prot)fe62 
         integer, parameter :: irfe60aprot_aux = irni64gprot_to_fe62 + 1 ! fe60(a, prot)co63 
         integer, parameter :: irco63prota_aux = irfe60aprot_aux + 1 ! co63(prot, a)fe60 
         integer, parameter :: irfe62protg_aux = irco63prota_aux + 1 ! fe62(prot, g)co63
         integer, parameter :: irco63gprot_aux = irfe62protg_aux + 1 ! co63(g, prot)fe62 
         integer, parameter :: irni64gprot_aux = irco63gprot_aux + 1 ! ni64(g, prot)co63 
         integer, parameter :: irco63protg_aux = irni64gprot_aux + 1 ! co63(prot, g)ni64 
         
         integer, parameter :: irsc50ec_to_ca48_2n = irco63protg_aux+1 ! sc50 + 2 e- => ca48 + 2 n
         integer, parameter :: irsc51ec_to_ca48_3n = irsc50ec_to_ca48_2n+1 ! sc51 + 2 e- => ca48 + 3 n
         integer, parameter :: irti52ec_to_sc51_n = irsc51ec_to_ca48_3n+1 ! ti52 + 2 e- => sc51 + 1 n
         integer, parameter :: irv54ec_to_ti52_2n = irti52ec_to_sc51_n+1 ! v54 + 2 e- => ti52 + 2 n
         integer, parameter :: irv55ec_to_ti52_3n = irv54ec_to_ti52_2n+1 ! v55 + 2 e- => ti52 + 3 n
         integer, parameter :: ircr56ec_to_v55_n = irv55ec_to_ti52_3n+1 ! cr56 + 2 e- => v55 + 1 n
         integer, parameter :: irmn58ec_to_cr56_2n = ircr56ec_to_v55_n+1 ! mn58 + 2 e- => cr56 + 2 n
         integer, parameter :: irmn59ec_to_cr56_3n = irmn58ec_to_cr56_2n+1 ! mn59 + 2 e- => cr56 + 3 n
         integer, parameter :: irfe60ec_to_mn59_n = irmn59ec_to_cr56_3n+1 ! fe60 + 2 e- => mn59 + 1 n
         integer, parameter :: irco62ec_to_fe60_2n = irfe60ec_to_mn59_n+1 ! co62 + 2 e- => fe60 + 2 n
         integer, parameter :: irco63ec_to_fe60_3n = irco62ec_to_fe60_2n+1 ! co63 + 2 e- => fe60 + 3 n
         integer, parameter :: irco64ec_to_fe60_4n = irco63ec_to_fe60_3n+1 ! co64 + 2 e- => fe60 + 4 n

         integer, parameter :: ircr55ec_to_ti52_3n = irco64ec_to_fe60_4n+1 ! cr55 + 2 e- => ti52 + 3 n
         integer, parameter :: irfe59ec_to_cr56_3n = ircr55ec_to_ti52_3n+1 ! fe59 + 2 e- => cr56 + 3 n
         integer, parameter :: irfe57ec_to_cr56_n = irfe59ec_to_cr56_3n+1 ! fe57 + 2 e- => cr56 + 3 n

         integer, parameter :: irni56ec_to_fe56 = irfe57ec_to_cr56_n+1 ! ni56 + 2 e- => fe56
         integer, parameter :: irni58ec_to_fe56_2n = irni56ec_to_fe56+1 ! ni58 + 2 e- => fe58
         integer, parameter :: irni58ec_to_fe58 = irni58ec_to_fe56_2n+1 ! ni58 + 2 e- => fe58
         integer, parameter :: irni60ec_to_fe60 = irni58ec_to_fe58+1 ! ni60 + 2 e- => fe60
         integer, parameter :: irni62ec_to_fe60_2n = irni60ec_to_fe60+1 ! ni62 + 2 e- => fe62
         integer, parameter :: irni62ec_to_fe62 = irni62ec_to_fe60_2n+1 ! ni62 + 2 e- => fe62
         integer, parameter :: irni64ec_to_fe60_4n = irni62ec_to_fe62+1 ! ni64 + 2 e- => fe64
         integer, parameter :: irni64ec_to_fe64 = irni64ec_to_fe60_4n+1 ! 

         integer, parameter :: irti44_ecnp_ca42 = irni64ec_to_fe64+1
         integer, parameter :: irti46_ecnp_ca44 = irti44_ecnp_ca42+1
         integer, parameter :: irti48_ecnp_ca46 = irti46_ecnp_ca44+1
         integer, parameter :: irti50_ecnp_ca48 = irti48_ecnp_ca46+1
         integer, parameter :: irti52_ecnp_ca48 = irti50_ecnp_ca48+1

         integer, parameter :: ircr48_ecnp_ti46 = irti52_ecnp_ca48+1
         integer, parameter :: ircr50_ecnp_ti48 = ircr48_ecnp_ti46+1
         integer, parameter :: ircr52_ecnp_ti50 = ircr50_ecnp_ti48+1
         integer, parameter :: ircr54_ecnp_ti52 = ircr52_ecnp_ti50+1
         integer, parameter :: ircr56_ecnp_ti52 = ircr54_ecnp_ti52+1

         integer, parameter :: irfe52_ecnp_cr50 = ircr56_ecnp_ti52+1
         integer, parameter :: irfe54_ecnp_cr52 = irfe52_ecnp_cr50+1
         integer, parameter :: irfe56_ecnp_cr54 = irfe54_ecnp_cr52+1
         integer, parameter :: irfe58_ecnp_cr56 = irfe56_ecnp_cr54+1
         integer, parameter :: irfe60_ecnp_cr56 = irfe58_ecnp_cr56+1
         
         integer, parameter :: irni56_ecnp_fe54 = irfe60_ecnp_cr56+1
         integer, parameter :: irni58_ecnp_fe56 = irni56_ecnp_fe54+1
         integer, parameter :: irni60_ecnp_fe58 = irni58_ecnp_fe56+1
         integer, parameter :: irni62_ecnp_fe60 = irni60_ecnp_fe58+1
         integer, parameter :: irni64_ecnp_fe60 = irni62_ecnp_fe60+1
         
         integer, parameter :: irprot_to_neut = irni64_ecnp_fe60+1 ! prot(e-nu)neut
         integer, parameter :: irneut_to_prot = irprot_to_neut+1 ! neut(e+nu)prot
         integer, parameter :: irhe4gn_to_pieces = irneut_to_prot+1 ! he4(g, neut)he3(g, prot)h2(g, neut)prot
         integer, parameter :: irhe4g_neut_aux = irhe4gn_to_pieces+1 ! he4(g, neut)he3
         integer, parameter :: irhe3gprot_aux = irhe4g_neut_aux+1 ! he3(g, prot)h2
         integer, parameter :: irh2g_neut_aux = irhe3gprot_aux+1 ! h2(g, neut)prot
         integer, parameter :: irne22_to_ne20_2n = irh2g_neut_aux+1 ! ne22(g,neut)ne21(g,neut)ne20
         integer, parameter :: iro18_to_o16_2n = irne22_to_ne20_2n+1 ! o18(g,neut)o17(g,neut)o16
         integer, parameter :: irhe4_breakup = iro18_to_o16_2n+1 ! he4(g, neut)he3(g, prot)h2(g, neut)prot
         integer, parameter :: irprot_neutg_aux = irhe4_breakup+1 ! prot(neut, g)h2
         integer, parameter :: irh2_protg_aux = irprot_neutg_aux+1 ! h2(prot, g)he3
         integer, parameter :: irhe3_neutg_aux = irh2_protg_aux+1 ! he3(neut, g)he4
         integer, parameter :: irhe4_rebuild = irhe3_neutg_aux+1 ! prot(neut, g)h2(prot, g)he3(neut, g)he4
         integer, parameter :: irn14gp_to_c12_n = irhe4_rebuild+1 ! n14 => c12 + neut + h1
         integer, parameter :: irn14gc12 = irn14gp_to_c12_n+1 ! n14 => c12 + neut + prot
         integer, parameter :: ir_h2_pg_he3 = irn14gc12+1
         integer, parameter :: ir_be7_pg_b8 = ir_h2_pg_he3+1
         integer, parameter :: ir_c12_pg_n13 = ir_be7_pg_b8+1
         integer, parameter :: ir_c13_pg_n14 = ir_c12_pg_n13+1
         integer, parameter :: ir_n13_pg_o14 = ir_c13_pg_n14+1
         integer, parameter :: ir_n14_pg_o15 = ir_n13_pg_o14+1
         integer, parameter :: ir_n15_pg_o16 = ir_n14_pg_o15+1 !
         integer, parameter :: ir_o16_pg_f17 = ir_n15_pg_o16+1 !
         integer, parameter :: ir_o17_pg_f18 = ir_o16_pg_f17+1 !
         integer, parameter :: ir_o18_pg_f19 = ir_o17_pg_f18+1 !
         integer, parameter :: ir_f19_pg_ne20 = ir_o18_pg_f19+1 !
         integer, parameter :: ir_ne22_pg_na23 = ir_f19_pg_ne20+1 !

         integer, parameter :: irc12ap_aux = ir_ne22_pg_na23+1 ! c12(a, p)n15
         integer, parameter :: irni56aprot_to_ni58 = irc12ap_aux+1 ! ni56(a, prot)cu59(g, prot)ni58
         integer, parameter :: irni58prot_to_ni56 = irni56aprot_to_ni58+1 ! ni58(prot, g)cu59(prot, a)ni56
         integer, parameter :: irni56aprot_aux = irni58prot_to_ni56+1 ! ni56(a, prot)cu59 
         integer, parameter :: ircu59prota_aux = irni56aprot_aux+1 ! cu59(prot, a)ni56 
         integer, parameter :: irni58protg_aux = ircu59prota_aux+1 ! ni58(prot, g)cu59
         integer, parameter :: ircu59gprot_aux = irni58protg_aux+1 ! cu59(g, prot)ni58 
         integer, parameter :: irni58aprot_to_ni60 = ircu59gprot_aux+1 ! ni58(a, prot)cu61(g, prot)ni60
         integer, parameter :: irni60prot_to_ni58 = irni58aprot_to_ni60+1 ! ni60(prot, g)cu61(prot, a)ni58
         integer, parameter :: irni58aprot_aux = irni60prot_to_ni58+1 ! ni58(a, prot)cu61 
         integer, parameter :: ircu61prota_aux = irni58aprot_aux+1 ! cu61(prot, a)ni58 
         integer, parameter :: irni60protg_aux = ircu61prota_aux+1 ! ni60(prot, g)cu61
         integer, parameter :: ircu61gprot_aux = irni60protg_aux+1 ! cu61(g, prot)ni60 
         integer, parameter :: irni60aprot_to_ni62 = ircu61gprot_aux+1 ! ni60(a, prot)cu63(g, prot)ni62
         integer, parameter :: irni62prot_to_ni60 = irni60aprot_to_ni62+1 ! ni62(prot, g)cu63(prot, a)ni60
         integer, parameter :: irni60aprot_aux = irni62prot_to_ni60+1 ! ni60(a, prot)cu63 
         integer, parameter :: ircu63prota_aux = irni60aprot_aux+1 ! cu63(prot, a)ni60 
         integer, parameter :: irni62protg_aux = ircu63prota_aux+1 ! ni62(prot, g)cu63
         integer, parameter :: ircu63gprot_aux = irni62protg_aux+1 ! cu63(g, prot)ni62 
         integer, parameter :: ir_fe60_ag_ni64 = ircu63gprot_aux+1 ! fe60(a, g)ni64
         integer, parameter :: ir_ni64_ga_fe60 = ir_fe60_ag_ni64+1 ! ni64(g, a)fe60
         integer, parameter :: irni62aprot_to_ni64 = ir_ni64_ga_fe60+1 ! ni62(a, prot)cu65(g, prot)ni64
         integer, parameter :: irni64prot_to_ni62 = irni62aprot_to_ni64+1 ! ni64(prot, g)cu65(prot, a)ni62
         integer, parameter :: irni62aprot_aux = irni64prot_to_ni62+1 ! ni62(a, prot)cu65 
         integer, parameter :: ircu65prota_aux = irni62aprot_aux+1 ! cu65(prot, a)ni62 
         integer, parameter :: irni64protg_aux = ircu65prota_aux+1 ! ni64(prot, g)cu65
         integer, parameter :: ircu65gprot_aux = irni64protg_aux+1 ! cu65(g, prot)ni64 

         integer, parameter :: ir_ni60_ag_zn64 = ircu65gprot_aux+1 ! ni60(a, g)zn64
         integer, parameter :: ir_zn64_ga_ni60 = ir_ni60_ag_zn64+1 ! zn64(g, a)ni60
         integer, parameter :: irni60aprot_to_zn64 = ir_zn64_ga_ni60+1 ! ni60(a, prot)cu63(prot, g)zn64
         integer, parameter :: irzn64gprot_to_ni60 = irni60aprot_to_zn64+1 ! zn64(g, prot)cu63(prot, a)ni60 
!         integer, parameter :: irni60aprot_aux = +1 ! ni60(a, prot)cu63 
!         integer, parameter :: ircu63prota_aux = +1 ! cu63(prot, a)ni60 
         integer, parameter :: irzn64gprot_aux = irzn64gprot_to_ni60+1 ! zn64(g, prot)cu63 
         integer, parameter :: ircu63protg_aux = irzn64gprot_aux+1 ! cu63(prot, g)zn64 
         integer, parameter :: irni62prot_to_zn64 = ircu63protg_aux+1 ! ni62(prot, g)cu63(prot, g)zn64
         integer, parameter :: irzn64gprot_to_ni62 = irni62prot_to_zn64+1 ! zn64(g, prot)cu63(g, prot)ni62 
!         integer, parameter :: irni62protg_aux = +1 ! ni62(prot, g)cu63
!         integer, parameter :: ircu63gprot_aux = +1 ! cu63(g, prot)ni62 
         integer, parameter :: irzn62aprot_to_zn64 = irzn64gprot_to_ni62+1 ! zn62(a, prot)ga65(g, prot)zn64
         integer, parameter :: irzn64prot_to_zn62 = irzn62aprot_to_zn64+1 ! zn64(prot, g)ga65(prot, a)zn62
         integer, parameter :: irzn62aprot_aux = irzn64prot_to_zn62+1 ! zn62(a, prot)ga65 
         integer, parameter :: irga65prota_aux = irzn62aprot_aux+1 ! ga65(prot, a)zn62 
         integer, parameter :: irzn64protg_aux = irga65prota_aux+1 ! zn64(prot, g)ga65
         integer, parameter :: irga65gprot_aux = irzn64protg_aux+1 ! ga65(g, prot)zn64 
         integer, parameter :: irzn62ng_to_zn64 = irga65gprot_aux+1 ! zn62(neutg)zn63(neutg)zn64
         integer, parameter :: irzn64gn_to_zn62 = irzn62ng_to_zn64+1 ! zn64(gneut)zn63(gneut)zn62
         integer, parameter :: irzn62ng_aux = irzn64gn_to_zn62+1 ! zn62(neutg)zn63 
         integer, parameter :: irzn63ng_aux = irzn62ng_aux+1 ! zn63(neutg)zn64 
         integer, parameter :: irzn63gn_aux = irzn63ng_aux+1 ! zn63(gneut)zn62 
         integer, parameter :: irzn64gn_aux = irzn63gn_aux+1 ! zn64(gneut)zn63
         integer, parameter :: irzn64ec_to_ni64 = irzn64gn_aux+1 ! zn64 + 2 e- => ni64
         
         integer, parameter :: ir_ni62_ag_zn66 = irzn64ec_to_ni64+1 ! ni62(a, g)zn66
         integer, parameter :: ir_zn66_ga_ni62 = ir_ni62_ag_zn66+1 ! zn66(g, a)ni62
         integer, parameter :: irni62aprot_to_zn66 = ir_zn66_ga_ni62+1 ! ni62(a, prot)cu65(prot, g)zn66
         integer, parameter :: irzn66gprot_to_ni62 = irni62aprot_to_zn66+1 ! zn66(g, prot)cu65(prot, a)ni62 
         integer, parameter :: irzn66gprot_aux = irzn66gprot_to_ni62+1 ! zn66(g, prot)cu65 
         integer, parameter :: ircu65protg_aux = irzn66gprot_aux+1 ! cu65(prot, g)zn66 
         integer, parameter :: irni64prot_to_zn66 = ircu65protg_aux+1 ! ni64(prot, g)cu65(prot, g)zn66
         integer, parameter :: irzn66gprot_to_ni64 = irni64prot_to_zn66+1 ! zn66(g, prot)cu65(g, prot)ni64 

         integer, parameter :: irzn64aprot_to_zn66 = irzn66gprot_to_ni64+1 ! zn64(a, prot)ga67(g, prot)zn66
         integer, parameter :: irzn66prot_to_zn64 = irzn64aprot_to_zn66+1 ! zn66(prot, g)ga67(prot, a)zn64
         integer, parameter :: irzn64aprot_aux = irzn66prot_to_zn64+1 ! zn64(a, prot)ga67 
         integer, parameter :: irga67prota_aux = irzn64aprot_aux+1 ! ga67(prot, a)zn64 
         integer, parameter :: irzn66protg_aux = irga67prota_aux+1 ! zn66(prot, g)ga67
         integer, parameter :: irga67gprot_aux = irzn66protg_aux+1 ! ga67(g, prot)zn66 

         integer, parameter :: irzn60ng_to_zn62 = irga67gprot_aux+1 ! zn60(neutg)zn61(neutg)zn62
         integer, parameter :: irzn62gn_to_zn60 = irzn60ng_to_zn62+1 ! zn62(gneut)zn61(gneut)zn60
         integer, parameter :: irzn60ng_aux = irzn62gn_to_zn60+1 ! zn60(neutg)zn61 
         integer, parameter :: irzn61ng_aux = irzn60ng_aux+1 ! zn61(neutg)zn62 
         integer, parameter :: irzn61gn_aux = irzn61ng_aux+1 ! zn61(gneut)zn60 
         integer, parameter :: irzn62gn_aux = irzn61gn_aux+1 ! zn62(gneut)zn61
         
         integer, parameter :: irzn64ng_to_zn66 = irzn62gn_aux+1 ! zn64(neutg)zn65(neutg)zn66
         integer, parameter :: irzn66gn_to_zn64 = irzn64ng_to_zn66+1 ! zn66(gneut)zn65(gneut)zn64
         integer, parameter :: irzn64ng_aux = irzn66gn_to_zn64+1 ! zn64(neutg)zn65 
         integer, parameter :: irzn65ng_aux = irzn64ng_aux+1 ! zn65(neutg)zn66 
         integer, parameter :: irzn65gn_aux = irzn65ng_aux+1 ! zn65(gneut)zn64 
         integer, parameter :: irzn66gn_aux = irzn65gn_aux+1 ! zn66(gneut)zn65
         integer, parameter :: irzn66ec_to_ni66 = irzn66gn_aux+1 ! zn66 + 2 e- => ni66

         integer, parameter :: ir_ni64_ag_zn68 = irzn66ec_to_ni66+1 ! ni64(a, g)zn68
         integer, parameter :: ir_zn68_ga_ni64 = ir_ni64_ag_zn68+1 ! zn68(g, a)ni64
         integer, parameter :: irni64aprot_to_zn68 = ir_zn68_ga_ni64+1 ! ni64(a, prot)cu67(prot, g)zn68
         integer, parameter :: irzn68gprot_to_ni64 = irni64aprot_to_zn68+1 ! zn68(g, prot)cu67(prot, a)ni64 
         integer, parameter :: irni64aprot_aux = irzn68gprot_to_ni64+1 ! ni64(a, prot)cu67 
         integer, parameter :: ircu67prota_aux = irni64aprot_aux+1 ! cu67(prot, a)ni64 
         integer, parameter :: irzn68gprot_aux = ircu67prota_aux+1 ! zn68(g, prot)cu67 
         integer, parameter :: ircu67protg_aux = irzn68gprot_aux+1 ! cu67(prot, g)zn68 
         integer, parameter :: irni66prot_to_zn68 = ircu67protg_aux+1 ! ni66(prot, g)cu67(prot, g)zn68
         integer, parameter :: irzn68gprot_to_ni66 = irni66prot_to_zn68+1 ! zn68(g, prot)cu67(g, prot)ni66 
         integer, parameter :: irni66protg_aux = irzn68gprot_to_ni66+1 ! ni66(prot, g)cu67
         integer, parameter :: ircu67gprot_aux = irni66protg_aux+1 ! cu67(g, prot)ni66 
         integer, parameter :: irzn66aprot_to_zn68 = ircu67gprot_aux+1 ! zn66(a, prot)ga69(g, prot)zn68
         integer, parameter :: irzn68prot_to_zn66 = irzn66aprot_to_zn68+1 ! zn68(prot, g)ga69(prot, a)zn66

         integer, parameter :: irzn68protg_aux = irzn68prot_to_zn66+1 ! zn68(prot, g)ga69
         integer, parameter :: irga69gprot_aux = irzn68protg_aux+1 ! ga69(g, prot)zn68 
         integer, parameter :: irzn66ng_to_zn68 = irga69gprot_aux+1 ! zn66(neutg)zn67(neutg)zn68
         integer, parameter :: irzn68gn_to_zn66 = irzn66ng_to_zn68+1 ! zn68(gneut)zn67(gneut)zn66
         integer, parameter :: irzn66ng_aux = irzn68gn_to_zn66+1 ! zn66(neutg)zn67 
         integer, parameter :: irzn67ng_aux = irzn66ng_aux+1 ! zn67(neutg)zn68 
         integer, parameter :: irzn67gn_aux = irzn67ng_aux+1 ! zn67(gneut)zn66 
         integer, parameter :: irzn68gn_aux = irzn67gn_aux+1 ! zn68(gneut)zn67
         integer, parameter :: irzn68ec_to_ni68 = irzn68gn_aux+1 ! zn68 + 2 e- => ni68

         integer, parameter :: ir_ni66_ag_zn70 = irzn68ec_to_ni68+1 ! ni66(a, g)zn70
         integer, parameter :: ir_zn70_ga_ni66 = ir_ni66_ag_zn70+1 ! zn70(g, a)ni66
         integer, parameter :: irni66aprot_to_zn70 = ir_zn70_ga_ni66+1 ! ni66(a, prot)cu69(prot, g)zn70
         integer, parameter :: irzn70gprot_to_ni66 = irni66aprot_to_zn70+1 ! zn70(g, prot)cu69(prot, a)ni66 
         integer, parameter :: irni66aprot_aux = irzn70gprot_to_ni66+1 ! ni66(a, prot)cu69 
         integer, parameter :: ircu69prota_aux = irni66aprot_aux+1 ! cu69(prot, a)ni66 
         integer, parameter :: irzn70gprot_aux = ircu69prota_aux+1 ! zn70(g, prot)cu69 
         integer, parameter :: ircu69protg_aux = irzn70gprot_aux+1 ! cu69(prot, g)zn70 
         integer, parameter :: irni68prot_to_zn70 = ircu69protg_aux+1 ! ni68(prot, g)cu69(prot, g)zn70
         integer, parameter :: irzn70gprot_to_ni68 = irni68prot_to_zn70+1 ! zn70(g, prot)cu69(g, prot)ni68 
         integer, parameter :: irni68protg_aux = irzn70gprot_to_ni68+1 ! ni68(prot, g)cu69
         integer, parameter :: ircu69gprot_aux = irni68protg_aux+1 ! cu69(g, prot)ni68 
         integer, parameter :: irzn68aprot_to_zn70 = ircu69gprot_aux+1 ! zn68(a, prot)ga71(g, prot)zn70
         integer, parameter :: irzn70prot_to_zn68 = irzn68aprot_to_zn70+1 ! zn70(prot, g)ga71(prot, a)zn68
         integer, parameter :: irzn68aprot_aux = irzn70prot_to_zn68+1 ! zn68(a, prot)ga71 
         integer, parameter :: irga71prota_aux = irzn68aprot_aux+1 ! ga71(prot, a)zn68 
         integer, parameter :: irzn70protg_aux = irga71prota_aux+1 ! zn70(prot, g)ga71
         integer, parameter :: irga71gprot_aux = irzn70protg_aux+1 ! ga71(g, prot)zn70 
         integer, parameter :: irzn68ng_to_zn70 = irga71gprot_aux+1 ! zn68(neutg)zn69(neutg)zn70
         integer, parameter :: irzn70gn_to_zn68 = irzn68ng_to_zn70+1 ! zn70(gneut)zn69(gneut)zn68
         integer, parameter :: irzn68ng_aux = irzn70gn_to_zn68+1 ! zn68(neutg)zn69 
         integer, parameter :: irzn69ng_aux = irzn68ng_aux+1 ! zn69(neutg)zn70 
         integer, parameter :: irzn69gn_aux = irzn69ng_aux+1 ! zn69(gneut)zn68 
         integer, parameter :: irzn70gn_aux = irzn69gn_aux+1 ! zn70(gneut)zn69
         integer, parameter :: irzn70ec_to_ni70 = irzn70gn_aux+1 ! zn70 + 2 e- => ni70

         integer, parameter :: ir_ni68_ag_zn72 = irzn70ec_to_ni70+1 ! ni68(a, g)zn72
         integer, parameter :: ir_zn72_ga_ni68 = ir_ni68_ag_zn72+1 ! zn72(g, a)ni68
         integer, parameter :: irni68aprot_to_zn72 = ir_zn72_ga_ni68+1 ! ni68(a, prot)cu71(prot, g)zn72
         integer, parameter :: irzn72gprot_to_ni68 = irni68aprot_to_zn72+1 ! zn72(g, prot)cu71(prot, a)ni68 
         integer, parameter :: irni68aprot_aux = irzn72gprot_to_ni68+1 ! ni68(a, prot)cu71 
         integer, parameter :: ircu71prota_aux = irni68aprot_aux+1 ! cu71(prot, a)ni68 
         integer, parameter :: irzn72gprot_aux = ircu71prota_aux+1 ! zn72(g, prot)cu71 
         integer, parameter :: ircu71protg_aux = irzn72gprot_aux+1 ! cu71(prot, g)zn72 
         integer, parameter :: irni70prot_to_zn72 = ircu71protg_aux+1 ! ni70(prot, g)cu71(prot, g)zn72
         integer, parameter :: irzn72gprot_to_ni70 = irni70prot_to_zn72+1 ! zn72(g, prot)cu71(g, prot)ni70 
         integer, parameter :: irni70protg_aux = irzn72gprot_to_ni70+1 ! ni70(prot, g)cu71
         integer, parameter :: ircu71gprot_aux = irni70protg_aux+1 ! cu71(g, prot)ni70 
         integer, parameter :: irzn70aprot_to_zn72 = ircu71gprot_aux+1 ! zn70(a, prot)ga73(g, prot)zn72
         integer, parameter :: irzn72prot_to_zn70 = irzn70aprot_to_zn72+1 ! zn72(prot, g)ga73(prot, a)zn70

         integer, parameter :: irzn70ng_to_zn72 = irzn72prot_to_zn70+1 ! zn70(neutg)zn71(neutg)zn72
         integer, parameter :: irzn72gn_to_zn70 = irzn70ng_to_zn72+1 ! zn72(gneut)zn71(gneut)zn70
         integer, parameter :: irzn70ng_aux = irzn72gn_to_zn70+1 ! zn70(neutg)zn71 
         integer, parameter :: irzn71ng_aux = irzn70ng_aux+1 ! zn71(neutg)zn72 
         integer, parameter :: irzn71gn_aux = irzn71ng_aux+1 ! zn71(gneut)zn70 
         integer, parameter :: irzn72gn_aux = irzn71gn_aux+1 ! zn72(gneut)zn71
         integer, parameter :: irzn72ec_to_ni72 = irzn72gn_aux+1 ! zn72 + 2 e- => ni72

         integer, parameter :: ir_zn66_ag_ge70 = irzn72ec_to_ni72+1 ! zn66(a, g)ge70
         integer, parameter :: ir_ge70_ga_zn66 = ir_zn66_ag_ge70+1 ! ge70(g, a)zn66
         integer, parameter :: irzn66aprot_to_ge70 = ir_ge70_ga_zn66+1 ! zn66(a, prot)ga69(prot, g)ge70
         integer, parameter :: irge70gprot_to_zn66 = irzn66aprot_to_ge70+1 ! ge70(g, prot)ga69(prot, a)zn66 
         integer, parameter :: irzn66aprot_aux = irge70gprot_to_zn66+1 ! zn66(a, prot)ga69 
         integer, parameter :: irga69prota_aux = irzn66aprot_aux+1 ! ga69(prot, a)zn66 
         integer, parameter :: irge70gprot_aux = irga69prota_aux+1 ! ge70(g, prot)ga69 
         integer, parameter :: irga69protg_aux = irge70gprot_aux+1 ! ga69(prot, g)ge70 
         integer, parameter :: irzn68prot_to_ge70 = irga69protg_aux+1 ! zn68(prot, g)ga69(prot, g)ge70
         integer, parameter :: irge70gprot_to_zn68 = irzn68prot_to_ge70+1 ! ge70(g, prot)ga69(g, prot)zn68 

         integer, parameter :: irge68aprot_to_ge70 = irge70gprot_to_zn68+1 ! ge68(a, prot)as71(g, prot)ge70
         integer, parameter :: irge70prot_to_ge68 = irge68aprot_to_ge70+1 ! ge70(prot, g)as71(prot, a)ge68
         integer, parameter :: irge68aprot_aux = irge70prot_to_ge68+1 ! ge68(a, prot)as71 
         integer, parameter :: iras71prota_aux = irge68aprot_aux+1 ! as71(prot, a)ge68 
         integer, parameter :: irge70protg_aux = iras71prota_aux+1 ! ge70(prot, g)as71
         integer, parameter :: iras71gprot_aux = irge70protg_aux+1 ! as71(g, prot)ge70 
         integer, parameter :: irge68ng_to_ge70 = iras71gprot_aux+1 ! ge68(neutg)ge69(neutg)ge70
         integer, parameter :: irge70gn_to_ge68 = irge68ng_to_ge70+1 ! ge70(gneut)ge69(gneut)ge68
         integer, parameter :: irge68ng_aux = irge70gn_to_ge68+1 ! ge68(neutg)ge69 
         integer, parameter :: irge69ng_aux = irge68ng_aux+1 ! ge69(neutg)ge70 
         integer, parameter :: irge69gn_aux = irge69ng_aux+1 ! ge69(gneut)ge68 
         integer, parameter :: irge70gn_aux = irge69gn_aux+1 ! ge70(gneut)ge69
         integer, parameter :: irge70ec_to_zn70 = irge70gn_aux+1 ! ge70 + 2 e- => zn70

         integer, parameter :: ir_zn68_ag_ge72 = irge70ec_to_zn70+1 ! zn68(a, g)ge72
         integer, parameter :: ir_ge72_ga_zn68 = ir_zn68_ag_ge72+1 ! ge72(g, a)zn68
         integer, parameter :: irzn68aprot_to_ge72 = ir_ge72_ga_zn68+1 ! zn68(a, prot)ga71(prot, g)ge72
         integer, parameter :: irge72gprot_to_zn68 = irzn68aprot_to_ge72+1 ! ge72(g, prot)ga71(prot, a)zn68 

         integer, parameter :: irge72gprot_aux = irge72gprot_to_zn68+1 ! ge72(g, prot)ga71 
         integer, parameter :: irga71protg_aux = irge72gprot_aux+1 ! ga71(prot, g)ge72 
         integer, parameter :: irzn70prot_to_ge72 = irga71protg_aux+1 ! zn70(prot, g)ga71(prot, g)ge72
         integer, parameter :: irge72gprot_to_zn70 = irzn70prot_to_ge72+1 ! ge72(g, prot)ga71(g, prot)zn70 
         integer, parameter :: irge70aprot_to_ge72 = irge72gprot_to_zn70+1 ! ge70(a, prot)as73(g, prot)ge72
         integer, parameter :: irge72prot_to_ge70 = irge70aprot_to_ge72+1 ! ge72(prot, g)as73(prot, a)ge70
         integer, parameter :: irge70aprot_aux = irge72prot_to_ge70+1 ! ge70(a, prot)as73 
         integer, parameter :: iras73prota_aux = irge70aprot_aux+1 ! as73(prot, a)ge70 
         integer, parameter :: irge72protg_aux = iras73prota_aux+1 ! ge72(prot, g)as73
         integer, parameter :: iras73gprot_aux = irge72protg_aux+1 ! as73(g, prot)ge72 
         integer, parameter :: irge70ng_to_ge72 = iras73gprot_aux+1 ! ge70(neutg)ge71(neutg)ge72
         integer, parameter :: irge72gn_to_ge70 = irge70ng_to_ge72+1 ! ge72(gneut)ge71(gneut)ge70
         integer, parameter :: irge70ng_aux = irge72gn_to_ge70+1 ! ge70(neutg)ge71 
         integer, parameter :: irge71ng_aux = irge70ng_aux+1 ! ge71(neutg)ge72 
         integer, parameter :: irge71gn_aux = irge71ng_aux+1 ! ge71(gneut)ge70 
         integer, parameter :: irge72gn_aux = irge71gn_aux+1 ! ge72(gneut)ge71
         integer, parameter :: irge72ec_to_zn72 = irge72gn_aux+1 ! ge72 + 2 e- => zn72

         integer, parameter :: ir_zn70_ag_ge74 = irge72ec_to_zn72+1 ! zn70(a, g)ge74
         integer, parameter :: ir_ge74_ga_zn70 = ir_zn70_ag_ge74+1 ! ge74(g, a)zn70
         integer, parameter :: irzn70aprot_to_ge74 = ir_ge74_ga_zn70+1 ! zn70(a, prot)ga73(prot, g)ge74
         integer, parameter :: irge74gprot_to_zn70 = irzn70aprot_to_ge74+1 ! ge74(g, prot)ga73(prot, a)zn70 
         integer, parameter :: irzn70aprot_aux = irge74gprot_to_zn70+1 ! zn70(a, prot)ga73 
         integer, parameter :: irga73prota_aux = irzn70aprot_aux+1 ! ga73(prot, a)zn70 
         integer, parameter :: irge74gprot_aux = irga73prota_aux+1 ! ge74(g, prot)ga73 
         integer, parameter :: irga73protg_aux = irge74gprot_aux+1 ! ga73(prot, g)ge74 
         integer, parameter :: irzn72prot_to_ge74 = irga73protg_aux+1 ! zn72(prot, g)ga73(prot, g)ge74
         integer, parameter :: irge74gprot_to_zn72 = irzn72prot_to_ge74+1 ! ge74(g, prot)ga73(g, prot)zn72 
         integer, parameter :: irzn72protg_aux = irge74gprot_to_zn72+1 ! zn72(prot, g)ga73
         integer, parameter :: irga73gprot_aux = irzn72protg_aux+1 ! ga73(g, prot)zn72 
         integer, parameter :: irge72aprot_to_ge74 = irga73gprot_aux+1 ! ge72(a, prot)as75(g, prot)ge74
         integer, parameter :: irge74prot_to_ge72 = irge72aprot_to_ge74+1 ! ge74(prot, g)as75(prot, a)ge72
         integer, parameter :: irge72aprot_aux = irge74prot_to_ge72+1 ! ge72(a, prot)as75 
         integer, parameter :: iras75prota_aux = irge72aprot_aux+1 ! as75(prot, a)ge72 
         integer, parameter :: irge74protg_aux = iras75prota_aux+1 ! ge74(prot, g)as75
         integer, parameter :: iras75gprot_aux = irge74protg_aux+1 ! as75(g, prot)ge74 
         integer, parameter :: irge72ng_to_ge74 = iras75gprot_aux+1 ! ge72(neutg)ge73(neutg)ge74
         integer, parameter :: irge74gn_to_ge72 = irge72ng_to_ge74+1 ! ge74(gneut)ge73(gneut)ge72
         integer, parameter :: irge72ng_aux = irge74gn_to_ge72+1 ! ge72(neutg)ge73 
         integer, parameter :: irge73ng_aux = irge72ng_aux+1 ! ge73(neutg)ge74 
         integer, parameter :: irge73gn_aux = irge73ng_aux+1 ! ge73(gneut)ge72 
         integer, parameter :: irge74gn_aux = irge73gn_aux+1 ! ge74(gneut)ge73
         integer, parameter :: irge74ec_to_zn74 = irge74gn_aux+1 ! ge74 + 2 e- => zn74
         integer, parameter :: irge74ng_to_ge76 = irge74ec_to_zn74+1 ! ge74(neutg)ge75(neutg)ge76
         integer, parameter :: irge76gn_to_ge74 = irge74ng_to_ge76+1 ! ge76(gneut)ge75(gneut)ge74
         integer, parameter :: irge74ng_aux = irge76gn_to_ge74+1 ! ge74(neutg)ge75 
         integer, parameter :: irge75ng_aux = irge74ng_aux+1 ! ge75(neutg)ge76 
         integer, parameter :: irge75gn_aux = irge75ng_aux+1 ! ge75(gneut)ge74 
         integer, parameter :: irge76gn_aux = irge75gn_aux+1 ! ge76(gneut)ge75

         integer, parameter :: ir_fe62_ag_ni66 = irge76gn_aux+1 ! fe62(a, g)ni66
         integer, parameter :: ir_ni66_ga_fe62 = ir_fe62_ag_ni66+1 ! ni66(g, a)fe62
         integer, parameter :: irfe62aprot_to_ni66 = ir_ni66_ga_fe62+1 ! fe62(a, prot)co65(prot, g)ni66
         integer, parameter :: irni66gprot_to_fe62 = irfe62aprot_to_ni66+1 ! ni66(g, prot)co65(prot, a)fe62 
         integer, parameter :: irfe62aprot_aux = irni66gprot_to_fe62+1 ! fe62(a, prot)co65 
         integer, parameter :: irco65prota_aux = irfe62aprot_aux+1 ! co65(prot, a)fe62 
         integer, parameter :: irni66gprot_aux = irco65prota_aux+1 ! ni66(g, prot)co65 
         integer, parameter :: irco65protg_aux = irni66gprot_aux+1 ! co65(prot, g)ni66 
         integer, parameter :: irni64aprot_to_ni66 = irco65protg_aux+1 ! ni64(a, prot)cu67(g, prot)ni66
         integer, parameter :: irni66prot_to_ni64 = irni64aprot_to_ni66+1 ! ni66(prot, g)cu67(prot, a)ni64
         integer, parameter :: irni64ng_to_ni66 = irni66prot_to_ni64+1 ! ni64(neutg)ni65(neutg)ni66
         integer, parameter :: irni66gn_to_ni64 = irni64ng_to_ni66+1 ! ni66(gneut)ni65(gneut)ni64
         integer, parameter :: irni64ng_aux = irni66gn_to_ni64+1 ! ni64(neutg)ni65 
         integer, parameter :: irni65ng_aux = irni64ng_aux+1 ! ni65(neutg)ni66 
         integer, parameter :: irni65gn_aux = irni65ng_aux+1 ! ni65(gneut)ni64 
         integer, parameter :: irni66gn_aux = irni65gn_aux+1 ! ni66(gneut)ni65
         integer, parameter :: irni66ec_to_fe60_6n = irni66gn_aux+1

         integer, parameter :: ir_mg26_ga_ne22 = irni66ec_to_fe60_6n+1 ! mg26(g, a)ne22
         integer, parameter :: irne22ap_to_mg26 = ir_mg26_ga_ne22+1 ! ne22(a, p)na25(p, g)mg26
         integer, parameter :: irmg26gp_to_ne22 = irne22ap_to_mg26+1 ! mg26(g, p)na25(p, a)ne22 
         integer, parameter :: irne22ap_aux = irmg26gp_to_ne22+1 ! ne22(a, p)na25 
         integer, parameter :: irna25pa_aux = irne22ap_aux+1 ! na25(p, a)ne22 
         integer, parameter :: irmg26gp_aux = irna25pa_aux+1 ! mg26(g, p)na25 
         integer, parameter :: irna25pg_aux = irmg26gp_aux+1 ! na25(p, g)mg26 
         integer, parameter :: irmg24ap_to_mg26 = irna25pg_aux+1 ! mg24(a, p)al27(g, p)mg26
         integer, parameter :: irmg26p_to_mg24 = irmg24ap_to_mg26+1 ! mg26(p, g)al27(p, a)mg24
         integer, parameter :: irmg24ng_to_mg26 = irmg26p_to_mg24+1 ! mg24(neutg)mg25(neutg)mg26
         integer, parameter :: irmg26gn_to_mg24 = irmg24ng_to_mg26+1 ! mg26(gneut)mg25(gneut)mg24
         integer, parameter :: irmg24ng_aux = irmg26gn_to_mg24+1 ! mg24(neutg)mg25 
         integer, parameter :: irmg25ng_aux = irmg24ng_aux+1 ! mg25(neutg)mg26 
         integer, parameter :: irmg25gn_aux = irmg25ng_aux+1 ! mg25(gneut)mg24 
         integer, parameter :: irmg26gn_aux = irmg25gn_aux+1 ! mg26(gneut)mg25

         integer, parameter :: irmg26pg_aux = irmg26gn_aux + 1
         integer, parameter :: iral27gp_aux = irmg26pg_aux + 1
         integer, parameter :: iro18ap_to_ne22 = iral27gp_aux+1 ! o18(a, p)f21(p, g)ne22
         integer, parameter :: irne22gp_to_o18 = iro18ap_to_ne22+1 ! ne22(g, p)f21(p, a)o18 
         integer, parameter :: iro18ap_aux = irne22gp_to_o18+1 ! o18(a, p)f21 
         integer, parameter :: irf21pa_aux = iro18ap_aux+1 ! f21(p, a)o18 
         integer, parameter :: irne22gp_aux = irf21pa_aux+1 ! ne22(g, p)f21 
         integer, parameter :: irf21pg_aux = irne22gp_aux+1 ! f21(p, g)ne22 
         integer, parameter :: irne20ap_to_ne22 = irf21pg_aux+1 ! ne20(a, p)na23(g, p)ne22
         integer, parameter :: irne22p_to_ne20 = irne20ap_to_ne22+1 ! ne22(p, g)na23(p, a)ne20
         integer, parameter :: irne20ng_to_ne22 = irne22p_to_ne20+1 ! ne20(neutg)ne21(neutg)ne22
         integer, parameter :: irne22gn_to_ne20 = irne20ng_to_ne22+1 ! ne22(gneut)ne21(gneut)ne20
         integer, parameter :: irne20ng_aux = irne22gn_to_ne20+1 ! ne20(neutg)ne21 
         integer, parameter :: irne21ng_aux = irne20ng_aux+1 ! ne21(neutg)ne22 
         integer, parameter :: irne21gn_aux = irne21ng_aux+1 ! ne21(gneut)ne20 
         integer, parameter :: irne22gn_aux = irne21gn_aux+1 ! ne22(gneut)ne21
         integer, parameter :: irne22pg_aux = irne22gn_aux + 1
         integer, parameter :: irna23gp_aux = irne22pg_aux + 1
         integer, parameter :: irne22p_to_mg24 =  irna23gp_aux+ 1
         integer, parameter :: irmg24gp_to_ne22 = irne22p_to_mg24 + 1

         integer, parameter :: ir_mg26_ag_si30 = irmg24gp_to_ne22+1 ! mg26(a, g)si30
         integer, parameter :: ir_si30_ga_mg26 = ir_mg26_ag_si30+1 ! si30(g, a)mg26
         integer, parameter :: irmg26ap_to_si30 = ir_si30_ga_mg26+1 ! mg26(a, p)al29(p, g)si30
         integer, parameter :: irsi30gp_to_mg26 = irmg26ap_to_si30+1 ! si30(g, p)al29(p, a)mg26 
         integer, parameter :: irmg26ap_aux = irsi30gp_to_mg26+1 ! mg26(a, p)al29 
         integer, parameter :: iral29pa_aux = irmg26ap_aux+1 ! al29(p, a)mg26 
         integer, parameter :: irsi30gp_aux = iral29pa_aux+1 ! si30(g, p)al29 
         integer, parameter :: iral29pg_aux = irsi30gp_aux+1 ! al29(p, g)si30 
         integer, parameter :: irmg28p_to_si30 = iral29pg_aux+1 ! mg28(p, g)al29(p, g)si30
         integer, parameter :: irsi30gp_to_mg28 = irmg28p_to_si30+1 ! si30(g, p)al29(g, p)mg28 
         integer, parameter :: irmg28pg_aux = irsi30gp_to_mg28+1 ! mg28(p, g)al29
         integer, parameter :: iral29gp_aux = irmg28pg_aux+1 ! al29(g, p)mg28 
         integer, parameter :: irsi28ap_to_si30 = iral29gp_aux+1 ! si28(a, p)p31(g, p)si30
         integer, parameter :: irsi30p_to_si28 = irsi28ap_to_si30+1 ! si30(p, g)p31(p, a)si28

         integer, parameter :: irsi30pg_aux = irsi30p_to_si28+1 ! si30(p, g)p31
         integer, parameter :: irp31gp_aux = irsi30pg_aux+1 ! p31(g, p)si30 
         integer, parameter :: irsi28ng_to_si30 = irp31gp_aux+1 ! si28(neutg)si29(neutg)si30
         integer, parameter :: irsi30gn_to_si28 = irsi28ng_to_si30+1 ! si30(gneut)si29(gneut)si28
         integer, parameter :: irsi28ng_aux = irsi30gn_to_si28+1 ! si28(neutg)si29 
         integer, parameter :: irsi29ng_aux = irsi28ng_aux+1 ! si29(neutg)si30 
         integer, parameter :: irsi29gn_aux = irsi29ng_aux+1 ! si29(gneut)si28 
         integer, parameter :: irsi30gn_aux = irsi29gn_aux+1 ! si30(gneut)si29

         integer, parameter :: ir_si30_ag_s34 = irsi30gn_aux+1 ! si30(a, g)s34
         integer, parameter :: ir_s34_ga_si30 = ir_si30_ag_s34+1 ! s34(g, a)si30
         integer, parameter :: irsi30ap_to_s34 = ir_s34_ga_si30+1 ! si30(a, p)p33(p, g)s34
         integer, parameter :: irs34gp_to_si30 = irsi30ap_to_s34+1 ! s34(g, p)p33(p, a)si30 
         integer, parameter :: irsi30ap_aux = irs34gp_to_si30+1 ! si30(a, p)p33 
         integer, parameter :: irp33pa_aux = irsi30ap_aux+1 ! p33(p, a)si30 
         integer, parameter :: irs34gp_aux = irp33pa_aux+1 ! s34(g, p)p33 
         integer, parameter :: irp33pg_aux = irs34gp_aux+1 ! p33(p, g)s34 
         integer, parameter :: irsi32p_to_s34 = irp33pg_aux+1 ! si32(p, g)p33(p, g)s34
         integer, parameter :: irs34gp_to_si32 = irsi32p_to_s34+1 ! s34(g, p)p33(g, p)si32 
         integer, parameter :: irsi32pg_aux = irs34gp_to_si32+1 ! si32(p, g)p33
         integer, parameter :: irp33gp_aux = irsi32pg_aux+1 ! p33(g, p)si32 
         integer, parameter :: irs32ap_to_s34 = irp33gp_aux+1 ! s32(a, p)cl35(g, p)s34
         integer, parameter :: irs34p_to_s32 = irs32ap_to_s34+1 ! s34(p, g)cl35(p, a)s32

         integer, parameter :: irs34pg_aux = irs34p_to_s32+1 ! s34(p, g)cl35
         integer, parameter :: ircl35gp_aux = irs34pg_aux+1 ! cl35(g, p)s34 
         integer, parameter :: irs32ng_to_s34 = ircl35gp_aux+1 ! s32(neutg)s33(neutg)s34
         integer, parameter :: irs34gn_to_s32 = irs32ng_to_s34+1 ! s34(gneut)s33(gneut)s32
         integer, parameter :: irs32ng_aux = irs34gn_to_s32+1 ! s32(neutg)s33 
         integer, parameter :: irs33ng_aux = irs32ng_aux+1 ! s33(neutg)s34 
         integer, parameter :: irs33gn_aux = irs33ng_aux+1 ! s33(gneut)s32 
         integer, parameter :: irs34gn_aux = irs33gn_aux+1 ! s34(gneut)s33

         integer, parameter :: ir_s34_ag_ar38 = irs34gn_aux+1 ! s34(a, g)ar38
         integer, parameter :: ir_ar38_ga_s34 = ir_s34_ag_ar38+1 ! ar38(g, a)s34
         integer, parameter :: irs34ap_to_ar38 = ir_ar38_ga_s34+1 ! s34(a, p)cl37(p, g)ar38
         integer, parameter :: irar38gp_to_s34 = irs34ap_to_ar38+1 ! ar38(g, p)cl37(p, a)s34 
         integer, parameter :: irs34ap_aux = irar38gp_to_s34+1 ! s34(a, p)cl37 
         integer, parameter :: ircl37pa_aux = irs34ap_aux+1 ! cl37(p, a)s34 
         integer, parameter :: irar38gp_aux = ircl37pa_aux+1 ! ar38(g, p)cl37 
         integer, parameter :: ircl37pg_aux = irar38gp_aux+1 ! cl37(p, g)ar38 
         integer, parameter :: irs36p_to_ar38 = ircl37pg_aux+1 ! s36(p, g)cl37(p, g)ar38
         integer, parameter :: irar38gp_to_s36 = irs36p_to_ar38+1 ! ar38(g, p)cl37(g, p)s36 
         integer, parameter :: irs36pg_aux = irar38gp_to_s36+1 ! s36(p, g)cl37
         integer, parameter :: ircl37gp_aux = irs36pg_aux+1 ! cl37(g, p)s36 
         integer, parameter :: irar36ap_to_ar38 = ircl37gp_aux+1 ! ar36(a, p)k39(g, p)ar38
         integer, parameter :: irar38p_to_ar36 = irar36ap_to_ar38+1 ! ar38(p, g)k39(p, a)ar36
         integer, parameter :: irar36ap_aux = irar38p_to_ar36+1 ! ar36(a, p)k39 
         integer, parameter :: irk39pa_aux = irar36ap_aux+1 ! k39(p, a)ar36 
         integer, parameter :: irar38pg_aux = irk39pa_aux+1 ! ar38(p, g)k39
         integer, parameter :: irk39gp_aux = irar38pg_aux+1 ! k39(g, p)ar38 
         integer, parameter :: irar36ng_to_ar38 = irk39gp_aux+1 ! ar36(neutg)ar37(neutg)ar38
         integer, parameter :: irar38gn_to_ar36 = irar36ng_to_ar38+1 ! ar38(gneut)ar37(gneut)ar36
         integer, parameter :: irar36ng_aux = irar38gn_to_ar36+1 ! ar36(neutg)ar37 
         integer, parameter :: irar37ng_aux = irar36ng_aux+1 ! ar37(neutg)ar38 
         integer, parameter :: irar37gn_aux = irar37ng_aux+1 ! ar37(gneut)ar36 
         integer, parameter :: irar38gn_aux = irar37gn_aux+1 ! ar38(gneut)ar37

         integer, parameter :: ir_ar38_ag_ca42 = irar38gn_aux+1 ! ar38(a, g)ca42
         integer, parameter :: ir_ca42_ga_ar38 = ir_ar38_ag_ca42+1 ! ca42(g, a)ar38
         integer, parameter :: irar38ap_to_ca42 = ir_ca42_ga_ar38+1 ! ar38(a, p)k41(p, g)ca42
         integer, parameter :: irca42gp_to_ar38 = irar38ap_to_ca42+1 ! ca42(g, p)k41(p, a)ar38 
         integer, parameter :: irar38ap_aux = irca42gp_to_ar38+1 ! ar38(a, p)k41 
         integer, parameter :: irk41pa_aux = irar38ap_aux+1 ! k41(p, a)ar38 
         integer, parameter :: irca42gp_aux = irk41pa_aux+1 ! ca42(g, p)k41 
         integer, parameter :: irk41pg_aux = irca42gp_aux+1 ! k41(p, g)ca42 
         integer, parameter :: irar40p_to_ca42 = irk41pg_aux+1 ! ar40(p, g)k41(p, g)ca42
         integer, parameter :: irca42gp_to_ar40 = irar40p_to_ca42+1 ! ca42(g, p)k41(g, p)ar40 
         integer, parameter :: irar40pg_aux = irca42gp_to_ar40+1 ! ar40(p, g)k41
         integer, parameter :: irk41gp_aux = irar40pg_aux+1 ! k41(g, p)ar40 
         integer, parameter :: irca40ap_to_ca42 = irk41gp_aux+1 ! ca40(a, p)sc43(g, p)ca42
         integer, parameter :: irca42p_to_ca40 = irca40ap_to_ca42+1 ! ca42(p, g)sc43(p, a)ca40

         integer, parameter :: irca42pg_aux = irca42p_to_ca40+1 ! ca42(p, g)sc43
         integer, parameter :: irsc43gp_aux = irca42pg_aux+1 ! sc43(g, p)ca42 

         integer, parameter :: ir_ca42_ag_ti46 = irsc43gp_aux+1 ! ca42(a, g)ti46
         integer, parameter :: ir_ti46_ga_ca42 = ir_ca42_ag_ti46+1 ! ti46(g, a)ca42
         integer, parameter :: irca42ap_to_ti46 = ir_ti46_ga_ca42+1 ! ca42(a, p)sc45(p, g)ti46
         integer, parameter :: irti46gp_to_ca42 = irca42ap_to_ti46+1 ! ti46(g, p)sc45(p, a)ca42 
         integer, parameter :: irca42ap_aux = irti46gp_to_ca42+1 ! ca42(a, p)sc45 
         integer, parameter :: irsc45pa_aux = irca42ap_aux+1 ! sc45(p, a)ca42 
         integer, parameter :: irti46gp_aux = irsc45pa_aux+1 ! ti46(g, p)sc45 
         integer, parameter :: irsc45pg_aux = irti46gp_aux+1 ! sc45(p, g)ti46 
         integer, parameter :: irca44p_to_ti46 = irsc45pg_aux+1 ! ca44(p, g)sc45(p, g)ti46
         integer, parameter :: irti46gp_to_ca44 = irca44p_to_ti46+1 ! ti46(g, p)sc45(g, p)ca44 
         integer, parameter :: irca44pg_aux = irti46gp_to_ca44+1 ! ca44(p, g)sc45
         integer, parameter :: irsc45gp_aux = irca44pg_aux+1 ! sc45(g, p)ca44 
         integer, parameter :: irti44ap_to_ti46 = irsc45gp_aux+1 ! ti44(a, p)v47(g, p)ti46
         integer, parameter :: irti46p_to_ti44 = irti44ap_to_ti46+1 ! ti46(p, g)v47(p, a)ti44
         integer, parameter :: irti44ap_aux = irti46p_to_ti44+1 ! ti44(a, p)v47 
         integer, parameter :: irv47pa_aux = irti44ap_aux+1 ! v47(p, a)ti44 
         integer, parameter :: irti46pg_aux = irv47pa_aux+1 ! ti46(p, g)v47
         integer, parameter :: irv47gp_aux = irti46pg_aux+1 ! v47(g, p)ti46 

         integer, parameter :: ir_ti46_ag_cr50 = irv47gp_aux+1 ! ti46(a, g)cr50
         integer, parameter :: ir_cr50_ga_ti46 = ir_ti46_ag_cr50+1 ! cr50(g, a)ti46
         integer, parameter :: irti46ap_to_cr50 = ir_cr50_ga_ti46+1 ! ti46(a, p)v49(p, g)cr50
         integer, parameter :: ircr50gp_to_ti46 = irti46ap_to_cr50+1 ! cr50(g, p)v49(p, a)ti46 
         integer, parameter :: irti46ap_aux = ircr50gp_to_ti46+1 ! ti46(a, p)v49 
         integer, parameter :: irv49pa_aux = irti46ap_aux+1 ! v49(p, a)ti46 
         integer, parameter :: ircr50gp_aux = irv49pa_aux+1 ! cr50(g, p)v49 
         integer, parameter :: irv49pg_aux = ircr50gp_aux+1 ! v49(p, g)cr50 
         integer, parameter :: irti48p_to_cr50 = irv49pg_aux+1 ! ti48(p, g)v49(p, g)cr50
         integer, parameter :: ircr50gp_to_ti48 = irti48p_to_cr50+1 ! cr50(g, p)v49(g, p)ti48 
         integer, parameter :: irti48pg_aux = ircr50gp_to_ti48+1 ! ti48(p, g)v49
         integer, parameter :: irv49gp_aux = irti48pg_aux+1 ! v49(g, p)ti48 
         integer, parameter :: ircr48ap_to_cr50 = irv49gp_aux+1 ! cr48(a, p)mn51(g, p)cr50
         integer, parameter :: ircr50p_to_cr48 = ircr48ap_to_cr50+1 ! cr50(p, g)mn51(p, a)cr48
         integer, parameter :: ircr48ap_aux = ircr50p_to_cr48+1 ! cr48(a, p)mn51 
         integer, parameter :: irmn51pa_aux = ircr48ap_aux+1 ! mn51(p, a)cr48 
         integer, parameter :: ircr50pg_aux = irmn51pa_aux+1 ! cr50(p, g)mn51
         integer, parameter :: irmn51gp_aux = ircr50pg_aux+1 ! mn51(g, p)cr50 

         integer, parameter :: ir_cr50_ag_fe54 = irmn51gp_aux+1 ! cr50(a, g)fe54
         integer, parameter :: ir_fe54_ga_cr50 = ir_cr50_ag_fe54+1 ! fe54(g, a)cr50
         integer, parameter :: ircr50ap_to_fe54 = ir_fe54_ga_cr50+1 ! cr50(a, p)mn53(p, g)fe54
         integer, parameter :: irfe54gp_to_cr50 = ircr50ap_to_fe54+1 ! fe54(g, p)mn53(p, a)cr50 
         integer, parameter :: ircr50ap_aux = irfe54gp_to_cr50+1 ! cr50(a, p)mn53 
         integer, parameter :: irmn53pa_aux = ircr50ap_aux+1 ! mn53(p, a)cr50 
         integer, parameter :: irfe54gp_aux = irmn53pa_aux+1 ! fe54(g, p)mn53 
         integer, parameter :: irmn53pg_aux = irfe54gp_aux+1 ! mn53(p, g)fe54 
         integer, parameter :: ircr52p_to_fe54 = irmn53pg_aux+1 ! cr52(p, g)mn53(p, g)fe54
         integer, parameter :: irfe54gp_to_cr52 = ircr52p_to_fe54+1 ! fe54(g, p)mn53(g, p)cr52 
         integer, parameter :: ircr52pg_aux = irfe54gp_to_cr52+1 ! cr52(p, g)mn53
         integer, parameter :: irmn53gp_aux = ircr52pg_aux+1 ! mn53(g, p)cr52 

         integer, parameter :: irne22an_to_mg24_2n = irmn53gp_aux+1 ! ne22(a,neut)mg25(g,neut)mg24 
         integer, parameter :: irne22ag_to_mg24_2n = irne22an_to_mg24_2n+1 ! ne22(a,g)mg26(g,neut)mg25(g,neut)mg24 
         integer, parameter :: irne22ap_to_mg24_2n = irne22ag_to_mg24_2n+1 ! ne22(a,g)mg26(g,neut)mg25(g,neut)mg24 
         
         integer, parameter :: ircr48ec_to_ti48 = irne22ap_to_mg24_2n+1
         integer, parameter :: ircr50ec_to_ti50 = ircr48ec_to_ti48+1
         integer, parameter :: ircr52ec_to_ti52 = ircr50ec_to_ti50+1
         integer, parameter :: ircr54ec_to_ti52_2n = ircr52ec_to_ti52+1
         integer, parameter :: ircr56ec_to_ti52_4n = ircr54ec_to_ti52_2n+1
         integer, parameter :: irti48ec_to_ca48 = ircr56ec_to_ti52_4n+1
         integer, parameter :: irti46ec_to_ca46 = irti48ec_to_ca48+1
         integer, parameter :: irti44ec_to_ca44 = irti46ec_to_ca46+1
         integer, parameter :: irti50ec_to_ca48_2n = irti44ec_to_ca44+1
         integer, parameter :: irti52ec_to_ca48_4n = irti50ec_to_ca48_2n+1
         integer, parameter :: irfe52ec_to_cr52 = irti52ec_to_ca48_4n+1
         
         integer, parameter :: irfe56ee_to_ni56 = irfe52ec_to_cr52+1
         integer, parameter :: irti52ee_to_cr52 = irfe56ee_to_ni56+1
         integer, parameter :: ircr52ee_to_fe52 = irti52ee_to_cr52+1
         integer, parameter :: irti50ee_to_cr50 = ircr52ee_to_fe52+1

         integer, parameter :: ircr54ee_to_fe54 = irti50ee_to_cr50+1
         integer, parameter :: ircr56ee_to_fe56 = ircr54ee_to_fe54+1
         
         integer, parameter :: irfe54ec_to_cr54 = ircr56ee_to_fe56+1
         integer, parameter :: irfe56ec_to_cr56 = irfe54ec_to_cr54+1
         
         integer, parameter :: irfe58ec_to_cr56_2n = irfe56ec_to_cr56+1
         integer, parameter :: irfe60ec_to_cr56_4n = irfe58ec_to_cr56_2n+1

         integer, parameter :: ircr54ap_to_fe58 = irfe60ec_to_cr56_4n+1
         integer, parameter :: irfe58gp_to_cr54 = ircr54ap_to_fe58+1
         integer, parameter :: ircr54ap_to_cr56 = irfe58gp_to_cr54+1
         integer, parameter :: ircr56p_to_cr54 = ircr54ap_to_cr56+1
         integer, parameter :: ircr56p_to_fe58 = ircr56p_to_cr54+1
         integer, parameter :: irfe58gp_to_cr56 = ircr56p_to_fe58+1
         integer, parameter :: ircr54ap_aux = irfe58gp_to_cr56+1
         integer, parameter :: irmn57pa_aux = ircr54ap_aux+1
         integer, parameter :: ircr56pg_aux = irmn57pa_aux+1
         integer, parameter :: irmn57gp_aux = ircr56pg_aux+1
         integer, parameter :: irfe58gp_aux = irmn57gp_aux+1
         integer, parameter :: irmn57pg_aux = irfe58gp_aux+1

         integer, parameter :: ircr56ap_to_fe60 = irmn57pg_aux+1
         integer, parameter :: irfe60gp_to_cr56 = ircr56ap_to_fe60+1
         integer, parameter :: ircr56ap_to_cr58 = irfe60gp_to_cr56+1
         integer, parameter :: ircr58p_to_cr56 = ircr56ap_to_cr58+1
         integer, parameter :: ircr58p_to_fe60 = ircr58p_to_cr56+1
         integer, parameter :: irfe60gp_to_cr58 = ircr58p_to_fe60+1
         integer, parameter :: ircr56ap_aux = irfe60gp_to_cr58+1
         integer, parameter :: irmn59pa_aux = ircr56ap_aux+1
         integer, parameter :: ircr58pg_aux = irmn59pa_aux+1
         integer, parameter :: irmn59gp_aux = ircr58pg_aux+1
         integer, parameter :: irfe60gp_aux = irmn59gp_aux+1
         integer, parameter :: irmn59pg_aux = irfe60gp_aux+1

         integer, parameter :: irca40ng_to_ca42 = irmn59pg_aux+1 ! ca40(neutg)ca41(neutg)ca42
         integer, parameter :: irca42gn_to_ca40 = irca40ng_to_ca42+1 ! ca42(gneut)ca41(gneut)ca40
         integer, parameter :: irca40ng_aux = irca42gn_to_ca40+1 ! ca40(neutg)ca41 
         integer, parameter :: irca41ng_aux = irca40ng_aux+1 ! ca41(neutg)ca42 
         integer, parameter :: irca41gn_aux = irca41ng_aux+1 ! ca41(gneut)ca40 
         integer, parameter :: irca42gn_aux = irca41gn_aux+1 ! ca42(gneut)ca41

         integer, parameter :: irca42ng_to_ca44 = irca42gn_aux+1 ! ca42(neutg)ca43(neutg)ca44
         integer, parameter :: irca44gn_to_ca42 = irca42ng_to_ca44+1 ! ca44(gneut)ca43(gneut)ca42
         integer, parameter :: irca42ng_aux = irca44gn_to_ca42+1 ! ca42(neutg)ca43 
         integer, parameter :: irca43ng_aux = irca42ng_aux+1 ! ca43(neutg)ca44 
         integer, parameter :: irca43gn_aux = irca43ng_aux+1 ! ca43(gneut)ca42 
         integer, parameter :: irca44gn_aux = irca43gn_aux+1 ! ca44(gneut)ca43

         integer, parameter :: irca44ng_to_ca46 = irca44gn_aux+1 ! ca44(neutg)ca45(neutg)ca46
         integer, parameter :: irca46gn_to_ca44 = irca44ng_to_ca46+1 ! ca46(gneut)ca45(gneut)ca44
         integer, parameter :: irca44ng_aux = irca46gn_to_ca44+1 ! ca44(neutg)ca45 
         integer, parameter :: irca45ng_aux = irca44ng_aux+1 ! ca45(neutg)ca46 
         integer, parameter :: irca45gn_aux = irca45ng_aux+1 ! ca45(gneut)ca44 
         integer, parameter :: irca46gn_aux = irca45gn_aux+1 ! ca46(gneut)ca45

         integer, parameter :: irca46ng_to_ca48 = irca46gn_aux+1 ! ca46(neutg)ca47(neutg)ca48
         integer, parameter :: irca48gn_to_ca46 = irca46ng_to_ca48+1 ! ca48(gneut)ca47(gneut)ca46
         integer, parameter :: irca46ng_aux = irca48gn_to_ca46+1 ! ca46(neutg)ca47 
         integer, parameter :: irca47ng_aux = irca46ng_aux+1 ! ca47(neutg)ca48 
         integer, parameter :: irca47gn_aux = irca47ng_aux+1 ! ca47(gneut)ca46 
         integer, parameter :: irca48gn_aux = irca47gn_aux+1 ! ca48(gneut)ca47

         integer, parameter :: ircr48ng_to_cr50 = irca48gn_aux+1 ! cr48(neutg)cr49(neutg)cr50
         integer, parameter :: ircr50gn_to_cr48 = ircr48ng_to_cr50+1 ! cr50(gneut)cr49(gneut)cr48
         integer, parameter :: ircr48ng_aux = ircr50gn_to_cr48+1 ! cr48(neutg)cr49 
         integer, parameter :: ircr49ng_aux = ircr48ng_aux+1 ! cr49(neutg)cr50 
         integer, parameter :: ircr49gn_aux = ircr49ng_aux+1 ! cr49(gneut)cr48 
         integer, parameter :: ircr50gn_aux = ircr49gn_aux+1 ! cr50(gneut)cr49

         integer, parameter :: ircr50ng_to_cr52 = ircr50gn_aux+1 ! cr50(neutg)cr51(neutg)cr52
         integer, parameter :: ircr52gn_to_cr50 = ircr50ng_to_cr52+1 ! cr52(gneut)cr51(gneut)cr50
         integer, parameter :: ircr50ng_aux = ircr52gn_to_cr50+1 ! cr50(neutg)cr51 
         integer, parameter :: ircr51ng_aux = ircr50ng_aux+1 ! cr51(neutg)cr52 
         integer, parameter :: ircr51gn_aux = ircr51ng_aux+1 ! cr51(gneut)cr50 
         integer, parameter :: ircr52gn_aux = ircr51gn_aux+1 ! cr52(gneut)cr51

         integer, parameter :: ircr52ng_to_cr54 = ircr52gn_aux+1 ! cr52(neutg)cr53(neutg)cr54
         integer, parameter :: ircr54gn_to_cr52 = ircr52ng_to_cr54+1 ! cr54(gneut)cr53(gneut)cr52
         integer, parameter :: ircr52ng_aux = ircr54gn_to_cr52+1 ! cr52(neutg)cr53 
         integer, parameter :: ircr53ng_aux = ircr52ng_aux+1 ! cr53(neutg)cr54 
         integer, parameter :: ircr53gn_aux = ircr53ng_aux+1 ! cr53(gneut)cr52 
         integer, parameter :: ircr54gn_aux = ircr53gn_aux+1 ! cr54(gneut)cr53

         integer, parameter :: ircr54ng_to_cr56 = ircr54gn_aux+1 ! cr54(neutg)cr55(neutg)cr56
         integer, parameter :: ircr56gn_to_cr54 = ircr54ng_to_cr56+1 ! cr56(gneut)cr55(gneut)cr54
         integer, parameter :: ircr54ng_aux = ircr56gn_to_cr54+1 ! cr54(neutg)cr55 
         integer, parameter :: ircr55ng_aux = ircr54ng_aux+1 ! cr55(neutg)cr56 
         integer, parameter :: ircr55gn_aux = ircr55ng_aux+1 ! cr55(gneut)cr54 
         integer, parameter :: ircr56gn_aux = ircr55gn_aux+1 ! cr56(gneut)cr55

         integer, parameter :: irti44ng_to_ti46 = ircr56gn_aux+1 ! ti44(neutg)ti45(neutg)ti46
         integer, parameter :: irti46gn_to_ti44 = irti44ng_to_ti46+1 ! ti46(gneut)ti45(gneut)ti44
         integer, parameter :: irti44ng_aux = irti46gn_to_ti44+1 ! ti44(neutg)ti45 
         integer, parameter :: irti45ng_aux = irti44ng_aux+1 ! ti45(neutg)ti46 
         integer, parameter :: irti45gn_aux = irti45ng_aux+1 ! ti45(gneut)ti44 
         integer, parameter :: irti46gn_aux = irti45gn_aux+1 ! ti46(gneut)ti45

         integer, parameter :: irti46ng_to_ti48 = irti46gn_aux+1 ! ti46(neutg)ti47(neutg)ti48
         integer, parameter :: irti48gn_to_ti46 = irti46ng_to_ti48+1 ! ti48(gneut)ti47(gneut)ti46
         integer, parameter :: irti46ng_aux = irti48gn_to_ti46+1 ! ti46(neutg)ti47 
         integer, parameter :: irti47ng_aux = irti46ng_aux+1 ! ti47(neutg)ti48 
         integer, parameter :: irti47gn_aux = irti47ng_aux+1 ! ti47(gneut)ti46 
         integer, parameter :: irti48gn_aux = irti47gn_aux+1 ! ti48(gneut)ti47

         integer, parameter :: irti48ng_to_ti50 = irti48gn_aux+1 ! ti48(neutg)ti49(neutg)ti50
         integer, parameter :: irti50gn_to_ti48 = irti48ng_to_ti50+1 ! ti50(gneut)ti49(gneut)ti48
         integer, parameter :: irti48ng_aux = irti50gn_to_ti48+1 ! ti48(neutg)ti49 
         integer, parameter :: irti49ng_aux = irti48ng_aux+1 ! ti49(neutg)ti50 
         integer, parameter :: irti49gn_aux = irti49ng_aux+1 ! ti49(gneut)ti48 
         integer, parameter :: irti50gn_aux = irti49gn_aux+1 ! ti50(gneut)ti49

         integer, parameter :: irti50ng_to_ti52 = irti50gn_aux+1 ! ti50(neutg)ti51(neutg)ti52
         integer, parameter :: irti52gn_to_ti50 = irti50ng_to_ti52+1 ! ti52(gneut)ti51(gneut)ti50
         integer, parameter :: irti50ng_aux = irti52gn_to_ti50+1 ! ti50(neutg)ti51 
         integer, parameter :: irti51ng_aux = irti50ng_aux+1 ! ti51(neutg)ti52 
         integer, parameter :: irti51gn_aux = irti51ng_aux+1 ! ti51(gneut)ti50 
         integer, parameter :: irti52gn_aux = irti51gn_aux+1 ! ti52(gneut)ti51
         
         integer, parameter :: irv53ec_to_ti52_n = irti52gn_aux+1
         integer, parameter :: ircr54ec_to_v53_n = irv53ec_to_ti52_n+1
         integer, parameter :: ircr55ec_to_v53_2n = ircr54ec_to_v53_n+1

         integer, parameter :: ircr56ec_to_v53_3n = ircr55ec_to_v53_2n+1

         integer, parameter :: irfe59ec_to_mn57_2n = ircr56ec_to_v53_3n+1
         integer, parameter :: irni63ec_to_co61_2n = irfe59ec_to_mn57_2n+1
         integer, parameter :: irni64ec_to_co61_3n = irni63ec_to_co61_2n+1
         integer, parameter :: irfe60ec_to_mn57_3n = irni64ec_to_co61_3n+1
         integer, parameter :: irmn57ec_to_cr56_n = irfe60ec_to_mn57_3n+1
         integer, parameter :: irfe58ec_to_mn57_n = irmn57ec_to_cr56_n+1
         integer, parameter :: irco61ec_to_fe60_n = irfe58ec_to_mn57_n+1
         integer, parameter :: irni62ec_to_co61_n = irco61ec_to_fe60_n+1

         integer, parameter :: irhe4_to_2h1_2neut = irni62ec_to_co61_n+1 ! he4(g, neut)he3(g, prot)h2(g, neut)prot
         integer, parameter :: irhe4_from_2h1_2neut = irhe4_to_2h1_2neut+1 ! prot(neut, g)h2(prot, g)he3(neut, g)he4

         integer, parameter :: irfe54an_to_ni58 = irhe4_from_2h1_2neut+1 ! fe54(a,n)ni57(n,g)ni58
         integer, parameter :: irni58gn_to_fe54 = irfe54an_to_ni58+1 ! ni58(g,n)ni57(n,a)fe54 
         integer, parameter :: irfe54an_to_ni56 = irni58gn_to_fe54+1 ! fe54(a,n)ni57(g,n)ni56
         integer, parameter :: irni56ng_to_fe54 = irfe54an_to_ni56+1 ! ni56(n,g)ni57(n,a)fe54
         integer, parameter :: irfe54an_aux = irni56ng_to_fe54+1 ! fe54(a,n)ni57 
         integer, parameter :: irni57na_aux = irfe54an_aux+1 ! ni57(n,a)fe54 

         integer, parameter :: irfe56an_to_ni60 = irni57na_aux+1 ! fe56(a,n)ni59(n,g)ni60
         integer, parameter :: irni60gn_to_fe56 = irfe56an_to_ni60+1 ! ni60(g,n)ni59(n,a)fe56 
         integer, parameter :: irfe56an_to_ni58 = irni60gn_to_fe56+1 ! fe56(a,n)ni59(g,n)ni58
         integer, parameter :: irni58ng_to_fe56 = irfe56an_to_ni58+1 ! ni58(n,g)ni59(n,a)fe56
         integer, parameter :: irfe56an_aux = irni58ng_to_fe56+1 ! fe56(a,n)ni59 
         integer, parameter :: irni59na_aux = irfe56an_aux+1 ! ni59(n,a)fe56 

         integer, parameter :: irfe58an_to_ni62 = irni59na_aux+1 ! fe58(a,n)ni61(n,g)ni62
         integer, parameter :: irni62gn_to_fe58 = irfe58an_to_ni62+1 ! ni62(g,n)ni61(n,a)fe58 
         integer, parameter :: irfe58an_to_ni60 = irni62gn_to_fe58+1 ! fe58(a,n)ni61(g,n)ni60
         integer, parameter :: irni60ng_to_fe58 = irfe58an_to_ni60+1 ! ni60(n,g)ni61(n,a)fe58
         integer, parameter :: irfe58an_aux = irni60ng_to_fe58+1 ! fe58(a,n)ni61 
         integer, parameter :: irni61na_aux = irfe58an_aux+1 ! ni61(n,a)fe58 

         integer, parameter :: ircr54an_to_fe58 = irni61na_aux+1 ! cr54(a,n)fe57(n,g)fe58
         integer, parameter :: irfe58gn_to_cr54 = ircr54an_to_fe58+1 ! fe58(g,n)fe57(n,a)cr54 
         integer, parameter :: ircr54an_to_fe56 = irfe58gn_to_cr54+1 ! cr54(a,n)fe57(g,n)fe56
         integer, parameter :: irfe56ng_to_cr54 = ircr54an_to_fe56+1 ! fe56(n,g)fe57(n,a)cr54
         integer, parameter :: ircr54an_aux = irfe56ng_to_cr54+1 ! cr54(a,n)fe57 
         integer, parameter :: irfe57na_aux = ircr54an_aux+1 ! fe57(n,a)cr54 

         integer, parameter :: ircr56an_to_fe60 = irfe57na_aux+1 ! cr56(a,n)fe59(n,g)fe60
         integer, parameter :: irfe60gn_to_cr56 = ircr56an_to_fe60+1 ! fe60(g,n)fe59(n,a)cr56 
         integer, parameter :: ircr56an_to_fe58 = irfe60gn_to_cr56+1 ! cr56(a,n)fe59(g,n)fe58
         integer, parameter :: irfe58ng_to_cr56 = ircr56an_to_fe58+1 ! fe58(n,g)fe59(n,a)cr56
         integer, parameter :: ircr56an_aux = irfe58ng_to_cr56+1 ! cr56(a,n)fe59 
         integer, parameter :: irfe59na_aux = ircr56an_aux+1 ! fe59(n,a)cr56 

         integer, parameter :: ircr56pn_to_fe56 = irfe59na_aux+1 ! cr56(p,n)mn56(p,n)fe56
         integer, parameter :: irfe56np_to_cr56 = ircr56pn_to_fe56+1 ! fe56(n,p)mn56(n,p)cr56 
         integer, parameter :: ircr56pn_aux = irfe56np_to_cr56+1 ! cr56(p,n)mn56
         integer, parameter :: irmn56np_aux = ircr56pn_aux+1 ! mn56(n,p)cr56 
         integer, parameter :: irfe56np_aux = irmn56np_aux+ 1 ! fe56(n,p)mn56 
         integer, parameter :: irmn56pn_aux = irfe56np_aux+ 1 ! mn56(p,n)fe56 

         integer, parameter :: ircr54pn_to_fe54 = irmn56pn_aux+1 ! cr54(p,n)mn54(p,n)fe54
         integer, parameter :: irfe54np_to_cr54 = ircr54pn_to_fe54+1 ! fe54(n,p)mn54(n,p)cr54 
         integer, parameter :: ircr54pn_aux = irfe54np_to_cr54+1 ! cr54(p,n)mn54
         integer, parameter :: irmn54np_aux = ircr54pn_aux+1 ! mn54(n,p)cr54 
         integer, parameter :: irfe54np_aux = irmn54np_aux+ 1 ! fe54(n,p)mn54 
         integer, parameter :: irmn54pn_aux = irfe54np_aux+ 1 ! mn54(p,n)fe54 

         integer, parameter :: irfe58pn_to_ni58 = irmn54pn_aux+1 ! fe58(p,n)co58(p,n)ni58
         integer, parameter :: irni58np_to_fe58 = irfe58pn_to_ni58+1 ! ni58(n,p)co58(n,p)fe58 
         integer, parameter :: irfe58pn_aux = irni58np_to_fe58+1 ! fe58(p,n)co58
         integer, parameter :: irco58np_aux = irfe58pn_aux+1 ! co58(n,p)fe58 
         integer, parameter :: irni58np_aux = irco58np_aux+ 1 ! ni58(n,p)co58 
         integer, parameter :: irco58pn_aux = irni58np_aux+ 1 ! co58(p,n)ni58 

         integer, parameter :: irfe56pn_to_ni56 = irco58pn_aux+1 ! fe56(p,n)co56(p,n)ni56
         integer, parameter :: irni56np_to_fe56 = irfe56pn_to_ni56+1 ! ni56(n,p)co56(n,p)fe56 
         integer, parameter :: irfe56pn_aux = irni56np_to_fe56+1 ! fe56(p,n)co56
         integer, parameter :: irco56np_aux = irfe56pn_aux+1 ! co56(n,p)fe56 
         integer, parameter :: irni56np_aux = irco56np_aux+ 1 ! ni56(n,p)co56 
         integer, parameter :: irco56pn_aux = irni56np_aux+ 1 ! co56(p,n)ni56 

         integer, parameter :: ircr52ap_to_fe56 = irco56pn_aux+1 ! cr52(a,p)mn55(p,g)fe56
         integer, parameter :: irfe56gp_to_cr52 = ircr52ap_to_fe56+1 ! fe56(g,p)mn55(p,a)cr52 
         integer, parameter :: ircr52ap_to_cr54 = irfe56gp_to_cr52+1 ! cr52(a,p)mn55(g,p)cr54
         integer, parameter :: ircr54p_to_cr52 = ircr52ap_to_cr54+1 ! cr54(p,g)mn55(p,a)cr52
         integer, parameter :: ircr54p_to_fe56 = ircr54p_to_cr52+1 ! cr54(p,g)mn55(p,g)fe56
         integer, parameter :: irfe56gp_to_cr54 = ircr54p_to_fe56+1 ! fe56(g,p)mn55(g,p)cr54 
         integer, parameter :: ircr52ap_aux = irfe56gp_to_cr54+1 ! cr52(a,p)mn55 
         integer, parameter :: irmn55pa_aux = ircr52ap_aux+1 ! mn55(p,a)cr52 
         integer, parameter :: ircr54pg_aux = irmn55pa_aux+1 ! cr54(p,g)mn55
         integer, parameter :: irmn55gp_aux = ircr54pg_aux+1 ! mn55(g,p)cr54 
         integer, parameter :: irfe56gp_aux = irmn55gp_aux+1 ! fe56(g,p)mn55 
         integer, parameter :: irmn55pg_aux = irfe56gp_aux+1 ! mn55(p,g)fe56 

         integer, parameter :: ircr50ap_to_cr52 = irmn55pg_aux+1 ! cr50(a,p)mn53(g,p)cr52
         integer, parameter :: ircr52p_to_cr50 = ircr50ap_to_cr52+1 ! cr52(p,g)mn53(p,a)cr50

         integer, parameter :: irti52ap_to_cr56 = ircr52p_to_cr50+1 ! ti52(a,p)v55(p,g)cr56
         integer, parameter :: ircr56gp_to_ti52 = irti52ap_to_cr56+1 ! cr56(g,p)v55(p,a)ti52 
         integer, parameter :: irti52ap_to_ti54 = ircr56gp_to_ti52+1 ! ti52(a,p)v55(g,p)ti54
         integer, parameter :: irti54p_to_ti52 = irti52ap_to_ti54+1 ! ti54(p,g)v55(p,a)ti52
         integer, parameter :: irti54p_to_cr56 = irti54p_to_ti52+1 ! ti54(p,g)v55(p,g)cr56
         integer, parameter :: ircr56gp_to_ti54 = irti54p_to_cr56+1 ! cr56(g,p)v55(g,p)ti54 
         integer, parameter :: irti52ap_aux = ircr56gp_to_ti54+1 ! ti52(a,p)v55 
         integer, parameter :: irv55pa_aux = irti52ap_aux+1 ! v55(p,a)ti52 
         integer, parameter :: irti54pg_aux = irv55pa_aux+1 ! ti54(p,g)v55
         integer, parameter :: irv55gp_aux = irti54pg_aux+1 ! v55(g,p)ti54 
         integer, parameter :: ircr56gp_aux = irv55gp_aux+1 ! cr56(g,p)v55 
         integer, parameter :: irv55pg_aux = ircr56gp_aux+1 ! v55(p,g)cr56 

         integer, parameter :: irti50ap_to_cr54 = irv55pg_aux+1 ! ti50(a,p)v53(p,g)cr54
         integer, parameter :: ircr54gp_to_ti50 = irti50ap_to_cr54+1 ! cr54(g,p)v53(p,a)ti50 
         integer, parameter :: irti50ap_to_ti52 = ircr54gp_to_ti50+1 ! ti50(a,p)v53(g,p)ti52
         integer, parameter :: irti52p_to_ti50 = irti50ap_to_ti52+1 ! ti52(p,g)v53(p,a)ti50
         integer, parameter :: irti52p_to_cr54 = irti52p_to_ti50+1 ! ti52(p,g)v53(p,g)cr54
         integer, parameter :: ircr54gp_to_ti52 = irti52p_to_cr54+1 ! cr54(g,p)v53(g,p)ti52 
         integer, parameter :: irti50ap_aux = ircr54gp_to_ti52+1 ! ti50(a,p)v53 
         integer, parameter :: irv53pa_aux = irti50ap_aux+1 ! v53(p,a)ti50 
         integer, parameter :: irti52pg_aux = irv53pa_aux+1 ! ti52(p,g)v53
         integer, parameter :: irv53gp_aux = irti52pg_aux+1 ! v53(g,p)ti52 
         integer, parameter :: ircr54gp_aux = irv53gp_aux+1 ! cr54(g,p)v53 
         integer, parameter :: irv53pg_aux = ircr54gp_aux+1 ! v53(p,g)cr54 

         integer, parameter :: irti48ap_to_cr52 = irv53pg_aux+1 ! ti48(a,p)v51(p,g)cr52
         integer, parameter :: ircr52gp_to_ti48 = irti48ap_to_cr52+1 ! cr52(g,p)v51(p,a)ti48 
         integer, parameter :: irti48ap_to_ti50 = ircr52gp_to_ti48+1 ! ti48(a,p)v51(g,p)ti50
         integer, parameter :: irti50p_to_ti48 = irti48ap_to_ti50+1 ! ti50(p,g)v51(p,a)ti48
         integer, parameter :: irti50p_to_cr52 = irti50p_to_ti48+1 ! ti50(p,g)v51(p,g)cr52
         integer, parameter :: ircr52gp_to_ti50 = irti50p_to_cr52+1 ! cr52(g,p)v51(g,p)ti50 
         integer, parameter :: irti48ap_aux = ircr52gp_to_ti50+1 ! ti48(a,p)v51 
         integer, parameter :: irv51pa_aux = irti48ap_aux+1 ! v51(p,a)ti48 
         integer, parameter :: irti50pg_aux = irv51pa_aux+1 ! ti50(p,g)v51
         integer, parameter :: irv51gp_aux = irti50pg_aux+1 ! v51(g,p)ti50 
         integer, parameter :: ircr52gp_aux = irv51gp_aux+1 ! cr52(g,p)v51 
         integer, parameter :: irv51pg_aux = ircr52gp_aux+1 ! v51(p,g)cr52 

         integer, parameter :: irti46ap_to_ti48 = irv51pg_aux+1 ! ti46(a,p)v49(g,p)ti48
         integer, parameter :: irti48p_to_ti46 = irti46ap_to_ti48+1 ! ti48(p,g)v49(p,a)ti46

         integer, parameter :: ircr52an_to_fe56 = irti48p_to_ti46+1 ! cr52(a,n)fe55(n,g)fe56
         integer, parameter :: irfe56gn_to_cr52 = ircr52an_to_fe56+1 ! fe56(g,n)fe55(n,a)cr52 
         integer, parameter :: ircr52an_to_fe54 = irfe56gn_to_cr52+1 ! cr52(a,n)fe55(g,n)fe54
         integer, parameter :: irfe54ng_to_cr52 = ircr52an_to_fe54+1 ! fe54(n,g)fe55(n,a)cr52
         integer, parameter :: ircr52an_aux = irfe54ng_to_cr52+1 ! cr52(a,n)fe55 
         integer, parameter :: irfe55na_aux = ircr52an_aux+1 ! fe55(n,a)cr52 

         integer, parameter :: ircr50an_to_fe54 = irfe55na_aux+1 ! cr50(a,n)fe53(n,g)fe54
         integer, parameter :: irfe54gn_to_cr50 = ircr50an_to_fe54+1 ! fe54(g,n)fe53(n,a)cr50 
         integer, parameter :: ircr50an_to_fe52 = irfe54gn_to_cr50+1 ! cr50(a,n)fe53(g,n)fe52
         integer, parameter :: irfe52ng_to_cr50 = ircr50an_to_fe52+1 ! fe52(n,g)fe53(n,a)cr50
         integer, parameter :: ircr50an_aux = irfe52ng_to_cr50+1 ! cr50(a,n)fe53 
         integer, parameter :: irfe53na_aux = ircr50an_aux+1 ! fe53(n,a)cr50 

         integer, parameter :: irti52an_to_cr56 = irfe53na_aux+1 ! ti52(a,n)cr55(n,g)cr56
         integer, parameter :: ircr56gn_to_ti52 = irti52an_to_cr56+1 ! cr56(g,n)cr55(n,a)ti52 
         integer, parameter :: irti52an_to_cr54 = ircr56gn_to_ti52+1 ! ti52(a,n)cr55(g,n)cr54
         integer, parameter :: ircr54ng_to_ti52 = irti52an_to_cr54+1 ! cr54(n,g)cr55(n,a)ti52
         integer, parameter :: irti52an_aux = ircr54ng_to_ti52+1 ! ti52(a,n)cr55 
         integer, parameter :: ircr55na_aux = irti52an_aux+1 ! cr55(n,a)ti52 

         integer, parameter :: irti50an_to_cr54 = ircr55na_aux+1 ! ti50(a,n)cr53(n,g)cr54
         integer, parameter :: ircr54gn_to_ti50 = irti50an_to_cr54+1 ! cr54(g,n)cr53(n,a)ti50 
         integer, parameter :: irti50an_to_cr52 = ircr54gn_to_ti50+1 ! ti50(a,n)cr53(g,n)cr52
         integer, parameter :: ircr52ng_to_ti50 = irti50an_to_cr52+1 ! cr52(n,g)cr53(n,a)ti50
         integer, parameter :: irti50an_aux = ircr52ng_to_ti50+1 ! ti50(a,n)cr53 
         integer, parameter :: ircr53na_aux = irti50an_aux+1 ! cr53(n,a)ti50 

         integer, parameter :: irti48an_to_cr52 = ircr53na_aux+1 ! ti48(a,n)cr51(n,g)cr52
         integer, parameter :: ircr52gn_to_ti48 = irti48an_to_cr52+1 ! cr52(g,n)cr51(n,a)ti48 
         integer, parameter :: irti48an_to_cr50 = ircr52gn_to_ti48+1 ! ti48(a,n)cr51(g,n)cr50
         integer, parameter :: ircr50ng_to_ti48 = irti48an_to_cr50+1 ! cr50(n,g)cr51(n,a)ti48
         integer, parameter :: irti48an_aux = ircr50ng_to_ti48+1 ! ti48(a,n)cr51 
         integer, parameter :: ircr51na_aux = irti48an_aux+1 ! cr51(n,a)ti48 

         integer, parameter :: irti46an_to_cr50 = ircr51na_aux+1 ! ti46(a,n)cr49(n,g)cr50
         integer, parameter :: ircr50gn_to_ti46 = irti46an_to_cr50+1 ! cr50(g,n)cr49(n,a)ti46 
         integer, parameter :: irti46an_to_cr48 = ircr50gn_to_ti46+1 ! ti46(a,n)cr49(g,n)cr48
         integer, parameter :: ircr48ng_to_ti46 = irti46an_to_cr48+1 ! cr48(n,g)cr49(n,a)ti46
         integer, parameter :: irti46an_aux = ircr48ng_to_ti46+1 ! ti46(a,n)cr49 
         integer, parameter :: ircr49na_aux = irti46an_aux+1 ! cr49(n,a)ti46 

         integer, parameter :: ircr52pn_to_fe52 = ircr49na_aux+1 ! cr52(p,n)mn52(p,n)fe52
         integer, parameter :: irfe52np_to_cr52 = ircr52pn_to_fe52+1 ! fe52(n,p)mn52(n,p)cr52 
         integer, parameter :: ircr52pn_aux = irfe52np_to_cr52+1 ! cr52(p,n)mn52
         integer, parameter :: irmn52np_aux = ircr52pn_aux+1 ! mn52(n,p)cr52 
         integer, parameter :: irfe52np_aux = irmn52np_aux+ 1 ! fe52(n,p)mn52 
         integer, parameter :: irmn52pn_aux = irfe52np_aux+ 1 ! mn52(p,n)fe52 

         integer, parameter :: irti52pn_to_cr52 = irmn52pn_aux+1 ! ti52(p,n)v52(p,n)cr52
         integer, parameter :: ircr52np_to_ti52 = irti52pn_to_cr52+1 ! cr52(n,p)v52(n,p)ti52 
         integer, parameter :: irti52pn_aux = ircr52np_to_ti52+1 ! ti52(p,n)v52
         integer, parameter :: irv52np_aux = irti52pn_aux+1 ! v52(n,p)ti52 
         integer, parameter :: ircr52np_aux = irv52np_aux+ 1 ! cr52(n,p)v52 
         integer, parameter :: irv52pn_aux = ircr52np_aux+ 1 ! v52(p,n)cr52 

         integer, parameter :: irti50pn_to_cr50 = irv52pn_aux+1 ! ti50(p,n)v50(p,n)cr50
         integer, parameter :: ircr50np_to_ti50 = irti50pn_to_cr50+1 ! cr50(n,p)v50(n,p)ti50 
         integer, parameter :: irti50pn_aux = ircr50np_to_ti50+1 ! ti50(p,n)v50
         integer, parameter :: irv50np_aux = irti50pn_aux+1 ! v50(n,p)ti50 
         integer, parameter :: ircr50np_aux = irv50np_aux+ 1 ! cr50(n,p)v50 
         integer, parameter :: irv50pn_aux = ircr50np_aux+ 1 ! v50(p,n)cr50 

         integer, parameter :: irti48pn_to_cr48 = irv50pn_aux+1 ! ti48(p,n)v48(p,n)cr48
         integer, parameter :: ircr48np_to_ti48 = irti48pn_to_cr48+1 ! cr48(n,p)v48(n,p)ti48 
         integer, parameter :: irti48pn_aux = ircr48np_to_ti48+1 ! ti48(p,n)v48
         integer, parameter :: irv48np_aux = irti48pn_aux+1 ! v48(n,p)ti48 
         integer, parameter :: ircr48np_aux = irv48np_aux+ 1 ! cr48(n,p)v48 
         integer, parameter :: irv48pn_aux = ircr48np_aux+ 1 ! v48(p,n)cr48 

         integer, parameter :: irti44an_to_cr48 = irv48pn_aux+1 ! ti44(a,n)cr47(n,g)cr48
         integer, parameter :: ircr48gn_to_ti44 = irti44an_to_cr48+1 ! cr48(g,n)cr47(n,a)ti44 
         integer, parameter :: irti44an_to_cr46 = ircr48gn_to_ti44+1 ! ti44(a,n)cr47(g,n)cr46
         integer, parameter :: ircr46ng_to_ti44 = irti44an_to_cr46+1 ! cr46(n,g)cr47(n,a)ti44
         integer, parameter :: irti44an_aux = ircr46ng_to_ti44+1 ! ti44(a,n)cr47 
         integer, parameter :: ircr47na_aux = irti44an_aux+1 ! cr47(n,a)ti44 

         integer, parameter :: num_predefined_reactions = ircr47na_aux
         integer :: rates_reaction_id_max
         
         
         ! some other reaction ids that are set if the reaction is loaded
         integer ::
     >      ir_s34_pg_cl35, ir_cl35_gp_s34,
     >      ir_ar38_pg_k39, ir_k39_gp_ar38,
     >      ir_si30_pg_p31, ir_p31_gp_si30,
     >      ir_si28_ng_si29, ir_si29_gn_si28,
     >      ir_s32_ng_s33, ir_s33_gn_s32,
     >      ir_cl35_pg_ar36,
     >      ir_ar36_ng_ar37, ir_ar37_gn_ar36,
     >      ir_cl37_pg_ar38, ir_ar38_gp_cl37,
     >      ir_s33_ng_s34, ir_s34_gn_s33,
     >      ir_si30_an_s33, ir_s33_na_si30,
     >      ir_s34_an_ar37, ir_ar37_na_s34,
     >      ir_si29_an_s32, ir_s32_na_si29,
     >      ir_s34_ap_cl37, ir_cl37_pa_s34,
     >      ir_cl37_pn_ar37, ir_ar37_np_cl37,
     >      ir_si29_ng_si30, ir_si30_gn_si29,
     >      ir_cl35_ng_cl36, ir_cl36_gn_cl35,
     >      ir_ar38_an_ca41, ir_ca41_na_ar38,
     >      ir_p31_ap_s34, ir_s34_pa_p31,
     
     >      ir_si29_ag_s33, ir_s33_ga_si29,
     >      ir_s33_ag_ar37, ir_ar37_ga_s33,
     >      ir_s33_an_ar36, ir_ar36_na_s33,
     >      ir_cl35_ap_ar38, ir_ar38_pa_cl35,
     >      ir_cl36_pa_s33, ir_s33_ap_cl36,
     >      ir_ar37_ng_ar38, ir_ar38_gn_ar37,
     >      ir_ar38_ap_k41, ir_k41_pa_ar38,
     >      ir_k39_ng_k40, ir_k40_gn_k39,         
     >      ir_k40_pg_ca41, ir_ca41_gp_k40,
     >      ir_ca40_ng_ca41, ir_ca41_gn_ca40,   
     >      ir_ca41_ng_ca42, ir_ca42_gn_ca41,
     >      ir_p31_ag_cl35, ir_cl35_ga_p31,
     >      ir_cl35_ag_k39, ir_k39_ga_cl35,
     >      ir_cl36_pg_ar37, ir_ar37_gp_cl36,
     >      ir_k39_ap_ca42, ir_ca42_pa_k39,
     >      ir_k40_pn_ca40, ir_ca40_np_k40,
     >      ir_k41_pg_ca42, ir_ca42_gp_k41,
     >      ir_ar37_an_ca40, ir_ca40_na_ar37,
     >      ir_k41_pn_ca41, ir_ca41_np_k41, 
     
     >      ir_fe54_ng_fe55, ir_fe55_gn_fe54,
     >      ir_fe55_ng_fe56, ir_fe56_gn_fe55,
     >      ir_fe54_pg_co55, ir_co55_gp_fe54,
     >      ir_fe55_pg_co56, ir_co56_gp_fe55,
     >      ir_cr50_pg_mn51, ir_mn51_gp_cr50,
     >      ir_ni58_pg_cu59, ir_cu59_gp_ni58,
     >      ir_co56_pg_ni57, ir_ni57_gp_co56,
     >      ir_cr50_ng_cr51, ir_cr51_gn_cr50,
     >      ir_ti46_pg_v47, ir_v47_gp_ti46,
     >      ir_ni59_pg_cu60, ir_cu60_gp_ni59,
     >      ir_co55_ng_co56, ir_co56_gn_co55,
     >      ir_ni58_ng_ni59, ir_ni59_gn_ni58,
     >      ir_co55_pg_ni56, ir_ni56_gp_co55,
     >      ir_fe55_pn_co55, ir_co55_np_fe55,
     >      ir_fe56_pn_co56, ir_co56_np_fe56,
     >      ir_cr51_pn_mn51, ir_mn51_np_cr51, 
     >      ir_co56_pn_ni56, ir_ni56_np_co56,
     >      ir_co58_np_fe58, ir_co59_gp_fe58,
     >      ir_co60_ng_co61, ir_co61_gn_co60,
     >      ir_fe56_ng_fe57, ir_fe57_gn_fe56,
     >      ir_fe57_ng_fe58, ir_fe58_gn_fe57,
     >      ir_fe58_ng_fe59, ir_fe58_pg_co59,
     >      ir_fe58_pn_co58, ir_fe59_gn_fe58,
     >      ir_fe59_ng_fe60, ir_fe60_gn_fe59,
     >      ir_ni60_ng_ni61, ir_ni61_gn_ni60,
     >      ir_ni61_ng_ni62, ir_ni62_gn_ni61,
     >      ir_fe60_pn_co60, ir_co60_np_fe60,
     >      ir_fe60_pg_co61, ir_co61_gp_fe60,
     >      ir_co60_pg_ni61, ir_ni61_gp_co60,
     >      ir_co61_pn_ni61, ir_ni61_np_co61,
     >      ir_co61_pg_ni62, ir_ni62_gp_co61,
     >      ir_fe60_ng_fe61, ir_fe61_gn_fe60,
     >      ir_fe61_ng_fe62, ir_fe62_gn_fe61,
     >      ir_ti50_ag_cr54, ir_cr54_ga_ti50,
     >      ir_ti52_ag_cr56, ir_cr56_ga_ti52,        
     >      ir_cr54_ag_fe58, ir_fe58_ga_cr54,      
     >      ir_cr56_ag_fe60, ir_fe60_ga_cr56,    
     >      ir_ca44_ag_ti48, ir_ti48_ga_ca44,
     >      ir_ca46_ag_ti50, ir_ti50_ga_ca46,
     >      ir_ca48_ag_ti52, ir_ti52_ga_ca48,
     >      ir_ti48_ag_cr52, ir_cr52_ga_ti48,
     >      ir_cr52_ag_fe56, ir_fe56_ga_cr52,

     >      ir_ni58_ag_zn62, ir_zn62_ga_ni58,                               
     >      ir_ni56_ag_zn60, ir_zn60_ga_ni56
                                     
      ! reactions information
         
         integer, parameter :: maxlen_reaction_Name = 32
         character (len=maxlen_reaction_Name), pointer :: reaction_Name(:) ! (rates_reaction_id_max)
   
         integer, parameter :: maxlen_reaction_Info = 72
         character (len=maxlen_reaction_Info), pointer :: reaction_Info(:) ! (rates_reaction_id_max)
         
         real(dp), pointer :: std_reaction_Qs(:) ! (rates_reaction_id_max) 
            ! set at initialization; read-only afterwards.
            ! avg energy including neutrinos
         
         real(dp), pointer :: std_reaction_neuQs(:) ! (rates_reaction_id_max) 
            ! set at initialization; read-only afterwards.
            ! avg neutrino loss
            
         integer, pointer :: reaction_screening_info(:,:) !(3,rates_reaction_id_max)
            ! reaction_screen_info(1:2,i) = [chem_id1, chem_id2] for screening.  0's if no screening.
            
         integer, pointer :: weak_reaction_info(:,:) ! (2,rates_reaction_id_max)
            ! weak_reaction_info(1:2,i) = [chem_id_in, chem_id_out].  0's if not a weak reaction.

         integer, pointer :: reaction_ye_rho_exponents(:,:) ! (2,rates_reaction_id_max)
            ! multiply T dependent rate by Ye^a(i) * Rho^b(i)
            ! reaction_ye_rho_coeffs(1,i) is a(i)
            ! reaction_ye_rho_coeffs(2,i) is b(i)
            ! (0,0) for photodisintegrations and decays
            ! (0,1) for standard 2 body reactions
            ! (0,2) for 3 body reactions such as triple alpha
            ! (1,1) for 2 body electron captures
            ! (1,2) for 3 body electron captures (e.g., pep)      
      
         integer, parameter :: max_num_reaction_inputs = 3
         integer, pointer :: reaction_inputs(:,:) ! (2*max_num_reaction_inputs,rates_reaction_id_max)
            ! up to max_num_reaction_inputs pairs of coefficients and chem id's, terminated by 0's.
            ! e.g.,  o16(p,g)f17 would be (/ 1, io16, 1, ih1, 0 /)
            ! triple alpha would be (/ 3, ihe4, 0 /)
            ! he3(he4, g)be7(e-,nu)li7(p,a)he4 would be (/ 1, ihe3, 1, ihe4, i, ih1, 0 /)

         integer, parameter :: max_num_reaction_outputs = 4
         integer, pointer :: reaction_outputs(:,:) ! (2*max_num_reaction_outputs,rates_reaction_id_max)
            ! up to max_num_reaction_outputs pairs of coefficients and chem id's, terminated by 0's.
            ! e.g.,  o16(p,g)f17 would be (/ 1, if17, 0 /)
            ! c12(a, p)n15 would be (/ 1, in15, 1, ih1, 0 /)
         

         integer, pointer,dimension(:) :: ! caches for get_reaclib_rate_and_dlnT (in raw_rates.f)
     >      reaction_is_reverse, reaction_reaclib_lo, reaction_reaclib_hi, reverse_reaction_id
            ! for all of these, 0 means "cache entry not yet set -- don't have the information"
            

      ! reaction categories

         
         integer, pointer :: reaction_categories(:) ! (rates_reaction_id_max) set by net using reactions.list info




      ! choices for various rates
         ! NOTE: if change these, must edit raw_rates to match.
         
         ! NACRE = Angulo et al. 1999 Nucl. Phys. A, 656, 3
         ! JR = jina reaclib -- file mesa/data/jina_data/results05301331 -- (Sakharuk et al. 2006)
         ! CF88 = Frank Timmes' version of 
            ! Caughlin, G. R. & Fowler, W. A. 1988, Atom. Data and Nuc. Data Tables, 40, 283
         
         
         ! when possible, NACRE is 1, jina reaclib is 2
         integer, parameter :: rates_NACRE_if_available = 1
         integer, parameter :: rates_JR_if_available = 2
         
         ! the jina reaclib rates are not valid below T = 10^7.
         ! if we have the option, we automatically blend over to nacre for low temperatures.
         ! the following values determine the blend region.
         real(dp) :: JR_T_full_off = 1.0d7 ! don't use JR below this
         real(dp) :: JR_T_full_on = 1.1d7 ! don't need to blend above this
         
         
      
         ! p(p,e+nu)h2
         integer, parameter :: use_rate_pp_NACRE = 1
         integer, parameter :: use_rate_pp_JR = 2 ! cf88
         integer, parameter :: use_rate_pp_CF88 = 3
         
         ! h2(p,g)he3 
         integer, parameter :: use_rate_dpg_NACRE = 1
         integer, parameter :: use_rate_dpg_JR = 2 ! Descouvemont et al (2004)
         integer, parameter :: use_rate_dpg_CF88 = 3
         
         ! he3(he3, 2p)he4
         integer, parameter :: use_rate_he3he3_NACRE = 1
         integer, parameter :: use_rate_he3he3_JR = 2 ! cf88
         integer, parameter :: use_rate_he3he3_CF88 = 3
         
         ! he4(he3,g)be7
         integer, parameter :: use_rate_he3he4_NACRE = 1
         integer, parameter :: use_rate_he3he4_JR = 2 ! Descouvemont et al (2004)
         integer, parameter :: use_rate_he3he4_CF88 = 3
         
         ! triple alpha
         integer, parameter :: use_rate_3a_NACRE = 1
         integer, parameter :: use_rate_3a_JR = 2 ! Fynbo et al. 2005 Nature 433, 136-139
         integer, parameter :: use_rate_3a_CF88 = 3
         integer, parameter :: use_rate_3a_FL87 = 4 ! Fushiki and Lamb, Apj, 317, 368-388, 1987
            ! note: use_rate_3a_FL87 is a special case. see eval_FL_epsnuc_3alf in rate_lib
      
         ! be7(p,g)b8
         integer, parameter :: use_rate_be7pg_NACRE = 1
         integer, parameter :: use_rate_be7pg_JR = 2 ! cf88
         integer, parameter :: use_rate_be7pg_CF88 = 3
         
         ! li7(p,a)he4
         integer, parameter :: use_rate_li7pa_NACRE = 1
         integer, parameter :: use_rate_li7pa_JR = 2 ! Descouvemont et al (2004)
         integer, parameter :: use_rate_li7pa_CF88 = 3
         
         ! c12(p,g)n13
         integer, parameter :: use_rate_c12pg_NACRE = 1
         integer, parameter :: use_rate_c12pg_JR = 2 ! nacre
         integer, parameter :: use_rate_c12pg_CF88 = 3
         
         ! c12(a,g)o16
         integer, parameter :: use_rate_c12ag_NACRE = 1
         integer, parameter :: use_rate_c12ag_JR = 2 ! Buchmann (1996)
         integer, parameter :: use_rate_c12ag_Kunz = 3 ! Kunz et al. (2002)
         integer, parameter :: use_rate_c12ag_CF88 = 4
         
         ! c13(p,g)n14
         integer, parameter :: use_rate_c13pg_NACRE = 1
         integer, parameter :: use_rate_c13pg_JR = 2 ! nacre
         
         ! c12 + c12
         integer, parameter :: use_rate_1212_CF88_multi = 1
            ! combines the rates for the n, p, and a channels.
            ! using neutron branching from dayras switkowski and woosley 1976
            ! and an estimate of proton branching.
         integer, parameter :: use_rate_1212_CF88_basic = 2
            ! the single rate approximation from CF88
         integer, parameter :: use_rate_1212_G05 = 3 ! Gasques, et al. Phys Review C, 72, 025806 (2005)
            ! NOTE: Gasques option for c12+c12 is implemented in net, not in rates.
         
         ! n13(p,g)o14
         integer, parameter :: use_rate_n13pg_NACRE = 1
         integer, parameter :: use_rate_n13pg_JR = 2 ! Li et al. (2006)
      
         ! n14(p,g)o15
         integer, parameter :: use_rate_n14pg_NACRE = 1
         integer, parameter :: use_rate_n14pg_JR = 2 ! Imbriani et al. (2004)
         integer, parameter :: use_rate_n14pg_CF88 = 3
         
         ! n14(a,g)f18
         integer, parameter :: use_rate_n14ag_NACRE = 1
         integer, parameter :: use_rate_n14ag_JR = 2 ! Gorres, Arlandini, Giesen (2000)
         integer, parameter :: use_rate_n14ag_CF88 = 3
         
         ! n15(p,g)o16
         integer, parameter :: use_rate_n15pg_NACRE = 1
         integer, parameter :: use_rate_n15pg_JR = 2 ! nacre
         
         ! n15(p,a)c12
         integer, parameter :: use_rate_n15pa_NACRE = 1
         integer, parameter :: use_rate_n15pa_JR = 2 ! nacre
         integer, parameter :: use_rate_n15pa_CF88 = 3
         
         ! o14(a,p)f17
         integer, parameter :: use_rate_o14ap_CF88 = 1
         integer, parameter :: use_rate_o14ap_JR = 2 ! Hahn 1996    PhRvC 54, 4, p1999-2013
         
         ! o15(a,g)ne19
         integer, parameter :: use_rate_o15ag_CF88 = 1
         integer, parameter :: use_rate_o15ag_JR = 2 ! Hahn 1996    PhRvC 54, 4, p1999-2013
         
         ! o16(p,g)f17
         integer, parameter :: use_rate_o16pg_NACRE = 1
         integer, parameter :: use_rate_o16pg_JR = 2 ! nacre
         integer, parameter :: use_rate_o16pg_CF88 = 3
         
         ! o16(a,g)ne20
         integer, parameter :: use_rate_o16ag_NACRE = 1
         integer, parameter :: use_rate_o16ag_JR = 2 ! nacre
         integer, parameter :: use_rate_o16ag_CF88 = 3
         
         ! o17(p,a)n14
         integer, parameter :: use_rate_o17pa_NACRE = 1
         integer, parameter :: use_rate_o17pa_JR = 2 ! Chafa et al. (2007)
      
         ! o17(p,g)f18
         integer, parameter :: use_rate_o17pg_NACRE = 1
         integer, parameter :: use_rate_o17pg_JR = 2 ! Chafa et al. (2007)
         
         ! o18(p,a)n15
         integer, parameter :: use_rate_o18pa_NACRE = 1
         integer, parameter :: use_rate_o18pa_JR = 2 ! nacre
         
         ! o18(p,g)f19
         integer, parameter :: use_rate_o18pg_NACRE = 1
         integer, parameter :: use_rate_o18pg_JR = 2 ! nacre
         
         ! o18(a,g)ne22
         integer, parameter :: use_rate_o18ag_NACRE = 1
         integer, parameter :: use_rate_o18ag_JR = 2  ! Dababneh (2003)
               
         ! f17(p,g)ne18
         integer, parameter :: use_rate_f17pg_wk82 = 1 ! wiescher and kettner, ap. j., 263, 891 (1982)
         integer, parameter :: use_rate_f17pg_JR = 2 ! Bardayan et al. (2000)
      
         ! f18(p,g)ne19
         integer, parameter :: use_rate_f18pg_wk82 = 1 ! wiescher and kettner, ap. j., 263, 891 (1982)
         integer, parameter :: use_rate_f18pg_JR = 2 ! Shu (2003)
      
         ! f18(p,a)o15
         integer, parameter :: use_rate_f18pa_wk82 = 1 ! wiescher and kettner, ap. j., 263, 891 (1982)
         integer, parameter :: use_rate_f18pa_JR = 2 ! Shu (2003)
         
         ! f19(p,g)ne20
         integer, parameter :: use_rate_f19pg_NACRE = 1
         integer, parameter :: use_rate_f19pg_JR = 2 ! cf88
         
         ! f19(p,a)o16
         integer, parameter :: use_rate_f19pa_NACRE = 1
         integer, parameter :: use_rate_f19pa_JR = 2 ! cf88
         
         ! ne20(a,g)mg24
         integer, parameter :: use_rate_ne20ag_NACRE = 1
         integer, parameter :: use_rate_ne20ag_JR = 2
         integer, parameter :: use_rate_ne20ag_CF88 = 3
         
         ! o16 + o16
         integer, parameter :: use_rate_1616_CF88 = 1
         integer, parameter :: use_rate_1616_reaclib = 2

      
      ! for mazurek's ni56 electron capture rate interpolation
         real(dp) :: tv(7),rv(6),rfdm(4),rfd0(4),rfd1(4),rfd2(4),tfdm(5),tfd0(5),tfd1(5),tfd2(5)


      type T_Factors
         real(dp) :: lnT9
         real(dp) :: T9
         real(dp) :: T92
         real(dp) :: T93
         real(dp) :: T94
         real(dp) :: T95
         real(dp) :: T96
         real(dp) :: T912
         real(dp) :: T932
         real(dp) :: T952
         real(dp) :: T972
         real(dp) :: T913
         real(dp) :: T923
         real(dp) :: T943
         real(dp) :: T953
         real(dp) :: T973
         real(dp) :: T9113
         real(dp) :: T914
         real(dp) :: T934
         real(dp) :: T954
         real(dp) :: T974
         real(dp) :: T915
         real(dp) :: T935
         real(dp) :: T945
         real(dp) :: T965
         real(dp) :: T917
         real(dp) :: T927
         real(dp) :: T947
         real(dp) :: T918
         real(dp) :: T938
         real(dp) :: T958
         real(dp) :: T9i
         real(dp) :: T9i2
         real(dp) :: T9i3
         real(dp) :: T9i12
         real(dp) :: T9i32
         real(dp) :: T9i52
         real(dp) :: T9i72
         real(dp) :: T9i13
         real(dp) :: T9i23
         real(dp) :: T9i43
         real(dp) :: T9i53
         real(dp) :: T9i14
         real(dp) :: T9i34
         real(dp) :: T9i54
         real(dp) :: T9i15
         real(dp) :: T9i35
         real(dp) :: T9i45
         real(dp) :: T9i65
         real(dp) :: T9i17
         real(dp) :: T9i27
         real(dp) :: T9i47
         real(dp) :: T9i18
         real(dp) :: T9i38
         real(dp) :: T9i58
         real(dp) :: T916
         real(dp) :: T976
         real(dp) :: T9i76
      end type T_Factors
      

      ! info for rates being evaluated using tables (rate_list.txt)
      type rate_table_info
         logical :: use_rate_table
         logical :: need_to_read
         character (len=132) :: rate_fname
         integer :: nT8s
         real(dp), pointer :: T8s(:) ! (nT8s)
         real(dp), pointer :: f1(:) ! =(4,nT8s)
      end type rate_table_info
      
      type (rate_table_info), pointer :: raw_rates_records(:)
      character (len=164) :: rates_table_dir

      type (integer_dict), pointer :: reaction_names_dict
      type (integer_dict), pointer :: skip_warnings_dict
   	
      type (reaction_data), target :: reaclib_rates


      ! rate results components
      
      integer, parameter :: i_rate = 1        
      integer, parameter :: i_rate_dT = 2  
      integer, parameter :: i_rate_dRho = 3 
      integer, parameter :: num_rvs = 3
      
      
      ! for tabular evaluation of the raw reaction rates
      real(dp) :: rattab_thi != 10.301029995664d0 ! log10(highest temp = 2e10)
      real(dp) :: rattab_tlo != 5.30102999566398d0 ! log10(lowest temp = 2e5)
      
      integer :: rattab_points_per_decade = 2000
      integer :: nrattab ! number of reaction rate table temperatures
         ! nrattab = <points per decade>*(rattab_thi - rattab_tlo) + 1
               
      real(dp) :: rattab_tstp != (rattab_thi-rattab_tlo)/(nrattab-1)! step size
         
      character (len=1000) :: rates_dir, rates_cache_dir


      
      contains


      subroutine start_rates_def_init(rates_cache_dir_in)
         use utils_lib, only: integer_dict_define
         use const_def, only: mesa_data_dir
         character (len=*), intent(in) :: rates_cache_dir_in
         integer :: i, ierr         
         rates_dir = trim(mesa_data_dir) // '/rates_data'
         if (len_trim(rates_cache_dir_in) > 0) then
            rates_cache_dir = rates_cache_dir_in
         else
            rates_cache_dir = trim(rates_dir) // '/cache'
         end if
         ierr = 0
         nullify(reaction_names_dict)
         do i=1,rates_reaction_id_max
            call integer_dict_define(reaction_names_dict, reaction_Name(i), i, ierr)
            if (ierr /= 0) then
               write(*,*) 'FATAL ERROR: rates_def_init failed in integer_dict_define'
               return
            end if
         end do
         call create_skip_warnings_dict(ierr)  
         call set_rattab_range(5.30102999566398d0, 10.301029995664d0)
      end subroutine start_rates_def_init
      
      
      subroutine set_rattab_range(tlo, thi)
         real(dp), intent(in) :: tlo, thi
         if (abs(thi - tlo) < 1d-6) then
            rattab_tlo = tlo
            rattab_thi = rattab_tlo
            nrattab = 1
            rattab_tstp = 0
            return
         end if
         rattab_thi = thi
         rattab_tlo = tlo
         nrattab = rattab_points_per_decade*(rattab_thi - rattab_tlo) + 1
         if (nrattab <= 1) then
            rattab_thi = rattab_tlo
            nrattab = 1
            rattab_tstp = 0
         else
            rattab_tstp = (rattab_thi-rattab_tlo)/(nrattab-1)
         end if
      end subroutine set_rattab_range
      
      
      subroutine create_skip_warnings_dict(ierr)
         use utils_lib
         use utils_def
         integer, intent(out) :: ierr
         
         integer :: iounit, n, i, t, id, read_int
         character (len=256) :: buffer, string, filename, list_filename
         
         ierr = 0
         iounit = alloc_iounit(ierr)
         if (ierr /= 0) return
         
         nullify(skip_warnings_dict)

         list_filename = 'skip_warnings.list'
         ! first try the local directory
         filename = trim(list_filename)
         open(unit=iounit, file=trim(filename), action='read', status='old', iostat=ierr)
         if (ierr /= 0) then ! if don't find that file, look in rates_data
            filename = trim(rates_dir) // '/' // trim(list_filename)
            ierr = 0
            open(unit=iounit, file=trim(filename), action='read', status='old', iostat=ierr)
            if (ierr /= 0) then
               call free_iounit(iounit)
               write(*,*) 'failed to open file ' // trim(list_filename)
               return
            end if
         end if
         
         n = 0
         i = 0
         
      reaction_loop: do
            t = token(iounit, n, i, buffer, string)
            if (t == eof_token) exit
            if (t /= name_token) then
               call error; return
            end if
            call integer_dict_define(skip_warnings_dict, string, 1, ierr)
            if (ierr /= 0) then
               write(*,*) 'FATAL ERROR: create_skip_warnings_dict failed in integer_dict_define'
               return
            end if
         end do reaction_loop
         
         close(iounit)
         call free_iounit(iounit)

         call integer_dict_create_hash(skip_warnings_dict, ierr)
         if (ierr /= 0) then
            write(*,*) 'FATAL ERROR: create_skip_warnings_dict failed'
            return
         end if

         contains
         
         subroutine error
            ierr = -1
            close(iounit)
            call free_iounit(iounit)
         end subroutine error

      end subroutine create_skip_warnings_dict
		
		
		integer function get_num_reaction_inputs(ir)
		   integer, intent(in) :: ir
		   integer :: j
		   include 'formats.dek'
		   if (max_num_reaction_inputs == 3) then
            if (reaction_inputs(5,ir) /= 0) then
               get_num_reaction_inputs = 3
            else if (reaction_inputs(3,ir) /= 0) then
               get_num_reaction_inputs = 2
            else if (reaction_inputs(1,ir) /= 0) then
               get_num_reaction_inputs = 1
            else 
               get_num_reaction_inputs = 0
            end if
            return
		   end if
         get_num_reaction_inputs = max_num_reaction_inputs
         do j = 1, 2*max_num_reaction_inputs-1, 2
            if (reaction_inputs(j,ir) == 0) then
               get_num_reaction_inputs = (j-1)/2
               exit
            end if
         end do
		end function get_num_reaction_inputs
		
		
		integer function get_num_reaction_outputs(ir)
		   integer, intent(in) :: ir
		   integer :: j
		   if (max_num_reaction_outputs == 3) then
            if (reaction_outputs(5,ir) /= 0) then
               get_num_reaction_outputs = 3
            else if (reaction_outputs(3,ir) /= 0) then
               get_num_reaction_outputs = 2
            else if (reaction_outputs(1,ir) /= 0) then
               get_num_reaction_outputs = 1
            else 
               get_num_reaction_outputs = 0
            end if
            return
		   end if
         get_num_reaction_outputs = max_num_reaction_outputs
         do j = 1, 2*max_num_reaction_outputs-1, 2
            if (reaction_outputs(j,ir) == 0) then
               get_num_reaction_outputs = (j-1)/2
               exit
            end if
         end do
		end function get_num_reaction_outputs
      
      
      integer function reaclib_index(handle) result(indx)
      	use utils_lib, only: integer_dict_lookup
      	character(len=*), intent(in) :: handle ! as in rates% reaction_handle
         integer :: ierr
         ierr = 0
      	call integer_dict_lookup(reaclib_rates% reaction_dict, handle, indx, ierr)
      	if (ierr /= 0) indx = 0
      end function reaclib_index
      
      
      integer function reaclib_reverse(handle) result(indx)
      	use utils_lib, only: integer_dict_lookup
      	character(len=*), intent(in) :: handle ! as in rates% reaction_handle
         integer :: ierr
         ierr = 0
      	call integer_dict_lookup(reaclib_rates% reverse_dict, handle, indx, ierr)
      	if (ierr /= 0) indx = 0
      end function reaclib_reverse
      
      
		integer function get_rates_reaction_id(reaction_name) result(value)
		   use utils_lib, only: integer_dict_lookup
		   use reaclib_lib, only: reaclib_lookup
			character (len=*), intent(in)  :: reaction_name 
			integer :: ierr
			integer :: indx
			ierr = 0
			call integer_dict_lookup(reaction_names_dict, reaction_name, value, ierr)
			if (ierr /= 0) value = 0
		end function get_rates_reaction_id


      end module rates_def

