! ***********************************************************************
!
!   Copyright (C) 2010  Bill Paxton
!
!   MESA is free software; you can use it and/or modify
!   it under the combined terms and restrictions of the MESA MANIFESTO
!   and the GNU General Library Public License as published
!   by the Free Software Foundation; either version 2 of the License,
!   or (at your option) any later version.
!
!   You should have received a copy of the MESA MANIFESTO along with
!   this software; if not, it is available at the mesa website:
!   http://mesa.sourceforge.net/
!
!   MESA is distributed in the hope that it will be useful,
!   but WITHOUT ANY WARRANTY; without even the implied warranty of
!   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
!   See the GNU Library General Public License for more details.
!
!   You should have received a copy of the GNU Library General Public License
!   along with this software; if not, write to the Free Software
!   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
!
! ***********************************************************************

      module rates_names
      
      implicit none
      
      
      contains
      
      
      subroutine set_reaction_names
         use rates_def
         integer :: i, cnt
         
         cnt = 0
         reaction_Name(:) = ''
      
         reaction_Name(ir_h1_h1_wk_h2) = 'r_h1_h1_wk_h2'
         reaction_Name(irpp_to_he3) = 'rpp_to_he3'
         reaction_Name(ir_h1_h1_ec_h2) = 'r_h1_h1_ec_h2'
         reaction_Name(irpep_to_he3) = 'rpep_to_he3'
         reaction_Name(ir_h2_h2_to_he4) = 'r_h2_h2_to_he4'
         reaction_Name(ir_h1_he3_wk_he4) = 'r_h1_he3_wk_he4'
         reaction_Name(ir_h2_he3_to_h1_he4) = 'r_h2_he3_to_h1_he4'
         reaction_Name(ir_he3_he3_to_h1_h1_he4) = 'r_he3_he3_to_h1_h1_he4'
         reaction_Name(ir_h1_h1_he4_to_he3_he3) = 'r_h1_h1_he4_to_he3_he3'
         reaction_Name(ir_he3_ag_be7) = 'r_he3_ag_be7'
         reaction_Name(ir34_pp2) = 'r34_pp2'
         reaction_Name(ir34_pp3) = 'r34_pp3'
         reaction_Name(ir_he4_he4_he4_to_c12) = 'r_he4_he4_he4_to_c12'
         reaction_Name(ir_c12_to_he4_he4_he4) = 'r_c12_to_he4_he4_he4'
         reaction_Name(ir_li7_pa_he4) = 'r_li7_pa_he4'
         reaction_Name(ir_be7_ec_li7) = 'r_be7_ec_li7'
         reaction_Name(irbe7ec_li7_aux) = 'rbe7ec_li7_aux'
         reaction_Name(ir_h2_be7_to_h1_he4_he4) = 'r_h2_be7_to_h1_he4_he4'
         reaction_Name(ir_he3_be7_to_h1_h1_he4_he4) = 'r_he3_be7_to_h1_h1_he4_he4'
         reaction_Name(irbe7pg_b8_aux) = 'rbe7pg_b8_aux'
         reaction_Name(ir_b8_wk_he4_he4) = 'r_b8_wk_he4_he4'
         reaction_Name(ir_b8_gp_be7) = 'r_b8_gp_be7'
         reaction_Name(irc12_to_c13) = 'rc12_to_c13'
         reaction_Name(irc12_to_n14) = 'rc12_to_n14'
         reaction_Name(ir_c12_ap_n15) = 'r_c12_ap_n15'
         reaction_Name(irc12ap_to_o16) = 'rc12ap_to_o16'
         reaction_Name(irc12ng_to_o16) = 'rc12ng_to_o16'
         reaction_Name(ir_c12_ag_o16) = 'r_c12_ag_o16'
         reaction_Name(ir1212a) = 'r1212a'
         reaction_Name(ir1212p) = 'r1212p'
         reaction_Name(ir1212) = 'r1212'
         reaction_Name(ir1216_to_mg24) = 'r1216_to_mg24'
         reaction_Name(ir1216_to_si28) = 'r1216_to_si28'
         reaction_Name(irc12ap_aux) = 'rc12ap_aux'
         reaction_Name(ir_c13_an_o16) = 'r_c13_an_o16'
         reaction_Name(ir_n13_ap_o16) = 'r_n13_ap_o16'
         reaction_Name(ir_n13_gp_c12) = 'r_n13_gp_c12'
         reaction_Name(irn14pg_aux) = 'rn14pg_aux'
         reaction_Name(irn14_to_n15) = 'rn14_to_n15'
         reaction_Name(irn14_to_o16) = 'rn14_to_o16'
         reaction_Name(irn14_to_c12) = 'rn14_to_c12'
         reaction_Name(ir_n14_ap_o17) = 'r_n14_ap_o17'
         reaction_Name(irn14ecap) = 'rn14ecap'
         reaction_Name(ir_n14_ag_f18) = 'r_n14_ag_f18'
         reaction_Name(irn14ag_to_o18) = 'rn14ag_to_o18'
         reaction_Name(irn14ag_to_ne20_2n) = 'rn14ag_to_ne20_2n'
         reaction_Name(irn14ag_to_ne22) = 'rn14ag_to_ne22'
         reaction_Name(irn14ag_lite) = 'rn14ag_lite'
         reaction_Name(ir_n14_gp_c13) = 'r_n14_gp_c13'
         reaction_Name(irn15pg_aux) = 'rn15pg_aux'
         reaction_Name(ir_n15_pa_c12) = 'r_n15_pa_c12'
         reaction_Name(irn15pa_aux) = 'rn15pa_aux'
         reaction_Name(ir_n15_ap_o18) = 'r_n15_ap_o18'
         reaction_Name(ir_o14_ag_ne18) = 'r_o14_ag_ne18'
         reaction_Name(ir_o14_ap_f17) = 'r_o14_ap_f17'
         reaction_Name(ir_o14_gp_n13) = 'r_o14_gp_n13'
         reaction_Name(ir_o15_ap_f18) = 'r_o15_ap_f18'
         reaction_Name(ir_o15_ag_ne19) = 'r_o15_ag_ne19'
         reaction_Name(ir_o15_gp_n14) = 'r_o15_gp_n14'
         reaction_Name(iro16_to_o17) = 'ro16_to_o17'
         reaction_Name(iro16_to_n14) = 'ro16_to_n14'
         reaction_Name(ir_o16_ap_f19) = 'r_o16_ap_f19'
         reaction_Name(iro16ap_aux) = 'ro16ap_aux'
         reaction_Name(iro16ap_to_ne20) = 'ro16ap_to_ne20'
         reaction_Name(ir_o16_ag_ne20) = 'r_o16_ag_ne20'
         reaction_Name(ir_o16_gp_n15) = 'r_o16_gp_n15'
         reaction_Name(iro16gp_aux) = 'ro16gp_aux'
         reaction_Name(iro16gp_to_c12) = 'ro16gp_to_c12'
         reaction_Name(ir_o16_ga_c12) = 'r_o16_ga_c12'
         reaction_Name(iro16ng_to_mg24) = 'ro16ng_to_mg24'
         reaction_Name(ir1616) = 'r1616'
         reaction_Name(ir1616a) = 'r1616a'
         reaction_Name(ir1616ppa) = 'r1616ppa'
         reaction_Name(ir1616ppg) = 'r1616ppg'
         reaction_Name(ir1616p) = 'r1616p'
         reaction_Name(ir1616p_aux) = 'r1616p_aux'
         reaction_Name(ir1616g) = 'r1616g'
         reaction_Name(ir_o17_pa_n14) = 'r_o17_pa_n14'
         reaction_Name(ir_o17_ag_ne21) = 'r_o17_ag_ne21'
         reaction_Name(iro17_to_o18) = 'ro17_to_o18'
         reaction_Name(ir_o18_pa_n15) = 'r_o18_pa_n15'
         reaction_Name(ir_o18_ag_ne22) = 'r_o18_ag_ne22'
         reaction_Name(ir_f17_pa_o14) = 'r_f17_pa_o14'
         reaction_Name(ir_f17_ap_ne20) = 'r_f17_ap_ne20'
         reaction_Name(ir_f17_gp_o16) = 'r_f17_gp_o16'
         reaction_Name(ir_f18_ap_ne21) = 'r_f18_ap_ne21'
         reaction_Name(ir_f18_pa_o15) = 'r_f18_pa_o15'
         reaction_Name(ir_f18_gp_o17) = 'r_f18_gp_o17'
         reaction_Name(irf19pg_aux) = 'rf19pg_aux'
         reaction_Name(ir_f19_pa_o16) = 'r_f19_pa_o16'
         reaction_Name(irf19pa_aux) = 'rf19pa_aux'
         reaction_Name(ir_f19_ap_ne22) = 'r_f19_ap_ne22'
         reaction_Name(ir_f19_gp_o18) = 'r_f19_gp_o18'
         reaction_Name(irne18ap_to_mg22) = 'rne18ap_to_mg22'
         reaction_Name(irne18ap_to_mg24) = 'rne18ap_to_mg24'
         reaction_Name(irne18ag_to_mg24) = 'rne18ag_to_mg24'
         reaction_Name(irne19pg_to_mg21) = 'rne19pg_to_mg21'
         reaction_Name(irne19pg_to_mg22) = 'rne19pg_to_mg22'
         reaction_Name(irne19pg_to_mg24) = 'rne19pg_to_mg24'
         reaction_Name(ir_ne19_ga_o15) = 'r_ne19_ga_o15'
         reaction_Name(irne20pg_to_mg22) = 'rne20pg_to_mg22'
         reaction_Name(irne20pg_to_mg24) = 'rne20pg_to_mg24'
         reaction_Name(ir_ne20_ag_mg24) = 'r_ne20_ag_mg24'
         reaction_Name(ir_ne20_ga_o16) = 'r_ne20_ga_o16'
         reaction_Name(ir_ne20_gp_f19) = 'r_ne20_gp_f19'
         reaction_Name(irne20gp_aux) = 'rne20gp_aux'
         reaction_Name(irne20gp_to_o16) = 'rne20gp_to_o16'
         reaction_Name(ir_ne20_ap_na23) = 'r_ne20_ap_na23'
         reaction_Name(irne20ap_aux) = 'rne20ap_aux'
         reaction_Name(irne20ap_to_mg24) = 'rne20ap_to_mg24'
         reaction_Name(irne20ng_to_mg24) = 'rne20ng_to_mg24'
         reaction_Name(ir_ne22_ag_mg26) = 'r_ne22_ag_mg26'
         reaction_Name(ir_ne22_ga_o18) = 'r_ne22_ga_o18'
         reaction_Name(irne22ag_fake) = 'rne22ag_fake'
         reaction_Name(irne22ga_fake) = 'rne22ga_fake'
         reaction_Name(ir_na23_gp_ne22) = 'r_na23_gp_ne22'
         reaction_Name(ir_na23_ap_mg26) = 'r_na23_ap_mg26'
         reaction_Name(irna23ap_aux) = 'rna23ap_aux'
         reaction_Name(ir_na23_pa_ne20) = 'r_na23_pa_ne20'
         reaction_Name(irna23pa_aux) = 'rna23pa_aux'
         reaction_Name(irna23pg_aux) = 'rna23pg_aux'
         reaction_Name(ir_mg24_ap_al27) = 'r_mg24_ap_al27'
         reaction_Name(irmg24ap_aux) = 'rmg24ap_aux'
         reaction_Name(irmg24ap_to_si28) = 'rmg24ap_to_si28'
         reaction_Name(ir_mg24_ag_si28) = 'r_mg24_ag_si28'
         reaction_Name(ir_mg24_ga_ne20) = 'r_mg24_ga_ne20'
         reaction_Name(ir_mg24_gp_na23) = 'r_mg24_gp_na23'
         reaction_Name(irmg24gp_aux) = 'rmg24gp_aux'
         reaction_Name(irmg24gp_to_ne20) = 'rmg24gp_to_ne20'
         reaction_Name(ir_mg26_ag_si30) = 'r_mg26_ag_si30'
         reaction_Name(iral27pg_aux) = 'ral27pg_aux'
         reaction_Name(ir_al27_gp_mg26) = 'r_al27_gp_mg26'
         reaction_Name(ir_al27_pa_mg24) = 'r_al27_pa_mg24'
         reaction_Name(iral27pa_aux) = 'ral27pa_aux'
         reaction_Name(ir_al27_ap_si30) = 'r_al27_ap_si30'
         reaction_Name(ir_si28_ap_p31) = 'r_si28_ap_p31'
         reaction_Name(irsi28ap_aux) = 'rsi28ap_aux'
         reaction_Name(irsi28ap_to_s32) = 'rsi28ap_to_s32'
         reaction_Name(ir_si28_ag_s32) = 'r_si28_ag_s32'
         reaction_Name(ir_si28_gp_al27) = 'r_si28_gp_al27'
         reaction_Name(irsi28gp_aux) = 'rsi28gp_aux'
         reaction_Name(ir_si28_ga_mg24) = 'r_si28_ga_mg24'
         reaction_Name(irsi28gp_to_mg24) = 'rsi28gp_to_mg24'
         reaction_Name(ir_si30_ga_mg26) = 'r_si30_ga_mg26'
         reaction_Name(ir_p31_pg_s32) = 'r_p31_pg_s32'
         reaction_Name(irp31pg_aux) = 'rp31pg_aux'
         reaction_Name(ir_p31_pa_si28) = 'r_p31_pa_si28'
         reaction_Name(irp31pa_aux) = 'rp31pa_aux'
         reaction_Name(ir_s32_ap_cl35) = 'r_s32_ap_cl35'
         reaction_Name(irs32ap_aux) = 'rs32ap_aux'
         reaction_Name(irs32ap_to_ar36) = 'rs32ap_to_ar36'
         reaction_Name(ir_s32_ag_ar36) = 'r_s32_ag_ar36'
         reaction_Name(ir_s32_gp_p31) = 'r_s32_gp_p31'
         reaction_Name(irs32gp_aux) = 'rs32gp_aux'
         reaction_Name(ir_s32_ga_si28) = 'r_s32_ga_si28'
         reaction_Name(irs32gp_to_si28) = 'rs32gp_to_si28'
         reaction_Name(ircl35pg_aux) = 'rcl35pg_aux'
         reaction_Name(ir_cl35_pa_s32) = 'r_cl35_pa_s32'
         reaction_Name(ircl35pa_aux) = 'rcl35pa_aux'
         reaction_Name(ir_ar36_ap_k39) = 'r_ar36_ap_k39'
         reaction_Name(irar36ap_aux) = 'rar36ap_aux'
         reaction_Name(irar36ap_to_ca40) = 'rar36ap_to_ca40'
         reaction_Name(ir_ar36_ag_ca40) = 'r_ar36_ag_ca40'
         reaction_Name(ir_ar36_gp_cl35) = 'r_ar36_gp_cl35'
         reaction_Name(irar36gp_aux) = 'rar36gp_aux'
         reaction_Name(ir_ar36_ga_s32) = 'r_ar36_ga_s32'
         reaction_Name(irar36gp_to_s32) = 'rar36gp_to_s32'
         reaction_Name(irk39pg_aux) = 'rk39pg_aux'
         reaction_Name(ir_k39_pa_ar36) = 'r_k39_pa_ar36'
         reaction_Name(irk39pa_aux) = 'rk39pa_aux'
         reaction_Name(ir_ca40_ap_sc43) = 'r_ca40_ap_sc43'
         reaction_Name(irca40ap_aux) = 'rca40ap_aux'
         reaction_Name(irca40ap_to_ti44) = 'rca40ap_to_ti44'
         reaction_Name(ir_ca40_ag_ti44) = 'r_ca40_ag_ti44'
         reaction_Name(ir_ca40_gp_k39) = 'r_ca40_gp_k39'
         reaction_Name(irca40gp_aux) = 'rca40gp_aux'
         reaction_Name(ir_ca40_ga_ar36) = 'r_ca40_ga_ar36'
         reaction_Name(irca40gp_to_ar36) = 'rca40gp_to_ar36'
         reaction_Name(irsc43pg_aux) = 'rsc43pg_aux'
         reaction_Name(ir_sc43_pa_ca40) = 'r_sc43_pa_ca40'
         reaction_Name(irsc43pa_aux) = 'rsc43pa_aux'
         reaction_Name(ir_ti44_ap_v47) = 'r_ti44_ap_v47'
         reaction_Name(irti44ap_aux) = 'rti44ap_aux'
         reaction_Name(irti44ap_to_cr48) = 'rti44ap_to_cr48'
         reaction_Name(ir_ti44_ag_cr48) = 'r_ti44_ag_cr48'
         reaction_Name(ir_ti44_gp_sc43) = 'r_ti44_gp_sc43'
         reaction_Name(irti44gp_aux) = 'rti44gp_aux'
         reaction_Name(ir_ti44_ga_ca40) = 'r_ti44_ga_ca40'
         reaction_Name(irti44gp_to_ca40) = 'rti44gp_to_ca40'
         reaction_Name(irv47pg_aux) = 'rv47pg_aux'
         reaction_Name(ir_v47_pa_ti44) = 'r_v47_pa_ti44'
         reaction_Name(irv47pa_aux) = 'rv47pa_aux'
         reaction_Name(ir_cr48_ap_mn51) = 'r_cr48_ap_mn51'
         reaction_Name(ircr48ap_aux) = 'rcr48ap_aux'
         reaction_Name(ircr48ap_to_fe52) = 'rcr48ap_to_fe52'
         reaction_Name(ir_cr48_ag_fe52) = 'r_cr48_ag_fe52'
         reaction_Name(ir_cr48_gp_v47) = 'r_cr48_gp_v47'
         reaction_Name(ircr48gp_aux) = 'rcr48gp_aux'
         reaction_Name(ir_cr48_ga_ti44) = 'r_cr48_ga_ti44'
         reaction_Name(ircr48gp_to_ti44) = 'rcr48gp_to_ti44'
         reaction_Name(irmn51pg_aux) = 'rmn51pg_aux'
         reaction_Name(ir_mn51_pa_cr48) = 'r_mn51_pa_cr48'
         reaction_Name(irmn51pa_aux) = 'rmn51pa_aux'
         reaction_Name(irfe52aprot) = 'rfe52aprot'
         reaction_Name(irfe52ap_aux) = 'rfe52ap_aux'
         reaction_Name(irfe52ap_to_ni56) = 'rfe52ap_to_ni56'
         reaction_Name(ir_fe52_gp_mn51) = 'r_fe52_gp_mn51'
         reaction_Name(irfe52gp_aux) = 'rfe52gp_aux'
         reaction_Name(ir_fe52_ga_cr48) = 'r_fe52_ga_cr48'
         reaction_Name(irfe52gp_to_cr48) = 'rfe52gp_to_cr48'
         reaction_Name(irfe52ng_to_fe54) = 'rfe52ng_to_fe54'
         reaction_Name(irfe52ng_aux) = 'rfe52ng_aux'
         reaction_Name(irfe52neut_to_fe54) = 'rfe52neut_to_fe54'
         reaction_Name(irfe53ng_aux) = 'rfe53ng_aux'
         reaction_Name(irfe53gn_aux) = 'rfe53gn_aux'
         reaction_Name(irfe54gn_to_fe52) = 'rfe54gn_to_fe52'
         reaction_Name(irfe54gn_aux) = 'rfe54gn_aux'
         reaction_Name(irfe54g_to_fe52) = 'rfe54g_to_fe52'
         reaction_Name(irfe54protg) = 'rfe54protg'
         reaction_Name(irfe54a_to_ni56) = 'rfe54a_to_ni56'
         
         reaction_Name(irfe54ng_aux) = 'rfe54ng_aux'
         reaction_Name(irfe55ng_aux) = 'rfe55ng_aux'
         reaction_Name(irfe55gn_aux) = 'rfe55gn_aux'
         reaction_Name(irfe56gn_aux) = 'rfe56gn_aux'
         reaction_Name(irfe54ng_to_fe56) = 'rfe54ng_to_fe56'
         reaction_Name(irfe56gn_to_fe54) = 'rfe56gn_to_fe54'
         
         reaction_Name(irfe56ng_aux) = 'rfe56ng_aux'
         reaction_Name(irfe57ng_aux) = 'rfe57ng_aux'
         reaction_Name(irfe57gn_aux) = 'rfe57gn_aux'
         reaction_Name(irfe58gn_aux) = 'rfe58gn_aux'
         reaction_Name(irfe56ng_to_fe58) = 'rfe56ng_to_fe58'
         reaction_Name(irfe58gn_to_fe56) = 'rfe58gn_to_fe56'
         
         reaction_Name(irfe58ng_aux) = 'rfe58ng_aux'
         reaction_Name(irfe59ng_aux) = 'rfe59ng_aux'
         reaction_Name(irfe59gn_aux) = 'rfe59gn_aux'
         reaction_Name(irfe60gn_aux) = 'rfe60gn_aux'
         reaction_Name(irfe58ng_to_fe60) = 'rfe58ng_to_fe60'
         reaction_Name(irfe60gn_to_fe58) = 'rfe60gn_to_fe58'
         reaction_Name(irfe60ec_to_cr48_12n) = 'rfe60ec_to_cr48_12n'
         
         reaction_Name(irfe60ng_aux) = 'rfe60ng_aux'
         reaction_Name(irfe61ng_aux) = 'rfe61ng_aux'
         reaction_Name(irfe61gn_aux) = 'rfe61gn_aux'
         reaction_Name(irfe62gn_aux) = 'rfe62gn_aux'
         reaction_Name(irfe60ng_to_fe62) = 'rfe60ng_to_fe62'
         reaction_Name(irfe62gn_to_fe60) = 'rfe62gn_to_fe60'
         
         reaction_Name(irfe62ng_aux) = 'rfe62ng_aux'
         reaction_Name(irfe63ng_aux) = 'rfe63ng_aux'
         reaction_Name(irfe63gn_aux) = 'rfe63gn_aux'
         reaction_Name(irfe64gn_aux) = 'rfe64gn_aux'
         reaction_Name(irfe62ng_to_fe64) = 'rfe62ng_to_fe64'
         reaction_Name(irfe64gn_to_fe62) = 'rfe64gn_to_fe62'
         
         reaction_Name(irfe56ec_fake_to_cr56) = 'rfe56ec_fake_to_cr56'
         reaction_Name(irco55g_prot) = 'rco55g_prot'
         reaction_Name(irco55prot_a) = 'rco55prot_a'
         reaction_Name(irco55pa_aux) = 'rco55pa_aux'
         reaction_Name(irco55protg) = 'rco55protg'
         reaction_Name(irco55pg_aux) = 'rco55pg_aux'
         reaction_Name(irni56g_prot) = 'rni56g_prot'
         reaction_Name(irni56gp_aux) = 'rni56gp_aux'
         reaction_Name(irni56gp_to_fe52) = 'rni56gp_to_fe52'
         reaction_Name(irni56ec_to_fe54) = 'rni56ec_to_fe54'

         reaction_Name(irni66ec_to_fe60_6n) = 'rni66ec_to_fe60_6n'

         reaction_Name(irfe54aprot_to_fe56) = 'rfe54aprot_to_fe56'
         reaction_Name(irfe56prot_to_fe54) = 'rfe56prot_to_fe54'


         reaction_Name(irfe56aprot_to_fe58) = 'rfe56aprot_to_fe58'
         reaction_Name(irfe58prot_to_fe56) = 'rfe58prot_to_fe56'


         reaction_Name(irfe58aprot_to_fe60) = 'rfe58aprot_to_fe60'
         reaction_Name(irfe60prot_to_fe58) = 'rfe60prot_to_fe58'

         reaction_Name(irfe60aprot_to_fe62) = 'rfe60aprot_to_fe62'
         reaction_Name(irfe62prot_to_fe60) = 'rfe62prot_to_fe60'
         reaction_Name(irfe62prot_to_ni64) = 'rfe62prot_to_ni64'
         reaction_Name(irni64gprot_to_fe62) = 'rni64gprot_to_fe62'
         reaction_Name(irfe62protg_aux) = 'rfe62protg_aux'
         reaction_Name(irco63gprot_aux) = 'rco63gprot_aux'








         reaction_Name(irfe52aprot_to_fe54) = 'rfe52aprot_to_fe54'
         reaction_Name(irfe54prot_to_fe52) = 'rfe54prot_to_fe52'


         
         reaction_Name(irni62ec_to_fe62) = 'rni62ec_to_fe62'
         reaction_Name(irni64ec_to_fe64) = 'rni64ec_to_fe64'

         reaction_Name(irprot_to_neut) = 'rprot_to_neut'
         reaction_Name(irneut_to_prot) = 'rneut_to_prot'
         reaction_Name(irhe4gn_to_pieces) = 'rhe4gn_to_pieces'
         reaction_Name(irhe4g_neut_aux) = 'rhe4g_neut_aux'
         reaction_Name(irhe3gprot_aux) = 'rhe3gprot_aux'
         reaction_Name(irh2g_neut_aux) = 'rh2g_neut_aux'
         reaction_Name(irne22_to_ne20_2n) = 'rne22_to_ne20_2n'
         reaction_Name(iro18_to_o16_2n) = 'ro18_to_o16_2n'
         reaction_Name(irhe4_breakup) = 'rhe4_breakup'
         reaction_Name(irprot_neutg_aux) = 'rprot_neutg_aux'
         reaction_Name(irh2_protg_aux) = 'rh2_protg_aux'
         reaction_Name(irhe3_neutg_aux) = 'rhe3_neutg_aux'
         reaction_Name(irhe4_rebuild) = 'rhe4_rebuild'
         reaction_Name(irn14gc12) = 'rn14gc12'
         reaction_Name(irn14gp_to_c12_n) = 'rn14gp_to_c12_n'
         reaction_Name(ir_h2_pg_he3) = 'r_h2_pg_he3'
         reaction_Name(ir_be7_pg_b8) = 'r_be7_pg_b8'
         reaction_Name(ir_c12_pg_n13) = 'r_c12_pg_n13'
         reaction_Name(ir_c13_pg_n14) = 'r_c13_pg_n14'
         reaction_Name(ir_n13_pg_o14) = 'r_n13_pg_o14'
         reaction_Name(ir_n14_pg_o15) = 'r_n14_pg_o15'
         reaction_Name(ir_n15_pg_o16) = 'r_n15_pg_o16'
         reaction_Name(ir_o16_pg_f17) = 'r_o16_pg_f17'
         reaction_Name(ir_o17_pg_f18) = 'r_o17_pg_f18'
         reaction_Name(ir_o18_pg_f19) = 'r_o18_pg_f19'
         reaction_Name(ir_f19_pg_ne20) = 'r_f19_pg_ne20'
         reaction_Name(ir_ne22_pg_na23) = 'r_ne22_pg_na23'


      ! ni56
         reaction_Name(ir_fe52_ag_ni56) = 'r_fe52_ag_ni56'
         reaction_Name(ir_ni56_ga_fe52) = 'r_ni56_ga_fe52'
         reaction_Name(irfe52aprot_to_ni56) = 'rfe52aprot_to_ni56'
         reaction_Name(irni56gprot_to_fe52) = 'rni56gprot_to_fe52'
         reaction_Name(irfe52aprot_aux) = 'rfe52aprot_aux'
         reaction_Name(irco55prota_aux) = 'rco55prota_aux'
         reaction_Name(irni56gprot_aux) = 'rni56gprot_aux'
         reaction_Name(irco55protg_aux) = 'rco55protg_aux'
         reaction_Name(irfe54prot_to_ni56) = 'rfe54prot_to_ni56'
         reaction_Name(irni56gprot_to_fe54) = 'rni56gprot_to_fe54'
         reaction_Name(irfe54protg_aux) = 'rfe54protg_aux'
         reaction_Name(irco55gprot_aux) = 'rco55gprot_aux'
         reaction_Name(irni56ec_to_fe56) = 'rni56ec_to_fe56'      
      
      ! ni58
         reaction_Name(ir_fe54_ag_ni58) = 'r_fe54_ag_ni58'
         reaction_Name(ir_ni58_ga_fe54) = 'r_ni58_ga_fe54'
         reaction_Name(irfe54aprot_to_ni58) = 'rfe54aprot_to_ni58'
         reaction_Name(irni58gprot_to_fe54) = 'rni58gprot_to_fe54'
         reaction_Name(irfe54aprot_aux) = 'rfe54aprot_aux'
         reaction_Name(irco57prota_aux) = 'rco57prota_aux'
         reaction_Name(irni58gprot_aux) = 'rni58gprot_aux'
         reaction_Name(irco57protg_aux) = 'rco57protg_aux'
         reaction_Name(irfe56prot_to_ni58) = 'rfe56prot_to_ni58'
         reaction_Name(irni58gprot_to_fe56) = 'rni58gprot_to_fe56'
         reaction_Name(irfe56protg_aux) = 'rfe56protg_aux'
         reaction_Name(irco57gprot_aux) = 'rco57gprot_aux'
         reaction_Name(irni56aprot_to_ni58) = 'rni56aprot_to_ni58'
         reaction_Name(irni58prot_to_ni56) = 'rni58prot_to_ni56'
         reaction_Name(irni56aprot_aux) = 'rni56aprot_aux'
         reaction_Name(ircu59prota_aux) = 'rcu59prota_aux'
         reaction_Name(irni58protg_aux) = 'rni58protg_aux'
         reaction_Name(ircu59gprot_aux) = 'rcu59gprot_aux'
         reaction_Name(irni56ng_to_ni58) = 'rni56ng_to_ni58'
         reaction_Name(irni58gn_to_ni56) = 'rni58gn_to_ni56'
         reaction_Name(irni56ng_aux) = 'rni56ng_aux'
         reaction_Name(irni57gn_aux) = 'rni57gn_aux'
         reaction_Name(irni57ng_aux) = 'rni57ng_aux'
         reaction_Name(irni58gn_aux) = 'rni58gn_aux'
         reaction_Name(irni58ec_to_fe58) = 'rni58ec_to_fe58'      
         reaction_Name(irni58ec_to_fe56_2n) = 'rni58ec_to_fe56_2n'      
      
      ! ni60
         reaction_Name(ir_fe56_ag_ni60) = 'r_fe56_ag_ni60'
         reaction_Name(ir_ni60_ga_fe56) = 'r_ni60_ga_fe56'
         reaction_Name(irfe56aprot_to_ni60) = 'rfe56aprot_to_ni60'
         reaction_Name(irni60gprot_to_fe56) = 'rni60gprot_to_fe56'
         reaction_Name(irfe56aprot_aux) = 'rfe56aprot_aux'
         reaction_Name(irco59prota_aux) = 'rco59prota_aux'
         reaction_Name(irni60gprot_aux) = 'rni60gprot_aux'
         reaction_Name(irco59protg_aux) = 'rco59protg_aux'
         reaction_Name(irfe58prot_to_ni60) = 'rfe58prot_to_ni60'
         reaction_Name(irni60gprot_to_fe58) = 'rni60gprot_to_fe58'
         reaction_Name(irfe58protg_aux) = 'rfe58protg_aux'
         reaction_Name(irco59gprot_aux) = 'rco59gprot_aux'
         reaction_Name(irni58aprot_to_ni60) = 'rni58aprot_to_ni60'
         reaction_Name(irni60prot_to_ni58) = 'rni60prot_to_ni58'
         reaction_Name(irni58aprot_aux) = 'rni58aprot_aux'
         reaction_Name(ircu61prota_aux) = 'rcu61prota_aux'
         reaction_Name(irni60protg_aux) = 'rni60protg_aux'
         reaction_Name(ircu61gprot_aux) = 'rcu61gprot_aux'
         reaction_Name(irni58ng_to_ni60) = 'rni58ng_to_ni60'
         reaction_Name(irni60gn_to_ni58) = 'rni60gn_to_ni58'
         reaction_Name(irni58ng_aux) = 'rni58ng_aux'
         reaction_Name(irni59gn_aux) = 'rni59gn_aux'
         reaction_Name(irni59ng_aux) = 'rni59ng_aux'
         reaction_Name(irni60gn_aux) = 'rni60gn_aux'
         reaction_Name(irni60ec_to_fe60) = 'rni60ec_to_fe60'
      
      ! ni62
         reaction_Name(ir_fe58_ag_ni62) = 'r_fe58_ag_ni62'
         reaction_Name(ir_ni62_ga_fe58) = 'r_ni62_ga_fe58'
         reaction_Name(irfe58aprot_to_ni62) = 'rfe58aprot_to_ni62'
         reaction_Name(irni62gprot_to_fe58) = 'rni62gprot_to_fe58'
         reaction_Name(irfe58aprot_aux) = 'rfe58aprot_aux'
         reaction_Name(irco61prota_aux) = 'rco61prota_aux'
         reaction_Name(irni62gprot_aux) = 'rni62gprot_aux'
         reaction_Name(irco61protg_aux) = 'rco61protg_aux'
         reaction_Name(irfe60prot_to_ni62) = 'rfe60prot_to_ni62'
         reaction_Name(irni62gprot_to_fe60) = 'rni62gprot_to_fe60'
         reaction_Name(irfe60protg_aux) = 'rfe60protg_aux'
         reaction_Name(irco61gprot_aux) = 'rco61gprot_aux'
         reaction_Name(irni60aprot_to_ni62) = 'rni60aprot_to_ni62'
         reaction_Name(irni62prot_to_ni60) = 'rni62prot_to_ni60'
         reaction_Name(irni60aprot_aux) = 'rni60aprot_aux'
         reaction_Name(ircu63prota_aux) = 'rcu63prota_aux'
         reaction_Name(irni62protg_aux) = 'rni62protg_aux'
         reaction_Name(ircu63gprot_aux) = 'rcu63gprot_aux'
         reaction_Name(irni60ng_to_ni62) = 'rni60ng_to_ni62'
         reaction_Name(irni62gn_to_ni60) = 'rni62gn_to_ni60'
         reaction_Name(irni60ng_aux) = 'rni60ng_aux'
         reaction_Name(irni61gn_aux) = 'rni61gn_aux'
         reaction_Name(irni61ng_aux) = 'rni61ng_aux'
         reaction_Name(irni62gn_aux) = 'rni62gn_aux'
         reaction_Name(irni62ec_to_fe60_2n) = 'rni62ec_to_fe60_2n'
         
      ! ni64
         reaction_Name(ir_fe60_ag_ni64) = 'r_fe60_ag_ni64'
         reaction_Name(ir_ni64_ga_fe60) = 'r_ni64_ga_fe60'
         reaction_Name(irfe60aprot_to_ni64) = 'rfe60aprot_to_ni64'
         reaction_Name(irni64gprot_to_fe60) = 'rni64gprot_to_fe60'
         reaction_Name(irfe60aprot_aux) = 'rfe60aprot_aux'
         reaction_Name(irco63prota_aux) = 'rco63prota_aux'
         reaction_Name(irni64gprot_aux) = 'rni64gprot_aux'
         reaction_Name(irco63protg_aux) = 'rco63protg_aux'
         reaction_Name(irni62aprot_to_ni64) = 'rni62aprot_to_ni64'
         reaction_Name(irni64prot_to_ni62) = 'rni64prot_to_ni62'
         reaction_Name(irni62aprot_aux) = 'rni62aprot_aux'
         reaction_Name(ircu65prota_aux) = 'rcu65prota_aux'
         reaction_Name(irni64protg_aux) = 'rni64protg_aux'
         reaction_Name(ircu65gprot_aux) = 'rcu65gprot_aux'
         reaction_Name(irni62ng_to_ni64) = 'rni62ng_to_ni64'
         reaction_Name(irni64gn_to_ni62) = 'rni64gn_to_ni62'
         reaction_Name(irni62ng_aux) = 'rni62ng_aux'
         reaction_Name(irni63gn_aux) = 'rni63gn_aux'
         reaction_Name(irni63ng_aux) = 'rni63ng_aux'
         reaction_Name(irni64gn_aux) = 'rni64gn_aux'
         reaction_Name(irni64ec_to_fe60_4n) = 'rni64ec_to_fe60_4n'
      
      ! ni66
         reaction_Name(ir_fe62_ag_ni66) = 'r_fe62_ag_ni66'
         reaction_Name(ir_ni66_ga_fe62) = 'r_ni66_ga_fe62'
         reaction_Name(irfe62aprot_to_ni66) = 'rfe62aprot_to_ni66'
         reaction_Name(irni66gprot_to_fe62) = 'rni66gprot_to_fe62'
         reaction_Name(irfe62aprot_aux) = 'rfe62aprot_aux'
         reaction_Name(irco65prota_aux) = 'rco65prota_aux'
         reaction_Name(irni66gprot_aux) = 'rni66gprot_aux'
         reaction_Name(irco65protg_aux) = 'rco65protg_aux'
         reaction_Name(irni64aprot_to_ni66) = 'rni64aprot_to_ni66'
         reaction_Name(irni66prot_to_ni64) = 'rni66prot_to_ni64'
         reaction_Name(irni64ng_to_ni66) = 'rni64ng_to_ni66'
         reaction_Name(irni66gn_to_ni64) = 'rni66gn_to_ni64'
         reaction_Name(irni64ng_aux) = 'rni64ng_aux'
         reaction_Name(irni65gn_aux) = 'rni65gn_aux'
         reaction_Name(irni65ng_aux) = 'rni65ng_aux'
         reaction_Name(irni66gn_aux) = 'rni66gn_aux'

      ! zn60
         reaction_Name(irzn60ng_to_zn62) = 'rzn60ng_to_zn62'
         reaction_Name(irzn62gn_to_zn60) = 'rzn62gn_to_zn60'
         reaction_Name(irzn60ng_aux) = 'rzn60ng_aux'
         reaction_Name(irzn61gn_aux) = 'rzn61gn_aux'
         reaction_Name(irzn61ng_aux) = 'rzn61ng_aux'
         reaction_Name(irzn62gn_aux) = 'rzn62gn_aux'
         
      ! zn64
         reaction_Name(ir_ni60_ag_zn64) = 'r_ni60_ag_zn64'
         reaction_Name(ir_zn64_ga_ni60) = 'r_zn64_ga_ni60'
         reaction_Name(irni60aprot_to_zn64) = 'rni60aprot_to_zn64'
         reaction_Name(irzn64gprot_to_ni60) = 'rzn64gprot_to_ni60'
         reaction_Name(irni60aprot_aux) = 'rni60aprot_aux'
         reaction_Name(ircu63prota_aux) = 'rcu63prota_aux'
         reaction_Name(irzn64gprot_aux) = 'rzn64gprot_aux'
         reaction_Name(ircu63protg_aux) = 'rcu63protg_aux'
         reaction_Name(irni62prot_to_zn64) = 'rni62prot_to_zn64'
         reaction_Name(irzn64gprot_to_ni62) = 'rzn64gprot_to_ni62'
         reaction_Name(irni62protg_aux) = 'rni62protg_aux'
         reaction_Name(ircu63gprot_aux) = 'rcu63gprot_aux'
         reaction_Name(irzn62aprot_to_zn64) = 'rzn62aprot_to_zn64'
         reaction_Name(irzn64prot_to_zn62) = 'rzn64prot_to_zn62'
         reaction_Name(irzn62aprot_aux) = 'rzn62aprot_aux'
         reaction_Name(irga65prota_aux) = 'rga65prota_aux'
         reaction_Name(irzn64protg_aux) = 'rzn64protg_aux'
         reaction_Name(irga65gprot_aux) = 'rga65gprot_aux'
         reaction_Name(irzn62ng_to_zn64) = 'rzn62ng_to_zn64'
         reaction_Name(irzn64gn_to_zn62) = 'rzn64gn_to_zn62'
         reaction_Name(irzn62ng_aux) = 'rzn62ng_aux'
         reaction_Name(irzn63gn_aux) = 'rzn63gn_aux'
         reaction_Name(irzn63ng_aux) = 'rzn63ng_aux'
         reaction_Name(irzn64gn_aux) = 'rzn64gn_aux'
         reaction_Name(irzn64ec_to_ni64) = 'rzn64ec_to_ni64'
         
      ! zn66
         reaction_Name(ir_ni62_ag_zn66) = 'r_ni62_ag_zn66'
         reaction_Name(ir_zn66_ga_ni62) = 'r_zn66_ga_ni62'
         reaction_Name(irni62aprot_to_zn66) = 'rni62aprot_to_zn66'
         reaction_Name(irzn66gprot_to_ni62) = 'rzn66gprot_to_ni62'
         reaction_Name(irni62aprot_aux) = 'rni62aprot_aux'
         reaction_Name(ircu65prota_aux) = 'rcu65prota_aux'
         reaction_Name(irzn66gprot_aux) = 'rzn66gprot_aux'
         reaction_Name(ircu65protg_aux) = 'rcu65protg_aux'
         reaction_Name(irni64prot_to_zn66) = 'rni64prot_to_zn66'
         reaction_Name(irzn66gprot_to_ni64) = 'rzn66gprot_to_ni64'
         reaction_Name(irni64protg_aux) = 'rni64protg_aux'
         reaction_Name(ircu65gprot_aux) = 'rcu65gprot_aux'
         reaction_Name(irzn64aprot_to_zn66) = 'rzn64aprot_to_zn66'
         reaction_Name(irzn66prot_to_zn64) = 'rzn66prot_to_zn64'
         reaction_Name(irzn64aprot_aux) = 'rzn64aprot_aux'
         reaction_Name(irga67prota_aux) = 'rga67prota_aux'
         reaction_Name(irzn66protg_aux) = 'rzn66protg_aux'
         reaction_Name(irga67gprot_aux) = 'rga67gprot_aux'
         reaction_Name(irzn64ng_to_zn66) = 'rzn64ng_to_zn66'
         reaction_Name(irzn66gn_to_zn64) = 'rzn66gn_to_zn64'
         reaction_Name(irzn64ng_aux) = 'rzn64ng_aux'
         reaction_Name(irzn65gn_aux) = 'rzn65gn_aux'
         reaction_Name(irzn65ng_aux) = 'rzn65ng_aux'
         reaction_Name(irzn66gn_aux) = 'rzn66gn_aux'
         reaction_Name(irzn66ec_to_ni66) = 'rzn66ec_to_ni66'
         
      ! zn68
         reaction_Name(ir_ni64_ag_zn68) = 'r_ni64_ag_zn68'
         reaction_Name(ir_zn68_ga_ni64) = 'r_zn68_ga_ni64'
         reaction_Name(irni64aprot_to_zn68) = 'rni64aprot_to_zn68'
         reaction_Name(irzn68gprot_to_ni64) = 'rzn68gprot_to_ni64'
         reaction_Name(irni64aprot_aux) = 'rni64aprot_aux'
         reaction_Name(ircu67prota_aux) = 'rcu67prota_aux'
         reaction_Name(irzn68gprot_aux) = 'rzn68gprot_aux'
         reaction_Name(ircu67protg_aux) = 'rcu67protg_aux'
         reaction_Name(irni66prot_to_zn68) = 'rni66prot_to_zn68'
         reaction_Name(irzn68gprot_to_ni66) = 'rzn68gprot_to_ni66'
         reaction_Name(irni66protg_aux) = 'rni66protg_aux'
         reaction_Name(ircu67gprot_aux) = 'rcu67gprot_aux'
         reaction_Name(irzn66aprot_to_zn68) = 'rzn66aprot_to_zn68'
         reaction_Name(irzn68prot_to_zn66) = 'rzn68prot_to_zn66'
!         reaction_Name(irzn66aprot_aux) = 'rzn66aprot_aux'
!         reaction_Name(irga69prota_aux) = 'rga69prota_aux'
         reaction_Name(irzn68protg_aux) = 'rzn68protg_aux'
         reaction_Name(irga69gprot_aux) = 'rga69gprot_aux'
         reaction_Name(irzn66ng_to_zn68) = 'rzn66ng_to_zn68'
         reaction_Name(irzn68gn_to_zn66) = 'rzn68gn_to_zn66'
         reaction_Name(irzn66ng_aux) = 'rzn66ng_aux'
         reaction_Name(irzn67gn_aux) = 'rzn67gn_aux'
         reaction_Name(irzn67ng_aux) = 'rzn67ng_aux'
         reaction_Name(irzn68gn_aux) = 'rzn68gn_aux'
         reaction_Name(irzn68ec_to_ni68) = 'rzn68ec_to_ni68'

      ! zn70
         reaction_Name(ir_ni66_ag_zn70) = 'r_ni66_ag_zn70'
         reaction_Name(ir_zn70_ga_ni66) = 'r_zn70_ga_ni66'
         reaction_Name(irni66aprot_to_zn70) = 'rni66aprot_to_zn70'
         reaction_Name(irzn70gprot_to_ni66) = 'rzn70gprot_to_ni66'
         reaction_Name(irni66aprot_aux) = 'rni66aprot_aux'
         reaction_Name(ircu69prota_aux) = 'rcu69prota_aux'
         reaction_Name(irzn70gprot_aux) = 'rzn70gprot_aux'
         reaction_Name(ircu69protg_aux) = 'rcu69protg_aux'
         reaction_Name(irni68prot_to_zn70) = 'rni68prot_to_zn70'
         reaction_Name(irzn70gprot_to_ni68) = 'rzn70gprot_to_ni68'
         reaction_Name(irni68protg_aux) = 'rni68protg_aux'
         reaction_Name(ircu69gprot_aux) = 'rcu69gprot_aux'
         reaction_Name(irzn68aprot_to_zn70) = 'rzn68aprot_to_zn70'
         reaction_Name(irzn70prot_to_zn68) = 'rzn70prot_to_zn68'
         reaction_Name(irzn68aprot_aux) = 'rzn68aprot_aux'
         reaction_Name(irga71prota_aux) = 'rga71prota_aux'
         reaction_Name(irzn70protg_aux) = 'rzn70protg_aux'
         reaction_Name(irga71gprot_aux) = 'rga71gprot_aux'
         reaction_Name(irzn68ng_to_zn70) = 'rzn68ng_to_zn70'
         reaction_Name(irzn70gn_to_zn68) = 'rzn70gn_to_zn68'
         reaction_Name(irzn68ng_aux) = 'rzn68ng_aux'
         reaction_Name(irzn69gn_aux) = 'rzn69gn_aux'
         reaction_Name(irzn69ng_aux) = 'rzn69ng_aux'
         reaction_Name(irzn70gn_aux) = 'rzn70gn_aux'
         reaction_Name(irzn70ec_to_ni70) = 'rzn70ec_to_ni70'

      ! zn72
         reaction_Name(ir_ni68_ag_zn72) = 'r_ni68_ag_zn72'
         reaction_Name(ir_zn72_ga_ni68) = 'r_zn72_ga_ni68'
         reaction_Name(irni68aprot_to_zn72) = 'rni68aprot_to_zn72'
         reaction_Name(irzn72gprot_to_ni68) = 'rzn72gprot_to_ni68'
         reaction_Name(irni68aprot_aux) = 'rni68aprot_aux'
         reaction_Name(ircu71prota_aux) = 'rcu71prota_aux'
         reaction_Name(irzn72gprot_aux) = 'rzn72gprot_aux'
         reaction_Name(ircu71protg_aux) = 'rcu71protg_aux'
         reaction_Name(irni70prot_to_zn72) = 'rni70prot_to_zn72'
         reaction_Name(irzn72gprot_to_ni70) = 'rzn72gprot_to_ni70'
         reaction_Name(irni70protg_aux) = 'rni70protg_aux'
         reaction_Name(ircu71gprot_aux) = 'rcu71gprot_aux'
         reaction_Name(irzn70aprot_to_zn72) = 'rzn70aprot_to_zn72'
         reaction_Name(irzn72prot_to_zn70) = 'rzn72prot_to_zn70'
         reaction_Name(irzn70aprot_aux) = 'rzn70aprot_aux'
         reaction_Name(irga73prota_aux) = 'rga73prota_aux'
         reaction_Name(irzn72protg_aux) = 'rzn72protg_aux'
         reaction_Name(irga73gprot_aux) = 'rga73gprot_aux'
         reaction_Name(irzn70ng_to_zn72) = 'rzn70ng_to_zn72'
         reaction_Name(irzn72gn_to_zn70) = 'rzn72gn_to_zn70'
         reaction_Name(irzn70ng_aux) = 'rzn70ng_aux'
         reaction_Name(irzn71gn_aux) = 'rzn71gn_aux'
         reaction_Name(irzn71ng_aux) = 'rzn71ng_aux'
         reaction_Name(irzn72gn_aux) = 'rzn72gn_aux'
         reaction_Name(irzn72ec_to_ni72) = 'rzn72ec_to_ni72'
         
      ! ge70
         reaction_Name(ir_zn66_ag_ge70) = 'r_zn66_ag_ge70'
         reaction_Name(ir_ge70_ga_zn66) = 'r_ge70_ga_zn66'
         reaction_Name(irzn66aprot_to_ge70) = 'rzn66aprot_to_ge70'
         reaction_Name(irge70gprot_to_zn66) = 'rge70gprot_to_zn66'
         reaction_Name(irzn66aprot_aux) = 'rzn66aprot_aux'
         reaction_Name(irga69prota_aux) = 'rga69prota_aux'
         reaction_Name(irge70gprot_aux) = 'rge70gprot_aux'
         reaction_Name(irga69protg_aux) = 'rga69protg_aux'
         reaction_Name(irzn68prot_to_ge70) = 'rzn68prot_to_ge70'
         reaction_Name(irge70gprot_to_zn68) = 'rge70gprot_to_zn68'
         reaction_Name(irzn68protg_aux) = 'rzn68protg_aux'
         reaction_Name(irga69gprot_aux) = 'rga69gprot_aux'
         reaction_Name(irge68aprot_to_ge70) = 'rge68aprot_to_ge70'
         reaction_Name(irge70prot_to_ge68) = 'rge70prot_to_ge68'
         reaction_Name(irge68aprot_aux) = 'rge68aprot_aux'
         reaction_Name(iras71prota_aux) = 'ras71prota_aux'
         reaction_Name(irge70protg_aux) = 'rge70protg_aux'
         reaction_Name(iras71gprot_aux) = 'ras71gprot_aux'
         reaction_Name(irge68ng_to_ge70) = 'rge68ng_to_ge70'
         reaction_Name(irge70gn_to_ge68) = 'rge70gn_to_ge68'
         reaction_Name(irge68ng_aux) = 'rge68ng_aux'
         reaction_Name(irge69gn_aux) = 'rge69gn_aux'
         reaction_Name(irge69ng_aux) = 'rge69ng_aux'
         reaction_Name(irge70gn_aux) = 'rge70gn_aux'
         reaction_Name(irge70ec_to_zn70) = 'rge70ec_to_zn70'
         
      ! ge72
         reaction_Name(ir_zn68_ag_ge72) = 'r_zn68_ag_ge72'
         reaction_Name(ir_ge72_ga_zn68) = 'r_ge72_ga_zn68'
         reaction_Name(irzn68aprot_to_ge72) = 'rzn68aprot_to_ge72'
         reaction_Name(irge72gprot_to_zn68) = 'rge72gprot_to_zn68'
         reaction_Name(irzn68aprot_aux) = 'rzn68aprot_aux'
         reaction_Name(irga71prota_aux) = 'rga71prota_aux'
         reaction_Name(irge72gprot_aux) = 'rge72gprot_aux'
         reaction_Name(irga71protg_aux) = 'rga71protg_aux'
         reaction_Name(irzn70prot_to_ge72) = 'rzn70prot_to_ge72'
         reaction_Name(irge72gprot_to_zn70) = 'rge72gprot_to_zn70'
         reaction_Name(irzn70protg_aux) = 'rzn70protg_aux'
         reaction_Name(irga71gprot_aux) = 'rga71gprot_aux'
         reaction_Name(irge70aprot_to_ge72) = 'rge70aprot_to_ge72'
         reaction_Name(irge72prot_to_ge70) = 'rge72prot_to_ge70'
         reaction_Name(irge70aprot_aux) = 'rge70aprot_aux'
         reaction_Name(iras73prota_aux) = 'ras73prota_aux'
         reaction_Name(irge72protg_aux) = 'rge72protg_aux'
         reaction_Name(iras73gprot_aux) = 'ras73gprot_aux'
         reaction_Name(irge70ng_to_ge72) = 'rge70ng_to_ge72'
         reaction_Name(irge72gn_to_ge70) = 'rge72gn_to_ge70'
         reaction_Name(irge70ng_aux) = 'rge70ng_aux'
         reaction_Name(irge71gn_aux) = 'rge71gn_aux'
         reaction_Name(irge71ng_aux) = 'rge71ng_aux'
         reaction_Name(irge72gn_aux) = 'rge72gn_aux'
         reaction_Name(irge72ec_to_zn72) = 'rge72ec_to_zn72'
         
      ! ge74
         reaction_Name(ir_zn70_ag_ge74) = 'r_zn70_ag_ge74'
         reaction_Name(ir_ge74_ga_zn70) = 'r_ge74_ga_zn70'
         reaction_Name(irzn70aprot_to_ge74) = 'rzn70aprot_to_ge74'
         reaction_Name(irge74gprot_to_zn70) = 'rge74gprot_to_zn70'
         reaction_Name(irzn70aprot_aux) = 'rzn70aprot_aux'
         reaction_Name(irga73prota_aux) = 'rga73prota_aux'
         reaction_Name(irge74gprot_aux) = 'rge74gprot_aux'
         reaction_Name(irga73protg_aux) = 'rga73protg_aux'
         reaction_Name(irzn72prot_to_ge74) = 'rzn72prot_to_ge74'
         reaction_Name(irge74gprot_to_zn72) = 'rge74gprot_to_zn72'
         reaction_Name(irzn72protg_aux) = 'rzn72protg_aux'
         reaction_Name(irga73gprot_aux) = 'rga73gprot_aux'
         reaction_Name(irge72aprot_to_ge74) = 'rge72aprot_to_ge74'
         reaction_Name(irge74prot_to_ge72) = 'rge74prot_to_ge72'
         reaction_Name(irge72aprot_aux) = 'rge72aprot_aux'
         reaction_Name(iras75prota_aux) = 'ras75prota_aux'
         reaction_Name(irge74protg_aux) = 'rge74protg_aux'
         reaction_Name(iras75gprot_aux) = 'ras75gprot_aux'
         reaction_Name(irge72ng_to_ge74) = 'rge72ng_to_ge74'
         reaction_Name(irge74gn_to_ge72) = 'rge74gn_to_ge72'
         reaction_Name(irge72ng_aux) = 'rge72ng_aux'
         reaction_Name(irge73gn_aux) = 'rge73gn_aux'
         reaction_Name(irge73ng_aux) = 'rge73ng_aux'
         reaction_Name(irge74gn_aux) = 'rge74gn_aux'
         reaction_Name(irge74ec_to_zn74) = 'rge74ec_to_zn74'
         
      ! ge76
         reaction_Name(irge74ng_to_ge76) = 'rge74ng_to_ge76'
         reaction_Name(irge76gn_to_ge74) = 'rge76gn_to_ge74'
         reaction_Name(irge74ng_aux) = 'rge74ng_aux'
         reaction_Name(irge75gn_aux) = 'rge75gn_aux'
         reaction_Name(irge75ng_aux) = 'rge75ng_aux'
         reaction_Name(irge76gn_aux) = 'rge76gn_aux'
         
         reaction_Name(ir_mg26_ga_ne22) = 'r_mg26_ga_ne22'
         reaction_Name(irne22ap_to_mg26) = 'rne22ap_to_mg26'
         reaction_Name(irmg26gp_to_ne22) = 'rmg26gp_to_ne22'
         reaction_Name(irne22ap_aux) = 'rne22ap_aux'
         reaction_Name(irna25pa_aux) = 'rna25pa_aux'
         reaction_Name(irmg26gp_aux) = 'rmg26gp_aux'
         reaction_Name(irna25pg_aux) = 'rna25pg_aux'
         reaction_Name(irmg24ap_to_mg26) = 'rmg24ap_to_mg26'
         reaction_Name(irmg26p_to_mg24) = 'rmg26p_to_mg24'
         reaction_Name(irmg24ng_to_mg26) = 'rmg24ng_to_mg26'
         reaction_Name(irmg26gn_to_mg24) = 'rmg26gn_to_mg24'
         reaction_Name(irmg24ng_aux) = 'rmg24ng_aux'
         reaction_Name(irmg25gn_aux) = 'rmg25gn_aux'
         reaction_Name(irmg25ng_aux) = 'rmg25ng_aux'
         reaction_Name(irmg26gn_aux) = 'rmg26gn_aux'
         reaction_Name(irmg26pg_aux) = 'rmg26pg_aux'
         reaction_Name(iral27gp_aux) = 'ral27gp_aux'

         reaction_Name(iro18ap_to_ne22) = 'ro18ap_to_ne22'
         reaction_Name(irne22gp_to_o18) = 'rne22gp_to_o18'
         reaction_Name(iro18ap_aux) = 'ro18ap_aux'
         reaction_Name(irf21pa_aux) = 'rf21pa_aux'
         reaction_Name(irne22gp_aux) = 'rne22gp_aux'
         reaction_Name(irf21pg_aux) = 'rf21pg_aux'
         reaction_Name(irne20ap_to_ne22) = 'rne20ap_to_ne22'
         reaction_Name(irne22p_to_ne20) = 'rne22p_to_ne20'
         reaction_Name(irne20ng_to_ne22) = 'rne20ng_to_ne22'
         reaction_Name(irne22gn_to_ne20) = 'rne22gn_to_ne20'
         reaction_Name(irne20ng_aux) = 'rne20ng_aux'
         reaction_Name(irne21gn_aux) = 'rne21gn_aux'
         reaction_Name(irne21ng_aux) = 'rne21ng_aux'
         reaction_Name(irne22gn_aux) = 'rne22gn_aux'
         reaction_Name(irne22pg_aux) = 'rne22pg_aux'
         reaction_Name(irna23gp_aux) = 'rna23gp_aux'
         reaction_Name(irne22p_to_mg24) = 'rne22p_to_mg24'
         reaction_Name(irmg24gp_to_ne22) = 'rmg24gp_to_ne22'

         reaction_Name(ir_mg26_ag_si30) = 'r_mg26_ag_si30'
         reaction_Name(ir_si30_ga_mg26) = 'r_si30_ga_mg26'
         reaction_Name(irmg26ap_to_si30) = 'rmg26ap_to_si30'
         reaction_Name(irsi30gp_to_mg26) = 'rsi30gp_to_mg26'
         reaction_Name(irmg26ap_aux) = 'rmg26ap_aux'
         reaction_Name(iral29pa_aux) = 'ral29pa_aux'
         reaction_Name(irsi30gp_aux) = 'rsi30gp_aux'
         reaction_Name(iral29pg_aux) = 'ral29pg_aux'
         reaction_Name(irmg28p_to_si30) = 'rmg28p_to_si30'
         reaction_Name(irsi30gp_to_mg28) = 'rsi30gp_to_mg28'
         reaction_Name(irmg28pg_aux) = 'rmg28pg_aux'
         reaction_Name(iral29gp_aux) = 'ral29gp_aux'
         reaction_Name(irsi28ap_to_si30) = 'rsi28ap_to_si30'
         reaction_Name(irsi30p_to_si28) = 'rsi30p_to_si28'
         reaction_Name(irsi28ap_aux) = 'rsi28ap_aux'
         reaction_Name(irp31pa_aux) = 'rp31pa_aux'
         reaction_Name(irsi30pg_aux) = 'rsi30pg_aux'
         reaction_Name(irp31gp_aux) = 'rp31gp_aux'
         reaction_Name(irsi28ng_to_si30) = 'rsi28ng_to_si30'
         reaction_Name(irsi30gn_to_si28) = 'rsi30gn_to_si28'
         reaction_Name(irsi28ng_aux) = 'rsi28ng_aux'
         reaction_Name(irsi29gn_aux) = 'rsi29gn_aux'
         reaction_Name(irsi29ng_aux) = 'rsi29ng_aux'
         reaction_Name(irsi30gn_aux) = 'rsi30gn_aux'

         reaction_Name(ir_si30_ag_s34) = 'r_si30_ag_s34'
         reaction_Name(ir_s34_ga_si30) = 'r_s34_ga_si30'
         reaction_Name(irsi30ap_to_s34) = 'rsi30ap_to_s34'
         reaction_Name(irs34gp_to_si30) = 'rs34gp_to_si30'
         reaction_Name(irsi30ap_aux) = 'rsi30ap_aux'
         reaction_Name(irp33pa_aux) = 'rp33pa_aux'
         reaction_Name(irs34gp_aux) = 'rs34gp_aux'
         reaction_Name(irp33pg_aux) = 'rp33pg_aux'
         reaction_Name(irsi32p_to_s34) = 'rsi32p_to_s34'
         reaction_Name(irs34gp_to_si32) = 'rs34gp_to_si32'
         reaction_Name(irsi32pg_aux) = 'rsi32pg_aux'
         reaction_Name(irp33gp_aux) = 'rp33gp_aux'
         reaction_Name(irs32ap_to_s34) = 'rs32ap_to_s34'
         reaction_Name(irs34p_to_s32) = 'rs34p_to_s32'
         reaction_Name(irs32ap_aux) = 'rs32ap_aux'
         reaction_Name(ircl35pa_aux) = 'rcl35pa_aux'
         reaction_Name(irs34pg_aux) = 'rs34pg_aux'
         reaction_Name(ircl35gp_aux) = 'rcl35gp_aux'
         reaction_Name(irs32ng_to_s34) = 'rs32ng_to_s34'
         reaction_Name(irs34gn_to_s32) = 'rs34gn_to_s32'
         reaction_Name(irs32ng_aux) = 'rs32ng_aux'
         reaction_Name(irs33gn_aux) = 'rs33gn_aux'
         reaction_Name(irs33ng_aux) = 'rs33ng_aux'
         reaction_Name(irs34gn_aux) = 'rs34gn_aux'

         reaction_Name(ir_s34_ag_ar38) = 'r_s34_ag_ar38'
         reaction_Name(ir_ar38_ga_s34) = 'r_ar38_ga_s34'
         reaction_Name(irs34ap_to_ar38) = 'rs34ap_to_ar38'
         reaction_Name(irar38gp_to_s34) = 'rar38gp_to_s34'
         reaction_Name(irs34ap_aux) = 'rs34ap_aux'
         reaction_Name(ircl37pa_aux) = 'rcl37pa_aux'
         reaction_Name(irar38gp_aux) = 'rar38gp_aux'
         reaction_Name(ircl37pg_aux) = 'rcl37pg_aux'
         reaction_Name(irs36p_to_ar38) = 'rs36p_to_ar38'
         reaction_Name(irar38gp_to_s36) = 'rar38gp_to_s36'
         reaction_Name(irs36pg_aux) = 'rs36pg_aux'
         reaction_Name(ircl37gp_aux) = 'rcl37gp_aux'
         reaction_Name(irar36ap_to_ar38) = 'rar36ap_to_ar38'
         reaction_Name(irar38p_to_ar36) = 'rar38p_to_ar36'
         reaction_Name(irar36ap_aux) = 'rar36ap_aux'
         reaction_Name(irk39pa_aux) = 'rk39pa_aux'
         reaction_Name(irar38pg_aux) = 'rar38pg_aux'
         reaction_Name(irk39gp_aux) = 'rk39gp_aux'
         reaction_Name(irar36ng_to_ar38) = 'rar36ng_to_ar38'
         reaction_Name(irar38gn_to_ar36) = 'rar38gn_to_ar36'
         reaction_Name(irar36ng_aux) = 'rar36ng_aux'
         reaction_Name(irar37gn_aux) = 'rar37gn_aux'
         reaction_Name(irar37ng_aux) = 'rar37ng_aux'
         reaction_Name(irar38gn_aux) = 'rar38gn_aux'

         reaction_Name(ir_ar38_ag_ca42) = 'r_ar38_ag_ca42'
         reaction_Name(ir_ca42_ga_ar38) = 'r_ca42_ga_ar38'
         reaction_Name(irar38ap_to_ca42) = 'rar38ap_to_ca42'
         reaction_Name(irca42gp_to_ar38) = 'rca42gp_to_ar38'
         reaction_Name(irar38ap_aux) = 'rar38ap_aux'
         reaction_Name(irk41pa_aux) = 'rk41pa_aux'
         reaction_Name(irca42gp_aux) = 'rca42gp_aux'
         reaction_Name(irk41pg_aux) = 'rk41pg_aux'
         reaction_Name(irar40p_to_ca42) = 'rar40p_to_ca42'
         reaction_Name(irca42gp_to_ar40) = 'rca42gp_to_ar40'
         reaction_Name(irar40pg_aux) = 'rar40pg_aux'
         reaction_Name(irk41gp_aux) = 'rk41gp_aux'
         reaction_Name(irca40ap_to_ca42) = 'rca40ap_to_ca42'
         reaction_Name(irca42p_to_ca40) = 'rca42p_to_ca40'
         reaction_Name(irca40ap_aux) = 'rca40ap_aux'
         reaction_Name(irsc43pa_aux) = 'rsc43pa_aux'
         reaction_Name(irca42pg_aux) = 'rca42pg_aux'
         reaction_Name(irsc43gp_aux) = 'rsc43gp_aux'
         reaction_Name(irca40ng_to_ca42) = 'rca40ng_to_ca42'
         reaction_Name(irca42gn_to_ca40) = 'rca42gn_to_ca40'
         reaction_Name(irca40ng_aux) = 'rca40ng_aux'
         reaction_Name(irca41gn_aux) = 'rca41gn_aux'
         reaction_Name(irca41ng_aux) = 'rca41ng_aux'
         reaction_Name(irca42gn_aux) = 'rca42gn_aux'

         reaction_Name(ir_ca42_ag_ti46) = 'r_ca42_ag_ti46'
         reaction_Name(ir_ti46_ga_ca42) = 'r_ti46_ga_ca42'
         reaction_Name(irca42ap_to_ti46) = 'rca42ap_to_ti46'
         reaction_Name(irti46gp_to_ca42) = 'rti46gp_to_ca42'
         reaction_Name(irca42ap_aux) = 'rca42ap_aux'
         reaction_Name(irsc45pa_aux) = 'rsc45pa_aux'
         reaction_Name(irti46gp_aux) = 'rti46gp_aux'
         reaction_Name(irsc45pg_aux) = 'rsc45pg_aux'
         reaction_Name(irca44p_to_ti46) = 'rca44p_to_ti46'
         reaction_Name(irti46gp_to_ca44) = 'rti46gp_to_ca44'
         reaction_Name(irca44pg_aux) = 'rca44pg_aux'
         reaction_Name(irsc45gp_aux) = 'rsc45gp_aux'
         reaction_Name(irti44ap_to_ti46) = 'rti44ap_to_ti46'
         reaction_Name(irti46p_to_ti44) = 'rti46p_to_ti44'
         reaction_Name(irti44ap_aux) = 'rti44ap_aux'
         reaction_Name(irv47pa_aux) = 'rv47pa_aux'
         reaction_Name(irti46pg_aux) = 'rti46pg_aux'
         reaction_Name(irv47gp_aux) = 'rv47gp_aux'
         reaction_Name(irti44ng_to_ti46) = 'rti44ng_to_ti46'
         reaction_Name(irti46gn_to_ti44) = 'rti46gn_to_ti44'
         reaction_Name(irti44ng_aux) = 'rti44ng_aux'
         reaction_Name(irti45gn_aux) = 'rti45gn_aux'
         reaction_Name(irti45ng_aux) = 'rti45ng_aux'
         reaction_Name(irti46gn_aux) = 'rti46gn_aux'

         reaction_Name(ir_ti46_ag_cr50) = 'r_ti46_ag_cr50'
         reaction_Name(ir_cr50_ga_ti46) = 'r_cr50_ga_ti46'
         reaction_Name(irti46ap_to_cr50) = 'rti46ap_to_cr50'
         reaction_Name(ircr50gp_to_ti46) = 'rcr50gp_to_ti46'
         reaction_Name(irti46ap_aux) = 'rti46ap_aux'
         reaction_Name(irv49pa_aux) = 'rv49pa_aux'
         reaction_Name(ircr50gp_aux) = 'rcr50gp_aux'
         reaction_Name(irv49pg_aux) = 'rv49pg_aux'
         reaction_Name(irti48p_to_cr50) = 'rti48p_to_cr50'
         reaction_Name(ircr50gp_to_ti48) = 'rcr50gp_to_ti48'
         reaction_Name(irti48pg_aux) = 'rti48pg_aux'
         reaction_Name(irv49gp_aux) = 'rv49gp_aux'
         reaction_Name(ircr48ap_to_cr50) = 'rcr48ap_to_cr50'
         reaction_Name(ircr50p_to_cr48) = 'rcr50p_to_cr48'
         reaction_Name(ircr48ap_aux) = 'rcr48ap_aux'
         reaction_Name(irmn51pa_aux) = 'rmn51pa_aux'
         reaction_Name(ircr50pg_aux) = 'rcr50pg_aux'
         reaction_Name(irmn51gp_aux) = 'rmn51gp_aux'
         reaction_Name(ircr48ng_to_cr50) = 'rcr48ng_to_cr50'
         reaction_Name(ircr50gn_to_cr48) = 'rcr50gn_to_cr48'
         reaction_Name(ircr48ng_aux) = 'rcr48ng_aux'
         reaction_Name(ircr49gn_aux) = 'rcr49gn_aux'
         reaction_Name(ircr49ng_aux) = 'rcr49ng_aux'
         reaction_Name(ircr50gn_aux) = 'rcr50gn_aux'

         reaction_Name(ir_cr50_ag_fe54) = 'r_cr50_ag_fe54'
         reaction_Name(ir_fe54_ga_cr50) = 'r_fe54_ga_cr50'
         reaction_Name(ircr50ap_to_fe54) = 'rcr50ap_to_fe54'
         reaction_Name(irfe54gp_to_cr50) = 'rfe54gp_to_cr50'
         reaction_Name(ircr50ap_aux) = 'rcr50ap_aux'
         reaction_Name(irmn53pa_aux) = 'rmn53pa_aux'
         reaction_Name(irfe54gp_aux) = 'rfe54gp_aux'
         reaction_Name(irmn53pg_aux) = 'rmn53pg_aux'
         reaction_Name(ircr52p_to_fe54) = 'rcr52p_to_fe54'
         reaction_Name(irfe54gp_to_cr52) = 'rfe54gp_to_cr52'
         reaction_Name(ircr52pg_aux) = 'rcr52pg_aux'
         reaction_Name(irmn53gp_aux) = 'rmn53gp_aux'

         reaction_Name(irne22an_to_mg24_2n) = 'rne22an_to_mg24_2n'
         reaction_Name(irne22ag_to_mg24_2n) = 'rne22ag_to_mg24_2n'
         reaction_Name(irne22ap_to_mg24_2n) = 'rne22ap_to_mg24_2n'

         reaction_Name(irti50ng_to_ti52) = 'rti50ng_to_ti52'
         reaction_Name(irti52gn_to_ti50) = 'rti52gn_to_ti50'
         reaction_Name(irti50ng_aux) = 'rti50ng_aux'
         reaction_Name(irti51gn_aux) = 'rti51gn_aux'
         reaction_Name(irti51ng_aux) = 'rti51ng_aux'
         reaction_Name(irti52gn_aux) = 'rti52gn_aux'
         reaction_Name(ircr54ng_to_cr56) = 'rcr54ng_to_cr56'
         reaction_Name(ircr56gn_to_cr54) = 'rcr56gn_to_cr54'
         reaction_Name(ircr54ng_aux) = 'rcr54ng_aux'
         reaction_Name(ircr55gn_aux) = 'rcr55gn_aux'
         reaction_Name(ircr55ng_aux) = 'rcr55ng_aux'
         reaction_Name(ircr56gn_aux) = 'rcr56gn_aux'
         
         reaction_Name(ircr48ec_to_ti48) = 'rcr48ec_to_ti48'
         reaction_Name(ircr50ec_to_ti50) = 'rcr50ec_to_ti50'
         reaction_Name(ircr52ec_to_ti52) = 'rcr52ec_to_ti52'
         reaction_Name(ircr54ec_to_ti52_2n) = 'rcr54ec_to_ti52_2n'
         reaction_Name(ircr56ec_to_ti52_4n) = 'rcr56ec_to_ti52_4n'
         reaction_Name(irti48ec_to_ca48) = 'rti48ec_to_ca48'
         reaction_Name(irti46ec_to_ca46) = 'rti46ec_to_ca46'
         reaction_Name(irti44ec_to_ca44) = 'rti44ec_to_ca44'
         reaction_Name(irti50ec_to_ca48_2n) = 'rti50ec_to_ca48_2n'
         reaction_Name(irti52ec_to_ca48_4n) = 'rti52ec_to_ca48_4n'
         reaction_Name(irfe52ec_to_cr52) = 'rfe52ec_to_cr52'
         
         reaction_Name(ircr54ee_to_fe54) = 'rcr54ee_to_fe54'
         reaction_Name(ircr56ee_to_fe56) = 'rcr56ee_to_fe56'

         reaction_Name(irfe56ee_to_ni56) = 'rfe56ee_to_ni56'
         reaction_Name(irti50ee_to_cr50) = 'rti50ee_to_cr50'
         reaction_Name(irti52ee_to_cr52) = 'rti52ee_to_cr52'
         reaction_Name(ircr52ee_to_fe52) = 'rcr52ee_to_fe52'
         
         reaction_Name(irfe54ec_to_cr54) = 'rfe54ec_to_cr54'
         reaction_Name(irfe56ec_to_cr56) = 'rfe56ec_to_cr56'
         
         reaction_Name(irfe58ec_to_cr56_2n) = 'rfe58ec_to_cr56_2n'
         reaction_Name(irfe60ec_to_cr56_4n) = 'rfe60ec_to_cr56_4n'

         reaction_Name(ircr54ap_to_fe58) = 'rcr54ap_to_fe58'
         reaction_Name(irfe58gp_to_cr54) = 'rfe58gp_to_cr54'
         reaction_Name(ircr54ap_to_cr56) = 'rcr54ap_to_cr56'
         reaction_Name(ircr56p_to_cr54) = 'rcr56p_to_cr54'
         reaction_Name(ircr56p_to_fe58) = 'rcr56p_to_fe58'
         reaction_Name(irfe58gp_to_cr56) = 'rfe58gp_to_cr56'
         reaction_Name(ircr54ap_aux) = 'rcr54ap_aux'
         reaction_Name(irmn57pa_aux) = 'rmn57pa_aux'
         reaction_Name(ircr56pg_aux) = 'rcr56pg_aux'
         reaction_Name(irmn57gp_aux) = 'rmn57gp_aux'
         reaction_Name(irfe58gp_aux) = 'rfe58gp_aux'
         reaction_Name(irmn57pg_aux) = 'rmn57pg_aux'
         reaction_Name(ircr56ap_to_fe60) = 'rcr56ap_to_fe60'
         reaction_Name(irfe60gp_to_cr56) = 'rfe60gp_to_cr56'
         reaction_Name(ircr56ap_to_cr58) = 'rcr56ap_to_cr58'
         reaction_Name(ircr58p_to_cr56) = 'rcr58p_to_cr56'
         reaction_Name(ircr58p_to_fe60) = 'rcr58p_to_fe60'
         reaction_Name(irfe60gp_to_cr58) = 'rfe60gp_to_cr58'
         reaction_Name(ircr56ap_aux) = 'rcr56ap_aux'
         reaction_Name(irmn59pa_aux) = 'rmn59pa_aux'
         reaction_Name(ircr58pg_aux) = 'rcr58pg_aux'
         reaction_Name(irmn59gp_aux) = 'rmn59gp_aux'
         reaction_Name(irfe60gp_aux) = 'rfe60gp_aux'
         reaction_Name(irmn59pg_aux) = 'rmn59pg_aux'

         reaction_Name(irca40ng_to_ca42) = 'rca40ng_to_ca42'
         reaction_Name(irca42gn_to_ca40) = 'rca42gn_to_ca40'
         reaction_Name(irca40ng_aux) = 'rca40ng_aux'
         reaction_Name(irca41ng_aux) = 'rca41ng_aux'
         reaction_Name(irca41gn_aux) = 'rca41gn_aux'
         reaction_Name(irca42gn_aux) = 'rca42gn_aux'

         reaction_Name(irca42ng_to_ca44) = 'rca42ng_to_ca44'
         reaction_Name(irca44gn_to_ca42) = 'rca44gn_to_ca42'
         reaction_Name(irca42ng_aux) = 'rca42ng_aux'
         reaction_Name(irca43ng_aux) = 'rca43ng_aux'
         reaction_Name(irca43gn_aux) = 'rca43gn_aux'
         reaction_Name(irca44gn_aux) = 'rca44gn_aux'

         reaction_Name(irca44ng_to_ca46) = 'rca44ng_to_ca46'
         reaction_Name(irca46gn_to_ca44) = 'rca46gn_to_ca44'
         reaction_Name(irca44ng_aux) = 'rca44ng_aux'
         reaction_Name(irca45ng_aux) = 'rca45ng_aux'
         reaction_Name(irca45gn_aux) = 'rca45gn_aux'
         reaction_Name(irca46gn_aux) = 'rca46gn_aux'

         reaction_Name(irca46ng_to_ca48) = 'rca46ng_to_ca48'
         reaction_Name(irca48gn_to_ca46) = 'rca48gn_to_ca46'
         reaction_Name(irca46ng_aux) = 'rca46ng_aux'
         reaction_Name(irca47ng_aux) = 'rca47ng_aux'
         reaction_Name(irca47gn_aux) = 'rca47gn_aux'
         reaction_Name(irca48gn_aux) = 'rca48gn_aux'

         reaction_Name(ircr48ng_to_cr50) = 'rcr48ng_to_cr50'
         reaction_Name(ircr50gn_to_cr48) = 'rcr50gn_to_cr48'
         reaction_Name(ircr48ng_aux) = 'rcr48ng_aux'
         reaction_Name(ircr49ng_aux) = 'rcr49ng_aux'
         reaction_Name(ircr49gn_aux) = 'rcr49gn_aux'
         reaction_Name(ircr50gn_aux) = 'rcr50gn_aux'

         reaction_Name(ircr50ng_to_cr52) = 'rcr50ng_to_cr52'
         reaction_Name(ircr52gn_to_cr50) = 'rcr52gn_to_cr50'
         reaction_Name(ircr50ng_aux) = 'rcr50ng_aux'
         reaction_Name(ircr51ng_aux) = 'rcr51ng_aux'
         reaction_Name(ircr51gn_aux) = 'rcr51gn_aux'
         reaction_Name(ircr52gn_aux) = 'rcr52gn_aux'

         reaction_Name(ircr52ng_to_cr54) = 'rcr52ng_to_cr54'
         reaction_Name(ircr54gn_to_cr52) = 'rcr54gn_to_cr52'
         reaction_Name(ircr52ng_aux) = 'rcr52ng_aux'
         reaction_Name(ircr53ng_aux) = 'rcr53ng_aux'
         reaction_Name(ircr53gn_aux) = 'rcr53gn_aux'
         reaction_Name(ircr54gn_aux) = 'rcr54gn_aux'

         reaction_Name(irti44ng_to_ti46) = 'rti44ng_to_ti46'
         reaction_Name(irti46gn_to_ti44) = 'rti46gn_to_ti44'
         reaction_Name(irti44ng_aux) = 'rti44ng_aux'
         reaction_Name(irti45ng_aux) = 'rti45ng_aux'
         reaction_Name(irti45gn_aux) = 'rti45gn_aux'
         reaction_Name(irti46gn_aux) = 'rti46gn_aux'

         reaction_Name(irti46ng_to_ti48) = 'rti46ng_to_ti48'
         reaction_Name(irti48gn_to_ti46) = 'rti48gn_to_ti46'
         reaction_Name(irti46ng_aux) = 'rti46ng_aux'
         reaction_Name(irti47ng_aux) = 'rti47ng_aux'
         reaction_Name(irti47gn_aux) = 'rti47gn_aux'
         reaction_Name(irti48gn_aux) = 'rti48gn_aux'

         reaction_Name(irti48ng_to_ti50) = 'rti48ng_to_ti50'
         reaction_Name(irti50gn_to_ti48) = 'rti50gn_to_ti48'
         reaction_Name(irti48ng_aux) = 'rti48ng_aux'
         reaction_Name(irti49ng_aux) = 'rti49ng_aux'
         reaction_Name(irti49gn_aux) = 'rti49gn_aux'
         reaction_Name(irti50gn_aux) = 'rti50gn_aux'

         reaction_Name(irv53ec_to_ti52_n) = 'rv53ec_to_ti52_n'
         reaction_Name(ircr54ec_to_v53_n) = 'rcr54ec_to_v53_n'
         reaction_Name(ircr55ec_to_v53_2n) = 'rcr55ec_to_v53_2n'

         reaction_Name(ircr56ec_to_v53_3n) = 'rcr56ec_to_v53_3n'

         reaction_Name(irfe59ec_to_mn57_2n) = 'rfe59ec_to_mn57_2n'
         reaction_Name(irni63ec_to_co61_2n) = 'rni63ec_to_co61_2n'
         reaction_Name(irni64ec_to_co61_3n) = 'rni64ec_to_co61_3n'
         reaction_Name(irfe60ec_to_mn57_3n) = 'rfe60ec_to_mn57_3n'
         reaction_Name(irmn57ec_to_cr56_n) = 'rmn57ec_to_cr56_n'
         reaction_Name(irfe58ec_to_mn57_n) = 'rfe58ec_to_mn57_n'
         reaction_Name(irco61ec_to_fe60_n) = 'rco61ec_to_fe60_n'
         reaction_Name(irni62ec_to_co61_n) = 'rni62ec_to_co61_n'
         reaction_Name(ircr55ec_to_ti52_3n) = 'rcr55ec_to_ti52_3n'     
         reaction_Name(irfe59ec_to_cr56_3n) = 'rfe59ec_to_cr56_3n'     
         reaction_Name(irfe57ec_to_cr56_n) = 'rfe57ec_to_cr56_n'     
         reaction_Name(irsc50ec_to_ca48_2n) = 'rsc50ec_to_ca48_2n'     
         reaction_Name(irsc51ec_to_ca48_3n) = 'rsc51ec_to_ca48_3n'     
         reaction_Name(irti52ec_to_sc51_n) = 'rti52ec_to_sc51_n'     
         reaction_Name(irv54ec_to_ti52_2n) = 'rv54ec_to_ti52_2n'     
         reaction_Name(irv55ec_to_ti52_3n) = 'rv55ec_to_ti52_3n'     
         reaction_Name(ircr56ec_to_v55_n) = 'rcr56ec_to_v55_n'     
         reaction_Name(irmn58ec_to_cr56_2n) = 'rmn58ec_to_cr56_2n'     
         reaction_Name(irmn59ec_to_cr56_3n) = 'rmn59ec_to_cr56_3n'     
         reaction_Name(irfe60ec_to_mn59_n) = 'rfe60ec_to_mn59_n'     
         reaction_Name(irco62ec_to_fe60_2n) = 'rco62ec_to_fe60_2n'     
         reaction_Name(irco63ec_to_fe60_3n) = 'rco63ec_to_fe60_3n'     
         reaction_Name(irco64ec_to_fe60_4n) = 'rco64ec_to_fe60_4n'     

         reaction_Name(irhe4_to_2h1_2neut) = 'rhe4_to_2h1_2neut'     
         reaction_Name(irhe4_from_2h1_2neut) = 'rhe4_from_2h1_2neut'     

         reaction_Name(irti44_ecnp_ca42) = 'rti44_ecnp_ca42'
         reaction_Name(irti46_ecnp_ca44) = 'rti46_ecnp_ca44'
         reaction_Name(irti48_ecnp_ca46) = 'rti48_ecnp_ca46'
         reaction_Name(irti50_ecnp_ca48) = 'rti50_ecnp_ca48'
         reaction_Name(irti52_ecnp_ca48) = 'rti52_ecnp_ca48'

         reaction_Name(ircr48_ecnp_ti46) = 'rcr48_ecnp_ti46'
         reaction_Name(ircr50_ecnp_ti48) = 'rcr50_ecnp_ti48'
         reaction_Name(ircr52_ecnp_ti50) = 'rcr52_ecnp_ti50'
         reaction_Name(ircr54_ecnp_ti52) = 'rcr54_ecnp_ti52'
         reaction_Name(ircr56_ecnp_ti52) = 'rcr56_ecnp_ti52'

         reaction_Name(irfe52_ecnp_cr50) = 'rfe52_ecnp_cr50'
         reaction_Name(irfe54_ecnp_cr52) = 'rfe54_ecnp_cr52'
         reaction_Name(irfe56_ecnp_cr54) = 'rfe56_ecnp_cr54'
         reaction_Name(irfe58_ecnp_cr56) = 'rfe58_ecnp_cr56'
         reaction_Name(irfe60_ecnp_cr56) = 'rfe60_ecnp_cr56'

         reaction_Name(irni56_ecnp_fe54) = 'rni56_ecnp_fe54'      
         reaction_Name(irni58_ecnp_fe56) = 'rni58_ecnp_fe56'      
         reaction_Name(irni60_ecnp_fe58) = 'rni60_ecnp_fe58'
         reaction_Name(irni62_ecnp_fe60) = 'rni62_ecnp_fe60'
         reaction_Name(irni64_ecnp_fe60) = 'rni64_ecnp_fe60'
     
         reaction_Name(irfe54an_to_ni58) = 'rfe54an_to_ni58'     
         reaction_Name(irni58gn_to_fe54) = 'rni58gn_to_fe54'     
         reaction_Name(irfe54an_to_ni56) = 'rfe54an_to_ni56'     
         reaction_Name(irni56ng_to_fe54) = 'rni56ng_to_fe54'     
         reaction_Name(irfe54an_aux) = 'rfe54an_aux'     
         reaction_Name(irni57na_aux) = 'rni57na_aux'     
     
         reaction_Name(irfe56an_to_ni60) = 'rfe56an_to_ni60'     
         reaction_Name(irni60gn_to_fe56) = 'rni60gn_to_fe56'     
         reaction_Name(irfe56an_to_ni58) = 'rfe56an_to_ni58'     
         reaction_Name(irni58ng_to_fe56) = 'rni58ng_to_fe56'     
         reaction_Name(irfe56an_aux) = 'rfe56an_aux'     
         reaction_Name(irni59na_aux) = 'rni59na_aux'     
     
         reaction_Name(irfe58an_to_ni62) = 'rfe58an_to_ni62'     
         reaction_Name(irni62gn_to_fe58) = 'rni62gn_to_fe58'     
         reaction_Name(irfe58an_to_ni60) = 'rfe58an_to_ni60'     
         reaction_Name(irni60ng_to_fe58) = 'rni60ng_to_fe58'     
         reaction_Name(irfe58an_aux) = 'rfe58an_aux'     
         reaction_Name(irni61na_aux) = 'rni61na_aux'     
     
         reaction_Name(ircr54an_to_fe58) = 'rcr54an_to_fe58'     
         reaction_Name(irfe58gn_to_cr54) = 'rfe58gn_to_cr54'     
         reaction_Name(ircr54an_to_fe56) = 'rcr54an_to_fe56'     
         reaction_Name(irfe56ng_to_cr54) = 'rfe56ng_to_cr54'     
         reaction_Name(ircr54an_aux) = 'rcr54an_aux'     
         reaction_Name(irfe57na_aux) = 'rfe57na_aux'     
     
         reaction_Name(ircr56an_to_fe60) = 'rcr56an_to_fe60'     
         reaction_Name(irfe60gn_to_cr56) = 'rfe60gn_to_cr56'     
         reaction_Name(ircr56an_to_fe58) = 'rcr56an_to_fe58'     
         reaction_Name(irfe58ng_to_cr56) = 'rfe58ng_to_cr56'     
         reaction_Name(ircr56an_aux) = 'rcr56an_aux'     
         reaction_Name(irfe59na_aux) = 'rfe59na_aux'     
     
         reaction_Name(ircr56pn_to_fe56) = 'rcr56pn_to_fe56'     
         reaction_Name(irfe56np_to_cr56) = 'rfe56np_to_cr56'     
         reaction_Name(ircr56pn_aux) = 'rcr56pn_aux'     
         reaction_Name(irmn56np_aux) = 'rmn56np_aux'     
         reaction_Name(irmn56pn_aux) = 'rmn56pn_aux'     
         reaction_Name(irfe56np_aux) = 'rfe56np_aux'     
     
         reaction_Name(ircr54pn_to_fe54) = 'rcr54pn_to_fe54'     
         reaction_Name(irfe54np_to_cr54) = 'rfe54np_to_cr54'     
         reaction_Name(ircr54pn_aux) = 'rcr54pn_aux'     
         reaction_Name(irmn54np_aux) = 'rmn54np_aux'     
         reaction_Name(irmn54pn_aux) = 'rmn54pn_aux'     
         reaction_Name(irfe54np_aux) = 'rfe54np_aux'     
     
         reaction_Name(irfe58pn_to_ni58) = 'rfe58pn_to_ni58'     
         reaction_Name(irni58np_to_fe58) = 'rni58np_to_fe58'     
         reaction_Name(irfe58pn_aux) = 'rfe58pn_aux'     
         reaction_Name(irco58np_aux) = 'rco58np_aux'     
         reaction_Name(irco58pn_aux) = 'rco58pn_aux'     
         reaction_Name(irni58np_aux) = 'rni58np_aux'     
     
         reaction_Name(irfe56pn_to_ni56) = 'rfe56pn_to_ni56'     
         reaction_Name(irni56np_to_fe56) = 'rni56np_to_fe56'     
         reaction_Name(irfe56pn_aux) = 'rfe56pn_aux'     
         reaction_Name(irco56np_aux) = 'rco56np_aux'     
         reaction_Name(irco56pn_aux) = 'rco56pn_aux'     
         reaction_Name(irni56np_aux) = 'rni56np_aux'     

         reaction_Name(ircr52ap_to_fe56) = 'rcr52ap_to_fe56'     
         reaction_Name(irfe56gp_to_cr52) = 'rfe56gp_to_cr52'     
         reaction_Name(ircr52ap_to_cr54) = 'rcr52ap_to_cr54'     
         reaction_Name(ircr54p_to_cr52) = 'rcr54p_to_cr52'     
         reaction_Name(ircr54p_to_fe56) = 'rcr54p_to_fe56'     
         reaction_Name(irfe56gp_to_cr54) = 'rfe56gp_to_cr54'     
         reaction_Name(ircr52ap_aux) = 'rcr52ap_aux'     
         reaction_Name(irmn55pa_aux) = 'rmn55pa_aux'     
         reaction_Name(irfe56gp_aux) = 'rfe56gp_aux'     
         reaction_Name(irmn55pg_aux) = 'rmn55pg_aux'     
         reaction_Name(ircr54pg_aux) = 'rcr54pg_aux'     
         reaction_Name(irmn55gp_aux) = 'rmn55gp_aux'     
     
         reaction_Name(ircr50ap_to_cr52) = 'rcr50ap_to_cr52'     
         reaction_Name(ircr52p_to_cr50) = 'rcr52p_to_cr50'     

         reaction_Name(irti52ap_to_cr56) = 'rti52ap_to_cr56'     
         reaction_Name(ircr56gp_to_ti52) = 'rcr56gp_to_ti52'     
         reaction_Name(irti52ap_to_ti54) = 'rti52ap_to_ti54'     
         reaction_Name(irti54p_to_ti52) = 'rti54p_to_ti52'     
         reaction_Name(irti54p_to_cr56) = 'rti54p_to_cr56'     
         reaction_Name(ircr56gp_to_ti54) = 'rcr56gp_to_ti54'     
         reaction_Name(irti52ap_aux) = 'rti52ap_aux'     
         reaction_Name(irv55pa_aux) = 'rv55pa_aux'     
         reaction_Name(ircr56gp_aux) = 'rcr56gp_aux'     
         reaction_Name(irv55pg_aux) = 'rv55pg_aux'     
         reaction_Name(irti54pg_aux) = 'rti54pg_aux'     
         reaction_Name(irv55gp_aux) = 'rv55gp_aux'     

         reaction_Name(irti50ap_to_cr54) = 'rti50ap_to_cr54'     
         reaction_Name(ircr54gp_to_ti50) = 'rcr54gp_to_ti50'     
         reaction_Name(irti50ap_to_ti52) = 'rti50ap_to_ti52'     
         reaction_Name(irti52p_to_ti50) = 'rti52p_to_ti50'     
         reaction_Name(irti52p_to_cr54) = 'rti52p_to_cr54'     
         reaction_Name(ircr54gp_to_ti52) = 'rcr54gp_to_ti52'     
         reaction_Name(irti50ap_aux) = 'rti50ap_aux'     
         reaction_Name(irv53pa_aux) = 'rv53pa_aux'     
         reaction_Name(ircr54gp_aux) = 'rcr54gp_aux'     
         reaction_Name(irv53pg_aux) = 'rv53pg_aux'     
         reaction_Name(irti52pg_aux) = 'rti52pg_aux'     
         reaction_Name(irv53gp_aux) = 'rv53gp_aux'     

         reaction_Name(irti48ap_to_cr52) = 'rti48ap_to_cr52'     
         reaction_Name(ircr52gp_to_ti48) = 'rcr52gp_to_ti48'     
         reaction_Name(irti48ap_to_ti50) = 'rti48ap_to_ti50'     
         reaction_Name(irti50p_to_ti48) = 'rti50p_to_ti48'     
         reaction_Name(irti50p_to_cr52) = 'rti50p_to_cr52'     
         reaction_Name(ircr52gp_to_ti50) = 'rcr52gp_to_ti50'     
         reaction_Name(irti48ap_aux) = 'rti48ap_aux'     
         reaction_Name(irv51pa_aux) = 'rv51pa_aux'     
         reaction_Name(ircr52gp_aux) = 'rcr52gp_aux'     
         reaction_Name(irv51pg_aux) = 'rv51pg_aux'     
         reaction_Name(irti50pg_aux) = 'rti50pg_aux'     
         reaction_Name(irv51gp_aux) = 'rv51gp_aux'     

         reaction_Name(irti46ap_to_ti48) = 'rti46ap_to_ti48'     
         reaction_Name(irti48p_to_ti46) = 'rti48p_to_ti46'     
     
         reaction_Name(ircr52an_to_fe56) = 'rcr52an_to_fe56'     
         reaction_Name(irfe56gn_to_cr52) = 'rfe56gn_to_cr52'     
         reaction_Name(ircr52an_to_fe54) = 'rcr52an_to_fe54'     
         reaction_Name(irfe54ng_to_cr52) = 'rfe54ng_to_cr52'     
         reaction_Name(ircr52an_aux) = 'rcr52an_aux'     
         reaction_Name(irfe55na_aux) = 'rfe55na_aux'     
     
         reaction_Name(ircr50an_to_fe54) = 'rcr50an_to_fe54'     
         reaction_Name(irfe54gn_to_cr50) = 'rfe54gn_to_cr50'     
         reaction_Name(ircr50an_to_fe52) = 'rcr50an_to_fe52'     
         reaction_Name(irfe52ng_to_cr50) = 'rfe52ng_to_cr50'     
         reaction_Name(ircr50an_aux) = 'rcr50an_aux'     
         reaction_Name(irfe53na_aux) = 'rfe53na_aux'     
     
         reaction_Name(irti52an_to_cr56) = 'rti52an_to_cr56'     
         reaction_Name(ircr56gn_to_ti52) = 'rcr56gn_to_ti52'     
         reaction_Name(irti52an_to_cr54) = 'rti52an_to_cr54'     
         reaction_Name(ircr54ng_to_ti52) = 'rcr54ng_to_ti52'     
         reaction_Name(irti52an_aux) = 'rti52an_aux'     
         reaction_Name(ircr55na_aux) = 'rcr55na_aux'     
     
         reaction_Name(irti50an_to_cr54) = 'rti50an_to_cr54'     
         reaction_Name(ircr54gn_to_ti50) = 'rcr54gn_to_ti50'     
         reaction_Name(irti50an_to_cr52) = 'rti50an_to_cr52'     
         reaction_Name(ircr52ng_to_ti50) = 'rcr52ng_to_ti50'     
         reaction_Name(irti50an_aux) = 'rti50an_aux'     
         reaction_Name(ircr53na_aux) = 'rcr53na_aux'     
     
         reaction_Name(irti48an_to_cr52) = 'rti48an_to_cr52'     
         reaction_Name(ircr52gn_to_ti48) = 'rcr52gn_to_ti48'     
         reaction_Name(irti48an_to_cr50) = 'rti48an_to_cr50'     
         reaction_Name(ircr50ng_to_ti48) = 'rcr50ng_to_ti48'     
         reaction_Name(irti48an_aux) = 'rti48an_aux'     
         reaction_Name(ircr51na_aux) = 'rcr51na_aux'     
     
         reaction_Name(irti46an_to_cr50) = 'rti46an_to_cr50'     
         reaction_Name(ircr50gn_to_ti46) = 'rcr50gn_to_ti46'     
         reaction_Name(irti46an_to_cr48) = 'rti46an_to_cr48'     
         reaction_Name(ircr48ng_to_ti46) = 'rcr48ng_to_ti46'     
         reaction_Name(irti46an_aux) = 'rti46an_aux'     
         reaction_Name(ircr49na_aux) = 'rcr49na_aux'     
     
         reaction_Name(ircr52pn_to_fe52) = 'rcr52pn_to_fe52'     
         reaction_Name(irfe52np_to_cr52) = 'rfe52np_to_cr52'     
         reaction_Name(ircr52pn_aux) = 'rcr52pn_aux'     
         reaction_Name(irmn52np_aux) = 'rmn52np_aux'     
         reaction_Name(irmn52pn_aux) = 'rmn52pn_aux'     
         reaction_Name(irfe52np_aux) = 'rfe52np_aux'     
     
         reaction_Name(irti52pn_to_cr52) = 'rti52pn_to_cr52'     
         reaction_Name(ircr52np_to_ti52) = 'rcr52np_to_ti52'     
         reaction_Name(irti52pn_aux) = 'rti52pn_aux'     
         reaction_Name(irv52np_aux) = 'rv52np_aux'     
         reaction_Name(irv52pn_aux) = 'rv52pn_aux'     
         reaction_Name(ircr52np_aux) = 'rcr52np_aux'     
     
         reaction_Name(irti50pn_to_cr50) = 'rti50pn_to_cr50'     
         reaction_Name(ircr50np_to_ti50) = 'rcr50np_to_ti50'     
         reaction_Name(irti50pn_aux) = 'rti50pn_aux'     
         reaction_Name(irv50np_aux) = 'rv50np_aux'     
         reaction_Name(irv50pn_aux) = 'rv50pn_aux'     
         reaction_Name(ircr50np_aux) = 'rcr50np_aux'     
     
         reaction_Name(irti48pn_to_cr48) = 'rti48pn_to_cr48'     
         reaction_Name(ircr48np_to_ti48) = 'rcr48np_to_ti48'     
         reaction_Name(irti48pn_aux) = 'rti48pn_aux'     
         reaction_Name(irv48np_aux) = 'rv48np_aux'     
         reaction_Name(irv48pn_aux) = 'rv48pn_aux'     
         reaction_Name(ircr48np_aux) = 'rcr48np_aux'     
     
         reaction_Name(irti44an_to_cr48) = 'rti44an_to_cr48'     
         reaction_Name(ircr48gn_to_ti44) = 'rcr48gn_to_ti44'     
         reaction_Name(irti44an_to_cr46) = 'rti44an_to_cr46'     
         reaction_Name(ircr46ng_to_ti44) = 'rcr46ng_to_ti44'     
         reaction_Name(irti44an_aux) = 'rti44an_aux'     
         reaction_Name(ircr47na_aux) = 'rcr47na_aux'     
     

         !reaction_Name(i) = ''     

         cnt = 0
         do i=1,num_predefined_reactions
            if (len_trim(reaction_Name(i)) == 0) then
               write(*,*) 'missing name for reaction', i
               if (i > 1) write(*,*) 'following ' // trim(reaction_Name(i-1))
               write(*,*) 
               cnt = cnt+1
            end if
         end do

         if (cnt > 0) stop 'set_reaction_names'

      end subroutine set_reaction_names

         
      end module rates_names


