      module test_rober
      use num_def
      use num_lib
      use test_int_support,only:i_nfcn,i_njac
      implicit none

      contains


      subroutine rober_derivs(n, x, vars, dvars_dx, lrpar,rpar,lipar,ipar, ierr)
         integer, intent(in) :: n, lrpar, lipar
         real(dp), intent(in) :: x
         real(dp), intent(inout) :: vars(n)
         real(dp), intent(out) :: dvars_dx(n)
         integer, intent(inout), pointer :: ipar(:) ! (lipar)
         real(dp), intent(inout), pointer :: rpar(:) ! (lrpar)
         real(dp) :: yprime(n)
         integer, intent(out) :: ierr
         ierr = 0
         ipar(i_nfcn) = ipar(i_nfcn) + 1
         call rober_feval(n,x,vars,yprime,dvars_dx,ierr,rpar,ipar)
      end subroutine rober_derivs


      subroutine rober_jacob(n,x,y,f,dfdy,ld_dfdy,lrpar,rpar,lipar,ipar,ierr)
         integer, intent(in) :: n, ld_dfdy, lrpar, lipar
         real(dp), intent(in) :: x
         real(dp), intent(inout) :: y(n)
         real(dp), intent(out) :: f(n), dfdy(ld_dfdy,n)
         integer, intent(inout), pointer :: ipar(:) ! (lipar)
         real(dp), intent(inout), pointer :: rpar(:) ! (lrpar)
         real(dp) :: yprime(n)
         integer, intent(out) :: ierr
         integer :: nz, i, j
         ierr = 0
         ipar(i_njac) = ipar(i_njac) + 1
         call rober_jeval(ld_dfdy,n,x,y,yprime,dfdy,ierr,rpar,ipar)
         if (ierr == 0) call rober_derivs(n, x, y, f, lrpar,rpar,lipar,ipar, ierr)
      end subroutine rober_jacob


      subroutine rober_sjac(n,x,y,f,nzmax,ia,ja,values,lrpar,rpar,lipar,ipar,ierr)  
         ! sparse jacobian. format either compressed row or compressed column.
         use mtx_lib,only:dense_to_row_sparse_with_diag,dense_to_col_sparse_with_diag
         use test_int_support,only:ipar_sparse_format
         integer, intent(in) :: n, nzmax, lrpar, lipar
         real(dp), intent(in) :: x
         real(dp), intent(inout) :: y(n)
         integer, intent(out) :: ia(n+1), ja(nzmax)
         real(dp), intent(out) :: f(n), values(nzmax)
         integer, intent(inout), pointer :: ipar(:) ! (lipar)
         real(dp), intent(inout), pointer :: rpar(:) ! (lrpar)
         integer, intent(out) :: ierr ! nonzero means terminate integration
         real(dp) :: dfdy(n,n)
         integer :: ld_dfdy, nz
         ld_dfdy = n
         ierr = 0
         call rober_jacob(n,x,y,f,dfdy,ld_dfdy,lrpar,rpar,lipar,ipar,ierr)
         if (ierr /= 0) return
         if (ipar(ipar_sparse_format) == 0) then
            call dense_to_row_sparse_with_diag(n,n,dfdy,nzmax,nz,ia,ja,values,ierr)
         else
            call dense_to_col_sparse_with_diag(n,n,dfdy,nzmax,nz,ia,ja,values,ierr)
         end if
      end subroutine rober_sjac
      
      
      subroutine do_test_rober(which_solver,which_decsol,numerical_jacobian,show_all,quiet)
         use test_support,only:show_results,show_statistics,check_results
         use test_int_support,only:do_test_stiff_int
         integer, intent(in) :: which_solver,which_decsol
         logical, intent(in) :: numerical_jacobian,show_all,quiet

         integer, parameter :: n = 3 ! the number of variables in the "rober" system of ODEs
         real(dp) :: y(n), yprime(n), yexact(n)
         integer, parameter :: lrpar = 1, lipar = 3, iout=1
         logical :: consis
         integer, parameter :: ndisc = 0
         real(dp) :: h0, t(0:ndisc+1), atol(1), rtol(1)
         integer :: i, mujac, mljac, matrix_type_spec, ierr, imas, mlmas, mumas, m1, m2, itol, nstep
         real(dp), target :: rpar_ary(lrpar) 
         integer, target :: ipar_ary(lipar)
         real(dp), pointer :: rpar(:)
         integer, pointer :: ipar(:)
         
         rpar => rpar_ary
         ipar => ipar_ary
            
         if (.not. quiet) write(*,*) 'rober'

         t(0)   = 0
         t(1)   = 1d11
         
         itol = 0 ! scalar tolerances
         rtol(1) = 1d-12
         atol(1) = 1d-12
         h0 = 1d-12 ! initial step size
         
         mljac = n ! square matrix
         mujac = n
         matrix_type_spec = square_matrix_type

         imas = 0
         mlmas = 0
         mumas = 0        
         
         m1 = 0
         m2 = 0     
         
         call rober_init(n,y,yprime,consis)
         nstep=0  
         call do_test_stiff_int(which_solver,which_decsol,numerical_jacobian, &
               rober_derivs,rober_jacob,rober_sjac,null_solout,iout, &
               n,ndisc,mljac,mujac,matrix_type_spec,null_mas,imas,mlmas,mumas,m1,m2, &
               t,rtol,atol,itol,h0,y,nstep,lrpar,rpar,lipar,ipar,quiet,ierr)
         if (ierr /= 0) then
            write(*,*) 'test_rober ierr', ierr
            stop 1
         end if
         
         call rober_solut(n,0d0,yexact)
         call check_results(n,y,yexact,rtol(1)*2,ierr)
         if (ierr /= 0) then
            write(*,*) 'check results ierr', ierr
            stop 1 ! do_test_vdpol
         end if
         
         if (quiet) return
         
         call show_results(n,y,yexact,show_all)
         call show_statistics(ipar(i_nfcn),ipar(i_njac),nstep,show_all)

      end subroutine do_test_rober
            
      
      end module test_rober
