      module test_medakzo
      use num_def
      use num_lib
      use test_int_support,only:i_nfcn,i_njac
      implicit none
      
      integer :: mljac, mujac

      contains


      subroutine medakzo_derivs(n, x, vars, dvars_dx, lrpar,rpar,lipar,ipar, ierr)
         integer, intent(in) :: n, lrpar, lipar
         real(dp), intent(in) :: x
         real(dp), intent(inout) :: vars(n)
         real(dp), intent(out) :: dvars_dx(n)
         integer, intent(inout), pointer :: ipar(:) ! (lipar)
         real(dp), intent(inout), pointer :: rpar(:) ! (lrpar)
         real(dp) :: yprime(n)
         integer, intent(out) :: ierr
         ierr = 0
         ipar(i_nfcn) = ipar(i_nfcn) + 1
         call medakzo_feval(n,x,vars,yprime,dvars_dx,ierr,rpar,ipar)
      end subroutine medakzo_derivs


      subroutine medakzo_jacob(n,x,y,f,dfdy,ld_dfdy,lrpar,rpar,lipar,ipar,ierr)
         integer, intent(in) :: n, ld_dfdy, lrpar, lipar
         real(dp), intent(in) :: x
         real(dp), intent(inout) :: y(n)
         real(dp), intent(out) :: f(n), dfdy(ld_dfdy,n)
         integer, intent(inout), pointer :: ipar(:) ! (lipar)
         real(dp), intent(inout), pointer :: rpar(:) ! (lrpar)
         real(dp) :: yprime(n)
         integer, intent(out) :: ierr
         integer :: nz, i, j
         ierr = 0
         ipar(i_njac) = ipar(i_njac) + 1
         call medakzo_jeval(ld_dfdy,n,x,y,yprime,dfdy,ierr,rpar,ipar)
         if (ierr == 0) call medakzo_derivs(n, x, y, f, lrpar,rpar,lipar,ipar, ierr)
         
         if (.false.) then
            write(*,*) 'medakzo_jacob'
            write(*,*) 'ld_dfdy', ld_dfdy
            write(*,*) 'n', n
            open(unit=33, file='medakzo_jacob.data', action='write', status='replace')
            write(33,*) ld_dfdy, n
            do i=1,ld_dfdy
               do j=1,n
                  write(33,*) dfdy(i,j)
               end do
            end do
            close(33)
            stop
         end if

      end subroutine medakzo_jacob


      subroutine medakzo_sjac(n,x,y,f,nzmax,ia,ja,values,lrpar,rpar,lipar,ipar,ierr)  
         ! sparse jacobian. format either compressed row or compressed column.
         use mtx_lib,only:band_to_row_sparse_with_diag,band_to_col_sparse_with_diag,mtx_rcond_banded
         use test_int_support,only:ipar_sparse_format
         integer, intent(in) :: n, nzmax, lrpar, lipar
         real(dp), intent(in) :: x
         real(dp), intent(inout) :: y(n)
         integer, intent(out) :: ia(n+1), ja(nzmax)
         real(dp), intent(out) :: f(n), values(nzmax)
         integer, intent(inout), pointer :: ipar(:) ! (lipar)
         real(dp), intent(inout), pointer :: rpar(:) ! (lrpar)
         integer, intent(out) :: ierr ! nonzero means terminate integration
         
         real(dp) :: dfdy(n,n)
         integer :: ld_dfdy, nz
         ld_dfdy = n
         ierr = 0
         call medakzo_jacob(n,x,y,f,dfdy,ld_dfdy,lrpar,rpar,lipar,ipar,ierr)
         if (ierr /= 0) return
         if (ipar(ipar_sparse_format) == 0) then
            call band_to_row_sparse_with_diag(n,mljac,mujac,dfdy,ld_dfdy,nzmax,nz,ia,ja,values,ierr)
         else
            call band_to_col_sparse_with_diag(n,mljac,mujac,dfdy,ld_dfdy,nzmax,nz,ia,ja,values,ierr)
         end if
      end subroutine medakzo_sjac
      
      
      subroutine do_test_medakzo(which_solver,which_decsol,numerical_jacobian,show_all,quiet)
         use test_support,only:show_results,show_statistics,check_results
         use test_int_support,only:do_test_stiff_int
         integer, intent(in) :: which_solver,which_decsol
         logical, intent(in) :: numerical_jacobian,show_all,quiet

         integer, parameter :: n = 400 ! the number of variables in the "medakzo" system of ODEs
         real(dp) :: y(n), yprime(n), yexact(n)
         integer, parameter :: lrpar = 1, lipar = 3, iout=1
         logical :: consis
         integer, parameter :: ndisc = 1, n_soln=11
         real(dp) :: result(n_soln), soln(n_soln), h0, t(0:ndisc+1), atol(1), rtol(1)
         integer :: i, j, k, matrix_type_spec, ierr, imas, mlmas, mumas, m1, m2, itol, nstep
         real(dp), target :: rpar_ary(lrpar) 
         integer, target :: ipar_ary(lipar)
         real(dp), pointer :: rpar(:)
         integer, pointer :: ipar(:)
         
         logical, parameter :: dbg = .false.
         
         rpar => rpar_ary
         ipar => ipar_ary

         include 'formats.dek'
            
         if (.not. quiet) write(*,*) 'medakzo'

         t(0)   = 0d0
         if (dbg) then
            t(1)   = 0.05d0
            t(2)   = 0.20d0
         else
            t(1)   = 5d0
            t(2)   = 20d0
         end if
         
         itol = 0 ! scalar tolerances
         rtol = 1d-6
         atol = 1d-6
         h0 = 1d-9 ! initial step size
         
         matrix_type_spec = banded_matrix_type
         mljac = 2
         mujac = 2

         imas = 0
         mlmas = 0
         mumas = 0        
         
         m1 = 0
         m2 = 0     
         
         call medakzo_init(n,y,yprime,consis)
         nstep=0        

         call do_test_stiff_int(which_solver,which_decsol,numerical_jacobian, &
               medakzo_derivs,medakzo_jacob,medakzo_sjac,null_solout,iout, &
               n,ndisc,mljac,mujac,matrix_type_spec,null_mas,imas,mlmas,mumas,m1,m2, &
               t,rtol,atol,itol,h0,y,nstep,lrpar,rpar,lipar,ipar,quiet,ierr)
         if (ierr /= 0) then
            write(*,*) 'test_medakzo ierr', ierr
            stop 1
         end if
         
         call medakzo_solut(n,0d0,yexact)
         j = 1
			do k = 1, n/2, (n/2-1)/11
			   if (j > n_soln) exit
			   result(j) = y(1+2*(k-1))
			   soln(j) = yexact(1+2*(k-1))
			   j = j+1
			end do

         if (.not. dbg) then
            call check_results(n,y,yexact,rtol(1)*50,ierr)
            if (ierr /= 0) then
               write(*,*) 'check results ierr', ierr
               !stop 1 ! do_test_medakzo
            end if
         end if
         
         if (quiet) return
         
         call show_results(n_soln,result,soln,show_all)
         call show_statistics(ipar(i_nfcn),ipar(i_njac),nstep,show_all)

      end subroutine do_test_medakzo
            
      
      end module test_medakzo
