
      subroutine vdpol3_x_init(neqn,y,yprime,consis)
      integer neqn
      double precision y(neqn),yprime(neqn)
      logical consis
      
      integer, parameter :: n = 12, m1 = n/2, m2 = m1

      ! the primary variables
      y(1) = 2d0
      y(2) = 0d0
      
      y(3) = 2d0
      y(4) = 0d0
      
      y(5) = 2d0
      y(6) = 0d0
      
      ! the auxiliary variables
      ! y(i+m2) = dy(i)/dt for i=1,...,m1
      y(1+m2) = 0d0
      y(2+m2) = 0d0
      
      y(3+m2) = 0d0
      y(4+m2) = 0d0
      
      y(5+m2) = 0d0
      y(6+m2) = 0d0
      
      return
      end


      subroutine vdpol3_x_feval(neqn,t,y,yprime,f,ierr,rpar,ipar)
      integer neqn,ierr,ipar(*)
      double precision t,y(neqn),yprime(neqn),f(neqn),rpar(*)
      
      integer, parameter :: n = 12, m1 = n/2, m2 = m1
      integer :: i
      
      ! f(y(i)) = d(y(i))/dt = y(i+m2) for i=1,...,m1
      do i=1,m1
         f(i) = y(i+m2)
      end do

      ! the mass matrix is 0 for the following equations.
      ! therefore the solver will make f(i+m2)=0 for i=m1+1,...,n
      f(1+m2) = y(1+m2) - y(2)
      f(2+m2) = y(2+m2) - ((1-y(1)**2)*y(2)-y(1))/1.0d-3
      
      f(3+m2) = y(3+m2) - y(4)
      f(4+m2) = y(4+m2) - ((1-y(3)**2)*y(4)-y(3))/1.0d-3
      
      f(5+m2) = y(5+m2) - y(6)
      f(6+m2) = y(6+m2) - ((1-y(5)**2)*y(6)-y(5))/1.0d-3
      
      return
      end


      subroutine vdpol3_x_jeval(ldim,neqn,t,y,yprime,dfdy,ierr,rpar,ipar)
      integer ldim,neqn,ierr,ipar(*)
      double precision t,y(neqn),yprime(neqn),dfdy(ldim,neqn),rpar(*)

      integer, parameter :: n = 12, m1 = n/2, m2 = m1, mm = m1/m2
      integer, parameter :: mujac = 1, mljac = 1
      integer :: i
      
      ! dfdy(i-j+mujac+1,j+k*m2) = partial f(i+m1) / partial y(j+k*m2)
      ! for i=1,mljac+mujac+1 and j=1,m2 and k=0,mm.

      ! dfdy(i-j+mujac+1,j) = partial f(i+m1) / partial y(j)
      
      ! above diagonal (i = j-1)
      dfdy(1,2) = -1d0
      dfdy(1,4) = -1d0
      dfdy(1,6) = -1d0
      
      ! diagonal (i = j)
      dfdy(2,1) = 0d0
      dfdy(2,2) = -(1d0-y(1)**2)/1.0d-3
      dfdy(2,3) = 0d0
      dfdy(2,4) = -(1d0-y(3)**2)/1.0d-3
      dfdy(2,5) = 0d0
      dfdy(2,6) = -(1d0-y(5)**2)/1.0d-3

      ! below diagonal (i = j+1)
      dfdy(3,1) = -(-2.0d0*y(1)*y(2)-1d0)/1.0d-3
      dfdy(3,3) = -(-2.0d0*y(3)*y(4)-1d0)/1.0d-3
      dfdy(3,5) = -(-2.0d0*y(5)*y(6)-1d0)/1.0d-3

      
      ! dfdy(i-j+mujac+1,j+m2) = partial f(i+m1) / partial y(j+m2)
      do j=1,m1
         dfdy(mujac+1,j+m2) = 1
      end do
      
      return
      end


      subroutine vdpol3_x_solut(neqn,t,y)
      integer neqn
      double precision t,y(neqn)
      ! note -- this is for stiffness param = 1d-3
      y(1) =  1.7632345401889102d+00           
      y(2) = -8.3568868191466206d-01

      y(3) =  1.7632345401889102d+00           
      y(4) = -8.3568868191466206d-01

      y(5) =  1.7632345401889102d+00           
      y(6) = -8.3568868191466206d-01
      return
      end
