c-----------------------------------------------------------------------
c-----------------------------------------------------------------------
c
c     This file is part of the Test Set for IVP solvers
c     http://www.dm.uniba.it/~testset/
c
c        Problem ROBERTSON
c        ODE of dimension 3
c
c     DISCLAIMER: see
c     http://www.dm.uniba.it/~testset/disclaimer.php
c
c     The most recent version of this source file can be found at
c     http://www.dm.uniba.it/~testset/src/problems/rober.f
c
c     This is revision
c     $Id: rober.F,v 1.2 2006/10/02 10:29:14 testset Exp $
c
c-----------------------------------------------------------------------
      subroutine rober_init(neqn,y,yprime,consis)
      integer neqn
      double precision y(neqn),yprime(neqn)
      logical consis

      y(1) = 1d0
      y(2) = 0d0
      y(3) = 0d0

      return
      end
c-----------------------------------------------------------------------
      subroutine rober_feval(neqn,t,y,yprime,f,ierr,rpar,ipar)
      integer neqn,ierr,ipar(*)
      double precision t,y(neqn),yprime(neqn),f(neqn),rpar(*)

      f(1) = -0.04d0*y(1)+1d4*y(2)*y(3)
      f(2) = 0.04d0*y(1)-1d4*y(2)*y(3)-3d7*y(2)**2
      f(3) =3d7*y(2)**2
      
      return
      end
c-----------------------------------------------------------------------
      subroutine rober_jeval(ldim,neqn,t,y,yprime,dfdy,ierr,rpar,ipar)
      integer ldim,neqn,ierr,ipar(*)
      double precision t,y(neqn),yprime(neqn),dfdy(ldim,neqn),rpar(*)

      integer i,j

      do 20 j=1,neqn
         do 10 i=1,neqn
            dfdy(i,j)=0d0
   10    continue
   20 continue

      dfdy(1,1) = -0.04d0
      dfdy(1,2) = 1d4*y(3)
      dfdy(1,3) = 1d4*y(2)
      dfdy(2,1) = 0.04d0
      dfdy(2,2) = -1d4*y(3)-6d7*y(2)
      dfdy(2,3) = -1d4*y(2)
      dfdy(3,2) = 6d7*y(2)

      return
      end
c-----------------------------------------------------------------------
      subroutine rober_solut(neqn,t,y)
      integer neqn
      double precision t,y(neqn)
c
c computed using double precision RADAU on an 
c     Alphaserver DS20E, with a 667 MHz EV67 processor.
c          
c          uround = 1.01d-19
c          rtol = atol = h0 = 1.1d-18
c
c
         
       y(1) =  0.2083340149701255D-07           
       y(2) =  0.8333360770334713D-13           
       y(3) =  0.9999999791665050D+00            

      return
      end
