! ***********************************************************************
!
!   Copyright (C) 2013  Frank Timmes, Bill Paxton
!
!   MESA is free software; you can use it and/or modify
!   it under the combined terms and restrictions of the MESA MANIFESTO
!   and the GNU General Library Public License as published
!   by the Free Software Foundation; either version 2 of the License,
!   or (at your option) any later version.
!
!   You should have received a copy of the MESA MANIFESTO along with
!   this software; if not, it is available at the mesa website:
!   http://mesa.sourceforge.net/
!
!   MESA is distributed in the hope that it will be useful,
!   but WITHOUT ANY WARRANTY; without even the implied warranty of
!   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
!   See the GNU Library General Public License for more details.
!
!   You should have received a copy of the GNU Library General Public License
!   along with this software; if not, write to the Free Software
!   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
!
! ***********************************************************************
 

      module nse_def
      use const_def, only: dp
      
      implicit none
      
         
      !real(dp), parameter :: min_T_for_NSE = 2.5d9 ! logT ~= 9.4
      real(dp), parameter :: min_T_for_NSE = 2d9 ! logT ~= 9.3
      real(dp), parameter :: min_lnT_for_NSE = log(min_T_for_NSE)

      integer :: nse_net_handle, nse_species, nse_num_reactions, &
         nse_num_weaklib_rates, max_nse_Z
      integer, pointer, dimension(:) :: &
         nse_chem_id, nse_net_iso, nse_reaction_id, nse_index, &
         nse_weak_reaction_num, nse_weak_reaction_index, nse_weaklib_ids
      character (len=256) :: nse_net_name




      
      contains   


      subroutine nse_def_init(trace, ierr)
         use const_def, only: mesa_data_dir
         use net_def
         use net_lib
         use rates_def
         use rates_lib
         use weak_def
         use weak_lib
         use num_lib, only: qsort
         
         logical, intent(in) :: trace
         integer, intent(out) :: ierr
         
         integer :: cid_lhs, cid_rhs, j, i, ir, nse_cid, nse_Z, nse_N
         real(dp), pointer :: sort_values(:)
         
         include 'formats.dek'
         
         nse_net_name = trim(mesa_data_dir) // '/net_data/nets/nse.net'
         
         nse_net_handle = alloc_net_handle(ierr)
         if (ierr /= 0) return   
         
         call net_start_def(nse_net_handle, ierr)
         if (ierr /= 0) then
            write(*,*) 'failed in net_start_def'
            return
         end if

         call read_net_file(nse_net_name, nse_net_handle, ierr)
         if (ierr /= 0) then
            write(*,*) 'failed in read_net_file ' // trim(nse_net_name)
            return
         end if
         
         call net_finish_def(nse_net_handle, ierr)
         if (ierr /= 0) then
            write(*,*) 'failed in net_finish_def'
            return
         end if
         
         nse_species = net_num_isos(nse_net_handle, ierr)
         if (ierr /= 0) then
            write(*,*) 'failed in net_num_isos'
            return
         end if
         
         call get_chem_id_table_ptr(nse_net_handle, nse_chem_id, ierr)
         if (ierr /= 0) then
            write(*,*) 'failed in get_chem_id_table_ptr'
            return
         end if

         if (trace) then
            write(*,*) 'species in nse net'
            do j=1,nse_species
               write(*,'(i6,3x,a)') j, chem_isos% name(nse_chem_id(j))
            end do
            write(*,*)
         end if
         
         call get_net_iso_table_ptr(nse_net_handle, nse_net_iso, ierr)
         if (ierr /= 0) then
            write(*,*) 'failed in get_net_iso_table_ptr'
            return
         end if
         
         nse_num_reactions = net_num_reactions(nse_net_handle, ierr)
         if (ierr /= 0) then
            write(*,*) 'failed in net_num_reactions'
            return
         end if
         
         call get_reaction_id_table_ptr(nse_net_handle, nse_reaction_id, ierr)
         if (ierr /= 0) then
            write(*,*) 'failed in get_reaction_id_table_ptr'
            return
         end if

         nse_num_weaklib_rates = 0
         do j = 1, nse_num_reactions
            i = nse_reaction_id(j)
            if (weak_reaction_info(1,i) > 0 .and. &
                weak_reaction_info(2,i) > 0) then
               nse_num_weaklib_rates = nse_num_weaklib_rates + 1
            end if
         end do

         allocate( &
            nse_weak_reaction_num(nse_num_weaklib_rates), &
            nse_weaklib_ids(nse_num_weaklib_rates), &
            nse_weak_reaction_index(nse_num_reactions), &
            nse_index(nse_species), sort_values(nse_species), stat=ierr)
         if (ierr /= 0) then
            write(*,*) 'failed in allocate'
            return
         end if

         j = 0    
         nse_weak_reaction_index(:) = 0
         do i = 1, nse_num_reactions
            ir = nse_reaction_id(i)
            if (weak_reaction_info(1,ir) <= 0 .or. &
                weak_reaction_info(2,ir) <= 0) cycle
            j = j + 1
            nse_weak_reaction_index(i) = j
            nse_weak_reaction_num(j) = i
            cid_lhs = weak_reaction_info(1,ir)
            cid_rhs = weak_reaction_info(2,ir)
            nse_weaklib_ids(j) = &
               get_weak_rate_id(chem_isos% name(cid_lhs), chem_isos% name(cid_rhs))
            if (nse_weaklib_ids(j) == 0) then
               !write(*,2) 'failed to find ' // trim(reaction_Name(ir))
               j = j - 1
               nse_num_weaklib_rates = nse_num_weaklib_rates - 1
            else
               if (.false.) write(*,'(a,i5)') &
                  trim(chem_isos% name(cid_lhs)) // ' => ' // &
                  trim(chem_isos% name(cid_rhs)), j
            end if
         end do
         if (.false.) write(*,2) 'nse_num_weaklib_rates', nse_num_weaklib_rates
         
         max_nse_Z = 0
         do i=1,nse_species
            nse_cid = nse_chem_id(i)
            nse_Z = chem_isos% Z(nse_cid)
            nse_N = chem_isos% N(nse_cid)
            sort_values(i) = 1000*nse_Z + nse_N
            if (nse_Z > max_nse_Z) max_nse_Z = nse_Z
         end do
         call qsort(nse_index, nse_species, sort_values)
         deallocate(sort_values)
      
      end subroutine nse_def_init
      
      
      

      end module nse_def

