      FUNCTION VCOOL(RHO,T,UE,PLAS,PHOT,PAIR)
C
C     Gives the neutrino cooling rate due to all three processes,
C    pair, photo, and plasma from Schinder et al. (apJ 313, 531, 1987),
C    which are valid from 10^8-10^10 K ( they also give fitting formulae
C    for higher temperatures 10^10  - 10^11), but we are not putting that
C    in right now. 
C
C
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      DIMENSION RAT(3) 
      IF(T.GT.1E11.OR.T.LT.1E8) THEN
c         WRITE(6,*) ' CALLING NEUTRINO COOLING OUT OF BOUNDS'
         VCOOL=0.0D0 
         RETURN
      END IF
      AL=T/5.9302E9
      ALI=(1.0D0/AL)
      ALI2=ALI*ALI
      ALI3=ALI2*ALI
      S=ALI*(RHO/(UE*1E9))**(1.0D0/3.0D0)
      S2=S*S
      S3=S*S*S
C
C     Determine the plasma cooling rate
C
      TOP=LOG(2.146E-7+7.814E-8*S+1.653E-8*S2)
      BOT=LOG(S3+2.581E-2*ALI+1.734E-2*ALI2+6.990E-4*ALI3)
      RAT(1)=((RHO/UE)**3.0)*EXP(-0.56457*S+TOP-BOT)
C
C     DetermNine the photo cooling rate
C
      IF(RHO.LT.1E11) THEN 
      TOP=LOG(3.897E10+5.906E10*S+4.693E10*S2)
      BOT=LOG(S3+6.290E-3*ALI+7.483E-3*ALI2+3.061E-4*ALI3)
      RAT(2)=(RHO/UE)*(AL**5)*EXP(-1.5654*S+TOP-BOT)
      ELSE
        RAT(2)=0.0D0
      ENDIF
C
C     Determine the pair cooling rate
C
      TOP=LOG(5.026E19+1.745E20*S+1.568E21*S2)
      IF(T.LT.1E10) THEN
         BOT=LOG(S3+9.383E-1*ALI-4.141E-1*ALI2+5.829E-2*ALI3)
      ELSE
         BOT=LOG(S3+1.2383*ALI-8.141E-1*ALI2)
      ENDIF
      GG=1.0D0-13.04*AL**2+
     $   133.5*AL**4+1534*AL**6+918.6*AL**8
      IF(T.LT.1E10) THEN
         RAT(3)=GG*EXP(-(2.0/AL)-5.5924*S+TOP-BOT)
      ELSE
         RAT(3)=GG*EXP(-(2.0/AL)-4.9924*S+TOP-BOT)
      ENDIF
C
C     The rates tabulated at this point are in ergs/cm^3/sec,
C     so divide by density to get them into ergs/gr/sec
C
      PLAS = RAT(1)/RHO
      PHOT = RAT(2)/RHO
      PAIR = RAT(3)/RHO
      VCOOL = PLAS + PHOT + PAIR
      
      RETURN
      END
