! ***********************************************************************
!
!   Copyright (C) 2009  Bill Paxton, Frank Timmes
!
!   This file is part of MESA.
!
!   MESA is free software; you can redistribute it and/or modify
!   it under the terms of the GNU General Library Public License as published
!   by the Free Software Foundation; either version 2 of the License, or
!   (at your option) any later version.
!
!   MESA is distributed in the hope that it will be useful, 
!   but WITHOUT ANY WARRANTY; without even the implied warranty of
!   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
!   GNU Library General Public License for more details.
!
!   You should have received a copy of the GNU Library General Public License
!   along with this software; if not, write to the Free Software
!   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
!
! ***********************************************************************

      module mod_test_net
      
      implicit none
         

      contains

      
      subroutine test(quiet)
         use chem_lib
         use net_def
         use net_lib
         use reaclib_lib, only: reaclib_init
         use weak_lib, only: weak_init
         use ecapture_lib, only: ecapture_init
         use rates_lib, only: rates_init
         use screen_def
         use const_lib
         use const_def, only: mesa_dir
         use test_burn
         use test_burn_const_P
         use test_net_support
         
         logical, intent(in) :: quiet
         character (len=64) :: my_mesa_dir
         
         integer :: ierr
      	
      	qt = quiet
      
         my_mesa_dir = '../..'
         call const_init(my_mesa_dir,ierr)     
      	if (ierr /= 0) then
      	   write(*,*) 'const_init failed'
      	   stop 1
      	end if        

      	ierr = 0
      	call chem_init('isotopes.data', ierr)
      	if (ierr /= 0) then
      	   write(*,*) 'chem_init failed'
      	   stop 1
      	end if
         
         call reaclib_init(ierr)   
      	if (ierr /= 0) then
      	   write(*,*) 'reaclib_init failed'
      	   stop 1
      	end if
   	
      	call weak_init('', ierr)   
      	if (ierr /= 0) then
      	   write(*,*) 'weak_init failed'
      	   stop 1
      	end if

        call ecapture_init(ierr)
      	if (ierr /= 0) then
      	   write(*,*) 'ecapture_init failed'
      	   stop 1
      	end if

         call rates_init('reactions.list', '', ierr)

         if (ierr /= 0) stop 1
         which_rates_choice = rates_NACRE_if_available
      
         test_logT = 7.5d0
         test_logRho = 2d0
         screening_mode = classic_screening
      
         if (.false.) then
            which_rates_choice = rates_JR_if_available
            call Do_One_Test_Burn('approx20.net',.true.)
            stop
         end if
      
         if (.false.) then
            call Do_One_Test_Burn_Const_P('approx20.net',.true.)
            stop
         end if
      
         if (.false.) then
            which_rates_choice = rates_JR_if_available
            call Do_One_Test_Burn('pp_and_cno_extras.net',.true.)
            stop
         end if
      
         if (.false.) then
            call Do_One_Test_Burn('19_to_ni56.net',.true.)
            stop
         end if
      
         if (.false.) then
            which_rates_choice = rates_JR_if_available
            call Do_One_Test_Burn('o18_to_mg26.net',.true.)
            stop
         end if
      
         if (.false.) then
            which_rates_choice = rates_JR_if_available
            call Do_One_Test('basic.net',.false.)
            stop
         end if
      
         if (.false.) then
            call Do_One_Test('approx21.net',.false.)
            stop
         end if
      
         if (.false.) then
            call Do_One_Test('approx29.net',.false.)
            stop
         end if
      
         if (.false.) then
            call Do_One_Test_and_show_Qs('pp_and_cno_extras.net',.false.)
            stop
         end if
      
         if (.false.) then
            call Do_One_Test('wd_o_ne_ignite.net',.false.)
            stop
         end if
      
         if (.not. qt) write(*,*) ' **************** Basic **************** '
      
         call test_net_setup('basic.net')
         call do_test_net(.false.,.false.)

         if (.not. qt) write(*,*)
         if (.not. qt) write(*,*)
         if (.not. qt) write(*,*) ' **************** o18_and_ne22 **************** '
      
         call change_net('o18_and_ne22.net')
         call do_test_net(.false.,.false.)    
      
         if (.not. qt) write(*,*)
         if (.not. qt) write(*,*)
         if (.not. qt) write(*,*) ' **************** pp_extras **************** '
      
         call change_net('pp_extras.net')
         call do_test_net(.false.,.false.)      
      
         if (.not. qt) write(*,*)
         if (.not. qt) write(*,*)
         if (.not. qt) write(*,*) ' **************** cno_extras **************** '
      
         call change_net('cno_extras.net')
         call do_test_net(.false.,.false.)      
         
         if (.false.) then
            
            call Do_One_Test_Burn('approx21.net',.false.)
            if (.not. qt) write(*,*)
      
            call Do_One_Test_Burn_Const_P('approx21.net',.false.)
            if (.not. qt) write(*,*)
         
         end if

         call test_net_cleanup
         call net_shutdown
         if (.not. qt) write(*,*)
      
      
      end subroutine test

      
      end module mod_test_net




