! ***********************************************************************
!
!   Copyright (C) 2010  Bill Paxton
!
!   MESA is free software; you can use it and/or modify
!   it under the combined terms and restrictions of the MESA MANIFESTO
!   and the GNU General Library Public License as published
!   by the Free Software Foundation; either version 2 of the License,
!   or (at your option) any later version.
!
!   You should have received a copy of the MESA MANIFESTO along with
!   this software; if not, it is available at the mesa website:
!   http://mesa.sourceforge.net/
!
!   MESA is distributed in the hope that it will be useful,
!   but WITHOUT ANY WARRANTY; without even the implied warranty of
!   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
!   See the GNU Library General Public License for more details.
!
!   You should have received a copy of the GNU Library General Public License
!   along with this software; if not, write to the Free Software
!   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
!
! ***********************************************************************
! ***********************************************************************

      module net_combos_support
      use net_def
      use const_def
      use chem_def
      use rates_def
      use net_derivs_support

      implicit none
      
      contains


      subroutine get_rates_for_v49_combos( ! also does ti46(a,g)cr50  
     >      n, g, den, temp, T9, T932, y, num_reactions, rate_factors,
     >      d_rti48prot_to_cr50_dprot, d_rcr50gprot_to_ti48_dprot,
     >      d_rti46aprot_to_ti48_dprot, d_rti48prot_to_ti46_dprot,
     >      d_rti46aprot_to_cr50_dprot, d_rcr50gprot_to_ti46_dprot)    
         type (Net_Info), pointer :: n
         type (Net_General_Info), pointer  :: g
         real(dp), pointer :: y(:)
         integer, intent(in) :: num_reactions
         real(dp), intent(in) ::    
     >      den, temp, T9, T932, rate_factors(:) ! (num_reactions)         
         real(dp), intent(out) ::    
     >      d_rti48prot_to_cr50_dprot, d_rcr50gprot_to_ti48_dprot,
     >      d_rti46aprot_to_ti48_dprot, d_rti48prot_to_ti46_dprot,
     >      d_rti46aprot_to_cr50_dprot, d_rcr50gprot_to_ti46_dprot
         call get_rates_for_ap_combos(  
     >      n, g, .true., den, temp, T9, T932, y, num_reactions, rate_factors,
     >      iti46, iti48, iv49, icr50,
     >      ir_ti46_ag_cr50, ! ti46(a,g)cr50
     >      ir_cr50_ga_ti46, ! cr50(g,a)ti46      
     >      irti46ap_to_cr50, ! ti46(a,p)v49(p,g)cr50
     >      ircr50gp_to_ti46, ! cr50(g,p)v49(p,a)ti46      
     >      irti46ap_to_ti48, ! ti46(a,p)v49(g,p)ti48
     >      irti48p_to_ti46, ! ti48(p,g)v49(p,a)ti46     
     >      irti48p_to_cr50, ! ti48(p,g)v49(p,g)cr50
     >      ircr50gp_to_ti48, ! cr50(g,p)v49(g,p)ti48      
     >      irti46ap_aux, ! ti46(a,p)v49 
     >      irv49pa_aux, ! v49(p,a)ti46 
     >      irti48pg_aux, ! ti48(p,g)v49
     >      irv49gp_aux, ! v49(g,p)ti48 
     >      ircr50gp_aux, ! cr50(g,p)v49 
     >      irv49pg_aux, ! v49(p,g)cr50 
     >      d_rti48prot_to_cr50_dprot, d_rcr50gprot_to_ti48_dprot,
     >      d_rti46aprot_to_ti48_dprot, d_rti48prot_to_ti46_dprot,
     >      d_rti46aprot_to_cr50_dprot, d_rcr50gprot_to_ti46_dprot)
      end subroutine get_rates_for_v49_combos


      subroutine get_rates_for_v51_combos( ! also does ti48(a,g)cr52  
     >      n, g, den, temp, T9, T932, y, num_reactions, rate_factors,
     >      d_rti50prot_to_cr52_dprot, d_rcr52gprot_to_ti50_dprot,
     >      d_rti48aprot_to_ti50_dprot, d_rti50prot_to_ti48_dprot,
     >      d_rti48aprot_to_cr52_dprot, d_rcr52gprot_to_ti48_dprot)    
         type (Net_Info), pointer :: n
         type (Net_General_Info), pointer  :: g
         real(dp), pointer :: y(:)
         integer, intent(in) :: num_reactions
         real(dp), intent(in) ::    
     >      den, temp, T9, T932, rate_factors(:) ! (num_reactions)         
         real(dp), intent(out) ::    
     >      d_rti50prot_to_cr52_dprot, d_rcr52gprot_to_ti50_dprot,
     >      d_rti48aprot_to_ti50_dprot, d_rti50prot_to_ti48_dprot,
     >      d_rti48aprot_to_cr52_dprot, d_rcr52gprot_to_ti48_dprot
         call get_rates_for_ap_combos(  
     >      n, g, .true., den, temp, T9, T932, y, num_reactions, rate_factors,
     >      iti48, iti50, iv51, icr52,
     >      ir_ti48_ag_cr52, ! ti48(a,g)cr52
     >      ir_cr52_ga_ti48, ! cr52(g,a)ti48      
     >      irti48ap_to_cr52, ! ti48(a,p)v51(p,g)cr52
     >      ircr52gp_to_ti48, ! cr52(g,p)v51(p,a)ti48      
     >      irti48ap_to_ti50, ! ti48(a,p)v51(g,p)ti50
     >      irti50p_to_ti48, ! ti50(p,g)v51(p,a)ti48     
     >      irti50p_to_cr52, ! ti50(p,g)v51(p,g)cr52
     >      ircr52gp_to_ti50, ! cr52(g,p)v51(g,p)ti50      
     >      irti48ap_aux, ! ti48(a,p)v51 
     >      irv51pa_aux, ! v51(p,a)ti48 
     >      irti50pg_aux, ! ti50(p,g)v51
     >      irv51gp_aux, ! v51(g,p)ti50 
     >      ircr52gp_aux, ! cr52(g,p)v51 
     >      irv51pg_aux, ! v51(p,g)cr52 
     >      d_rti50prot_to_cr52_dprot, d_rcr52gprot_to_ti50_dprot,
     >      d_rti48aprot_to_ti50_dprot, d_rti50prot_to_ti48_dprot,
     >      d_rti48aprot_to_cr52_dprot, d_rcr52gprot_to_ti48_dprot)
      end subroutine get_rates_for_v51_combos


      subroutine get_rates_for_v53_combos( ! also does ti50(a,g)cr54  
     >      n, g, den, temp, T9, T932, y, num_reactions, rate_factors,
     >      d_rti52prot_to_cr54_dprot, d_rcr54gprot_to_ti52_dprot,
     >      d_rti50aprot_to_ti52_dprot, d_rti52prot_to_ti50_dprot,
     >      d_rti50aprot_to_cr54_dprot, d_rcr54gprot_to_ti50_dprot)    
         type (Net_Info), pointer :: n
         type (Net_General_Info), pointer  :: g
         real(dp), pointer :: y(:)
         integer, intent(in) :: num_reactions
         real(dp), intent(in) ::    
     >      den, temp, T9, T932, rate_factors(:) ! (num_reactions)         
         real(dp), intent(out) ::    
     >      d_rti52prot_to_cr54_dprot, d_rcr54gprot_to_ti52_dprot,
     >      d_rti50aprot_to_ti52_dprot, d_rti52prot_to_ti50_dprot,
     >      d_rti50aprot_to_cr54_dprot, d_rcr54gprot_to_ti50_dprot
         call get_rates_for_ap_combos(  
     >      n, g, .true., den, temp, T9, T932, y, num_reactions, rate_factors,
     >      iti50, iti52, iv53, icr54,
     >      ir_ti50_ag_cr54, ! ti50(a,g)cr54
     >      ir_cr54_ga_ti50, ! cr54(g,a)ti50      
     >      irti50ap_to_cr54, ! ti50(a,p)v53(p,g)cr54
     >      ircr54gp_to_ti50, ! cr54(g,p)v53(p,a)ti50      
     >      irti50ap_to_ti52, ! ti50(a,p)v53(g,p)ti52
     >      irti52p_to_ti50, ! ti52(p,g)v53(p,a)ti50     
     >      irti52p_to_cr54, ! ti52(p,g)v53(p,g)cr54
     >      ircr54gp_to_ti52, ! cr54(g,p)v53(g,p)ti52      
     >      irti50ap_aux, ! ti50(a,p)v53 
     >      irv53pa_aux, ! v53(p,a)ti50 
     >      irti52pg_aux, ! ti52(p,g)v53
     >      irv53gp_aux, ! v53(g,p)ti52 
     >      ircr54gp_aux, ! cr54(g,p)v53 
     >      irv53pg_aux, ! v53(p,g)cr54 
     >      d_rti52prot_to_cr54_dprot, d_rcr54gprot_to_ti52_dprot,
     >      d_rti50aprot_to_ti52_dprot, d_rti52prot_to_ti50_dprot,
     >      d_rti50aprot_to_cr54_dprot, d_rcr54gprot_to_ti50_dprot)
      end subroutine get_rates_for_v53_combos


      subroutine get_rates_for_v55_combos( ! also does ti52(a,g)cr56  
     >      n, g, den, temp, T9, T932, y, num_reactions, rate_factors,
     >      d_rti54prot_to_cr56_dprot, d_rcr56gprot_to_ti54_dprot,
     >      d_rti52aprot_to_ti54_dprot, d_rti54prot_to_ti52_dprot,
     >      d_rti52aprot_to_cr56_dprot, d_rcr56gprot_to_ti52_dprot)    
         type (Net_Info), pointer :: n
         type (Net_General_Info), pointer  :: g
         real(dp), pointer :: y(:)
         integer, intent(in) :: num_reactions
         real(dp), intent(in) ::    
     >      den, temp, T9, T932, rate_factors(:) ! (num_reactions)         
         real(dp), intent(out) ::    
     >      d_rti54prot_to_cr56_dprot, d_rcr56gprot_to_ti54_dprot,
     >      d_rti52aprot_to_ti54_dprot, d_rti54prot_to_ti52_dprot,
     >      d_rti52aprot_to_cr56_dprot, d_rcr56gprot_to_ti52_dprot
         call get_rates_for_ap_combos(  
     >      n, g, .true., den, temp, T9, T932, y, num_reactions, rate_factors,
     >      iti52, iti54, iv55, icr56,
     >      ir_ti52_ag_cr56, ! ti52(a,g)cr56
     >      ir_cr56_ga_ti52, ! cr56(g,a)ti52      
     >      irti52ap_to_cr56, ! ti52(a,p)v55(p,g)cr56
     >      ircr56gp_to_ti52, ! cr56(g,p)v55(p,a)ti52      
     >      irti52ap_to_ti54, ! ti52(a,p)v55(g,p)ti54
     >      irti54p_to_ti52, ! ti54(p,g)v55(p,a)ti52     
     >      irti54p_to_cr56, ! ti54(p,g)v55(p,g)cr56
     >      ircr56gp_to_ti54, ! cr56(g,p)v55(g,p)ti54      
     >      irti52ap_aux, ! ti52(a,p)v55 
     >      irv55pa_aux, ! v55(p,a)ti52 
     >      irti54pg_aux, ! ti54(p,g)v55
     >      irv55gp_aux, ! v55(g,p)ti54 
     >      ircr56gp_aux, ! cr56(g,p)v55 
     >      irv55pg_aux, ! v55(p,g)cr56 
     >      d_rti54prot_to_cr56_dprot, d_rcr56gprot_to_ti54_dprot,
     >      d_rti52aprot_to_ti54_dprot, d_rti54prot_to_ti52_dprot,
     >      d_rti52aprot_to_cr56_dprot, d_rcr56gprot_to_ti52_dprot)
      end subroutine get_rates_for_v55_combos


      subroutine get_rates_for_mn53_combos( ! also does cr50(a,g)fe54  
     >      n, g, den, temp, T9, T932, y, num_reactions, rate_factors,
     >      d_rcr52prot_to_fe54_dprot, d_rfe54gprot_to_cr52_dprot,
     >      d_rcr50aprot_to_cr52_dprot, d_rcr52prot_to_cr50_dprot,
     >      d_rcr50aprot_to_fe54_dprot, d_rfe54gprot_to_cr50_dprot)    
         type (Net_Info), pointer :: n
         type (Net_General_Info), pointer  :: g
         real(dp), pointer :: y(:)
         integer, intent(in) :: num_reactions
         real(dp), intent(in) ::    
     >      den, temp, T9, T932, rate_factors(:) ! (num_reactions)         
         real(dp), intent(out) ::    
     >      d_rcr52prot_to_fe54_dprot, d_rfe54gprot_to_cr52_dprot,
     >      d_rcr50aprot_to_cr52_dprot, d_rcr52prot_to_cr50_dprot,
     >      d_rcr50aprot_to_fe54_dprot, d_rfe54gprot_to_cr50_dprot
         call get_rates_for_ap_combos(  
     >      n, g, .true., den, temp, T9, T932, y, num_reactions, rate_factors,
     >      icr50, icr52, imn53, ife54,
     >      ir_cr50_ag_fe54, ! cr50(a,g)fe54
     >      ir_fe54_ga_cr50, ! fe54(g,a)cr50      
     >      ircr50ap_to_fe54, ! cr50(a,p)mn53(p,g)fe54
     >      irfe54gp_to_cr50, ! fe54(g,p)mn53(p,a)cr50      
     >      ircr50ap_to_cr52, ! cr50(a,p)mn53(g,p)cr52
     >      ircr52p_to_cr50, ! cr52(p,g)mn53(p,a)cr50     
     >      ircr52p_to_fe54, ! cr52(p,g)mn53(p,g)fe54
     >      irfe54gp_to_cr52, ! fe54(g,p)mn53(g,p)cr52      
     >      ircr50ap_aux, ! cr50(a,p)mn53 
     >      irmn53pa_aux, ! mn53(p,a)cr50 
     >      ircr52pg_aux, ! cr52(p,g)mn53
     >      irmn53gp_aux, ! mn53(g,p)cr52 
     >      irfe54gp_aux, ! fe54(g,p)mn53 
     >      irmn53pg_aux, ! mn53(p,g)fe54 
     >      d_rcr52prot_to_fe54_dprot, d_rfe54gprot_to_cr52_dprot,
     >      d_rcr50aprot_to_cr52_dprot, d_rcr52prot_to_cr50_dprot,
     >      d_rcr50aprot_to_fe54_dprot, d_rfe54gprot_to_cr50_dprot)
      end subroutine get_rates_for_mn53_combos


      subroutine get_rates_for_mn55_combos( ! also does cr52(a,g)fe56  
     >      n, g, den, temp, T9, T932, y, num_reactions, rate_factors,
     >      d_rcr54prot_to_fe56_dprot, d_rfe56gprot_to_cr54_dprot,
     >      d_rcr52aprot_to_cr54_dprot, d_rcr54prot_to_cr52_dprot,
     >      d_rcr52aprot_to_fe56_dprot, d_rfe56gprot_to_cr52_dprot)    
         type (Net_Info), pointer :: n
         type (Net_General_Info), pointer  :: g
         real(dp), pointer :: y(:)
         integer, intent(in) :: num_reactions
         real(dp), intent(in) ::    
     >      den, temp, T9, T932, rate_factors(:) ! (num_reactions)         
         real(dp), intent(out) ::    
     >      d_rcr54prot_to_fe56_dprot, d_rfe56gprot_to_cr54_dprot,
     >      d_rcr52aprot_to_cr54_dprot, d_rcr54prot_to_cr52_dprot,
     >      d_rcr52aprot_to_fe56_dprot, d_rfe56gprot_to_cr52_dprot
         call get_rates_for_ap_combos(  
     >      n, g, .true., den, temp, T9, T932, y, num_reactions, rate_factors,
     >      icr52, icr54, imn55, ife56,
     >      ir_cr52_ag_fe56, ! cr52(a,g)fe56
     >      ir_fe56_ga_cr52, ! fe56(g,a)cr52      
     >      ircr52ap_to_fe56, ! cr52(a,p)mn55(p,g)fe56
     >      irfe56gp_to_cr52, ! fe56(g,p)mn55(p,a)cr52      
     >      ircr52ap_to_cr54, ! cr52(a,p)mn55(g,p)cr54
     >      ircr54p_to_cr52, ! cr54(p,g)mn55(p,a)cr52     
     >      ircr54p_to_fe56, ! cr54(p,g)mn55(p,g)fe56
     >      irfe56gp_to_cr54, ! fe56(g,p)mn55(g,p)cr54      
     >      ircr52ap_aux, ! cr52(a,p)mn55 
     >      irmn55pa_aux, ! mn55(p,a)cr52 
     >      ircr54pg_aux, ! cr54(p,g)mn55
     >      irmn55gp_aux, ! mn55(g,p)cr54 
     >      irfe56gp_aux, ! fe56(g,p)mn55 
     >      irmn55pg_aux, ! mn55(p,g)fe56 
     >      d_rcr54prot_to_fe56_dprot, d_rfe56gprot_to_cr54_dprot,
     >      d_rcr52aprot_to_cr54_dprot, d_rcr54prot_to_cr52_dprot,
     >      d_rcr52aprot_to_fe56_dprot, d_rfe56gprot_to_cr52_dprot)
      end subroutine get_rates_for_mn55_combos


      subroutine get_rates_for_mn57_combos( ! also does cr54(a,g)fe58  
     >      n, g, den, temp, T9, T932, y, num_reactions, rate_factors,
     >      d_rcr56prot_to_fe58_dprot, d_rfe58gprot_to_cr56_dprot,
     >      d_rcr54aprot_to_cr56_dprot, d_rcr56prot_to_cr54_dprot,
     >      d_rcr54aprot_to_fe58_dprot, d_rfe58gprot_to_cr54_dprot)    
         type (Net_Info), pointer :: n
         type (Net_General_Info), pointer  :: g
         real(dp), pointer :: y(:)
         integer, intent(in) :: num_reactions
         real(dp), intent(in) ::    
     >      den, temp, T9, T932, rate_factors(:) ! (num_reactions)         
         real(dp), intent(out) ::    
     >      d_rcr56prot_to_fe58_dprot, d_rfe58gprot_to_cr56_dprot,
     >      d_rcr54aprot_to_cr56_dprot, d_rcr56prot_to_cr54_dprot,
     >      d_rcr54aprot_to_fe58_dprot, d_rfe58gprot_to_cr54_dprot
         call get_rates_for_ap_combos(  
     >      n, g, .true., den, temp, T9, T932, y, num_reactions, rate_factors,
     >      icr54, icr56, imn57, ife58,
     >      ir_cr54_ag_fe58, ! cr54(a,g)fe58
     >      ir_fe58_ga_cr54, ! fe58(g,a)cr54 
     >      ircr54ap_to_fe58, ! cr54(a,p)mn57(p,g)fe58
     >      irfe58gp_to_cr54, ! fe58(g,p)mn57(p,a)cr54 
     >      ircr54ap_to_cr56, ! cr54(a,p)mn57(g,p)cr56
     >      ircr56p_to_cr54, ! cr56(p,g)mn57(p,a)cr54
     >      ircr56p_to_fe58, ! cr56(p,g)mn57(p,g)fe58
     >      irfe58gp_to_cr56, ! fe58(g,p)mn57(g,p)cr56 
     >      ircr54ap_aux, ! cr54(a,p)mn57 
     >      irmn57pa_aux, ! mn57(p,a)cr54 
     >      ircr56pg_aux, ! cr56(p,g)mn57
     >      irmn57gp_aux, ! mn57(g,p)cr56 
     >      irfe58gp_aux, ! fe58(g,p)mn57 
     >      irmn57pg_aux, ! mn57(p,g)fe58 
     >      d_rcr56prot_to_fe58_dprot, d_rfe58gprot_to_cr56_dprot,
     >      d_rcr54aprot_to_cr56_dprot, d_rcr56prot_to_cr54_dprot,
     >      d_rcr54aprot_to_fe58_dprot, d_rfe58gprot_to_cr54_dprot)
      end subroutine get_rates_for_mn57_combos


      subroutine get_rates_for_mn59_combos( ! also does cr56(a,g)fe60  
     >      n, g, den, temp, T9, T932, y, num_reactions, rate_factors,
     >      d_rcr58prot_to_fe60_dprot, d_rfe60gprot_to_cr58_dprot,
     >      d_rcr56aprot_to_cr58_dprot, d_rcr58prot_to_cr56_dprot,
     >      d_rcr56aprot_to_fe60_dprot, d_rfe60gprot_to_cr56_dprot)    
         type (Net_Info), pointer :: n
         type (Net_General_Info), pointer  :: g
         real(dp), pointer :: y(:)
         integer, intent(in) :: num_reactions
         real(dp), intent(in) ::    
     >      den, temp, T9, T932, rate_factors(:) ! (num_reactions)         
         real(dp), intent(out) ::    
     >      d_rcr58prot_to_fe60_dprot, d_rfe60gprot_to_cr58_dprot,
     >      d_rcr56aprot_to_cr58_dprot, d_rcr58prot_to_cr56_dprot,
     >      d_rcr56aprot_to_fe60_dprot, d_rfe60gprot_to_cr56_dprot
         call get_rates_for_ap_combos(  
     >      n, g, .true., den, temp, T9, T932, y, num_reactions, rate_factors,
     >      icr56, icr58, imn59, ife60,
     >      ir_cr56_ag_fe60, ! cr56(a,g)fe60
     >      ir_fe60_ga_cr56, ! fe60(g,a)cr56 
     >      ircr56ap_to_fe60, ! cr56(a,p)mn59(p,g)fe60
     >      irfe60gp_to_cr56, ! fe60(g,p)mn59(p,a)cr56 
     >      ircr56ap_to_cr58, ! cr56(a,p)mn59(g,p)cr58
     >      ircr58p_to_cr56, ! cr58(p,g)mn59(p,a)cr56
     >      ircr58p_to_fe60, ! cr58(p,g)mn59(p,g)fe60
     >      irfe60gp_to_cr58, ! fe60(g,p)mn59(g,p)cr58 
     >      ircr56ap_aux, ! cr56(a,p)mn59 
     >      irmn59pa_aux, ! mn59(p,a)cr56 
     >      ircr58pg_aux, ! cr58(p,g)mn59
     >      irmn59gp_aux, ! mn59(g,p)cr58 
     >      irfe60gp_aux, ! fe60(g,p)mn59 
     >      irmn59pg_aux, ! mn59(p,g)fe60 
     >      d_rcr58prot_to_fe60_dprot, d_rfe60gprot_to_cr58_dprot,
     >      d_rcr56aprot_to_cr58_dprot, d_rcr58prot_to_cr56_dprot,
     >      d_rcr56aprot_to_fe60_dprot, d_rfe60gprot_to_cr56_dprot)
      end subroutine get_rates_for_mn59_combos


      subroutine get_rates_for_co55_combos( ! also does fe52(a,g)ni56
     >      n, g, den, temp, T9, T932, y, num_reactions, rate_factors,
     >      d_rfe54prot_to_ni56_dprot, d_rni56gprot_to_fe54_dprot,
     >      d_rfe52aprot_to_fe54_dprot, d_rfe54prot_to_fe52_dprot,
     >      d_rfe52aprot_to_ni56_dprot, d_rni56gprot_to_fe52_dprot)    
         type (Net_Info), pointer :: n
         type (Net_General_Info), pointer  :: g
         real(dp), pointer :: y(:)
         integer, intent(in) :: num_reactions
         real(dp), intent(in) ::    
     >      den, temp, T9, T932, rate_factors(:) ! (num_reactions)         
         real(dp), intent(out) ::    
     >      d_rfe54prot_to_ni56_dprot, d_rni56gprot_to_fe54_dprot,
     >      d_rfe52aprot_to_fe54_dprot, d_rfe54prot_to_fe52_dprot,
     >      d_rfe52aprot_to_ni56_dprot, d_rni56gprot_to_fe52_dprot
         call get_rates_for_ap_combos(  
     >      n, g, .true., den, temp, T9, T932, y, num_reactions, rate_factors,
     >      ife52, ife54, ico55, ini56,
     >      ir_fe52_ag_ni56, ! fe52(a,g)ni56
     >      ir_ni56_ga_fe52, ! ni56(g,a)fe52 
     >      irfe52aprot_to_ni56, ! fe52(a,prot)co55(prot,g)ni56
     >      irni56gprot_to_fe52, ! ni56(g,prot)co55(prot,a)fe52 
     >      irfe52aprot_to_fe54, ! fe52(a,prot)co55(g,prot)fe54
     >      irfe54prot_to_fe52, ! fe54(prot,g)co55(prot,a)fe52
     >      irfe54prot_to_ni56, ! fe54(prot,g)co55(prot,g)ni56
     >      irni56gprot_to_fe54, ! ni56(g,prot)co55(g,prot)fe54 
     >      irfe52aprot_aux, ! fe52(a,prot)co55 
     >      irco55prota_aux, ! co55(prot,a)fe52 
     >      irfe54protg_aux, ! fe54(prot,g)co55
     >      irco55gprot_aux, ! co55(g,prot)fe54 
     >      irni56gprot_aux, ! ni56(g,prot)co55 
     >      irco55protg_aux, ! co55(prot,g)ni56 
     >      d_rfe54prot_to_ni56_dprot, d_rni56gprot_to_fe54_dprot,
     >      d_rfe52aprot_to_fe54_dprot, d_rfe54prot_to_fe52_dprot,
     >      d_rfe52aprot_to_ni56_dprot, d_rni56gprot_to_fe52_dprot)
         end subroutine get_rates_for_co55_combos


      subroutine get_rates_for_co57_combos( ! also does fe54(a,g)ni58
     >      n, g, den, temp, T9, T932, y, num_reactions, rate_factors,
     >      d_rfe56prot_to_ni58_dprot, d_rni58gprot_to_fe56_dprot,
     >      d_rfe54aprot_to_fe56_dprot, d_rfe56prot_to_fe54_dprot,
     >      d_rfe54aprot_to_ni58_dprot, d_rni58gprot_to_fe54_dprot)    
         type (Net_Info), pointer :: n
         type (Net_General_Info), pointer  :: g
         real(dp), pointer :: y(:)
         integer, intent(in) :: num_reactions
         real(dp), intent(in) ::    
     >      den, temp, T9, T932, rate_factors(:) ! (num_reactions)         
         real(dp), intent(out) ::    
     >      d_rfe56prot_to_ni58_dprot, d_rni58gprot_to_fe56_dprot,
     >      d_rfe54aprot_to_fe56_dprot, d_rfe56prot_to_fe54_dprot,
     >      d_rfe54aprot_to_ni58_dprot, d_rni58gprot_to_fe54_dprot
         call get_rates_for_ap_combos(  
     >      n, g, .true., den, temp, T9, T932, y, num_reactions, rate_factors,
     >      ife54, ife56, ico57, ini58,
     >      ir_fe54_ag_ni58, ! fe54(a,g)ni58
     >      ir_ni58_ga_fe54, ! ni58(g,a)fe54 
     >      irfe54aprot_to_ni58, ! fe54(a,prot)co57(prot,g)ni58
     >      irni58gprot_to_fe54, ! ni58(g,prot)co57(prot,a)fe54 
     >      irfe54aprot_to_fe56, ! fe54(a,prot)co57(g,prot)fe56
     >      irfe56prot_to_fe54, ! fe56(prot,g)co57(prot,a)fe54
     >      irfe56prot_to_ni58, ! fe56(prot,g)co57(prot,g)ni58
     >      irni58gprot_to_fe56, ! ni58(g,prot)co57(g,prot)fe56 
     >      irfe54aprot_aux, ! fe54(a,prot)co57 
     >      irco57prota_aux, ! co57(prot,a)fe54 
     >      irfe56protg_aux, ! fe56(prot,g)co57
     >      irco57gprot_aux, ! co57(g,prot)fe56 
     >      irni58gprot_aux, ! ni58(g,prot)co57 
     >      irco57protg_aux, ! co57(prot,g)ni58 
     >      d_rfe56prot_to_ni58_dprot, d_rni58gprot_to_fe56_dprot,
     >      d_rfe54aprot_to_fe56_dprot, d_rfe56prot_to_fe54_dprot,
     >      d_rfe54aprot_to_ni58_dprot, d_rni58gprot_to_fe54_dprot)
         end subroutine get_rates_for_co57_combos


      subroutine get_rates_for_co59_combos( ! also does fe56(a,g)ni60  
     >      n, g, den, temp, T9, T932, y, num_reactions, rate_factors,
     >      d_rfe58prot_to_ni60_dprot, d_rni60gprot_to_fe58_dprot,
     >      d_rfe56aprot_to_fe58_dprot, d_rfe58prot_to_fe56_dprot,
     >      d_rfe56aprot_to_ni60_dprot, d_rni60gprot_to_fe56_dprot)    
         type (Net_Info), pointer :: n
         type (Net_General_Info), pointer  :: g
         real(dp), pointer :: y(:)
         integer, intent(in) :: num_reactions
         real(dp), intent(in) ::    
     >      den, temp, T9, T932, rate_factors(:) ! (num_reactions)         
         real(dp), intent(out) ::    
     >      d_rfe58prot_to_ni60_dprot, d_rni60gprot_to_fe58_dprot,
     >      d_rfe56aprot_to_fe58_dprot, d_rfe58prot_to_fe56_dprot,
     >      d_rfe56aprot_to_ni60_dprot, d_rni60gprot_to_fe56_dprot
         call get_rates_for_ap_combos(  
     >      n, g, .true., den, temp, T9, T932, y, num_reactions, rate_factors,
     >      ife56, ife58, ico59, ini60,
     >      ir_fe56_ag_ni60, ! fe56(a,g)ni60
     >      ir_ni60_ga_fe56, ! ni60(g,a)fe56 
     >      irfe56aprot_to_ni60, ! fe56(a,prot)co59(prot,g)ni60
     >      irni60gprot_to_fe56, ! ni60(g,prot)co59(prot,a)fe56 
     >      irfe56aprot_to_fe58, ! fe56(a,prot)co59(g,prot)fe58
     >      irfe58prot_to_fe56, ! fe58(prot,g)co59(prot,a)fe56
     >      irfe58prot_to_ni60, ! fe58(prot,g)co59(prot,g)ni60
     >      irni60gprot_to_fe58, ! ni60(g,prot)co59(g,prot)fe58 
     >      irfe56aprot_aux, ! fe56(a,prot)co59 
     >      irco59prota_aux, ! co59(prot,a)fe56 
     >      irfe58protg_aux, ! fe58(prot,g)co59
     >      irco59gprot_aux, ! co59(g,prot)fe58 
     >      irni60gprot_aux, ! ni60(g,prot)co59 
     >      irco59protg_aux, ! co59(prot,g)ni60 
     >      d_rfe58prot_to_ni60_dprot, d_rni60gprot_to_fe58_dprot,
     >      d_rfe56aprot_to_fe58_dprot, d_rfe58prot_to_fe56_dprot,
     >      d_rfe56aprot_to_ni60_dprot, d_rni60gprot_to_fe56_dprot)
         end subroutine get_rates_for_co59_combos


      subroutine get_rates_for_co61_combos( ! also does fe58(a,g)ni62   
     >      n, g, den, temp, T9, T932, y, num_reactions, rate_factors,
     >      d_rfe60prot_to_ni62_dprot, d_rni62gprot_to_fe60_dprot,
     >      d_rfe58aprot_to_fe60_dprot, d_rfe60prot_to_fe58_dprot,
     >      d_rfe58aprot_to_ni62_dprot, d_rni62gprot_to_fe58_dprot)    
         type (Net_Info), pointer :: n
         type (Net_General_Info), pointer  :: g
         real(dp), pointer :: y(:)
         integer, intent(in) :: num_reactions
         real(dp), intent(in) ::    
     >      den, temp, T9, T932, rate_factors(:) ! (num_reactions)         
         real(dp), intent(out) ::    
     >      d_rfe60prot_to_ni62_dprot, d_rni62gprot_to_fe60_dprot,
     >      d_rfe58aprot_to_fe60_dprot, d_rfe60prot_to_fe58_dprot,
     >      d_rfe58aprot_to_ni62_dprot, d_rni62gprot_to_fe58_dprot
         call get_rates_for_ap_combos(  
     >      n, g, .true., den, temp, T9, T932, y, num_reactions, rate_factors,
     >      ife58, ife60, ico61, ini62,
     >      ir_fe58_ag_ni62, ! fe58(a,g)ni62
     >      ir_ni62_ga_fe58, ! ni62(g,a)fe58 
     >      irfe58aprot_to_ni62, ! fe58(a,prot)co61(prot,g)ni62
     >      irni62gprot_to_fe58, ! ni62(g,prot)co61(prot,a)fe58 
     >      irfe58aprot_to_fe60, ! fe58(a,prot)co61(g,prot)fe60
     >      irfe60prot_to_fe58, ! fe60(prot,g)co61(prot,a)fe58
     >      irfe60prot_to_ni62, ! fe60(prot,g)co61(prot,g)ni62
     >      irni62gprot_to_fe60, ! ni62(g,prot)co61(g,prot)fe60 
     >      irfe58aprot_aux, ! fe58(a,prot)co61 
     >      irco61prota_aux, ! co61(prot,a)fe58 
     >      irfe60protg_aux, ! fe60(prot,g)co61
     >      irco61gprot_aux, ! co61(g,prot)fe60 
     >      irni62gprot_aux, ! ni62(g,prot)co61 
     >      irco61protg_aux, ! co61(prot,g)ni62 
     >      d_rfe60prot_to_ni62_dprot, d_rni62gprot_to_fe60_dprot,
     >      d_rfe58aprot_to_fe60_dprot, d_rfe60prot_to_fe58_dprot,
     >      d_rfe58aprot_to_ni62_dprot, d_rni62gprot_to_fe58_dprot)
         end subroutine get_rates_for_co61_combos


      subroutine get_rates_for_co63_combos( ! also does fe60(a,g)ni64  
     >      n, g, den, temp, T9, T932, y, num_reactions, rate_factors,
     >      d_rfe62prot_to_ni64_dprot, d_rni64gprot_to_fe62_dprot,
     >      d_rfe60aprot_to_fe62_dprot, d_rfe62prot_to_fe60_dprot,
     >      d_rfe60aprot_to_ni64_dprot, d_rni64gprot_to_fe60_dprot)    
         type (Net_Info), pointer :: n
         type (Net_General_Info), pointer  :: g
         real(dp), pointer :: y(:)
         integer, intent(in) :: num_reactions
         real(dp), intent(in) ::    
     >      den, temp, T9, T932, rate_factors(:) ! (num_reactions)         
         real(dp), intent(out) ::    
     >      d_rfe62prot_to_ni64_dprot, d_rni64gprot_to_fe62_dprot,
     >      d_rfe60aprot_to_fe62_dprot, d_rfe62prot_to_fe60_dprot,
     >      d_rfe60aprot_to_ni64_dprot, d_rni64gprot_to_fe60_dprot
         call get_rates_for_ap_combos(  
     >      n, g, .true., den, temp, T9, T932, y, num_reactions, rate_factors,
     >      ife60, ife62, ico63, ini64,
     >      ir_fe60_ag_ni64, ! fe60(a,g)ni64
     >      ir_ni64_ga_fe60, ! ni64(g,a)fe60 
     >      irfe60aprot_to_ni64, ! fe60(a,prot)co63(prot,g)ni64
     >      irni64gprot_to_fe60, ! ni64(g,prot)co63(prot,a)fe60 
     >      irfe60aprot_to_fe62, ! fe60(a,prot)co63(g,prot)fe62
     >      irfe62prot_to_fe60, ! fe62(prot,g)co63(prot,a)fe60
     >      irfe62prot_to_ni64, ! fe62(prot,g)co63(prot,g)ni64
     >      irni64gprot_to_fe62, ! ni64(g,prot)co63(g,prot)fe62 
     >      irfe60aprot_aux, ! fe60(a,prot)co63 
     >      irco63prota_aux, ! co63(prot,a)fe60 
     >      irfe62protg_aux, ! fe62(prot,g)co63
     >      irco63gprot_aux, ! co63(g,prot)fe62 
     >      irni64gprot_aux, ! ni64(g,prot)co63 
     >      irco63protg_aux, ! co63(prot,g)ni64 
     >      d_rfe62prot_to_ni64_dprot, d_rni64gprot_to_fe62_dprot,
     >      d_rfe60aprot_to_fe62_dprot, d_rfe62prot_to_fe60_dprot,
     >      d_rfe60aprot_to_ni64_dprot, d_rni64gprot_to_fe60_dprot)
         end subroutine get_rates_for_co63_combos


      subroutine get_rates_for_cu59_combos( ! also does ni56(a,g)zn60   
     >      n, g, den, temp, T9, T932, y, num_reactions, rate_factors,
     >      d_rni58prot_to_zn60_dprot, d_rzn60gprot_to_ni58_dprot,
     >      d_rni56aprot_to_ni58_dprot, d_rni58prot_to_ni56_dprot,
     >      d_rni56aprot_to_zn60_dprot, d_rzn60gprot_to_ni56_dprot)    
         type (Net_Info), pointer :: n
         type (Net_General_Info), pointer  :: g
         real(dp), pointer :: y(:)
         integer, intent(in) :: num_reactions
         real(dp), intent(in) :: 
     >      den, temp, T9, T932, rate_factors(:) ! (num_reactions)         
         real(dp), intent(out) ::    
     >      d_rni58prot_to_zn60_dprot, d_rzn60gprot_to_ni58_dprot,
     >      d_rni56aprot_to_ni58_dprot, d_rni58prot_to_ni56_dprot,
     >      d_rni56aprot_to_zn60_dprot, d_rzn60gprot_to_ni56_dprot         
         call get_rates_for_ap_combos(  
     >      n, g, .true., den, temp, T9, T932, y, num_reactions, rate_factors,
     >      ini56, ini58, icu59, izn60,
     >      ir_ni56_ag_zn60, ! ni56(a,g)zn60
     >      ir_zn60_ga_ni56, ! zn60(g,a)ni56  
     >      0, !irni56aprot_to_zn60, ! ni56(a,prot)cu59(prot,g)zn60
     >      0, !irzn60gprot_to_ni56, ! zn60(g,prot)cu59(prot,a)ni56 
     >      irni56aprot_to_ni58, ! ni56(a,prot)cu59(g,prot)ni58
     >      irni58prot_to_ni56, ! ni58(prot,g)cu59(prot,a)ni56
     >      0, !irni58prot_to_zn60, ! ni58(prot,g)cu59(prot,g)zn60
     >      0, !irzn60gprot_to_ni58, ! zn60(g,prot)cu59(g,prot)ni58 
     >      irni56aprot_aux, ! ni56(a,prot)cu59 
     >      ircu59prota_aux, ! cu59(prot,a)ni56 
     >      irni58protg_aux, ! ni58(prot,g)cu59
     >      ircu59gprot_aux, ! cu59(g,prot)ni58 
     >      0, !irzn60gprot_aux, ! zn60(g,prot)cu59 
     >      0, !ircu59protg_aux, ! cu59(prot,g)zn60 
     >      d_rni58prot_to_zn60_dprot, d_rzn60gprot_to_ni58_dprot,
     >      d_rni56aprot_to_ni58_dprot, d_rni58prot_to_ni56_dprot,
     >      d_rni56aprot_to_zn60_dprot, d_rzn60gprot_to_ni56_dprot)
         end subroutine get_rates_for_cu59_combos


      subroutine get_rates_for_cu61_combos( ! also does ni58(a,g)zn62   
     >      n, g, den, temp, T9, T932, y, num_reactions, rate_factors,
     >      d_rni60prot_to_zn62_dprot, d_rzn62gprot_to_ni60_dprot,
     >      d_rni58aprot_to_ni60_dprot, d_rni60prot_to_ni58_dprot,
     >      d_rni58aprot_to_zn62_dprot, d_rzn62gprot_to_ni58_dprot)    
         type (Net_Info), pointer :: n
         type (Net_General_Info), pointer  :: g
         real(dp), pointer :: y(:)
         integer, intent(in) :: num_reactions
         real(dp), intent(in) :: 
     >      den, temp, T9, T932, rate_factors(:) ! (num_reactions)         
         real(dp), intent(out) ::    
     >      d_rni60prot_to_zn62_dprot, d_rzn62gprot_to_ni60_dprot,
     >      d_rni58aprot_to_ni60_dprot, d_rni60prot_to_ni58_dprot,
     >      d_rni58aprot_to_zn62_dprot, d_rzn62gprot_to_ni58_dprot         
         ! comment out zn62 reactions      
         call get_rates_for_ap_combos(  
     >      n, g, .true., den, temp, T9, T932, y, num_reactions, rate_factors,
     >      ini58, ini60, icu61, izn62,
     >      ir_ni58_ag_zn62, ! ni58(a,g)zn62
     >      ir_zn62_ga_ni58, ! zn62(g,a)ni58  
     >      0, !irni58aprot_to_zn62, ! ni58(a,prot)cu61(prot,g)zn62
     >      0, !irzn62gprot_to_ni58, ! zn62(g,prot)cu61(prot,a)ni58 
     >      irni58aprot_to_ni60, ! ni58(a,prot)cu61(g,prot)ni60
     >      irni60prot_to_ni58, ! ni60(prot,g)cu61(prot,a)ni58
     >      0, !irni60prot_to_zn62, ! ni60(prot,g)cu61(prot,g)zn62
     >      0, !irzn62gprot_to_ni60, ! zn62(g,prot)cu61(g,prot)ni60 
     >      irni58aprot_aux, ! ni58(a,prot)cu61 
     >      ircu61prota_aux, ! cu61(prot,a)ni58 
     >      irni60protg_aux, ! ni60(prot,g)cu61
     >      ircu61gprot_aux, ! cu61(g,prot)ni60 
     >      0, !irzn62gprot_aux, ! zn62(g,prot)cu61 
     >      0, !ircu61protg_aux, ! cu61(prot,g)zn62 
     >      d_rni60prot_to_zn62_dprot, d_rzn62gprot_to_ni60_dprot,
     >      d_rni58aprot_to_ni60_dprot, d_rni60prot_to_ni58_dprot,
     >      d_rni58aprot_to_zn62_dprot, d_rzn62gprot_to_ni58_dprot)
         end subroutine get_rates_for_cu61_combos


      subroutine get_rates_for_cu63_combos( ! also does ni60(a,g)zn64   
     >      n, g, den, temp, T9, T932, y, num_reactions, rate_factors,
     >      d_rni62prot_to_zn64_dprot, d_rzn64gprot_to_ni62_dprot,
     >      d_rni60aprot_to_ni62_dprot, d_rni62prot_to_ni60_dprot,
     >      d_rni60aprot_to_zn64_dprot, d_rzn64gprot_to_ni60_dprot)    
         type (Net_Info), pointer :: n
         type (Net_General_Info), pointer  :: g
         real(dp), pointer :: y(:)
         integer, intent(in) :: num_reactions
         real(dp), intent(in) :: 
     >      den, temp, T9, T932, rate_factors(:) ! (num_reactions)         
         real(dp), intent(out) ::    
     >      d_rni62prot_to_zn64_dprot, d_rzn64gprot_to_ni62_dprot,
     >      d_rni60aprot_to_ni62_dprot, d_rni62prot_to_ni60_dprot,
     >      d_rni60aprot_to_zn64_dprot, d_rzn64gprot_to_ni60_dprot         
         call get_rates_for_ap_combos(  
     >      n, g, .true., den, temp, T9, T932, y, num_reactions, rate_factors,
     >      ini60, ini62, icu63, izn64,
     >      ir_ni60_ag_zn64, ! ni60(a,g)zn64
     >      ir_zn64_ga_ni60, ! zn64(g,a)ni60  
     >      irni60aprot_to_zn64, ! ni60(a,prot)cu63(prot,g)zn64
     >      irzn64gprot_to_ni60, ! zn64(g,prot)cu63(prot,a)ni60 
     >      irni60aprot_to_ni62, ! ni60(a,prot)cu63(g,prot)ni62
     >      irni62prot_to_ni60, ! ni62(prot,g)cu63(prot,a)ni60
     >      irni62prot_to_zn64, ! ni62(prot,g)cu63(prot,g)zn64
     >      irzn64gprot_to_ni62, ! zn64(g,prot)cu63(g,prot)ni62 
     >      irni60aprot_aux, ! ni60(a,prot)cu63 
     >      ircu63prota_aux, ! cu63(prot,a)ni60 
     >      irni62protg_aux, ! ni62(prot,g)cu63
     >      ircu63gprot_aux, ! cu63(g,prot)ni62 
     >      irzn64gprot_aux, ! zn64(g,prot)cu63 
     >      ircu63protg_aux, ! cu63(prot,g)zn64 
     >      d_rni62prot_to_zn64_dprot, d_rzn64gprot_to_ni62_dprot,
     >      d_rni60aprot_to_ni62_dprot, d_rni62prot_to_ni60_dprot,
     >      d_rni60aprot_to_zn64_dprot, d_rzn64gprot_to_ni60_dprot)
         end subroutine get_rates_for_cu63_combos


      subroutine get_rates_for_cu65_combos( ! also does ni62(a,g)zn66   
     >      n, g, den, temp, T9, T932, y, num_reactions, rate_factors,
     >      d_rni64prot_to_zn66_dprot, d_rzn66gprot_to_ni64_dprot,
     >      d_rni62aprot_to_ni64_dprot, d_rni64prot_to_ni62_dprot,
     >      d_rni62aprot_to_zn66_dprot, d_rzn66gprot_to_ni62_dprot)    
         type (Net_Info), pointer :: n
         type (Net_General_Info), pointer  :: g
         real(dp), pointer :: y(:)
         integer, intent(in) :: num_reactions
         real(dp), intent(in) :: 
     >      den, temp, T9, T932, rate_factors(:) ! (num_reactions)         
         real(dp), intent(out) ::    
     >      d_rni64prot_to_zn66_dprot, d_rzn66gprot_to_ni64_dprot,
     >      d_rni62aprot_to_ni64_dprot, d_rni64prot_to_ni62_dprot,
     >      d_rni62aprot_to_zn66_dprot, d_rzn66gprot_to_ni62_dprot         
         call get_rates_for_ap_combos(  
     >      n, g, .true., den, temp, T9, T932, y, num_reactions, rate_factors,
     >      ini62, ini64, icu65, izn66,
     >      ir_ni62_ag_zn66, ! ni62(a,g)zn66
     >      ir_zn66_ga_ni62, ! zn66(g,a)ni62  
     >      irni62aprot_to_zn66, ! ni62(a,prot)cu65(prot,g)zn66
     >      irzn66gprot_to_ni62, ! zn66(g,prot)cu65(prot,a)ni62 
     >      irni62aprot_to_ni64, ! ni62(a,prot)cu65(g,prot)ni64
     >      irni64prot_to_ni62, ! ni64(prot,g)cu65(prot,a)ni62
     >      irni64prot_to_zn66, ! ni64(prot,g)cu65(prot,g)zn66
     >      irzn66gprot_to_ni64, ! zn66(g,prot)cu65(g,prot)ni64 
     >      irni62aprot_aux, ! ni62(a,prot)cu65 
     >      ircu65prota_aux, ! cu65(prot,a)ni62 
     >      irni64protg_aux, ! ni64(prot,g)cu65
     >      ircu65gprot_aux, ! cu65(g,prot)ni64 
     >      irzn66gprot_aux, ! zn66(g,prot)cu65 
     >      ircu65protg_aux, ! cu65(prot,g)zn66 
     >      d_rni64prot_to_zn66_dprot, d_rzn66gprot_to_ni64_dprot,
     >      d_rni62aprot_to_ni64_dprot, d_rni64prot_to_ni62_dprot,
     >      d_rni62aprot_to_zn66_dprot, d_rzn66gprot_to_ni62_dprot)
         end subroutine get_rates_for_cu65_combos


      subroutine get_rates_for_cu67_combos( ! also does ni64(a,g)zn68   
     >      n, g, den, temp, T9, T932, y, num_reactions, rate_factors,
     >      d_rni66prot_to_zn68_dprot, d_rzn68gprot_to_ni66_dprot,
     >      d_rni64aprot_to_ni66_dprot, d_rni66prot_to_ni64_dprot,
     >      d_rni64aprot_to_zn68_dprot, d_rzn68gprot_to_ni64_dprot)    
         type (Net_Info), pointer :: n
         type (Net_General_Info), pointer  :: g
         real(dp), pointer :: y(:)
         integer, intent(in) :: num_reactions
         real(dp), intent(in) :: 
     >      den, temp, T9, T932, rate_factors(:) ! (num_reactions)         
         real(dp), intent(out) ::    
     >      d_rni66prot_to_zn68_dprot, d_rzn68gprot_to_ni66_dprot,
     >      d_rni64aprot_to_ni66_dprot, d_rni66prot_to_ni64_dprot,
     >      d_rni64aprot_to_zn68_dprot, d_rzn68gprot_to_ni64_dprot         
         call get_rates_for_ap_combos(  
     >      n, g, .true., den, temp, T9, T932, y, num_reactions, rate_factors,
     >      ini64, ini66, icu67, izn68,
     >      ir_ni64_ag_zn68, ! ni64(a,g)zn68
     >      ir_zn68_ga_ni64, ! zn68(g,a)ni64  
     >      irni64aprot_to_zn68, ! ni64(a,prot)cu67(prot,g)zn68
     >      irzn68gprot_to_ni64, ! zn68(g,prot)cu67(prot,a)ni64 
     >      irni64aprot_to_ni66, ! ni64(a,prot)cu67(g,prot)ni66
     >      irni66prot_to_ni64, ! ni66(prot,g)cu67(prot,a)ni64
     >      irni66prot_to_zn68, ! ni66(prot,g)cu67(prot,g)zn68
     >      irzn68gprot_to_ni66, ! zn68(g,prot)cu67(g,prot)ni66 
     >      irni64aprot_aux, ! ni64(a,prot)cu67 
     >      ircu67prota_aux, ! cu67(prot,a)ni64 
     >      irni66protg_aux, ! ni66(prot,g)cu67
     >      ircu67gprot_aux, ! cu67(g,prot)ni66 
     >      irzn68gprot_aux, ! zn68(g,prot)cu67 
     >      ircu67protg_aux, ! cu67(prot,g)zn68 
     >      d_rni66prot_to_zn68_dprot, d_rzn68gprot_to_ni66_dprot,
     >      d_rni64aprot_to_ni66_dprot, d_rni66prot_to_ni64_dprot,
     >      d_rni64aprot_to_zn68_dprot, d_rzn68gprot_to_ni64_dprot)
         end subroutine get_rates_for_cu67_combos


      subroutine get_rates_for_ga71_combos( ! also does zn68(a,g)ge72   
     >      n, g, den, temp, T9, T932, y, num_reactions, rate_factors,
     >      d_rzn70prot_to_ge72_dprot, d_rge72gprot_to_zn70_dprot,
     >      d_rzn68aprot_to_zn70_dprot, d_rzn70prot_to_zn68_dprot,
     >      d_rzn68aprot_to_ge72_dprot, d_rge72gprot_to_zn68_dprot)    
         type (Net_Info), pointer :: n
         type (Net_General_Info), pointer  :: g
         real(dp), pointer :: y(:)
         integer, intent(in) :: num_reactions
         real(dp), intent(in) :: 
     >      den, temp, T9, T932, rate_factors(:) ! (num_reactions)         
         real(dp), intent(out) ::    
     >      d_rzn70prot_to_ge72_dprot, d_rge72gprot_to_zn70_dprot,
     >      d_rzn68aprot_to_zn70_dprot, d_rzn70prot_to_zn68_dprot,
     >      d_rzn68aprot_to_ge72_dprot, d_rge72gprot_to_zn68_dprot         
         call get_rates_for_ap_combos(  
     >      n, g, .true., den, temp, T9, T932, y, num_reactions, rate_factors,
     >      izn68, izn70, iga71, ige72,
     >      ir_zn68_ag_ge72, ! zn68(a,g)ge72
     >      ir_ge72_ga_zn68, ! ge72(g,a)zn68  
     >      irzn68aprot_to_ge72, ! zn68(a,prot)ga71(prot,g)ge72
     >      irge72gprot_to_zn68, ! ge72(g,prot)ga71(prot,a)zn68 
     >      irzn68aprot_to_zn70, ! zn68(a,prot)ga71(g,prot)zn70
     >      irzn70prot_to_zn68, ! zn70(prot,g)ga71(prot,a)zn68
     >      irzn70prot_to_ge72, ! zn70(prot,g)ga71(prot,g)ge72
     >      irge72gprot_to_zn70, ! ge72(g,prot)ga71(g,prot)zn70 
     >      irzn68aprot_aux, ! zn68(a,prot)ga71 
     >      irga71prota_aux, ! ga71(prot,a)zn68 
     >      irzn70protg_aux, ! zn70(prot,g)ga71
     >      irga71gprot_aux, ! ga71(g,prot)zn70 
     >      irge72gprot_aux, ! ge72(g,prot)ga71 
     >      irga71protg_aux, ! ga71(prot,g)ge72 
     >      d_rzn70prot_to_ge72_dprot, d_rge72gprot_to_zn70_dprot,
     >      d_rzn68aprot_to_zn70_dprot, d_rzn70prot_to_zn68_dprot,
     >      d_rzn68aprot_to_ge72_dprot, d_rge72gprot_to_zn68_dprot)
         end subroutine get_rates_for_ga71_combos


         subroutine get_rates_for_ap_combos(   
     >      n, g, use_prot, den, temp, T9, T932, y, num_reactions, rate_factors,
     >      i_fe52, i_fe54, i_co55, i_ni56,
     >      ir_fe52_ag_ni56, ! fe52(a, g)ni56
     >      ir_ni56_ga_fe52, ! ni56(g, a)fe52 
     >      ir_fe52aprot_to_ni56, ! fe52(a, prot)co55(prot, g)ni56
     >      ir_ni56gprot_to_fe52, ! ni56(g, prot)co55(prot, a)fe52 
     >      ir_fe52aprot_to_fe54, ! fe52(a, prot)co55(g, prot)fe54
     >      ir_fe54prot_to_fe52, ! fe54(prot, g)co55(prot, a)fe52
     >      ir_fe54prot_to_ni56, ! fe54(prot, g)co55(prot, g)ni56
     >      ir_ni56gprot_to_fe54, ! ni56(g, prot)co55(g, prot)fe54 
     >      ir_fe52aprot_aux, ! fe52(a, prot)co55 
     >      ir_co55prota_aux, ! co55(prot, a)fe52 
     >      ir_fe54protg_aux, ! fe54(prot, g)co55
     >      ir_co55gprot_aux, ! co55(g, prot)fe54 
     >      ir_ni56gprot_aux, ! ni56(g, prot)co55 
     >      ir_co55protg_aux, ! co55(prot, g)ni56 
     >      d_r_fe54prot_to_ni56_dprot, d_r_ni56gprot_to_fe54_dprot,
     >      d_r_fe52aprot_to_fe54_dprot, d_r_fe54prot_to_fe52_dprot,
     >      d_r_fe52aprot_to_ni56_dprot, d_r_ni56gprot_to_fe52_dprot)    
         type (Net_Info), pointer :: n
         type (Net_General_Info), pointer  :: g
         logical, intent(in) :: use_prot
         real(dp), pointer :: y(:)
         integer, intent(in) :: num_reactions,
     >      i_fe52, i_fe54, i_co55, i_ni56,
     >      ir_fe52_ag_ni56, ! fe52(a, g)ni56
     >      ir_ni56_ga_fe52, ! ni56(g, a)fe52 
     >      ir_fe52aprot_to_ni56, ! fe52(a, prot)co55(prot, g)ni56
     >      ir_ni56gprot_to_fe52, ! ni56(g, prot)co55(prot, a)fe52 
     >      ir_fe52aprot_to_fe54, ! fe52(a, prot)co55(g, prot)fe54
     >      ir_fe54prot_to_fe52, ! fe54(prot, g)co55(prot, a)fe52
     >      ir_fe54prot_to_ni56, ! fe54(prot, g)co55(prot, g)ni56
     >      ir_ni56gprot_to_fe54, ! ni56(g, prot)co55(g, prot)fe54 
     >      ir_fe52aprot_aux, ! fe52(a, prot)co55 
     >      ir_co55prota_aux, ! co55(prot, a)fe52 
     >      ir_fe54protg_aux, ! fe54(prot, g)co55
     >      ir_co55gprot_aux, ! co55(g, prot)fe54 
     >      ir_ni56gprot_aux, ! ni56(g, prot)co55 
     >      ir_co55protg_aux ! co55(prot, g)ni56 
         real(dp), intent(in) :: den, temp, T9, T932, rate_factors(:) ! (num_reactions)         
         real(dp), intent(out) ::    
     >         d_r_fe54prot_to_ni56_dprot, d_r_ni56gprot_to_fe54_dprot,
     >         d_r_fe52aprot_to_fe54_dprot, d_r_fe54prot_to_fe52_dprot,
     >         d_r_fe52aprot_to_ni56_dprot, d_r_ni56gprot_to_fe52_dprot

         real(dp), pointer :: rates(:, :)
         integer, pointer :: rtab(:), itab(:)
         integer :: prot, ierr,
     >      r_fe52_ag_ni56, r_ni56_ga_fe52,
     >      r_fe54prot_to_ni56, r_ni56gprot_to_fe54,
     >      r_fe52aprot_to_fe54, r_fe54prot_to_fe52,
     >      r_fe52aprot_to_ni56, r_ni56gprot_to_fe52,
     >      r_fe52aprot_aux, r_fe54protg_aux, r_co55gprot_aux,
     >      r_co55protg_aux, r_co55prota_aux, r_ni56gprot_aux
         real(dp) :: 
     >      denom, denomdt, denomdd, denomdprot, 
     >      zz, d_zz_dt, d_zz_dd, d_zz_dprot,
     >      r_fe52aprot, r_fe54protg, r_co55g_prot,
     >      r_co55protg, r_co55prot_a, r_ni56g_prot,
     >      d_r_fe52aprot_dt, d_r_fe54protg_dt, d_r_co55gprot_dt,
     >      d_r_co55protg_dt, d_r_co55prota_dt, d_r_ni56gprot_dt,
     >      d_r_fe52aprot_dd, d_r_fe54protg_dd, d_r_co55gprot_dd,
     >      d_r_co55protg_dd, d_r_co55prota_dd, d_r_ni56gprot_dd         
         real(dp) :: factor, d_factor_dT
         logical :: have_reactions

         include 'formats.dek'

         rates => n% rate_screened
         rtab => g% net_reaction
         itab => g% net_iso
         
         if (use_prot) then
            prot = itab(iprot)
            if (prot == 0) prot = itab(ih1)
         else
            prot = itab(ih1)
         end if
         if (prot == 0) stop 'need prot in net'

         have_reactions = .false.
         
         if (ir_fe52_ag_ni56 /= 0) then
            r_fe52_ag_ni56 = rtab(ir_fe52_ag_ni56)
         else
            r_fe52_ag_ni56 = 0
         end if
         if (r_fe52_ag_ni56 /= 0) have_reactions = .true.
         
         if (ir_ni56_ga_fe52 /= 0) then
            r_ni56_ga_fe52 = rtab(ir_ni56_ga_fe52)
         else
            r_ni56_ga_fe52 = 0
         end if
         if (r_ni56_ga_fe52 /= 0) have_reactions = .true.
         
         call set1(ir_fe54prot_to_ni56,
     >      r_fe54prot_to_ni56, d_r_fe54prot_to_ni56_dprot)
         
         call set1(ir_ni56gprot_to_fe54,
     >      r_ni56gprot_to_fe54, d_r_ni56gprot_to_fe54_dprot)

         call set1(ir_fe52aprot_to_fe54,
     >      r_fe52aprot_to_fe54, d_r_fe52aprot_to_fe54_dprot)

         call set1(ir_fe54prot_to_fe52,
     >      r_fe54prot_to_fe52, d_r_fe54prot_to_fe52_dprot)

         call set1(ir_fe52aprot_to_ni56,
     >      r_fe52aprot_to_ni56, d_r_fe52aprot_to_ni56_dprot)

         call set1(ir_ni56gprot_to_fe52,
     >      r_ni56gprot_to_fe52, d_r_ni56gprot_to_fe52_dprot)
         
         if (.not. have_reactions) return
         if (temp < 1.5d9) return

         call set1_aux(ir_fe52aprot_aux,
     >      r_fe52aprot_aux, r_fe52aprot, d_r_fe52aprot_dt, d_r_fe52aprot_dd)
                  
         call set1_aux(ir_fe54protg_aux,
     >      r_fe54protg_aux, r_fe54protg, d_r_fe54protg_dt, d_r_fe54protg_dd)
                  
         call set1_aux(ir_co55gprot_aux,
     >      r_co55gprot_aux, r_co55g_prot, d_r_co55gprot_dt, d_r_co55gprot_dd)
                  
         call set1_aux(ir_co55protg_aux,
     >      r_co55protg_aux, r_co55protg, d_r_co55protg_dt, d_r_co55protg_dd)
                  
         call set1_aux(ir_co55prota_aux,
     >      r_co55prota_aux, r_co55prot_a, d_r_co55prota_dt, d_r_co55prota_dd)
                  
         call set1_aux(ir_ni56gprot_aux,
     >      r_ni56gprot_aux, r_ni56g_prot, d_r_ni56gprot_dt, d_r_ni56gprot_dd)


         denom = r_co55g_prot + y(prot)*(r_co55protg + r_co55prot_a)         
         if (denom < 1d-12) return

         denomdt = d_r_co55gprot_dt + y(prot)*(d_r_co55protg_dt + d_r_co55prota_dt)
         denomdd = d_r_co55gprot_dd + y(prot)*(d_r_co55protg_dd + d_r_co55prota_dd)
         denomdprot = r_co55protg + r_co55prot_a
         
         zz = 1/denom
         d_zz_dt = -denomdt/denom**2
         d_zz_dd = -denomdd/denom**2
         d_zz_dprot = -denomdprot/denom**2
         
         if (r_fe54prot_to_ni56 /= 0) then ! fe54(prot,g)co55(prot,g)ni56
         
            rates(i_rate,r_fe54prot_to_ni56) = r_fe54protg*r_co55protg*zz
            
            rates(i_rate_dT,r_fe54prot_to_ni56) = 
     >         d_r_fe54protg_dt*r_co55protg*zz +
     >         r_fe54protg*d_r_co55protg_dt*zz +
     >         r_fe54protg*r_co55protg*d_zz_dt

            rates(i_rate_dRho,r_fe54prot_to_ni56) = 
     >         d_r_fe54protg_dd*r_co55protg*zz +
     >         r_fe54protg*d_r_co55protg_dd*zz +
     >         r_fe54protg*r_co55protg*d_zz_dd

            d_r_fe54prot_to_ni56_dprot = r_fe54protg*r_co55protg*d_zz_dprot
         
            rates(:,r_fe54prot_to_ni56) = 
     >         rates(:,r_fe54prot_to_ni56)*rate_factors(r_fe54prot_to_ni56)
            d_r_fe54prot_to_ni56_dprot = 
     >         d_r_fe54prot_to_ni56_dprot*rate_factors(r_fe54prot_to_ni56)
            
         end if
         
         if (r_ni56gprot_to_fe54 /= 0) then ! ni56(g,prot)co55(g,prot)fe54
         
            rates(i_rate,r_ni56gprot_to_fe54) = r_ni56g_prot*r_co55g_prot*zz
            
            rates(i_rate_dT,r_ni56gprot_to_fe54) = 
     >         d_r_ni56gprot_dt*r_co55g_prot*zz +
     >         r_ni56g_prot*d_r_co55gprot_dt*zz +
     >         r_ni56g_prot*r_co55g_prot*d_zz_dt

            rates(i_rate_dRho,r_ni56gprot_to_fe54) = 
     >         d_r_ni56gprot_dd*r_co55g_prot*zz +
     >         r_ni56g_prot*d_r_co55gprot_dd*zz +
     >         r_ni56g_prot*r_co55g_prot*d_zz_dd

            d_r_ni56gprot_to_fe54_dprot = r_ni56g_prot*r_co55g_prot*d_zz_dprot
         
            rates(:,r_ni56gprot_to_fe54) = 
     >         rates(:,r_ni56gprot_to_fe54)*rate_factors(r_ni56gprot_to_fe54)
            d_r_ni56gprot_to_fe54_dprot = 
     >         d_r_ni56gprot_to_fe54_dprot*rate_factors(r_ni56gprot_to_fe54)
 
         end if
         
         if (r_fe52aprot_to_fe54 /= 0) then ! fe52(a,prot)co55(g,prot)fe54
         
            rates(i_rate,r_fe52aprot_to_fe54) = r_fe52aprot*r_co55g_prot*zz
            
            rates(i_rate_dT,r_fe52aprot_to_fe54) = 
     >         d_r_fe52aprot_dt*r_co55g_prot*zz +
     >         r_fe52aprot*d_r_co55gprot_dt*zz +
     >         r_fe52aprot*r_co55g_prot*d_zz_dt

            rates(i_rate_dRho,r_fe52aprot_to_fe54) = 
     >         d_r_fe52aprot_dd*r_co55g_prot*zz +
     >         r_fe52aprot*d_r_co55gprot_dd*zz +
     >         r_fe52aprot*r_co55g_prot*d_zz_dd

            d_r_fe52aprot_to_fe54_dprot = r_fe52aprot*r_co55g_prot*d_zz_dprot
         
            rates(:,r_fe52aprot_to_fe54) = 
     >         rates(:,r_fe52aprot_to_fe54)*rate_factors(r_fe52aprot_to_fe54)
            d_r_fe52aprot_to_fe54_dprot = 
     >         d_r_fe52aprot_to_fe54_dprot*rate_factors(r_fe52aprot_to_fe54)
 
         end if
         
         if (r_fe54prot_to_fe52 /= 0) then ! fe54(prot,g)co55(prot,a)fe52
         
            rates(i_rate,r_fe54prot_to_fe52) = r_fe54protg*r_co55prot_a*zz
            
            rates(i_rate_dT,r_fe54prot_to_fe52) = 
     >         d_r_fe54protg_dt*r_co55prot_a*zz +
     >         r_fe54protg*d_r_co55prota_dt*zz +
     >         r_fe54protg*r_co55prot_a*d_zz_dt

            rates(i_rate_dRho,r_fe54prot_to_fe52) = 
     >         d_r_fe54protg_dd*r_co55prot_a*zz +
     >         r_fe54protg*d_r_co55prota_dd*zz +
     >         r_fe54protg*r_co55prot_a*d_zz_dd

            d_r_fe54prot_to_fe52_dprot = 
     >            r_fe54protg*r_co55prot_a*d_zz_dprot
         
            rates(:,r_fe54prot_to_fe52) = 
     >         rates(:,r_fe54prot_to_fe52)*rate_factors(r_fe54prot_to_fe52)
            d_r_fe54prot_to_fe52_dprot = 
     >         d_r_fe54prot_to_fe52_dprot*rate_factors(r_fe54prot_to_fe52)
 
         end if
         
         if (r_fe52aprot_to_ni56 /= 0) then ! fe52(a,prot)co55(prot,g)ni56
         
            rates(i_rate,r_fe52aprot_to_ni56) = r_fe52aprot*r_co55protg*zz
            
            rates(i_rate_dT,r_fe52aprot_to_ni56) = 
     >        d_r_fe52aprot_dt*r_co55protg*zz  +
     >        r_fe52aprot*d_r_co55protg_dt*zz  +
     >        r_fe52aprot*r_co55protg*d_zz_dt

            rates(i_rate_dRho,r_fe52aprot_to_ni56) = 
     >        d_r_fe52aprot_dd*r_co55protg*zz  +
     >        r_fe52aprot*d_r_co55protg_dd*zz  +
     >        r_fe52aprot*r_co55protg*d_zz_dd

            d_r_fe52aprot_to_ni56_dprot = r_fe52aprot*r_co55protg*d_zz_dprot

            rates(:,r_fe52aprot_to_ni56) = 
     >         rates(:,r_fe52aprot_to_ni56)*rate_factors(r_fe52aprot_to_ni56)
            d_r_fe52aprot_to_ni56_dprot = 
     >         d_r_fe52aprot_to_ni56_dprot*rate_factors(r_fe52aprot_to_ni56)
 
         end if
         
         if (r_ni56gprot_to_fe52 /= 0) then ! ni56(g,prot)co55(prot,a)fe52
         
            rates(i_rate,r_ni56gprot_to_fe52) = 
     >            r_ni56g_prot*r_co55prot_a*zz            
            rates(i_rate_dT,r_ni56gprot_to_fe52) = 
     >         d_r_ni56gprot_dt*r_co55prot_a*zz +
     >         r_ni56g_prot*d_r_co55prota_dt*zz +
     >         r_ni56g_prot*r_co55prot_a*d_zz_dt
         
            rates(i_rate_dRho,r_ni56gprot_to_fe52) = 
     >         d_r_ni56gprot_dd*r_co55prot_a*zz +
     >         r_ni56g_prot*d_r_co55prota_dd*zz +
     >         r_ni56g_prot*r_co55prot_a*d_zz_dd
     
            d_r_ni56gprot_to_fe52_dprot = 
     >            r_ni56g_prot*r_co55prot_a*d_zz_dprot
     
            rates(:,r_ni56gprot_to_fe52) = 
     >         rates(:,r_ni56gprot_to_fe52)*rate_factors(r_ni56gprot_to_fe52)
     
            d_r_ni56gprot_to_fe52_dprot = 
     >         d_r_ni56gprot_to_fe52_dprot*rate_factors(r_ni56gprot_to_fe52)
 
         end if
         
         factor = n% factor_prot
         d_factor_dT = n% d_factor_prot_dT
         if (factor < 1d0) then
            if (ir_fe52aprot_to_fe54 /= 0 .and. ir_fe54prot_to_fe52 /= 0) then
               call limit_pair_at_very_high_T(
     >            ir_fe52aprot_to_fe54, ir_fe54prot_to_fe52, 
     >            rates, rtab, factor, d_factor_dT, .false.)
               d_r_fe52aprot_to_fe54_dprot = factor*d_r_fe52aprot_to_fe54_dprot
               d_r_fe54prot_to_fe52_dprot = factor*d_r_fe54prot_to_fe52_dprot
               end if
            if (ir_fe54prot_to_ni56 /= 0 .and. ir_ni56gprot_to_fe54 /= 0) then
               call limit_pair_at_very_high_T(
     >            ir_fe54prot_to_ni56, ir_ni56gprot_to_fe54, 
     >            rates, rtab, factor, d_factor_dT, .false.)
               d_r_fe54prot_to_ni56_dprot = factor*d_r_fe54prot_to_ni56_dprot
               d_r_ni56gprot_to_fe54_dprot = factor*d_r_ni56gprot_to_fe54_dprot
               end if
         
            if (ir_fe52aprot_to_ni56 /= 0 .and. ir_ni56gprot_to_fe52 /= 0) then
               call limit_pair_at_very_high_T(
     >            ir_fe52aprot_to_ni56, ir_ni56gprot_to_fe52, 
     >            rates, rtab, factor, d_factor_dT, .false.)
               d_r_fe52aprot_to_ni56_dprot = factor*d_r_fe52aprot_to_ni56_dprot
               d_r_ni56gprot_to_fe52_dprot = factor*d_r_ni56gprot_to_fe52_dprot
            end if
         
         end if

         factor = n% factor_combo_a_capture
         d_factor_dT = n% d_factor_combo_a_capture_dT
         if (factor == 1d0) return
         
         if (ir_fe52_ag_ni56 /= 0 .and. ir_ni56_ga_fe52 /= 0) then
            call limit_pair_at_very_high_T(
     >         ir_fe52_ag_ni56, ir_ni56_ga_fe52, 
     >         rates, rtab, factor, d_factor_dT, .false.)
         end if
         
         contains
         
         subroutine set1(ir_fe54prot_to_ni56,
     >         r_fe54prot_to_ni56, d_r_fe54prot_to_ni56_dprot)
            integer, intent(in) :: ir_fe54prot_to_ni56
            integer, intent(out) :: r_fe54prot_to_ni56
            real(dp), intent(out) :: d_r_fe54prot_to_ni56_dprot
            if (ir_fe54prot_to_ni56 /= 0) then
               r_fe54prot_to_ni56 = 
     >            rtab(ir_fe54prot_to_ni56) ! fe54(prot,g)co55(prot,g)ni56
            else
               r_fe54prot_to_ni56 = 0
            end if
            if (r_fe54prot_to_ni56 /= 0) then
               have_reactions = .true.
               rates(:,r_fe54prot_to_ni56) = 0
            end if
            d_r_fe54prot_to_ni56_dprot = 0
         end subroutine set1
         
         subroutine set1_aux(ir_fe52aprot_aux,
     >         r_fe52aprot_aux, r_fe52aprot, d_r_fe52aprot_dt, d_r_fe52aprot_dd)
            integer, intent(in) :: ir_fe52aprot_aux
            integer, intent(out) :: r_fe52aprot_aux
            real(dp), intent(out) ::
     >         r_fe52aprot, d_r_fe52aprot_dt, d_r_fe52aprot_dd
            if (ir_fe52aprot_aux /= 0) then
               r_fe52aprot_aux = rtab(ir_fe52aprot_aux)         
            else                    
               r_fe52aprot_aux = 0
            end if         
            if (r_fe52aprot_aux /= 0) then
               r_fe52aprot = 
     >            rates(i_rate,r_fe52aprot_aux)*rate_factors(r_fe52aprot_aux)
               d_r_fe52aprot_dt = 
     >            rates(i_rate_dT,r_fe52aprot_aux)*rate_factors(r_fe52aprot_aux)
               d_r_fe52aprot_dd = 
     >            rates(i_rate_dRho,r_fe52aprot_aux)*rate_factors(r_fe52aprot_aux)
            else
               r_fe52aprot = 0
               d_r_fe52aprot_dt = 0
               d_r_fe52aprot_dd = 0
            end if
         end subroutine set1_aux

      end subroutine get_rates_for_ap_combos

      
      subroutine T_limit_intermediate_combo_a_captures(n)
         type (Net_Info), pointer :: n

         real(dp), pointer :: rates(:, :)
         integer, pointer :: rtab(:)
         type (Net_General_Info), pointer  :: g
         real(dp) :: factor, d_factor_dT

         factor = n% factor_a_cap_intermediate
         d_factor_dT = n% d_factor_a_cap_intermediate_dT
         if (factor == 1d0) return

         g => n% g
         rates => n% rate_screened
         rtab => g% net_reaction

         call do1_pair(ir_ne20_ag_mg24, ir_mg24_ga_ne20)        
         !call do1_pair(irne20ap_to_mg24, irmg24gp_to_ne20)                       
         
         call do1_pair(ir_mg24_ag_si28, ir_si28_ga_mg24)         
         !call do1_pair(irmg24ap_to_si28, irsi28gp_to_mg24)
         
         call do1_pair(ir_si28_ag_s32, ir_s32_ga_si28)         
         !call do1_pair(irsi28ap_to_s32, irs32gp_to_si28)        
         
         call do1_pair(ir_s32_ag_ar36, ir_ar36_ga_s32)         
         !call do1_pair(irs32ap_to_ar36, irar36gp_to_s32)        
         
         call do1_pair(ir_ar36_ag_ca40, ir_ca40_ga_ar36)         
         !call do1_pair(irar36ap_to_ca40, irca40gp_to_ar36)       
         
         call do1_pair(ir_ca40_ag_ti44, ir_ti44_ga_ca40)         
         !call do1_pair(irca40ap_to_ti44, irti44gp_to_ca40)         
         
         call do1_pair(ir_ca42_ag_ti46, ir_ti46_ga_ca42)         
         !call do1_pair(irca42ap_to_ti46, irti46gp_to_ca42)         
         
         call do1_pair(ir_ca44_ag_ti48, ir_ti48_ga_ca44)         
         !call do1_pair(irca44ap_to_ti48, irti48gp_to_ca44)         
         
         call do1_pair(ir_ca46_ag_ti50, ir_ti50_ga_ca46)         
         !call do1_pair(irca46ap_to_ti50, irti50gp_to_ca46)         
         
         call do1_pair(ir_ca48_ag_ti52, ir_ti52_ga_ca48)         
         !call do1_pair(irca48ap_to_ti52, irti52gp_to_ca48)         

         call do1_pair(ir_ti44_ag_cr48, ir_cr48_ga_ti44)         
         !call do1_pair(irti44ap_to_cr48, ircr48gp_to_ti44)

         call do1_pair(ir_ti46_ag_cr50, ir_cr50_ga_ti46)         
         !call do1_pair(irti46ap_to_cr50, ircr50gp_to_ti46)

         call do1_pair(ir_ti48_ag_cr52, ir_cr52_ga_ti48)         
         !call do1_pair(irti48ap_to_cr52, ircr52gp_to_ti48)

         call do1_pair(ir_ti50_ag_cr54, ir_cr54_ga_ti50)         
         !call do1_pair(irti50ap_to_cr54, ircr54gp_to_ti50)

         call do1_pair(ir_ti52_ag_cr56, ir_cr56_ga_ti52)         
         !call do1_pair(irti52ap_to_cr56, ircr56gp_to_ti52)
         
         call do1_pair(ir_cr48_ag_fe52, ir_fe52_ga_cr48)
         !call do1_pair(ircr48ap_to_fe52, irfe52gp_to_cr48)
                  
         call do1_pair(ir_cr50_ag_fe54, ir_fe54_ga_cr50)
         !call do1_pair(ircr50ap_to_fe54, irfe54gp_to_cr50)
         
         call do1_pair(ir_cr52_ag_fe56, ir_fe56_ga_cr52)
         !call do1_pair(ircr52ap_to_fe56, irfe56gp_to_cr52)
         
         call do1_pair(ir_cr54_ag_fe58, ir_fe58_ga_cr54)
         !call do1_pair(ircr54ap_to_fe58, irfe58gp_to_cr54)
         
         call do1_pair(ir_cr56_ag_fe60, ir_fe60_ga_cr56)
         !call do1_pair(ircr56ap_to_fe60, irfe60gp_to_cr56)
         
         
         contains

         subroutine do1_pair(ir_fe52_ag_ni56, ir_ni56_ga_fe52)
            integer, intent(in) :: ir_fe52_ag_ni56, ir_ni56_ga_fe52
            call limit_pair_at_very_high_T(
     >         ir_fe52_ag_ni56, ir_ni56_ga_fe52, 
     >         rates, rtab, factor, d_factor_dT, .false.)
         end subroutine do1_pair
      
      end subroutine T_limit_intermediate_combo_a_captures

      
      subroutine T_limit_high_mass_a_captures(n) 
         ! for alpha captures not done as part of combo
         type (Net_Info), pointer :: n

         real(dp), pointer :: rates(:, :)
         integer, pointer :: rtab(:)
         type (Net_General_Info), pointer  :: g
         real(dp) :: factor, d_factor_dT

         factor = n% factor_a_cap_high_mass
         d_factor_dT = n% d_factor_a_cap_high_mass_dT
         if (factor == 1d0) return

         g => n% g
         rates => n% rate_screened
         rtab => g% net_reaction
         
         ! all done as part of combos.

         !call do1_pair(ir_cr56_ag_fe60, ir_fe60_ga_cr56)  
         !call do1_pair(ir_ni64_ag_zn68, ir_zn68_ga_ni64)        
         !call do1_pair(ir_zn68_ag_ge72, ir_ge72_ga_zn68)        
         
         contains

         subroutine do1_pair(ir_fe52_ag_ni56, ir_ni56_ga_fe52)
            integer, intent(in) :: ir_fe52_ag_ni56, ir_ni56_ga_fe52
            call limit_pair_at_very_high_T(
     >         ir_fe52_ag_ni56, ir_ni56_ga_fe52, 
     >         rates, rtab, factor, d_factor_dT, .false.)
         end subroutine do1_pair
      
      end subroutine T_limit_high_mass_a_captures

            
      subroutine get_rates_for_ne20_ne22( ! ne20 + 2n <=> ne22 via ne21
     >      n, g, den, temp, T9, T932, y, num_reactions, rate_factors)        
         type (Net_Info), pointer :: n
         type (Net_General_Info), pointer  :: g
         real(dp), pointer :: y(:)
         integer, intent(in) :: num_reactions
         real(dp), intent(in) :: den, temp, T9, T932, rate_factors(:)     
         call get_rates_for_A_neut_C( 
     >      n, g, den, temp, T9, T932, y, num_reactions, rate_factors,
     >      ine20, ine22, irne20ng_to_ne22, irne22gn_to_ne20,
     >      irne20ng_aux, irne21ng_aux, irne21gn_aux, irne22gn_aux,
     >      n% d_rne20neut_to_ne22_dneut, n% d_rne22g_to_ne20_dneut)
      end subroutine get_rates_for_ne20_ne22

            
      subroutine get_rates_for_ca40_ca42( ! ca40 + 2n <=> ca42 via ca41
     >      n, g, den, temp, T9, T932, y, num_reactions, rate_factors)        
         type (Net_Info), pointer :: n
         type (Net_General_Info), pointer  :: g
         real(dp), pointer :: y(:)
         integer, intent(in) :: num_reactions
         real(dp), intent(in) :: den, temp, T9, T932, rate_factors(:)     
         call get_rates_for_A_neut_C( 
     >      n, g, den, temp, T9, T932, y, num_reactions, rate_factors,
     >      ica40, ica42, irca40ng_to_ca42, irca42gn_to_ca40,
     >      irca40ng_aux, irca41ng_aux, irca41gn_aux, irca42gn_aux,
     >      n% d_rca40neut_to_ca42_dneut, n% d_rca42g_to_ca40_dneut)
      end subroutine get_rates_for_ca40_ca42

            
      subroutine get_rates_for_ca42_ca44( ! ca42 + 2n <=> ca44 via ca43
     >      n, g, den, temp, T9, T932, y, num_reactions, rate_factors)        
         type (Net_Info), pointer :: n
         type (Net_General_Info), pointer  :: g
         real(dp), pointer :: y(:)
         integer, intent(in) :: num_reactions
         real(dp), intent(in) :: den, temp, T9, T932, rate_factors(:)     
         call get_rates_for_A_neut_C( 
     >      n, g, den, temp, T9, T932, y, num_reactions, rate_factors,
     >      ica42, ica44, irca42ng_to_ca44, irca44gn_to_ca42,
     >      irca42ng_aux, irca43ng_aux, irca43gn_aux, irca44gn_aux,
     >      n% d_rca42neut_to_ca44_dneut, n% d_rca44g_to_ca42_dneut)
      end subroutine get_rates_for_ca42_ca44

            
      subroutine get_rates_for_ca44_ca46( ! ca44 + 2n <=> ca46 via ca45
     >      n, g, den, temp, T9, T932, y, num_reactions, rate_factors)        
         type (Net_Info), pointer :: n
         type (Net_General_Info), pointer  :: g
         real(dp), pointer :: y(:)
         integer, intent(in) :: num_reactions
         real(dp), intent(in) :: den, temp, T9, T932, rate_factors(:)     
         call get_rates_for_A_neut_C( 
     >      n, g, den, temp, T9, T932, y, num_reactions, rate_factors,
     >      ica44, ica46, irca44ng_to_ca46, irca46gn_to_ca44,
     >      irca44ng_aux, irca45ng_aux, irca45gn_aux, irca46gn_aux,
     >      n% d_rca44neut_to_ca46_dneut, n% d_rca46g_to_ca44_dneut)
      end subroutine get_rates_for_ca44_ca46

            
      subroutine get_rates_for_ca46_ca48( ! ca46 + 2n <=> ca48 via ca47
     >      n, g, den, temp, T9, T932, y, num_reactions, rate_factors)        
         type (Net_Info), pointer :: n
         type (Net_General_Info), pointer  :: g
         real(dp), pointer :: y(:)
         integer, intent(in) :: num_reactions
         real(dp), intent(in) :: den, temp, T9, T932, rate_factors(:)     
         call get_rates_for_A_neut_C( 
     >      n, g, den, temp, T9, T932, y, num_reactions, rate_factors,
     >      ica46, ica48, irca46ng_to_ca48, irca48gn_to_ca46,
     >      irca46ng_aux, irca47ng_aux, irca47gn_aux, irca48gn_aux,
     >      n% d_rca46neut_to_ca48_dneut, n% d_rca48g_to_ca46_dneut)
      end subroutine get_rates_for_ca46_ca48

            
      subroutine get_rates_for_ti44_ti46( ! ti44 + 2n <=> ti46 via ti45
     >      n, g, den, temp, T9, T932, y, num_reactions, rate_factors)        
         type (Net_Info), pointer :: n
         type (Net_General_Info), pointer  :: g
         real(dp), pointer :: y(:)
         integer, intent(in) :: num_reactions
         real(dp), intent(in) :: den, temp, T9, T932, rate_factors(:)     
         call get_rates_for_A_neut_C( 
     >      n, g, den, temp, T9, T932, y, num_reactions, rate_factors,
     >      iti44, iti46, irti44ng_to_ti46, irti46gn_to_ti44,
     >      irti44ng_aux, irti45ng_aux, irti45gn_aux, irti46gn_aux,
     >      n% d_rti44neut_to_ti46_dneut, n% d_rti46g_to_ti44_dneut)
      end subroutine get_rates_for_ti44_ti46

            
      subroutine get_rates_for_ti46_ti48( ! ti46 + 2n <=> ti48 via ti47
     >      n, g, den, temp, T9, T932, y, num_reactions, rate_factors)        
         type (Net_Info), pointer :: n
         type (Net_General_Info), pointer  :: g
         real(dp), pointer :: y(:)
         integer, intent(in) :: num_reactions
         real(dp), intent(in) :: den, temp, T9, T932, rate_factors(:)     
         call get_rates_for_A_neut_C( 
     >      n, g, den, temp, T9, T932, y, num_reactions, rate_factors,
     >      iti46, iti48, irti46ng_to_ti48, irti48gn_to_ti46,
     >      irti46ng_aux, irti47ng_aux, irti47gn_aux, irti48gn_aux,
     >      n% d_rti46neut_to_ti48_dneut, n% d_rti48g_to_ti46_dneut)
      end subroutine get_rates_for_ti46_ti48

            
      subroutine get_rates_for_ti48_ti50( ! ti48 + 2n <=> ti50 via ti49
     >      n, g, den, temp, T9, T932, y, num_reactions, rate_factors)        
         type (Net_Info), pointer :: n
         type (Net_General_Info), pointer  :: g
         real(dp), pointer :: y(:)
         integer, intent(in) :: num_reactions
         real(dp), intent(in) :: den, temp, T9, T932, rate_factors(:)     
         call get_rates_for_A_neut_C( 
     >      n, g, den, temp, T9, T932, y, num_reactions, rate_factors,
     >      iti48, iti50, irti48ng_to_ti50, irti50gn_to_ti48,
     >      irti48ng_aux, irti49ng_aux, irti49gn_aux, irti50gn_aux,
     >      n% d_rti48neut_to_ti50_dneut, n% d_rti50g_to_ti48_dneut)
      end subroutine get_rates_for_ti48_ti50

            
      subroutine get_rates_for_ti50_ti52( ! ti50 + 2n <=> ti52 via ti51
     >      n, g, den, temp, T9, T932, y, num_reactions, rate_factors)        
         type (Net_Info), pointer :: n
         type (Net_General_Info), pointer  :: g
         real(dp), pointer :: y(:)
         integer, intent(in) :: num_reactions
         real(dp), intent(in) :: den, temp, T9, T932, rate_factors(:)     
         call get_rates_for_A_neut_C( 
     >      n, g, den, temp, T9, T932, y, num_reactions, rate_factors,
     >      iti50, iti52, irti50ng_to_ti52, irti52gn_to_ti50,
     >      irti50ng_aux, irti51ng_aux, irti51gn_aux, irti52gn_aux,
     >      n% d_rti50neut_to_ti52_dneut, n% d_rti52g_to_ti50_dneut)
      end subroutine get_rates_for_ti50_ti52

            
      subroutine get_rates_for_cr48_cr50( ! cr48 + 2n <=> cr50 via cr49
     >      n, g, den, temp, T9, T932, y, num_reaccrons, rate_factors)        
         type (Net_Info), pointer :: n
         type (Net_General_Info), pointer  :: g
         real(dp), pointer :: y(:)
         integer, intent(in) :: num_reaccrons
         real(dp), intent(in) :: den, temp, T9, T932, rate_factors(:)     
         call get_rates_for_A_neut_C( 
     >      n, g, den, temp, T9, T932, y, num_reaccrons, rate_factors,
     >      icr48, icr50, ircr48ng_to_cr50, ircr50gn_to_cr48,
     >      ircr48ng_aux, ircr49ng_aux, ircr49gn_aux, ircr50gn_aux,
     >      n% d_rcr48neut_to_cr50_dneut, n% d_rcr50g_to_cr48_dneut)
      end subroutine get_rates_for_cr48_cr50

            
      subroutine get_rates_for_cr50_cr52( ! cr50 + 2n <=> cr52 via cr51
     >      n, g, den, temp, T9, T932, y, num_reaccrons, rate_factors)        
         type (Net_Info), pointer :: n
         type (Net_General_Info), pointer  :: g
         real(dp), pointer :: y(:)
         integer, intent(in) :: num_reaccrons
         real(dp), intent(in) :: den, temp, T9, T932, rate_factors(:)     
         call get_rates_for_A_neut_C( 
     >      n, g, den, temp, T9, T932, y, num_reaccrons, rate_factors,
     >      icr50, icr52, ircr50ng_to_cr52, ircr52gn_to_cr50,
     >      ircr50ng_aux, ircr51ng_aux, ircr51gn_aux, ircr52gn_aux,
     >      n% d_rcr50neut_to_cr52_dneut, n% d_rcr52g_to_cr50_dneut)
      end subroutine get_rates_for_cr50_cr52

            
      subroutine get_rates_for_cr52_cr54( ! cr52 + 2n <=> cr54 via cr53
     >      n, g, den, temp, T9, T932, y, num_reaccrons, rate_factors)        
         type (Net_Info), pointer :: n
         type (Net_General_Info), pointer  :: g
         real(dp), pointer :: y(:)
         integer, intent(in) :: num_reaccrons
         real(dp), intent(in) :: den, temp, T9, T932, rate_factors(:)     
         call get_rates_for_A_neut_C( 
     >      n, g, den, temp, T9, T932, y, num_reaccrons, rate_factors,
     >      icr52, icr54, ircr52ng_to_cr54, ircr54gn_to_cr52,
     >      ircr52ng_aux, ircr53ng_aux, ircr53gn_aux, ircr54gn_aux,
     >      n% d_rcr52neut_to_cr54_dneut, n% d_rcr54g_to_cr52_dneut)
      end subroutine get_rates_for_cr52_cr54

            
      subroutine get_rates_for_cr54_cr56( ! cr54 + 2n <=> cr56 via cr55
     >      n, g, den, temp, T9, T932, y, num_reactions, rate_factors)        
         type (Net_Info), pointer :: n
         type (Net_General_Info), pointer  :: g
         real(dp), pointer :: y(:)
         integer, intent(in) :: num_reactions
         real(dp), intent(in) :: den, temp, T9, T932, rate_factors(:)     
         call get_rates_for_A_neut_C( 
     >      n, g, den, temp, T9, T932, y, num_reactions, rate_factors,
     >      icr54, icr56, ircr54ng_to_cr56, ircr56gn_to_cr54,
     >      ircr54ng_aux, ircr55ng_aux, ircr55gn_aux, ircr56gn_aux,
     >      n% d_rcr54neut_to_cr56_dneut, n% d_rcr56g_to_cr54_dneut)
      end subroutine get_rates_for_cr54_cr56

            
      subroutine get_rates_for_fe52_fe54( ! fe52 + 2n <=> fe54 via fe53
     >      n, g, den, temp, T9, T932, y, num_reactions, rate_factors)        
         type (Net_Info), pointer :: n
         type (Net_General_Info), pointer  :: g
         real(dp), pointer :: y(:)
         integer, intent(in) :: num_reactions
         real(dp), intent(in) :: den, temp, T9, T932, rate_factors(:)     
         call get_rates_for_A_neut_C( 
     >      n, g, den, temp, T9, T932, y, num_reactions, rate_factors,
     >      ife52, ife54, irfe52neut_to_fe54, irfe54g_to_fe52,
     >      irfe52ng_aux, irfe53ng_aux, irfe53gn_aux, irfe54gn_aux,
     >      n% d_rfe52neut_to_fe54_dneut, n% d_rfe54g_to_fe52_dneut)
      end subroutine get_rates_for_fe52_fe54

            
      subroutine get_rates_for_fe54_fe56( ! fe54 + 2n <=> fe56 via fe55
     >      n, g, den, temp, T9, T932, y, num_reactions, rate_factors)        
         type (Net_Info), pointer :: n
         type (Net_General_Info), pointer  :: g
         real(dp), pointer :: y(:)
         integer, intent(in) :: num_reactions
         real(dp), intent(in) :: den, temp, T9, T932, rate_factors(:)     
         call get_rates_for_A_neut_C( 
     >      n, g, den, temp, T9, T932, y, num_reactions, rate_factors,
     >      ife54, ife56, irfe54ng_to_fe56, irfe56gn_to_fe54,
     >      irfe54ng_aux, irfe55ng_aux, irfe55gn_aux, irfe56gn_aux,
     >      n% d_rfe54neut_to_fe56_dneut, n% d_rfe56g_to_fe54_dneut)
      end subroutine get_rates_for_fe54_fe56

            
      subroutine get_rates_for_fe56_fe58( ! fe56 + 2n <=> fe58 via fe57
     >      n, g, den, temp, T9, T932, y, num_reactions, rate_factors)        
         type (Net_Info), pointer :: n
         type (Net_General_Info), pointer  :: g
         real(dp), pointer :: y(:)
         integer, intent(in) :: num_reactions
         real(dp), intent(in) :: den, temp, T9, T932, rate_factors(:)       
         call get_rates_for_A_neut_C( 
     >      n, g, den, temp, T9, T932, y, num_reactions, rate_factors,
     >      ife56, ife58, irfe56ng_to_fe58, irfe58gn_to_fe56,
     >      irfe56ng_aux, irfe57ng_aux, irfe57gn_aux, irfe58gn_aux,
     >      n% d_rfe56neut_to_fe58_dneut, n% d_rfe58g_to_fe56_dneut)
      end subroutine get_rates_for_fe56_fe58

            
      subroutine get_rates_for_fe58_fe60( ! fe58 + 2n <=> fe60 via fe59
     >      n, g, den, temp, T9, T932, y, num_reactions, rate_factors)        
         type (Net_Info), pointer :: n
         type (Net_General_Info), pointer  :: g
         real(dp), pointer :: y(:)
         integer, intent(in) :: num_reactions
         real(dp), intent(in) :: den, temp, T9, T932, rate_factors(:)     
         call get_rates_for_A_neut_C( 
     >      n, g, den, temp, T9, T932, y, num_reactions, rate_factors,
     >      ife58, ife60, irfe58ng_to_fe60, irfe60gn_to_fe58,
     >      irfe58ng_aux, irfe59ng_aux, irfe59gn_aux, irfe60gn_aux,
     >      n% d_rfe58neut_to_fe60_dneut, n% d_rfe60g_to_fe58_dneut)
      end subroutine get_rates_for_fe58_fe60

            
      subroutine get_rates_for_fe60_fe62( ! fe60 + 2n <=> fe62 via fe61
     >      n, g, den, temp, T9, T932, y, num_reactions, rate_factors)        
         type (Net_Info), pointer :: n
         type (Net_General_Info), pointer  :: g
         real(dp), pointer :: y(:)
         integer, intent(in) :: num_reactions
         real(dp), intent(in) :: den, temp, T9, T932, rate_factors(:)     
         call get_rates_for_A_neut_C( 
     >      n, g, den, temp, T9, T932, y, num_reactions, rate_factors,
     >      ife60, ife62, irfe60ng_to_fe62, irfe62gn_to_fe60,
     >      irfe60ng_aux, irfe61ng_aux, irfe61gn_aux, irfe62gn_aux,
     >      n% d_rfe60neut_to_fe62_dneut, n% d_rfe62g_to_fe60_dneut)
      end subroutine get_rates_for_fe60_fe62

            
      subroutine get_rates_for_ni56_ni58( ! ni56 + 2n <=> ni58 via ni57
     >      n, g, den, temp, T9, T932, y, num_reactions, rate_factors)        
         type (Net_Info), pointer :: n
         type (Net_General_Info), pointer  :: g
         real(dp), pointer :: y(:)
         integer, intent(in) :: num_reactions
         real(dp), intent(in) :: den, temp, T9, T932, rate_factors(:)       
         call get_rates_for_A_neut_C( 
     >      n, g, den, temp, T9, T932, y, num_reactions, rate_factors,
     >      ini56, ini58, irni56ng_to_ni58, irni58gn_to_ni56,
     >      irni56ng_aux, irni57ng_aux, irni57gn_aux, irni58gn_aux,
     >      n% d_rni56neut_to_ni58_dneut, n% d_rni58g_to_ni56_dneut)
      end subroutine get_rates_for_ni56_ni58

            
      subroutine get_rates_for_ni58_ni60( ! ni58 + 2n <=> ni60 via ni59
     >      n, g, den, temp, T9, T932, y, num_reactions, rate_factors)        
         type (Net_Info), pointer :: n
         type (Net_General_Info), pointer  :: g
         real(dp), pointer :: y(:)
         integer, intent(in) :: num_reactions
         real(dp), intent(in) :: den, temp, T9, T932, rate_factors(:)       
         call get_rates_for_A_neut_C( 
     >      n, g, den, temp, T9, T932, y, num_reactions, rate_factors,
     >      ini58, ini60, irni58ng_to_ni60, irni60gn_to_ni58,
     >      irni58ng_aux, irni59ng_aux, irni59gn_aux, irni60gn_aux,
     >      n% d_rni58neut_to_ni60_dneut, n% d_rni60g_to_ni58_dneut)
      end subroutine get_rates_for_ni58_ni60

            
      subroutine get_rates_for_ni60_ni62( ! ni60 + 2n <=> ni62 via ni61
     >      n, g, den, temp, T9, T932, y, num_reactions, rate_factors)        
         type (Net_Info), pointer :: n
         type (Net_General_Info), pointer  :: g
         real(dp), pointer :: y(:)
         integer, intent(in) :: num_reactions
         real(dp), intent(in) :: den, temp, T9, T932, rate_factors(:)       
         call get_rates_for_A_neut_C( 
     >      n, g, den, temp, T9, T932, y, num_reactions, rate_factors,
     >      ini60, ini62, irni60ng_to_ni62, irni62gn_to_ni60,
     >      irni60ng_aux, irni61ng_aux, irni61gn_aux, irni62gn_aux,
     >      n% d_rni60neut_to_ni62_dneut, n% d_rni62g_to_ni60_dneut)
      end subroutine get_rates_for_ni60_ni62

            
      subroutine get_rates_for_ni62_ni64( ! ni62 + 2n <=> ni64 via ni63
     >      n, g, den, temp, T9, T932, y, num_reactions, rate_factors)        
         type (Net_Info), pointer :: n
         type (Net_General_Info), pointer  :: g
         real(dp), pointer :: y(:)
         integer, intent(in) :: num_reactions
         real(dp), intent(in) :: den, temp, T9, T932, rate_factors(:)       
         call get_rates_for_A_neut_C( 
     >      n, g, den, temp, T9, T932, y, num_reactions, rate_factors,
     >      ini62, ini64, irni62ng_to_ni64, irni64gn_to_ni62,
     >      irni62ng_aux, irni63ng_aux, irni63gn_aux, irni64gn_aux,
     >      n% d_rni62neut_to_ni64_dneut, n% d_rni64g_to_ni62_dneut)
      end subroutine get_rates_for_ni62_ni64

            
      subroutine get_rates_for_ni64_ni66( ! ni64 + 2n <=> ni66 via ni65
     >      n, g, den, temp, T9, T932, y, num_reactions, rate_factors)        
         type (Net_Info), pointer :: n
         type (Net_General_Info), pointer  :: g
         real(dp), pointer :: y(:)
         integer, intent(in) :: num_reactions
         real(dp), intent(in) :: den, temp, T9, T932, rate_factors(:)     
         call get_rates_for_A_neut_C( 
     >      n, g, den, temp, T9, T932, y, num_reactions, rate_factors,
     >      ini64, ini66, irni64ng_to_ni66, irni66gn_to_ni64,
     >      irni64ng_aux, irni65ng_aux, irni65gn_aux, irni66gn_aux,
     >      n% d_rni64neut_to_ni66_dneut, n% d_rni66g_to_ni64_dneut)
      end subroutine get_rates_for_ni64_ni66

            
      subroutine get_rates_for_zn60_zn62( ! zn60 + 2n <=> zn62 via zn61
     >      n, g, den, temp, T9, T932, y, num_reactions, rate_factors)        
         type (Net_Info), pointer :: n
         type (Net_General_Info), pointer  :: g
         real(dp), pointer :: y(:)
         integer, intent(in) :: num_reactions
         real(dp), intent(in) :: den, temp, T9, T932, rate_factors(:)     
         call get_rates_for_A_neut_C( 
     >      n, g, den, temp, T9, T932, y, num_reactions, rate_factors,
     >      izn60, izn62, irzn60ng_to_zn62, irzn62gn_to_zn60,
     >      irzn60ng_aux, irzn61ng_aux, irzn61gn_aux, irzn62gn_aux,
     >      n% d_rzn60neut_to_zn62_dneut, n% d_rzn62g_to_zn60_dneut)
      end subroutine get_rates_for_zn60_zn62

            
      subroutine get_rates_for_zn62_zn64( ! zn62 + 2n <=> zn64 via zn63
     >      n, g, den, temp, T9, T932, y, num_reactions, rate_factors)        
         type (Net_Info), pointer :: n
         type (Net_General_Info), pointer  :: g
         real(dp), pointer :: y(:)
         integer, intent(in) :: num_reactions
         real(dp), intent(in) :: den, temp, T9, T932, rate_factors(:)     
         call get_rates_for_A_neut_C( 
     >      n, g, den, temp, T9, T932, y, num_reactions, rate_factors,
     >      izn62, izn64, irzn62ng_to_zn64, irzn64gn_to_zn62,
     >      irzn62ng_aux, irzn63ng_aux, irzn63gn_aux, irzn64gn_aux,
     >      n% d_rzn62neut_to_zn64_dneut, n% d_rzn64g_to_zn62_dneut)
      end subroutine get_rates_for_zn62_zn64

            
      subroutine get_rates_for_zn64_zn66( ! zn64 + 2n <=> zn66 via zn65
     >      n, g, den, temp, T9, T932, y, num_reactions, rate_factors)        
         type (Net_Info), pointer :: n
         type (Net_General_Info), pointer  :: g
         real(dp), pointer :: y(:)
         integer, intent(in) :: num_reactions
         real(dp), intent(in) :: den, temp, T9, T932, rate_factors(:)     
         call get_rates_for_A_neut_C( 
     >      n, g, den, temp, T9, T932, y, num_reactions, rate_factors,
     >      izn64, izn66, irzn64ng_to_zn66, irzn66gn_to_zn64,
     >      irzn64ng_aux, irzn65ng_aux, irzn65gn_aux, irzn66gn_aux,
     >      n% d_rzn64neut_to_zn66_dneut, n% d_rzn66g_to_zn64_dneut)
      end subroutine get_rates_for_zn64_zn66

            
      subroutine get_rates_for_zn66_zn68( ! zn66 + 2n <=> zn68 via zn67
     >      n, g, den, temp, T9, T932, y, num_reactions, rate_factors)        
         type (Net_Info), pointer :: n
         type (Net_General_Info), pointer  :: g
         real(dp), pointer :: y(:)
         integer, intent(in) :: num_reactions
         real(dp), intent(in) :: den, temp, T9, T932, rate_factors(:)     
         call get_rates_for_A_neut_C( 
     >      n, g, den, temp, T9, T932, y, num_reactions, rate_factors,
     >      izn66, izn68, irzn66ng_to_zn68, irzn68gn_to_zn66,
     >      irzn66ng_aux, irzn67ng_aux, irzn67gn_aux, irzn68gn_aux,
     >      n% d_rzn66neut_to_zn68_dneut, n% d_rzn68g_to_zn66_dneut)
      end subroutine get_rates_for_zn66_zn68

            
      subroutine get_rates_for_zn68_zn70( ! zn68 + 2n <=> zn70 via zn69
     >      n, g, den, temp, T9, T932, y, num_reactions, rate_factors)        
         type (Net_Info), pointer :: n
         type (Net_General_Info), pointer  :: g
         real(dp), pointer :: y(:)
         integer, intent(in) :: num_reactions
         real(dp), intent(in) :: den, temp, T9, T932, rate_factors(:)     
         call get_rates_for_A_neut_C( 
     >      n, g, den, temp, T9, T932, y, num_reactions, rate_factors,
     >      izn68, izn70, irzn68ng_to_zn70, irzn70gn_to_zn68,
     >      irzn68ng_aux, irzn69ng_aux, irzn69gn_aux, irzn70gn_aux,
     >      n% d_rzn68neut_to_zn70_dneut, n% d_rzn70g_to_zn68_dneut)
      end subroutine get_rates_for_zn68_zn70

            
      subroutine get_rates_for_ge70_ge72( ! ge70 + 2n <=> ge72 via ge71
     >      n, g, den, temp, T9, T932, y, num_reactions, rate_factors)        
         type (Net_Info), pointer :: n
         type (Net_General_Info), pointer  :: g
         real(dp), pointer :: y(:)
         integer, intent(in) :: num_reactions
         real(dp), intent(in) :: den, temp, T9, T932, rate_factors(:)     
         call get_rates_for_A_neut_C( 
     >      n, g, den, temp, T9, T932, y, num_reactions, rate_factors,
     >      ige70, ige72, irge70ng_to_ge72, irge72gn_to_ge70,
     >      irge70ng_aux, irge71ng_aux, irge71gn_aux, irge72gn_aux,
     >      n% d_rge70neut_to_ge72_dneut, n% d_rge72g_to_ge70_dneut)
      end subroutine get_rates_for_ge70_ge72
            
            
      subroutine get_rates_for_ge72_ge74( ! ge72 + 2n <=> ge74 via ge73
     >      n, g, den, temp, T9, T932, y, num_reactions, rate_factors)        
         type (Net_Info), pointer :: n
         type (Net_General_Info), pointer  :: g
         real(dp), pointer :: y(:)
         integer, intent(in) :: num_reactions
         real(dp), intent(in) :: den, temp, T9, T932, rate_factors(:)     
         call get_rates_for_A_neut_C( 
     >      n, g, den, temp, T9, T932, y, num_reactions, rate_factors,
     >      ige72, ige74, irge72ng_to_ge74, irge74gn_to_ge72,
     >      irge72ng_aux, irge73ng_aux, irge73gn_aux, irge74gn_aux,
     >      n% d_rge72neut_to_ge74_dneut, n% d_rge74g_to_ge72_dneut)
      end subroutine get_rates_for_ge72_ge74
            
            
      subroutine get_rates_for_ge74_ge76( ! ge74 + 2n <=> ge76 via ge75
     >      n, g, den, temp, T9, T932, y, num_reactions, rate_factors)        
         type (Net_Info), pointer :: n
         type (Net_General_Info), pointer  :: g
         real(dp), pointer :: y(:)
         integer, intent(in) :: num_reactions
         real(dp), intent(in) :: den, temp, T9, T932, rate_factors(:)     
         call get_rates_for_A_neut_C( 
     >      n, g, den, temp, T9, T932, y, num_reactions, rate_factors,
     >      ige74, ige76, irge74ng_to_ge76, irge76gn_to_ge74,
     >      irge74ng_aux, irge75ng_aux, irge75gn_aux, irge76gn_aux,
     >      n% d_rge74neut_to_ge76_dneut, n% d_rge76g_to_ge74_dneut)
      end subroutine get_rates_for_ge74_ge76
         

      subroutine get_rates_for_A_neut_C(  ! A + 2n <=> C via B
     >      n, g, den, temp, T9, T932, y, num_reactions, rate_factors,
     >      iA, iC, irAng_to_C, irCgn_to_A,
     >      irAng_aux, irBng_aux, irBgn_aux, irCgn_aux,
     >      d_rAneut_to_C_dneut, d_rCg_to_A_dneut)   
     
         type (Net_Info), pointer :: n
         type (Net_General_Info), pointer  :: g
         real(dp), pointer :: y(:)
         integer, intent(in) :: 
     >      num_reactions, iA, iC, irAng_to_C, irCgn_to_A,
     >      irAng_aux, irBng_aux, irBgn_aux, irCgn_aux
         real(dp), intent(in) ::
     >      den, temp, T9, T932, rate_factors(:) ! (num_reactions)         
         real(dp), intent(out) ::
     >      d_rAneut_to_C_dneut, d_rCg_to_A_dneut

         real(dp), pointer :: rates(:,:)
         integer, pointer :: rtab(:), itab(:)
         integer :: neut, A, C, rAng_aux, rBng_aux, rBgn_aux, rCgn_aux,
     >      rAneut_to_C, rCg_to_A, j
         real(dp) ::  
     >      denom, denomdt, denomdd, denomdneut, 
     >      zz, d_zz_dt, d_zz_dd, d_zz_dneut,
     >      rAng, rBng, rBgn, rCgn,  
     >      d_rAng_dt, d_rBng_dt, d_rBgn_dt, d_rCgn_dt, 
     >      d_rAng_dd, d_rBng_dd, d_rBgn_dd, d_rCgn_dd,
     >      fac, fr, rr, forward, reverse, rem_neut_dt

         real(dp) :: factor, d_factor_dT

         include 'formats.dek'
          
         rates => n% rate_screened
         rtab => g% net_reaction
         itab => g% net_iso
         
         if (irAng_to_C /= 0) then
            rAneut_to_C = rtab(irAng_to_C)
            if (rAneut_to_C /= 0) rates(:,rAneut_to_C) = 0
         else
            rAneut_to_C = 0
         end if        
         d_rAneut_to_C_dneut = 0
         
         if (irCgn_to_A /= 0) then
            rCg_to_A = rtab(irCgn_to_A)
            if (rCg_to_A /= 0) rates(:,rCg_to_A) = 0
         else
            rCg_to_A = 0
         end if        
         d_rCg_to_A_dneut = 0
         
         if (rAneut_to_C == 0 .or. rCg_to_A == 0) return
         if (temp < 1.5d9) return
         neut = itab(ineut)
         A = itab(iA)
         C = itab(iC)         
         if (neut == 0 .or. A == 0 .or. C == 0) return
         
         rAng_aux = rtab(irAng_aux)
         if (rAng_aux == 0) then
            write(*,*) 'need rAng_aux ' // trim(reaction_name(irAng_to_C))
            stop 1
         end if
         
         rBng_aux = rtab(irBng_aux)
         if (rBng_aux == 0) then
            write(*,*) 'need rBng_aux ' // trim(reaction_name(irAng_to_C))
            stop 1
         end if
         
         rBgn_aux = rtab(irBgn_aux)
         if (rBgn_aux == 0) then
            write(*,*) 'need rBgn_aux ' // trim(reaction_name(irAng_to_C))
            stop 1
         end if
         
         rCgn_aux = rtab(irCgn_aux)
         if (rCgn_aux == 0) then
            write(*,*) 'need rCgn_aux ' // trim(reaction_name(irAng_to_C))
            stop 1
         end if
         
         rAng = rates(i_rate,rAng_aux)*rate_factors(rAng_aux)
         rBng = rates(i_rate,rBng_aux)*rate_factors(rBng_aux)
         rBgn = rates(i_rate,rBgn_aux)*rate_factors(rBgn_aux)
         rCgn = rates(i_rate,rCgn_aux)*rate_factors(rCgn_aux)
         
         denom = rBgn + y(neut)*rBng
         if (denom < 1d-12) return
         
         d_rAng_dt = rates(i_rate_dT,rAng_aux)*rate_factors(rAng_aux)
         d_rBng_dt = rates(i_rate_dT,rBng_aux)*rate_factors(rBng_aux)
         d_rBgn_dt = rates(i_rate_dT,rBgn_aux)*rate_factors(rBgn_aux)
         d_rCgn_dt = rates(i_rate_dT,rCgn_aux)*rate_factors(rCgn_aux)
         
         d_rAng_dd = rates(i_rate_dRho,rAng_aux)*rate_factors(rAng_aux)
         d_rBng_dd = rates(i_rate_dRho,rBng_aux)*rate_factors(rBng_aux)
         d_rBgn_dd = rates(i_rate_dRho,rBgn_aux)*rate_factors(rBgn_aux)
         d_rCgn_dd = rates(i_rate_dRho,rCgn_aux)*rate_factors(rCgn_aux)
         
         denomdt = rates(i_rate_dT,rBgn_aux) + y(neut)*rates(i_rate_dT,rBng_aux)
         denomdd = rates(i_rate_dRho,rBgn_aux) + y(neut)*rates(i_rate_dRho,rBng_aux)
         denomdneut = rBng
         
         zz = 1/denom
         d_zz_dt = -denomdt/denom**2
         d_zz_dd = -denomdd/denom**2
         d_zz_dneut = -denomdneut/denom**2
         
         if (rCg_to_A /= 0) then
         
            rates(i_rate,rCg_to_A) = rCgn*rBgn*zz
            
            rates(i_rate_dT,rCg_to_A) = 
     >         d_rCgn_dt*rBgn*zz +
     >         rCgn*d_rBgn_dt*zz +
     >         rCgn*rBgn*d_zz_dt

            rates(i_rate_dRho,rCg_to_A) = 
     >         d_rCgn_dd*rBgn*zz +
     >         rCgn*d_rBgn_dd*zz +
     >         rCgn*rBgn*d_zz_dd

            d_rCg_to_A_dneut = rCgn*rBgn*d_zz_dneut

            rates(:,rCg_to_A) = rates(:,rCg_to_A)*rate_factors(rCg_to_A)
            d_rCg_to_A_dneut = d_rCg_to_A_dneut*rate_factors(rCg_to_A)

         end if

         if (rAneut_to_C /= 0) then
         
            rates(i_rate,rAneut_to_C) = rAng*rBng*zz
            
            rates(i_rate_dT,rAneut_to_C) = 
     >         d_rAng_dt*rBng*zz +
     >         rAng*d_rBng_dt*zz +
     >         rAng*rBng*d_zz_dt

            rates(i_rate_dRho,rAneut_to_C) = 
     >         d_rAng_dd*rBng*zz +
     >         rAng*d_rBng_dd*zz +
     >         rAng*rBng*d_zz_dd

            d_rAneut_to_C_dneut = rAng*rBng*d_zz_dneut
         
            rates(:,rAneut_to_C) = rates(:,rAneut_to_C)*rate_factors(rAneut_to_C)
            d_rAneut_to_C_dneut = d_rAneut_to_C_dneut*rate_factors(rAneut_to_C)
            
         end if
         
         if (rCg_to_A == 0 .or. rAneut_to_C == 0) return
         
         factor = n% factor_neut
         d_factor_dT = n% d_factor_neut_dT
         
         if (factor == 1d0) return

         rates(i_rate_dT,rAneut_to_C) = 
     >         factor*rates(i_rate_dT,rAneut_to_C) + 
     >         d_factor_dT*rates(i_rate,rAneut_to_C)
         rates(i_rate_dT,rCg_to_A) = 
     >         factor*rates(i_rate_dT,rCg_to_A) +
     >         d_factor_dT*rates(i_rate,rCg_to_A)

         rates(i_rate_dRho,rAneut_to_C) = 
     >         factor*rates(i_rate_dRho,rAneut_to_C)
         rates(i_rate_dRho,rCg_to_A) = 
     >         factor*rates(i_rate_dRho,rCg_to_A)

         rates(i_rate,rAneut_to_C) = 
     >         factor*rates(i_rate,rAneut_to_C)
         rates(i_rate,rCg_to_A) = 
     >         factor*rates(i_rate,rCg_to_A)

         d_rCg_to_A_dneut = factor*d_rCg_to_A_dneut
         d_rAneut_to_C_dneut = factor*d_rAneut_to_C_dneut
         

      end subroutine get_rates_for_A_neut_C

            
      subroutine get_rates_for_cr49_combos(
     >      n, g, den, temp, y, num_reactions, rate_factors)        
         type (Net_Info), pointer :: n
         type (Net_General_Info), pointer  :: g
         real(dp), pointer :: y(:)
         integer, intent(in) :: num_reactions
         real(dp), intent(in) :: den, temp, rate_factors(:)            
         call get_rates_for_an_combos(   
     >      n, g, den, temp, y, num_reactions, rate_factors,
     >      iti46, icr48, icr49, icr50,    
     >      irti46an_to_cr50, ! ti46(a,n)cr49(n,g)cr50
     >      ircr50gn_to_ti46, ! cr50(g,n)cr49(n,a)ti46 
     >      irti46an_to_cr48, ! ti46(a,n)cr49(g,n)cr48
     >      ircr48ng_to_ti46, ! cr48(n,g)cr49(n,a)ti46
     >      ircr48ng_to_cr50, ! cr48(n,g)cr49(n,g)cr50
     >      ircr50gn_to_cr48, ! cr50(g,n)cr49(g,n)cr48      
     >      irti46an_aux, ! ti46(a,n)cr49 
     >      ircr49na_aux, ! cr49(n,a)ti46 
     >      ircr48ng_aux, ! cr48(n,g)cr49
     >      ircr49gn_aux, ! cr49(g,n)cr48 
     >      ircr50gn_aux, ! cr50(g,n)cr49 
     >      ircr49ng_aux, ! cr49(n,g)cr50      
     >      n% d_rcr48neut_to_cr50_dneut, n% d_rcr50g_to_cr48_dneut,
     >      n% d_rti46aneut_to_cr48_dneut, n% d_rcr48neut_to_ti46_dneut,
     >      n% d_rti46aneut_to_cr50_dneut, n% d_rcr50gneut_to_ti46_dneut)       
      end subroutine get_rates_for_cr49_combos

            
      subroutine get_rates_for_cr51_combos(
     >      n, g, den, temp, y, num_reactions, rate_factors)        
         type (Net_Info), pointer :: n
         type (Net_General_Info), pointer  :: g
         real(dp), pointer :: y(:)
         integer, intent(in) :: num_reactions
         real(dp), intent(in) :: den, temp, rate_factors(:)            
         call get_rates_for_an_combos(   
     >      n, g, den, temp, y, num_reactions, rate_factors,
     >      iti48, icr50, icr51, icr52,    
     >      irti48an_to_cr52, ! ti48(a,n)cr51(n,g)cr52
     >      ircr52gn_to_ti48, ! cr52(g,n)cr51(n,a)ti48 
     >      irti48an_to_cr50, ! ti48(a,n)cr51(g,n)cr50
     >      ircr50ng_to_ti48, ! cr50(n,g)cr51(n,a)ti48
     >      ircr50ng_to_cr52, ! cr50(n,g)cr51(n,g)cr52
     >      ircr52gn_to_cr50, ! cr52(g,n)cr51(g,n)cr50      
     >      irti48an_aux, ! ti48(a,n)cr51 
     >      ircr51na_aux, ! cr51(n,a)ti48 
     >      ircr50ng_aux, ! cr50(n,g)cr51
     >      ircr51gn_aux, ! cr51(g,n)cr50 
     >      ircr52gn_aux, ! cr52(g,n)cr51 
     >      ircr51ng_aux, ! cr51(n,g)cr52      
     >      n% d_rcr50neut_to_cr52_dneut, n% d_rcr52g_to_cr50_dneut,
     >      n% d_rti48aneut_to_cr50_dneut, n% d_rcr50neut_to_ti48_dneut,
     >      n% d_rti48aneut_to_cr52_dneut, n% d_rcr52gneut_to_ti48_dneut)       
      end subroutine get_rates_for_cr51_combos

            
      subroutine get_rates_for_cr53_combos(
     >      n, g, den, temp, y, num_reactions, rate_factors)        
         type (Net_Info), pointer :: n
         type (Net_General_Info), pointer  :: g
         real(dp), pointer :: y(:)
         integer, intent(in) :: num_reactions
         real(dp), intent(in) :: den, temp, rate_factors(:)            
         call get_rates_for_an_combos(   
     >      n, g, den, temp, y, num_reactions, rate_factors,
     >      iti50, icr52, icr53, icr54,    
     >      irti50an_to_cr54, ! ti50(a,n)cr53(n,g)cr54
     >      ircr54gn_to_ti50, ! cr54(g,n)cr53(n,a)ti50 
     >      irti50an_to_cr52, ! ti50(a,n)cr53(g,n)cr52
     >      ircr52ng_to_ti50, ! cr52(n,g)cr53(n,a)ti50
     >      ircr52ng_to_cr54, ! cr52(n,g)cr53(n,g)cr54
     >      ircr54gn_to_cr52, ! cr54(g,n)cr53(g,n)cr52      
     >      irti50an_aux, ! ti50(a,n)cr53 
     >      ircr53na_aux, ! cr53(n,a)ti50 
     >      ircr52ng_aux, ! cr52(n,g)cr53
     >      ircr53gn_aux, ! cr53(g,n)cr52 
     >      ircr54gn_aux, ! cr54(g,n)cr53 
     >      ircr53ng_aux, ! cr53(n,g)cr54      
     >      n% d_rcr52neut_to_cr54_dneut, n% d_rcr54g_to_cr52_dneut,
     >      n% d_rti50aneut_to_cr52_dneut, n% d_rcr52neut_to_ti50_dneut,
     >      n% d_rti50aneut_to_cr54_dneut, n% d_rcr54gneut_to_ti50_dneut)       
      end subroutine get_rates_for_cr53_combos

            
      subroutine get_rates_for_cr55_combos(
     >      n, g, den, temp, y, num_reactions, rate_factors)        
         type (Net_Info), pointer :: n
         type (Net_General_Info), pointer  :: g
         real(dp), pointer :: y(:)
         integer, intent(in) :: num_reactions
         real(dp), intent(in) :: den, temp, rate_factors(:)            
         call get_rates_for_an_combos(   
     >      n, g, den, temp, y, num_reactions, rate_factors,
     >      iti52, icr54, icr55, icr56,    
     >      irti52an_to_cr56, ! ti52(a,n)cr55(n,g)cr56
     >      ircr56gn_to_ti52, ! cr56(g,n)cr55(n,a)ti52 
     >      irti52an_to_cr54, ! ti52(a,n)cr55(g,n)cr54
     >      ircr54ng_to_ti52, ! cr54(n,g)cr55(n,a)ti52
     >      ircr54ng_to_cr56, ! cr54(n,g)cr55(n,g)cr56
     >      ircr56gn_to_cr54, ! cr56(g,n)cr55(g,n)cr54      
     >      irti52an_aux, ! ti52(a,n)cr55 
     >      ircr55na_aux, ! cr55(n,a)ti52 
     >      ircr54ng_aux, ! cr54(n,g)cr55
     >      ircr55gn_aux, ! cr55(g,n)cr54 
     >      ircr56gn_aux, ! cr56(g,n)cr55 
     >      ircr55ng_aux, ! cr55(n,g)cr56      
     >      n% d_rcr54neut_to_cr56_dneut, n% d_rcr56g_to_cr54_dneut,
     >      n% d_rti52aneut_to_cr54_dneut, n% d_rcr54neut_to_ti52_dneut,
     >      n% d_rti52aneut_to_cr56_dneut, n% d_rcr56gneut_to_ti52_dneut)       
      end subroutine get_rates_for_cr55_combos

            
      subroutine get_rates_for_fe53_combos(
     >      n, g, den, temp, y, num_reactions, rate_factors)        
         type (Net_Info), pointer :: n
         type (Net_General_Info), pointer  :: g
         real(dp), pointer :: y(:)
         integer, intent(in) :: num_reactions
         real(dp), intent(in) :: den, temp, rate_factors(:)            
         call get_rates_for_an_combos(   
     >      n, g, den, temp, y, num_reactions, rate_factors,
     >      icr50, ife52, ife53, ife54,    
     >      ircr50an_to_fe54, ! cr50(a,n)fe53(n,g)fe54
     >      irfe54gn_to_cr50, ! fe54(g,n)fe53(n,a)cr50 
     >      ircr50an_to_fe52, ! cr50(a,n)fe53(g,n)fe52
     >      irfe52ng_to_cr50, ! fe52(n,g)fe53(n,a)cr50
     >      irfe52ng_to_fe54, ! fe52(n,g)fe53(n,g)fe54
     >      irfe54gn_to_fe52, ! fe54(g,n)fe53(g,n)fe52      
     >      ircr50an_aux, ! cr50(a,n)fe53 
     >      irfe53na_aux, ! fe53(n,a)cr50 
     >      irfe52ng_aux, ! fe52(n,g)fe53
     >      irfe53gn_aux, ! fe53(g,n)fe52 
     >      irfe54gn_aux, ! fe54(g,n)fe53 
     >      irfe53ng_aux, ! fe53(n,g)fe54      
     >      n% d_rfe52neut_to_fe54_dneut, n% d_rfe54g_to_fe52_dneut,
     >      n% d_rcr50aneut_to_fe52_dneut, n% d_rfe52neut_to_cr50_dneut,
     >      n% d_rcr50aneut_to_fe54_dneut, n% d_rfe54gneut_to_cr50_dneut)       
      end subroutine get_rates_for_fe53_combos

            
      subroutine get_rates_for_fe55_combos(
     >      n, g, den, temp, y, num_reactions, rate_factors)        
         type (Net_Info), pointer :: n
         type (Net_General_Info), pointer  :: g
         real(dp), pointer :: y(:)
         integer, intent(in) :: num_reactions
         real(dp), intent(in) :: den, temp, rate_factors(:)            
         call get_rates_for_an_combos(   
     >      n, g, den, temp, y, num_reactions, rate_factors,
     >      icr52, ife54, ife55, ife56,    
     >      ircr52an_to_fe56, ! cr52(a,n)fe55(n,g)fe56
     >      irfe56gn_to_cr52, ! fe56(g,n)fe55(n,a)cr52 
     >      ircr52an_to_fe54, ! cr52(a,n)fe55(g,n)fe54
     >      irfe54ng_to_cr52, ! fe54(n,g)fe55(n,a)cr52
     >      irfe54ng_to_fe56, ! fe54(n,g)fe55(n,g)fe56
     >      irfe56gn_to_fe54, ! fe56(g,n)fe55(g,n)fe54      
     >      ircr52an_aux, ! cr52(a,n)fe55 
     >      irfe55na_aux, ! fe55(n,a)cr52 
     >      irfe54ng_aux, ! fe54(n,g)fe55
     >      irfe55gn_aux, ! fe55(g,n)fe54 
     >      irfe56gn_aux, ! fe56(g,n)fe55 
     >      irfe55ng_aux, ! fe55(n,g)fe56      
     >      n% d_rfe54neut_to_fe56_dneut, n% d_rfe56g_to_fe54_dneut,
     >      n% d_rcr52aneut_to_fe54_dneut, n% d_rfe54neut_to_cr52_dneut,
     >      n% d_rcr52aneut_to_fe56_dneut, n% d_rfe56gneut_to_cr52_dneut)       
      end subroutine get_rates_for_fe55_combos

            
      subroutine get_rates_for_fe57_combos(
     >      n, g, den, temp, y, num_reactions, rate_factors)        
         type (Net_Info), pointer :: n
         type (Net_General_Info), pointer  :: g
         real(dp), pointer :: y(:)
         integer, intent(in) :: num_reactions
         real(dp), intent(in) :: den, temp, rate_factors(:)            
         call get_rates_for_an_combos(   
     >      n, g, den, temp, y, num_reactions, rate_factors,
     >      icr54, ife56, ife57, ife58,    
     >      ircr54an_to_fe58, ! cr54(a,n)fe57(n,g)fe58
     >      irfe58gn_to_cr54, ! fe58(g,n)fe57(n,a)cr54 
     >      ircr54an_to_fe56, ! cr54(a,n)fe57(g,n)fe56
     >      irfe56ng_to_cr54, ! fe56(n,g)fe57(n,a)cr54
     >      irfe56ng_to_fe58, ! fe56(n,g)fe57(n,g)fe58
     >      irfe58gn_to_fe56, ! fe58(g,n)fe57(g,n)fe56      
     >      ircr54an_aux, ! cr54(a,n)fe57 
     >      irfe57na_aux, ! fe57(n,a)cr54 
     >      irfe56ng_aux, ! fe56(n,g)fe57
     >      irfe57gn_aux, ! fe57(g,n)fe56 
     >      irfe58gn_aux, ! fe58(g,n)fe57 
     >      irfe57ng_aux, ! fe57(n,g)fe58      
     >      n% d_rfe56neut_to_fe58_dneut, n% d_rfe58g_to_fe56_dneut,
     >      n% d_rcr54aneut_to_fe56_dneut, n% d_rfe56neut_to_cr54_dneut,
     >      n% d_rcr54aneut_to_fe58_dneut, n% d_rfe58gneut_to_cr54_dneut)       
      end subroutine get_rates_for_fe57_combos

            
      subroutine get_rates_for_fe59_combos(
     >      n, g, den, temp, y, num_reactions, rate_factors)        
         type (Net_Info), pointer :: n
         type (Net_General_Info), pointer  :: g
         real(dp), pointer :: y(:)
         integer, intent(in) :: num_reactions
         real(dp), intent(in) :: den, temp, rate_factors(:)            
         call get_rates_for_an_combos(   
     >      n, g, den, temp, y, num_reactions, rate_factors,
     >      icr56, ife58, ife59, ife60,    
     >      ircr56an_to_fe60, ! cr56(a,n)fe59(n,g)fe60
     >      irfe60gn_to_cr56, ! fe60(g,n)fe59(n,a)cr56 
     >      ircr56an_to_fe58, ! cr56(a,n)fe59(g,n)fe58
     >      irfe58ng_to_cr56, ! fe58(n,g)fe59(n,a)cr56
     >      irfe58ng_to_fe60, ! fe58(n,g)fe59(n,g)fe60
     >      irfe60gn_to_fe58, ! fe60(g,n)fe59(g,n)fe58      
     >      ircr56an_aux, ! cr56(a,n)fe59 
     >      irfe59na_aux, ! fe59(n,a)cr56 
     >      irfe58ng_aux, ! fe58(n,g)fe59
     >      irfe59gn_aux, ! fe59(g,n)fe58 
     >      irfe60gn_aux, ! fe60(g,n)fe59 
     >      irfe59ng_aux, ! fe59(n,g)fe60      
     >      n% d_rfe58neut_to_fe60_dneut, n% d_rfe60g_to_fe58_dneut,
     >      n% d_rcr56aneut_to_fe58_dneut, n% d_rfe58neut_to_cr56_dneut,
     >      n% d_rcr56aneut_to_fe60_dneut, n% d_rfe60gneut_to_cr56_dneut)       
      end subroutine get_rates_for_fe59_combos

            
      subroutine get_rates_for_ni57_combos(
     >      n, g, den, temp, y, num_reactions, rate_factors)        
         type (Net_Info), pointer :: n
         type (Net_General_Info), pointer  :: g
         real(dp), pointer :: y(:)
         integer, intent(in) :: num_reactions
         real(dp), intent(in) :: den, temp, rate_factors(:)            
         call get_rates_for_an_combos(   
     >      n, g, den, temp, y, num_reactions, rate_factors,
     >      ife54, ini56, ini57, ini58,    
     >      irfe54an_to_ni58, ! fe54(a,n)ni57(n,g)ni58
     >      irni58gn_to_fe54, ! ni58(g,n)ni57(n,a)fe54 
     >      irfe54an_to_ni56, ! fe54(a,n)ni57(g,n)ni56
     >      irni56ng_to_fe54, ! ni56(n,g)ni57(n,a)fe54
     >      irni56ng_to_ni58, ! ni56(n,g)ni57(n,g)ni58
     >      irni58gn_to_ni56, ! ni58(g,n)ni57(g,n)ni56      
     >      irfe54an_aux, ! fe54(a,n)ni57 
     >      irni57na_aux, ! ni57(n,a)fe54 
     >      irni56ng_aux, ! ni56(n,g)ni57
     >      irni57gn_aux, ! ni57(g,n)ni56 
     >      irni58gn_aux, ! ni58(g,n)ni57 
     >      irni57ng_aux, ! ni57(n,g)ni58      
     >      n% d_rni56neut_to_ni58_dneut, n% d_rni58g_to_ni56_dneut,
     >      n% d_rfe54aneut_to_ni56_dneut, n% d_rni56neut_to_fe54_dneut,
     >      n% d_rfe54aneut_to_ni58_dneut, n% d_rni58gneut_to_fe54_dneut)       
      end subroutine get_rates_for_ni57_combos

            
      subroutine get_rates_for_ni59_combos(
     >      n, g, den, temp, y, num_reactions, rate_factors)        
         type (Net_Info), pointer :: n
         type (Net_General_Info), pointer  :: g
         real(dp), pointer :: y(:)
         integer, intent(in) :: num_reactions
         real(dp), intent(in) :: den, temp, rate_factors(:)            
         call get_rates_for_an_combos(   
     >      n, g, den, temp, y, num_reactions, rate_factors,
     >      ife56, ini58, ini59, ini60,    
     >      irfe56an_to_ni60, ! fe56(a,n)ni59(n,g)ni60
     >      irni60gn_to_fe56, ! ni60(g,n)ni59(n,a)fe56 
     >      irfe56an_to_ni58, ! fe56(a,n)ni59(g,n)ni58
     >      irni58ng_to_fe56, ! ni58(n,g)ni59(n,a)fe56
     >      irni58ng_to_ni60, ! ni58(n,g)ni59(n,g)ni60
     >      irni60gn_to_ni58, ! ni60(g,n)ni59(g,n)ni58      
     >      irfe56an_aux, ! fe56(a,n)ni59 
     >      irni59na_aux, ! ni59(n,a)fe56 
     >      irni58ng_aux, ! ni58(n,g)ni59
     >      irni59gn_aux, ! ni59(g,n)ni58 
     >      irni60gn_aux, ! ni60(g,n)ni59 
     >      irni59ng_aux, ! ni59(n,g)ni60      
     >      n% d_rni58neut_to_ni60_dneut, n% d_rni60g_to_ni58_dneut,
     >      n% d_rfe56aneut_to_ni58_dneut, n% d_rni58neut_to_fe56_dneut,
     >      n% d_rfe56aneut_to_ni60_dneut, n% d_rni60gneut_to_fe56_dneut)       
      end subroutine get_rates_for_ni59_combos

            
      subroutine get_rates_for_ni61_combos(
     >      n, g, den, temp, y, num_reactions, rate_factors)        
         type (Net_Info), pointer :: n
         type (Net_General_Info), pointer  :: g
         real(dp), pointer :: y(:)
         integer, intent(in) :: num_reactions
         real(dp), intent(in) :: den, temp, rate_factors(:)            
         call get_rates_for_an_combos(   
     >      n, g, den, temp, y, num_reactions, rate_factors,
     >      ife58, ini60, ini61, ini62,    
     >      irfe58an_to_ni62, ! fe58(a,n)ni61(n,g)ni62
     >      irni62gn_to_fe58, ! ni62(g,n)ni61(n,a)fe58 
     >      irfe58an_to_ni60, ! fe58(a,n)ni61(g,n)ni60
     >      irni60ng_to_fe58, ! ni60(n,g)ni61(n,a)fe58
     >      irni60ng_to_ni62, ! ni60(n,g)ni61(n,g)ni62
     >      irni62gn_to_ni60, ! ni62(g,n)ni61(g,n)ni60      
     >      irfe58an_aux, ! fe58(a,n)ni61 
     >      irni61na_aux, ! ni61(n,a)fe58 
     >      irni60ng_aux, ! ni60(n,g)ni61
     >      irni61gn_aux, ! ni61(g,n)ni60 
     >      irni62gn_aux, ! ni62(g,n)ni61 
     >      irni61ng_aux, ! ni61(n,g)ni62      
     >      n% d_rni60neut_to_ni62_dneut, n% d_rni62g_to_ni60_dneut,
     >      n% d_rfe58aneut_to_ni60_dneut, n% d_rni60neut_to_fe58_dneut,
     >      n% d_rfe58aneut_to_ni62_dneut, n% d_rni62gneut_to_fe58_dneut)       
      end subroutine get_rates_for_ni61_combos
      
      
         subroutine get_rates_for_an_combos(   
     >      n, g, den, temp, y, num_reactions, rate_factors,
     >      i_fe54, i_ni56, i_ni57, i_ni58,
     
     >      ir_fe54aneut_to_ni58, ! fe54(a, neut)ni57(neut, g)ni58
     >      ir_ni58gneut_to_fe54, ! ni58(g, neut)ni57(neut, a)fe54 
     >      ir_fe54aneut_to_ni56, ! fe54(a, neut)ni57(g, neut)ni56
     >      ir_ni56neut_to_fe54, ! ni56(neut, g)ni57(neut, a)fe54
     >      ir_ni56neut_to_ni58, ! ni56(neut, g)ni57(neut, g)ni58
     >      ir_ni58gneut_to_ni56, ! ni58(g, neut)ni57(g, neut)ni56
      
     >      ir_fe54aneut_aux, ! fe54(a, neut)ni57 
     >      ir_ni57neuta_aux, ! ni57(neut, a)fe54 
     >      ir_ni56neutg_aux, ! ni56(neut, g)ni57
     >      ir_ni57gneut_aux, ! ni57(g, neut)ni56 
     >      ir_ni58gneut_aux, ! ni58(g, neut)ni57 
     >      ir_ni57neutg_aux, ! ni57(neut, g)ni58 
     
     >      d_r_ni56neut_to_ni58_dneut, d_r_ni58gneut_to_ni56_dneut,
     >      d_r_fe54aneut_to_ni56_dneut, d_r_ni56neut_to_fe54_dneut,
     >      d_r_fe54aneut_to_ni58_dneut, d_r_ni58gneut_to_fe54_dneut)  
       
         type (Net_Info), pointer :: n
         type (Net_General_Info), pointer  :: g
         real(dp), pointer :: y(:)
         integer, intent(in) :: num_reactions,
     >      i_fe54, i_ni56, i_ni57, i_ni58,
     >      ir_fe54aneut_to_ni58, ! fe54(a, neut)ni57(neut, g)ni58
     >      ir_ni58gneut_to_fe54, ! ni58(g, neut)ni57(neut, a)fe54 
     >      ir_fe54aneut_to_ni56, ! fe54(a, neut)ni57(g, neut)ni56
     >      ir_ni56neut_to_fe54, ! ni56(neut, g)ni57(neut, a)fe54
     >      ir_ni56neut_to_ni58, ! ni56(neut, g)ni57(neut, g)ni58
     >      ir_ni58gneut_to_ni56, ! ni58(g, neut)ni57(g, neut)ni56 
     >      ir_fe54aneut_aux, ! fe54(a, neut)ni57 
     >      ir_ni57neuta_aux, ! ni57(neut, a)fe54 
     >      ir_ni56neutg_aux, ! ni56(neut, g)ni57
     >      ir_ni57gneut_aux, ! ni57(g, neut)ni56 
     >      ir_ni58gneut_aux, ! ni58(g, neut)ni57 
     >      ir_ni57neutg_aux ! ni57(neut, g)ni58 
         real(dp), intent(in) :: den, temp, rate_factors(:) ! (num_reactions)         
         real(dp), intent(out) ::    
     >         d_r_ni56neut_to_ni58_dneut, d_r_ni58gneut_to_ni56_dneut,
     >         d_r_fe54aneut_to_ni56_dneut, d_r_ni56neut_to_fe54_dneut,
     >         d_r_fe54aneut_to_ni58_dneut, d_r_ni58gneut_to_fe54_dneut

         real(dp), pointer :: rates(:, :)
         integer, pointer :: rtab(:), itab(:)
         integer :: neut, ierr,
     >      r_ni56neut_to_ni58, r_ni58gneut_to_ni56,
     >      r_fe54aneut_to_ni56, r_ni56neut_to_fe54,
     >      r_fe54aneut_to_ni58, r_ni58gneut_to_fe54,
     >      r_fe54aneut_aux, r_ni56neutg_aux, r_ni57gneut_aux,
     >      r_ni57neutg_aux, r_ni57neuta_aux, r_ni58gneut_aux
         real(dp) :: 
     >      denom, denomdt, denomdd, denomdneut, 
     >      zz, d_zz_dt, d_zz_dd, d_zz_dneut,
     >      r_fe54aneut, r_ni56neutg, r_ni57g_neut,
     >      r_ni57neutg, r_ni57neut_a, r_ni58g_neut,
     >      d_r_fe54aneut_dt, d_r_ni56neutg_dt, d_r_ni57gneut_dt,
     >      d_r_ni57neutg_dt, d_r_ni57neuta_dt, d_r_ni58gneut_dt,
     >      d_r_fe54aneut_dd, d_r_ni56neutg_dd, d_r_ni57gneut_dd,
     >      d_r_ni57neutg_dd, d_r_ni57neuta_dd, d_r_ni58gneut_dd         
         real(dp) :: factor, d_factor_dT
         logical :: have_reactions

         include 'formats.dek'
          
         rates => n% rate_screened
         rtab => g% net_reaction
         itab => g% net_iso
         
         have_reactions = .false.
         
         call set1(ir_ni56neut_to_ni58,
     >      r_ni56neut_to_ni58, d_r_ni56neut_to_ni58_dneut)
         
         call set1(ir_ni58gneut_to_ni56,
     >      r_ni58gneut_to_ni56, d_r_ni58gneut_to_ni56_dneut)

         call set1(ir_fe54aneut_to_ni56,
     >      r_fe54aneut_to_ni56, d_r_fe54aneut_to_ni56_dneut)

         call set1(ir_ni56neut_to_fe54,
     >      r_ni56neut_to_fe54, d_r_ni56neut_to_fe54_dneut)

         call set1(ir_fe54aneut_to_ni58,
     >      r_fe54aneut_to_ni58, d_r_fe54aneut_to_ni58_dneut)

         call set1(ir_ni58gneut_to_fe54,
     >      r_ni58gneut_to_fe54, d_r_ni58gneut_to_fe54_dneut)
                  
         if (temp < 1.5d9) return
         if (.not. have_reactions) return
         neut = itab(ineut)
         if (neut == 0) return

         call set1_aux(ir_fe54aneut_aux,
     >      r_fe54aneut_aux, r_fe54aneut, d_r_fe54aneut_dt, d_r_fe54aneut_dd)
                  
         call set1_aux(ir_ni56neutg_aux,
     >      r_ni56neutg_aux, r_ni56neutg, d_r_ni56neutg_dt, d_r_ni56neutg_dd)
                  
         call set1_aux(ir_ni57gneut_aux,
     >      r_ni57gneut_aux, r_ni57g_neut, d_r_ni57gneut_dt, d_r_ni57gneut_dd)
                  
         call set1_aux(ir_ni57neutg_aux,
     >      r_ni57neutg_aux, r_ni57neutg, d_r_ni57neutg_dt, d_r_ni57neutg_dd)
                  
         call set1_aux(ir_ni57neuta_aux,
     >      r_ni57neuta_aux, r_ni57neut_a, d_r_ni57neuta_dt, d_r_ni57neuta_dd)
                  
         call set1_aux(ir_ni58gneut_aux,
     >      r_ni58gneut_aux, r_ni58g_neut, d_r_ni58gneut_dt, d_r_ni58gneut_dd)


         denom = r_ni57g_neut + y(neut)*(r_ni57neutg + r_ni57neut_a)         
         if (denom < 1d-12) return

         denomdt = d_r_ni57gneut_dt + y(neut)*(d_r_ni57neutg_dt + d_r_ni57neuta_dt)
         denomdd = d_r_ni57gneut_dd + y(neut)*(d_r_ni57neutg_dd + d_r_ni57neuta_dd)
         denomdneut = r_ni57neutg + r_ni57neut_a
         
         zz = 1/denom
         d_zz_dt = -denomdt/denom**2
         d_zz_dd = -denomdd/denom**2
         d_zz_dneut = -denomdneut/denom**2
         
         if (r_ni56neut_to_ni58 /= 0) then ! ni56(neut,g)ni57(neut,g)ni58
         
            rates(i_rate,r_ni56neut_to_ni58) = r_ni56neutg*r_ni57neutg*zz
            
            rates(i_rate_dT,r_ni56neut_to_ni58) = 
     >         d_r_ni56neutg_dt*r_ni57neutg*zz +
     >         r_ni56neutg*d_r_ni57neutg_dt*zz +
     >         r_ni56neutg*r_ni57neutg*d_zz_dt

            rates(i_rate_dRho,r_ni56neut_to_ni58) = 
     >         d_r_ni56neutg_dd*r_ni57neutg*zz +
     >         r_ni56neutg*d_r_ni57neutg_dd*zz +
     >         r_ni56neutg*r_ni57neutg*d_zz_dd

            d_r_ni56neut_to_ni58_dneut = r_ni56neutg*r_ni57neutg*d_zz_dneut
         
            rates(:,r_ni56neut_to_ni58) = 
     >         rates(:,r_ni56neut_to_ni58)*rate_factors(r_ni56neut_to_ni58)
            d_r_ni56neut_to_ni58_dneut = 
     >         d_r_ni56neut_to_ni58_dneut*rate_factors(r_ni56neut_to_ni58)
            
         end if
         
         if (r_ni58gneut_to_ni56 /= 0) then ! ni58(g,neut)ni57(g,neut)ni56
         
            rates(i_rate,r_ni58gneut_to_ni56) = r_ni58g_neut*r_ni57g_neut*zz
            
            rates(i_rate_dT,r_ni58gneut_to_ni56) = 
     >         d_r_ni58gneut_dt*r_ni57g_neut*zz +
     >         r_ni58g_neut*d_r_ni57gneut_dt*zz +
     >         r_ni58g_neut*r_ni57g_neut*d_zz_dt

            rates(i_rate_dRho,r_ni58gneut_to_ni56) = 
     >         d_r_ni58gneut_dd*r_ni57g_neut*zz +
     >         r_ni58g_neut*d_r_ni57gneut_dd*zz +
     >         r_ni58g_neut*r_ni57g_neut*d_zz_dd

            d_r_ni58gneut_to_ni56_dneut = r_ni58g_neut*r_ni57g_neut*d_zz_dneut
         
            rates(:,r_ni58gneut_to_ni56) = 
     >         rates(:,r_ni58gneut_to_ni56)*rate_factors(r_ni58gneut_to_ni56)
            d_r_ni58gneut_to_ni56_dneut = 
     >         d_r_ni58gneut_to_ni56_dneut*rate_factors(r_ni58gneut_to_ni56)
 
         end if
         
         if (r_fe54aneut_to_ni56 /= 0) then ! fe54(a,neut)ni57(g,neut)ni56
         
            rates(i_rate,r_fe54aneut_to_ni56) = r_fe54aneut*r_ni57g_neut*zz
            
            rates(i_rate_dT,r_fe54aneut_to_ni56) = 
     >         d_r_fe54aneut_dt*r_ni57g_neut*zz +
     >         r_fe54aneut*d_r_ni57gneut_dt*zz +
     >         r_fe54aneut*r_ni57g_neut*d_zz_dt

            rates(i_rate_dRho,r_fe54aneut_to_ni56) = 
     >         d_r_fe54aneut_dd*r_ni57g_neut*zz +
     >         r_fe54aneut*d_r_ni57gneut_dd*zz +
     >         r_fe54aneut*r_ni57g_neut*d_zz_dd

            d_r_fe54aneut_to_ni56_dneut = r_fe54aneut*r_ni57g_neut*d_zz_dneut
         
            rates(:,r_fe54aneut_to_ni56) = 
     >         rates(:,r_fe54aneut_to_ni56)*rate_factors(r_fe54aneut_to_ni56)
            d_r_fe54aneut_to_ni56_dneut = 
     >         d_r_fe54aneut_to_ni56_dneut*rate_factors(r_fe54aneut_to_ni56)
 
         end if
         
         if (r_ni56neut_to_fe54 /= 0) then ! ni56(neut,g)ni57(neut,a)fe54
         
            rates(i_rate,r_ni56neut_to_fe54) = r_ni56neutg*r_ni57neut_a*zz
            
            rates(i_rate_dT,r_ni56neut_to_fe54) = 
     >         d_r_ni56neutg_dt*r_ni57neut_a*zz +
     >         r_ni56neutg*d_r_ni57neuta_dt*zz +
     >         r_ni56neutg*r_ni57neut_a*d_zz_dt

            rates(i_rate_dRho,r_ni56neut_to_fe54) = 
     >         d_r_ni56neutg_dd*r_ni57neut_a*zz +
     >         r_ni56neutg*d_r_ni57neuta_dd*zz +
     >         r_ni56neutg*r_ni57neut_a*d_zz_dd

            d_r_ni56neut_to_fe54_dneut = 
     >            r_ni56neutg*r_ni57neut_a*d_zz_dneut
         
            rates(:,r_ni56neut_to_fe54) = 
     >         rates(:,r_ni56neut_to_fe54)*rate_factors(r_ni56neut_to_fe54)
            d_r_ni56neut_to_fe54_dneut = 
     >         d_r_ni56neut_to_fe54_dneut*rate_factors(r_ni56neut_to_fe54)
 
         end if
         
         if (r_fe54aneut_to_ni58 /= 0) then ! fe54(a,neut)ni57(neut,g)ni58
         
            rates(i_rate,r_fe54aneut_to_ni58) = r_fe54aneut*r_ni57neutg*zz
            
            rates(i_rate_dT,r_fe54aneut_to_ni58) = 
     >        d_r_fe54aneut_dt*r_ni57neutg*zz  +
     >        r_fe54aneut*d_r_ni57neutg_dt*zz  +
     >        r_fe54aneut*r_ni57neutg*d_zz_dt

            rates(i_rate_dRho,r_fe54aneut_to_ni58) = 
     >        d_r_fe54aneut_dd*r_ni57neutg*zz  +
     >        r_fe54aneut*d_r_ni57neutg_dd*zz  +
     >        r_fe54aneut*r_ni57neutg*d_zz_dd

            d_r_fe54aneut_to_ni58_dneut = r_fe54aneut*r_ni57neutg*d_zz_dneut

            rates(:,r_fe54aneut_to_ni58) = 
     >         rates(:,r_fe54aneut_to_ni58)*rate_factors(r_fe54aneut_to_ni58)
            d_r_fe54aneut_to_ni58_dneut = 
     >         d_r_fe54aneut_to_ni58_dneut*rate_factors(r_fe54aneut_to_ni58)
 
         end if
         
         if (r_ni58gneut_to_fe54 /= 0) then ! ni58(g,neut)ni57(neut,a)fe54
         
            rates(i_rate,r_ni58gneut_to_fe54) = 
     >            r_ni58g_neut*r_ni57neut_a*zz            
            rates(i_rate_dT,r_ni58gneut_to_fe54) = 
     >         d_r_ni58gneut_dt*r_ni57neut_a*zz +
     >         r_ni58g_neut*d_r_ni57neuta_dt*zz +
     >         r_ni58g_neut*r_ni57neut_a*d_zz_dt
         
            rates(i_rate_dRho,r_ni58gneut_to_fe54) = 
     >         d_r_ni58gneut_dd*r_ni57neut_a*zz +
     >         r_ni58g_neut*d_r_ni57neuta_dd*zz +
     >         r_ni58g_neut*r_ni57neut_a*d_zz_dd
     
            d_r_ni58gneut_to_fe54_dneut = 
     >            r_ni58g_neut*r_ni57neut_a*d_zz_dneut
     
            rates(:,r_ni58gneut_to_fe54) = 
     >         rates(:,r_ni58gneut_to_fe54)*rate_factors(r_ni58gneut_to_fe54)
     
            d_r_ni58gneut_to_fe54_dneut = 
     >         d_r_ni58gneut_to_fe54_dneut*rate_factors(r_ni58gneut_to_fe54)
 
         end if
         
         factor = n% factor_neut
         d_factor_dT = n% d_factor_neut_dT
         if (factor < 1d0) then
         
            if (ir_fe54aneut_to_ni56 /= 0 .and. ir_ni56neut_to_fe54 /= 0) then
               call limit_pair_at_very_high_T(
     >            ir_fe54aneut_to_ni56, ir_ni56neut_to_fe54, 
     >            rates, rtab, factor, d_factor_dT, .false.)
               d_r_fe54aneut_to_ni56_dneut = factor*d_r_fe54aneut_to_ni56_dneut
               d_r_ni56neut_to_fe54_dneut = factor*d_r_ni56neut_to_fe54_dneut
               end if
               
            if (ir_ni56neut_to_ni58 /= 0 .and. ir_ni58gneut_to_ni56 /= 0) then
               call limit_pair_at_very_high_T(
     >            ir_ni56neut_to_ni58, ir_ni58gneut_to_ni56, 
     >            rates, rtab, factor, d_factor_dT, .false.)
               d_r_ni56neut_to_ni58_dneut = factor*d_r_ni56neut_to_ni58_dneut
               d_r_ni58gneut_to_ni56_dneut = factor*d_r_ni58gneut_to_ni56_dneut
               end if
         
            if (ir_fe54aneut_to_ni58 /= 0 .and. ir_ni58gneut_to_fe54 /= 0) then
               call limit_pair_at_very_high_T(
     >            ir_fe54aneut_to_ni58, ir_ni58gneut_to_fe54, 
     >            rates, rtab, factor, d_factor_dT, .false.)
               d_r_fe54aneut_to_ni58_dneut = factor*d_r_fe54aneut_to_ni58_dneut
               d_r_ni58gneut_to_fe54_dneut = factor*d_r_ni58gneut_to_fe54_dneut
            end if
         
         end if
         
         contains
         
         subroutine set1(ir_ni56neut_to_ni58,
     >         r_ni56neut_to_ni58, d_r_ni56neut_to_ni58_dneut)
            integer, intent(in) :: ir_ni56neut_to_ni58
            integer, intent(out) :: r_ni56neut_to_ni58
            real(dp), intent(out) :: d_r_ni56neut_to_ni58_dneut
            if (ir_ni56neut_to_ni58 /= 0) then
               r_ni56neut_to_ni58 = 
     >            rtab(ir_ni56neut_to_ni58) ! ni56(neut,g)ni57(neut,g)ni58
            else
               r_ni56neut_to_ni58 = 0
            end if
            if (r_ni56neut_to_ni58 /= 0) then
               have_reactions = .true.
               rates(:,r_ni56neut_to_ni58) = 0
            end if
            d_r_ni56neut_to_ni58_dneut = 0
         end subroutine set1
         
         subroutine set1_aux(ir_fe54aneut_aux,
     >         r_fe54aneut_aux, r_fe54aneut, d_r_fe54aneut_dt, d_r_fe54aneut_dd)
            integer, intent(in) :: ir_fe54aneut_aux
            integer, intent(out) :: r_fe54aneut_aux
            real(dp), intent(out) ::
     >         r_fe54aneut, d_r_fe54aneut_dt, d_r_fe54aneut_dd
            if (ir_fe54aneut_aux /= 0) then
               r_fe54aneut_aux = rtab(ir_fe54aneut_aux)         
            else                    
               r_fe54aneut_aux = 0
            end if         
            if (r_fe54aneut_aux /= 0) then
               r_fe54aneut = 
     >            rates(i_rate,r_fe54aneut_aux)*rate_factors(r_fe54aneut_aux)
               d_r_fe54aneut_dt = 
     >            rates(i_rate_dT,r_fe54aneut_aux)*rate_factors(r_fe54aneut_aux)
               d_r_fe54aneut_dd = 
     >            rates(i_rate_dRho,r_fe54aneut_aux)*rate_factors(r_fe54aneut_aux)
            else
               r_fe54aneut = 0
               d_r_fe54aneut_dt = 0
               d_r_fe54aneut_dd = 0
            end if
         end subroutine set1_aux

      end subroutine get_rates_for_an_combos

            
      subroutine get_rates_for_v48_combos(
     >      n, g, den, temp, y, num_reactions, rate_factors)        
         type (Net_Info), pointer :: n
         type (Net_General_Info), pointer  :: g
         real(dp), pointer :: y(:)
         integer, intent(in) :: num_reactions
         real(dp), intent(in) :: den, temp, rate_factors(:)            
         call get_rates_for_pn_combos(   
     >      n, g, den, temp, y, num_reactions, rate_factors,
     >      iti48, iv48, icr48,    
     >      irti48pn_to_cr48, ! ti48(p,n)v48(p,n)cr48
     >      ircr48np_to_ti48, ! cr48(n,p)v48(n,p)ti48       
     >      irti48pn_aux, ! ti48(p,n)v48 
     >      irv48np_aux, ! v48(n,p)ti48 
     >      ircr48np_aux, ! cr48(n,p)v48 
     >      irv48pn_aux, ! v48(p,n)cr48 
     >      n% d_rti48pn_to_cr48_dprot, n% d_rti48pn_to_cr48_dneut,       
     >      n% d_rcr48np_to_ti48_dprot, n% d_rcr48np_to_ti48_dneut)       
      end subroutine get_rates_for_v48_combos

            
      subroutine get_rates_for_v50_combos(
     >      n, g, den, temp, y, num_reactions, rate_factors)        
         type (Net_Info), pointer :: n
         type (Net_General_Info), pointer  :: g
         real(dp), pointer :: y(:)
         integer, intent(in) :: num_reactions
         real(dp), intent(in) :: den, temp, rate_factors(:)            
         call get_rates_for_pn_combos(   
     >      n, g, den, temp, y, num_reactions, rate_factors,
     >      iti50, iv50, icr50,    
     >      irti50pn_to_cr50, ! ti50(p,n)v50(p,n)cr50
     >      ircr50np_to_ti50, ! cr50(n,p)v50(n,p)ti50       
     >      irti50pn_aux, ! ti50(p,n)v50 
     >      irv50np_aux, ! v50(n,p)ti50 
     >      ircr50np_aux, ! cr50(n,p)v50 
     >      irv50pn_aux, ! v50(p,n)cr50 
     >      n% d_rti50pn_to_cr50_dprot, n% d_rti50pn_to_cr50_dneut,       
     >      n% d_rcr50np_to_ti50_dprot, n% d_rcr50np_to_ti50_dneut)       
      end subroutine get_rates_for_v50_combos

            
      subroutine get_rates_for_v52_combos(
     >      n, g, den, temp, y, num_reactions, rate_factors)        
         type (Net_Info), pointer :: n
         type (Net_General_Info), pointer  :: g
         real(dp), pointer :: y(:)
         integer, intent(in) :: num_reactions
         real(dp), intent(in) :: den, temp, rate_factors(:)            
         call get_rates_for_pn_combos(   
     >      n, g, den, temp, y, num_reactions, rate_factors,
     >      iti52, iv52, icr52,    
     >      irti52pn_to_cr52, ! ti52(p,n)v52(p,n)cr52
     >      ircr52np_to_ti52, ! cr52(n,p)v52(n,p)ti52       
     >      irti52pn_aux, ! ti52(p,n)v52 
     >      irv52np_aux, ! v52(n,p)ti52 
     >      ircr52np_aux, ! cr52(n,p)v52 
     >      irv52pn_aux, ! v52(p,n)cr52 
     >      n% d_rti52pn_to_cr52_dprot, n% d_rti52pn_to_cr52_dneut,       
     >      n% d_rcr52np_to_ti52_dprot, n% d_rcr52np_to_ti52_dneut)       
      end subroutine get_rates_for_v52_combos

            
      subroutine get_rates_for_mn52_combos(
     >      n, g, den, temp, y, num_reactions, rate_factors)        
         type (Net_Info), pointer :: n
         type (Net_General_Info), pointer  :: g
         real(dp), pointer :: y(:)
         integer, intent(in) :: num_reactions
         real(dp), intent(in) :: den, temp, rate_factors(:)            
         call get_rates_for_pn_combos(   
     >      n, g, den, temp, y, num_reactions, rate_factors,
     >      icr52, imn52, ife52,    
     >      ircr52pn_to_fe52, ! cr52(p,n)mn52(p,n)fe52
     >      irfe52np_to_cr52, ! fe52(n,p)mn52(n,p)cr52       
     >      ircr52pn_aux, ! cr52(p,n)mn52 
     >      irmn52np_aux, ! mn52(n,p)cr52 
     >      irfe52np_aux, ! fe52(n,p)mn52 
     >      irmn52pn_aux, ! mn52(p,n)fe52 
     >      n% d_rcr52pn_to_fe52_dprot, n% d_rcr52pn_to_fe52_dneut,       
     >      n% d_rfe52np_to_cr52_dprot, n% d_rfe52np_to_cr52_dneut)       
      end subroutine get_rates_for_mn52_combos

            
      subroutine get_rates_for_mn54_combos(
     >      n, g, den, temp, y, num_reactions, rate_factors)        
         type (Net_Info), pointer :: n
         type (Net_General_Info), pointer  :: g
         real(dp), pointer :: y(:)
         integer, intent(in) :: num_reactions
         real(dp), intent(in) :: den, temp, rate_factors(:)            
         call get_rates_for_pn_combos(   
     >      n, g, den, temp, y, num_reactions, rate_factors,
     >      icr54, imn54, ife54,    
     >      ircr54pn_to_fe54, ! cr54(p,n)mn54(p,n)fe54
     >      irfe54np_to_cr54, ! fe54(n,p)mn54(n,p)cr54       
     >      ircr54pn_aux, ! cr54(p,n)mn54 
     >      irmn54np_aux, ! mn54(n,p)cr54 
     >      irfe54np_aux, ! fe54(n,p)mn54 
     >      irmn54pn_aux, ! mn54(p,n)fe54 
     >      n% d_rcr54pn_to_fe54_dprot, n% d_rcr54pn_to_fe54_dneut,       
     >      n% d_rfe54np_to_cr54_dprot, n% d_rfe54np_to_cr54_dneut)       
      end subroutine get_rates_for_mn54_combos

            
      subroutine get_rates_for_mn56_combos(
     >      n, g, den, temp, y, num_reactions, rate_factors)        
         type (Net_Info), pointer :: n
         type (Net_General_Info), pointer  :: g
         real(dp), pointer :: y(:)
         integer, intent(in) :: num_reactions
         real(dp), intent(in) :: den, temp, rate_factors(:)            
         call get_rates_for_pn_combos(   
     >      n, g, den, temp, y, num_reactions, rate_factors,
     >      icr56, imn56, ife56,    
     >      ircr56pn_to_fe56, ! cr56(p,n)mn56(p,n)fe56
     >      irfe56np_to_cr56, ! fe56(n,p)mn56(n,p)cr56       
     >      ircr56pn_aux, ! cr56(p,n)mn56 
     >      irmn56np_aux, ! mn56(n,p)cr56 
     >      irfe56np_aux, ! fe56(n,p)mn56 
     >      irmn56pn_aux, ! mn56(p,n)fe56 
     >      n% d_rcr56pn_to_fe56_dprot, n% d_rcr56pn_to_fe56_dneut,       
     >      n% d_rfe56np_to_cr56_dprot, n% d_rfe56np_to_cr56_dneut)       
      end subroutine get_rates_for_mn56_combos

            
      subroutine get_rates_for_co56_combos(
     >      n, g, den, temp, y, num_reactions, rate_factors)        
         type (Net_Info), pointer :: n
         type (Net_General_Info), pointer  :: g
         real(dp), pointer :: y(:)
         integer, intent(in) :: num_reactions
         real(dp), intent(in) :: den, temp, rate_factors(:)            
         call get_rates_for_pn_combos(   
     >      n, g, den, temp, y, num_reactions, rate_factors,
     >      ife56, ico56, ini56,    
     >      irfe56pn_to_ni56, ! fe56(p,n)co56(p,n)ni56
     >      irni56np_to_fe56, ! ni56(n,p)co56(n,p)fe56       
     >      irfe56pn_aux, ! fe56(p,n)co56 
     >      irco56np_aux, ! co56(n,p)fe56 
     >      irni56np_aux, ! ni56(n,p)co56 
     >      irco56pn_aux, ! co56(p,n)ni56 
     >      n% d_rfe56pn_to_ni56_dprot, n% d_rfe56pn_to_ni56_dneut,       
     >      n% d_rni56np_to_fe56_dprot, n% d_rni56np_to_fe56_dneut)       
      end subroutine get_rates_for_co56_combos

            
      subroutine get_rates_for_co58_combos(
     >      n, g, den, temp, y, num_reactions, rate_factors)        
         type (Net_Info), pointer :: n
         type (Net_General_Info), pointer  :: g
         real(dp), pointer :: y(:)
         integer, intent(in) :: num_reactions
         real(dp), intent(in) :: den, temp, rate_factors(:)            
         call get_rates_for_pn_combos(   
     >      n, g, den, temp, y, num_reactions, rate_factors,
     >      ife58, ico58, ini58,    
     >      irfe58pn_to_ni58, ! fe58(p,n)co58(p,n)ni58
     >      irni58np_to_fe58, ! ni58(n,p)co58(n,p)fe58       
     >      irfe58pn_aux, ! fe58(p,n)co58 
     >      irco58np_aux, ! co58(n,p)fe58 
     >      irni58np_aux, ! ni58(n,p)co58 
     >      irco58pn_aux, ! co58(p,n)ni58 
     >      n% d_rfe58pn_to_ni58_dprot, n% d_rfe58pn_to_ni58_dneut,       
     >      n% d_rni58np_to_fe58_dprot, n% d_rni58np_to_fe58_dneut)       
      end subroutine get_rates_for_co58_combos


      subroutine get_rates_for_pn_combos(   
     >      n, g, den, temp, y, num_reactions, rate_factors,
     >      i_cr56, i_mn56, i_fe56,    
     >      ir_cr56pn_to_fe56, ! cr56(p,n)mn56(p,n)fe56
     >      ir_fe56np_to_cr56, ! fe56(n,p)mn56(n,p)cr56       
     >      ir_cr56pn_aux, ! cr56(p,n)mn56 
     >      ir_mn56np_aux, ! mn56(n,p)cr56 
     >      ir_fe56np_aux, ! fe56(n,p)mn56 
     >      ir_mn56pn_aux, ! mn56(p,n)fe56 
     >      d_r_cr56pn_to_fe56_dprot, d_r_cr56pn_to_fe56_dneut,       
     >      d_r_fe56np_to_cr56_dprot, d_r_fe56np_to_cr56_dneut)       
         type (Net_Info), pointer :: n
         type (Net_General_Info), pointer  :: g
         real(dp), pointer :: y(:)
         integer, intent(in) :: num_reactions
         real(dp), intent(in) :: den, temp, rate_factors(:)  
         integer, intent(in) ::           
     >      i_cr56, i_mn56, i_fe56, ir_cr56pn_to_fe56, ir_fe56np_to_cr56,   
     >      ir_cr56pn_aux, ir_mn56np_aux, ir_fe56np_aux, ir_mn56pn_aux
         real(dp), intent(out) :: 
     >      d_r_cr56pn_to_fe56_dprot, d_r_cr56pn_to_fe56_dneut,       
     >      d_r_fe56np_to_cr56_dprot, d_r_fe56np_to_cr56_dneut
         
         real(dp), pointer :: rates(:, :)
         integer, pointer :: rtab(:), itab(:)
         integer :: 
     >      neut, prot, r_cr56pn_to_fe56, r_fe56np_to_cr56, 
     >      r_cr56pn_aux, r_mn56np_aux, r_fe56np_aux, r_mn56pn_aux
         real(dp) :: 
     >      factor, d_factor_dT, zz, d_zz_dd, d_zz_dt, d_zz_dneut, d_zz_dprot,
     >      denom, denomdt, denomdd, denomdneut, denomdprot,
     >      r_cr56pn, d_r_cr56pn_dt, d_r_cr56pn_dd,
     >      r_mn56np, d_r_mn56np_dt, d_r_mn56np_dd,
     >      r_fe56np, d_r_fe56np_dt, d_r_fe56np_dd,
     >      r_mn56pn, d_r_mn56pn_dt, d_r_mn56pn_dd
         
         include 'formats'
          
         rates => n% rate_screened
         rtab => g% net_reaction
         itab => g% net_iso
         
         call set1(ir_cr56pn_to_fe56, r_cr56pn_to_fe56, 
     >      d_r_cr56pn_to_fe56_dprot, d_r_cr56pn_to_fe56_dneut)
         
         call set1(ir_fe56np_to_cr56, r_fe56np_to_cr56, 
     >      d_r_fe56np_to_cr56_dprot, d_r_fe56np_to_cr56_dneut)

         if (temp < 1.5d9) return
         if (r_cr56pn_to_fe56 == 0 .and. r_fe56np_to_cr56 == 0) return
         
         neut = itab(ineut)
         prot = itab(iprot)
         if (neut == 0 .or. prot == 0) return
         
         call set1_aux(ir_cr56pn_aux,
     >      r_cr56pn_aux, r_cr56pn, d_r_cr56pn_dt, d_r_cr56pn_dd)
         
         call set1_aux(ir_mn56np_aux,
     >      r_mn56np_aux, r_mn56np, d_r_mn56np_dt, d_r_mn56np_dd)
         
         call set1_aux(ir_fe56np_aux,
     >      r_fe56np_aux, r_fe56np, d_r_fe56np_dt, d_r_fe56np_dd)
         
         call set1_aux(ir_mn56pn_aux,
     >      r_mn56pn_aux, r_mn56pn, d_r_mn56pn_dt, d_r_mn56pn_dd)
         
         denom = y(neut)*r_mn56np + y(prot)*r_mn56pn      

         if (denom < 1d-12) return

         denomdt = y(neut)*d_r_mn56np_dt + y(prot)*d_r_mn56pn_dt
         denomdd = y(neut)*d_r_mn56np_dd + y(prot)*d_r_mn56pn_dd
         denomdneut = r_mn56np
         denomdprot = r_mn56pn
         
         zz = 1/denom
         d_zz_dt = -denomdt/denom**2
         d_zz_dd = -denomdd/denom**2
         d_zz_dneut = -denomdneut/denom**2
         d_zz_dprot = -denomdprot/denom**2
         
         if (r_cr56pn_to_fe56 /= 0) then ! cr56(p,n)mn56(p,n)fe56
         
            rates(i_rate,r_cr56pn_to_fe56) = r_cr56pn*r_mn56pn*zz
            
            rates(i_rate_dT,r_cr56pn_to_fe56) = 
     >         d_r_cr56pn_dt*r_mn56pn*zz +
     >         r_cr56pn*d_r_mn56pn_dt*zz +
     >         r_cr56pn*r_mn56pn*d_zz_dt

            rates(i_rate_dRho,r_cr56pn_to_fe56) = 
     >         d_r_cr56pn_dd*r_mn56pn*zz +
     >         r_cr56pn*d_r_mn56pn_dd*zz +
     >         r_cr56pn*r_mn56pn*d_zz_dd

            d_r_cr56pn_to_fe56_dneut = r_cr56pn*r_mn56pn*d_zz_dneut
            d_r_cr56pn_to_fe56_dprot = r_cr56pn*r_mn56pn*d_zz_dprot
         
            rates(:,r_cr56pn_to_fe56) = 
     >         rates(:,r_cr56pn_to_fe56)*rate_factors(r_cr56pn_to_fe56)
            d_r_cr56pn_to_fe56_dneut = 
     >         d_r_cr56pn_to_fe56_dneut*rate_factors(r_cr56pn_to_fe56)
            d_r_cr56pn_to_fe56_dprot = 
     >         d_r_cr56pn_to_fe56_dprot*rate_factors(r_cr56pn_to_fe56)
            
         end if
         
         if (r_fe56np_to_cr56 /= 0) then ! fe56(n,p)mn56(n,p)cr56
         
            rates(i_rate,r_fe56np_to_cr56) = r_fe56np*r_mn56np*zz
            
            rates(i_rate_dT,r_fe56np_to_cr56) = 
     >         d_r_fe56np_dt*r_mn56np*zz +
     >         r_fe56np*d_r_mn56np_dt*zz +
     >         r_fe56np*r_mn56np*d_zz_dt

            rates(i_rate_dRho,r_fe56np_to_cr56) = 
     >         d_r_fe56np_dd*r_mn56np*zz +
     >         r_fe56np*d_r_mn56np_dd*zz +
     >         r_fe56np*r_mn56np*d_zz_dd

            d_r_fe56np_to_cr56_dneut = r_fe56np*r_mn56np*d_zz_dneut
            d_r_fe56np_to_cr56_dprot = r_fe56np*r_mn56np*d_zz_dprot
         
            rates(:,r_fe56np_to_cr56) = 
     >         rates(:,r_fe56np_to_cr56)*rate_factors(r_fe56np_to_cr56)
            d_r_fe56np_to_cr56_dneut = 
     >         d_r_fe56np_to_cr56_dneut*rate_factors(r_fe56np_to_cr56)
            d_r_fe56np_to_cr56_dprot = 
     >         d_r_fe56np_to_cr56_dprot*rate_factors(r_fe56np_to_cr56)
            
         end if
         
         factor = n% factor_neut
         d_factor_dT = n% d_factor_neut_dT
         if (factor < 1d0) then
            if (r_cr56pn_to_fe56 /= 0 .and. r_fe56np_to_cr56 /= 0) then
               call limit_pair_at_very_high_T(
     >            ir_cr56pn_to_fe56, ir_fe56np_to_cr56, 
     >            rates, rtab, factor, d_factor_dT, .false.)
               d_r_cr56pn_to_fe56_dprot = factor*d_r_cr56pn_to_fe56_dprot
               d_r_cr56pn_to_fe56_dneut = factor*d_r_cr56pn_to_fe56_dneut
               d_r_fe56np_to_cr56_dprot = factor*d_r_fe56np_to_cr56_dprot
               d_r_fe56np_to_cr56_dneut = factor*d_r_fe56np_to_cr56_dneut
            end if         
         end if
         
         contains
         
         subroutine set1(ir_cr56pn_to_fe56, r_cr56pn_to_fe56, 
     >         d_r_cr56pn_to_fe56_dprot, d_r_cr56pn_to_fe56_dneut)
            integer, intent(in) :: ir_cr56pn_to_fe56
            integer, intent(out) :: r_cr56pn_to_fe56
            real(dp), intent(out) :: 
     >         d_r_cr56pn_to_fe56_dprot, d_r_cr56pn_to_fe56_dneut
            if (ir_cr56pn_to_fe56 /= 0) then
               r_cr56pn_to_fe56 = rtab(ir_cr56pn_to_fe56)
            else
               r_cr56pn_to_fe56 = 0
            end if
            if (r_cr56pn_to_fe56 /= 0) then
               rates(:,r_cr56pn_to_fe56) = 0
            end if
            d_r_cr56pn_to_fe56_dprot = 0
            d_r_cr56pn_to_fe56_dneut = 0      
         end subroutine set1

         subroutine set1_aux(ir_cr56pn_aux,
     >         r_cr56pn_aux, r_cr56pn, d_r_cr56pn_dt, d_r_cr56pn_dd)
            integer, intent(in) :: ir_cr56pn_aux
            integer, intent(out) :: r_cr56pn_aux
            real(dp), intent(out) ::
     >         r_cr56pn, d_r_cr56pn_dt, d_r_cr56pn_dd
            if (ir_cr56pn_aux /= 0) then
               r_cr56pn_aux = rtab(ir_cr56pn_aux)         
            else                    
               r_cr56pn_aux = 0
            end if         
            if (r_cr56pn_aux /= 0) then
               r_cr56pn = 
     >            rates(i_rate,r_cr56pn_aux)*rate_factors(r_cr56pn_aux)
               d_r_cr56pn_dt = 
     >            rates(i_rate_dT,r_cr56pn_aux)*rate_factors(r_cr56pn_aux)
               d_r_cr56pn_dd = 
     >            rates(i_rate_dRho,r_cr56pn_aux)*rate_factors(r_cr56pn_aux)
            else
               r_cr56pn = 0
               d_r_cr56pn_dt = 0
               d_r_cr56pn_dd = 0
            end if
         end subroutine set1_aux

      end subroutine get_rates_for_pn_combos

            
      subroutine limit_pair_at_very_high_T(
     >         ir1, ir2, rates, rtab, factor, d_factor_dT, dbg) 
         integer, intent(in) :: ir1, ir2
         real(dp), pointer :: rates(:,:)
         integer, pointer :: rtab(:)
         real(dp), intent(in) :: factor, d_factor_dT
         logical, intent(in) :: dbg
           
         integer :: i1, i2
         
         include 'formats'
         
         i1 = rtab(ir1)
         if (i1 == 0) then
            if (dbg) write(*,2) 'limit_pair_at_very_high_T i1 == 0 ' // 
     >               trim(reaction_Name(ir1)), ir1
            return
         end if
         
         i2 = rtab(ir2)
         if (i2 == 0) then
            if (dbg) write(*,2) 'limit_pair_at_very_high_T i2 == 0' // 
     >               trim(reaction_Name(ir2)), ir2
            return
         end if

         rates(i_rate_dT,i1) = 
     >         factor*rates(i_rate_dT,i1) + 
     >         d_factor_dT*rates(i_rate,i1)
         rates(i_rate_dT,i2) = 
     >         factor*rates(i_rate_dT,i2) +
     >         d_factor_dT*rates(i_rate,i2)

         rates(i_rate_dRho,i1) = 
     >         factor*rates(i_rate_dRho,i1)
         rates(i_rate_dRho,i2) = 
     >         factor*rates(i_rate_dRho,i2)

         rates(i_rate,i1) = 
     >         factor*rates(i_rate,i1)
         rates(i_rate,i2) = 
     >         factor*rates(i_rate,i2)
         
      end subroutine limit_pair_at_very_high_T

            
      subroutine limit_rate_at_very_high_T(
     >         ir1, rates, rtab, factor, d_factor_dT, dbg) 
         integer, intent(in) :: ir1
         real(dp), pointer :: rates(:,:)
         integer, pointer :: rtab(:)
         real(dp), intent(in) :: factor, d_factor_dT
         logical, intent(in) :: dbg
           
         integer :: i1
         
         include 'formats'
         
         i1 = rtab(ir1)
         if (i1 == 0) then
            if (dbg) write(*,2) 'limit_rate_at_very_high_T i1 == 0 ' // 
     >               trim(reaction_Name(ir1)), ir1
            return
         end if

         rates(i_rate_dT,i1) = 
     >         factor*rates(i_rate_dT,i1) + 
     >         d_factor_dT*rates(i_rate,i1)

         rates(i_rate_dRho,i1) = 
     >         factor*rates(i_rate_dRho,i1)

         rates(i_rate,i1) = 
     >         factor*rates(i_rate,i1)
         
      end subroutine limit_rate_at_very_high_T
      
      
      subroutine get_he4_breakup_and_rebuild(
     >      n, g, y, num_reactions, rate_factors,
     >      ir_he4_breakup, ir_he4_rebuild, use_prot,
     >      d_rhe4_breakup_dneut, d_rhe4_breakup_dprot,
     >      d_rhe4_rebuild_dneut, d_rhe4_rebuild_dprot)        
         type (Net_Info), pointer :: n
         type (Net_General_Info), pointer  :: g
         real(dp), pointer :: y(:)
         integer, intent(in) :: num_reactions, ir_he4_breakup, ir_he4_rebuild
         logical, intent(in) :: use_prot
         real(dp), intent(in) :: rate_factors(:) ! (num_reactions)         
         real(dp), intent(out) ::
     >      d_rhe4_breakup_dneut, d_rhe4_breakup_dprot,
     >      d_rhe4_rebuild_dneut, d_rhe4_rebuild_dprot

         integer, pointer :: rtab(:), itab(:)
         real(dp), pointer :: rates(:, :)
         real(dp) :: 
     >      rhegn, rhegp, rdgn,
     >      rheng, rdpg, rhng,
     >      d_rhegn_dt, d_rhegp_dt, d_rdgn_dt,
     >      d_rheng_dt, d_rdpg_dt, d_rhng_dt,
     >      d_rhegn_dd, d_rhegp_dd, d_rdgn_dd,
     >      d_rheng_dd, d_rdpg_dd, d_rhng_dd,
     >      denom, denomdt, denomdd, denomdprot, denomdneut,
     >      zz, d_zz_dt, d_zz_dd, d_zz_dprot, d_zz_dneut
         integer :: neut, prot, rhe4_breakup, rhe4_rebuild
         integer :: rhe4g_neut_aux, rhe3gprot_aux, rh2g_neut_aux
         integer :: rprot_neutg_aux, rh2_protg_aux, rhe3_neutg_aux

         include 'formats.dek'
          
         rates => n% rate_screened
         rtab => g% net_reaction
         itab => g% net_iso

         neut = itab(ineut)
         if (neut == 0) stop 'need neut in net'
         if (use_prot) then
            prot = itab(iprot)
            if (prot == 0) prot = itab(ih1)
         else
            prot = itab(ih1)
         end if
         if (prot == 0) stop 'need prot in net'
         
         rhe4_breakup = rtab(ir_he4_breakup)
         rhe4_rebuild = rtab(ir_he4_rebuild)
         
         if (rhe4_breakup /= 0) rates(:, rhe4_breakup) = 0
         if (rhe4_rebuild /= 0) rates(:, rhe4_rebuild) = 0
         
         rhe4g_neut_aux = rtab(irhe4g_neut_aux)
         if (rhe4g_neut_aux == 0) stop 'need rhe4g_neut_aux'
         
         rhe3gprot_aux = rtab(irhe3gprot_aux)
         if (rhe3gprot_aux == 0) stop 'need rhe3gprot_aux'
         
         rh2g_neut_aux = rtab(irh2g_neut_aux)
         if (rh2g_neut_aux == 0) stop 'need rh2g_neut_aux'
         
         rprot_neutg_aux = rtab(irprot_neutg_aux)
         if (rprot_neutg_aux == 0) stop 'need rprot_neutg_aux'
         
         rh2_protg_aux = rtab(irh2_protg_aux)
         if (rh2_protg_aux == 0) stop 'need rh2_protg_aux'
         
         rhe3_neutg_aux = rtab(irhe3_neutg_aux)
         if (rhe3_neutg_aux == 0) stop 'need rhe3_neutg_aux'

         rhegn = rates(i_rate,rhe4g_neut_aux)*rate_factors(rhe4g_neut_aux)
         rhegp = rates(i_rate,rhe3gprot_aux)*rate_factors(rhe3gprot_aux)
         rdgn = rates(i_rate,rh2g_neut_aux)*rate_factors(rh2g_neut_aux)
         
         rheng = rates(i_rate,rhe3_neutg_aux)*rate_factors(rhe3_neutg_aux)
         rdpg = rates(i_rate,rh2_protg_aux)*rate_factors(rh2_protg_aux)
         rhng = rates(i_rate,rprot_neutg_aux)*rate_factors(rprot_neutg_aux)
         
         denom  = rhegp*rdgn + y(neut)*rheng*rdgn + y(neut)*y(prot)*rheng*rdpg
         
         if (.false.) then
            write(*,1) 'rhegn', rhegn
            write(*,1) 'rhegp', rhegp
            write(*,1) 'rdgn', rdgn
            write(*,1) 'rheng', rheng
            write(*,1) 'rdpg', rdpg
            write(*,1) 'rhng', rhng
            write(*,1) 'denom', denom
            write(*,*)
            !stop 'get_he4_breakup_and_rebuild'
         end if
         
         d_rhegn_dt = rates(i_rate_dT,rhe4g_neut_aux)*rate_factors(rhe4g_neut_aux)
         d_rhegp_dt = rates(i_rate_dT,rhe3gprot_aux)*rate_factors(rhe3gprot_aux)
         d_rdgn_dt = rates(i_rate_dT,rh2g_neut_aux)*rate_factors(rh2g_neut_aux)

         d_rhegn_dd = rates(i_rate_dRho,rhe4g_neut_aux)*rate_factors(rhe4g_neut_aux)
         d_rhegp_dd = rates(i_rate_dRho,rhe3gprot_aux)*rate_factors(rhe3gprot_aux)
         d_rdgn_dd = rates(i_rate_dRho,rh2g_neut_aux)*rate_factors(rh2g_neut_aux)
         
         d_rheng_dt = rates(i_rate_dT,rhe3_neutg_aux)*rate_factors(rhe3_neutg_aux)
         d_rdpg_dt = rates(i_rate_dT,rh2_protg_aux)*rate_factors(rh2_protg_aux)
         d_rhng_dt = rates(i_rate_dT,rprot_neutg_aux)*rate_factors(rprot_neutg_aux)
         
         d_rheng_dd = rates(i_rate_dRho,rhe3_neutg_aux)*rate_factors(rhe3_neutg_aux)
         d_rdpg_dd = rates(i_rate_dRho,rh2_protg_aux)*rate_factors(rh2_protg_aux)
         d_rhng_dd = rates(i_rate_dRho,rprot_neutg_aux)*rate_factors(rprot_neutg_aux)
            
         if (denom > 1) then
            denomdt =  
     1            d_rhegp_dt*rdgn 
     1          + rhegp*d_rdgn_dt  
     2          +  y(neut) * (d_rheng_dt*rdgn + rheng*d_rdgn_dt) 
     4          +  y(neut)*y(prot) * (d_rheng_dt*rdpg + rheng*d_rdpg_dt)
            denomdd =  
     1            d_rhegp_dd*rdgn 
     1          + rhegp*d_rdgn_dd  
     2          +  y(neut) * (d_rheng_dd*rdgn + rheng*d_rdgn_dd) 
     4          +  y(neut)*y(prot) * (d_rheng_dd*rdpg + rheng*d_rdpg_dd)
            denomdprot = y(neut)*rheng*rdpg
            denomdneut = rheng*rdgn + y(prot)*rheng*rdpg
         else
            denom = 1
            denomdt = 0
            denomdd = 0
            denomdprot = 0
            denomdneut = 0
         end if

         zz = 1/denom  
         d_zz_dt = -denomdt/denom**2
         d_zz_dd = -denomdd/denom**2
         d_zz_dprot = -denomdprot/denom**2
         d_zz_dneut = -denomdneut/denom**2
         
         if (rhe4_breakup /= 0) then
            rates(i_rate,rhe4_breakup) = rhegn*rhegp*rdgn*zz
            rates(:,rhe4_breakup) = rates(:,rhe4_breakup)*rate_factors(rhe4_breakup)

            rates(i_rate_dT,rhe4_breakup) = 
     >         d_rhegn_dt*rhegp*rdgn*zz +         
     >         rhegn*d_rhegp_dt*rdgn*zz +         
     >         rhegn*rhegp*d_rdgn_dt*zz +         
     >         rhegn*rhegp*rdgn*d_zz_dt       

            rates(i_rate_dRho,rhe4_breakup) = 
     >         d_rhegn_dd*rhegp*rdgn*zz +         
     >         rhegn*d_rhegp_dd*rdgn*zz +         
     >         rhegn*rhegp*d_rdgn_dd*zz +         
     >         rhegn*rhegp*rdgn*d_zz_dd       

            d_rhe4_breakup_dprot = rhegn*rhegp*rdgn*d_zz_dprot
            d_rhe4_breakup_dneut = rhegn*rhegp*rdgn*d_zz_dneut
         
         else

            d_rhe4_breakup_dprot = 0
            d_rhe4_breakup_dneut = 0
            
         end if
         
         if (rhe4_rebuild /= 0) then

            rates(i_rate,rhe4_rebuild) = rheng*rdpg*rhng*zz
            rates(:,rhe4_rebuild) = rates(:,rhe4_rebuild)*rate_factors(rhe4_rebuild)

            rates(i_rate_dT,rhe4_rebuild) = 
     >         d_rheng_dt*rdpg*rhng*zz +
     >         rheng*d_rdpg_dt*rhng*zz +
     >         rheng*rdpg*d_rhng_dt*zz +
     >         rheng*rdpg*rhng*d_zz_dt
     
            rates(i_rate_dRho,rhe4_rebuild) = 
     >         d_rheng_dd*rdpg*rhng*zz +
     >         rheng*d_rdpg_dd*rhng*zz +
     >         rheng*rdpg*d_rhng_dd*zz +
     >         rheng*rdpg*rhng*d_zz_dd

            d_rhe4_rebuild_dprot = rheng*rdpg*rhng*d_zz_dprot
            d_rhe4_rebuild_dneut = rheng*rdpg*rhng*d_zz_dneut
            
         else
         
            d_rhe4_rebuild_dprot = 0
            d_rhe4_rebuild_dneut = 0

         end if

      end subroutine get_he4_breakup_and_rebuild
      
      
      
      end module net_combos_support



         



         
         
         