
#include <stdio.h>
#include "klu_version.h"
#include "klu.h"

#define HANDLE_SIZE  8
/* kind of integer to hold a pointer. */
typedef long long fptr;  /* 64-bit by default */

typedef struct {
   KLU_symbolic *Symbolic ;
   KLU_numeric *Numeric ;
   KLU_common Common ;
} factors_t;

#ifdef USE_FLOAT128
#define c_fort c_fortran_klu_quad_
#undef basicfloat
#define basicfloat __float128
#else
#define c_fort c_fortran_klu_dble_
#undef basicfloat
#define basicfloat double
#endif

void c_fort(int *iopt, int *n, int *nrhs, 
                 basicfloat Ax [ ], int Ai [ ], int Ap [ ],
                 basicfloat B [ ], int *ldb, basicfloat *result,
		 fptr *f_factors, /* a handle containing the address
				     pointing to the factored matrices */
		 int *info)
{
/* 
 * This routine can be called from Fortran.
 *
 * f_factors (input/output) fptr* 
 *      If iopt == 1, it is an output and contains the pointer pointing to
 *                    the structure of the factored matrices.
 *      Otherwise, it it an input.
 *
 */
    int i;
    factors_t *klu, *copy_klu;
	 klu = (factors_t*) *f_factors;
    *info = 0;
    *result = 0.0;
    
    /* klu_test(); return; */

    if ( *iopt == -6 ) { /* turn off pivoting */

       klu->Common.tol = 0.0; /* force diagonal to be the pivot */

    } else if ( *iopt == -5 ) { /* copy klu */

	    copy_klu = (factors_t*) malloc(sizeof(factors_t));
       *copy_klu = *klu;
	    *f_factors = (fptr) copy_klu;

    } else if ( *iopt == -4 ) { /* free klu */
       
       free(klu);

    } else if ( *iopt == -3 ) { /* free Symbolic */

       KLU_free_symbolic (&klu->Symbolic, &klu->Common) ;
       *info = klu->Common.status;
       free(klu);

    } else if ( *iopt == -2 ) { /* free Numeric */

       KLU_free_numeric (&klu->Numeric, &klu->Common) ;
       *info = klu->Common.status;

    } else if ( *iopt == -1 ) { /* create Symbolic */

	    klu = (factors_t*) malloc(sizeof(factors_t));
	    *f_factors = (fptr) klu;
       KLU_defaults (&klu->Common) ;
       /*klu->Common.tol = 0.0; /* force diagonal to be the pivot */
       klu->Symbolic = KLU_analyze (*n, Ap, Ai, &klu->Common) ;
       *info = klu->Common.status;

    } else if ( *iopt == 0 ) { /* create Numeric */

       klu->Numeric = KLU_factor (Ap, Ai, Ax, klu->Symbolic, &klu->Common) ;
       *info = klu->Common.status;

    } else if ( *iopt == 1 ) { /* analyze and factor */

	    klu = (factors_t*) malloc(sizeof(factors_t));
	    *f_factors = (fptr) klu;
       KLU_defaults (&klu->Common) ;  
       /*klu->Common.tol = 0.0; /* force diagonal to be the pivot */
       klu->Symbolic = KLU_analyze (*n, Ap, Ai, &klu->Common) ;
       if (klu->Common.status == 0) {
          klu->Numeric = KLU_factor (Ap, Ai, Ax, klu->Symbolic, &klu->Common) ;
       } else {
	       printf("c_fortran_klu failed in analyze\n");
       }
       *info = klu->Common.status;

    } else if ( *iopt == 2 ) { /* solve */
       
       KLU_solve (klu->Symbolic, klu->Numeric, *ldb, *nrhs, B, &klu->Common) ;
       *info = klu->Common.status;

    } else if ( *iopt == 3 ) { /* free storage */

       KLU_free_symbolic (&klu->Symbolic, &klu->Common) ;
       KLU_free_numeric (&klu->Numeric, &klu->Common) ;
       free(klu);

    } else if ( *iopt == 4 ) { /* refactor */

       KLU_refactor (Ap, Ai, Ax, klu->Symbolic, klu->Numeric, &klu->Common) ;
       *info = klu->Common.status;

    } else if ( *iopt == 5 ) { /* result = rcond */

       KLU_rcond (klu->Symbolic, klu->Numeric, &klu->Common) ;
       *result = klu->Common.rcond;
       *info = klu->Common.status;

    } else if ( *iopt == 6 ) { /* result = rgrowth */

       KLU_rgrowth (Ap, Ai, Ax, klu->Symbolic, klu->Numeric, &klu->Common) ;
       *result = klu->Common.rgrowth;
       *info = klu->Common.status;

    } else if ( *iopt == 7 ) { /* result = condest */
       KLU_condest (Ap, Ax, klu->Symbolic, klu->Numeric, &klu->Common) ;
       *result = klu->Common.condest;
       *info = klu->Common.status;

    } else {
	    printf("Invalid iopt=%d passed to c_fortran_klu\n",*iopt);
	    exit(-1);
    }
}


