# opacity.rb

load "../../utils/image_plot.rb"


class Opacity_data < Image_data

    attr_accessor :logK, :dlogK_dlogRho, :dlogK_dlogT
    attr_accessor :logKec, :dlogKec_dlogRho, :dlogKec_dlogT
    attr_accessor :data_z, :data_xh, :data_xc, :data_xo
    
    def initialize(data_dir)
        read_image_Xs(data_dir, 'logRho.data', 'log $\\rho$ (g cm^{-3})')
        read_image_Ys(data_dir, 'logT.data', 'log T (K)')
        @logK = read_image_data(data_dir, 'logK')
        @dlogK_dlogRho = read_image_data(data_dir, 'dlogK_dlogRho')
        @dlogK_dlogT = read_image_data(data_dir, 'dlogK_dlogT')
        @logKec = read_image_data(data_dir, 'logKec')
        @dlogKec_dlogRho = read_image_data(data_dir, 'dlogKec_dlogRho')
        @dlogKec_dlogT = read_image_data(data_dir, 'dlogKec_dlogT')
        read_params(data_dir)
    end
    
    def read_params(data_dir)
        data = Dvector.read_row(data_dir + '/params.data')
        @data_z = data[0]
        @data_xh = data[1]
        @data_xc = data[2]
        @data_xo= data[3]
    end

end # class Opacity_data



class Opacity_plot

    include Math
    include FigureConstants
    include Image_plot
    
    class Test_model_data
    
        attr_accessor :mass, :radius, :density, :temp, :xh, :xhe
        attr_accessor :log_rho, :log_T
        
        def initialize(filename)
            @test_1_0_info = [
                nil,
                nil,
                @density = Dvector.new,
                @temp = Dvector.new
                ]
            Dvector.read(filename, @test_1_0_info)
            @log_rho = @density.safe_log10
            @log_T = @temp.safe_log10
        end
        
    end
    
    class Kap_rad_cond_data
    
        attr_accessor :logRho, :logT
        
        def initialize(filename)
            @kap_rad_cond_info = [
                @logRho = Dvector.new,
                @logT = Dvector.new
                ]
            puts "filename #{filename}"
            Dvector.read(filename, @kap_rad_cond_info)
            puts "@logRho #{@logRho}"
        end
        
    end
    
    
    def initialize(data_dir)
    
        @figure_maker = FigureMaker.default
        t.def_eval_function { |str| eval(str) }
        t.save_dir = 'plot_out'
        
        t.def_figure('logK') { logK }
        t.def_figure('logK_with_contours') { logK_with_contours }
        
        t.def_figure('dlogK_dlogRho') { dlogK_dlogRho }
        t.def_figure('dlogK_dlogT') { dlogK_dlogT }

        t.def_figure('logKec') { logKec }
        t.def_figure('dlogKec_dlogRho') { dlogKec_dlogRho }
        t.def_figure('dlogKec_dlogT') { dlogKec_dlogT }

        fyi = 'plot_FYI_data/'
            
        Dvector.read(fyi +'psi4.data', @psi4 = [Dvector.new, Dvector.new], 2)
        Dvector.read(fyi +'logP_equal_10.data', @logP_equal_10 = [Dvector.new, Dvector.new])

        @test_0_001 = Test_model_data.new(fyi +'test_0.001_plot.data')
        @test_0_01 = Test_model_data.new(fyi +'test_0.00991768_plot.data')
        @test_0_1 = Test_model_data.new(fyi +'test_0.1_plot.data')
        @test_0_3 = Test_model_data.new(fyi +'test_0.3_plot.data')
        @test_0_6 = Test_model_data.new(fyi +'test_0.6_plot.data')
        @test_0_6_low = Test_model_data.new(fyi +'test_0.6_low.data')
        @test_0_6_high = Test_model_data.new(fyi +'test_0.6_high.data')
        @test_1_0 = Test_model_data.new(fyi +'test_1.0_plot.data')
        @test_1_0_low = Test_model_data.new(fyi +'test_1.0_low.data')
        @test_1_0_high = Test_model_data.new(fyi +'test_1.0_high.data')
        @test_3_0_low = Test_model_data.new(fyi +'test_3.0_low.data')
        @test_3_0_high = Test_model_data.new(fyi +'test_3.0_high.data')
        @test_3_0 = Test_model_data.new(fyi +'test_3.0_plot.data')
        @test_4_0 = Test_model_data.new(fyi +'test_4.0_plot.data')
        @test_10_0 = Test_model_data.new(fyi +'test_10.0_plot.data')
        @test_100_0 = Test_model_data.new(fyi +'test_100.0_plot.data')
        @test_100_low = Test_model_data.new(fyi +'test_100.0_low.data')
        @test_100_high = Test_model_data.new(fyi +'test_100.0_high.data')
        @test_he_accretion = Test_model_data.new(fyi +'test_he_accretion.data')
        
        Dvector.read(fyi +'kap_rad_cond_eq.data', @kap_rad_cond_eq = [Dvector.new, Dvector.new])
        Dvector.read(fyi +'kap_rad_cond_x10.data', @kap_rad_cond_x10 = [Dvector.new, Dvector.new])

        Dvector.read(fyi +'elect.data', @elect_data = [Dvector.new, Dvector.new])

        @image_data = Opacity_data.new(data_dir)
        @label_scale = 0.55
        
        t.legend_text_dy = 1.4
        
        @no_clipping = false
        
        t.def_enter_page_function { enter_page }    
    end
    
    def enter_page
        t.page_setup(11*72/2,8.5*72/2)
        t.set_frame_sides(0.15,0.85,0.85,0.15) # left, right, top, bottom in page coords  
    end
    
    def t
        @figure_maker
    end
    
    def d
        @image_data
    end
    
# Opacity plotting methods

   def do_regions
        add_logR_limit
        # show where electron to baryon ratio is twice that expected
        t.line_width = 1.0
        t.line_type = Line_Type_Dash
        t.append_points_to_path(@elect_data[0],@elect_data[1])
        t.stroke_color = Crimson
        t.stroke
        # show where kap_rad == kap_cond
        t.line_type = Line_Type_Dot
        t.append_points_to_path(@kap_rad_cond_eq[0],@kap_rad_cond_eq[1])
        t.stroke_color = BrightBlue
        t.stroke
        dx = t.default_text_height_dx
        dy = t.default_text_height_dy/2
        
        add_test_line(@test_0_001.log_rho,@test_0_001.log_T,'$0.001$',0*dx,1*dy)
        #add_test_line(@test_0_01.log_rho,@test_0_01.log_T,'$0.01$',0*dx,1*dy)
        add_test_line(@test_0_1.log_rho,@test_0_1.log_T,'$0.1$',0*dx,1*dy)
        add_test_line(@test_1_0.log_rho,@test_1_0.log_T,'$1.0$',0*dx,1*dy)
        add_test_line(@test_100_0.log_rho,@test_100_0.log_T,'$100$',0*dx,1*dy)
   end 
    
    
    def do_decorations(title) # this is called from image_plot
        # show where electron to baryon ratio is twice that expected
        t.line_width = 1.0
        t.line_type = Line_Type_Dash
        t.append_points_to_path(@elect_data[0],@elect_data[1])
        t.stroke_color = Crimson
        t.stroke

            if @skip_footer == true
               text = sprintf('Z=%.3f, Y=%.3f', d.data_z, 1 - (d.data_xh+d.data_z))
               t.show_label('text' => text, 
                  'x' => -6.8, 'y' => 7.5,
                  'color' => Black,
                  'justification' => LEFT_JUSTIFIED, 
                  'scale' => 0.8)
            else
                if d.data_xc != 0 || d.data_xo != 0
                    footer = sprintf('Z=%.4f, X=%.4f, xc=%.4f, xo=%.4f', 
                        d.data_z, d.data_xh, d.data_xc, d.data_xo)
                else
                    footer = sprintf('Z=%.3f, Y=%.3f', d.data_z, 1 - (d.data_xh+d.data_z))
                end
                t.show_text('text'=> footer, 'side'=> BOTTOM, 'scale'=>0.7, 'shift'=>4.5)
            end
            
            if false
             t.show_label('text' => 'electron scattering opacity', 
                 'x' => -4.5, 'y' => 7.45,
                 'color' => Black,
                 'scale' => 0.8, 
                 'justification' => CENTERED, 
                 'alignment' => ALIGNED_AT_MIDHEIGHT)
              
             t.show_label('text' => '$\kappa_0 = 0.2(1 + X)$ cm^2 \textrm{g}^{-1}', 
                 'x' => -4.5, 'y' => 7.25,
                 'color' => Black,
                 'scale' => 0.8, 
                 'justification' => CENTERED, 
                 'alignment' => ALIGNED_AT_MIDHEIGHT)
         end 
          
          kx = -3.7
          t.show_label('text' => '$\kappa_0$', 
              'x' => kx, 'y' => 6.65,
              'color' => Black, 'scale' => 1, 
              'justification' => CENTERED, 
              'alignment' => ALIGNED_AT_MIDHEIGHT)

          t.show_label('text' => '$10\kappa_0$', 
              'x' => kx, 'y' => 5.9,
              'color' => Black, 'scale' => 1, 
              'justification' => CENTERED, 
              'alignment' => ALIGNED_AT_MIDHEIGHT)

          t.show_label('text' => '$10^2\kappa_0$', 
              'x' => kx, 'y' => 5.64,
              'color' => Black, 'scale' => 1, 
              'justification' => CENTERED, 
              'alignment' => ALIGNED_AT_MIDHEIGHT)

          t.show_label('text' => '$10^3\kappa_0$', 
              'x' => kx, 'y' => 5.4,
              'color' => Black, 'scale' => 1, 
              'justification' => CENTERED, 
              'alignment' => ALIGNED_AT_MIDHEIGHT)

          t.show_label('text' => '$10^4\kappa_0$', 
              'x' => kx, 'y' => 5.12,
              'color' => Black, 'scale' => 1, 
              'justification' => CENTERED, 
              'alignment' => ALIGNED_AT_MIDHEIGHT)

          t.show_label('text' => '$10^5\kappa_0$', 
              'x' => kx, 'y' => 4.8,
              'color' => Black, 'scale' => 1, 
              'justification' => CENTERED, 
              'alignment' => ALIGNED_AT_MIDHEIGHT)

          #t.show_label('text' => 'electron scattering', 
          #    'x' => -5.0, 'y' => 7.8,
          #    'color' => Black, 'scale' => 0.9, 
          #    'justification' => CENTERED, 
          #    'alignment' => ALIGNED_AT_MIDHEIGHT)

          t.show_label('text' => 'conduction by', 
              'x' => 1.95, 'y' => 3.8,
              'color' => Black, 'scale' => 0.8, 
              'justification' => CENTERED, 
              'alignment' => ALIGNED_AT_MIDHEIGHT)

          t.show_label('text' => 'degenerate electrons', 
              'x' => 1.95, 'y' => 3.6,
              'color' => Black, 'scale' => 0.8, 
              'justification' => CENTERED, 
              'alignment' => ALIGNED_AT_MIDHEIGHT)
            
         t.line_width = 2
         t.line_color = Coral
         add_TR_line(1, 2.7, 1, 8.7)
         add_TR_line(-8, 2.7, -8, 8.7)
         add_TR_line(8, 2.7, 8, 8.7)
         
         dx = t.default_text_height_dx/4
         dy = t.default_text_height_dy/2

         add_test_line(@kap_rad_cond_eq[0],@kap_rad_cond_eq[1],'',dx,dy, BrightBlue)

        add_test_line(@test_he_accretion.log_rho,@test_he_accretion.log_T,'WD',0*dx,1*dy)
        return

         add_test_line(@test_0_1.log_rho,@test_0_1.log_T,'$0.1$',dx,dy,LightSkyBlue)
         add_test_line(@test_0_3.log_rho,@test_0_3.log_T,'$0.3$',dx,dy,LightSkyBlue)

         #add_test_line(@test_0_6_low.log_rho,@test_0_6_low.log_T,'',dx,dy,LightSkyBlue)
         #add_test_line(@test_0_6_high.log_rho,@test_0_6_high.log_T,'$0.6$',dx,dy)

         add_test_line(@test_1_0_low.log_rho,@test_1_0_low.log_T,'',dx,dy,LightSkyBlue)
         add_test_line(@test_1_0_high.log_rho,@test_1_0_high.log_T,'$1.0$',dx,dy)

         add_test_line(@test_3_0_low.log_rho,@test_3_0_low.log_T,'',dx,dy)
         add_test_line(@test_3_0_high.log_rho,@test_3_0_high.log_T,'$3$',dx,dy,LightSkyBlue)

         add_test_line(@test_100_low.log_rho,@test_100_low.log_T,'',dx,dy)
         add_test_line(@test_100_high.log_rho,@test_100_high.log_T,'$100$',dx,dy,LightSkyBlue)

    end
    
    
    def clayton_degen_logRho(logT)
        temp = 10**logT
        y = 0.275
        z = 0.019
        x = 1 - (y + z)
        zbar = x + y*2 + z*7 
        abar = x + y*4 + z*14
        rho = 2.4e-7 * zbar/abar * temp**1.5
        return log10(rho)
    end
    
    
    def add_test_line(xs, ys, txt, dx, dy, clr = Teal, line_type = Line_Type_Solid)
        t.line_width = 2.0
        t.line_type = line_type
        t.append_points_to_path(xs, ys)
        t.stroke_color = clr
        t.stroke
        return if txt == nil
        t.show_label('text' => txt, 'x' => xs[-1]+dx, 'y' => ys[-1]+dy,
            'color' => Black,
            'scale' => 0.9, 'justification' => CENTERED, 'alignment' => ALIGNED_AT_MIDHEIGHT)
    end 
    
    
    def show_test_line(xs,ys,txt,dx,dy)
        t.line_type = Line_Type_Solid
        t.show_polyline(xs,ys,Teal)
        t.show_label(
            'text' => txt, 'x' => xs.max+0*dx, 'y' => ys.max+0*dy,
            'color' => Black,
            'scale' => 0.9, 'justification' => RIGHT_JUSTIFIED, 'alignment' => ALIGNED_AT_MIDHEIGHT)
    end
        
        
    def add_PSI(ary, psi)
        xs = ary[0]; ys = ary[1]
        j = ys.where_closest(6.86)
        t.line_type = Line_Type_Solid
        t.line_color = Crimson
        t.line_width = 2
        t.append_points_to_path(xs, ys)
        t.stroke
        t.show_label('text' => sprintf('${\epsilon}_F/{k T}$=%i', psi), 'x' => xs[j]-0.2, 'y' => ys[j],
            'color' => Black, 'scale' => 0.75, 'angle' => 52,
            'justification' => CENTERED, 'alignment' => ALIGNED_AT_MIDHEIGHT)
    end
    
    
    def get_logRho(logR, logT)
        logR + 3 * logT - 18
    end
    
    def clip_image
        return
        return if @no_clipping == true
        t.move_to_point(-4,2)
        t.append_point_to_path(17,9)
        t.append_point_to_path(-16,9)
        t.append_point_to_path(-16,2)
        t.close_path
        t.clip
    end
    
    
    def add_TR_line(logR1, logT1, logR2, logT2)
        logRho1 = logR1 + 3 * logT1 - 18
        logRho2 = logR2 + 3 * logT2 - 18
        t.stroke_line(logRho1, logT1, logRho2, logT2)
    end
    
    
    def show_freedman_region
    
        t.line_width = 2
        t.line_color = Tan
        
        t.move_to_point(-8.8,1.88)
        t.append_point_to_path(-3.36,1.88)
        t.append_point_to_path(-1.5,2.5)
        t.append_point_to_path(-2.6,3.6)
        t.append_point_to_path(-11.3,3.6)
        #t.append_point_to_path(-8.8,2.7)
        #t.append_point_to_path(-10.2,2.7)
        t.append_point_to_path(-9.5,1.88)
        t.append_point_to_path(-8.8,1.88)
        t.close_path
        t.stroke
        
        txt_scl = 1
        t.show_label('text' => 'FREEDMAN', 'x' => -5.3, 'y' => 2.7,
            'color' => Black,
            'scale' => txt_scl, 'justification' => CENTERED,
            'alignment' => ALIGNED_AT_MIDHEIGHT)
        
    end
    
    
    
    def add_logR_limit
    
        show_freedman_region
    
        t.line_width = 2
        t.line_color = Coral
        logT_lo = 2.7; logT_hi = 8.7; logT_max = 10.3
        add_TR_line(-8, logT_lo, -8, logT_hi)
        add_TR_line(1, logT_lo, 1, logT_hi)
        add_TR_line(1, logT_lo, -8, logT_lo)
        add_TR_line(1, logT_hi, -8, logT_hi)

        freg_blend_logT2 = 4.10
        freg_blend_logT1 = 3.93
        add_TR_line(1, 2.7, -8, 2.7)
        add_TR_line(1, freg_blend_logT1, -8, freg_blend_logT1)
        add_TR_line(1, freg_blend_logT2, -8, freg_blend_logT2)
        add_TR_line(1, 8.2, -8, 8.2)

        #t.line_color = Crimson
        #add_TR_line(-1, logT_lo, -1, 4)

        t.line_color = Black
        
        add_TR_line(-8, logT_hi, -8, logT_max)
        add_TR_line(-8, logT_max, 8, logT_max)
        add_TR_line(8, logT_lo, 8, logT_hi)
        #add_TR_line(1, logT_lo, 8, logT_lo)

        #add_TR_line(9, logT_lo, 9, logT_hi)
        #add_TR_line(2, 1.5, 3, logT_hi)
        
        txt_scl = 1.0
        t.show_label('text' => 'FERGUSON', 'x' => -9.2, 'y' => 3.6,
            'color' => Black,
            'scale' => txt_scl, 'justification' => CENTERED,
            'alignment' => ALIGNED_AT_MIDHEIGHT)
        
        
        t.show_label('text' => 'OPAL/OP', 'x' => -4.7, 'y' => 5.2,
            'color' => Black,
            'scale' => txt_scl, 'justification' => CENTERED,
            'alignment' => ALIGNED_AT_MIDHEIGHT)
        
        
        t.show_label('text' => 'COMPTON', 'x' => 5.5, 'y' => 9.1,
            'color' => Black,
            'scale' => txt_scl, 'justification' => CENTERED,
            'alignment' => ALIGNED_AT_MIDHEIGHT)
        
        
        t.show_label('text' => 'BLEND', 'x' => 1.8, 'y' => 8.45,
            'color' => Black,
            'scale' => 0.7, 'justification' => CENTERED,
            'alignment' => ALIGNED_AT_MIDHEIGHT)
        
        
        t.show_label('text' => 'e^+e^-', 'x' => 4.9, 'y' => 9.7,
            'color' => Crimson,
            'scale' => 0.7, 'justification' => CENTERED,
            'alignment' => ALIGNED_AT_MIDHEIGHT)
        
        t.show_label('text' => 'BLEND', 
            'x' => -9, 'y' => (freg_blend_logT1 + freg_blend_logT2)/2,
            'color' => Black,
            'scale' => 0.6, 'justification' => CENTERED,
            'alignment' => ALIGNED_AT_MIDHEIGHT)


        angle = 35
        t.show_label('text' => 'logR = -8', 'x' => -6.2, 'y' => 6.9,
            'color' => Black, 'angle' => angle,
            'scale' => txt_scl, 'justification' => CENTERED,
            'alignment' => ALIGNED_AT_MIDHEIGHT)
        t.show_label('text' => 'logR = 1', 'x' => 5, 'y' => 6.9,
            'color' => Black, 'angle' => angle,
            'scale' => txt_scl, 'justification' => CENTERED,
            'alignment' => ALIGNED_AT_MIDHEIGHT)
        t.show_label('text' => 'logR = 8', 'x' => 3.8, 'y' => 4.9,
            'color' => Black, 'angle' => angle,
            'scale' => txt_scl, 'justification' => CENTERED,
            'alignment' => ALIGNED_AT_MIDHEIGHT)
        
        
        
        
    end
    
    
    def add_lowT
        #return
        t.line_type = Line_Type_Dash
        t.line_color = Black
        t.line_width = 2
        t.move_to_point(-11, 4)
        t.append_point_to_path(-2, 4)
        t.append_point_to_path(-1.5, 3.85)
        t.append_point_to_path(-1.25, 3.58)
        t.append_point_to_path(-1.0, 3.18)
        t.append_point_to_path(-0.9, 2.9)
        t.stroke
        t.show_label('text' => '$log P = 10$', 'x' => -0.4, 'y' => 2.87,
            'color' => Black,
            'scale' => 1, 'justification' => CENTERED, 
            'alignment' => ALIGNED_AT_TOP)
    end
    
    
    # plot routines
    
    def logK
        @skip_footer = true
        xleft = -12
        xright = 10
        ytop = 10.5
        ybottom = 1.5
        boundaries = [xleft, xright, ytop, ybottom]
        title = ''
        t.show_plot('boundaries' => boundaries) {
            t.rescale(1.2)
            t.show_xlabel('log $\\rho$ (g cm^{-3})')
            t.show_ylabel('log T (K)')
            t.rescale(0.9)

            t.fill_color = White
            t.fill_frame
            do_regions
            #show_freedman_points
        }
        @skip_footer = false
    end
    
    
    def show_freedman_points
        freedman_info = [
            nil,
            temperature = Dvector.new,
            pressure = Dvector.new,
            density = Dvector.new,
            kap = Dvector.new
            ]
        Dvector.read('freedman.data', freedman_info, 2)
        logTs = temperature.log10
        logRhos = density.log10
        t.show_marker(
            'marker' => Box, 'Xs' => logRhos, 'Ys' => logTs, 
            'color' => Crimson, 'scale' => 0.1)
        logT_prev = -1
        i_prev = -1
        n = 0
        logTs.length.times { |i|
            logT = logTs[i]
            if logT != logT_prev
                #puts "#{(logT*100 + 0.5).to_i} num prev #{i - i_prev} n #{n}"
                puts "num_LogRhos_for_logT(#{n}) = #{i - i_prev}"
                logT_prev = logT
                i_prev = i
                n = n+1
            end
        }
    end
    
    
    def logK_with_contours
        legend_dict = Hash.new
        legend_dict['legend_top_margin'] = 0.02
        legend_dict['legend_left_margin'] = 0.04
        legend_dict['legend_right_margin'] = 0.65
        legend_dict['plot_scale'] = 1
        legend_dict['legend_scale'] = 1.25
        legend_dict['plot_right_margin'] = 0
        @doing_contours = true
        @skip_footer = true
        kap0 = 0.2*(1 + d.data_xh)
        #contours = [ log10(0.01*kap0), log10(0.1*kap0), log10(kap0), log10(10*kap0), log10(100*kap0) ]
        contours = [ log10(kap0), log10(10*kap0), log10(1e2*kap0), 
                      log10(1e3*kap0), log10(1e4*kap0), log10(1e5*kap0) ]
                      
        z_lower = -6.7
        z_upper = 9

        z_lower = nil
        z_upper = nil

        image_plot('d' => d, 'zs' => d.logK, 'title' => '', 
                    'color_bar_title' => 'log opacity (cm^2 \textrm{g}^{-1})',
                    'z_lower' => z_lower, 'z_upper' => z_upper, 'legend_dict' => legend_dict,
                    'color_bar_contours' => false,
                    'contours' => contours)
                    
        @doing_contours = false
        @skip_footer = false
    end

    def do_decorations(title)
        dx = t.default_text_height_dx
        dy = t.default_text_height_dy/2
        add_test_line(@test_0_001.log_rho,@test_0_001.log_T,'$0.001$',0*dx,1*dy)
        t.line_width = 2
        t.line_color = Coral
        add_TR_line(9, 1.7, 9, 8.7)
        add_TR_line(1, 1.7, 1, 8.7)
    end
    
    def dlogK_dlogRho
        #image_plot('d' => d, 'zs' => d.dlogK_dlogRho, 'title' => 'dlogK_dlogRho', 
        #    'z_lower' => -2.35, 'z_upper' => 2.35)
        image_plot('d' => d, 'zs' => d.dlogK_dlogRho, 'title' => 'dlogK_dlogRho', 
            'z_lower' => nil, 'z_upper' => nil)
    end
    
    def dlogK_dlogT
        image_plot('d' => d, 'zs' => d.dlogK_dlogT, 'title' => 'dlogK_dlogT', 
           'z_lower' => nil, 'z_upper' => nil)
            # 'z_lower' => -30, 'z_upper' => 30)
    end
    
    def logKec
        image_plot('d' => d, 'zs' => d.logKec, 'title' => 'logKec', 
            'z_lower' => nil, 'z_upper' => nil)
            #'z_lower' => -23, 'z_upper' => 23)
    end
    
    def dlogKec_dlogRho
        image_plot('d' => d, 'zs' => d.dlogKec_dlogRho, 'title' => 'dlogKec_dlogRho', 
            'z_lower' => nil, 'z_upper' => nil)
            #'z_lower' => -23, 'z_upper' => 23)
    end
    
    def dlogKec_dlogT
        image_plot('d' => d, 'zs' => d.dlogKec_dlogT, 'title' => 'dlogKec_dlogT', 
            'z_lower' => nil, 'z_upper' => nil)
            #'z_lower' => -23, 'z_upper' => 23)
    end
    
end

Opacity_plot.new('plot_data')
