   # eosDT.rb

   load "../../utils/image_plot.rb"

    class Test_model_data
    
        attr_accessor :mass, :radius, :density, :temp, :xh, :xhe
        attr_accessor :log_rho, :log_T
        
        def initialize(filename)
            test_info = [
                nil,
                nil,
                @density = Dvector.new,
                @temp = Dvector.new
                ]
            Dvector.read(filename, test_info)
            @log_rho = @density.safe_log10
            @log_T = @temp.safe_log10
        end
        
    end

   class Eos_data < Image_data

      attr_accessor :x, :z
      attr_accessor :fneut_H
      attr_accessor :fneut_He
      attr_accessor :fneut_C
      attr_accessor :fneut_N
      attr_accessor :fneut_O
      attr_accessor :fneut_Ne
      attr_accessor :fneut_Mg
      attr_accessor :fneut_Si
      attr_accessor :fneut_Fe
      attr_accessor :z_H
      attr_accessor :z_He
      attr_accessor :z_C
      attr_accessor :z_N
      attr_accessor :z_O
      attr_accessor :z_Ne
      attr_accessor :z_Mg
      attr_accessor :z_Si
      attr_accessor :z_Fe
      attr_accessor :logpp_H
      attr_accessor :logpp_He
      attr_accessor :logpp_C
      attr_accessor :logpp_N
      attr_accessor :logpp_O
      attr_accessor :logpp_Ne
      attr_accessor :logpp_Mg
      attr_accessor :logpp_Si
      attr_accessor :logpp_Fe

      def initialize(data_dir, fyi)

         params = Dvector.read_row(data_dir + '/params.data')
         @z = params[0]
         @x = params[1]
         puts "z=#{@z}  x=#{@x}"

         read_image_Xs(data_dir, 'logRho.data', 'log $\\rho$')
         read_image_Ys(data_dir, 'logT.data', 'log T')

         @fneut_H = read_image_data(data_dir, 'fneut_H')
         @fneut_He = read_image_data(data_dir, 'fneut_He')
         @fneut_C = read_image_data(data_dir, 'fneut_C')
         @fneut_N = read_image_data(data_dir, 'fneut_N')
         @fneut_O = read_image_data(data_dir, 'fneut_O')
         @fneut_Ne = read_image_data(data_dir, 'fneut_Ne')
         @fneut_Mg = read_image_data(data_dir, 'fneut_Mg')
         @fneut_Si = read_image_data(data_dir, 'fneut_Si')
         @fneut_Fe = read_image_data(data_dir, 'fneut_Fe')
         @z_H = read_image_data(data_dir, 'z_H')
         @z_He = read_image_data(data_dir, 'z_He')
         @z_C = read_image_data(data_dir, 'z_C')
         @z_N = read_image_data(data_dir, 'z_N')
         @z_O = read_image_data(data_dir, 'z_O')
         @z_Ne = read_image_data(data_dir, 'z_Ne')
         @z_Mg = read_image_data(data_dir, 'z_Mg')
         @z_Si = read_image_data(data_dir, 'z_Si')
         @z_Fe = read_image_data(data_dir, 'z_Fe')
         @logpp_H = read_image_data(data_dir, 'logpp_H')
         @logpp_He = read_image_data(data_dir, 'logpp_He')
         @logpp_C = read_image_data(data_dir, 'logpp_C')
         @logpp_N = read_image_data(data_dir, 'logpp_N')
         @logpp_O = read_image_data(data_dir, 'logpp_O')
         @logpp_Ne = read_image_data(data_dir, 'logpp_Ne')
         @logpp_Mg = read_image_data(data_dir, 'logpp_Mg')
         @logpp_Si = read_image_data(data_dir, 'logpp_Si')
         @logpp_Fe = read_image_data(data_dir, 'logpp_Fe')

      end

   end # class Eos_data


   class Diff_plot

   include Math
   include Tioga
   include FigureConstants
   include Image_plot

   class Profile_data

      attr_accessor :mass, :radius, :density, :temperature, :pgas, :energy
      attr_accessor :logRho, :logT, :logPgas, :logE

      def initialize(filename)

         ar = [
            @mass = Dvector.new,
            @radius = Dvector.new,
            @density = Dvector.new,
            @temperature = Dvector.new,
            @pgas = Dvector.new,
            @energy = Dvector.new
         ]
         Dvector.read(filename, ar, 4) # data starts on line 4

         @logRho = @density.safe_log10
         @logT = @temperature.safe_log10
         @logPgas = @pgas.safe_log10
         @logE = @energy.safe_log10

      end

   end

   class Ranges_data

      attr_accessor :log_T, :log_P

      def initialize(filename)
         Dvector.read(filename, [
         @log_T = Dvector.new,
         @log_P = Dvector.new
         ])
      end

   end

   class SCVHdata

      attr_accessor :log_rho_min, :log_rho_max, :log_T

      def initialize(filename)
         Dvector.read(filename, [@log_T = Dvector.new, 
         @log_rho_min = Dvector.new, @log_rho_max = Dvector.new])
      end

   end

   class OPALdata

      attr_accessor :log_rho, :log_Tmin, :log_Tmax

      def initialize(filename)
         Dvector.read(filename, [@log_rho = Dvector.new, 
         t6_min = Dvector.new, t6_max = Dvector.new])
         @log_Tmin = t6_min.mul(1e6).safe_log10
         @log_Tmax = t6_max.mul(1e6).safe_log10
      end

   end

   def initialize(data_dir)

      @data_dir = data_dir
      @figure_maker = FigureMaker.default
      t.def_eval_function { |str| eval(str) }
      t.save_dir = 'plot_out'
      
      fyi = 'plot_FYI_data/'
      @test_1_0 = Test_model_data.new(fyi +'test_1.0_plot.data')
      @test_0_1 = Test_model_data.new(fyi +'test_0.1_plot.data')
      @test_0_01 = Test_model_data.new(fyi +'test_0.00991768_plot.data')
      @test_0_001 = Test_model_data.new(fyi +'test_0.001_plot.data')
      @test_wd = Test_model_data.new(fyi +'test_wd_plot.data')

      @image_data = Eos_data.new(data_dir, fyi)

      t.def_figure('fneut_H') { fneut_H } unless d.fneut_H == nil
      t.def_figure('fneut_He') { fneut_He } unless d.fneut_He == nil
      t.def_figure('fneut_C') { fneut_C } unless d.fneut_C == nil
      t.def_figure('fneut_N') { fneut_N } unless d.fneut_N == nil
      t.def_figure('fneut_O') { fneut_O } unless d.fneut_O == nil
      t.def_figure('fneut_Ne') { fneut_Ne } unless d.fneut_Ne == nil
      t.def_figure('fneut_Mg') { fneut_Mg } unless d.fneut_Mg == nil
      t.def_figure('fneut_Si') { fneut_Si } unless d.fneut_Si == nil
      t.def_figure('fneut_Fe') { fneut_Fe } unless d.fneut_Fe == nil
      t.def_figure('z_H') { z_H } unless d.z_H == nil
      t.def_figure('z_He') { z_He } unless d.z_He == nil
      t.def_figure('z_C') { z_C } unless d.z_C == nil
      t.def_figure('z_N') { z_N } unless d.z_N == nil
      t.def_figure('z_O') { z_O } unless d.z_O == nil
      t.def_figure('z_Ne') { z_Ne } unless d.z_Ne == nil
      t.def_figure('z_Mg') { z_Mg } unless d.z_Mg == nil
      t.def_figure('z_Si') { z_Si } unless d.z_Si == nil
      t.def_figure('z_Fe') { z_Fe } unless d.z_Fe == nil
      t.def_figure('logpp_H') { logpp_H } unless d.logpp_H == nil
      t.def_figure('logpp_He') { logpp_He } unless d.logpp_He == nil
      t.def_figure('logpp_C') { logpp_C } unless d.logpp_C == nil
      t.def_figure('logpp_N') { logpp_N } unless d.logpp_N == nil
      t.def_figure('logpp_O') { logpp_O } unless d.logpp_O == nil
      t.def_figure('logpp_Ne') { logpp_Ne } unless d.logpp_Ne == nil
      t.def_figure('logpp_Mg') { logpp_Mg } unless d.logpp_Mg == nil
      t.def_figure('logpp_Si') { logpp_Si } unless d.logpp_Si == nil
      t.def_figure('logpp_Fe') { logpp_Fe } unless d.logpp_Fe == nil

      @label_scale = 0.75


      @no_clipping = false #true        

      t.def_enter_page_function { enter_page }    
   end

   def enter_page
      t.yaxis_numeric_label_angle = -90
      t.page_setup(11*72/2,8.5*72/2)
      t.set_frame_sides(0.15,0.85,0.85,0.15) # left, right, top, bottom in page coords  
   end


   def clip_image
    return
      return if @no_clipping == true
      t.move_to_point(9,5.3)
      t.append_point_to_path(3.40,5.3)
      t.append_point_to_path(-4.4, 2.1)
      t.append_point_to_path(-14, 2.1)
      t.append_point_to_path(-14,4.4)
      t.append_point_to_path(8,11)
      t.append_point_to_path(14.6,11)
      t.close_path
      t.clip
   end


   def t
      @figure_maker
   end

   def d
      @image_data
   end

   # EoS plotting methods


   def logOpalR_line(logOpalR)
    return
      logT1 = 3
      logRho1 = logOpalR + 3 * logT1 - 18
      logT2 = 11
      logRho2 = logOpalR + 3 * logT2 - 18
      t.line_width = 4
      t.line_color = Indigo
      #puts "#{logOpalR} #{logRho1} #{logT1} #{logRho2} #{logT2}"
      t.stroke_line(logRho1, logT1, logRho2, logT2)
   end


   def logQ_line(logQ)
      logT1 = 2
      logRho1 = logQ + 2 * logT1 - 12
      logT2 = 11
      logRho2 = logQ + 2 * logT2 - 12
      t.line_width = 1
      t.line_color = Teal
      #puts "#{logQ} #{logRho1} #{logT1} #{logRho2} #{logT2}"
      t.stroke_line(logRho1, logT1, logRho2, logT2)
   end
   
   
   def show_blend_regions
   
        # blend from table to non-table
        t.line_width = 1
        t.line_color = Black
        t.line_type = Line_Type_Dash

        logQ1 =   5.6900000000000004E+00
        logQ2 =   5.1900000000000004E+00
        logRho1 =   3.7000000000000002E+00
        logRho2 =   3.1899999999999999E+00
        logRho3 =  -1.7100000000000009E+00
        logRho4  = -2.2100000000000009E+00
        logRho5  = -9.0000000000000000E+00
        logRho6  = -9.9900000000000002E+00
        logRho7  = -12
        logT1  =  7.7000000000000002E+00
        logT2 =   7.5999999999999996E+00
        logT3  =  5.0049999999999999E+00
        logT4  =  5.0000000000000000E+00
        logT5  =  3.6000000000000001E+00
        logT6  =  3.5000000000000000E+00
        logT7 =   2.2999999999999998E+00
        logT8  =  2.2000000000000002E+00

        t.stroke_line(logRho2, logT1, logRho7, logT1)        
        t.stroke_line(logRho2, logT2, logRho7, logT2)        
        t.stroke_line(logRho2, logT1, logRho1, logT2)        
        t.stroke_line(logRho1, logT2, logRho1, logT3)        
        #t.stroke_line(logRho2, logT2, logRho2, logT3)        

        t.stroke_line(logRho4, logT7, logRho5, logT7)        
        t.stroke_line(logRho4, logT8, logRho5, logT8)        
        t.stroke_line(logRho4, logT8, logRho3, logT7)        
        t.stroke_line(logRho6, logT7, logRho5, logT8)      

        t.stroke_line(logRho2, logT2, logRho2, logT4)      
        t.stroke_line(logRho3, logT7, logRho1, logT3)      
        t.stroke_line(logRho4, logT7, logRho2, logT4)      

        t.stroke_line(logRho5, logT7, logRho5, logT6)      
        t.stroke_line(logRho6, logT7, logRho6, logT6)      
        t.stroke_line(logRho5, logT6, logRho6, logT5)    

        t.stroke_line(logRho6, logT5, logRho7, logT5)      
        t.stroke_line(logRho6, logT6, logRho7, logT6)      

        # blend from OPAL to SCVH
        t.line_width = 1
        t.line_color = Blue
        t.line_type = Line_Type_Dot

        logRho0 = logRho1
        logRho1 = 2.2
        logRho2 = 1.2
        logRho3 = -2.0
        logRho4 = -3.8
        logRho5 = -5.8
        logRho6 = -6.8
        logRho7 = -10
        logT1 = 6.6
        logT2 = 6.5
        logT3 = 4.0
        logT4 = 3.4
        logT5 = 3.3

        t.stroke_line(logRho0, logT1, logRho2, logT1)        
        t.stroke_line(logRho2, logT1, logRho4, logT3)        
        t.stroke_line(logRho4, logT3, logRho5, logT4)        
        t.stroke_line(logRho5, logT4, logRho7, logT4)        

        t.stroke_line(logRho0, logT2, logRho1, logT2)        
        t.stroke_line(logRho1, logT2, logRho3, logT3)        
        t.stroke_line(logRho3, logT3, logRho5, logT5)        
        t.stroke_line(logRho5, logT5, logRho7, logT5)        

        # typical HELM/PC blend
        t.line_width = 1
        t.line_color = Crimson
        t.line_type = Line_Type_Dot_Dash

        t.stroke_line(14.0, 9.45, 3.7, 6.019)        
        t.stroke_line(3.7, 6.019, 3.7, 1.0)

        t.stroke_line(14.0, 9.7535, 2.8, 6.02)        
        t.stroke_line(2.8, 6.02, 2.8, 1.0)  

   end
   
   
   def show_PC_HELM_blend(abar,zbar)
   
        qe = 4.80320440e-10
        avo = 6.02214179e23
        kerg = 1.3806504e-16 
        logRho1_PC_limit = 
        logRho2_PC_limit = 
        log_Gamma_all_HELM = 
        log_Gamma_all_PC = 
        
        logG0 = log10((zbar*qe)**2*((4.0/3.0)*pi*avo/abar)**(1.0/3.0)/kerg)
        logT_lo = logG0 + logRho2_PC_limit/3 - log_Gamma_all_HELM
        logT_hi = logG0 + logRho1_PC_limit/3 - log_Gamma_all_PC
        logRho = 14
        logT = logG0 + logRho/3 - log_Gamma_all_PC
        logRho1 = logRho; logT1 = logT
        logRho2 = logRho1_PC_limit; logT2 = logT_hi
        t.stroke_line(logRho1, logT1, logRho2, logT2)        
        t.stroke_line(logRho2, logT2, logRho2, 1.0)

        logT = logG0 + logRho/3 - log_Gamma_all_HELM
        logRho1 = logRho; logT1 = logT
        logRho2 = logRho2_PC_limit; logT2 = logT_lo
        t.stroke_line(logRho1, logT1, logRho2, logT2)        
        t.stroke_line(logRho2, logT2, logRho2, 1.0)

   end
   
   

   def do_decorations(title)
   
       #show_blend_regions
       dx = 3*t.default_text_height_dx
       add_test_line(@test_wd.log_rho,@test_wd.log_T,'$0.8 M_{\odot}$ WD',0*dx,0.6)
       add_test_line(@test_1_0.log_rho,@test_1_0.log_T,'$1.0 M_{\odot}$',0*dx,0.6)
       add_test_line(@test_0_1.log_rho,@test_0_1.log_T,'$0.1 M_{\odot}$',0*dx,0.6)
       add_test_line(@test_0_01.log_rho, @test_0_01.log_T, '$0.01 M_{\odot}$', 0*dx,-0.1)
       add_test_line(@test_0_001.log_rho, @test_0_001.log_T, '$0.001 M_{\odot}$', 0*dx,-0.1)
       
       logQ_line(2.7)
       logQ_line(5.69)
        
      return
      #logOpalR_line(14)
      #logOpalR_line(-14)
      
      logG_line(log10(40))
      logG_line(log10(80))

      dy = 0.4*t.default_text_height_dy
      t.line_width = 0.75
      t.stroke_color = BrightBlue
      t.line_type = Line_Type_Solid
      star_clr = Black
      return if @helm_only
      
      return
      
      
      add_test_line(@test_0_01.logRho, @test_0_01.logT, '$0.01 M_{\odot}$', 1.6*dx, -2*dy)
      add_test_line(@test_0_1.logRho, @test_0_1.logT, '$0.1 M_{\odot}$', dx, dy, star_clr)
      add_test_line(@test_1_0.logRho, @test_1_0.logT, '$1.0 M_{\odot}$', dx, dy, star_clr)
      add_test_line(@test_10_0.logRho, @test_10_0.logT, '$10.0 M_{\odot}$', dx, dy, star_clr)
      add_test_line(@test_150_0.logRho, @test_150_0.logT, 
         '$150 M_{\odot}$', -0.75*dx, 1.7*dy, star_clr)

      return
      t.line_width = 1
      t.line_color = Indigo
      logRho1 = 3.5
      logT1 = 3
      logRho2 = -8
      logT2 = 2
      t.stroke_line(logRho1, logT1, logRho2, logT2)


   end
    
    
    def logG_line(logG)  # logG = logRho/3 - logT + 6.76173  pure oxygen
        logRho1 = 3.8
        logT1 = logRho1/3 - logG + 6.76173
        logRho2 = 12
        logT2 = logRho2/3 - logG + 6.76173
        t.line_width = 1
        t.line_color = Blue
        t.line_type = Line_Type_Dot
        #puts "logG_line #{logG} #{logRho1} #{logT1} #{logRho2} #{logT2}"
        t.stroke_line(logRho1, logT1, logRho2, logT2)        
    end


   def add_test_line(xs, ys, txt, dx, dy, clr = Black)
      t.append_points_to_path(xs, ys)
      t.stroke_color = clr
      t.stroke
      #t.show_marker('marker' => Circle, 'Xs' => xs, 'Ys' => ys, 'scale' => 0.3, 'color' => Teal)
      return if txt == nil
      t.show_label('text' => txt, 'x' => xs[0] - 0.2*dx, 'y' => ys[0] - 0.5*dy,
         'color' => clr,
         'scale' => @label_scale, 
         'justification' => CENTERED, 
         'alignment' => ALIGNED_AT_MIDHEIGHT)
      t.show_label('text' => txt, 'x' => xs[-1] + 0.2*dx, 'y' => ys[-1] + 0.5*dy,
         'color' => clr,
         'scale' => @label_scale, 
         'justification' => CENTERED, 
         'alignment' => ALIGNED_AT_MIDHEIGHT)
   end 

   def show_params(pos = 0.5, shift = 4)
      return
      puts "show_params"
      if d.z >= 0.01
         txt = sprintf('X=%4.2f Zinit=%4.2f', d.x, d.z)
      elsif d.z >= 0.001
         txt = sprintf('X=%4.2f Zinit=%5.3f', d.x, d.z)
      else
         txt = sprintf('X=%4.2f Zinit=%6.4f', d.x, d.z)
      end
      t.show_text('text' => txt, 'side' => BOTTOM, 'pos' => pos, 
      'shift' => shift, 'scale' => 0.8, 'justification' => CENTERED)
   end


   # plot routines for diffusion data
   
   def fneut_H
      image_plot('d' => d, 'zs' => d.fneut_H, 'title' => 'fneut_H',  
         'z_lower' => nil, 'z_upper' => nil)
   end
   
   def fneut_He
      image_plot('d' => d, 'zs' => d.fneut_He, 'title' => 'fneut_He',  
         'z_lower' => nil, 'z_upper' => nil)
   end
   
   def fneut_C
      image_plot('d' => d, 'zs' => d.fneut_C, 'title' => 'fneut_C',  
         'z_lower' => nil, 'z_upper' => nil)
   end
   
   def fneut_N
      image_plot('d' => d, 'zs' => d.fneut_N, 'title' => 'fneut_N',  
         'z_lower' => nil, 'z_upper' => nil)
   end
   
   def fneut_O
      image_plot('d' => d, 'zs' => d.fneut_O, 'title' => 'fneut_O',  
         'z_lower' => nil, 'z_upper' => nil)
   end
   
   def fneut_Ne
      image_plot('d' => d, 'zs' => d.fneut_Ne, 'title' => 'fneut_Ne',  
         'z_lower' => nil, 'z_upper' => nil)
   end
   
   def fneut_Mg
      image_plot('d' => d, 'zs' => d.fneut_Mg, 'title' => 'fneut_Mg',  
         'z_lower' => nil, 'z_upper' => nil)
   end
   
   def fneut_Si
      image_plot('d' => d, 'zs' => d.fneut_Si, 'title' => 'fneut_Si',  
         'z_lower' => nil, 'z_upper' => nil)
   end
   
   def fneut_Fe
      image_plot('d' => d, 'zs' => d.fneut_Fe, 'title' => 'fneut_Fe',  
         'z_lower' => nil, 'z_upper' => nil)
   end
   
   def z_H
      image_plot('d' => d, 'zs' => d.z_H, 'title' => 'z_H',  
         'z_lower' => nil, 'z_upper' => nil)
   end
   
   def z_He
      image_plot('d' => d, 'zs' => d.z_He, 'title' => 'z_He',  
         'z_lower' => nil, 'z_upper' => nil)
   end
   
   def z_C
      image_plot('d' => d, 'zs' => d.z_C, 'title' => 'z_C',  
         'z_lower' => nil, 'z_upper' => nil)
   end
   
   def z_N
      image_plot('d' => d, 'zs' => d.z_N, 'title' => 'z_N',  
         'z_lower' => nil, 'z_upper' => nil)
   end
   
   def z_O
      image_plot('d' => d, 'zs' => d.z_O, 'title' => 'z_O',  
         'z_lower' => nil, 'z_upper' => nil)
   end
   
   def z_Ne
      image_plot('d' => d, 'zs' => d.z_Ne, 'title' => 'z_Ne',  
         'z_lower' => nil, 'z_upper' => nil)
   end
   
   def z_Mg
      image_plot('d' => d, 'zs' => d.z_Mg, 'title' => 'z_Mg',  
         'z_lower' => nil, 'z_upper' => nil)
   end
   
   def z_Si
      image_plot('d' => d, 'zs' => d.z_Si, 'title' => 'z_Si',  
         'z_lower' => nil, 'z_upper' => nil)
   end
   
   def z_Fe
      image_plot('d' => d, 'zs' => d.z_Fe, 'title' => 'z_Fe',  
         'z_lower' => nil, 'z_upper' => nil)
   end
   
   def logpp_H
      image_plot('d' => d, 'zs' => d.logpp_H, 'title' => 'logpp_H',  
         'z_lower' => nil, 'z_upper' => nil)
   end
   
   def logpp_He
      image_plot('d' => d, 'zs' => d.logpp_He, 'title' => 'logpp_He',  
         'z_lower' => nil, 'z_upper' => nil)
   end
   
   def logpp_C
      image_plot('d' => d, 'zs' => d.logpp_C, 'title' => 'logpp_C',  
         'z_lower' => nil, 'z_upper' => nil)
   end
   
   def logpp_N
      image_plot('d' => d, 'zs' => d.logpp_N, 'title' => 'logpp_N',  
         'z_lower' => nil, 'z_upper' => nil)
   end
   
   def logpp_O
      image_plot('d' => d, 'zs' => d.logpp_O, 'title' => 'logpp_O',  
         'z_lower' => nil, 'z_upper' => nil)
   end
   
   def logpp_Ne
      image_plot('d' => d, 'zs' => d.logpp_Ne, 'title' => 'logpp_Ne',  
         'z_lower' => nil, 'z_upper' => nil)
   end
   
   def logpp_Mg
      image_plot('d' => d, 'zs' => d.logpp_Mg, 'title' => 'logpp_Mg',  
         'z_lower' => nil, 'z_upper' => nil)
   end
   
   def logpp_Si
      image_plot('d' => d, 'zs' => d.logpp_Si, 'title' => 'logpp_Si',  
         'z_lower' => nil, 'z_upper' => nil)
   end
   
   def logpp_Fe
      image_plot('d' => d, 'zs' => d.logpp_Fe, 'title' => 'logpp_Fe',  
         'z_lower' => nil, 'z_upper' => nil)
   end


   end

   Diff_plot.new('plot_data')
