      program test_interp
      use const_lib
      use interp_2d_lib_db
      use interp_2d_lib_sg
      use interp_2d_support
      implicit none

      character (len=32) :: my_mesa_dir
      integer :: ierr
      
      my_mesa_dir = '../..'         
      call const_init(my_mesa_dir,ierr)     
   	if (ierr /= 0) then
   	   write(*,*) 'const_init failed'
   	   stop 1
   	end if        

      !call Build_2D_Plots(.false.)
      call Build_2D_Plots_sg(.false.)

      contains



      subroutine Build_2D_Plots(bicub_flag)
         logical, intent(in) :: bicub_flag

         integer :: io_first, io_last, io_xs, io_ys, io, x_points, y_points, i, j
         real(dp) :: x_max, x_min, y_max, y_min, dx, dy, x, y, z, dz_dx, dz_dy
         character (len=256) :: dir
         
         call get_2D_test_values_db
         call setup_to_interp_2D_db(bicub_flag)
         
         x_points = 201
         y_points = 191
         x_max = PI; x_min = -x_max
         y_max = PI; y_min = -y_max
         dx = (x_max - x_min) / (x_points - 1)
         dy = (y_max - y_min) / (y_points - 1)
         
         dir = 'plot_data'
         
         io_xs = 40
         io_ys = io_xs + 1
         io_first = io_ys + 1
         call Open_2D_Outfiles(io_first, io_last, io_xs, io_ys, dir)
         
         do j = 1, y_points
            y = y_min + (j-1) * dy
            write(io_ys,*) y
            do i = 1, x_points
               x = x_min + (i-1) * dx
               if (j==1) write(io_xs,*) x
               call eval_2D_interp_db(bicub_flag,x,y,z,dz_dx,dz_dy)
               io = io_first
               write(io,*) z; io = io + 1
               write(io,*) dz_dx; io = io + 1
               write(io,*) dz_dy; io = io + 1
            end do
         end do
         
         close(io_xs)
         close(io_ys)
         do io = io_first, io_last
            close(io)
         end do
         
         write(*,*) 'done creating data for 2D plots'

         
      end subroutine Build_2D_Plots 



      subroutine Build_2D_Plots_sg(bicub_flag)
         logical, intent(in) :: bicub_flag

         integer :: io_first, io_last, io_xs, io_ys, io, x_points, y_points, i, j
         real :: x_max, x_min, y_max, y_min, dx, dy, x, y, z, dz_dx, dz_dy
         character (len=256) :: dir
         
         call get_2D_test_values_sg
         call setup_to_interp_2D_sg(bicub_flag)
         
         x_points = 201
         y_points = 191
         x_max = pi_sg; x_min = -x_max
         y_max = pi_sg; y_min = -y_max
         dx = (x_max - x_min) / (x_points - 1)
         dy = (y_max - y_min) / (y_points - 1)
         
         dir = 'plot_data'
         
         io_xs = 40
         io_ys = io_xs + 1
         io_first = io_ys + 1
         call Open_2D_Outfiles(io_first, io_last, io_xs, io_ys, dir)
         
         do j = 1, y_points
            y = y_min + (j-1) * dy
            write(io_ys,*) y
            do i = 1, x_points
               x = x_min + (i-1) * dx
               if (j==1) write(io_xs,*) x
               call eval_2D_interp_sg(bicub_flag,x,y,z,dz_dx,dz_dy)
               io = io_first
               write(io,*) z; io = io + 1
               write(io,*) dz_dx; io = io + 1
               write(io,*) dz_dy; io = io + 1
            end do
         end do
         
         close(io_xs)
         close(io_ys)
         do io = io_first, io_last
            close(io)
         end do
         
         write(*,*) 'done creating data for 2D plots -- sg', bicub_flag

         
      end subroutine Build_2D_Plots_sg



      subroutine Open_2D_Outfiles(io_first, io_last, io_xs, io_ys, dir)
         integer, intent(IN) :: io_first, io_xs, io_ys
         integer, intent(OUT) :: io_last
         character (len=256), intent(IN) :: dir
         character (len=256) :: fname
         integer :: io
         
         fname = trim(dir) // '/x.data'
         open(unit=io_xs,file=trim(fname))
         
         fname = trim(dir) // '/y.data'
         open(unit=io_ys,file=trim(fname))
         
         io = io_first

         fname = trim(dir) // '/z.data'
         open(unit=io,file=trim(fname))

         fname = trim(dir) // '/dz_dx.data'
         io = io+1; open(unit=io,file=trim(fname))
   
         fname = trim(dir) // '/dz_dy.data'
         io = io+1; open(unit=io,file=trim(fname))
            
         io_last = io
      
      end subroutine Open_2D_Outfiles


      end program




