# interp_2D.rb

load "../../utils/image_plot.rb"

class Interp_2D_data < Image_data

    attr_accessor :z, :dz_dx, :dz_dy
    attr_accessor :xs, :ys
    
    def initialize(data_dir)
        @dir = data_dir
        read_image_Xs(data_dir, 'x.data', 'X')
        read_image_Ys(data_dir, 'y.data', 'Y')
        @z = read_image_data(data_dir, 'z')
        @dz_dx = read_image_data(data_dir, 'dz_dx')
        @dz_dy = read_image_data(data_dir, 'dz_dy')
    end
    
end # class Interp_2D_data

class Interp_2D_plot

    include Math
    include FigureConstants
    include Image_plot
    
    def initialize(data_dir)
    
        @figure_maker = FigureMaker.default
        t.def_eval_function { |str| eval(str) }
        t.save_dir = 'plot_out'
        
        t.def_figure('z') { z }
        t.def_figure('dz_dx') { dz_dx }
        t.def_figure('dz_dy') { dz_dy }
            

        @image_data = Interp_2D_data.new(data_dir)
        @label_scale = 0.55
        
        @no_clipping = true
        
        @image_aspect_ratio = 1
        

    end
    
    def t
        @figure_maker
    end
    
    def d
        @image_data
    end
    
    
    # plot routines
    
    def z
        image_plot('d' => d, 'zs' => d.z, 'title' => 'Function Values')
    end
    
    def dz_dx
        image_plot('d' => d, 'zs' => d.dz_dx, 'title' => 'dz/dx')
    end
    
    def dz_dy
        image_plot('d' => d, 'zs' => d.dz_dy, 'title' => 'dz/dy')
    end
    
end

Interp_2D_plot.new('plot_data')
