      module plot_eosQT
      use eos_def
      use eos_lib
      use const_def
      use chem_def
      use num_lib,only:safe_log10
      use utils_lib, only: is_bad_num
      use eos_support
      
      implicit none

      
      contains
      
      
      subroutine Build_QT_Plots

         character (len=256) :: dir
      
         double precision lgT_min,lgT_max,lgQ_min,lgQ_max,dlgT,
     >      dlgQ,lgQ,lgT,Q,T
      
         integer lgT_points, lgQ_points, time0, time1, clock_rate
         integer i,j,k,info, io,io_first,io_last,io_params,io_Q,io_tmp,num_vals

         integer, parameter :: io_unit0 = 40
      
         double precision :: X, Zinit, dXC, dXO, Y, Z

         double precision, allocatable :: output_values(:,:,:)

   !..composition

         ! Carbon
         X = 0.00d0
         Zinit = 0.00d0
         dXO = 0.0d0
         dXC = 1.00d0

         ! Oxygen
         X = 0.00d0
         Zinit = 0.00d0
         dXO = 1.0d0
         dXC = 0.00d0

         ! 3:1 H:He
         Zinit = 0.04d0
         dXO = 0.0d0
         dXC = 0.00d0
         X = 0.75d0*(1 - (Zinit+dXO+dXC))

         ! C/O even
         X = 0.00d0
         Zinit = 0.00d0
         dXO = 0.50d0
         dXC = 0.50d0

         ! solar
         X = 0.70d0
         Zinit = 0.02d0
         dXO = 0.00d0
         dXC = 0.00d0

         ! opal data
         X = 0.60d0
         Zinit = 0.02d0
         dXO = 0.00d0
         dXC = 0.00d0

         ! Hydrogen
         Zinit = 0.00d0
         dXO = 0.0d0
         dXC = 0.00d0
         X = 1.00d0

         ! Helium
         X = 0.00d0
         Zinit = 0.00d0
         dXO = 0.0d0
         dXC = 0.00d0

         ! test
         X = 0.70d0
         Zinit = 0.02d0
         dXO = 0.00d0
         dXC = 0.00d0

   !..set the sample size
            lgT_points = 200
            lgQ_points = 200
            
   !..set the ranges

	      
	      ! check scvh
	      lgT_max = 6d0
	      lgT_min = 2.3d0
	      lgQ_min = 2d0
	      lgQ_max = 4.9d0
	      
	      
   
      write(*,*) lgQ_min, lgQ_max
            
   !..open the output files
         io_params = io_unit0
         io_Q = io_unit0+1
         io_tmp = io_unit0+2
         io_first = io_unit0+3

         dir = 'plot_data_QT'
         call Open_Plot_Outfiles(io_first, io_last, io_params, io_Q, io_tmp, dir)
         write(io_params, '(4(f10.6),2(i7))') Zinit, X, dXC, dXO, lgQ_points, lgT_points
         close(io_params)
         num_vals  = io_last - io_first + 1
         allocate(output_values(lgQ_points,lgT_points,num_vals))
   
         Z = Zinit + dXC + dXO
         call Init_Composition(X, Zinit, dXC, dXO)
         
   !..get the results

         dlgT = (lgT_max - lgT_min)/(lgT_points-1)
         dlgQ = (lgQ_max - lgQ_min)/(lgQ_points-1)
   
         eos_ht% with_coulomb_corrections = .true.

!x $OMP PARALLEL DO PRIVATE(i,j,lgT,T,lgQ,Q)
         do j=1, lgT_points
            lgT = lgT_min + dlgT*(j-1)
            T = 10 ** lgT
            do i=1,lgQ_points
               lgQ = lgQ_min + dlgQ*(i-1)
               Q = 10 ** lgQ
               call Plot_one(i, j, lgT, T, lgQ, Q, output_values, Z, X, abar, zbar, 
     >            num_vals, lgQ_points, lgT_points, info)
            end do
         end do
!x $OMP END PARALLEL DO
   
         write(*,*) 'write QT files'
!x $OMP PARALLEL DO PRIVATE(k)
         do k = 1, num_vals
            write(*,*) k
            
            write(io_first+k-1,'(e24.16)') output_values(1:lgQ_points,1:lgT_points,k)
         end do
!x $OMP END PARALLEL DO

         do i = 1, lgT_points
            lgT = lgT_min + dlgT*(i-1)
            write(io_tmp,*) lgT
         end do
         close(io_tmp)
      
         do j=1,lgQ_points
            lgQ = lgQ_min + dlgQ*(j-1)
            write(io_Q,*) lgQ
         end do
         close(io_Q)
   
         do io=io_first,io_last
            close(io)
         end do
   
         deallocate(output_values)

         call Shutdown_eos

      end subroutine Build_QT_Plots


      subroutine Plot_one(i, j, lgT, T, lgQ, Q, output_values, Z, X, abar, zbar, 
     >      num_vals, lgQ_points, lgT_points, info)
         integer, intent(in) :: i, j, num_vals, lgQ_points, lgT_points
         double precision, intent(in) :: lgT, T, lgQ, Q, Z, X, abar, zbar
         double precision, intent(out) :: output_values(lgQ_points,lgT_points,num_vals)
         integer, intent(out) :: info

         double precision :: Rho, lgRho, plasg, lg_OpalR, time0, time1, energy, S, Prad, P
         double precision :: dlgT_dlgQ, theta_e, d_theta_e_deta, Pgas, Q_guess_error, Q_guess
         double precision, dimension(num_eos_basic_results) :: 
     >         res, d_dlnd, d_dlnT, d_dabar, d_dzbar
         double precision, dimension(num_helm_results) :: helm_res
         integer :: k, ierr
         
         logical, parameter :: basic_flag = .false.
         logical, parameter :: OpalR_flag = .false.
         
         double precision, parameter :: min_lg_OpalR = -14d0, max_lg_OpalR = 14d0
         
         include 'formats.dek'
                     
         ierr = 0

         lgRho = lgQ + 2*lgT - 12
         Rho = 10**lgRho
          
         call eosDT_get(
     >         handle, Z, X, abar, zbar, 
     >         species, chem_id, net_iso, xa,
     >         Rho, lgRho, T, lgT, 
     >         res, d_dlnd, d_dlnT, d_dabar, d_dzbar, ierr)
         !if (ierr /= 0) then
         !   write(*,1) 'failed lgQ, lgT', lgQ, lgT
         !end if
         
         call cpu_time(time1)
         plasg = Plasma_Coupling_Parameter(T, Rho, abar, zbar)

         if (ierr == 0) then

            k = 0
            Pgas = exp(res(i_lnPgas))
            Prad = crad*T**4/3
            P = Pgas + Prad
            k = k+1; output_values(i,j,k) = log10(P)
            k = k+1; output_values(i,j,k) = res(i_lnE)/ln10
            k = k+1; output_values(i,j,k) = res(i_lnS)/ln10

            k = k+1; output_values(i,j,k) = res(i_grad_ad)
            if (.false.) then
               write(*,1) 'lgQ', lgQ
               write(*,1) 'lgT', lgT
               write(*,1) 'grad_ad', res(i_grad_ad)
               write(*,*)
            end if
            
            k = k+1; output_values(i,j,k) = d_dlnT(i_grad_ad)
            k = k+1; output_values(i,j,k) = d_dlnd(i_grad_ad)

            k = k+1; output_values(i,j,k) = safe_log10(res(i_cv))
            k = k+1; output_values(i,j,k) = safe_log10(res(i_cp))
            k = k+1; output_values(i,j,k) = res(i_chiRho)
            k = k+1; output_values(i,j,k) = res(i_chiT)

            k = k+1; output_values(i,j,k) = res(i_gamma1)
            k = k+1; output_values(i,j,k) = res(i_gamma3)
            k = k+1; output_values(i,j,k) = res(i_eta)
            k = k+1; output_values(i,j,k) = d_dlnd(i_eta)
            k = k+1; output_values(i,j,k) = 1 / max(1d-99,d_dlnd(i_eta))

            k = k+1; output_values(i,j,k) = plasg
            
            energy = exp(res(i_lnE))
            S = exp(res(i_lnS))
            
            if (is_bad_num(S)) then
               write(*,1) 'Z', Z
               write(*,1) 'X', X
               write(*,1) 'abar', abar
               write(*,1) 'zbar', zbar
               write(*,1) 'logQ', lgQ
               write(*,1) 'logT', lgT
               write(*,1) 'S', S
               write(*,*)
               stop 'plotter'
            end if
            
            k = k+1; output_values(i,j,k) = res(i_Cv) * T / energy
            k = k+1; output_values(i,j,k) = res(i_dE_dRho) * Rho / energy
            k = k+1; output_values(i,j,k) = res(i_dS_dT) * T / S
            k = k+1; output_values(i,j,k) = res(i_dS_dRho) * Rho / S
            k = k+1; output_values(i,j,k) = eos_theta_e(res(i_eta), d_theta_e_deta)

            k = k+1; output_values(i,j,k) = res(i_lnfree_e)/ln10
            
            k = k+1; output_values(i,j,k) = res(i_lnPgas)/ln10
            k = k+1; output_values(i,j,k) = d_dlnd(i_lnPgas)
         
         end if
         
         info = ierr

      end subroutine Plot_one
      
      
      subroutine Open_Plot_Outfiles(io_first, io_last, io_params, io_Q, io_tmp, dir)
         integer, intent(IN) :: io_first, io_params, io_Q, io_tmp
         integer, intent(OUT) :: io_last
         character (len=256), intent(IN) :: dir
         character (len=256) :: fname
         integer :: io
         
         fname = trim(dir) // '/params.data'
         open(unit=io_params,file=trim(fname))
         
         fname = trim(dir) // '/logQ.data'
         open(unit=io_Q,file=trim(fname))
         
         fname = trim(dir) // '/logT.data'
         open(unit=io_tmp,file=trim(fname))
         
         io = io_first
         fname = trim(dir) // '/logP.data'
         open(unit=io,file=trim(fname))  
         fname = trim(dir) // '/logE.data'
         io = io+1; open(unit=io,file=trim(fname))          
         fname = trim(dir) // '/logS.data'
         io = io+1; open(unit=io,file=trim(fname))

         fname = trim(dir) // '/grad_ad.data'
         io = io+1; open(unit=io,file=trim(fname))
         fname = trim(dir) // '/d_grad_ad_dlnT.data'
         io = io+1; open(unit=io,file=trim(fname))
         fname = trim(dir) // '/d_grad_ad_dlnRho.data'
         io = io+1; open(unit=io,file=trim(fname))

         fname = trim(dir) // '/log_cv.data'
         io = io+1; open(unit=io,file=trim(fname))
         fname = trim(dir) // '/log_cp.data'
         io = io+1; open(unit=io,file=trim(fname))            
         fname = trim(dir) // '/chiRho.data'
         io = io+1; open(unit=io,file=trim(fname))
         fname = trim(dir) // '/chiT.data'
         io = io+1; open(unit=io,file=trim(fname))            

         fname = trim(dir) // '/gamma1.data'
         io = io+1; open(unit=io,file=trim(fname))
         fname = trim(dir) // '/gamma3.data'
         io = io+1; open(unit=io,file=trim(fname))
         fname = trim(dir) // '/eta.data'
         io = io+1; open(unit=io,file=trim(fname))            
         fname = trim(dir) // '/d_eta_dlnQ.data'
         io = io+1; open(unit=io,file=trim(fname))            
         fname = trim(dir) // '/d_lnd_d_eta.data'
         io = io+1; open(unit=io,file=trim(fname))            

         fname = trim(dir) // '/plasg.data'
         io = io+1; open(unit=io,file=trim(fname))

         fname = trim(dir) // '/dlnE_dlnT.data'
         io = io+1; open(unit=io,file=trim(fname))

         fname = trim(dir) // '/dlnE_dlnRho.data'
         io = io+1; open(unit=io,file=trim(fname))
                     
         fname = trim(dir) // '/dlnS_dlnT.data'
         io = io+1; open(unit=io,file=trim(fname))
         
         fname = trim(dir) // '/dlnS_dlnRho.data'
         io = io+1; open(unit=io,file=trim(fname))
         
         fname = trim(dir) // '/theta_e.data'
         io = io+1; open(unit=io,file=trim(fname))
         
         fname = trim(dir) // '/log_free_e.data'
         io = io+1; open(unit=io,file=trim(fname))
         
         fname = trim(dir) // '/logPgas.data'
         io = io+1; open(unit=io,file=trim(fname))

         fname = trim(dir) // '/dlnPgas_dlnRho.data'
         io = io+1; open(unit=io,file=trim(fname))
         
         io_last = io
      
      end subroutine Open_Plot_Outfiles


         
      
      end module plot_eosQT

