require 'Tioga/FigureMaker'
require 'read_ecapture'
require 'read_weaklib'

class TestPlots

  include Math
  include Tioga
  include FigureConstants
#  include MyPlotStyles

  def t
    @figure_maker
  end
  
  def initialize

    @figure_maker = FigureMaker.default

    @test_path = "../test_data/"
    @weak_path = "../test_data/"

    @ecap = EcaptureRates.new(@test_path, "test-ecapture")
    @weak = WeaklibRates.new(@weak_path)

    # set parameters
    @logYe = 0.5.log10


    t.def_figure("decay_namg") { decay_plot("mg24", "na24") }
    t.def_figure("decay_nena") { decay_plot("na24", "ne24") }
    t.def_figure("decay_of")   { decay_plot("ne20", "f20") }
    t.def_figure("decay_fne")  { decay_plot("f20",  "o20") }

    t.def_figure("capture_namg") { capture_plot("mg24", "na24") }
    t.def_figure("capture_nena") { capture_plot("na24", "ne24") }
    t.def_figure("capture_of")   { capture_plot("ne20", "f20") }
    t.def_figure("capture_fne")  { capture_plot("f20",  "o20") }

    
  end

  def decay_plot(lhs,rhs)

      @weak.read(lhs+rhs)
      @ecap.read(rhs,lhs)

      t.show_plot_with_legend('legend_left_margin' => 0.05,
                              'legend_top_margin' => 0.6,
                              'legend_scale' => 1.4,
                              'plot_right_margin' => 0){
        t.show_plot([6.5,10.5,5,-50]){
          title = '$\beta$-decay (%s $\to$ %s)' % [rhs,lhs]
          t.do_box_labels(title,
                          '$\log (\rho Y_{\rm e})\rm ~ [g ~ cm ^{-3}]$', 
                          '$\lambda_{\beta} ~ \rm [s^{-1}]$')


          colors = [BrickRed, Green, BrightBlue, Black]
          @weak.logtemp[1..4].each_with_index{|logt,i|
            plot_weak_ee_at_fixed_logtemp(logt, colors[i])
            plot_ecap_at_fixed_logtemp(logt, colors[i], 'T_9 = %3.1f' % 10**(logt -9))
          }

        }
      }        

  end

  def capture_plot(lhs,rhs)

      @weak.read(lhs+rhs)
      @ecap.read(lhs,rhs)

      t.show_plot_with_legend('legend_left_margin' => 0.05,
                              'legend_top_margin' => 0.00,
                              'legend_scale' => 1.4,
                              'plot_right_margin' => 0){
        t.show_plot([6.5,10.5,5,-50]){
          title = 'e-capture (%s $\to$ %s)' % [lhs,rhs]
          t.do_box_labels(title,
                          '$\log (\rho Y_{\rm e})\rm ~ [g ~ cm ^{-3}]$', 
                          '$\lambda_{\rm ec} ~ \rm [s^{-1}]$')


          colors = [BrickRed, Green, BrightBlue, Black]
          @weak.logtemp[1..4].each_with_index{|logt,i|
            plot_weak_ec_at_fixed_logtemp(logt, colors[i])
            plot_ecap_at_fixed_logtemp(logt, colors[i], 'T_9 = %3.1f' % 10**(logt -9))
          }

        }
      }        

  end


  # def quadplot

  #   t.subplot(t.row_margins('row' => 1, 'num_rows' => 2)){ 
  #     t.subplot(t.column_margins('column' => 1, 'num_columns' => 2)){
  #       capture_at_fixed_temp([8.5,10.5,5,-25], [8.6])
  #       t.do_box_labels(nil, '$\log (\rho Y_e)\rm ~ [g ~ cm ^{-3}]$', 
  #                       '$\lambda_{ec} ~ \rm [s^{-1}]$')

  #     }
  #     t.subplot(t.column_margins('column' => 2, 'num_columns' => 2)){
  #       capture_at_fixed_dens([0.1, 2.0,5,-25], [9.3, 9.8, 10.3])
  #       t.do_box_labels(nil, '$T_9\rm ~ [K]$', 
  #                       '$\lambda_{ec} ~ \rm [s^{-1}]$')
  #     }

  #   }

  # end




  def plot_ecap_at_fixed_logtemp(logtemp, color = Black, label = "", 
                                 style = LINE_TYPE_SOLID)
    idx = @ecap.logtemp.where_closest(logtemp)
    t.show_polyline(@ecap.logrhoye, @ecap.lambda.column(idx),
                    color, label, style)
  end

  def plot_ecap_at_fixed_logrhoye(logrhoye, color = Black, label = "", 
                                  style = LINE_TYPE_SOLID)
    idx = @ecap.logrhoye.where_closest(logrhoye)
    t.show_polyline(@ecap.logtemp, @ecap.lambda.row(idx),
                    color, label, style)
  end


  def plot_weak_ee_at_fixed_logtemp(logtemp, color = Black)
    idx = @weak.logtemp.where_closest(logtemp)
    @weak.logrhoye.each2(@weak.ee.column(idx)){|x,y|
      t.show_marker('x'=>x,'y'=>y, 'scale' => 0.6,
                    'marker'=>Circle, 'color' => color)
    }
      
  end

  def plot_weak_ec_at_fixed_logtemp(logtemp, color = Black)
    idx = @weak.logtemp.where_closest(logtemp)
    @weak.logrhoye.each2(@weak.ec.column(idx)){|x,y|
      t.show_marker('x'=>x,'y'=>y, 'scale' => 0.6,
                    'marker'=>Circle, 'color' => color)
    }
      
  end




end

TestPlots.new

