require 'Dobjects/Dvector'
require 'Dobjects/Dtable'

class WeaklibRates

  attr_reader :logtemp
  attr_reader :logrhoye

  attr_reader :pe
  attr_reader :ec
  attr_reader :nu
  attr_reader :ee
  attr_reader :pc
  attr_reader :nubar

  def initialize(filepath)
    @filepath = filepath
  end

  def read(reaction)

    filename = File.join(@filepath, "%s.data" % reaction)

    ntemp = 12
    ndens = 11
    
    t9 = Dvector.new([0.01, 0.1, 0.2, 0.4, 0.7, 1.0, 
                      1.5, 2.0, 3.0, 5.0, 10.0, 30.0])

    @logtemp = t9.log10 + 9
    @logrhoye = Dvector.new([1.0, 2.0, 3.0, 4.0, 5.0, 6.0, 
                             7.0, 8.0, 9.0, 10.0, 11.0])

    t1 = Dtable.new(ntemp+1,ndens)
    t2 = Dtable.new(ntemp+1,ndens)
    t3 = Dtable.new(ntemp+1,ndens)

    t4 = Dtable.new(ntemp+1,ndens)
    t5 = Dtable.new(ntemp+1,ndens)
    t6 = Dtable.new(ntemp+1,ndens)

    t1.read(filename, skiplines = 5)
    t2.read(filename, skiplines = 6 + ndens )
    t3.read(filename, skiplines = 7 + ndens * 2)
    t4.read(filename, skiplines = 9 + ndens * 3)
    t5.read(filename, skiplines = 10 + ndens * 4)
    t6.read(filename, skiplines = 11 + ndens * 5)

    @pe = Dtable.new(ntemp,ndens)
    @ec = Dtable.new(ntemp,ndens)
    @nu = Dtable.new(ntemp,ndens)

    @ee = Dtable.new(ntemp,ndens)
    @pc = Dtable.new(ntemp,ndens)
    @nubar = Dtable.new(ntemp,ndens)


    # oh boy is this awful!!!
    ntemp.times do |j|
        ndens.times do |i|
            
            @pe[i,j] = t1[i,j+1]
            @ec[i,j] = t2[i,j+1]
            @nu[i,j] = t3[i,j+1]
            @ee[i,j] = t4[i,j+1]
            @pc[i,j] = t5[i,j+1]
            @nubar[i,j] = t6[i,j+1]
      end
    end

  end

end
