require 'Dobjects/Dvector'
require 'Dobjects/Dtable'

class EcaptureRates

  attr_reader :logtemp
  attr_reader :logrhoye
  attr_reader :lambda
  attr_reader :dlambda_dlnT
  attr_reader :dlambda_dlnRho
  attr_reader :Qtot
  attr_reader :Qneu

  def initialize(filepath, fileprefix)
    @filepath = filepath
    @fileprefix = fileprefix
  end

  def read(lhs,rhs)

    @filename = File.join(@filepath, "%s-%s%s" % [@fileprefix,lhs,rhs])

    f = File.open(@filename)
    ntemp, ndens = f.readline.split.map{|x| x.to_i}
    f.close

    @logtemp = Dobjects::Dvector.read_row(@filename, 2)
    @logrhoye = Dobjects::Dvector.read_row(@filename, 3) + 0.5.log10

    @lambda = Dobjects::Dtable.new(ntemp,ndens)
    @dlambda_dlnT = Dobjects::Dtable.new(ntemp,ndens)
    @dlambda_dlnRho = Dobjects::Dtable.new(ntemp,ndens)

    @Qtot = Dobjects::Dtable.new(ntemp,ndens)
    @Qneu = Dobjects::Dtable.new(ntemp,ndens)

    dsets = [@lambda,
             @dlambda_dlnT,
             @dlambda_dlnRho,
             @Qtot,
             @Qneu]

    dsets.each_with_index{|dset, i|
      dset.read(@filename, skiplines = 3 + i*ndens)
    }

  end

end



