! ***********************************************************************
!
!   Copyright (C) 2013  Josiah Schwab, Bill Paxton
!
!   MESA is free software; you can use it and/or modify
!   it under the combined terms and restrictions of the MESA MANIFESTO
!   and the GNU General Library Public License as published
!   by the Free Software Foundation; either version 2 of the License,
!   or (at your option) any later version.
!
!   You should have received a copy of the MESA MANIFESTO along with
!   this software; if not, it is available at the mesa website:
!   http://mesa.sourceforge.net/
!
!   MESA is distributed in the hope that it will be useful,
!   but WITHOUT ANY WARRANTY; without even the implied warranty of
!   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
!   See the GNU Library General Public License for more details.
!
!   You should have received a copy of the GNU Library General Public License
!   along with this software; if not, write to the Free Software
!   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
!
! ***********************************************************************

module ecapture_def

  use const_def, only: dp
  use utils_def, only: integer_dict
  use chem_def, only: iso_name_length

  implicit none

  logical :: do_ecapture = .false.
  logical :: do_ecapture_coulomb = .false.

  character (len=256) :: ecapture_data_dir

  logical :: use_other_ecapture_data_dir = .false.
  character (len=1024) :: other_ecapture_data_dir

  logical :: ecapture_data_loaded

  integer, parameter :: max_num_ecapture_nuclei = 10
  integer, parameter :: max_num_ecapture_states = 10

  integer, parameter :: max_num_ecapture_reactions = 10
  integer, parameter :: max_num_ecapture_transitions = 25

  integer :: num_ecapture_nuclei, num_ecapture_reactions
  integer, pointer, dimension(:) :: ecapture_nuclide_id, &
       ecapture_lhs_nuclide_id, ecapture_rhs_nuclide_id ! (num_ecapture_reactions)
  character(len=iso_name_length), dimension(:), pointer :: ecapture_nuclide_name, &
       ecapture_lhs_nuclide_name, ecapture_rhs_nuclide_name ! (num_ecapture_reactions)
  type (integer_dict), pointer :: ecapture_reactions_dict

  integer :: num_ecapture_states
  type (integer_dict), pointer :: ecapture_states_number_dict
  type (integer_dict), pointer :: ecapture_states_offset_dict

  integer, parameter :: num_states_data = 2
  integer, parameter :: i_E = 1, i_J = 2
  real(dp), pointer :: ecapture_states_data(:,:)

  integer :: num_ecapture_transitions
  type (integer_dict), pointer :: ecapture_transitions_number_dict
  type (integer_dict), pointer :: ecapture_transitions_offset_dict

  integer, parameter :: num_transitions_data = 2
  integer, parameter :: i_Si = 1, i_Sf = 2
  integer, pointer :: ecapture_transitions_data(:,:)
  real(dp), pointer :: ecapture_logft_data(:)

contains

  subroutine ecapture_def_init(ierr)
    use const_def, only: mesa_data_dir
    integer, intent(out) :: ierr 
    ierr = 0
    if (use_other_ecapture_data_dir) then 
       ecapture_data_dir = other_ecapture_data_dir
    else
       ecapture_data_dir = trim(mesa_data_dir) // '/ecapture_data'
    end if
    ecapture_data_loaded = .false.
    nullify(ecapture_reactions_dict)
    nullify(ecapture_transitions_number_dict)
    nullify(ecapture_transitions_offset_dict)
    nullify(ecapture_states_number_dict)
    nullify(ecapture_states_offset_dict)
  end subroutine ecapture_def_init


  subroutine free_ecapture_info
    use utils_lib, only: integer_dict_free
    ecapture_data_loaded = .false.
    deallocate(ecapture_transitions_data, ecapture_states_data, ecapture_logft_data, &
         ecapture_nuclide_id, ecapture_lhs_nuclide_id, ecapture_rhs_nuclide_id, &
         ecapture_nuclide_name, ecapture_lhs_nuclide_name, ecapture_rhs_nuclide_name)
    call integer_dict_free(ecapture_reactions_dict)
    call integer_dict_free(ecapture_transitions_number_dict)
    call integer_dict_free(ecapture_transitions_offset_dict)
    call integer_dict_free(ecapture_states_number_dict)
    call integer_dict_free(ecapture_states_offset_dict)
  end subroutine free_ecapture_info


  subroutine create_ecapture_dict_key(ecapture_lhs, ecapture_rhs, key)
    character(len=iso_name_length), intent(in) :: ecapture_lhs, ecapture_rhs
    character(len=2*iso_name_length+1), intent(out) :: key
    key = trim(ecapture_lhs) // ' ' // trim(ecapture_rhs)
  end subroutine create_ecapture_dict_key


end module ecapture_def

