! ***********************************************************************
!
!   Copyright (C) 2013  Josiah Schwab, Bill Paxton
!
!   MESA is free software; you can use it and/or modify
!   it under the combined terms and restrictions of the MESA MANIFESTO
!   and the GNU General Library Public License as published
!   by the Free Software Foundation; either version 2 of the License,
!   or (at your option) any later version.
!
!   You should have received a copy of the MESA MANIFESTO along with
!   this software; if not, it is available at the mesa website:
!   http://mesa.sourceforge.net/
!
!   MESA is distributed in the hope that it will be useful,
!   but WITHOUT ANY WARRANTY; without even the implied warranty of
!   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
!   See the GNU Library General Public License for more details.
!
!   You should have received a copy of the GNU Library General Public License
!   along with this software; if not, write to the Free Software
!   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
!
! ***********************************************************************

module mod_eval_coulomb

  use const_def, only: dp

  implicit none

contains

  function do_mu_coulomb(z, rhoye, T, zbar) result(mu)

    ! calulate the chemi

    implicit none

    real(dp), intent(in) :: z     ! nuclear charge
    real(dp), intent(in) :: T     ! temperature
    real(dp), intent(in) :: rhoye ! density * electron fraction
    real(dp), intent(in) :: zbar  ! average nuclear charge

    real(dp) :: mu ! the chemical potential in units of kT

    real(dp) :: gamma
    real(dp) :: zr, zr_m1o3

    ! define parameters
    real(dp), parameter :: c0 = 0.9
    real(dp), parameter :: c1 = 0.2843
    real(dp), parameter :: c2 = -0.054
    real(dp), parameter :: d0 = -9.0 / 16.0
    real(dp), parameter :: d1 = 0.460

    logical :: debug = .false.

    ! coulomb coupling parameter
    gamma = 2.275e5_dp * z**(2.0/3.0) * zbar * rhoye ** (1.0/3.0) / T
    if (debug) write(*,'(a,3(ES12.3))') "gamma = ", gamma, rhoYe, T

    ! ratios for convenience
    zr = z/zbar
    zr_m1o3 = zr**(1.0/3.0) ! zr to the minus 1/3 power

    ! evaluate mu(Z)
    mu = -zr * (gamma * (c0 + (c1  + c2 * zr_m1o3) * zr_m1o3) + &
         (d0 + d1 * zr_m1o3))

    return

  end function do_mu_coulomb

end module mod_eval_coulomb
