! ***********************************************************************
!
!   Copyright (C) 2010  Bill Paxton
!
!   MESA is free software; you can use it and/or modify
!   it under the combined terms and restrictions of the MESA MANIFESTO
!   and the GNU General Library Public License as published
!   by the Free Software Foundation; either version 2 of the License,
!   or (at your option) any later version.
!
!   You should have received a copy of the MESA MANIFESTO along with
!   this software; if not, it is available at the mesa website:
!   http://mesa.sourceforge.net/
!
!   MESA is distributed in the hope that it will be useful,
!   but WITHOUT ANY WARRANTY; without even the implied warranty of
!   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
!   See the GNU Library General Public License for more details.
!
!   You should have received a copy of the GNU Library General Public License
!   along with this software; if not, write to the Free Software
!   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
!
!
! ***********************************************************************
 
      module nuclide_set_mod
      use chem_def	
      
      implicit none

      contains
      
      
            
      
      subroutine read_ZA(filename, Z, A, nnuc, ierr)
         use utils_lib
         use utils_def, only: eof_token
         character (len=*), intent(in) :: filename
         integer, dimension(:), pointer :: Z, A ! will be allocated
         integer, intent(out) :: nnuc, ierr
         
         integer :: iounit, n, i, t, id, pass, vals(3), j
      	integer :: ilo, ihi
         character (len=256) :: buffer, string

         ierr = 0
         iounit = alloc_iounit(ierr)
         if (ierr /= 0) return
         
         nullify(Z)
         nullify(A)
         
   	   ilo=0; ihi=0

         do pass = 1, 2
         
            if (pass == 2) then ! allocate the arrays
               nnuc = ihi
               allocate(Z(nnuc), A(nnuc), stat=ierr)
               if (failed('allocate')) return
               ilo=0; ihi=0
               !write(*,*) 'nnuc', nnuc
            end if
         
            call openfile(ierr)
            if (ierr /= 0) return

            n = 0
            i = 0
            
   trip_loop: do ! read triples Z, A_lo, A_hi
               
               do j=1,3
                  t = token(iounit, n, i, buffer, string)
                  if (t == eof_token) exit trip_loop
                  read(string,fmt=*,iostat=ierr) vals(j)
                  if (failed('bad data? error in reading')) then
                     write(*,*) 'pass', pass
                     write(*,*) '   n', n
                     write(*,*) '   i', i
                     write(*,*) 'buffer <' // trim(buffer) // '>'
                     write(*,*) 'string <' // trim(string) // '>'
                     return
                  end if
               end do
               
               call setZA(vals(1),vals(2),vals(3))

            end do trip_loop
            
            close(iounit)
            
         end do
         
         call free_iounit(iounit)

         
         contains
         
         
         logical function failed(str)
            character (len=*), intent(in) :: str
            if (ierr == 0) then
               failed = .false.
               return
            end if
            failed = .true.
            close(iounit)
            call free_iounit(iounit)
            write(*,*) trim(str) // ' ' // trim(filename)
         end function failed
         
         subroutine openfile(ierr)
            integer, intent(out) :: ierr
            !write(*,*) 'open ' // trim(filename)
            open(unit=iounit, file=trim(filename), action='read', status='old', iostat=ierr)
            if (failed('failed to open file')) return
         end subroutine openfile
      
      
         subroutine setZA(zee,alo,ahi)
            integer, intent(in) :: zee, alo, ahi
            integer :: i
            include 'formats.dek'
         	ilo = ihi+1; ihi=ilo+ahi-alo
         	if (pass == 1) return
         	if (ihi > nnuc) then
         	   write(*,2) 'ihi', ihi
         	   write(*,2) 'nnuc', nnuc
         	   write(*,*) 'bug in read_ZA'
         	   stop 1
         	end if
         	Z(ilo:ihi) = zee
         	A(ilo:ihi) = [(i, i=alo,ahi)]
         end subroutine setZA


      end subroutine read_ZA
      
      
      subroutine do_composition_info(Y, nuclides, abar, zbar, z2bar, ye)
      	double precision, intent(in) :: Y(:)
      	type(nuclide_data), intent(in) :: nuclides
         double precision, intent(out) :: abar, zbar, z2bar, ye
         double precision :: Z, yzsum, yz2sum, ysum
         integer :: i
         yzsum=0; yz2sum=0; ysum=0
         do i = 1, nuclides% nnuclides
            ysum = ysum + Y(i)
            Z = nuclides% Z(i)
            yzsum = yzsum + Y(i)*Z
            yz2sum = yz2sum + Y(i)*Z**2
         end do
         abar = 1d0/ysum
         zbar = abar*yzsum
         z2bar = abar*yz2sum
         ye = zbar/abar
      end subroutine do_composition_info
      

      function rank_in_set(iso, set)
      	character(len=iso_name_length), intent(in) :: iso
      	type(nuclide_set), dimension(:), intent(in) :: set
      	integer :: rank_in_set
      	integer :: low, high, mid, i
      	integer, parameter :: max_cycles = 20
      	low = 1
      	high = size(set)
      	if (adjustl(iso) < adjustl(set(low)% nuclide) .or. adjustl(iso) > adjustl(set(high)% nuclide)) then
      		rank_in_set = nuclide_not_found
      		return
      	end if	
      	do i = 1, max_cycles
      		if (high-low <=1) then
      			if (adjustl(iso) == adjustl(set(high)% nuclide)) then
      				rank_in_set = set(high)% rank
      			else if (adjustl(iso) == adjustl(set(low)% nuclide)) then
      				rank_in_set = set(low)% rank
      			else
      				rank_in_set = nuclide_not_found
      			end if
      			return
      		end if
      		mid = (high+low)/2
      		if (adjustl(iso) <= adjustl(set(mid)% nuclide)) then
      			high = mid
      		else if (adjustl(iso) > adjustl(set(mid)% nuclide)) then
      			low = mid
      		end if
      	end do
      	rank_in_set = nuclide_not_found
      end function rank_in_set
      

      subroutine sort_nuclide_set(set)
      	type(nuclide_set), dimension(:), intent(inout) :: set	
      	integer :: n, i, ir, j, l
      	type(nuclide_set) :: ts
	
      	n = size(set)
      	if (size(set) < 2) return
      	l = n/2+1
      	ir = n
      	do
      		if (l > 1) then
      			l = l-1
      			ts = set(l)
      		else
      			ts = set(ir)
      			set(ir) = set(1)
      			ir = ir-1
      			if (ir == 1) then
      				set(1) = ts
      				return
      			end if
      		end if
      		i = l
      		j = l+l
      		do
      			if (j > ir) exit
      			if (j < ir) then
      				if (compare_lt(set(j), set(j+1))) j = j+1
      			end if
      			if (compare_lt(ts, set(j))) then
      				set(i) = set(j)
      				i = j
      				j = j+j
      			else
      				j = ir + 1
      			end if
      		end do
      		set(i) = ts
      	end do

      	contains
      	
      	logical function compare_lt(a, b)
      		type(nuclide_set), intent(in) :: a, b
      		compare_lt = (adjustl(a% nuclide) < adjustl(b% nuclide))
      	end function compare_lt
      	
      end subroutine sort_nuclide_set
      

      subroutine read_nuclide_set(filename, set, err)
	
      	character(len=*), intent(in) :: filename
      	type(nuclide_set), dimension(:), pointer, intent(out) :: set
      	integer, intent(out) :: err
      	integer, parameter :: iounit=10
      	integer :: ios, i, nset
      	character(len=5) :: nuclide
	
      	err = 0
      	open(unit=iounit, file=filename, iostat=err, status="old", action="read")
      	if ( err /= 0 ) return

      	! first line must be size of set
      	read (iounit, *) nset
      	allocate(set(nset), stat=err)
      	if (err /= 0) stop "set: Allocation request denied"
         
         ios = 0
      	do i = 1, nset
      		read(iounit, *, iostat=ios) set(i)% rank, set(i)% nuclide
      		set(i)% nuclide = adjustr(set(i)% nuclide)
      		if (ios /= 0) then
      			print '("end of file with ", i0, " nuclides")', i
      			err = -1
      			exit
      		end if
      	end do	
      end subroutine read_nuclide_set

      
      subroutine set_some_isos
         use chem_def
         ih1 = get_nuclide_index('h1')
         ih2 = get_nuclide_index('h2')
         ih3 = get_nuclide_index('h3')
         ihe3 = get_nuclide_index('he3')
         ihe4 = get_nuclide_index('he4')
         ili6 = get_nuclide_index('li6')
         ili7 = get_nuclide_index('li7')
         ili8 = get_nuclide_index('li8')
         ibe7 = get_nuclide_index('be7')
         ibe8 = get_nuclide_index('be8')
         ibe9 = get_nuclide_index('be9')
         ibe10 = get_nuclide_index('be10')
         ibe11 = get_nuclide_index('be11')
         ib8 = get_nuclide_index('b8')
         ib10 = get_nuclide_index('b10')
         ib11 = get_nuclide_index('b11')
         ib12 = get_nuclide_index('b12')
         ib13 = get_nuclide_index('b13')
         ib14 = get_nuclide_index('b14')
         ic9 = get_nuclide_index('c9')
         ic10 = get_nuclide_index('c10')
         ic11 = get_nuclide_index('c11')
         ic12 = get_nuclide_index('c12')
         ic13 = get_nuclide_index('c13')
         ic14 = get_nuclide_index('c14')
         ic15 = get_nuclide_index('c15')
         ic16 = get_nuclide_index('c16')
         in12 = get_nuclide_index('n12')
         in13 = get_nuclide_index('n13')
         in14 = get_nuclide_index('n14')
         in15 = get_nuclide_index('n15')
         in16 = get_nuclide_index('n16')
         in17 = get_nuclide_index('n17')
         in18 = get_nuclide_index('n18')
         in19 = get_nuclide_index('n19')
         in20 = get_nuclide_index('n20')
         io13 = get_nuclide_index('o13')
         io14 = get_nuclide_index('o14')
         io15 = get_nuclide_index('o15')
         io16 = get_nuclide_index('o16')
         io17 = get_nuclide_index('o17')
         io18 = get_nuclide_index('o18')
         io19 = get_nuclide_index('o19')
         io20 = get_nuclide_index('o20')
         if15 = get_nuclide_index('f15')
         if16 = get_nuclide_index('f16')
         if17 = get_nuclide_index('f17')
         if18 = get_nuclide_index('f18')
         if19 = get_nuclide_index('f19')
         if20 = get_nuclide_index('f20')
         if21 = get_nuclide_index('f21')
         if22 = get_nuclide_index('f22')
         if23 = get_nuclide_index('f23')
         if24 = get_nuclide_index('f24')
         ine17 = get_nuclide_index('ne17')
         ine18 = get_nuclide_index('ne18')
         ine19 = get_nuclide_index('ne19')
         ine20 = get_nuclide_index('ne20')
         ine21 = get_nuclide_index('ne21')
         ine22 = get_nuclide_index('ne22')
         ine23 = get_nuclide_index('ne23')
         ine24 = get_nuclide_index('ne24')
         ine25 = get_nuclide_index('ne25')
         ine26 = get_nuclide_index('ne26')
         ine27 = get_nuclide_index('ne27')
         ine28 = get_nuclide_index('ne28')
         ina20 = get_nuclide_index('na20')
         ina21 = get_nuclide_index('na21')
         ina22 = get_nuclide_index('na22')
         ina23 = get_nuclide_index('na23')
         ina24 = get_nuclide_index('na24')
         ina25 = get_nuclide_index('na25')
         ina26 = get_nuclide_index('na26')
         ina27 = get_nuclide_index('na27')
         ina28 = get_nuclide_index('na28')
         ina29 = get_nuclide_index('na29')
         ina30 = get_nuclide_index('na30')
         ina31 = get_nuclide_index('na31')
         img20 = get_nuclide_index('mg20')
         img21 = get_nuclide_index('mg21')
         img22 = get_nuclide_index('mg22')
         img23 = get_nuclide_index('mg23')
         img24 = get_nuclide_index('mg24')
         img25 = get_nuclide_index('mg25')
         img26 = get_nuclide_index('mg26')
         img27 = get_nuclide_index('mg27')
         img28 = get_nuclide_index('mg28')
         img29 = get_nuclide_index('mg29')
         img30 = get_nuclide_index('mg30')
         img31 = get_nuclide_index('mg31')
         img32 = get_nuclide_index('mg32')
         img33 = get_nuclide_index('mg33')
         ial22 = get_nuclide_index('al22')
         ial23 = get_nuclide_index('al23')
         ial24 = get_nuclide_index('al24')
         ial25 = get_nuclide_index('al25')
         ial26 = get_nuclide_index('al26')
         ial27 = get_nuclide_index('al27')
         ial28 = get_nuclide_index('al28')
         ial29 = get_nuclide_index('al29')
         ial30 = get_nuclide_index('al30')
         ial31 = get_nuclide_index('al31')
         ial32 = get_nuclide_index('al32')
         ial33 = get_nuclide_index('al33')
         ial34 = get_nuclide_index('al34')
         ial35 = get_nuclide_index('al35')
         isi22 = get_nuclide_index('si22')
         isi23 = get_nuclide_index('si23')
         isi24 = get_nuclide_index('si24')
         isi25 = get_nuclide_index('si25')
         isi26 = get_nuclide_index('si26')
         isi27 = get_nuclide_index('si27')
         isi28 = get_nuclide_index('si28')
         isi29 = get_nuclide_index('si29')
         isi30 = get_nuclide_index('si30')
         isi31 = get_nuclide_index('si31')
         isi32 = get_nuclide_index('si32')
         isi33 = get_nuclide_index('si33')
         isi34 = get_nuclide_index('si34')
         isi35 = get_nuclide_index('si35')
         isi36 = get_nuclide_index('si36')
         isi37 = get_nuclide_index('si37')
         isi38 = get_nuclide_index('si38')
         ip26 = get_nuclide_index('p26')
         ip27 = get_nuclide_index('p27')
         ip28 = get_nuclide_index('p28')
         ip29 = get_nuclide_index('p29')
         ip30 = get_nuclide_index('p30')
         ip31 = get_nuclide_index('p31')
         ip32 = get_nuclide_index('p32')
         ip33 = get_nuclide_index('p33')
         ip34 = get_nuclide_index('p34')
         ip35 = get_nuclide_index('p35')
         ip36 = get_nuclide_index('p36')
         ip37 = get_nuclide_index('p37')
         ip38 = get_nuclide_index('p38')
         ip39 = get_nuclide_index('p39')
         ip40 = get_nuclide_index('p40')
         is27 = get_nuclide_index('s27')
         is28 = get_nuclide_index('s28')
         is29 = get_nuclide_index('s29')
         is30 = get_nuclide_index('s30')
         is31 = get_nuclide_index('s31')
         is32 = get_nuclide_index('s32')
         is33 = get_nuclide_index('s33')
         is34 = get_nuclide_index('s34')
         is35 = get_nuclide_index('s35')
         is36 = get_nuclide_index('s36')
         is37 = get_nuclide_index('s37')
         is38 = get_nuclide_index('s38')
         is39 = get_nuclide_index('s39')
         is40 = get_nuclide_index('s40')
         is41 = get_nuclide_index('s41')
         is42 = get_nuclide_index('s42')
         icl31 = get_nuclide_index('cl31')
         icl32 = get_nuclide_index('cl32')
         icl33 = get_nuclide_index('cl33')
         icl34 = get_nuclide_index('cl34')
         icl35 = get_nuclide_index('cl35')
         icl36 = get_nuclide_index('cl36')
         icl37 = get_nuclide_index('cl37')
         icl38 = get_nuclide_index('cl38')
         icl39 = get_nuclide_index('cl39')
         icl40 = get_nuclide_index('cl40')
         icl41 = get_nuclide_index('cl41')
         icl42 = get_nuclide_index('cl42')
         icl43 = get_nuclide_index('cl43')
         icl44 = get_nuclide_index('cl44')
         iar31 = get_nuclide_index('ar31')
         iar32 = get_nuclide_index('ar32')
         iar33 = get_nuclide_index('ar33')
         iar34 = get_nuclide_index('ar34')
         iar35 = get_nuclide_index('ar35')
         iar36 = get_nuclide_index('ar36')
         iar37 = get_nuclide_index('ar37')
         iar38 = get_nuclide_index('ar38')
         iar39 = get_nuclide_index('ar39')
         iar40 = get_nuclide_index('ar40')
         iar41 = get_nuclide_index('ar41')
         iar42 = get_nuclide_index('ar42')
         iar43 = get_nuclide_index('ar43')
         iar44 = get_nuclide_index('ar44')
         iar45 = get_nuclide_index('ar45')
         iar46 = get_nuclide_index('ar46')
         iar47 = get_nuclide_index('ar47')
         ik35 = get_nuclide_index('k35')
         ik36 = get_nuclide_index('k36')
         ik37 = get_nuclide_index('k37')
         ik38 = get_nuclide_index('k38')
         ik39 = get_nuclide_index('k39')
         ik40 = get_nuclide_index('k40')
         ik41 = get_nuclide_index('k41')
         ik42 = get_nuclide_index('k42')
         ik43 = get_nuclide_index('k43')
         ik44 = get_nuclide_index('k44')
         ik45 = get_nuclide_index('k45')
         ik46 = get_nuclide_index('k46')
         ik47 = get_nuclide_index('k47')
         ica35 = get_nuclide_index('ca35')
         ica36 = get_nuclide_index('ca36')
         ica37 = get_nuclide_index('ca37')
         ica38 = get_nuclide_index('ca38')
         ica39 = get_nuclide_index('ca39')
         ica40 = get_nuclide_index('ca40')
         ica41 = get_nuclide_index('ca41')
         ica42 = get_nuclide_index('ca42')
         ica43 = get_nuclide_index('ca43')
         ica44 = get_nuclide_index('ca44')
         ica45 = get_nuclide_index('ca45')
         ica46 = get_nuclide_index('ca46')
         ica47 = get_nuclide_index('ca47')
         ica48 = get_nuclide_index('ca48')
         ica49 = get_nuclide_index('ca49')
         ica50 = get_nuclide_index('ca50')
         ica51 = get_nuclide_index('ca51')
         ica52 = get_nuclide_index('ca52')
         ica53 = get_nuclide_index('ca53')
         isc40 = get_nuclide_index('sc40')
         isc41 = get_nuclide_index('sc41')
         isc42 = get_nuclide_index('sc42')
         isc43 = get_nuclide_index('sc43')
         isc44 = get_nuclide_index('sc44')
         isc45 = get_nuclide_index('sc45')
         isc46 = get_nuclide_index('sc46')
         isc47 = get_nuclide_index('sc47')
         isc48 = get_nuclide_index('sc48')
         isc49 = get_nuclide_index('sc49')
         isc50 = get_nuclide_index('sc50')
         isc51 = get_nuclide_index('sc51')
         isc52 = get_nuclide_index('sc52')
         isc53 = get_nuclide_index('sc53')
         iti39 = get_nuclide_index('ti39')
         iti40 = get_nuclide_index('ti40')
         iti41 = get_nuclide_index('ti41')
         iti42 = get_nuclide_index('ti42')
         iti43 = get_nuclide_index('ti43')
         iti44 = get_nuclide_index('ti44')
         iti45 = get_nuclide_index('ti45')
         iti46 = get_nuclide_index('ti46')
         iti47 = get_nuclide_index('ti47')
         iti48 = get_nuclide_index('ti48')
         iti49 = get_nuclide_index('ti49')
         iti50 = get_nuclide_index('ti50')
         iti51 = get_nuclide_index('ti51')
         iti52 = get_nuclide_index('ti52')
         iti53 = get_nuclide_index('ti53')
         iti54 = get_nuclide_index('ti54')
         iti55 = get_nuclide_index('ti55')
         iv43 = get_nuclide_index('v43')
         iv44 = get_nuclide_index('v44')
         iv45 = get_nuclide_index('v45')
         iv46 = get_nuclide_index('v46')
         iv47 = get_nuclide_index('v47')
         iv48 = get_nuclide_index('v48')
         iv49 = get_nuclide_index('v49')
         iv50 = get_nuclide_index('v50')
         iv51 = get_nuclide_index('v51')
         iv52 = get_nuclide_index('v52')
         iv53 = get_nuclide_index('v53')
         iv54 = get_nuclide_index('v54')
         iv55 = get_nuclide_index('v55')
         iv56 = get_nuclide_index('v56')
         iv57 = get_nuclide_index('v57')
         icr43 = get_nuclide_index('cr43')
         icr44 = get_nuclide_index('cr44')
         icr45 = get_nuclide_index('cr45')
         icr46 = get_nuclide_index('cr46')
         icr47 = get_nuclide_index('cr47')
         icr48 = get_nuclide_index('cr48')
         icr49 = get_nuclide_index('cr49')
         icr50 = get_nuclide_index('cr50')
         icr51 = get_nuclide_index('cr51')
         icr52 = get_nuclide_index('cr52')
         icr53 = get_nuclide_index('cr53')
         icr54 = get_nuclide_index('cr54')
         icr55 = get_nuclide_index('cr55')
         icr56 = get_nuclide_index('cr56')
         icr57 = get_nuclide_index('cr57')
         icr58 = get_nuclide_index('cr58')
         icr59 = get_nuclide_index('cr59')
         icr60 = get_nuclide_index('cr60')
         imn46 = get_nuclide_index('mn46')
         imn47 = get_nuclide_index('mn47')
         imn48 = get_nuclide_index('mn48')
         imn49 = get_nuclide_index('mn49')
         imn50 = get_nuclide_index('mn50')
         imn51 = get_nuclide_index('mn51')
         imn52 = get_nuclide_index('mn52')
         imn53 = get_nuclide_index('mn53')
         imn54 = get_nuclide_index('mn54')
         imn55 = get_nuclide_index('mn55')
         imn56 = get_nuclide_index('mn56')
         imn57 = get_nuclide_index('mn57')
         imn58 = get_nuclide_index('mn58')
         imn59 = get_nuclide_index('mn59')
         imn60 = get_nuclide_index('mn60')
         imn61 = get_nuclide_index('mn61')
         imn62 = get_nuclide_index('mn62')
         imn63 = get_nuclide_index('mn63')
         ife46 = get_nuclide_index('fe46')
         ife47 = get_nuclide_index('fe47')
         ife48 = get_nuclide_index('fe48')
         ife49 = get_nuclide_index('fe49')
         ife50 = get_nuclide_index('fe50')
         ife51 = get_nuclide_index('fe51')
         ife52 = get_nuclide_index('fe52')
         ife53 = get_nuclide_index('fe53')
         ife54 = get_nuclide_index('fe54')
         ife55 = get_nuclide_index('fe55')
         ife56 = get_nuclide_index('fe56')
         ife57 = get_nuclide_index('fe57')
         ife58 = get_nuclide_index('fe58')
         ife59 = get_nuclide_index('fe59')
         ife60 = get_nuclide_index('fe60')
         ife61 = get_nuclide_index('fe61')
         ife62 = get_nuclide_index('fe62')
         ife63 = get_nuclide_index('fe63')
         ife64 = get_nuclide_index('fe64')
         ife65 = get_nuclide_index('fe65')
         ife66 = get_nuclide_index('fe66')
         ife68 = get_nuclide_index('fe68')
         ico50 = get_nuclide_index('co50')
         ico51 = get_nuclide_index('co51')
         ico52 = get_nuclide_index('co52')
         ico53 = get_nuclide_index('co53')
         ico54 = get_nuclide_index('co54')
         ico55 = get_nuclide_index('co55')
         ico56 = get_nuclide_index('co56')
         ico57 = get_nuclide_index('co57')
         ico58 = get_nuclide_index('co58')
         ico59 = get_nuclide_index('co59')
         ico60 = get_nuclide_index('co60')
         ico61 = get_nuclide_index('co61')
         ico62 = get_nuclide_index('co62')
         ico63 = get_nuclide_index('co63')
         ico64 = get_nuclide_index('co64')
         ico65 = get_nuclide_index('co65')
         ico66 = get_nuclide_index('co66')
         ico67 = get_nuclide_index('co67')
         ini50 = get_nuclide_index('ni50')
         ini51 = get_nuclide_index('ni51')
         ini52 = get_nuclide_index('ni52')
         ini53 = get_nuclide_index('ni53')
         ini54 = get_nuclide_index('ni54')
         ini55 = get_nuclide_index('ni55')
         ini56 = get_nuclide_index('ni56')
         ini57 = get_nuclide_index('ni57')
         ini58 = get_nuclide_index('ni58')
         ini59 = get_nuclide_index('ni59')
         ini60 = get_nuclide_index('ni60')
         ini61 = get_nuclide_index('ni61')
         ini62 = get_nuclide_index('ni62')
         ini63 = get_nuclide_index('ni63')
         ini64 = get_nuclide_index('ni64')
         ini65 = get_nuclide_index('ni65')
         ini66 = get_nuclide_index('ni66')
         ini67 = get_nuclide_index('ni67')
         ini68 = get_nuclide_index('ni68')
         ini69 = get_nuclide_index('ni69')
         ini70 = get_nuclide_index('ni70')
         ini71 = get_nuclide_index('ni71')
         ini72 = get_nuclide_index('ni72')
         ini73 = get_nuclide_index('ni73')
         icu56 = get_nuclide_index('cu56')
         icu57 = get_nuclide_index('cu57')
         icu58 = get_nuclide_index('cu58')
         icu59 = get_nuclide_index('cu59')
         icu60 = get_nuclide_index('cu60')
         icu61 = get_nuclide_index('cu61')
         icu62 = get_nuclide_index('cu62')
         icu63 = get_nuclide_index('cu63')
         icu64 = get_nuclide_index('cu64')
         icu65 = get_nuclide_index('cu65')
         icu66 = get_nuclide_index('cu66')
         icu67 = get_nuclide_index('cu67')
         icu68 = get_nuclide_index('cu68')
         icu69 = get_nuclide_index('cu69')
         icu70 = get_nuclide_index('cu70')
         icu71 = get_nuclide_index('cu71')
         icu72 = get_nuclide_index('cu72')
         izn55 = get_nuclide_index('zn55')
         izn56 = get_nuclide_index('zn56')
         izn57 = get_nuclide_index('zn57')
         izn58 = get_nuclide_index('zn58')
         izn59 = get_nuclide_index('zn59')
         izn60 = get_nuclide_index('zn60')
         izn61 = get_nuclide_index('zn61')
         izn62 = get_nuclide_index('zn62')
         izn63 = get_nuclide_index('zn63')
         izn64 = get_nuclide_index('zn64')
         izn65 = get_nuclide_index('zn65')
         izn66 = get_nuclide_index('zn66')
         izn67 = get_nuclide_index('zn67')
         izn68 = get_nuclide_index('zn68')
         izn69 = get_nuclide_index('zn69')
         izn70 = get_nuclide_index('zn70')
         izn71 = get_nuclide_index('zn71')
         izn72 = get_nuclide_index('zn72')
         izn73 = get_nuclide_index('zn73')
         izn74 = get_nuclide_index('zn74')
         
         iga60 = get_nuclide_index('ga60')
         iga61 = get_nuclide_index('ga61')
         iga62 = get_nuclide_index('ga62')
         iga63 = get_nuclide_index('ga63')
         iga64 = get_nuclide_index('ga64')
         iga65 = get_nuclide_index('ga65')
         iga66 = get_nuclide_index('ga66')
         iga67 = get_nuclide_index('ga67')
         iga68 = get_nuclide_index('ga68')
         iga69 = get_nuclide_index('ga69')
         iga70 = get_nuclide_index('ga70')
         iga71 = get_nuclide_index('ga71')
         iga72 = get_nuclide_index('ga72')
         iga73 = get_nuclide_index('ga73')
         iga74 = get_nuclide_index('ga74')
         iga75 = get_nuclide_index('ga75')
         
         ige59 = get_nuclide_index('ge59')
         ige60 = get_nuclide_index('ge60')
         ige61 = get_nuclide_index('ge61')
         ige62 = get_nuclide_index('ge62')
         ige63 = get_nuclide_index('ge63')
         ige64 = get_nuclide_index('ge64')
         ige65 = get_nuclide_index('ge65')
         ige66 = get_nuclide_index('ge66')
         ige67 = get_nuclide_index('ge67')
         ige68 = get_nuclide_index('ge68')
         ige69 = get_nuclide_index('ge69')
         ige70 = get_nuclide_index('ge70')
         ige71 = get_nuclide_index('ge71')
         ige72 = get_nuclide_index('ge72')
         ige73 = get_nuclide_index('ge73')
         ige74 = get_nuclide_index('ge74')
         ige75 = get_nuclide_index('ge75')
         ige76 = get_nuclide_index('ge76')
         
         ias71 = get_nuclide_index('as71')
         ias72 = get_nuclide_index('as72')
         ias73 = get_nuclide_index('as73')
         ias74 = get_nuclide_index('as74')
         ias75 = get_nuclide_index('as75')
         ias76 = get_nuclide_index('as76')
         ias77 = get_nuclide_index('as77')
         ias78 = get_nuclide_index('as78')
         ias79 = get_nuclide_index('as79')
         
         ise68 = get_nuclide_index('se68')
         ise69 = get_nuclide_index('se69')
         ise70 = get_nuclide_index('se70')
         ise71 = get_nuclide_index('se71')
         ise72 = get_nuclide_index('se72')
         ise73 = get_nuclide_index('se73')
         ise74 = get_nuclide_index('se74')
         ise75 = get_nuclide_index('se75')
         ise76 = get_nuclide_index('se76')

         ikr70 = get_nuclide_index('kr70')
         ikr72 = get_nuclide_index('kr72')
         isr74 = get_nuclide_index('sr74')
         isr76 = get_nuclide_index('sr76')
         izr77 = get_nuclide_index('zr77')
         izr80 = get_nuclide_index('zr80')
         imo82 = get_nuclide_index('mo82')
         imo84 = get_nuclide_index('mo84')
         iru88 = get_nuclide_index('ru88')
         ipd92 = get_nuclide_index('pd92')
         isr75 = get_nuclide_index('sr75')
         iru86 = get_nuclide_index('ru86')
         iru87 = get_nuclide_index('ru87')
         ipd89 = get_nuclide_index('pd89')
         ipd91 = get_nuclide_index('pd91')
         icd93 = get_nuclide_index('cd93')
         icd96 = get_nuclide_index('cd96')
         isn98 = get_nuclide_index('sn98')
         isn100 = get_nuclide_index('sn100')
         isn102 = get_nuclide_index('sn102')
         isn104 = get_nuclide_index('sn104')
         ineut = get_nuclide_index('neut')
         iprot = get_nuclide_index('prot')
         
         contains
         
         function get_nuclide_index(nuclei) result(indx)
         	use utils_lib, only: integer_dict_lookup
         	character(len=*), intent(in) :: nuclei
         	integer :: indx, ierr
         	ierr = 0
         	call integer_dict_lookup(chem_isos_dict, nuclei, indx, ierr)
         	if (ierr /= 0) indx = nuclide_not_found
         end function get_nuclide_index
         
      end subroutine set_some_isos
      

      end module nuclide_set_mod
