! ***********************************************************************
!
!   Copyright (C) 2010  Bill Paxton
!
!   MESA is free software; you can use it and/or modify
!   it under the combined terms and restrictions of the MESA MANIFESTO
!   and the GNU General Library Public License as published
!   by the Free Software Foundation; either version 2 of the License,
!   or (at your option) any later version.
!
!   You should have received a copy of the MESA MANIFESTO along with
!   this software; if not, it is available at the mesa website:
!   http://mesa.sourceforge.net/
!
!   MESA is distributed in the hope that it will be useful,
!   but WITHOUT ANY WARRANTY; without even the implied warranty of
!   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
!   See the GNU Library General Public License for more details.
!
!   You should have received a copy of the GNU Library General Public License
!   along with this software; if not, write to the Free Software
!   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
!
! ***********************************************************************

      module binary_private_def
      
      use binary_def

      implicit none

   ! history column options

      integer, parameter :: bh_model_number = 1
      integer, parameter :: bh_age = bh_model_number + 1
      integer, parameter :: bh_period_days = bh_age + 1
      integer, parameter :: bh_period_hr = bh_period_days + 1
      integer, parameter :: bh_period_minutes = bh_period_hr + 1
      integer, parameter :: bh_lg_separation = bh_period_minutes + 1
      integer, parameter :: bh_binary_separation = bh_lg_separation + 1
      integer, parameter :: bh_rl_donor = bh_binary_separation + 1
      integer, parameter :: bh_rl_accretor = bh_rl_donor + 1
      integer, parameter :: bh_rl_overflow = bh_rl_accretor + 1
      integer, parameter :: bh_rl_relative_overflow = bh_rl_overflow + 1
      integer, parameter :: bh_donor_mass = bh_rl_relative_overflow + 1
      integer, parameter :: bh_lg_donor_mass = bh_donor_mass + 1
      integer, parameter :: bh_companion_mass = bh_lg_donor_mass + 1
      integer, parameter :: bh_lg_companion_mass = bh_companion_mass + 1
      integer, parameter :: bh_sum_of_masses = bh_lg_companion_mass + 1
      integer, parameter :: bh_donor_div_companion_mass = bh_sum_of_masses + 1
      integer, parameter :: bh_delta_companion_mass = bh_donor_div_companion_mass + 1
      integer, parameter :: bh_lg_F_irr = bh_delta_companion_mass + 1
      integer, parameter :: bh_xfer_fraction = bh_lg_F_irr + 1
      integer, parameter :: bh_log_J = bh_xfer_fraction + 1
      integer, parameter :: bh_log_abs_Jdot = bh_log_J + 1
      integer, parameter :: bh_log_abs_jdot_mb = bh_log_abs_Jdot + 1
      integer, parameter :: bh_log_abs_jdot_gr = bh_log_abs_jdot_mb + 1
      integer, parameter :: bh_log_abs_jdot_ml = bh_log_abs_jdot_gr + 1
      integer, parameter :: bh_log_abs_jdot_tide = bh_log_abs_jdot_ml + 1
      integer, parameter :: bh_log_abs_jdot_ls = bh_log_abs_jdot_tide + 1
      integer, parameter :: bh_log_abs_extra_jdot = bh_log_abs_jdot_ls + 1
      
      integer, parameter :: bh_col_id_max = bh_log_abs_extra_jdot
      
      character (len=maxlen_binary_history_column_name) :: binary_history_column_name(bh_col_id_max)
      
      contains
      
      
      subroutine binary_history_column_names_init(ierr)
         integer, intent(out) :: ierr
         
         integer :: i, cnt
         ierr = 0
         cnt = 0
         binary_history_column_name(:) = ''

         binary_history_column_name(bh_model_number) = 'model_number'
         binary_history_column_name(bh_age) = 'age'
         binary_history_column_name(bh_period_days) = 'period_days'
         binary_history_column_name(bh_period_hr) = 'period_hr'
         binary_history_column_name(bh_period_minutes) = 'period_minutes'
         binary_history_column_name(bh_lg_separation) = 'lg_separation'
         binary_history_column_name(bh_binary_separation) = 'binary_separation'
         binary_history_column_name(bh_rl_donor) = 'rl_donor'
         binary_history_column_name(bh_rl_accretor) = 'rl_accretor'
         binary_history_column_name(bh_rl_overflow) = 'rl_overflow'
         binary_history_column_name(bh_rl_relative_overflow) = 'rl_relative_overflow'
         binary_history_column_name(bh_donor_mass) = 'donor_mass'
         binary_history_column_name(bh_lg_donor_mass) = 'lg_donor_mass'
         binary_history_column_name(bh_companion_mass) = 'companion_mass'
         binary_history_column_name(bh_lg_companion_mass) = 'lg_companion_mass'
         binary_history_column_name(bh_sum_of_masses) = 'sum_of_masses'
         binary_history_column_name(bh_donor_div_companion_mass) = 'donor_div_companion_mass'
         binary_history_column_name(bh_delta_companion_mass) = 'delta_companion_mass'
         binary_history_column_name(bh_lg_F_irr) = 'lg_F_irr'
         binary_history_column_name(bh_xfer_fraction) = 'xfer_fraction'
         binary_history_column_name(bh_log_J) = 'log_J'
         binary_history_column_name(bh_log_abs_Jdot) = 'log_abs_Jdot'
         binary_history_column_name(bh_log_abs_jdot_mb) = 'log_abs_jdot_mb'
         binary_history_column_name(bh_log_abs_jdot_gr) = 'log_abs_jdot_gr'
         binary_history_column_name(bh_log_abs_jdot_ml) = 'log_abs_jdot_ml'
         binary_history_column_name(bh_log_abs_jdot_tide) = 'log_abs_jdot_tide'
         binary_history_column_name(bh_log_abs_jdot_ls) = 'log_abs_jdot_ls'
         binary_history_column_name(bh_log_abs_extra_jdot) = 'log_abs_extra_jdot'
                  
         cnt = 0
         do i=1,bh_col_id_max
            if (len_trim(binary_history_column_name(i)) == 0) then
               write(*,*) 'missing name for log column id', i
               if (i > 1) write(*,*) 'following ' // trim(binary_history_column_name(i-1))
               write(*,*) 
               cnt = cnt+1
            end if
         end do

         if (cnt > 0) then
            ierr = -1
            return
         end if

      end subroutine binary_history_column_names_init         


      end module binary_private_def

