      module mod_plot_atm
      use atm_def
      use atm_lib
      use const_def
      use chem_def
      use chem_lib
      use num_lib,only:safe_log10
      use utils_lib, only: is_bad_num
      use test_atm_support
      
      implicit none

      
      contains
      
      
      subroutine Build_Plots
   	   integer :: ierr
   	   character(len=256) :: dir
      
         double precision :: Teff_min, Teff_max, logg_min, logg_max, dTeff, dlogg, lgRho
      
         integer Teff_points, logg_points
         integer i, j, k, info, io, io_first, io_last, io_teff, &
            io_logg, num_vals, which_atm_option

         integer, parameter :: io_unit0 = 40

         double precision, allocatable :: output_values(:,:,:)
         

         call setup


   !..set the sample size
         Teff_points = 300
         logg_points = 300
            

            
   !..open the output files
         io_teff = io_unit0
         io_logg = io_unit0+2
         io_first = io_unit0+3

         dir = 'plot_data'
         call Open_Plot_Outfiles(io_first, io_last, io_teff, io_logg, dir)
         num_vals  = io_last - io_first + 1
         allocate(output_values(logg_points,Teff_points,num_vals))
         
         !which_atm_option = atm_wd_tau_25_tables
         which_atm_option = atm_tau_1m1_tables
         !which_atm_option = atm_photosphere_tables
            
   !..set the ranges

	      Teff_max = 50000d0
	      Teff_min = 100d0
	      logg_min = 0d0
	      logg_max = 6.0d0
         
         if (which_atm_option == atm_wd_tau_25_tables) then

   	      Teff_max = 8000d0
   	      Teff_min = 7000d0
   	      logg_min = 7.4d0
   	      logg_max = 8.1d0

   	      Teff_max = 3500d0
   	      Teff_min = 2500d0
   	      logg_min = 7.0d0
   	      logg_max = 9.0d0

            M = 0.8*Msun

            Z = 0.0
            X = 1
            XC = 0
            XN = 0
            XO = 0

         else
            M = Msun
            Z = 0.02
            X = 0.70
            XC = 3.2724592105263235d-03
            XN = 9.5023842105263292d-04
            XO = 8.8218000000000601d-03
         end if
         
         call set_composition

         tau = atm_tau_base(which_atm_option, ierr)
         if (ierr /= 0) then
            if (test_verbosely) write(*,*) 'failed in atm_tau_base'
            stop 1
         end if
         
   !..get the results

         dTeff = (Teff_max - Teff_min)/(Teff_points-1)
         dlogg = (logg_max - logg_min)/(logg_points-1)

         do j=1, Teff_points
            Teff = Teff_min + dTeff*(j-1)
            do i=1,logg_points
               logg = logg_min + dlogg*(i-1)
               call Plot_one( &
                  i, j, Teff, logg, which_atm_option, &
                  output_values, num_vals, logg_points, Teff_points, info)
            end do
         end do
   
         write(*,*) 'write files'
         do k = 1, num_vals
            write(*,*) k
            write(io_first+k-1,'(e24.16)') output_values(1:logg_points,1:Teff_points,k)
         end do

         do i = 1, Teff_points
            Teff = Teff_min + dTeff*(i-1)
            write(io_teff,*) Teff
         end do
         close(io_teff)
      
         do j=1,logg_points
            logg = logg_min + dlogg*(j-1)
            write(io_logg,*) logg
         end do
         close(io_logg)
   
         do io=io_first,io_last
            close(io)
         end do
   
         deallocate(output_values)

      end subroutine Build_Plots


      subroutine Plot_one( &
            i, j, Teff, logg, which_atm_option, &
            output_values, num_vals, logg_points, Teff_points, ierr)
         integer, intent(in) :: i, j, num_vals, logg_points, Teff_points, which_atm_option
         double precision, intent(in) :: Teff, logg
         double precision, intent(out) :: output_values(logg_points,Teff_points,num_vals)
         integer, intent(out) :: ierr

         double precision :: R, L, Teff_out, Pgas, Prad, &
            lnT, dlnT_dL, dlnT_dlnR, dlnT_dlnM, dlnT_dlnkap,  &
            lnP, dlnP_dL, dlnP_dlnR, dlnP_dlnM, dlnP_dlnkap
         integer :: k, off_table_option
         character(len=256) :: option_str
         
         include 'formats.dek'
                     
         ierr = 0
         R = sqrt ( cgrav*M / 10d0**logg )               
         L = pi*crad*clight * R**2 * Teff**4

         !call atm_option_str(which_atm_option, option_str, ierr)
         !if (ierr /= 0) stop 1
         !write(*,*) 'Plot_one: ' // trim(option_str)
         
         if (atm_by_table(which_atm_option)) then
            kap_guess = 0.5d0
            atol = 1d-6
            rtol = 1d-4
            max_tries = 30
            off_table_option = atm_grey_and_kap
            call atm_get_table( &
               which_atm_option, off_table_option, cgrav, M, R, L, &
               lnT, dlnT_dL, dlnT_dlnR, dlnT_dlnM, &
               lnP, dlnP_dL, dlnP_dlnR, dlnP_dlnM, &
               kap_guess, X, Z, abar, zbar, &
               species, chem_id, net_iso, xa, &
               max_tries, atol, rtol, eos_handle, kap_handle, &
               Teff_out, ierr)
            dlnT_dlnkap = 0
            dlnP_dlnkap = 0            
         else
            write(*,*) 'need to add to Plot_one for this option'
            stop 1
         end if
          
         !call atm_get( &
         !   cgrav, M, R, L, X, Z, kap, Teff_out, &
         !   lnT, dlnT_dL, dlnT_dlnR, dlnT_dlnM, dlnT_dlnkap,  &
         !   lnP, dlnP_dL, dlnP_dlnR, dlnP_dlnM, dlnP_dlnkap,  &
         !    which_atm_option, switch_to_grey_as_backup, ierr)
         if (ierr /= 0) then
            write(*,1) 'failed Teff, logg', Teff, logg
         end if
         
         if (is_bad_num(lnP)) then
            write(*,1) 'lnP', lnP
            write(*,1) 'M', M
            write(*,1) 'R', R
            write(*,1) 'L', L
            write(*,1) 'logg', logg
            write(*,1) 'Teff', Teff
            write(*,*) 'Plot_one: ' // trim(option_str)
            stop 'Plot_one'
         end if

         if (ierr == 0) then

            k = 0
            Pgas = exp(lnP) - (crad*exp(lnT)**4)/3
            k = k+1; output_values(i,j,k) = safe_log10(Pgas)
            k = k+1; output_values(i,j,k) = lnP/ln10
            k = k+1; output_values(i,j,k) = lnT/ln10
            k = k+1; output_values(i,j,k) = lnT/ln10 - log10(Teff_out)
            
            k = k+1; output_values(i,j,k) = dlnP_dL
            k = k+1; output_values(i,j,k) = dlnP_dlnR
            k = k+1; output_values(i,j,k) = dlnP_dlnM
            
            k = k+1; output_values(i,j,k) = dlnT_dL
            k = k+1; output_values(i,j,k) = dlnT_dlnR
            k = k+1; output_values(i,j,k) = dlnT_dlnM

            !k = k+1; output_values(i,j,k) = dlnP_dlnkap
            !k = k+1; output_values(i,j,k) = dlnT_dlnkap
         
         end if

      end subroutine Plot_one
      
      
      subroutine Open_Plot_Outfiles(io_first, io_last, io_teff, io_logg, dir)
         integer, intent(IN) :: io_first, io_teff, io_logg
         integer, intent(OUT) :: io_last
         character (len=256), intent(IN) :: dir
         character (len=256) :: fname
         integer :: io
         
         fname = trim(dir) // '/teff.data'
         open(unit=io_teff,file=trim(fname))
         
         fname = trim(dir) // '/logg.data'
         open(unit=io_logg,file=trim(fname))
         
         io = io_first-1
         
         fname = trim(dir) // '/logPgas.data'
         io = io+1; open(unit=io,file=trim(fname))  
         
         fname = trim(dir) // '/logP.data'
         io = io+1; open(unit=io,file=trim(fname))  
         
         fname = trim(dir) // '/logT.data'
         io = io+1; open(unit=io,file=trim(fname))          
         
         fname = trim(dir) // '/logT_sub_logTeff.data'
         io = io+1; open(unit=io,file=trim(fname))          

         fname = trim(dir) // '/dlnP_dL.data'
         io = io+1; open(unit=io,file=trim(fname))
         fname = trim(dir) // '/dlnP_dlnR.data'
         io = io+1; open(unit=io,file=trim(fname))
         fname = trim(dir) // '/dlnP_dlnM.data'
         io = io+1; open(unit=io,file=trim(fname))
         

         fname = trim(dir) // '/dlnT_dL.data'
         io = io+1; open(unit=io,file=trim(fname))
         fname = trim(dir) // '/dlnT_dlnR.data'
         io = io+1; open(unit=io,file=trim(fname))
         fname = trim(dir) // '/dlnT_dlnM.data'
         io = io+1; open(unit=io,file=trim(fname))
         
         !fname = trim(dir) // '/dlnP_dlnkap.data'
         !io = io+1; open(unit=io,file=trim(fname))
         !fname = trim(dir) // '/dlnT_dlnkap.data'
         !io = io+1; open(unit=io,file=trim(fname))

         io_last = io
      
      end subroutine Open_Plot_Outfiles

      
      end module mod_plot_atm
      
      
      program plot_atm
      use mod_plot_atm
      call Build_Plots
      end program plot_atm

