/*
 *  topology_names.cpp
 *
 *  This file is part of NEST.
 *
 *  Copyright (C) 2004 The NEST Initiative
 *
 *  NEST is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  NEST is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with NEST.  If not, see <http://www.gnu.org/licenses/>.
 *
 */

/*
  This file is part of the NEST topology module.
*/

#include "topology_names.h"

namespace nest
{

namespace names
{

const Name allow_autapses( "allow_autapses" );
const Name allow_multapses( "allow_multapses" );
const Name allow_oversized_mask( "allow_oversized_mask" );
const Name anchor( "anchor" );
const Name azimuth_angle( "azimuth_angle" );
const Name box( "box" );
const Name center( "center" );
const Name circular( "circular" );
const Name column( "column" );
const Name columns( "columns" );
const Name connection_type( "connection_type" );
const Name convergent( "convergent" );
const Name cutoff( "cutoff" );
const Name depth( "depth" );
const Name divergent( "divergent" );
const Name edge_wrap( "edge_wrap" );
const Name elements( "elements" );
const Name ellipsoidal( "ellipsoidal" );
const Name elliptical( "elliptical" );
const Name extent( "extent" );
const Name grid( "grid" );
const Name grid3d( "grid3d" );
const Name inner_radius( "inner_radius" );
const Name kappa( "kappa" );
const Name kernel( "kernel" );
const Name layer( "layer" );
const Name layers( "layers" );
const Name lid( "lid" );
const Name lower_left( "lower_left" );
const Name major_axis( "major_axis" );
const Name mask( "mask" );
const Name max( "max" );
const Name mean_x( "mean_x" );
const Name mean_y( "mean_y" );
const Name min( "min" );
const Name minor_axis( "minor_axis" );
const Name number_of_connections( "number_of_connections" );
const Name outer_radius( "outer_radius" );
const Name p_center( "p_center" );
const Name polar_angle( "polar_angle" );
const Name polar_axis( "polar_axis" );
const Name positions( "positions" );
const Name radius( "radius" );
const Name rectangular( "rectangular" );
const Name row( "row" );
const Name rows( "rows" );
const Name sigma_x( "sigma_x" );
const Name sigma_y( "sigma_y" );
const Name sources( "sources" );
const Name spherical( "spherical" );
const Name topology( "topology" );
const Name upper_right( "upper_right" );

} // namespace names

} // namespace nest
