/*
 *  group_models.h
 *
 *  This file is part of NEST.
 *
 *  Copyright (C) 2004 The NEST Initiative
 *
 *  NEST is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  NEST is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with NEST.  If not, see <http://www.gnu.org/licenses/>.
 *
 */
/**
 * This file contains the groups used to organize models in the documentation
 * Every model should be in at least one group (neurons, synapses, devices)
 * And further groups can be included as appropriate.
 * For examples, see the ../models/*.h directory.
 *
 * /
/** @defgroup Devices
 *
 *  This module is for the devices of NEST
 *
 */
/** @defgroup music
 *
 *  This is a subgroup for MUSIC related devices of NEST
 *
 */
/** @defgroup detector
 *
 *  This is a subgroup for detector and recorder type devices of NEST
 *
 */
/** @defgroup generator
 *
 *  This is a subgroup for devices that modify models (generators, dilutor)
 *  of NEST
 */
/** @defgroup Neurons
 *
 * This module is for the neurons of NEST
 *
 */

/** @defgroup rate
 *
 *  This is a subgroup for rate based neurons of NEST
 *
 */

/** @defgroup iaf
 *
 *  This is a subgroup for leaky and generalized
 *  integrate-and-fire neurons of NEST
 *
 */
/** @defgroup binary
 *
 *  This is a subgroup for binary neurons of NEST
 *
 */
/** @defgroup aeif
 *
 *  This is a subgroup for adaptive integrate-and-fire neurons of NEST
 *  (phenomological)
 *
 */
/** @defgroup hh
 *
 *  This is a subgroup for Hodgkin Huxley neurons of NEST
 *
 */
/** @defgroup cond
 *
 *  This is a subgroup for conductance-based neurons of NEST
 *
 */
/** @defgroup pp
 *
 *  This is a subgroup for point process neurons of NEST
 *
 */
/** @defgroup parrot
 *
 *  This is a subgroup for parrot neurons of NEST
 *
 */
/** @defgroup psc
 *
 *  This is a subgroup for current-based neurons of NEST
 *
 */
/** @defgroup ht_neuron
 *
 *  This is a subgroup for Hill Tononi neuron model of NEST
 *
 */

/** @defgroup clopath_n
 *
 * This is a subgroup for Clopath type neurons of NEST
 *
 */
/** @defgroup Synapses
 *
 * This module is for the synapses of NEST
 *
 */

/** @defgroup ht_synapse
 *
 *  This is a subgroup for Hill Tononi synapse model of NEST
 *
 */
/** @defgroup stdp
 *
 *  This is a subgroup for spike-timing dependent plasticity synapse types
 *
 */
/** @defgroup stp
 *
 *  This is a subgroup for short-term plasticty synapses of NEST
 *
 */
/** @defgroup inst_rate
 *
 *  This is a subgroup for instantaneous rate synapse types of NEST
 *
 */
/** @defgroup cont_delay
 *
 *  This is a subgroup for continuous delay  synapse types of NEST
 *
 */
/** @defgroup static
 *
 *  This is a subgroup for static synapse types of NEST
 *
 */
/** @defgroup gap
 *
 *  This is a subgroup for gap junctions types of NEST
 *  Including neurons that explictly support gap jucntions
 *
 */
/** @defgroup clopath_s
 *
 * This is a subgroup for Clopath type synapses of NEST
 *
 */
