# plot_by_name.rb

class Plot_by_Name_Data

    include Math
    include Tioga
    
    attr_accessor :info, :values, :mesh, :names, :num_values
    

    def initialize(names_filename, data_filename)
    
        read_names(names_filename)
        @num_values=@names.size
        @values = Array.new(@num_values) { |i| Dvector.new }
        Dvector.read(data_filename, @values)
        @mesh = Dvector.new(@values[0].size) { |i| i+1 }

    end    
    
    def read_names(names_filename)
        
        f = File.open(names_filename)
        @names = []
        100.times {|i| 
            begin
                namestr = f.readline
            rescue
                namestr = ''
            end
            break if namestr.size == 0
            puts namestr
            @names << namestr[0..-2]
        }
        f.close
        
    end
    
end # Plot_by_Name_Data


class Plot_by_Name

    include Math
    include Tioga
    include FigureConstants
    
    def t
        @figure_maker
    end

    def d
        @data
    end


    def initialize(by_mesh = false, xlbl = nil, data_dir = 'plot_data', rtol = 1e-4,
            first = 0, last = -1, names_file = 'names.data', test_file = 'test.data')

        @rtol = rtol
        @atol = rtol
        
        @figure_maker = FigureMaker.default
        t.save_dir = 'plot_out'
        t.def_eval_function { |str| eval(str) }
        t.tex_preview_preamble += "\n\\include{color_names}\n"
        #t.landscape
        
        t.def_enter_page_function { enter_page }
        
        @data = Plot_by_Name_Data.new(data_dir + '/' + names_file, data_dir + '/' + test_file)
        
        @first_pt = first
        @last_pt = last

        set_plotting_info
        @xlabel = xlbl
        @xlabel = 'mesh point' if @xlabel == nil and by_mesh == true
        @xlabel = d.names[0] if @xlabel == nil and by_mesh != true
        
        if by_mesh
            
            @num_plots.times { |i|
                eval(sprintf("t.def_figure(\"%s\") { plot_by_mesh %i }", @plot_info[i][0], i))
            }
        
        else
            
            (@num_plots-1).times { |i|
                eval(sprintf("t.def_figure(\"%s\") { plot_by_x %i }", @plot_info[i+1][0], i+1))
            }
           
        end

    end  
    
    
    def enter_page
        t.page_setup(11*72,8.5*72)
        t.set_frame_sides(0.15,0.85,0.85,0.15) # left, right, top, bottom in page coords   
        t.rescale(2)     
        t.rescale_lines(1.5)
    end
    
    
    def get_min_max_for_plot(n)
        ys = d.values[n][@first_pt..@last_pt]
        ymin = ys.min
        ymax = ys.max
        dy = ymax - ymin
        ytol = [ymin.abs, ymax.abs].max
        dy = @atol if dy < ytol * @rtol + @atol
        ymargin = 0.02
        @plot_ymax = ymax + ymargin * dy
        @plot_ymin = ymin - ymargin * dy
    end

    
    def set_plotting_info # for each of the results
        
        @num_plots = d.num_values
        @plot_info = Array.new(@num_plots)
        
        @num_plots.times {|i|
            get_min_max_for_plot(i)
            @plot_info[i] = [d.names[i], @plot_ymin, @plot_ymax]
        }
        
    end


    def plot_by_mesh(n)
        plot_results(n, d.mesh[@first_pt..@last_pt], d.values[n][@first_pt..@last_pt], @xlabel, false)
    end

    def plot_by_x(n)
        plot_results(n, d.values[0][@first_pt..@last_pt], d.values[n][@first_pt..@last_pt], @xlabel, false)
    end
    
    
    def plot_results(n, xs, ys, xlabel, xreversed)

        plt = @plot_info[n]
        title = plt[0].tr("_", " ")
        t.show_title(title)
        t.show_xlabel(xlabel.tr("_", " "))
        ymin  = plt[1]
        ymax  = plt[2]
        xmargin = 0.07
        ymargin = 0.1
        if xreversed
            xmin = xs.min; xmax = xs.max
            width = (xmax == xmin)? 1 : xmax - xmin
            left_boundary = xmax + xmargin * width
            right_boundary = xmin - xmargin * width
        else
            xmin = xs.min; xmax = xs.max
            width = (xmax == xmin)? 1 : xmax - xmin
            left_boundary = xmin - xmargin * width
            right_boundary = xmax + xmargin * width
        end
        height = (ymax == ymin)? 1 : ymax - ymin
        top_boundary = ymax + ymargin * height
        bottom_boundary = ymin - ymargin * height
        boundaries = [ left_boundary, right_boundary, top_boundary, bottom_boundary ]
        t.show_plot(boundaries) {
            t.show_polyline(xs,ys,BrightBlue)
        }
        show_footer
        
    end
    
    
    def show_footer
    end
        
        
    def background
        t.fill_color = FloralWhite
        t.fill_frame
    end

end
