class Plot_by_Name

    def setup(dict)
        
        @first_abundance_column = dict['first_abundance_column']
        @title = dict['title']
        @log_mass_frac_ymax = dict['log_mass_frac_ymax']
        @log_mass_frac_ymin = dict['log_mass_frac_ymin']
        @log_ergs_ymax = dict['log_ergs_ymax']
        @log_ergs_ymin = dict['log_ergs_ymin']
        @num_abundance_line_labels = dict['num_abundance_line_labels']        
        
        @show_net_burn = false
                
        @net_burn_data = Plot_by_Name_Data.new(
          data_dir + '/net_burn.names', 
          data_dir + '/net_burn.data', 
          lines_before_real_data, 
          strictly_increasing) if @show_net_burn

        add_extras(dict) if defined?(add_extras)

    end 
    
    def define_figures(dict)
        t.def_figure("burn") { plot_burn }
    end

    
    def plot_burn
        
        do_eps = true

        t.rescale(0.75)
        t.ylabel_shift = 1.4
        if do_eps
            t.set_subframe('right_margin' => 0.3, 'top_margin' => 0.1, 'bottom_margin' => 0.1)
        else
            t.set_subframe('right_margin' => 0.1, 'top_margin' => 0.1, 'bottom_margin' => 0.1)
        end
        xs = get_xs_for_plot
        title = @title
        t.show_title(title) unless title == 'HE4'
        if @xaxis_label == 'lg_age'
            xlabel = 'log age (years)'
        elsif @xaxis_label == 'lg_time'
            xlabel = 'log age (seconds)'
        else
            xlabel = @xaxis_label.tr("_", " ")
        end 
        t.show_xlabel(xlabel)
        t.legend_text_dy = 1        
        ymin = @log_mass_frac_ymin
        if ymin == nil
            ymin = -8.1
        end 
        ymax = @log_mass_frac_ymax
        if ymax == nil
            if ymin < -8
                ymax = 0.8
            else
                ymax = 0.25
            end
        end
        
        xleft = xs[0]
        xright = xs[-1]
        
        xleft = @xmin unless @xmin == nil
        xright = @xmax unless @xmax == nil
        
        @xleft = xleft
        @xright = xright

        first_abundance = @first_abundance_column
        
        t.subplot {
            t.yaxis_loc = t.ylabel_side = LEFT
            t.right_edge_type = AXIS_HIDDEN if do_eps
            t.show_plot('left_boundary' => xleft, 'right_boundary' => xright,
                'top_boundary' => ymax, 'bottom_boundary' => ymin) do
                ylabel = 'log mass fraction'
                t.show_ylabel(ylabel)
                cnt = 1 # reserve 0 for eps nuc
                d.num_values.times { |i|
                   unless d.names[i] == 'ye' || d.names[i] == 'xsum_sub_1' || i < first_abundance
                        puts "#{d.names[i]}"
                        cnt = plot_abundance_line(cnt, xs, d.values[i][@first_pt..@last_pt], d.names[i])
                   end
                }
                if title == 'HE4'
                  xpos = 1.7; ypos = -0.5; dypos = -0.3; scale = 0.7
                  t.show_label(
                      'x' => xpos, 'y' => ypos, 'justification' => LEFT_JUSTIFIED,
                      'text' => '0.98 He4, 0.02 N14', 'scale' => scale, 'alignment' => ALIGNED_AT_BASELINE)
                  ypos += dypos
                  t.show_label(
                      'x' => xpos, 'y' => ypos,  'justification' => LEFT_JUSTIFIED,
                      'text' => 'logRho = 4.0', 'scale' => scale, 'alignment' => ALIGNED_AT_BASELINE)
                  ypos += dypos
                  t.show_label(
                      'x' => xpos, 'y' => ypos,  'justification' => LEFT_JUSTIFIED,
                      'text' => 'logT = 8.1', 'scale' => scale, 'alignment' => ALIGNED_AT_BASELINE)
                end
            end
        }
        
        return unless do_eps
        
        t.subplot do  # ergs per gm
            i = d.names.index('lg_ergs_nuc')
            t.yaxis_loc = t.ylabel_side = RIGHT
            t.left_edge_type = AXIS_HIDDEN
            ys = d.values[i][@first_pt..@last_pt]                       
            ymax = @log_ergs_ymax
            ymin = @log_ergs_ymin
            t.show_plot('left_boundary' => xleft, 'right_boundary' => xright,
                'top_boundary' => ymax, 'bottom_boundary' => ymin) do
                ylabel = 'log total ergs gm^{-1}'
                t.show_ylabel(ylabel)
                plot_abundance_line(-1, xs, ys, 'lg_ergs')
            end
        end
    end

    
    
    def plot_abundance_line(cnt, xs, ys, label)
        show_lim = -50
        return cnt if ys == nil
        return cnt unless ys.max > show_lim
        #ys = ys_in.safe_log10
        txt = nil
        txt = label if @legend_abundance_lines == true || @doing_multiple != true
        
        colors = [ BrightBlue, Goldenrod, Coral, FireBrick, RoyalPurple, Lilac ]
        num_colors = colors.length
        patterns = [ Line_Type_Solid, Line_Type_Dash, Line_Type_Dot, Line_Type_Dot_Dash, Line_Type_Dot_Long_Dash ]
        num_patterns = patterns.length
        
        color = colors[cnt - num_colors*(cnt/num_colors)]
        pattern = Line_Type_Solid #patterns[cnt/num_colors]
        if cnt < 0
            color = Crimson
            pattern = Line_Type_Solid
        end
        
        if true
        #puts "show jina burn " + label
        t.line_width = 0.7
        #color = Black
        #pattern = Line_Type_Solid
        t.show_polyline(xs, ys, color, txt, pattern)
        t.show_marker('xs' => xs, 'ys' => ys, 'marker' => Bullet,
            'color' => color, 'scale' => 0.4) if @show_points
        end

         if @show_net_burn
            d1 = @net_burn_data
            i = d1.names.index(label)
            unless i == nil
               xname = d.names[@xaxis_column-1]
               puts "xname #{xname}"
               iname = d1.names.index(xname)
               puts "iname #{iname}"
               xs1 = d1.values[iname]
               ys1 = d1.values[i]
               t.line_width = 1.5
               color = Black
               pattern = Line_Type_Dot
               t.show_polyline(xs1, ys1, color, txt, pattern)
            end
         end
        
        return cnt+1 unless @num_abundance_line_labels > 0
        
        xwidth = @xright - @xleft
        n = @num_abundance_line_labels
        dx = xwidth.to_f/n

        xs_reversed = xs.reverse # need to reverse for use with linear_interpolate
        ys_reversed = ys.reverse
        dy = t.default_text_height_dy*0.2
        n.times do |j|
            x = @xleft + dx*(j+0.5)
            y = Dvector.linear_interpolate(x, xs_reversed, ys_reversed) + dy
            scale = 0.9
            if label == 'ye'
                txt = label
            elsif label == 'eps'
                txt = '$\epsilon_{nuc}$'
                scale = 0.9
            else
                txt = label[3,label.length]
                txt = '$\epsilon_{nuc}$' if txt == 'eps_nuc'
                txt = '$error$' if txt == 'abs_1_sub_sum_x'
            end
            #next if x > 2 && x < 8 && txt != 'o18'
            #next if txt == 'o18' && x > 3
            t.show_label(
                'x' => x, 'y' => y, 
                'text' => txt, 'scale' => scale, 'alignment' => ALIGNED_AT_BASELINE)
                #'text' => label, 'scale' => 0.6, 'alignment' => ALIGNED_AT_BASELINE)
        end
        return cnt+1
    end 


end
