! ***********************************************************************
!
!   Copyright (C) 2010  Bill Paxton
!
!   this file is part of mesa.
!
!   mesa is free software; you can redistribute it and/or modify
!   it under the terms of the gnu general library public license as published
!   by the free software foundation; either version 2 of the license, or
!   (at your option) any later version.
!
!   mesa is distributed in the hope that it will be useful, 
!   but without any warranty; without even the implied warranty of
!   merchantability or fitness for a particular purpose.  see the
!   gnu library general public license for more details.
!
!   you should have received a copy of the gnu library general public license
!   along with this software; if not, write to the free software
!   foundation, inc., 59 temple place, suite 330, boston, ma 02111-1307 usa
!
! ***********************************************************************
 
      module run_star_extras ! for rlo

      use star_lib
      use star_def
      use const_def
      use const_def
      use chem_def
      use num_lib,only:safe_log10
      
      implicit none
      
      integer :: time0, time1, clock_rate
      double precision, parameter :: expected_runtime = 5 ! minutes
      
      integer, parameter :: rlo_extra_log_columns = 24


      include 'rlo_data.dek'
      
      
      contains


      include 'rlo_routines.dek' 
      
      
      subroutine extras_controls(s, ierr)
         type (star_info), pointer :: s
         integer, intent(out) :: ierr
         ierr = 0
         !write(*,*) 'extras_controls'
         call rlo_controls(s,ierr)
         doing_binary_rlo = .false.
      end subroutine extras_controls
      
      
      integer function extras_startup(s, id, restart, ierr)
         type (star_info), pointer :: s
         integer, intent(in) :: id
         logical, intent(in) :: restart
         integer, intent(out) :: ierr
         !write(*,*) 'extras_startup'
         ierr = 0
         extras_startup = 0
         call system_clock(time0,clock_rate)
         if (.not. restart) then
            call alloc_rlo_info(s)
            mass_change_prev = 0
            sum_div_qloc_prev = 0
         else ! it is a restart
            call unpack_rlo_info(s)
            s% mass_change = mass_change_prev
            s% max_timestep = max_timestep_prev
         end if
      end function extras_startup
      

      ! returns either keep_going, retry, backup, or terminate.
      integer function extras_check_model(s, id, id_extra)
         type (star_info), pointer :: s
         integer, intent(in) :: id, id_extra
         extras_check_model = rlo_check_model(id,s)         
      end function extras_check_model


      integer function how_many_extra_log_columns(s, id, id_extra)
         type (star_info), pointer :: s
         integer, intent(in) :: id, id_extra
         how_many_extra_log_columns = rlo_extra_log_columns
      end function how_many_extra_log_columns
      
      
      subroutine data_for_extra_log_columns(s, id, id_extra, n, names, vals, ierr)
         type (star_info), pointer :: s
         integer, intent(in) :: id, id_extra, n
         character (len=maxlen_log_column_name) :: names(n)
         double precision :: vals(n)
         integer, intent(out) :: ierr
         integer :: i
         double precision :: Lmdot
         ierr = 0
         if (n /= rlo_extra_log_columns) then
            stop 'bad value for n in data_for_extra_log_columns'
         end if
         Lmdot = 6d32*abs(s% mass_change)/1d-11 ! ergs s^-1
         i = 0
         i=i+1; names(i) = 'period_days'; vals(i) = binary_period/(60d0*60d0*24d0)
         i=i+1; names(i) = 'period_hr'; vals(i) = binary_period/(60d0*60d0)
         i=i+1; names(i) = 'period_minutes'; vals(i) = binary_period/60d0         
         i=i+1; names(i) = 'lg_separation'; vals(i) = safe_log10(binary_separation)
         i=i+1; names(i) = 'binary_separation'; vals(i) = binary_separation/Rsun
         i=i+1; names(i) = 'rl_donor'; vals(i) = rl/Rsun
         i=i+1; names(i) = 'rl_accretor'; vals(i) = (binary_separation-rl)/Rsun
         i=i+1; names(i) = 'rl_overflow'; vals(i) = (r-rl)/Rsun
         i=i+1; names(i) = 'rl_relative_overflow'; vals(i) = (r-rl)/rl
         i=i+1; names(i) = 'donor_mass'; vals(i) = s% star_mass
         i=i+1; names(i) = 'lg_donor_mass'; vals(i) = safe_log10(s% star_mass)
         i=i+1; names(i) = 'companion_mass'; vals(i) = companion_mass
         i=i+1; names(i) = 'lg_companion_mass'; vals(i) = safe_log10(companion_mass)
         i=i+1; names(i) = 'sum_of_masses'; vals(i) = s% star_mass + companion_mass
         i=i+1; names(i) = 'donor_div_companion_mass'; vals(i) = s% star_mass / companion_mass
         i=i+1; names(i) = 'delta_companion_mass'; vals(i) = companion_mass - initial_companion_mass
         i=i+1; names(i) = 'lg_F_irr'; vals(i) = safe_log10(s% irradiation_flux)
         i=i+1; names(i) = 'xfer_fraction'; vals(i) = xfer_fraction_prev
         i=i+1; names(i) = 'log_J'; vals(i) = safe_log10(angular_momentum_j)
         i=i+1; names(i) = 'log_abs_Jdot'; vals(i) = safe_log10(abs(j_dot))
         i=i+1; names(i) = 'log_abs_jdot_mb'; vals(i) = safe_log10(abs(j_dot_mb))
         i=i+1; names(i) = 'log_abs_jdot_gr'; vals(i) = safe_log10(abs(j_dot_gr))
         i=i+1; names(i) = 'log_abs_jdot_ml'; vals(i) = safe_log10(abs(j_dot_ml))
         i=i+1; names(i) = 'log_abs_jdot_tide'; vals(i) = safe_log10(abs(j_dot_tide))
         if (i /= rlo_extra_log_columns) then
            stop 'bad value for i in data_for_extra_log_columns'
         end if
      end subroutine data_for_extra_log_columns

      
      integer function how_many_extra_profile_columns(s, id, id_extra)
         type (star_info), pointer :: s
         integer, intent(in) :: id, id_extra
         how_many_extra_profile_columns = 0
      end function how_many_extra_profile_columns
      
      
      subroutine data_for_extra_profile_columns(s, id, id_extra, n, nz, names, vals, ierr)
         type (star_info), pointer :: s
         integer, intent(in) :: id, id_extra, n, nz
         character (len=maxlen_profile_column_name) :: names(n)
         double precision :: vals(nz,n)
         integer, intent(out) :: ierr
         integer :: k
         ierr = 0
      end subroutine data_for_extra_profile_columns
      

      ! returns either keep_going, retry, backup, or terminate.
      integer function extras_finish_step(s, id, id_extra)
         type (star_info), pointer :: s
         integer, intent(in) :: id, id_extra
         ! save rlo data in s% extra_iwork and s% extra_work
         ! before calling star_finish_step
         call store_rlo_info(s)
         extras_finish_step = keep_going
      end function extras_finish_step
      
      
      subroutine extras_after_evolve(s, id, id_extra, ierr)
         type (star_info), pointer :: s
         integer, intent(in) :: id, id_extra
         integer, intent(out) :: ierr
         double precision :: dt
         ierr = 0
         call system_clock(time1,clock_rate)
         dt = dble(time1 - time0) / clock_rate / 60
         if (dt > 10*expected_runtime) then
            write(*,'(/,a30,2f18.6,a,/)') '>>>>>>> EXCESSIVE runtime', &
               dt, expected_runtime, '   <<<<<<<<<  ERROR'
         else
            write(*,'(/,a30,2f18.6,2i10/)') 'runtime (minutes), retries, backups', &
               dt, expected_runtime, s% num_retries, s% num_backups
         end if
      end subroutine extras_after_evolve


      end module run_star_extras
      
