# plots.rb

require 'Tioga/FigureMaker'

class Plots

    include Math
    include Tioga
    include FigureConstants


    class Profile_data
    
        attr_accessor :mass, :radius, :density, :temperature, :pgas, :energy
        attr_accessor :logRho, :logT, :logPgas, :logE
        attr_accessor :logQ, :logW, :logV, :logB
        
        def initialize(filename)
        
            ar = [
                @mass = Dvector.new,
                @radius = Dvector.new,
                @density = Dvector.new,
                @temperature = Dvector.new,
                @pgas = Dvector.new,
                @energy = Dvector.new
                ]
            Dvector.read(filename, ar, 4) # data starts on line 4
            
            @logRho = @density.safe_log10
            @logT = @temperature.safe_log10
            @logPgas = @pgas.safe_log10
            @logE = @energy.safe_log10
            
            @logQ = @logRho - 2*@logT + 12
            @logW = @logPgas - 4*@logT
            @logV = @logRho - 3*@logE + 45
            @logB = @logRho - 0.7*@logPgas + 10
                        
        end
        
    end
    
    def t
        @figure_maker
    end

    def initialize
        @figure_maker = FigureMaker.default

        t.save_dir = 'plots_out'
        t.def_eval_function { |str| eval(str) }
        
        @p = []
        @clrs = []
        @lbls = []
        i = -1
        i = i+1; load_profile(i, 'zams_150.00_plot.data', Blue, '150')
        #i = i+1; load_profile(i, 'zams_100.00_plot.data', Blue, '100')
        i = i+1; load_profile(i, 'zams_10.00_plot.data', Blue, '10')
        i = i+1; load_profile(i, 'zams_1.00_plot.data', Blue, '1')
        i = i+1; load_profile(i, 'zams_0.10_plot.data', Blue, '0.1')
        i = i+1; load_profile(i, 'zams_0.01_plot.data', Blue, '0.01')
        i = i+1; load_profile(i, 'zams_0.001_plot.data', Blue, '0.001')
        @num_profiles = i+1
        
        t.def_figure("RhoT") { profiles_RhoT }
        t.def_figure("QT") { profiles_QT }
        
        t.def_figure("PgasT") { profiles_PgasT }
        t.def_figure("WT") { profiles_WT }
        
        t.def_figure("RhoE") { profiles_RhoE }
        t.def_figure("VRho") { profiles_VRho }
        
        t.def_figure("PgasRho") { profiles_PgasRho }
        t.def_figure("BRho") { profiles_BRho }
        
        t.def_enter_page_function { enter_page }

        # Uncomment the followiing line if you want tioga to leave
        # its temporary files behind.
        t.autocleanup = false
        
        @margin = 0.1
            
    end
    
    
    def load_profile(i, fname, clr, lbl)
        fyi = ''
        @p[i] = Profile_data.new(fyi + fname)
        @clrs[i] = clr
        @lbls[i] = lbl
    end
    
    
    def enter_page
        t.yaxis_numeric_label_angle = -90
        t.page_setup(11*72/2,8.5*72/2)
        t.set_frame_sides(0.15,0.85,0.85,0.15) # left, right, top, bottom in page coords  
    end
    
    
    
    def boundaries(
          xary,yary,margin,ymin=nil,ymax=nil,reverse_xaxis=false,reverse_yaxis=false)
          
        xmin = Dvector.min_of_many(xary)
        xmax = Dvector.max_of_many(xary)
        
        ymin = Dvector.min_of_many(yary) if ymin == nil
        ymax = Dvector.max_of_many(yary) if ymax == nil
        
        width = (xmax == xmin)? 1 : xmax - xmin
        height = (ymax == ymin)? 1 : ymax - ymin
        left_boundary = xmin - margin * width
        right_boundary = xmax + margin * width
        top_boundary = ymax + margin * height
        bottom_boundary = ymin - margin * height
        
        if reverse_xaxis
           tmp = left_boundary; left_boundary = right_boundary; right_boundary = tmp
        end
        if reverse_yaxis
           tmp = top_boundary; top_boundary = bottom_boundary; bottom_boundary = tmp
        end
        
        return [ left_boundary, right_boundary, top_boundary, bottom_boundary ]
        
    end
    

    
    def profiles(xary,yary,clrs,lbls,xlabel,ylabel)
      t.do_box_labels('Profiles', xlabel, ylabel)
      dx = 3*t.default_text_height_dx
      dy = 0.4*t.default_text_height_dy
      t.show_plot(boundaries(xary,yary,@margin)) do
        xary.length.times do |i|
          t.show_polyline(xary[i],yary[i],clrs[i],lbls[i])
          t.show_label('text' => lbls[i], 'x' => xary[i][0] - 0*dx, 'y' => yary[i][0] - 8*dy,
            'color' => Black,
            'scale' => 0.8, 
            'justification' => CENTERED, 
            'alignment' => ALIGNED_AT_MIDHEIGHT)
        end
      end
    end
    
    
    def logRho
      ary = []
      @num_profiles.times { |i| ary << @p[i].logRho }
      ary
    end
    
    
    def logPgas
      ary = []
      @num_profiles.times { |i| ary << @p[i].logPgas }
      ary
    end
    
    
    def logT
      ary = []
      @num_profiles.times { |i| ary << @p[i].logT }
      ary
    end
    
    
    def logE
      ary = []
      @num_profiles.times { |i| ary << @p[i].logE }
      ary
    end
    
    
    def logQ
      ary = []
      @num_profiles.times { |i| ary << @p[i].logQ }
      ary
    end
    
    
    def logW
      ary = []
      @num_profiles.times { |i| ary << @p[i].logW }
      ary
    end
    
    
    def logV
      ary = []
      @num_profiles.times { |i| ary << @p[i].logV }
      ary
    end
    
    
    def logB
      ary = []
      @num_profiles.times { |i| ary << @p[i].logB }
      ary
    end
    
    
    def profiles_RhoT
      profiles(logRho,logT,@clrs,@lbls,'logRho','logT')
    end
    
    
    def profiles_PgasT
      profiles(logPgas,logT,@clrs,@lbls,'logPgas','logT')
    end
    
    
    def profiles_QT
      profiles(logQ,logT,@clrs,@lbls,'logQ = logRho - 2*logT + 12','logT')
    end
    
    
    def profiles_WT
      profiles(logW,logT,@clrs,@lbls,'logW = logPgas - 4*logT','logT')
    end
    
    
    def profiles_RhoE
      profiles(logRho,logE,@clrs,@lbls,'logRho','logE')
    end
    
    
    def profiles_VRho
      profiles(logV,logRho,@clrs,@lbls,'logV = logRho - 3*logE + 45','logRho')
    end
    
    
    def profiles_PgasRho
      profiles(logPgas,logRho,@clrs,@lbls,'logPgas','logRho')
    end
    
    
    def profiles_BRho
      profiles(logB,logRho,@clrs,@lbls,'logB = logRho - 0.7*logPgas + 10','logRho')
    end
    
    

end


Plots.new
