# trho_plots.rb
       
    
class Clipdata
  attr_accessor :log_rho, :log_T
  def initialize(filename)
      Dvector.read(filename, [@log_rho = Dvector.new, @log_T = Dvector.new])
  end
end

    
class Ignition_data
   include Tioga
   attr_accessor :log_rho, :log_T
   def initialize(filename)
      Dvector.read(filename, [@log_rho = Dvector.new, @log_T = Dvector.new])
   end
end



class ProfilePlots

    include Math
    include Tioga
    include FigureConstants
    include Image_plot
    
    
    def burning_lines
        
        # the data shows where the net burn minus all neutrino losses reaches 1 erg/g/s
        # this includes non-nuclear neutrinos, but those really only matter for carbon

        xs = @psi4[0]
        ys = @psi4[1]
        t.line_width = 0.3
        t.show_polyline(xs, ys, SlateGray, nil, Line_Type_Solid)
        t.show_label('text' => '${\epsilon}_F/{k T}$=4', 'x' => 6.8, 'y' => 9.5,
            'color' => Black, 
            'scale' => 0.8, 'justification' => LEFT_JUSTIFIED, 'alignment' => ALIGNED_AT_TOP)
        
        dx = 0.9*t.default_text_height_dx
        dy = 0.3*t.default_text_height_dy
        t.line_width = 1.3
        
        # hydrogen burning
        xs = @hydrogen_burn.log_rho
        ys = @hydrogen_burn.log_T
        t.show_polyline(xs, ys, Black, nil, Line_Type_Dash)
        
        # helium burning
        xs = Dvector[ 1.9,  3.0,  4.0,  5.0, 6.0, 6.2, 6.4, 6.8, 7.6, 8.2, 8.4, 8.5, 8.6]
        ys = Dvector[8.25, 8.21, 8.14, 8.03, 7.9, 7.9, 7.85, 7.8, 7.7, 7.6, 7.5, 7.4, 7.1]
        xs = @helium_burn.log_rho
        ys = @helium_burn.log_T
        t.show_polyline(xs, ys, Black, nil, Line_Type_Dash)
        
        # carbon burning
        xs = @carbon_burn.log_rho
        ys = @carbon_burn.log_T
        t.show_polyline(xs, ys, Black, nil, Line_Type_Dash)

        # oxygen burning
        xs = @oxygen_burn.log_rho
        ys = @oxygen_burn.log_T
        t.show_polyline(xs, ys, Black, nil, Line_Type_Dash)

        x0 = -2
        y0 = 7.25
        t.show_label('text' => 'Hydrogen burning', 'x' => x0 - 1.05, 'y' => y0+0.7*dy,
            'color' => Black,
            'scale' => 0.6, 'justification' => RIGHT_JUSTIFIED, 
            'alignment' => ALIGNED_AT_BASELINE)
        t.show_label('text' => 'Helium burning', 'x' => x0 + 1.6, 'y' => y0 + 0.97,
            'color' => Black,
            'scale' => 0.6, 'justification' => RIGHT_JUSTIFIED, 
            'alignment' => ALIGNED_AT_BASELINE)
        t.show_label('text' => 'Carbon burning', 'x' => x0 + 3.3 + -0.2*dx, 'y' => y0+1.5,
            'color' => Black,
            'scale' => 0.6, 'justification' => RIGHT_JUSTIFIED, 
            'alignment' => ALIGNED_AT_BASELINE)
        t.show_label('text' => 'Oxygen burning', 'x' => 2.2, 'y' => 9.1,
            'color' => Black,
            'scale' => 0.6, 'justification' => RIGHT_JUSTIFIED, 
            'alignment' => ALIGNED_AT_BASELINE)

        #return

    end
    
    def show_section(first_i, last_i, state)
        if first_i == last_i
            if last_i == d.logRho.size
                first_i = last_i - 1
            else
                last_i += 1
            end
        end
        logRho = d.logRho[first_i..last_i]
        logT = d.logT[first_i..last_i]
        if state == 0
            t.line_type = Line_Type_Solid
            t.line_width = 3
            t.show_polyline(logRho, logT, RoyalPurple)
            t.line_width = 1.5
            t.show_polyline(logRho, logT, Teal)
        elsif state == 1
            t.line_type = Line_Type_Solid
            t.line_width = 3.25
            t.show_polyline(logRho, logT, RoyalPurple)
            t.line_width = 2.0
            t.show_polyline(logRho, logT, Gold)
        else
            t.line_type = Line_Type_Solid
            t.line_width = 3.5
            t.show_polyline(logRho, logT, RoyalPurple)
            t.line_width = 2.5
            t.show_polyline(logRho, logT, Crimson)
        end
    end
    
    def eos_info_pair(text, val, x_num, y)
        x_text = x_num - 1.8
        t.show_text('text' => text,
                'x' => x_text, 'y' => y, 'justification' => RIGHT_JUSTIFIED)
        t.show_text('text' => '{\sffamily ' + sprintf('%0.4f',val) + '}',
                'x' => x_num, 'y' => y, 'justification' => RIGHT_JUSTIFIED)
    end

    def add_eos_info
        t.context do
            t.rescale(0.6)
            xloc = 9; y = 5.1; dy = -t.default_text_height_dy * 1.1
            eos_info_pair('$ M/M_{\odot} $', d.star_mass, xloc, y); y += dy;
            eos_info_pair('$ \log R/R_{\odot} $', d.radius[d.surface_shell].safe_log10, xloc, y); y += dy;
            eos_info_pair('$ \log L/L_{\odot} $', d.photosphere_L.log10, xloc, y); y += dy;
            eos_info_pair('$ \log L_{H}/L_{\odot} $', d.power_h_burn.safe_log10, xloc, y); y += dy;
            eos_info_pair('$ \log L_{He}/L_{\odot} $', d.power_he_burn.safe_log10, xloc, y); y += dy;
            if d.h1_boundary_mass > 0
               eos_info_pair('H boundary', d.h1_boundary_mass, xloc, y)
               y += dy
            end
            if d.he4_boundary_mass > 0
               eos_info_pair('He boundary', d.he4_boundary_mass, xloc, y)
               y += dy
            end 
            if d.c12_boundary_mass > 0
               eos_info_pair('C boundary', d.c12_boundary_mass, xloc, y)
               y += dy
            end 
            
            xloc = 4.2; y = y-2*dy
            #eos_info_pair('$ initial M/M_{\odot} $', d.initial_mass, xloc, y); y += dy;
            #eos_info_pair('$ initial Z $', d.initial_z, xloc, y); y += dy;
        end
    end
    
    def add_eos_legend
        add_eos_info
        x1 = -9.2; x2 = x1+1; x3 = x2+0.6
        dy = -0.07
        yshift = 0.4
        y1 = 8.7+yshift; y2 = y1 + dy
        t.line_type = Line_Type_Solid
        t.line_width = 5
        t.stroke_color = RoyalPurple
        t.stroke_line(x1, y1, x2, y1)
        t.line_width = 3
        t.stroke_color = Gold
        t.stroke_line(x1, y1, x2, y1)
        t.show_text('text' => 'over 1 erg/g/s', 'at' => [x3, y2],
            'scale' => 0.66, 'justification' => LEFT_JUSTIFIED)
        y1 = 9.0+yshift; y2 = y1 + dy
        t.line_type = Line_Type_Solid
        t.line_width = 6
        t.stroke_color = RoyalPurple
        t.stroke_line(x1, y1, x2, y1)
        t.line_width = 4
        t.stroke_color = Crimson
        t.stroke_line(x1, y1, x2, y1)
        t.show_text('text' => 'over 1000 erg/g/s', 'at' => [x3, y2],
            'scale' => 0.66, 'justification' => LEFT_JUSTIFIED)
        dy = -0.09
        y1 = 8.2+yshift; y2 = y1 + dy
        xdot = 0.5*(x1+x2)
        draw_mass_spot(xdot, y1, @mass_50_color)
        t.show_text('text' => '50\% $ M_{tot} $', 'at' => [x3, y2],
            'scale' => 0.66, 'justification' => LEFT_JUSTIFIED)
        y1 = 7.9+yshift; y2 = y1 + dy
        draw_mass_spot(xdot, y1, @mass_95_color)
        t.show_text('text' => '95\%', 'at' => [x3, y2],
            'scale' => 0.66, 'justification' => LEFT_JUSTIFIED)
        y1 = 7.6+yshift; y2 = y1 + dy
        draw_mass_spot(xdot, y1, @mass_999_color)
        t.show_text('text' => '99.9\%', 'at' => [x3, y2],
            'scale' => 0.66, 'justification' => LEFT_JUSTIFIED)
        y1 = 7.3+yshift; y2 = y1 + dy
        
        if @show_tau10
          draw_mass_spot(xdot, y1, Teal)
          t.show_text('text' => '$\tau = 10$', 'at' => [x3, y2],
              'scale' => 0.66, 'justification' => LEFT_JUSTIFIED)
        elsif @show_tau100
          draw_mass_spot(xdot, y1, Crimson)
          t.show_text('text' => '$\tau = 100$', 'at' => [x3, y2],
              'scale' => 0.66, 'justification' => LEFT_JUSTIFIED)
        end

        y1 = 7.0+yshift; y2 = y1 + dy
        if @eta_color != nil && d.eta.max > 0
          draw_mass_spot(xdot, y1, @eta_color)
          t.show_text('text' => '$\eta = 0$', 'at' => [x3, y2],
              'scale' => 0.66, 'justification' => LEFT_JUSTIFIED)
        end
    end
    
    def show_star(which_state)
        eps = d.eps_nuc # nuclear energy generation rate (erg/g/s)
        start_i = 0
        old_state = 0
        eps.each_index do |i|
            rate = eps[i]
            if rate < 1
                new_state = 0
            elsif rate < 1000
                new_state = 1
            else
                new_state = 2
            end
            if i == 0
                old_state = new_state
                start_i = i
            elsif new_state != old_state
                show_section(start_i, i, old_state) if old_state == which_state && i - start_i > 2
                old_state = new_state
                start_i = i
            end
        end
        show_section(start_i, eps.size-1, old_state) if old_state == which_state
    end
    
    def draw_mass_spot(x, y, color)
        t.show_marker('x' => x, 'y' => y, 'mode' => FILL_AND_STROKE, 'stroke_width' => 0.7,
            'marker' => Bullet, 'scale' => 0.8, 'stroke_color' => Black, 'fill_color' => color);
    end
    
    def find0(xx1,yy1,xx2,yy2)
        # returns x where y is 0 on line connecting the points (xx1,yy1) and (xx2,yy2)
        a = (xx1*yy2)-(xx2*yy1)
        b = yy2-yy1
        if ((a.abs > b.abs*1e30) and ((yy1 >= 0 and yy2 <= 0) or (yy1 <= 0 and y2 > 0)))
            xz = 0.5*(xx1+xx2)
        else
            xz = a/b
        end
        return xz
    end
    
    
    def show_mass_point(frac, color)
        m = d.star_mass * frac
        i = d.mass.where_closest(m)
        j = i+1
        j = i if j >= d.mass.length
        m0 = d.mass[i]; m1 = d.mass[j]        
        if ((m0-m)*(m-m1) < 0)
            j = i-1; m1 = d.mass[j]
        end
        rho = find0(d.logRho[i], m0-m, d.logRho[j], m1-m)
        temp = find0(d.logT[i], m0-m, d.logT[j], m1-m)
        draw_mass_spot(rho, temp, color)
    end
    
    
    def show_tau_point(tau_mass, color)
        show_mass_point(tau_mass/d.star_mass, color)
    end

    
    def show_eta_point(color)
        show_mass_point(d.mass[d.eta.where_closest(0)]/d.star_mass, color)
    end


    def plot_T_RHO
      plot_T_RHO_Profile(false, false)
    end

    def plot_T_RHO_eos
      plot_T_RHO_Profile(true, false)
    end

    def plot_T_RHO_kap
      plot_T_RHO_Profile(false, true)
    end
    
    def plot_T_RHO_Profile(eos_flag, kap_flag)
        left = @trho_left; right = @trho_right
        top = @trho_top; bottom = @trho_bottom
        t.show_plot('left_boundary' => left, 'right_boundary' => right,
               'top_boundary' => top, 'bottom_boundary' => bottom) do
            t.show_xlabel('log $\rho$ (g cm^{-3})')
            t.show_ylabel('log T \rm (K)')
            burning_lines
            show_eos_regions if eos_flag
            show_kap_regions if kap_flag
            show_star(0)
            show_star(1)
            show_star(2)
            show_tau_point(d.tau10_mass, Teal) if @show_tau10
            show_eta_point(@eta_color) if @eta_color != nil && d.eta.max > 0
            show_mass_point(0.5, @mass_50_color)
            show_mass_point(0.95, @mass_95_color)
            show_mass_point(0.999, @mass_999_color)
            add_eos_legend
        end
    end


   def show_kap_regions
        add_logR_limit
        # show where electron to baryon ratio is twice that expected
        t.line_width = 1.0
        t.line_type = Line_Type_Dash
        t.append_points_to_path(@elect_data[0],@elect_data[1])
        t.stroke_color = Crimson
        t.stroke
        # show where kap_rad == kap_cond
        t.line_type = Line_Type_Dot
        t.append_points_to_path(@kap_rad_cond_eq[0],@kap_rad_cond_eq[1])
        t.stroke_color = BrightBlue
        t.stroke
   end 
    
    
    def add_TR_line(logR1, logT1, logR2, logT2)
        logRho1 = logR1 + 3 * logT1 - 18
        logRho2 = logR2 + 3 * logT2 - 18
        t.stroke_line(logRho1, logT1, logRho2, logT2)
    end
    
    
    def add_logR_limit

        show_freeman_region
    
        t.line_width = 2
        t.line_color = Coral
        logT_lo = 2.7; logT_hi = 8.7; logT_max = 10.3
        add_TR_line(-8, logT_lo, -8, logT_hi)
        add_TR_line(1, logT_lo, 1, logT_hi)
        add_TR_line(1, logT_lo, -8, logT_lo)
        add_TR_line(1, logT_hi, -8, logT_hi)

        freg_blend_logT2 = 4.10
        freg_blend_logT1 = 3.93
        add_TR_line(1, 2.7, -8, 2.7)
        add_TR_line(1, freg_blend_logT1, -8, freg_blend_logT1)
        add_TR_line(1, freg_blend_logT2, -8, freg_blend_logT2)
        add_TR_line(1, 8.2, -8, 8.2)

        t.line_color = Black
        
        add_TR_line(-8, logT_hi, -8, logT_max)
        add_TR_line(-8, logT_max, 8, logT_max)
        add_TR_line(8, logT_lo, 8, logT_hi)
        add_TR_line(1, logT_lo, 8, logT_lo)
        
        txt_scl = 1
        t.show_label('text' => 'FERGUSON', 'x' => -8.3, 'y' => 3.65,
            'color' => Black,
            'scale' => txt_scl, 'justification' => CENTERED,
            'alignment' => ALIGNED_AT_MIDHEIGHT)
        
        
        t.show_label('text' => 'OPAL/OP', 'x' => -4.7, 'y' => 5.2,
            'color' => Black,
            'scale' => txt_scl, 'justification' => CENTERED,
            'alignment' => ALIGNED_AT_MIDHEIGHT)
        
        
        t.show_label('text' => 'COMPTON', 'x' => 6.5, 'y' => 9.1,
            'color' => Black,
            'scale' => txt_scl, 'justification' => CENTERED,
            'alignment' => ALIGNED_AT_MIDHEIGHT)
        
        
        t.show_label('text' => 'BLEND', 'x' => 1.8, 'y' => 8.45,
            'color' => Black,
            'scale' => 0.7, 'justification' => CENTERED,
            'alignment' => ALIGNED_AT_MIDHEIGHT)
        
        
        t.show_label('text' => 'BLEND', 
            'x' => -9, 'y' => (freg_blend_logT1 + freg_blend_logT2)/2,
            'color' => Black,
            'scale' => 0.6, 'justification' => CENTERED,
            'alignment' => ALIGNED_AT_MIDHEIGHT)
        
        
        t.show_label('text' => '$\kappa_{rad}=\kappa_{cond}$', 'x' => -0.2, 'y' => 3.7,
            'color' => Black,
            'scale' => 0.7, 'justification' => RIGHT_JUSTIFIED,
            'alignment' => ALIGNED_AT_MIDHEIGHT)


        angle = 35
        t.show_label('text' => 'logR = -8', 'x' => -7.8, 'y' => 6.3,
            'color' => Black, 'angle' => angle,
            'scale' => txt_scl, 'justification' => CENTERED,
            'alignment' => ALIGNED_AT_MIDHEIGHT)
        t.show_label('text' => 'logR = 1', 'x' => 0.6, 'y' => 6.1,
            'color' => Black, 'angle' => angle,
            'scale' => txt_scl, 'justification' => CENTERED,
            'alignment' => ALIGNED_AT_MIDHEIGHT)
        t.show_label('text' => 'logR = 8', 'x' => 3.8, 'y' => 4.9,
            'color' => Black, 'angle' => angle,
            'scale' => txt_scl, 'justification' => CENTERED,
            'alignment' => ALIGNED_AT_MIDHEIGHT)

    end
    
    
    def show_freeman_region
    
        t.line_width = 2
        t.line_color = Tan
        t.move_to_point(-8.8,1.88)
        t.append_point_to_path(-3.36,1.88)
        t.append_point_to_path(-1.5,2.5)
        t.append_point_to_path(-2.6,3.6)
        t.append_point_to_path(-11.3,3.6)
        #t.append_point_to_path(-8.8,2.7)
        #t.append_point_to_path(-10.2,2.7)
        t.append_point_to_path(-9.5,1.88)
        t.append_point_to_path(-8.8,1.88)
        t.close_path
        t.stroke
        
        txt_scl = 1
        t.show_label('text' => 'FREEDMAN', 'x' => -5.2, 'y' => 3.0,
            'color' => Black,
            'scale' => txt_scl, 'justification' => CENTERED,
            'alignment' => ALIGNED_AT_MIDHEIGHT)
        
    end
    
    
    def show_eos_regions
      #logG_line(0)
      #logG_line(log10(40))
      #logG_line(log10(80))
      #logG_line(log10(170))
      show_gamma_4_thirds
      show_gamma_170
      scl = 1.3 
      t.show_label('text' => '\textbf{SCVH}', 'x' => -7.2, 'y' => 2.73,
              'color' => DarkChocolate, 'scale' => scl, 
              'justification' => CENTERED)
       t.show_label('text' => '\textbf{PC}', 'x' => 7.8, 'y' => 5.8,
           'color' => Crimson, 'scale' => scl, 'justification' => CENTERED)
       t.show_label('text' => '\textbf{HELM}', 'x' => 8.6, 'y' => 8.6,
           'color' => Crimson, 'scale' => scl, 'justification' => CENTERED)
       show_opal_clip
       show_scvh_clip
       t.show_label('text' => '\textbf{OPAL}', 'x' => -7.2, 'y' => 5.8,
              'color' => Indigo, 'scale' => scl, 
              'justification' => CENTERED)
    
    end
    
    def logT_for_gamma_170(logRho)
        return 4.53128 + logRho/3.0
    end
    
    
    def show_gamma_4_thirds
        t.line_width = 1.0
        t.line_type = Line_Type_Dash
        t.append_points_to_path(@gamma_4_thirds[0],@gamma_4_thirds[1])
        t.stroke_color = Crimson
        t.stroke
        t.show_label('text' => '$\Gamma_1 < 4/3$', 'x' => 3, 'y' => 9.25,
                    'color' => Crimson,
                    'scale' => 0.6, 'justification' => LEFT_JUSTIFIED, 
                    'alignment' => ALIGNED_AT_BASELINE)
    end
    
    
    def show_gamma_170
        t.line_color = Black
        t.line_width = 1.0
        t.line_type = LINE_TYPE_DASH
        logRho1 = 3.8; logT1 = logT_for_gamma_170(logRho1)
        logRho2 = 14; logT2 = logT_for_gamma_170(logRho2)
        t.stroke_line(logRho1, logT1, logRho2, logT2)
        t.show_label('text' => '$\Gamma = 170$ for pure oxygen', 'x' => 4.5, 'y' => 5.69,
                    'color' => Black, 'angle' => 36.7,
                    'scale' => 0.7, 'justification' => LEFT_JUSTIFIED, 
                    'alignment' => ALIGNED_AT_BASELINE)
    end
    
    
    def show_elect
        # show where electron to baryon ratio is twice that expected
        t.line_width = 1.0
        t.line_type = Line_Type_Dash
        t.append_points_to_path(@elect_data[0],@elect_data[1])
        t.stroke_color = Crimson
        t.stroke
    end
    
    
    def logG_line(logG)  # logG = logRho/3 - logT + 6.76173  pure oxygen
        d = 3.7
        logRho1 = 3.8
        logT1 = logRho1/3 - logG + 6.76173
        logRho2 = 12
        logT2 = logRho2/3 - logG + 6.76173
        t.line_width = 1
        t.line_color = Blue
        t.line_type = Line_Type_Dot
        puts "logG_line #{logG} #{logRho1} #{logT1} #{logRho2} #{logT2}"
        t.stroke_line(logRho1, logT1, logRho2, logT2)        
    end

    
    def show_opal_clip
        t.context do
            t.opacity_for_fill = 0.3
            t.fill_color = Lilac
            t.append_points_to_path(@opal_clip.log_rho, @opal_clip.log_T)
            t.context { t.clip; t.fill_frame }
            t.stroke_color = Indigo
            t.line_type = Line_Type_Solid
            t.opacity_for_stroke = 0.7
            t.line_width = 2.0
            t.append_points_to_path(@opal_clip.log_rho, @opal_clip.log_T)
            t.close_path
            t.stroke
        end
    end

    def show_scvh_clip
        t.context do
            t.opacity_for_fill = 0.3
            t.fill_color = Peru
            t.append_points_to_path(@scvh_clip.log_rho, @scvh_clip.log_T)
            t.context { t.clip; t.fill_frame }
            t.stroke_color = DarkChocolate
            t.line_type = Line_Type_Solid
            t.opacity_for_stroke = 0.7
            t.line_width = 2.0
            t.append_points_to_path(@scvh_clip.log_rho, @scvh_clip.log_T)
            t.close_path
            t.stroke
        end
    end



end
