# history_logs.rb

require 'date'

class HistoryLogs

    include Math
    include Tioga
    include FigureConstants

    attr_reader :columns, :column_names

      attr_accessor :initial_mass
      attr_accessor :initial_z
      attr_accessor :h1_boundary_limit
      attr_accessor :he4_boundary_limit
      attr_accessor :c12_boundary_limit
      attr_accessor :burn_min1
      attr_accessor :burn_min2
      
      attr_accessor :model_number
      attr_accessor :star_age
      attr_accessor :star_mass
      attr_accessor :log_LH
      attr_accessor :log_LHe
      attr_accessor :log_Lneu
      attr_accessor :log_Lneu_div_L
      attr_accessor :log_L_div_Ledd
      attr_accessor :log_L
      attr_accessor :log_Ledd
      attr_accessor :log_Teff
      attr_accessor :effective_temp
      attr_accessor :log_R
      attr_accessor :log_g
      attr_accessor :log_center_T
      attr_accessor :log_center_P
      attr_accessor :log_center_Rho
      attr_accessor :log_central_T
      attr_accessor :log_central_P
      attr_accessor :log_central_Rho
      attr_accessor :log_dt
      attr_accessor :e_thermal

      attr_accessor :conv_mx1_top
      attr_accessor :conv_mx1_bot
      attr_accessor :conv_mx2_top
      attr_accessor :conv_mx2_bot
      attr_accessor :mx1_top
      attr_accessor :mx1_bot
      attr_accessor :mx2_top
      attr_accessor :mx2_bot
      attr_accessor :epsnuc_M_1
      attr_accessor :epsnuc_M_2
      attr_accessor :epsnuc_M_3
      attr_accessor :epsnuc_M_4
      attr_accessor :epsnuc_M_5
      attr_accessor :epsnuc_M_6
      attr_accessor :epsnuc_M_7
      attr_accessor :epsnuc_M_8
      attr_accessor :h1_boundary_mass
      attr_accessor :he4_boundary_mass
 
      attr_accessor :mix_type_1
      attr_accessor :mix_qtop_1
      attr_accessor :mix_type_2
      attr_accessor :mix_qtop_2
      attr_accessor :mix_type_3
      attr_accessor :mix_qtop_3
      attr_accessor :mix_type_4
      attr_accessor :mix_qtop_4
      attr_accessor :mix_type_5
      attr_accessor :mix_qtop_5
      attr_accessor :mix_type_6
      attr_accessor :mix_qtop_6
      attr_accessor :mix_type_7
      attr_accessor :mix_qtop_7
      attr_accessor :mix_type_8
      attr_accessor :mix_qtop_8
      attr_accessor :mix_type_9
      attr_accessor :mix_qtop_9
      attr_accessor :mix_type_10
      attr_accessor :mix_qtop_10
      attr_accessor :mix_type_11
      attr_accessor :mix_qtop_11
      attr_accessor :mix_type_12
      attr_accessor :mix_qtop_12
      attr_accessor :mix_type_13
      attr_accessor :mix_qtop_13
      attr_accessor :mix_type_14
      attr_accessor :mix_qtop_14
      attr_accessor :mix_type_15
      attr_accessor :mix_qtop_15
      attr_accessor :mix_type_16
      attr_accessor :mix_qtop_16
      attr_accessor :mix_type_17
      attr_accessor :mix_qtop_17
      attr_accessor :mix_type_18
      attr_accessor :mix_qtop_18
      attr_accessor :mix_type_19
      attr_accessor :mix_qtop_19
      attr_accessor :mix_type_20
      attr_accessor :mix_qtop_20
      attr_accessor :mix_type_21
      attr_accessor :mix_qtop_21
      attr_accessor :mix_type_22
      attr_accessor :mix_qtop_22
      attr_accessor :mix_type_23
      attr_accessor :mix_qtop_23
      attr_accessor :mix_type_24
      attr_accessor :mix_qtop_24
      attr_accessor :mix_type_25
      attr_accessor :mix_qtop_25
      attr_accessor :mix_type_26
      attr_accessor :mix_qtop_26
      attr_accessor :mix_type_27
      attr_accessor :mix_qtop_27
      attr_accessor :mix_type_28
      attr_accessor :mix_qtop_28
      attr_accessor :mix_type_29
      attr_accessor :mix_qtop_29
      attr_accessor :mix_type_30
      attr_accessor :mix_qtop_30
      attr_accessor :mix_type_31
      attr_accessor :mix_qtop_31
      attr_accessor :mix_type_32
      attr_accessor :mix_qtop_32
      attr_accessor :mix_type_33
      attr_accessor :mix_qtop_33
      attr_accessor :mix_type_34
      attr_accessor :mix_qtop_34
      attr_accessor :mix_type_35
      attr_accessor :mix_qtop_35
      attr_accessor :mix_type_36
      attr_accessor :mix_qtop_36
      attr_accessor :mix_type_37
      attr_accessor :mix_qtop_37
      attr_accessor :mix_type_38
      attr_accessor :mix_qtop_38
      attr_accessor :mix_type_39
      attr_accessor :mix_qtop_39
      attr_accessor :mix_type_40
      attr_accessor :mix_qtop_40
      attr_accessor :mix_type_41
      attr_accessor :mix_qtop_41
      attr_accessor :mix_type_42
      attr_accessor :mix_qtop_42
      attr_accessor :mix_type_43
      attr_accessor :mix_qtop_43
      attr_accessor :mix_type_44
      attr_accessor :mix_qtop_44
      attr_accessor :mix_type_45
      attr_accessor :mix_qtop_45
      attr_accessor :mix_type_46
      attr_accessor :mix_qtop_46
      attr_accessor :mix_type_47
      attr_accessor :mix_qtop_47
      attr_accessor :mix_type_48
      attr_accessor :mix_qtop_48
      attr_accessor :mix_type_49
      attr_accessor :mix_qtop_49
      attr_accessor :mix_type_50
      attr_accessor :mix_qtop_50
 
      attr_accessor :burn_type_1
      attr_accessor :burn_qtop_1
      attr_accessor :burn_type_2
      attr_accessor :burn_qtop_2
      attr_accessor :burn_type_3
      attr_accessor :burn_qtop_3
      attr_accessor :burn_type_4
      attr_accessor :burn_qtop_4
      attr_accessor :burn_type_5
      attr_accessor :burn_qtop_5
      attr_accessor :burn_type_6
      attr_accessor :burn_qtop_6
      attr_accessor :burn_type_7
      attr_accessor :burn_qtop_7
      attr_accessor :burn_type_8
      attr_accessor :burn_qtop_8
      attr_accessor :burn_type_9
      attr_accessor :burn_qtop_9
      attr_accessor :burn_type_10
      attr_accessor :burn_qtop_10
      attr_accessor :burn_type_11
      attr_accessor :burn_qtop_11
      attr_accessor :burn_type_12
      attr_accessor :burn_qtop_12
      attr_accessor :burn_type_13
      attr_accessor :burn_qtop_13
      attr_accessor :burn_type_14
      attr_accessor :burn_qtop_14
      attr_accessor :burn_type_15
      attr_accessor :burn_qtop_15
      attr_accessor :burn_type_16
      attr_accessor :burn_qtop_16
      attr_accessor :burn_type_17
      attr_accessor :burn_qtop_17
      attr_accessor :burn_type_18
      attr_accessor :burn_qtop_18
      attr_accessor :burn_type_19
      attr_accessor :burn_qtop_19
      attr_accessor :burn_type_20
      attr_accessor :burn_qtop_20
      attr_accessor :burn_type_21
      attr_accessor :burn_qtop_21
      attr_accessor :burn_type_22
      attr_accessor :burn_qtop_22
      attr_accessor :burn_type_23
      attr_accessor :burn_qtop_23
      attr_accessor :burn_type_24
      attr_accessor :burn_qtop_24
      attr_accessor :burn_type_25
      attr_accessor :burn_qtop_25
      attr_accessor :burn_type_26
      attr_accessor :burn_qtop_26
      attr_accessor :burn_type_27
      attr_accessor :burn_qtop_27
      attr_accessor :burn_type_28
      attr_accessor :burn_qtop_28
      attr_accessor :burn_type_29
      attr_accessor :burn_qtop_29
      attr_accessor :burn_type_30
      attr_accessor :burn_qtop_30
      attr_accessor :burn_type_31
      attr_accessor :burn_qtop_31
      attr_accessor :burn_type_32
      attr_accessor :burn_qtop_32
      attr_accessor :burn_type_33
      attr_accessor :burn_qtop_33
      attr_accessor :burn_type_34
      attr_accessor :burn_qtop_34
      attr_accessor :burn_type_35
      attr_accessor :burn_qtop_35
      attr_accessor :burn_type_36
      attr_accessor :burn_qtop_36
      attr_accessor :burn_type_37
      attr_accessor :burn_qtop_37
      attr_accessor :burn_type_38
      attr_accessor :burn_qtop_38
      attr_accessor :burn_type_39
      attr_accessor :burn_qtop_39
      attr_accessor :burn_type_40
      attr_accessor :burn_qtop_40
      attr_accessor :burn_type_41
      attr_accessor :burn_qtop_41
      attr_accessor :burn_type_42
      attr_accessor :burn_qtop_42
      attr_accessor :burn_type_43
      attr_accessor :burn_qtop_43
      attr_accessor :burn_type_44
      attr_accessor :burn_qtop_44
      attr_accessor :burn_type_45
      attr_accessor :burn_qtop_45
      attr_accessor :burn_type_46
      attr_accessor :burn_qtop_46
      attr_accessor :burn_type_47
      attr_accessor :burn_qtop_47
      attr_accessor :burn_type_48
      attr_accessor :burn_qtop_48
      attr_accessor :burn_type_49
      attr_accessor :burn_qtop_49
      attr_accessor :burn_type_50
      attr_accessor :burn_qtop_50
      attr_accessor :burn_type_51
      attr_accessor :burn_qtop_51
      attr_accessor :burn_type_52
      attr_accessor :burn_qtop_52
      attr_accessor :burn_type_53
      attr_accessor :burn_qtop_53
      attr_accessor :burn_type_54
      attr_accessor :burn_qtop_54
      attr_accessor :burn_type_55
      attr_accessor :burn_qtop_55
      attr_accessor :burn_type_56
      attr_accessor :burn_qtop_56
      attr_accessor :burn_type_57
      attr_accessor :burn_qtop_57
      attr_accessor :burn_type_58
      attr_accessor :burn_qtop_58
      attr_accessor :burn_type_59
      attr_accessor :burn_qtop_59
      attr_accessor :burn_type_60
      attr_accessor :burn_qtop_60
      attr_accessor :burn_type_61
      attr_accessor :burn_qtop_61
      attr_accessor :burn_type_62
      attr_accessor :burn_qtop_62
      attr_accessor :burn_type_63
      attr_accessor :burn_qtop_63
      attr_accessor :burn_type_64
      attr_accessor :burn_qtop_64
      attr_accessor :burn_type_65
      attr_accessor :burn_qtop_65
      attr_accessor :burn_type_66
      attr_accessor :burn_qtop_66
      attr_accessor :burn_type_67
      attr_accessor :burn_qtop_67
      attr_accessor :burn_type_68
      attr_accessor :burn_qtop_68
      attr_accessor :burn_type_69
      attr_accessor :burn_qtop_69
      attr_accessor :burn_type_70
      attr_accessor :burn_qtop_70
      attr_accessor :burn_type_71
      attr_accessor :burn_qtop_71
      attr_accessor :burn_type_72
      attr_accessor :burn_qtop_72
      attr_accessor :burn_type_73
      attr_accessor :burn_qtop_73
      attr_accessor :burn_type_74
      attr_accessor :burn_qtop_74
      attr_accessor :burn_type_75
      attr_accessor :burn_qtop_75
      attr_accessor :burn_type_76
      attr_accessor :burn_qtop_76
      attr_accessor :burn_type_77
      attr_accessor :burn_qtop_77
      attr_accessor :burn_type_78
      attr_accessor :burn_qtop_78
      attr_accessor :burn_type_79
      attr_accessor :burn_qtop_79
      attr_accessor :burn_type_80
      attr_accessor :burn_qtop_80
      attr_accessor :burn_type_81
      attr_accessor :burn_qtop_81
      attr_accessor :burn_type_82
      attr_accessor :burn_qtop_82
      attr_accessor :burn_type_83
      attr_accessor :burn_qtop_83
      attr_accessor :burn_type_84
      attr_accessor :burn_qtop_84
      attr_accessor :burn_type_85
      attr_accessor :burn_qtop_85
      attr_accessor :burn_type_86
      attr_accessor :burn_qtop_86
      attr_accessor :burn_type_87
      attr_accessor :burn_qtop_87
      attr_accessor :burn_type_88
      attr_accessor :burn_qtop_88
      attr_accessor :burn_type_89
      attr_accessor :burn_qtop_89
      attr_accessor :burn_type_90
      attr_accessor :burn_qtop_90
      attr_accessor :burn_type_91
      attr_accessor :burn_qtop_91
      attr_accessor :burn_type_92
      attr_accessor :burn_qtop_92
      attr_accessor :burn_type_93
      attr_accessor :burn_qtop_93
      attr_accessor :burn_type_94
      attr_accessor :burn_qtop_94
      attr_accessor :burn_type_95
      attr_accessor :burn_qtop_95
      attr_accessor :burn_type_96
      attr_accessor :burn_qtop_96
      attr_accessor :burn_type_97
      attr_accessor :burn_qtop_97
      attr_accessor :burn_type_98
      attr_accessor :burn_qtop_98
      attr_accessor :burn_type_99
      attr_accessor :burn_qtop_99
      attr_accessor :burn_type_100
      attr_accessor :burn_qtop_100

      attr_accessor :center_h1
      attr_accessor :center_he4
      attr_accessor :center_c12
      attr_accessor :center_n14
      attr_accessor :center_o16
      attr_accessor :center_ne20
      attr_accessor :center_si28
      attr_accessor :center_s32
      attr_accessor :center_ar36
      attr_accessor :center_ca40
      attr_accessor :center_ti44
      attr_accessor :center_cr48
      attr_accessor :center_cr56
      attr_accessor :center_fe52
      attr_accessor :center_fe54
      attr_accessor :center_fe56
      attr_accessor :center_ni56
      attr_accessor :center_neut
      attr_accessor :center_prot

      attr_accessor :cz_max_log_h1
      attr_accessor :cz_max_log_he4
      attr_accessor :cz_max_log_c12
      attr_accessor :cz_max_log_n13
      attr_accessor :cz_max_log_n14
      attr_accessor :cz_max_log_o16
      attr_accessor :cz_max_log_ne20
      attr_accessor :cz_max_log_na23
      attr_accessor :cz_max_log_mg24
      attr_accessor :cz_max_log_al27
      attr_accessor :cz_max_log_si28
      attr_accessor :cz_max_log_p31
      attr_accessor :cz_max_log_s32
      attr_accessor :cz_max_log_cl35
      attr_accessor :cz_max_log_ar36
      attr_accessor :cz_max_log_k39
      attr_accessor :cz_max_log_ca40
      attr_accessor :cz_max_log_sc43
      attr_accessor :cz_max_log_ti44
      attr_accessor :cz_max_log_v47
      attr_accessor :cz_max_log_cr48
      attr_accessor :cz_max_log_cr56
      attr_accessor :cz_max_log_mn51
      attr_accessor :cz_max_log_fe52
      attr_accessor :cz_max_log_fe54
      attr_accessor :cz_max_log_fe56
      attr_accessor :cz_max_log_ni56

      attr_accessor :cz_logT
      attr_accessor :cz_logP
 
      attr_accessor :max_eps_nuc_t_heat, :max_eps_nuc_lgP, :max_eps_nuc_lgT, :max_eps_nuc_log_c12

      attr_accessor :lg_age 
      attr_accessor :lg_ybp
      attr_accessor :lg_sbp
      
      attr_accessor :log_average_h2
      attr_accessor :log_average_li7

      attr_accessor :radius
      attr_accessor :h1_boundary_mass
      attr_accessor :h1_boundary_radius
      attr_accessor :he4_boundary_mass
      attr_accessor :he4_boundary_radius
      
      
      attr_accessor :surface_he4


      # for rlo
      attr_accessor :period_minutes
      attr_accessor :period_hr
      attr_accessor :log_abs_mdot
      attr_accessor :atmosphere_column_density
      attr_accessor :lg_Lmdot
      attr_accessor :jdot_div_jdotgr
      attr_accessor :lg_separation
      attr_accessor :rl_donor
      attr_accessor :rl_accretor
      
      # for asteroseismology
      attr_accessor :delta_nu
      attr_accessor :delta_Pg
      attr_accessor :log_delta_Pg
      attr_accessor :nu_max
      attr_accessor :int_k_r_dr_nu_max_Sl1
      
      attr_accessor :l0_model_1, :l0_model_2, :l0_model_3, :l0_model_4
      attr_accessor :l1_model_1, :l1_model_2, :l1_model_3, :l1_model_4
      attr_accessor :l2_model_1, :l2_model_2, :l2_model_3, :l2_model_4
      attr_accessor :l0_obs_1, :l0_obs_2, :l0_obs_3, :l0_obs_4
      attr_accessor :l1_obs_1, :l1_obs_2, :l1_obs_3, :l1_obs_4
      attr_accessor :l2_obs_1, :l2_obs_2, :l2_obs_3, :l2_obs_4
      attr_accessor :avg_delta_nu_model, :avg_delta_nu_obs
      
      
      attr_accessor :age_Scale
      

    def initialize(filename, first_model, last_model, 
            age_shift, first_age, last_age, discard_span, age_span, max_models, log_cnt, xaxis, mini_log_names)    
      read(filename, first_model, last_model, 
        age_shift, first_age, last_age, discard_span, age_span, max_models, log_cnt, xaxis, mini_log_names)
    end

    
    def read(filename, first_model, last_model, 
        age_shift, first_age, last_age, discard_span, age_span, max_models, log_cnt, xaxis, mini_log_names)
      
      dbg = false
      
      if dbg
         puts "args for read"
         puts "first_model #{first_model}"
         puts "last_model #{last_model}"
         puts "age_shift #{age_shift}"
         puts "first_age #{first_age}"
         puts "last_age #{last_age}"
         puts "discard_span #{discard_span}"
         puts "age_span #{age_span}"
         puts "max_models #{max_models}"
         puts "log_cnt #{log_cnt}"
      end
      
      puts "read #{filename}"

      # read the names
      f = File.open(filename)
      f.readline # skip line 1
      val_names = f.readline.split # names of scalars in line 2
      f.readline # skip line 3
      f.readline # skip line 4
      f.readline # skip line 5
      vec_names = f.readline.split # names of vectors in line 6
      f.close
      
      vals = Dvector.read_row(filename,3) # scalar values are in line 3
      assign_to_names(val_names,vals)
      
      @column_names = vec_names
      @columns = Array.new(vec_names.size) { Dvector.new }
      Dvector.read(filename,@columns,7) # vector values start on line 7
      assign_to_names(vec_names,@columns)
      
     #@column_names.each { |n| puts "#{n}"}

    # discard log entries with model_number < first_model
      if first_model > 0
        k = @model_number.where_last_le(first_model)
        if k != nil && k > 0
            @columns.each { |vec| vec.slice!(0..k-1) }
        end
      end
      
    # discard log entries with model_number > last_model
    # if last_model <= 0, then ignore this parameter.
      if last_model > 0
        k = @model_number.where_last_le(last_model)
        if k != nil && k < @model_number.length
            @columns.each { |vec| vec.slice!(k+1..-1) }
        end
      end
      
      puts "remove_backups" if dbg
      
      remove_backups(dbg)
      
      if xaxis == 'by_yrs_post_flash' || xaxis == 'by_lg_yrs_post_flash'
        # set age_shift
        k = @log_LHe.where_max if @log_LHe != nil
        k = @power_he_burn.where_max if @power_he_burn != nil
        puts "max he burn point #{k}"
        puts "max he burn age #{@star_age[k]}"
        age_shift = -@star_age[k]
        first_age = 1 if xaxis == 'by_lg_yrs_post_flash'
      end
      
      @star_age = @lg_age.exp10 if @star_age == nil && @lg_age != nil
      @star_age.add!(age_shift) if age_shift != nil
      
      puts "prune_as_needed" if dbg

      prune_as_needed(first_age, last_age, discard_span, age_span, max_models, log_cnt, dbg)
      set_derived_values
      
      puts "finished reading data" if dbg
      
      return if filename.include?('mini') || mini_log_names == nil
      
      #return if @log_L == nil || @log_Teff == nil
      
      filename = filename + '_mini'
      f = File.open(filename,"w")
      write_mini_log(f,mini_log_names)
      f.close

    end
    
    
    def write_mini_log(f,name_list=nil)
      name_list.each do |name|
         n = @column_names.index(name)
         unless n == nil
            f.printf("%25s", name)
         end
      end
      f.puts
      @star_age.length.times do |i|
         name_list.each do |name|
            n = @column_names.index(name)
            unless n == nil
               if name == "model_number"
                  f.printf("%25i", @model_number[i])
               else
                  f.printf("%25.15e", @columns[n][i])
               end
            end
         end
         f.puts
      end
    end

    
    def remove_backups(dbg)
      # make a list of the ones to be removed
      lst = []
      n = @model_number.size
      (n-1).times do |k|
        lst << k if @model_number[k] >= @model_number[k+1..-1].min
      end
      return if lst.length == 0
      puts "remove #{lst.length} models because of backups" if dbg
      lst = lst.sort
      @columns.each { |vec| vec.prune!(lst) }
      num_models = @model_number.length
    end
    
    
   def prune_as_needed(first_age, last_age, discard_span, age_span, max_models, log_cnt, dbg)
   
      # last_age = -1 means use final log to set last_age
      last_age = @star_age[-1] if last_age == -1
      
      # revise last_age by subtracting discard_span
      last_age = last_age - discard_span

      if age_span != -1 && first_age == -1
         # discard log entries for model with ages < last_age - age_span
         # age_span = -1 means set age_span = last_age
         first_age = last_age - age_span
      elsif first_age == -1
         first_age = @star_age[0] 
      end
      
      first_model = @star_age.where_last_le(first_age)
      last_model = @star_age.where_last_le(last_age)
      if dbg
         puts "last_age #{last_age}"
         puts "age_span #{age_span}"
         puts "first_age #{first_age}"
         puts "first_model #{first_model}"
         puts "last_model #{last_model}"
      end

      num_models = @star_age.length
      first_model = 0 if first_model == nil
      last_model = num_models-1 if last_model == nil
      
      old_num_models = num_models
      if first_model > 0 || last_model < num_models-1
         if dbg
            puts "remove #{first_model} models from start because of start age #{first_age}"
            puts "remove #{num_models-1-last_model} models from end because of end age #{last_age}"
         end
         @columns.each { |vec| 
            vec.slice!(last_model+1..-1) if last_model < num_models-1
            vec.slice!(0..first_model-1) if first_model > 0
         }
         if dbg
            puts "num models now #{num_models}"
         end
         num_models = @star_age.length
      end

      if num_models != last_model-first_model+1
         puts "problem in pruning models"
         puts "old_num_models #{old_num_models}"
         puts "num_models #{num_models}"
         puts "last_model #{last_model}"
         puts "first_model #{first_model}"
         puts "last_age #{last_age}"
         puts "age_span #{age_span}"
         puts "first_age #{first_age}"
         return
      end

      # prune set of models if there are more than max_models
      # max_models = -1 mean there is no max.
      return if max_models == -1 || num_models <= max_models

      # if need to prune models because exceed max_models,
      # start pruning by discarding models with
      # model number < previous model number + log_cnt.
      mod_num_range = @model_number[-1] - @model_number[0] + 1
      log_cnt = (mod_num_range + max_models - 1)/max_models if log_cnt == -1
      if log_cnt > 1
         # remove as many as can before check log_cnt
         # since log_cnt check can only reduce number by a factor = log_cnt
         first_model = num_models - max_models*log_cnt
         if first_model > 0
            @columns.each { |vec| vec.slice!(0..first_model-1) }
            num_models = @star_age.length
            if dbg
               puts "remove #{first_model} models from start before checking log_cnt"
               puts "num models now #{num_models}"
            end
        end
         # make a list of the ones to be removed
         lst = []
         n = @model_number.size
         num_models = n
         last_deletion = -1
         (n-1).times do |k|
            if k > last_deletion
               okay_number = @model_number[k]+log_cnt
               j = k+1
               while j < num_models && @model_number[j] < okay_number
                  last_deletion = j
                  lst << last_deletion
                  n -= 1
                  break if (n <= max_models)
                  j += 1
               end
               break if (n <= max_models)
            end
         end
         @columns.each { |vec| vec.prune!(lst) }
         num_models = @star_age.length
         if dbg
            puts "remove #{lst.length} models for log_cnt = #{log_cnt}"
            puts "num models now #{num_models}"
         end
         return if num_models <= max_models
      end

      # if still need to discard models after have pruned using log_cnt,
      # then discard the models with the smallest model_numbers until
      # only have max_models remaining.
      first_model = num_models - max_models
      @columns.each { |vec| vec.slice!(0..first_model-1) }
      num_models = @star_age.length
      if dbg
         puts "remove #{first_model} models from start because of max_models = #{max_models}"
         puts "num models now #{num_models}"
      end
      if num_models != max_models
         puts "problem in last stage of pruning models"
         puts "num_models #{num_models}"
         puts "max_models #{max_models}"
         puts "first_model #{first_model}"
      end
      
   end


    def assign_to_names(names,vals)
      unless names.size == vals.size
         puts "mismatch in lengths for assign to names"
         puts "names.size = #{names.size}"
         puts "vals.size = #{vals.size}"
         raise "error in assign_to_names"
      end
      cmd = ''
      begin
         names.size.times do |i|
            cmd = sprintf("@%s = vals[%i]",names[i],i)
            eval(cmd)
         end
      rescue
         puts "failure for #{cmd}"
         raise "error in assign_to_names"
      end
    end

    
    def set_derived_values
      
      if @log_central_T == nil
        @log_central_T = @log_center_T
      elsif @log_center_T == nil
        @log_center_T = @log_central_T
      end
      
      if @log_central_Rho == nil
        @log_central_Rho = @log_center_Rho
      elsif @log_center_Rho == nil
        @log_center_Rho = @log_central_Rho
      end
      
      if @log_central_T == nil
        @log_central_T = @P
      elsif @P == nil
        @P = @log_central_T
      end
    
      msun = 1.9892e33 # solar mass (g)
      rsun = 6.9598e10 # solar radius (cm)
      secyer = 3.1558149984e7
      #@lsolar = 3.8418e33 # solar luminosity (erg s^-1)

      @num_models = @star_age.length
      present = @star_age[-1]
      
      @lg_ybp = Dvector.new
      p = 1e-99
      unless @log_dt == nil
        @log_dt.reverse.each { |lgdt| dt = 10.0**lgdt; p = p + dt; @lg_ybp << log10(p) }
      end
      @lg_ybp.reverse! unless @lg_ybp == nil
      
      #@lg_ybp = @star_age.dup.sub!(present).neg!.safe_log10!
      @lg_sbp = @lg_ybp.dup.add!(log10(secyer))
      @lg_age = @star_age.dup.safe_log10!
      
      @log_Lneu_div_L = @log_Lneu.dup.sub!(@log_L) unless @log_Lneu == nil
      
      @effective_temp = @log_Teff.dup.exp10! if @effective_temp == nil && @log_Teff != nil

      @radius = @log_R.dup.exp10! unless @log_R == nil
      
      @star_mass = @mass if @star_mass == nil && @mass != nil

    end

end
