from guic import *
from shlex import *
from subprocess import *
from distutils import file_util

class Job(Toplevel):

    def __init__(self, process, inlist):
        Toplevel.__init__(self)
        self.process = process
        self.title("MESA Job Control")
        self.inlist = inlist

        frame = Frame(self)
        frame.pack(side=TOP, fill=X)

        self.status_label = Label(frame, text="Model calculation is running")
        self.status_label.pack(side=LEFT)

        if self.inlist.pause.get():
            frame = Frame(self)
            frame.pack(side=TOP, fill=X)
            step_button = Button(frame, text="Step", command=self.step)
            step_button.pack(side=LEFT)
        
        frame = Frame(self)
        frame.pack(side=TOP, fill=X)

        quit_button = Button(frame, text="PGSTAR...", command=self.refresh_pgstar)
        quit_button.pack(side=LEFT)

        frame = Frame(self)
        frame.pack(side=TOP, fill=X)

        quit_button = Button(frame, text="QUIT", command=self.quit)
        quit_button.pack(side=LEFT)

        self.protocol("WM_DELETE_WINDOW", self.quit)

        self.after(100, self.poll)

    def refresh_pgstar(self):
        pgstar_dialog = PgstarDialog(self.inlist)
        self.wait_window(pgstar_dialog)
        self.step()
        self.inlist.write_inlist()

    def quit(self):
        if self.process != None and self.process.poll() == None:
            if askokcancel("Quit",
                           "A model is running. Do you"
                           " really wish to quit?"):
                self.process.terminate()
                self.process.wait()
                self.destroy()
        else:
            self.destroy()

    def poll(self):
        result = self.process.poll()
        if result != None:
            if result == 0:
                self.bell()
                self.status_label.config(text="Model calculation is complete")
            else:
                self.bell()
                self.bell()
                self.status_label.config(text="Model calculation failed", fg="red")
        else:
            self.after(100, self.poll)

    def step(self):
        result = self.process.poll()
        if result == None:
            self.process.stdin.write("\n")

class Problem(InlistDialog):

    def __init__(self, master):
        InlistDialog.__init__(self, master)
        master.title("MESA Star Builder")

        menu = Menu(master)
        master.config(menu=menu)
        

        filemenu = Menu(menu)
        menu.add_cascade(label="File", menu=filemenu)
        filemenu.add_command(label="Quit", command=self.quit)

        advmenu = Menu(menu)
        menu.add_cascade(label="Advanced", menu=advmenu)
        self.create_advanced_menu(advmenu)
        
        helpmenu = Menu(menu)
        menu.add_cascade(label="Help", menu=helpmenu)
        helpmenu.add_command(label="About...", command=self.about)


        frame = Frame(master)
        frame.pack(side=TOP, fill=X)

        frame1 = Frame(frame)
        frame1.pack(side=TOP, fill=X)
        
        
        create_button = Button(frame1, text="Create", command=self.create)
        create_button.pack(side=LEFT)

        frame1 = Frame(frame)
        frame1.pack(side=TOP, fill=X)

        restart_button = Button(frame1, text="Restart", command=self.restart)
        restart_button.pack(side=LEFT)
        self.restart_file_entry = Entry(frame1)
        self.restart_file_entry.pack(side=LEFT)
        restart_file_select_button = Button(frame1, text="Browse...",
                                            command=self.restart_file_select)
        restart_file_select_button.pack(side=LEFT)
        
        
        master.protocol("WM_DELETE_WINDOW", self.quit)
        self.root = master

        self.process = None
        self.job = None

    def about(self):
        showinfo(
            "About",
            "MESA Star GUI by Kent G. Budge and Bill Paxton"
            )        

    def create(self):
        if self.process == None or self.process.poll() != None:
            self.write_inlist()
            command_line = "rm -f restart_photo"
            args = split(command_line)
            check_call(args)
            command_line = "./star"
            args = split(command_line)
            self.process = Popen(args, stdin=PIPE)
            self.job = Job(self.process, self)
            self.job.mainloop()
        else:
            showwarning(
                "JOB ALREADY RUNNING",
                "A job is already running. You must quit this job before starting another"
                )        
            

    def restart(self):
        if self.process == None or self.process.poll() != None:
            self.write_inlist()
            file_util.copy_file(self.restart_file_entry.get(), "restart_photo")
            command_line = "./star"
            args = split(command_line)
            self.process = Popen(args, stdin=PIPE)
            self.job = Job(self.process, self)
            self.job.mainloop()
        else:
            showwarning(
                "JOB ALREADY RUNNING",
                "A job is already running. You must quit this job before starting another"
                )        

    def restart_file_select(self):
        inlist = askopenfilename()
        if (inlist != ()):
            self.restart_file_entry.delete(0, END)
            self.restart_file_entry.insert(END, inlist)

    def quit(self):
        if self.process != None and self.process.poll() == None:
            if askokcancel("Quit",
                           "A model is running. Do you"
                           " really wish to quit?"):
                self.process.terminate()
                self.process.wait()
                if self.job != None:
                    self.job.destroy()
                self.root.destroy()
        else:
            self.root.destroy()

root = Tk()

problem = Problem(root)

root.mainloop()
