! ***********************************************************************
!
!   Copyright (C) 2012  Bill Paxton
!
!   MESA is free software; you can use it and/or modify
!   it under the combined terms and restrictions of the MESA MANIFESTO
!   and the GNU General Library Public License as published
!   by the Free Software Foundation; either version 2 of the License,
!   or (at your option) any later version.
!
!   You should have received a copy of the MESA MANIFESTO along with
!   this software; if not, it is available at the mesa website:
!   http://mesa.sourceforge.net/
!
!   MESA is distributed in the hope that it will be useful,
!   but WITHOUT ANY WARRANTY; without even the implied warranty of
!   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
!   See the GNU Library General Public License for more details.
!
!   You should have received a copy of the GNU Library General Public License
!   along with this software; if not, write to the Free Software
!   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
!
! ***********************************************************************

      module star_def

      use rates_def, only: rates_reaction_id_max
      use utils_def, only: integer_dict
      use chem_def, only: num_categories, iso_name_length
      use const_def, only: sp, dp, qp
      
      
      implicit none

      integer, parameter :: star_def_version = 16
      
      integer, parameter :: nz_alloc_extra = 200
      
      
      integer, parameter :: XL = dp
      !integer, parameter :: XL = qp ! will need some code changes to use this



      ! result codes for various evolution routines
      integer, parameter :: keep_going = 0
      integer, parameter :: redo = 1 
         ! repeat current step with same timestep
         ! for example, after changing a parameter such as mdot
      integer, parameter :: retry = 2
         ! repeat current step with smaller timestep
      integer, parameter :: backup = 3
         ! go back to previous model and retry with smaller timestep
      integer, parameter :: terminate = 4
      
            
      ! wind schemes
      integer, parameter :: no_automatic_wind = 0
      integer, parameter :: Reimers_wind = 1
      integer, parameter :: Blocker_wind = 2
      integer, parameter :: de_Jager_wind = 3
      integer, parameter :: Nieuwenhuijzen_wind = 4
      integer, parameter :: Dutch_wind = 5
      integer, parameter :: other_wind = 6


      ! mesh cell types
      integer, parameter :: split_type = -1
      integer, parameter :: unchanged_type = 0
      integer, parameter :: merged_type = 1
      
      
      ! solver operations
      integer, parameter :: struct_hydro_bit_pos = 0
      integer, parameter :: struct_thermo_bit_pos = 1
      integer, parameter :: burn_bit_pos = 2
      integer, parameter :: mix_bit_pos = 3
      
      ! seulex
      integer, parameter :: max_seulex_kmax = 12 ! max allowed max rows for extrapolation
      
      
      ! pgstar data
      type pgstar_win_file_data
         integer :: id
         character (len=64) :: name
         logical :: win_flag, file_flag, do_win, do_file
         integer :: id_win, id_file, file_cnt
         real :: win_width, prev_win_width
         real :: win_aspect_ratio, prev_win_aspect_ratio
         real :: file_width, file_aspect_ratio
         character (len=256) :: file_dir, file_prefix
         procedure (), pointer, nopass :: plot => null()
      end type pgstar_win_file_data

   	integer, parameter :: max_Abundance_num_isos_to_show = 50
      
      integer, parameter :: max_num_Other_plots = 10
      integer, parameter :: i_main = 1
      integer, parameter :: i_TRho_Profile = i_main + 1
      integer, parameter :: i_Profile = i_TRho_Profile + 1
      integer, parameter :: i_Profile2 = i_Profile + 1
      integer, parameter :: i_Profile3 = i_Profile2 + 1
      integer, parameter :: i_loggTe = i_Profile3 + 1
      integer, parameter :: i_HR = i_loggTe + 1
      integer, parameter :: i_TRho = i_HR + 1
      integer, parameter :: i_HR_TRho = i_TRho + 1
      integer, parameter :: i_Dynamo = i_HR_TRho + 1
      integer, parameter :: i_Mixing_Ds = i_Dynamo + 1
      integer, parameter :: i_Mixing_Dynamo = i_Mixing_Ds + 1
      integer, parameter :: i_CONV = i_Mixing_Dynamo + 1
      integer, parameter :: i_Cntr_Hist = i_CONV + 1
      integer, parameter :: i_Surf_Hist = i_Cntr_Hist + 1
      integer, parameter :: i_Mode_Prop = i_Surf_Hist + 1
      integer, parameter :: i_Power = i_Mode_Prop + 1
      integer, parameter :: i_Abundance = i_Power + 1
      integer, parameter :: i_Abund_Power = i_Abundance + 1
      integer, parameter :: i_Abund_Pwr_Dmix = i_Abund_Power + 1
      integer, parameter :: i_Abund_Pwr_Dmix_Dyn = i_Abund_Pwr_Dmix + 1
      integer, parameter :: i_Other = i_Abund_Pwr_Dmix_Dyn + 1
      integer, parameter :: num_pgstar_plots = i_Other + max_num_Other_plots

      
      
      ! some Tioga colors for pgstar
      integer :: clr_Black
      integer :: clr_Blue
      integer :: clr_BrightBlue
      integer :: clr_Goldenrod
      integer :: clr_Lilac
      integer :: clr_Coral
      integer :: clr_FireBrick
      integer :: clr_RoyalPurple
      integer :: clr_Gold
      integer :: clr_Crimson
      integer :: clr_SlateGray
      integer :: clr_Teal
      integer :: clr_LightSteelBlue
      integer :: clr_MediumSlateBlue
      integer :: clr_MediumSpringGreen
      integer :: clr_MediumBlue
      integer :: clr_RoyalBlue
      integer :: clr_LightGray
      integer :: clr_Silver
      integer :: clr_DarkGray
      integer :: clr_Gray
      integer :: clr_LightSkyBlue
      integer :: clr_LightSkyGreen
      integer :: clr_SeaGreen
      integer :: clr_Tan
      integer :: clr_IndianRed
      integer :: clr_LightOliveGreen
      integer :: clr_CadetBlue
      integer :: clr_Beige




      integer, parameter :: max_generations = 3
      integer, parameter :: strlen = 256
      integer, parameter :: net_name_len = strlen
      integer, parameter :: name_len = 80           
      integer, parameter :: max_num_mixing_regions = 100
      integer, parameter :: maxlen_log_column_name = 80
      integer, parameter :: maxlen_profile_column_name = 80

      integer, parameter :: max_num_accretion_species = 50

      integer, parameter :: max_num_diffusion_classes = 20      
      
      integer, parameter :: num_xa_function = 9           
      integer, parameter :: num_mesh_logX = 9
      
      integer, parameter :: num_xa_central_limits = 9
      integer, parameter :: num_xa_surface_limits = 9
      integer, parameter :: num_xa_average_limits = 9
      
      integer, parameter :: terminal_iounit = 6

      integer, parameter :: max_num_profile_mass_points = 10

      integer, parameter :: max_num_profile_extras = 10

      integer, parameter :: num_x_ctrls = 100
      
      real(dp), parameter :: lnd_offset = 0   !100


      type star_info
         
         include "star_data.dek"
   
         ! handles
            integer :: eos_handle
            integer :: other_eos_handle
            integer :: kap_handle
            integer :: other_kap_handle
            integer :: net_handle
               
         ! star id
            integer :: id ! unique identifier for each star_info instance
         
         ! private
            integer :: retry_cnt
            integer :: dbg_control
            logical :: do_struct_hydro, do_struct_thermo, do_burn, do_mix
            integer :: burn_decsol_option, hydro_decsol_option
            integer :: burn_solver_option1, burn_solver_option2
            integer :: extra_terminal_iounit
            ! parameters for create pre ms -- set in run_star before calling star_create_pre_ms_model
            real(dp) :: pre_ms_T_c, pre_ms_guess_rho_c, &
               pre_ms_d_log10_P, pre_ms_logT_surf_limit, pre_ms_logP_surf_limit
            integer :: pre_ms_initial_zfracs, pre_ms_relax_num_steps
            logical :: in_use
            
         ! controls
            include "star_controls.dek"
            include "pgstar_controls.dek"
         
      end type star_info
      
      
      !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
      
      ! values for result_reason
      integer, parameter :: result_reason_normal = 1
      integer, parameter :: dt_is_zero = 2 
         ! indicates that t+dt == t, perhaps because of round-off with tiny dt.
      integer, parameter :: nonzero_ierr = 3 ! some routine returned with ierr /= 0
      integer, parameter :: hydro_failed_to_converge = 4
      integer, parameter :: do_burn_failed = 5
      integer, parameter :: diffusion_failed = 6
      integer, parameter :: too_many_steps_for_burn = 7
      integer, parameter :: too_many_steps_for_diffusion = 8
      integer, parameter :: too_many_steps_for_hydro = 9
      integer, parameter :: adjust_mesh_failed = 10
      integer, parameter :: adjust_mass_failed = 11
      integer, parameter :: core_dump_model_number = 12
      integer, parameter :: timestep_limits = 13
      integer, parameter :: variable_change_limits = 14
      
      integer, parameter :: num_reasons = 14
      
      character (len=32) :: result_reason_str(num_reasons)


      integer, parameter :: max_star_handles = 10 ! this can be increased as necessary
      type (star_info), target, save :: star_handles(max_star_handles) 
         ! gfortran seems to require "save" here.  at least it did once upon a time.
         
         
      character (len=256) :: data_dir_for_mesa, rate_tables_dir_for_star, rates_cache_suffix_for_star
         



      ! debugging storage
      integer, parameter :: max_ndbg = 9


      contains


      subroutine get_star_ptr(id,s,ierr)
         use alert_lib, only : alert
         integer, intent(in) :: id
         type (star_info), pointer :: s
         integer, intent(out) :: ierr         
         if (id < 1 .or. id > max_star_handles) then
            ierr = -1
            call alert(ierr,'invalid star handle')
            return
         end if
         s => star_handles(id)
         ierr = 0
      end subroutine get_star_ptr
      
      
      subroutine result_reason_init         
         result_reason_str(result_reason_normal) = 'normal'
         result_reason_str(dt_is_zero) = 'dt_is_zero'
         result_reason_str(nonzero_ierr) = 'nonzero_ierr'
         result_reason_str(hydro_failed_to_converge) = 'hydro_failed_to_converge'
         result_reason_str(do_burn_failed) = 'do_burn_failed'
         result_reason_str(diffusion_failed) = 'element_diffusion_failed'
         result_reason_str(too_many_steps_for_burn) = 'too_many_steps_for_burn'
         result_reason_str(too_many_steps_for_diffusion) = 'too_many_steps_for_diffusion'
         result_reason_str(too_many_steps_for_hydro) = 'too_many_steps_for_hydro'
         result_reason_str(adjust_mesh_failed) = 'adjust_mesh_failed'
         result_reason_str(adjust_mass_failed) = 'adjust_mass_failed'
         result_reason_str(core_dump_model_number) = 'core_dump_model_number'
         result_reason_str(timestep_limits) = 'convergence problems'
         result_reason_str(variable_change_limits) = 'variable_change_limits'
      end subroutine result_reason_init

      
      end module star_def

