! ***********************************************************************
!
!   Copyright (C) 2010  Bill Paxton
!
!   MESA is free software; you can use it and/or modify
!   it under the combined terms and restrictions of the MESA MANIFESTO
!   and the GNU General Library Public License as published
!   by the Free Software Foundation; either version 2 of the License,
!   or (at your option) any later version.
!
!   You should have received a copy of the MESA MANIFESTO along with
!   this software; if not, it is available at the mesa website:
!   http://mesa.sourceforge.net/
!
!   MESA is distributed in the hope that it will be useful,
!   but WITHOUT ANY WARRANTY; without even the implied warranty of
!   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
!   See the GNU Library General Public License for more details.
!
!   You should have received a copy of the GNU Library General Public License
!   along with this software; if not, write to the Free Software
!   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
!
! ***********************************************************************

      module se_support

      use star_lib
      use star_def

      implicit none
      

      contains
      
      
      subroutine se_startup(s, id, restart, use_se_output, ierr)
         type (star_info), pointer :: s
         integer, intent(in) :: id
         logical, intent(in) :: restart, use_se_output
         integer, intent(out) :: ierr
         ierr = 0
      end subroutine se_startup
      
      
      integer function se_finish_step(s, id, use_se_output, &
            how_many_extra_log_columns, data_for_extra_log_columns, &
            how_many_extra_profile_columns, data_for_extra_profile_columns)
         type (star_info), pointer :: s
         integer, intent(in) :: id
         logical, intent(in) :: use_se_output
         interface
            include 'extra_log_cols.dek'
            include 'extra_profile_cols.dek'
         end interface
         se_finish_step = keep_going
      end function se_finish_step
      
      
      subroutine se_after_evolve(s, id, ierr)
         type (star_info), pointer :: s
         integer, intent(in) :: id
         integer, intent(out) :: ierr
         ierr = 0
      end subroutine se_after_evolve



      end module se_support
