! ***********************************************************************
!
!   Copyright (C) 2011  Bill Paxton
!
!   MESA is free software; you can use it and/or modify
!   it under the combined terms and restrictions of the MESA MANIFESTO
!   and the GNU General Library Public License as published
!   by the Free Software Foundation; either version 2 of the License,
!   or (at your option) any later version.
!
!   You should have received a copy of the MESA MANIFESTO along with
!   this software; if not, it is available at the mesa website:
!   http://mesa.sourceforge.net/
!
!   MESA is distributed in the hope that it will be useful,
!   but WITHOUT ANY WARRANTY; without even the implied warranty of
!   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
!   See the GNU Library General Public License for more details.
!
!   You should have received a copy of the GNU Library General Public License
!   along with this software; if not, write to the Free Software
!   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
!
! ***********************************************************************
 
      module mod_other_mlt
      
      ! you can add your own mlt_eval routine to replace the one in mesa/mlt/public/mlt_lib.
      ! here's how to do it.

      ! in your working copy of run_star_extras, replace 
      !      include 'standard_run_star_extras.dek'
      ! by the contents of the included file from star/public

      ! Don't make any edits to any of the files in star/public. 
      ! You do all of this in your private copy of run_star_extras.

      ! before doing anything else, make sure your working copy of run_star_extras works.
      ! edit the extras_controls routine 
      !      subroutine extras_controls(s, ierr)
      !         type (star_info), pointer :: s
      !         integer, intent(out) :: ierr
      !         ierr = 0
      ! 	       write(*,*) 'hello from extra_controls'
      !      end subroutine extras_controls

      ! then, in your work directory, do ./mk and ./rn to check that it is okay.
      ! assuming that worked, now edit extra_controls to set the procedure pointer to other_cgrav

      !      subroutine extras_controls(s, ierr)
      !         type (star_info), pointer :: s
      !         integer, intent(out) :: ierr
      !         ierr = 0
      ! 	       s% other_mlt => my_mlt_eval
      !      end subroutine extras_controls

      ! my_mlt_eval will be called if s% use_other_mlt is true         
         
         
      ! NOTE: if you'd like to have some inlist controls for your routine,
      ! you can use the x_ctrl array of real(dp) variables that is in &controls
      ! e.g., in the &controls inlist, you can set
      !     x_ctrl(1) = my_special_param
      ! then in your routine, you can access that by
      !     s% x_ctrl(1)
      ! of course before you can use s, you need to get it using the id argument.
      ! here's an example of how to do that -- add these lines at the start of your routine:
      !         use star_lib, only: star_ptr
      !         type (star_info), pointer :: s
      !         call star_ptr(id, s, ierr)
      !         if (ierr /= 0) then ! OOPS
      !            return
      !         end if
      ! 
      ! for integer control values, you can use x_integer_ctrl
      ! for logical control values, you can use x_logical_ctrl
      
      

      use star_def
      use mlt_def

      implicit none
      
            
      contains
      
      
      subroutine null_other_mlt(  &
            id, k, cgrav, m, r, T, rho, L, P, &
            chiRho, chiT, Cp, Cv, X, opacity, grada,  &
            gradmu, dlnmu_dlnT, dlnmu_dlnrho, grad_rho, grad_temp, &
            gradr_factor, use_Ledoux_criterion, gradL_composition_term, &
            alpha_semiconvection, thermo_haline_coeff, &
            mixing_length_alpha, alt_scale_height, thermohaline_option, &
            use_Henyey_MLT, Henyey_y_param, Henyey_nu_param, &
            max_convective_L, tau, &
            mixing_type, mlt_basics, mlt_partials, ierr)
         use mlt_lib, only: mlt_eval
         use mlt_def
         integer, intent(in) :: id ! id for star         
         integer, intent(in) :: k ! cell number or 0 if not for a particular cell         
         real(dp), intent(in) :: cgrav, m, r, T, Rho, L, P
         real(dp), intent(in) :: chiRho, chiT, Cp, Cv, X, opacity, grada, &
            gradmu, dlnmu_dlnT, dlnmu_dlnrho, grad_rho, grad_temp, gradr_factor
         logical, intent(in) :: use_Ledoux_criterion
         real(dp), intent(in) :: gradL_composition_term
         real(dp), intent(in) :: alpha_semiconvection, thermo_haline_coeff
         real(dp), intent(in) :: mixing_length_alpha
         logical, intent(in) :: alt_scale_height, use_Henyey_MLT
         character (len=*), intent(in) :: thermohaline_option 
         real(dp), intent(in) :: Henyey_y_param, Henyey_nu_param, max_convective_L, tau
         integer, intent(out) :: mixing_type ! none, convective, semiconvective, or salt finger
         real(dp), intent(out) :: mlt_basics(num_mlt_results)
         real(dp), intent(out) :: mlt_partials(num_mlt_partials,num_mlt_results)
            ! e.g., mlt_partials(mlt_dlnT,mlt_gradT) has partial wrt lnT of gradT
         integer, intent(out) :: ierr
         call mlt_eval(  &
            cgrav, m, r, T, rho, L, P, &
            chiRho, chiT, Cp, Cv, X, opacity, grada,  &
            gradmu, dlnmu_dlnT, dlnmu_dlnrho, grad_rho, grad_temp, &
            gradr_factor, use_Ledoux_criterion, gradL_composition_term, &
            alpha_semiconvection, thermo_haline_coeff, &
            mixing_length_alpha, alt_scale_height, thermohaline_option, &
            use_Henyey_MLT, Henyey_y_param, Henyey_nu_param, &
            max_convective_L, tau, &
            mixing_type, mlt_basics, mlt_partials, ierr)
      end subroutine null_other_mlt


      end module mod_other_mlt
      
      
      
      
