! ***********************************************************************
!
!   Copyright (C) 2010  Bill Paxton
!
!   MESA is free software; you can use it and/or modify
!   it under the combined terms and restrictions of the MESA MANIFESTO
!   and the GNU General Library Public License as published
!   by the Free Software Foundation; either version 2 of the License,
!   or (at your option) any later version.
!
!   You should have received a copy of the MESA MANIFESTO along with
!   this software; if not, it is available at the mesa website:
!   http://mesa.sourceforge.net/
!
!   MESA is distributed in the hope that it will be useful,
!   but WITHOUT ANY WARRANTY; without even the implied warranty of
!   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
!   See the GNU Library General Public License for more details.
!
!   You should have received a copy of the GNU Library General Public License
!   along with this software; if not, write to the Free Software
!   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
!
! ***********************************************************************
 
      module mod_other_cgrav
      
      
! you can add your own routine for use instead of the default_other_cgrav

! here's how to do it.

! in your working copy of run_star_extras, replace 
!      include 'standard_run_star_extras.dek'
! by the contents of the included file from star/public

! Don't make any edits to any of the files in star/public. 
! You do all of this in your private copy of run_star_extras.

! before doing anything else, let's make sure your working copy of run_star_extras works.
! edit the extras_controls routine 
!      subroutine extras_controls(s, ierr)
!         type (star_info), pointer :: s
!         integer, intent(out) :: ierr
!         ierr = 0
! 	       write(*,*) 'hello from extra_controls'
!      end subroutine extras_controls

! then, in your work directory, do ./mk and ./rn to check that it is okay.
! assuming that worked, now edit extra_controls to set the procedure pointer to other_cgrav

!      subroutine extras_controls(s, ierr)
!         type (star_info), pointer :: s
!         integer, intent(out) :: ierr
!         ierr = 0
! 	       s% other_cgrav => cgrav_routine
!      end subroutine extras_controls

!      subroutine cgrav_routine(id, ierr)
!         use const_def, only: standard_cgrav
!         integer, intent(in) :: id
!         integer, intent(out) :: ierr
!         type (star_info), pointer :: s
!         integer :: k
!         ierr = 0
!         call get_star_ptr(id, s, ierr)
!         if (ierr /= 0) return
!         s% cgrav(:) = standard_cgrav
!      end subroutine cgrav_routine



! change your profile_columns.list to include
! 	cgrav_factor

! then do ./mk and ./rn
! check a profile plot of cgrav_factor to make sure it is uniformly equal to one.

! now you are ready to change your cgrav_routine to do what you want.
         
         
      ! NOTE: if you'd like to have some inlist controls for your routine,
      ! you can use the x_ctrl array of real(dp) variables that is in &controls
      ! e.g., in the &controls inlist, you can set
      !     x_ctrl(1) = my_special_param
      ! then in your routine, you can access that by
      !     s% x_ctrl(1)
      ! of course before you can use s, you need to get it using the id argument.
      ! here's an example of how to do that -- add these lines at the start of your routine:
      !         use star_lib, only: star_ptr
      !         type (star_info), pointer :: s
      !         call star_ptr(id, s, ierr)
      !         if (ierr /= 0) then ! OOPS
      !            return
      !         end if
      ! 
      ! for integer control values, you can use x_integer_ctrl
      ! for logical control values, you can use x_logical_ctrl

      use star_def

      implicit none

      
      
      contains
      
      
      
      
      subroutine default_other_cgrav(id, ierr)
         use const_def, only: standard_cgrav
         integer, intent(in) :: id
         integer, intent(out) :: ierr
         type (star_info), pointer :: s
         integer :: k
         ierr = 0
         call get_star_ptr(id, s, ierr)
         if (ierr /= 0) return
         s% cgrav(:) = standard_cgrav
      end subroutine default_other_cgrav



      end module mod_other_cgrav
      
      
      
      
