! ***********************************************************************
!
!   Copyright (C) 2010  Bill Paxton
!
!   MESA is free software; you can use it and/or modify
!   it under the combined terms and restrictions of the MESA MANIFESTO
!   and the GNU General Library Public License as published
!   by the Free Software Foundation; either version 2 of the License,
!   or (at your option) any later version.
!
!   You should have received a copy of the MESA MANIFESTO along with
!   this software; if not, it is available at the mesa website:
!   http://mesa.sourceforge.net/
!
!   MESA is distributed in the hope that it will be useful,
!   but WITHOUT ANY WARRANTY; without even the implied warranty of
!   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
!   See the GNU Library General Public License for more details.
!
!   You should have received a copy of the GNU Library General Public License
!   along with this software; if not, write to the Free Software
!   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
!
! ***********************************************************************

      module star_private_def
      
      use star_def

      implicit none

   ! log column options

   ! don't change log number for column; only add or reuse discarded
   ! don't change log number for column; only add or reuse discarded
      integer, parameter :: l_model_number = 1
   ! don't change log number for column; only add or reuse discarded
      integer, parameter :: l_star_age = l_model_number + 1
   ! don't change log number for column; only add or reuse discarded
      integer, parameter :: l_star_mass = l_star_age + 1
   ! don't change log number for column; only add or reuse discarded
      integer, parameter :: l_delta_mass = l_star_mass + 1
   ! don't change log number for column; only add or reuse discarded
      integer, parameter :: l_log_xmstar = l_delta_mass + 1
   ! don't change log number for column; only add or reuse discarded
      integer, parameter :: l_star_mdot = l_log_xmstar + 1
   ! don't change log number for column; only add or reuse discarded
      integer, parameter :: l_log_abs_mdot = l_star_mdot + 1
   ! don't change log number for column; only add or reuse discarded
      integer, parameter :: l_time_step = l_log_abs_mdot + 1
   ! don't change log number for column; only add or reuse discarded
      integer, parameter :: l_e_thermal = l_time_step + 1
   ! don't change log number for column; only add or reuse discarded
      integer, parameter :: l_num_zones = l_e_thermal + 1
      
   ! don't change log number for column; only add or reuse discarded
      integer, parameter :: l_conv_mx1_top = l_num_zones + 1
   ! don't change log number for column; only add or reuse discarded
      integer, parameter :: l_conv_mx1_bot = l_conv_mx1_top + 1
   ! don't change log number for column; only add or reuse discarded
      integer, parameter :: l_conv_mx2_top = l_conv_mx1_bot + 1
   ! don't change log number for column; only add or reuse discarded
      integer, parameter :: l_conv_mx2_bot = l_conv_mx2_top + 1
   ! don't change log number for column; only add or reuse discarded
      integer, parameter :: l_mx1_top = l_conv_mx2_bot + 1
   ! don't change log number for column; only add or reuse discarded
      integer, parameter :: l_mx1_bot = l_mx1_top + 1
   ! don't change log number for column; only add or reuse discarded
      integer, parameter :: l_mx2_top = l_mx1_bot + 1
   ! don't change log number for column; only add or reuse discarded
      integer, parameter :: l_mx2_bot = l_mx2_top + 1
      
   ! don't change log number for column; only add or reuse discarded
      integer, parameter :: l_conv_mx1_top_r = l_mx2_bot + 1
   ! don't change log number for column; only add or reuse discarded
      integer, parameter :: l_conv_mx1_bot_r = l_conv_mx1_top_r + 1
   ! don't change log number for column; only add or reuse discarded
      integer, parameter :: l_conv_mx2_top_r = l_conv_mx1_bot_r + 1
   ! don't change log number for column; only add or reuse discarded
      integer, parameter :: l_conv_mx2_bot_r = l_conv_mx2_top_r + 1
   ! don't change log number for column; only add or reuse discarded
      integer, parameter :: l_mx1_top_r = l_conv_mx2_bot_r + 1
   ! don't change log number for column; only add or reuse discarded
      integer, parameter :: l_mx1_bot_r = l_mx1_top_r + 1
   ! don't change log number for column; only add or reuse discarded
      integer, parameter :: l_mx2_top_r = l_mx1_bot_r + 1
   ! don't change log number for column; only add or reuse discarded
      integer, parameter :: l_mx2_bot_r = l_mx2_top_r + 1
      
   ! don't change log number for column; only add or reuse discarded
      integer, parameter :: l_mixing_regions = l_mx2_bot_r + 1
   ! don't change log number for column; only add or reuse discarded
      integer, parameter :: l_epsnuc_M_1 = l_mixing_regions + 1
   ! don't change log number for column; only add or reuse discarded
      integer, parameter :: l_epsnuc_M_2 = l_epsnuc_M_1 + 1
   ! don't change log number for column; only add or reuse discarded
      integer, parameter :: l_epsnuc_M_3 = l_epsnuc_M_2 + 1
   ! don't change log number for column; only add or reuse discarded
      integer, parameter :: l_epsnuc_M_4 = l_epsnuc_M_3 + 1
   ! don't change log number for column; only add or reuse discarded
      integer, parameter :: l_epsnuc_M_5 = l_epsnuc_M_4 + 1
   ! don't change log number for column; only add or reuse discarded
      integer, parameter :: l_epsnuc_M_6 = l_epsnuc_M_5 + 1
   ! don't change log number for column; only add or reuse discarded
      integer, parameter :: l_epsnuc_M_7 = l_epsnuc_M_6 + 1
   ! don't change log number for column; only add or reuse discarded
      integer, parameter :: l_epsnuc_M_8 = l_epsnuc_M_7 + 1
   ! don't change log number for column; only add or reuse discarded
      integer, parameter :: l_burning_regions = l_epsnuc_M_8 + 1
   ! don't change log number for column; only add or reuse discarded
      integer, parameter :: l_h1_boundary_mass = l_burning_regions + 1
   ! don't change log number for column; only add or reuse discarded
      integer, parameter :: l_he4_boundary_mass = l_h1_boundary_mass + 1
   ! don't change log number for column; only add or reuse discarded
      integer, parameter :: l_power_h_burn = l_he4_boundary_mass + 1
   ! don't change log number for column; only add or reuse discarded
      integer, parameter :: l_power_he_burn = l_power_h_burn + 1
   ! don't change log number for column; only add or reuse discarded
      integer, parameter :: l_log_center_T = l_power_he_burn + 1
   ! don't change log number for column; only add or reuse discarded
      integer, parameter :: l_log_center_Rho = l_log_center_T + 1
   ! don't change log number for column; only add or reuse discarded
      integer, parameter :: l_center_mu = l_log_center_Rho + 1
   ! don't change log number for column; only add or reuse discarded
      integer, parameter :: l_center_ye = l_center_mu + 1
   ! don't change log number for column; only add or reuse discarded
      integer, parameter :: l_center_entropy = l_center_ye + 1
   ! don't change log number for column; only add or reuse discarded
      integer, parameter :: l_v_div_csound_surf = l_center_entropy + 1
   ! don't change log number for column; only add or reuse discarded
      integer, parameter :: l_surface_accel_div_grav = l_v_div_csound_surf + 1
   ! don't change log number for column; only add or reuse discarded
      integer, parameter :: l_log_dt = l_surface_accel_div_grav + 1
   ! don't change log number for column; only add or reuse discarded
      integer, parameter :: l_log_LH = l_log_dt + 1
   ! don't change log number for column; only add or reuse discarded
      integer, parameter :: l_log_LHe = l_log_LH + 1
   ! don't change log number for column; only add or reuse discarded
      integer, parameter :: l_luminosity = l_log_LHe + 1
   ! don't change log number for column; only add or reuse discarded
      integer, parameter :: l_log_L = l_luminosity + 1
   ! don't change log number for column; only add or reuse discarded
      integer, parameter :: l_log_LZ = l_log_L + 1
   ! don't change log number for column; only add or reuse discarded
      integer, parameter :: l_log_Lneu = l_log_LZ + 1
   ! don't change log number for column; only add or reuse discarded
      integer, parameter :: l_log_R_cm = l_log_Lneu + 1
   ! don't change log number for column; only add or reuse discarded
      integer, parameter :: l_radius_cm = l_log_R_cm + 1
   ! don't change log number for column; only add or reuse discarded
      integer, parameter :: l_radius = l_radius_cm + 1
   ! don't change log number for column; only add or reuse discarded
      integer, parameter :: l_log_R = l_radius + 1
   ! don't change log number for column; only add or reuse discarded
      integer, parameter :: l_log_Teff = l_log_R + 1
   ! don't change log number for column; only add or reuse discarded
      integer, parameter :: l_effective_T = l_log_Teff + 1
   ! don't change log number for column; only add or reuse discarded
      integer, parameter :: l_gravity = l_effective_T + 1
   ! don't change log number for column; only add or reuse discarded
      integer, parameter :: l_log_g = l_gravity + 1
   ! don't change log number for column; only add or reuse discarded
      integer, parameter :: l_log_L_div_Ledd = l_log_g + 1
   ! don't change log number for column; only add or reuse discarded
      integer, parameter :: l_num_retries = l_log_L_div_Ledd + 1
   ! don't change log number for column; only add or reuse discarded
      integer, parameter :: l_num_backups = l_num_retries + 1
   ! don't change log number for column; only add or reuse discarded
      integer, parameter :: l_h1_czb_mass = l_num_backups + 1
   ! don't change log number for column; only add or reuse discarded
      integer, parameter :: l_surf_c12_minus_o16 = l_h1_czb_mass + 1
   ! don't change log number for column; only add or reuse discarded
      integer, parameter :: l_surf_num_c12_div_num_o16 = l_surf_c12_minus_o16 + 1

   ! don't change log number for column; only add or reuse discarded
      integer, parameter :: l_min_Pgas_div_P = l_surf_num_c12_div_num_o16 + 1
      integer, parameter :: l_log_center_P = l_min_pgas_div_P + 1
   ! don't change log number for column; only add or reuse discarded
      integer, parameter :: l_center_eps_grav = l_log_center_P + 1
   ! don't change log number for column; only add or reuse discarded
      integer, parameter :: l_center_degeneracy = l_center_eps_grav + 1
   ! don't change log number for column; only add or reuse discarded
      integer, parameter :: l_center_gamma = l_center_degeneracy + 1
      
   ! don't change log number for column; only add or reuse discarded
      integer, parameter :: l_h1_boundary_radius = l_center_gamma + 1
   ! don't change log number for column; only add or reuse discarded
      integer, parameter :: l_h1_boundary_lgT = l_h1_boundary_radius + 1
   ! don't change log number for column; only add or reuse discarded
      integer, parameter :: l_h1_boundary_lgRho = l_h1_boundary_lgT + 1
   ! don't change log number for column; only add or reuse discarded
      integer, parameter :: l_h1_boundary_L = l_h1_boundary_lgRho + 1
   ! don't change log number for column; only add or reuse discarded
      integer, parameter :: l_h1_boundary_v = l_h1_boundary_L + 1
   ! don't change log number for column; only add or reuse discarded
      integer, parameter :: l_h1_bdy_to_phot_sound_time = l_h1_boundary_v + 1
      
   ! don't change log number for column; only add or reuse discarded
      integer, parameter :: l_he4_boundary_radius = l_h1_bdy_to_phot_sound_time + 1
   ! don't change log number for column; only add or reuse discarded
      integer, parameter :: l_he4_boundary_lgT = l_he4_boundary_radius + 1
   ! don't change log number for column; only add or reuse discarded
      integer, parameter :: l_he4_boundary_lgRho = l_he4_boundary_lgT + 1
   ! don't change log number for column; only add or reuse discarded
      integer, parameter :: l_he4_boundary_L = l_he4_boundary_lgRho + 1
   ! don't change log number for column; only add or reuse discarded
      integer, parameter :: l_he4_boundary_v = l_he4_boundary_L + 1
   ! don't change log number for column; only add or reuse discarded
      integer, parameter :: l_he4_bdy_to_phot_sound_time = l_he4_boundary_v + 1
      
   ! don't change log number for column; only add or reuse discarded
      integer, parameter :: l_c12_boundary_mass = l_he4_bdy_to_phot_sound_time + 1
   ! don't change log number for column; only add or reuse discarded
      integer, parameter :: l_c12_boundary_radius = l_c12_boundary_mass + 1
   ! don't change log number for column; only add or reuse discarded
      integer, parameter :: l_c12_boundary_lgT = l_c12_boundary_radius + 1
   ! don't change log number for column; only add or reuse discarded
      integer, parameter :: l_c12_boundary_lgRho = l_c12_boundary_lgT + 1
   ! don't change log number for column; only add or reuse discarded
      integer, parameter :: l_c12_boundary_L = l_c12_boundary_lgRho + 1
   ! don't change log number for column; only add or reuse discarded
      integer, parameter :: l_c12_boundary_v = l_c12_boundary_L + 1
   ! don't change log number for column; only add or reuse discarded
      integer, parameter :: l_c12_bdy_to_phot_sound_time = l_c12_boundary_v + 1
      
   ! don't change log number for column; only add or reuse discarded
      integer, parameter :: l_envelope_mass = l_c12_bdy_to_phot_sound_time + 1
   ! don't change log number for column; only add or reuse discarded
      integer, parameter :: l_envelope_fraction_left = l_envelope_mass + 1
      
   ! don't change log number for column; only add or reuse discarded
      integer, parameter :: l_tau10_mass = l_envelope_fraction_left + 1
   ! don't change log number for column; only add or reuse discarded
      integer, parameter :: l_tau10_radius = l_tau10_mass + 1
   ! don't change log number for column; only add or reuse discarded
      integer, parameter :: l_tau10_lgP = l_tau10_radius + 1
   ! don't change log number for column; only add or reuse discarded
      integer, parameter :: l_tau10_T = l_tau10_lgP + 1
   ! don't change log number for column; only add or reuse discarded
      integer, parameter :: l_tau10_lgT = l_tau10_T + 1
   ! don't change log number for column; only add or reuse discarded
      integer, parameter :: l_tau10_lgRho = l_tau10_lgT + 1
   ! don't change log number for column; only add or reuse discarded
      integer, parameter :: l_tau10_L = l_tau10_lgRho + 1
   ! don't change log number for column; only add or reuse discarded
      integer, parameter :: l_tau100_mass = l_tau10_L + 1
   ! don't change log number for column; only add or reuse discarded
      integer, parameter :: l_tau100_radius = l_tau100_mass + 1
   ! don't change log number for column; only add or reuse discarded
      integer, parameter :: l_tau100_lgP = l_tau100_radius + 1
   ! don't change log number for column; only add or reuse discarded
      integer, parameter :: l_tau100_T = l_tau100_lgP + 1
   ! don't change log number for column; only add or reuse discarded
      integer, parameter :: l_tau100_lgT = l_tau100_T + 1
   ! don't change log number for column; only add or reuse discarded
      integer, parameter :: l_tau100_lgRho = l_tau100_lgT + 1
   ! don't change log number for column; only add or reuse discarded
      integer, parameter :: l_tau100_L = l_tau100_lgRho + 1
   ! don't change log number for column; only add or reuse discarded
      integer, parameter :: l_dynamic_timescale = l_tau100_L + 1
   ! don't change log number for column; only add or reuse discarded
      integer, parameter :: l_kh_timescale = l_dynamic_timescale + 1
   ! don't change log number for column; only add or reuse discarded
      integer, parameter :: l_nuc_timescale = l_kh_timescale + 1 
   ! don't change log number for column; only add or reuse discarded
      integer, parameter :: l_log_abs_Lgrav = l_nuc_timescale + 1 
   ! don't change log number for column; only add or reuse discarded
      integer, parameter :: l_eps_grav_integral = l_log_abs_Lgrav + 1 
   ! don't change log number for column; only add or reuse discarded
      integer, parameter :: l_log_extra_L = l_eps_grav_integral + 1 
   ! don't change log number for column; only add or reuse discarded
      integer, parameter :: l_extra_L = l_log_extra_L + 1 
   ! don't change log number for column; only add or reuse discarded
      integer, parameter :: l_log_Lnuc = l_extra_L + 1 
   ! don't change log number for column; only add or reuse discarded
      integer, parameter :: l_mass_ext_to_max_eps_nuc = l_log_Lnuc + 1 
   ! don't change log number for column; only add or reuse discarded
      integer, parameter :: l_mass_loc_of_max_eps_nuc = l_mass_ext_to_max_eps_nuc + 1 
         
   ! don't change log number for column; only add or reuse discarded
      integer, parameter :: l_trace_mass_location = l_mass_loc_of_max_eps_nuc + 1 
   ! don't change log number for column; only add or reuse discarded
      integer, parameter :: l_trace_mass_radius = l_trace_mass_location + 1 
   ! don't change log number for column; only add or reuse discarded
      integer, parameter :: l_trace_mass_lgT = l_trace_mass_radius + 1 
   ! don't change log number for column; only add or reuse discarded
      integer, parameter :: l_trace_mass_lgRho = l_trace_mass_lgT + 1 
   ! don't change log number for column; only add or reuse discarded
      integer, parameter :: l_trace_mass_L = l_trace_mass_lgRho + 1 
   ! don't change log number for column; only add or reuse discarded
      integer, parameter :: l_trace_mass_v = l_trace_mass_L + 1 
         
   ! don't change log number for column; only add or reuse discarded
      integer, parameter :: l_max_T_mass = l_trace_mass_v + 1 
   ! don't change log number for column; only add or reuse discarded
      integer, parameter :: l_max_T_radius = l_max_T_mass + 1 
   ! don't change log number for column; only add or reuse discarded
      integer, parameter :: l_max_T_lgT = l_max_T_radius + 1 
   ! don't change log number for column; only add or reuse discarded
      integer, parameter :: l_max_T_lgRho = l_max_T_lgT + 1 
   ! don't change log number for column; only add or reuse discarded
      integer, parameter :: l_max_T_L = l_max_T_lgRho + 1 
   ! don't change log number for column; only add or reuse discarded
      integer, parameter :: l_max_T_eps_nuc = l_max_T_L + 1 
      
   ! don't change log number for column; only add or reuse discarded
      integer, parameter :: l_max_eps_h = l_max_T_eps_nuc + 1
   ! don't change log number for column; only add or reuse discarded
      integer, parameter :: l_max_eps_h_lgT = l_max_eps_h + 1
   ! don't change log number for column; only add or reuse discarded
      integer, parameter :: l_max_eps_h_lgRho = l_max_eps_h_lgT + 1
   ! don't change log number for column; only add or reuse discarded
      integer, parameter :: l_max_eps_h_m = l_max_eps_h_lgRho + 1
   ! don't change log number for column; only add or reuse discarded
      integer, parameter :: l_max_eps_h_xm = l_max_eps_h_m + 1
   ! don't change log number for column; only add or reuse discarded
      integer, parameter :: l_max_eps_h_lgR = l_max_eps_h_xm + 1
   ! don't change log number for column; only add or reuse discarded
      integer, parameter :: l_max_eps_h_lgP = l_max_eps_h_lgR + 1
   ! don't change log number for column; only add or reuse discarded
      integer, parameter :: l_max_eps_h_opacity = l_max_eps_h_lgP + 1
      
   ! don't change log number for column; only add or reuse discarded
      integer, parameter :: l_max_eps_he = l_max_eps_h_opacity + 1
   ! don't change log number for column; only add or reuse discarded
      integer, parameter :: l_max_eps_he_lgT = l_max_eps_he + 1
   ! don't change log number for column; only add or reuse discarded
      integer, parameter :: l_max_eps_he_lgRho = l_max_eps_he_lgT + 1
   ! don't change log number for column; only add or reuse discarded
      integer, parameter :: l_max_eps_he_m = l_max_eps_he_lgRho + 1
   ! don't change log number for column; only add or reuse discarded
      integer, parameter :: l_max_eps_he_xm = l_max_eps_he_m + 1
   ! don't change log number for column; only add or reuse discarded
      integer, parameter :: l_max_eps_he_lgR = l_max_eps_he_xm + 1
   ! don't change log number for column; only add or reuse discarded
      integer, parameter :: l_max_eps_he_lgP = l_max_eps_he_lgR + 1
   ! don't change log number for column; only add or reuse discarded
      integer, parameter :: l_max_eps_he_opacity = l_max_eps_he_lgP + 1
      
   ! don't change log number for column; only add or reuse discarded
      integer, parameter :: l_max_eps_z = l_max_eps_he_opacity + 1
   ! don't change log number for column; only add or reuse discarded
      integer, parameter :: l_max_eps_z_lgT = l_max_eps_z + 1
   ! don't change log number for column; only add or reuse discarded
      integer, parameter :: l_max_eps_z_lgRho = l_max_eps_z_lgT + 1
   ! don't change log number for column; only add or reuse discarded
      integer, parameter :: l_max_eps_z_m = l_max_eps_z_lgRho + 1
   ! don't change log number for column; only add or reuse discarded
      integer, parameter :: l_max_eps_z_xm = l_max_eps_z_m + 1
   ! don't change log number for column; only add or reuse discarded
      integer, parameter :: l_max_eps_z_lgR = l_max_eps_z_xm + 1
   ! don't change log number for column; only add or reuse discarded
      integer, parameter :: l_max_eps_z_lgP = l_max_eps_z_lgR + 1
   ! don't change log number for column; only add or reuse discarded
      integer, parameter :: l_max_eps_z_opacity = l_max_eps_z_lgP + 1

   ! don't change log number for column; only add or reuse discarded
      integer, parameter :: l_max_eps_nuc = l_max_eps_z_opacity + 1
   ! don't change log number for column; only add or reuse discarded
      integer, parameter :: l_max_eps_nuc_lgT = l_max_eps_nuc + 1
   ! don't change log number for column; only add or reuse discarded
      integer, parameter :: l_max_eps_nuc_lgRho = l_max_eps_nuc_lgT + 1
   ! don't change log number for column; only add or reuse discarded
      integer, parameter :: l_max_eps_nuc_m = l_max_eps_nuc_lgRho + 1
   ! don't change log number for column; only add or reuse discarded
      integer, parameter :: l_max_eps_nuc_xm = l_max_eps_nuc_m + 1
   ! don't change log number for column; only add or reuse discarded
      integer, parameter :: l_max_eps_nuc_lgR = l_max_eps_nuc_xm + 1
   ! don't change log number for column; only add or reuse discarded
      integer, parameter :: l_max_eps_nuc_lgP = l_max_eps_nuc_lgR + 1
   ! don't change log number for column; only add or reuse discarded
      integer, parameter :: l_max_eps_nuc_opacity = l_max_eps_nuc_lgP + 1
   ! don't change log number for column; only add or reuse discarded
      integer, parameter :: l_max_eps_nuc_cp = l_max_eps_nuc_opacity + 1
   ! don't change log number for column; only add or reuse discarded
      integer, parameter :: l_max_eps_nuc_csound = l_max_eps_nuc_cp + 1
   ! don't change log number for column; only add or reuse discarded
      integer, parameter :: l_max_eps_nuc_pi_r_div_cs = l_max_eps_nuc_csound + 1
   ! don't change log number for column; only add or reuse discarded
      integer, parameter :: l_max_eps_nuc_H = l_max_eps_nuc_pi_r_div_cs + 1
   ! don't change log number for column; only add or reuse discarded
      integer, parameter :: l_max_eps_nuc_H_div_cs = l_max_eps_nuc_H + 1
   ! don't change log number for column; only add or reuse discarded
      integer, parameter :: l_max_eps_nuc_t_heat = l_max_eps_nuc_H_div_cs + 1

   ! don't change log number for column; only add or reuse discarded
   
      integer, parameter :: l_max_conv_vel_div_csound = l_max_eps_nuc_t_heat + 1
      
   ! don't change log number for column; only add or reuse discarded
      integer, parameter :: l_dt_Courant = l_max_conv_vel_div_csound + 1
   ! don't change log number for column; only add or reuse discarded
      integer, parameter :: l_log_dt_Courant = l_dt_Courant + 1
   ! don't change log number for column; only add or reuse discarded
      integer, parameter :: l_dt_Courant_yr = l_log_dt_Courant + 1
   ! don't change log number for column; only add or reuse discarded
      integer, parameter :: l_log_dt_Courant_yr = l_dt_Courant_yr + 1
   ! don't change log number for column; only add or reuse discarded
      integer, parameter :: l_dt_div_dt_Courant = l_log_dt_Courant_yr + 1
   ! don't change log number for column; only add or reuse discarded
      integer, parameter :: l_log_dt_div_dt_Courant = l_dt_div_dt_Courant + 1
      
   ! don't change log number for column; only add or reuse discarded
      integer, parameter :: l_log_surf_opacity = l_log_dt_div_dt_Courant + 1
   ! don't change log number for column; only add or reuse discarded
      integer, parameter :: l_log_surf_density = l_log_surf_opacity + 1
   ! don't change log number for column; only add or reuse discarded
      integer, parameter :: l_log_surf_pressure = l_log_surf_density + 1
   ! don't change log number for column; only add or reuse discarded
      integer, parameter :: l_surface_temperature = l_log_surf_pressure + 1
   ! don't change log number for column; only add or reuse discarded
      integer, parameter :: l_log_surf_temperature = l_surface_temperature + 1
   ! don't change log number for column; only add or reuse discarded
      integer, parameter :: l_surface_optical_depth = l_log_surf_temperature + 1
   ! don't change log number for column; only add or reuse discarded
      integer, parameter :: l_log_surf_optical_depth = l_surface_optical_depth + 1
   ! don't change log number for column; only add or reuse discarded
      integer, parameter :: l_log_surf_z = l_log_surf_optical_depth + 1
   ! don't change log number for column; only add or reuse discarded
      integer, parameter :: l_log_Ledd = l_log_surf_z + 1
   ! don't change log number for column; only add or reuse discarded
      integer, parameter :: l_iron_core_infall = l_log_Ledd + 1

   ! don't change log number for column; only add or reuse discarded
      integer, parameter :: l_cz_mass = l_iron_core_infall + 1
   ! don't change log number for column; only add or reuse discarded
      integer, parameter :: l_cz_log_xmsun = l_cz_mass + 1
   ! don't change log number for column; only add or reuse discarded
      integer, parameter :: l_cz_xm = l_cz_log_xmsun + 1
   ! don't change log number for column; only add or reuse discarded
      integer, parameter :: l_cz_log_xmass = l_cz_xm + 1
   ! don't change log number for column; only add or reuse discarded
      integer, parameter :: l_cz_logT = l_cz_log_xmass + 1
   ! don't change log number for column; only add or reuse discarded
      integer, parameter :: l_cz_logRho = l_cz_logT + 1
   ! don't change log number for column; only add or reuse discarded
      integer, parameter :: l_cz_logP = l_cz_logRho + 1
   ! don't change log number for column; only add or reuse discarded
      integer, parameter :: l_cz_log_column_depth = l_cz_logP + 1
   ! don't change log number for column; only add or reuse discarded
      integer, parameter :: l_cz_log_radial_depth = l_cz_log_column_depth + 1
   ! don't change log number for column; only add or reuse discarded
      integer, parameter :: l_cz_radius = l_cz_log_radial_depth + 1
   ! don't change log number for column; only add or reuse discarded
      integer, parameter :: l_cz_csound = l_cz_radius + 1
   ! don't change log number for column; only add or reuse discarded
      integer, parameter :: l_cz_scale_height = l_cz_csound + 1
   ! don't change log number for column; only add or reuse discarded
      integer, parameter :: l_cz_grav = l_cz_scale_height + 1
   ! don't change log number for column; only add or reuse discarded
      integer, parameter :: l_cz_log_eps_nuc = l_cz_grav + 1
   ! don't change log number for column; only add or reuse discarded
      integer, parameter :: l_cz_t_heat = l_cz_log_eps_nuc + 1
   ! don't change log number for column; only add or reuse discarded
      integer, parameter :: l_cz_eta = l_cz_t_heat + 1
      
   ! don't change log number for column; only add or reuse discarded
      integer, parameter :: l_cz_log_tau = l_cz_eta + 1
   ! don't change log number for column; only add or reuse discarded
      integer, parameter :: l_cz_opacity = l_cz_log_tau + 1
   ! don't change log number for column; only add or reuse discarded
      integer, parameter :: l_cz_luminosity = l_cz_opacity + 1
   ! don't change log number for column; only add or reuse discarded
      integer, parameter :: l_cz_zone = l_cz_luminosity + 1
   ! don't change log number for column; only add or reuse discarded
      integer, parameter :: l_cz_omega = l_cz_zone + 1
   ! don't change log number for column; only add or reuse discarded
      integer, parameter :: l_cz_omega_div_omega_crit = l_cz_omega + 1

   ! don't change log number for column; only add or reuse discarded
      integer, parameter :: l_cz_top_mass = l_cz_omega_div_omega_crit + 1
   ! don't change log number for column; only add or reuse discarded
      integer, parameter :: l_cz_top_log_xmsun = l_cz_top_mass + 1
   ! don't change log number for column; only add or reuse discarded
      integer, parameter :: l_cz_top_xm = l_cz_top_log_xmsun + 1
   ! don't change log number for column; only add or reuse discarded
      integer, parameter :: l_cz_top_log_xmass = l_cz_top_xm + 1
   ! don't change log number for column; only add or reuse discarded
      integer, parameter :: l_cz_top_logT = l_cz_top_log_xmass + 1
   ! don't change log number for column; only add or reuse discarded
      integer, parameter :: l_cz_top_logRho = l_cz_top_logT + 1
   ! don't change log number for column; only add or reuse discarded
      integer, parameter :: l_cz_top_logP = l_cz_top_logRho + 1
   ! don't change log number for column; only add or reuse discarded
      integer, parameter :: l_cz_top_log_column_depth = l_cz_top_logP + 1
   ! don't change log number for column; only add or reuse discarded
      integer, parameter :: l_cz_top_log_radial_depth = l_cz_top_log_column_depth + 1
   ! don't change log number for column; only add or reuse discarded
      integer, parameter :: l_cz_top_radius = l_cz_top_log_radial_depth + 1
   ! don't change log number for column; only add or reuse discarded
      integer, parameter :: l_cz_top_csound = l_cz_top_radius + 1
   ! don't change log number for column; only add or reuse discarded
      integer, parameter :: l_cz_top_scale_height = l_cz_top_csound + 1
   ! don't change log number for column; only add or reuse discarded
      integer, parameter :: l_cz_top_grav = l_cz_top_scale_height + 1
   ! don't change log number for column; only add or reuse discarded
      integer, parameter :: l_cz_top_log_eps_nuc = l_cz_top_grav + 1
   ! don't change log number for column; only add or reuse discarded
      integer, parameter :: l_cz_top_t_heat = l_cz_top_log_eps_nuc + 1
   ! don't change log number for column; only add or reuse discarded
      integer, parameter :: l_cz_top_eta = l_cz_top_t_heat + 1
      
   ! don't change log number for column; only add or reuse discarded
      integer, parameter :: l_cz_top_log_tau = l_cz_top_eta + 1
   ! don't change log number for column; only add or reuse discarded
      integer, parameter :: l_cz_top_opacity = l_cz_top_log_tau + 1
   ! don't change log number for column; only add or reuse discarded
      integer, parameter :: l_cz_top_luminosity = l_cz_top_opacity + 1
   ! don't change log number for column; only add or reuse discarded
      integer, parameter :: l_cz_top_zone = l_cz_top_luminosity + 1
   ! don't change log number for column; only add or reuse discarded
      integer, parameter :: l_cz_top_omega = l_cz_top_zone + 1
   ! don't change log number for column; only add or reuse discarded
      integer, parameter :: l_cz_top_omega_div_omega_crit = l_cz_top_omega + 1

   ! don't change log number for column; only add or reuse discarded
      integer, parameter :: l_trace_mass_omega = l_cz_top_omega_div_omega_crit + 1
   ! don't change log number for column; only add or reuse discarded
      integer, parameter :: l_trace_mass_omega_div_omega_crit = l_trace_mass_omega + 1

   ! don't change log number for column; only add or reuse discarded
      integer, parameter :: l_h1_bdy_omega = l_trace_mass_omega_div_omega_crit + 1
   ! don't change log number for column; only add or reuse discarded
      integer, parameter :: l_h1_bdy_omega_div_omega_crit = l_h1_bdy_omega + 1
   ! don't change log number for column; only add or reuse discarded
      integer, parameter :: l_he4_bdy_omega = l_h1_bdy_omega_div_omega_crit + 1
   ! don't change log number for column; only add or reuse discarded
      integer, parameter :: l_he4_bdy_omega_div_omega_crit = l_he4_bdy_omega + 1
   ! don't change log number for column; only add or reuse discarded
      integer, parameter :: l_c12_bdy_omega = l_he4_bdy_omega_div_omega_crit + 1
   ! don't change log number for column; only add or reuse discarded
      integer, parameter :: l_c12_bdy_omega_div_omega_crit = l_c12_bdy_omega + 1
   ! don't change log number for column; only add or reuse discarded
      integer, parameter :: l_surf_omega_crit = l_c12_bdy_omega_div_omega_crit + 1
      integer, parameter :: l_surf_omega = l_surf_omega_crit + 1
   ! don't change log number for column; only add or reuse discarded
      integer, parameter :: l_log_rotational_mdot_boost = l_surf_omega + 1
   ! don't change log number for column; only add or reuse discarded
      integer, parameter :: l_surf_v_crit = l_log_rotational_mdot_boost + 1
   ! don't change log number for column; only add or reuse discarded
      integer, parameter :: l_surf_v_rot = l_surf_v_crit + 1
   ! don't change log number for column; only add or reuse discarded
      integer, parameter :: l_surf_omega_div_omega_crit = l_surf_v_rot + 1
   ! don't change log number for column; only add or reuse discarded
      integer, parameter :: l_center_omega = l_surf_omega_div_omega_crit + 1
   ! don't change log number for column; only add or reuse discarded
      integer, parameter :: l_surf_r_equitorial_div_r = l_center_omega + 1
      integer, parameter :: l_surf_r_polar_div_r = l_surf_r_equitorial_div_r + 1
      integer, parameter :: l_center_omega_div_omega_crit = l_surf_r_polar_div_r + 1

   ! don't change log number for column; only add or reuse discarded
      integer, parameter :: l_log_total_angular_momentum = l_center_omega_div_omega_crit + 1

   ! don't change log number for column; only add or reuse discarded
      integer, parameter :: l_min_t_eddy = l_log_total_angular_momentum + 1
   ! don't change log number for column; only add or reuse discarded
      integer, parameter :: l_elapsed_time = l_min_t_eddy + 1      
   ! don't change log number for column; only add or reuse discarded
      integer, parameter :: l_num_jacobians = l_elapsed_time + 1
   ! don't change log number for column; only add or reuse discarded
      integer, parameter :: l_total_num_jacobians = l_num_jacobians + 1
      
      integer, parameter :: l_photosphere_L = l_total_num_jacobians + 1
      integer, parameter :: l_photosphere_r = l_photosphere_L + 1


      integer, parameter :: l_delta_nu = l_photosphere_r + 1
      integer, parameter :: l_delta_Pg = l_delta_nu + 1
      integer, parameter :: l_nu_max = l_delta_Pg + 1
      integer, parameter :: l_acoustic_cutoff = l_nu_max + 1
      integer, parameter :: l_gs_per_delta_nu = l_acoustic_cutoff + 1
      integer, parameter :: l_ng_for_nu_max = l_gs_per_delta_nu + 1
      integer, parameter :: l_log_delta_Pg = l_ng_for_nu_max + 1
      integer, parameter :: l_nu_max_3_4th_div_delta_nu = l_log_delta_Pg + 1

      integer, parameter :: l_int_k_r_dr_nu_max_Sl1 = l_nu_max_3_4th_div_delta_nu + 1
      integer, parameter :: l_int_k_r_dr_2pt0_nu_max_Sl1 = l_int_k_r_dr_nu_max_Sl1 + 1
      integer, parameter :: l_int_k_r_dr_0pt5_nu_max_Sl1 = l_int_k_r_dr_2pt0_nu_max_Sl1 + 1

      integer, parameter :: l_int_k_r_dr_nu_max_Sl2 = l_int_k_r_dr_0pt5_nu_max_Sl1 + 1
      integer, parameter :: l_int_k_r_dr_2pt0_nu_max_Sl2 = l_int_k_r_dr_nu_max_Sl2 + 1
      integer, parameter :: l_int_k_r_dr_0pt5_nu_max_Sl2 = l_int_k_r_dr_2pt0_nu_max_Sl2 + 1

      integer, parameter :: l_int_k_r_dr_nu_max_Sl3 = l_int_k_r_dr_0pt5_nu_max_Sl2 + 1
      integer, parameter :: l_int_k_r_dr_2pt0_nu_max_Sl3 = l_int_k_r_dr_nu_max_Sl3 + 1
      integer, parameter :: l_int_k_r_dr_0pt5_nu_max_Sl3 = l_int_k_r_dr_2pt0_nu_max_Sl3 + 1
      
      integer, parameter :: l_log_Lnuc_sub_log_L = l_int_k_r_dr_0pt5_nu_max_Sl3 + 1
      integer, parameter :: l_cz_top_zone_logdq = l_log_Lnuc_sub_log_L + 1

      integer, parameter :: l_op_split_diff = l_cz_top_zone_logdq + 1

      integer, parameter :: l_trace_mass_lgP = l_op_split_diff + 1
      integer, parameter :: l_trace_mass_g = l_trace_mass_lgP + 1
      integer, parameter :: l_trace_mass_X = l_trace_mass_g + 1
      integer, parameter :: l_trace_mass_Y = l_trace_mass_X + 1
      integer, parameter :: l_trace_mass_edv_H = l_trace_mass_Y + 1
      integer, parameter :: l_trace_mass_edv_He = l_trace_mass_edv_H + 1
      integer, parameter :: l_trace_mass_scale_height = l_trace_mass_edv_He + 1
      integer, parameter :: l_trace_mass_dlnX_dr = l_trace_mass_scale_height + 1
      integer, parameter :: l_trace_mass_dlnY_dr = l_trace_mass_dlnX_dr + 1
      integer, parameter :: l_trace_mass_dlnRho_dr = l_trace_mass_dlnY_dr + 1

      integer, parameter :: l_seulex_rows = l_trace_mass_dlnRho_dr + 1
      integer, parameter :: l_log_err_ratio_max = l_seulex_rows + 1
      integer, parameter :: l_log_err_ratio_avg = l_log_err_ratio_max + 1

      integer, parameter :: l_min_L = l_log_err_ratio_avg + 1
      integer, parameter :: l_offset_FL = l_min_L + 1
      
   ! don't change log number for column; only add or reuse discarded
      integer, parameter :: l_col_id_max = l_offset_FL
      
      character (len=maxlen_log_column_name) :: log_column_name(l_col_id_max)
      type (integer_dict), pointer :: log_column_names_dict
      
      
      
   ! profile column options

      ! abundances -- names from chem_Name array in chem_def
      ! nuclear reaction eps - names from reaction_Name array in rates_def
      ! nuclear reaction category eps - names from category_name array in net_def
      ! items specified in another file - include 'filename'
      ! star_data items from the following list

      integer, parameter :: p_zone = 1
      integer, parameter :: p_log_Lrad_div_Ledd = p_zone + 1
      integer, parameter :: p_log_Lrad_div_L = p_log_Lrad_div_Ledd + 1
      integer, parameter :: p_log_Lrad = p_log_Lrad_div_L + 1
      integer, parameter :: p_luminosity_conv = p_log_Lrad + 1
      integer, parameter :: p_lum_conv_div_lum_Edd = p_luminosity_conv + 1
      integer, parameter :: p_lum_rad_div_lum_Edd = p_lum_conv_div_lum_Edd + 1
      integer, parameter :: p_lum_rad_div_L = p_lum_rad_div_lum_Edd + 1
      integer, parameter :: p_lum_conv_div_L = p_lum_rad_div_L + 1
      integer, parameter :: p_lum_conv_div_lum_rad = p_lum_conv_div_L + 1
      integer, parameter :: p_luminosity_rad = p_lum_conv_div_lum_rad + 1
      integer, parameter :: p_luminosity = p_luminosity_rad + 1
      integer, parameter :: p_grav = p_luminosity + 1
      integer, parameter :: p_r_div_g = p_grav + 1
      integer, parameter :: p_g_div_r = p_r_div_g + 1
      integer, parameter :: p_net_nuclear_energy = p_g_div_r + 1
      integer, parameter :: p_net_energy = p_net_nuclear_energy + 1
      integer, parameter :: p_logL = p_net_energy + 1
      integer, parameter :: p_log_Ledd = p_logL + 1
      integer, parameter :: p_log_L_div_Ledd = p_log_Ledd + 1
      integer, parameter :: p_signed_log_power = p_log_L_div_Ledd + 1
      integer, parameter :: p_velocity = p_signed_log_power + 1
      integer, parameter :: p_rmid = p_velocity + 1
      integer, parameter :: p_radius = p_rmid + 1
      integer, parameter :: p_logR = p_radius + 1
      integer, parameter :: p_q = p_logR + 1
      integer, parameter :: p_dq = p_q + 1
      
      integer, parameter :: p_avg_charge_H = p_dq + 1
      integer, parameter :: p_avg_charge_He = p_avg_charge_H + 1
      integer, parameter :: p_avg_charge_C = p_avg_charge_He + 1
      integer, parameter :: p_avg_charge_N = p_avg_charge_C + 1
      integer, parameter :: p_avg_charge_O = p_avg_charge_N + 1
      integer, parameter :: p_avg_charge_Ne = p_avg_charge_O + 1
      integer, parameter :: p_avg_charge_Mg = p_avg_charge_Ne + 1
      integer, parameter :: p_avg_charge_Si = p_avg_charge_Mg + 1
      integer, parameter :: p_avg_charge_Fe = p_avg_charge_Si + 1
      
      integer, parameter :: p_neutral_fraction_H = p_avg_charge_Fe + 1
      integer, parameter :: p_neutral_fraction_He = p_neutral_fraction_H + 1
      integer, parameter :: p_neutral_fraction_C = p_neutral_fraction_He + 1
      integer, parameter :: p_neutral_fraction_N = p_neutral_fraction_C + 1
      integer, parameter :: p_neutral_fraction_O = p_neutral_fraction_N + 1
      integer, parameter :: p_neutral_fraction_Ne = p_neutral_fraction_O + 1
      integer, parameter :: p_neutral_fraction_Mg = p_neutral_fraction_Ne + 1
      integer, parameter :: p_neutral_fraction_Si = p_neutral_fraction_Mg + 1
      integer, parameter :: p_neutral_fraction_Fe = p_neutral_fraction_Si + 1
      
      integer, parameter :: p_lum_rad_div_lum_Edd_sub_fourPrad_div_PchiT = p_neutral_fraction_Fe + 1
      integer, parameter :: p_fourPrad_div_PchiT = p_lum_rad_div_lum_Edd_sub_fourPrad_div_PchiT + 1
      integer, parameter :: p_pturbulence_div_ptotal = p_fourPrad_div_PchiT + 1
      integer, parameter :: p_pgas_div_ptotal = p_pturbulence_div_ptotal + 1
      integer, parameter :: p_mass = p_pgas_div_ptotal + 1
      integer, parameter :: p_mmid = p_mass + 1
      integer, parameter :: p_xm = p_mmid + 1
      integer, parameter :: p_logxq = p_xm + 1
      integer, parameter :: p_logxm = p_logxq + 1
      
      integer, parameter :: p_log_radial_depth = p_logxm + 1
      integer, parameter :: p_log_column_depth = p_log_radial_depth + 1
      integer, parameter :: p_r_div_R = p_log_column_depth + 1
      integer, parameter :: p_dr = p_r_div_R + 1
      integer, parameter :: p_log_dr = p_dr + 1
      integer, parameter :: p_dr_div_cs = p_log_dr + 1
      integer, parameter :: p_log_dr_div_cs = p_dr_div_cs + 1
      integer, parameter :: p_dr_div_cs_yr = p_log_dr_div_cs + 1
      integer, parameter :: p_log_dr_div_cs_yr = p_dr_div_cs_yr + 1

      integer, parameter :: p_acoustic_radius = p_log_dr_div_cs_yr + 1
      integer, parameter :: p_acoustic_r_div_R_phot = p_acoustic_radius + 1
      
      integer, parameter :: p_grav_gr_factor = p_acoustic_r_div_R_phot + 1
      integer, parameter :: p_log_grav_gr_factor = p_grav_gr_factor + 1
      
      integer, parameter :: p_gr_mass_excess = p_log_grav_gr_factor + 1
      integer, parameter :: p_gr_time_excess = p_gr_mass_excess + 1
      integer, parameter :: p_gr_space_excess = p_gr_time_excess + 1
      integer, parameter :: p_gr_enthalpy_excess = p_gr_space_excess + 1

      integer, parameter :: p_x = p_gr_enthalpy_excess + 1
      integer, parameter :: p_log_x = p_x + 1
      integer, parameter :: p_y = p_log_x + 1
      integer, parameter :: p_log_y = p_y + 1
      integer, parameter :: p_z = p_log_y + 1
      integer, parameter :: p_log_z = p_z + 1
      
      integer, parameter :: p_logdq = p_log_z + 1
      integer, parameter :: p_dq_ratio = p_logdq + 1
      integer, parameter :: p_tau = p_dq_ratio + 1
      integer, parameter :: p_log_opacity = p_tau + 1
      integer, parameter :: p_energy = p_log_opacity + 1
      integer, parameter :: p_logM = p_energy + 1
      integer, parameter :: p_logtau = p_logM + 1
      integer, parameter :: p_temperature = p_logtau + 1
      integer, parameter :: p_logT = p_temperature + 1
      integer, parameter :: p_rho = p_logT + 1
      integer, parameter :: p_logRho = p_rho + 1
      integer, parameter :: p_pgas = p_logRho+ 1
      integer, parameter :: p_logPgas = p_pgas + 1
      integer, parameter :: p_prad = p_logPgas + 1
      integer, parameter :: p_pressure = p_prad + 1
      integer, parameter :: p_logP = p_pressure + 1
      integer, parameter :: p_logE = p_logP + 1
      integer, parameter :: p_grada = p_logE + 1
      integer, parameter :: p_dE_dRho = p_grada + 1
      integer, parameter :: p_cv = p_dE_dRho + 1
      integer, parameter :: p_cp = p_cv + 1
      integer, parameter :: p_logS = p_cp + 1
      integer, parameter :: p_logS_per_baryon = p_logS + 1
      integer, parameter :: p_gamma1 = p_logS_per_baryon + 1
      integer, parameter :: p_gamma3 = p_gamma1 + 1
      integer, parameter :: p_eta = p_gamma3 + 1
      integer, parameter :: p_theta_e = p_eta + 1
      integer, parameter :: p_gam = p_theta_e + 1
      integer, parameter :: p_mu = p_gam + 1
      integer, parameter :: p_v_div_r = p_mu + 1
      integer, parameter :: p_v_div_csound = p_v_div_r + 1
      integer, parameter :: p_csound_at_face = p_v_div_csound + 1
      integer, parameter :: p_csound = p_csound_at_face + 1
      integer, parameter :: p_scale_height = p_csound + 1

      integer, parameter :: p_omega = p_scale_height + 1
      integer, parameter :: p_log_omega = p_omega + 1
      integer, parameter :: p_log_j_rot = p_log_omega + 1
      integer, parameter :: p_log_J_inside = p_log_j_rot + 1
      integer, parameter :: p_log_J_div_M53 = p_log_J_inside + 1
      integer, parameter :: p_log_abs_shear = p_log_J_div_M53 + 1
      integer, parameter :: p_shear = p_log_abs_shear + 1
      integer, parameter :: p_i_rot = p_shear + 1
      integer, parameter :: p_j_rot = p_i_rot + 1
      integer, parameter :: p_v_rot = p_j_rot + 1
      integer, parameter :: p_fp_rot = p_v_rot + 1
      integer, parameter :: p_ft_rot = p_fp_rot + 1
      integer, parameter :: p_log_am_nu = p_ft_rot + 1

      integer, parameter :: p_r_polar = p_log_am_nu + 1
      integer, parameter :: p_log_r_polar = p_r_polar + 1
      integer, parameter :: p_r_equitorial = p_log_r_polar + 1
      integer, parameter :: p_log_r_equitorial = p_r_equitorial + 1
      integer, parameter :: p_r_e_div_r_p = p_log_r_equitorial + 1

      integer, parameter :: p_omega_crit = p_r_e_div_r_p + 1
      integer, parameter :: p_omega_div_omega_crit = p_omega_crit + 1

      integer, parameter :: p_am_log_sig = p_omega_div_omega_crit + 1
      integer, parameter :: p_am_domega_dlnR = p_am_log_sig + 1
      integer, parameter :: p_am_log_D_DSI = p_am_domega_dlnR + 1
      integer, parameter :: p_am_log_D_SH = p_am_log_D_DSI + 1
      integer, parameter :: p_am_log_D_SSI = p_am_log_D_SH + 1
      integer, parameter :: p_am_log_D_ES = p_am_log_D_SSI + 1
      integer, parameter :: p_am_log_D_GSF = p_am_log_D_ES + 1
      integer, parameter :: p_am_log_D_ST = p_am_log_D_GSF + 1
      integer, parameter :: p_am_log_nu_ST = p_am_log_D_ST + 1

      integer, parameter :: p_dynamo_log_B_r = p_am_log_nu_ST + 1
      integer, parameter :: p_dynamo_log_B_phi = p_dynamo_log_B_r + 1

      integer, parameter :: p_gradr_sub_grada = p_dynamo_log_B_phi + 1
      integer, parameter :: p_entropy = p_gradr_sub_grada + 1
      integer, parameter :: p_free_e = p_entropy + 1
      integer, parameter :: p_logfree_e = p_free_e + 1
      integer, parameter :: p_dlnRho_dlnT_const_Pgas = p_logfree_e + 1
      integer, parameter :: p_dlnRho_dlnPgas_const_T = p_dlnRho_dlnT_const_Pgas + 1
      integer, parameter :: p_chiRho = p_dlnRho_dlnPgas_const_T + 1
      integer, parameter :: p_chiT = p_chiRho + 1
      integer, parameter :: p_abar = p_chiT + 1
      integer, parameter :: p_zbar = p_abar + 1
      integer, parameter :: p_z2bar = p_zbar + 1
      integer, parameter :: p_ye = p_z2bar + 1

      integer, parameter :: p_dkap_dlnrho_at_face = p_ye + 1
      integer, parameter :: p_dkap_dlnt_at_face = p_dkap_dlnrho_at_face + 1
      integer, parameter :: p_opacity = p_dkap_dlnt_at_face + 1

      integer, parameter :: p_deps_dlnd_at_face = p_opacity + 1
      integer, parameter :: p_deps_dlnT_at_face = p_deps_dlnd_at_face + 1
      integer, parameter :: p_d_epsnuc_dlnd = p_deps_dlnT_at_face + 1
      integer, parameter :: p_d_lnepsnuc_dlnd = p_d_epsnuc_dlnd + 1
      integer, parameter :: p_d_lnepsnuc_dlnT = p_d_lnepsnuc_dlnd + 1
      integer, parameter :: p_d_epsnuc_dlnT = p_d_lnepsnuc_dlnT + 1
      integer, parameter :: p_eps_nuc = p_d_epsnuc_dlnT + 1

      integer, parameter :: p_eps_nuc_neu_total = p_eps_nuc + 1
      integer, parameter :: p_non_nuc_neu = p_eps_nuc_neu_total + 1
      integer, parameter :: p_nonnucneu_plas = p_non_nuc_neu + 1
      integer, parameter :: p_nonnucneu_brem = p_nonnucneu_plas + 1
      integer, parameter :: p_nonnucneu_phot = p_nonnucneu_brem + 1
      integer, parameter :: p_nonnucneu_pair = p_nonnucneu_phot + 1
      integer, parameter :: p_nonnucneu_reco = p_nonnucneu_pair + 1
      integer, parameter :: p_log_irradiation_heat = p_nonnucneu_reco + 1
      integer, parameter :: p_cgrav_factor = p_log_irradiation_heat + 1
      integer, parameter :: p_log_extra_L = p_cgrav_factor + 1
      integer, parameter :: p_extra_L = p_log_extra_L + 1
      integer, parameter :: p_extra_heat = p_extra_L + 1
      integer, parameter :: p_logPvisc = p_extra_heat + 1
      integer, parameter :: p_rp_div_GMrho_face = p_logPvisc + 1
      integer, parameter :: p_env_eps_grav = p_rp_div_GMrho_face + 1
      integer, parameter :: p_eps_grav = p_env_eps_grav + 1
      integer, parameter :: p_signed_log_eps_grav = p_eps_grav + 1
      integer, parameter :: p_mlt_Zeta = p_signed_log_eps_grav + 1
      integer, parameter :: p_mlt_Gamma = p_mlt_Zeta + 1
      integer, parameter :: p_mlt_mixing_length = p_mlt_Gamma + 1
      
      integer, parameter :: p_mlt_mixing_type = p_mlt_mixing_length + 1
      integer, parameter :: p_gradT_sub_grada = p_mlt_mixing_type + 1
      integer, parameter :: p_super_ad = p_gradT_sub_grada + 1
      
      integer, parameter :: p_log_D_conv = p_super_ad + 1
      integer, parameter :: p_log_D_semi = p_log_D_conv + 1
      integer, parameter :: p_log_D_ovr = p_log_D_semi + 1
      integer, parameter :: p_log_D_th = p_log_D_ovr + 1
      
      integer, parameter :: p_log_D_mix_non_rotation = p_log_D_th + 1
      integer, parameter :: p_log_sig_mix = p_log_D_mix_non_rotation + 1
      integer, parameter :: p_log_sig_div_siglim = p_log_sig_mix + 1
      integer, parameter :: p_log_D_mix = p_log_sig_div_siglim + 1
      integer, parameter :: p_log_conv_vel_frac_current = p_log_D_mix + 1
      integer, parameter :: p_log_conv_vel = p_log_conv_vel_frac_current + 1
      integer, parameter :: p_newly_nonconvective = p_log_conv_vel + 1
      integer, parameter :: p_conv_vel_div_L_vel = p_newly_nonconvective + 1
      integer, parameter :: p_conv_vel_div_csound = p_conv_vel_div_L_vel + 1
      integer, parameter :: p_conv_dP_term = p_conv_vel_div_csound + 1
      integer, parameter :: p_mixing_type = p_conv_dP_term + 1
      integer, parameter :: p_conv_mixing_type = p_mixing_type + 1

      integer, parameter :: p_log_mlt_D_mix = p_conv_mixing_type + 1
      integer, parameter :: p_pressure_scale_height = p_log_mlt_D_mix + 1

      integer, parameter :: p_gradT = p_pressure_scale_height + 1
      integer, parameter :: p_gradr = p_gradT + 1
      integer, parameter :: p_dlnP_dm = p_gradr + 1
      integer, parameter :: p_dlnT_dm = p_dlnP_dm + 1

      integer, parameter :: p_dlnP_dlnm = p_dlnT_dm + 1
      integer, parameter :: p_dlnT_dlnm = p_dlnP_dlnm + 1

      integer, parameter :: p_dL_dm = p_dlnT_dlnm + 1
      integer, parameter :: p_accel_div_grav = p_dL_dm + 1
      
      integer, parameter :: p_dlnPgas_dt = p_accel_div_grav + 1
      integer, parameter :: p_dlnE_var_dt = p_dlnPgas_dt + 1
      integer, parameter :: p_lnddot = p_dlnE_var_dt + 1
      integer, parameter :: p_dlnd_dt = p_lnddot + 1
      integer, parameter :: p_lnTdot = p_dlnd_dt + 1
      integer, parameter :: p_dlnT_dt = p_lnTdot + 1
      integer, parameter :: p_dlnR_dt = p_dlnT_dt + 1
      
      integer, parameter :: p_signed_dlnd = p_dlnR_dt + 1
      integer, parameter :: p_signed_dlnT = p_signed_dlnd + 1
      
      integer, parameter :: p_dv_dt = p_signed_dlnT + 1
      integer, parameter :: p_cno_div_z = p_dv_dt + 1

      integer, parameter :: p_delta_r = p_cno_div_z + 1
      integer, parameter :: p_delta_v = p_delta_r + 1
      integer, parameter :: p_dt_dv_div_dr = p_delta_v + 1

      integer, parameter :: p_dlnH1_dlnP = p_dt_dv_div_dr + 1
      integer, parameter :: p_dlnHe3_dlnP = p_dlnH1_dlnP + 1
      integer, parameter :: p_dlnHe4_dlnP = p_dlnHe3_dlnP + 1
      integer, parameter :: p_dlnC12_dlnP = p_dlnHe4_dlnP + 1
      integer, parameter :: p_dlnC13_dlnP = p_dlnC12_dlnP + 1
      integer, parameter :: p_dlnN14_dlnP = p_dlnC13_dlnP + 1
      integer, parameter :: p_dlnO16_dlnP = p_dlnN14_dlnP + 1
      integer, parameter :: p_dlnNe20_dlnP = p_dlnO16_dlnP + 1
      integer, parameter :: p_dlnMg24_dlnP = p_dlnNe20_dlnP + 1
      integer, parameter :: p_dlnSi28_dlnP = p_dlnMg24_dlnP + 1

      integer, parameter :: p_dlog_pp_dlogP = p_dlnSi28_dlnP + 1
      integer, parameter :: p_dlog_cno_dlogP = p_dlog_pp_dlogP + 1
      integer, parameter :: p_dlog_3alf_dlogP = p_dlog_cno_dlogP + 1
         
      integer, parameter :: p_dlog_burn_c_dlogP = p_dlog_3alf_dlogP + 1
      integer, parameter :: p_dlog_burn_n_dlogP = p_dlog_burn_c_dlogP + 1
      integer, parameter :: p_dlog_burn_o_dlogP = p_dlog_burn_n_dlogP + 1
         
      integer, parameter :: p_dlog_burn_ne_dlogP = p_dlog_burn_o_dlogP + 1
      integer, parameter :: p_dlog_burn_na_dlogP = p_dlog_burn_ne_dlogP + 1
      integer, parameter :: p_dlog_burn_mg_dlogP = p_dlog_burn_na_dlogP + 1
         
      integer, parameter :: p_dlog_cc_dlogP = p_dlog_burn_mg_dlogP + 1
      integer, parameter :: p_dlog_co_dlogP = p_dlog_cc_dlogP + 1
      integer, parameter :: p_dlog_oo_dlogP = p_dlog_co_dlogP + 1
         
      integer, parameter :: p_dlog_burn_si_dlogP = p_dlog_oo_dlogP + 1
      integer, parameter :: p_dlog_burn_s_dlogP = p_dlog_burn_si_dlogP + 1
      integer, parameter :: p_dlog_burn_ar_dlogP = p_dlog_burn_s_dlogP + 1
      integer, parameter :: p_dlog_burn_ca_dlogP = p_dlog_burn_ar_dlogP + 1
      integer, parameter :: p_dlog_burn_ti_dlogP = p_dlog_burn_ca_dlogP + 1
      integer, parameter :: p_dlog_burn_cr_dlogP = p_dlog_burn_ti_dlogP + 1
      integer, parameter :: p_dlog_burn_fe_dlogP = p_dlog_burn_cr_dlogP + 1
         
      integer, parameter :: p_dlog_pnhe4_dlogP = p_dlog_burn_fe_dlogP + 1
      integer, parameter :: p_dlog_photo_dlogP = p_dlog_pnhe4_dlogP + 1
      integer, parameter :: p_dlog_other_dlogP = p_dlog_photo_dlogP + 1

      integer, parameter :: p_dlnX_dr = p_dlog_other_dlogP + 1
      integer, parameter :: p_dlnY_dr = p_dlnX_dr + 1
      integer, parameter :: p_dlnRho_dr = p_dlnY_dr + 1
      
      integer, parameter :: p_logQ = p_dlnRho_dr + 1
      integer, parameter :: p_log_mdot_cs = p_logQ + 1
      integer, parameter :: p_log_mdot_v = p_log_mdot_cs + 1
      integer, parameter :: p_log_L_div_CpTMdot = p_log_mdot_v + 1
      integer, parameter :: p_cs_at_cell_bdy = p_log_L_div_CpTMdot + 1
      
      integer, parameter :: p_binding_energy_integral = p_cs_at_cell_bdy + 1
      integer, parameter :: p_binding_energy = p_binding_energy_integral + 1
      
      integer, parameter :: p_gradL = p_binding_energy + 1
      integer, parameter :: p_gradL_composition_term = p_gradL + 1
      integer, parameter :: p_sch_stable = p_gradL_composition_term + 1
      integer, parameter :: p_ledoux_stable = p_sch_stable + 1
      integer, parameter :: p_stability_type = p_ledoux_stable + 1
      integer, parameter :: p_grad_density = p_stability_type + 1
      integer, parameter :: p_grad_temperature = p_grad_density + 1
      
      integer, parameter :: p_mu_alt = p_grad_temperature + 1
      
      integer, parameter :: p_dlnmu_X = p_mu_alt + 1
      integer, parameter :: p_gradmu_X = p_dlnmu_X + 1

      integer, parameter :: p_gradmu_alt = p_gradmu_X + 1
      integer, parameter :: p_gradmu = p_gradmu_alt + 1
      
      integer, parameter :: p_gradr_for_mixing = p_gradmu + 1
      integer, parameter :: p_gradL_for_mixing = p_gradr_for_mixing + 1
      integer, parameter :: p_gradT_for_mixing = p_gradL_for_mixing + 1
      integer, parameter :: p_grada_for_mixing = p_gradT_for_mixing + 1

      integer, parameter :: p_gradL_comp_for_mixing = p_grada_for_mixing + 1
      integer, parameter :: p_gradmu_for_mixing = p_gradL_comp_for_mixing + 1
      integer, parameter :: p_gradmu_alt_for_mixing = p_gradmu_for_mixing + 1
      integer, parameter :: p_gradmu_X_for_mixing = p_gradmu_alt_for_mixing + 1

      integer, parameter :: p_brunt_g_r_div_cs2 = p_gradmu_X_for_mixing + 1
      integer, parameter :: p_brunt_chiY = p_brunt_g_r_div_cs2 + 1
      integer, parameter :: p_brunt_dlnY_dlnP = p_brunt_chiY + 1
      integer, parameter :: p_brunt_nonB = p_brunt_dlnY_dlnP + 1
      integer, parameter :: p_brunt_B = p_brunt_nonB + 1
      integer, parameter :: p_brunt_dlnRho_dlnR = p_brunt_B + 1
      integer, parameter :: p_lamb_S2 = p_brunt_dlnRho_dlnR + 1
      integer, parameter :: p_lamb_S = p_lamb_S2 + 1
      integer, parameter :: p_lamb_Sl1 = p_lamb_S + 1
      integer, parameter :: p_lamb_Sl2 = p_lamb_Sl1 + 1
      integer, parameter :: p_lamb_Sl3 = p_lamb_Sl2 + 1
      integer, parameter :: p_sign_brunt_N2 = p_lamb_Sl3 + 1
      integer, parameter :: p_brunt_A = p_sign_brunt_N2 + 1
      
      integer, parameter :: p_brunt_N2 = p_brunt_A + 1
      integer, parameter :: p_brunt_N2_structure_term = p_brunt_N2 + 1
      integer, parameter :: p_brunt_N2_composition_term = p_brunt_N2_structure_term + 1
      
      integer, parameter :: p_log_brunt_N2_dimensionless = p_brunt_N2_composition_term + 1
      integer, parameter :: p_brunt_N2_dimensionless = p_log_brunt_N2_dimensionless + 1
      integer, parameter :: p_brunt_N_dimensionless = p_brunt_N2_dimensionless + 1
      integer, parameter :: p_brunt_N = p_brunt_N_dimensionless + 1
      integer, parameter :: p_brunt_frequency = p_brunt_N + 1
      integer, parameter :: p_log_brunt_N2 = p_brunt_frequency + 1
      integer, parameter :: p_log_brunt_N = p_log_brunt_N2 + 1
      integer, parameter :: p_brunt_N_div_r_integral = p_log_brunt_N + 1
      integer, parameter :: p_brunt_nu = p_brunt_N_div_r_integral + 1
      integer, parameter :: p_brunt_nu_structure_term = p_brunt_nu + 1
      integer, parameter :: p_brunt_nu_composition_term = p_brunt_nu_structure_term + 1
      integer, parameter :: p_log_brunt_nu = p_brunt_nu_composition_term + 1
      integer, parameter :: p_log_lamb_Sl1 = p_log_brunt_nu + 1
      integer, parameter :: p_log_lamb_Sl2 = p_log_lamb_Sl1 + 1
      integer, parameter :: p_log_lamb_Sl3 = p_log_lamb_Sl2 + 1
      integer, parameter :: p_log_lamb_Sl10 = p_log_lamb_Sl3 + 1      
      integer, parameter :: p_k_r_integral = p_log_lamb_Sl10 + 1      

      integer, parameter :: p_log_err_ratio_max = p_k_r_integral + 1      

      integer, parameter :: p_col_id_max = p_log_err_ratio_max
      
      character (len=maxlen_profile_column_name) :: profile_column_name(p_col_id_max)
      type (integer_dict), pointer :: profile_column_names_dict




      ! phases of evolution for logs and profiles
      integer, parameter :: phase_starting = 0
      integer, parameter :: phase_early_main_seq = 1
      integer, parameter :: phase_mid_main_seq = 2
      integer, parameter :: phase_wait_for_he = 3
      integer, parameter :: phase_he_ignition_over = 4
      integer, parameter :: phase_he_igniting = 5
      integer, parameter :: phase_helium_burning = 6
      integer, parameter :: phase_carbon_burning = 7
      
      ! time_step limit identifiers
      integer, parameter :: Tlim_struc = 1
      integer, parameter :: Tlim_num_jacobians = 2
      integer, parameter :: Tlim_num_diff_solver_steps = 3
      integer, parameter :: Tlim_dX = 4
      integer, parameter :: Tlim_dH = 5
      integer, parameter :: Tlim_dHe = 6
      integer, parameter :: Tlim_dH_div_H = 7
      integer, parameter :: Tlim_dHe_div_He = 8
      integer, parameter :: Tlim_dX_div_X = 9
      integer, parameter :: Tlim_dL_div_L = 10
      integer, parameter :: Tlim_dlgP = 11
      integer, parameter :: Tlim_dlgRho = 12
      integer, parameter :: Tlim_dlgT = 13
      integer, parameter :: Tlim_dlgR = 14
      integer, parameter :: Tlim_dlgL_nuc_cat = 15
      integer, parameter :: Tlim_dlgL_H = 16
      integer, parameter :: Tlim_dlgL_He = 17
      integer, parameter :: Tlim_d_deltaR_shrink = 18
      integer, parameter :: Tlim_dlgL_z = 19
      integer, parameter :: Tlim_dlgL_nuc = 20
      integer, parameter :: Tlim_dlgTeff = 21
      integer, parameter :: Tlim_dX_nuc = 22
      integer, parameter :: Tlim_dlgRho_cntr = 23
      integer, parameter :: Tlim_dlgT_cntr = 24
      integer, parameter :: Tlim_lg_XH_cntr = 25
      integer, parameter :: Tlim_dmstar = 26
      integer, parameter :: Tlim_lgL = 27
      integer, parameter :: Tlim_max_timestep = 28
      integer, parameter :: Tlim_timestep_hold = 29
      integer, parameter :: Tlim_lg_XHe_cntr = 30
      integer, parameter :: Tlim_L_div_CpTMdot = 31
      integer, parameter :: Tlim_dX_nuc_drop = 32
      integer, parameter :: Tlim_neg_X = 33
      integer, parameter :: Tlim_bad_Xsum = 34
      integer, parameter :: Tlim_deltaJ = 35
      integer, parameter :: Tlim_delta_HR = 36
      integer, parameter :: Tlim_dHe3 = 37
      integer, parameter :: Tlim_dHe3_div_He3 = 38
      integer, parameter :: Tlim_op_split = 39
      integer, parameter :: Tlim_d_deltaR_grow = 40
      
      integer, parameter :: numTlim = 40
      
      character (len=14) :: dt_why_str(numTlim) ! indicates the reson for the timestep choice
      character (len=100) :: dt_why_long_str(numTlim)
      
   


      contains


      subroutine star_private_def_init
         use num_def
         integer :: i         
         
         dt_why_str(Tlim_struc) = 'varcontrol'
         dt_why_str(Tlim_num_jacobians) = 'convergence'
         dt_why_str(Tlim_num_diff_solver_steps) = 'diff steps'
         dt_why_str(Tlim_dH) = 'dH'
         dt_why_str(Tlim_dHe) = 'dHe'
         dt_why_str(Tlim_dHe3) = 'dHe3'
         dt_why_str(Tlim_dX) = 'dX'
         dt_why_str(Tlim_dH_div_H) = 'dH/H'
         dt_why_str(Tlim_dHe_div_He) = 'dHe/He'
         dt_why_str(Tlim_dHe3_div_He3) = 'dHe3/He3'
         dt_why_str(Tlim_dX_div_X) = 'dX/X'
         dt_why_str(Tlim_dL_div_L) = 'dL/L'
         dt_why_str(Tlim_dlgP) = 'lgP'
         dt_why_str(Tlim_dlgRho) = 'lgRho'
         dt_why_str(Tlim_dlgT) = 'lgT'
         dt_why_str(Tlim_dlgR) = 'lgR'
         dt_why_str(Tlim_d_deltaR_shrink) = 'd_delR_shrink'
         dt_why_str(Tlim_d_deltaR_grow) = 'd_delR_grow'
         dt_why_str(Tlim_dlgL_nuc_cat) = 'Lnuc'
         dt_why_str(Tlim_dlgL_H) = 'Lnuc_H'
         dt_why_str(Tlim_dlgL_He) = 'Lnuc_He'
         dt_why_str(Tlim_dlgL_z) = 'Lnuc_z'
         dt_why_str(Tlim_dlgL_nuc) = 'Lnuc'
         dt_why_str(Tlim_dlgTeff) = 'lgTeff'
         dt_why_str(Tlim_dlgRho_cntr) = 'lgRho_cntr'
         dt_why_str(Tlim_dlgT_cntr) = 'lgT_cntr'
         dt_why_str(Tlim_lg_XH_cntr) = 'lg_XH_cntr'
         dt_why_str(Tlim_dmstar) = 'delta_mstar'
         dt_why_str(Tlim_deltaJ) = 'delta total J'
         dt_why_str(Tlim_lgL) = 'lgL'
         dt_why_str(Tlim_max_timestep) = 'max_dt'
         dt_why_str(Tlim_timestep_hold) = 'hold'
         dt_why_str(Tlim_dX_nuc) = 'dX_nuc'
         dt_why_str(Tlim_dX_nuc_drop) = 'dX_nuc_drop'
         dt_why_str(Tlim_lg_XHe_cntr) = 'lg_XHe_cntr'
         dt_why_str(Tlim_L_div_CpTMdot) = 'L_div_CpTMdot'
         dt_why_str(Tlim_neg_X) = 'neg_mass_frac'
         dt_why_str(Tlim_bad_Xsum) = 'bad_X_sum'
         dt_why_str(Tlim_delta_HR) = 'delta_HR'
         dt_why_str(Tlim_op_split) = 'op_split'
         
         dt_why_long_str(Tlim_struc) = &
            'excessive change in structure'
         dt_why_long_str(Tlim_num_jacobians) = &
            'excessive number of hydro solver steps required'
         dt_why_long_str(Tlim_num_diff_solver_steps) = &
            'excessive number of diffusion solver steps required'
         dt_why_long_str(Tlim_dX) = &
            'excessive change in mass fraction'
         dt_why_long_str(Tlim_dX_div_X) = &
            'excessive relative change in mass fraction'
         dt_why_long_str(Tlim_dL_div_L) = &
            'excessive relative change in luminosity at some grid point'
         dt_why_long_str(Tlim_dlgP) = &
            'excessive change in log pressure in some shell'
         dt_why_long_str(Tlim_dlgRho) = &
            'excessive change in log density in some shell'
         dt_why_long_str(Tlim_dlgT) = &
            'excessive change in log temperature in some shell'
         dt_why_long_str(Tlim_dlgR) = &
            'excessive change in log radius for some shell'
         dt_why_long_str(Tlim_d_deltaR_shrink) = &
            'excessive relative decrease in radial thickness for some shell'
         dt_why_long_str(Tlim_d_deltaR_grow) = &
            'excessive relative increase in radial thickness for some shell'
         dt_why_long_str(Tlim_dlgL_nuc_cat) = &
            'excessive change in log nuclear luminosity for some category (lg_Lnuc)'
         dt_why_long_str(Tlim_dlgL_H) = &
            'excessive change in log hydrogen burning luminosity (lg_Lnuc_H)'
         dt_why_long_str(Tlim_dlgL_He) = &
            'excessive change in log helium burning luminosity (lg_Lnuc_He)'
         dt_why_long_str(Tlim_dlgL_z) = &
            'excessive change in log heavy metals burning luminosity (lg_Lnuc_z)'
         dt_why_long_str(Tlim_dlgL_nuc) = &
            'excessive change in log nuclear burning luminosity (lg_Lnuc)'
         dt_why_long_str(Tlim_dlgTeff) = &
            'excessive change in log surface temperature (lg_Teff)'
         dt_why_long_str(Tlim_dlgRho_cntr) = &
            'excessive change in log density at center'
         dt_why_long_str(Tlim_dlgT_cntr) = &
            'excessive change in log temperature at center'
         dt_why_long_str(Tlim_lg_XH_cntr) = &
            'excessive change in center log10(hydrogen abundance)'
         dt_why_long_str(Tlim_dmstar) = &
            'excessive magnitude of change in lg(M/Msun)'
         dt_why_long_str(Tlim_deltaJ) = &
            'excessive magnitude of change in lg(total angular momentum)'
         dt_why_long_str(Tlim_lgL) = &
            'excessive magnitude of change lg(L/Lsun)'
         dt_why_long_str(Tlim_max_timestep) = &
            'reached max timestep limit'
         dt_why_long_str(Tlim_timestep_hold) = &
            'cannot increase timestep during hold period'
         dt_why_long_str(Tlim_dX_nuc) = &
            'exceeded dX_nuc limit on timestep'
         dt_why_long_str(Tlim_dX_nuc_drop) = &
            'exceeded dX_nuc_drop limit on timestep'
         dt_why_long_str(Tlim_lg_XHe_cntr) = &
            'excessive change in center log10(helium abundance)'
         dt_why_long_str(Tlim_L_div_CpTMdot) = &
            'L/(CpTMdot) exceeded limit in newly accreted mass'
         dt_why_long_str(Tlim_neg_X) = 'negative mass fraction'
         dt_why_long_str(Tlim_bad_Xsum) = 'bad sum of mass fractions'
         dt_why_long_str(Tlim_delta_HR) = 'exceeded limit on step size on HR diagram'
         dt_why_long_str(Tlim_op_split) = 'excessive difference for op split'
         
         do i=1,max_star_handles
            star_handles(i)% id = i
            star_handles(i)% in_use = .false.
         end do
         
      end subroutine star_private_def_init
      
      
      subroutine do_init_star_misc(s)
         type (star_info), pointer :: s
         
         s% doing_timing = .false.
         s% time_eos = 0
         s% time_kap = 0
         s% time_net = 0
         s% time_neu = 0
         s% time_do_mesh = 0
         s% time_do_mesh_plan = 0
         s% time_do_mesh_adjust = 0
         s% time_do_adjust_mass = 0
         s% time_do_report = 0
         s% time_next_timestep = 0
         s% time_write_profile = 0
         s% time_write_log = 0
         s% time_write_photo = 0
         s% time_pgstar = 0
         s% time_set_basic_vars = 0
         s% time_set_rotation_vars = 0
         s% time_set_mlt_vars = 0
         s% time_set_eqn_vars = 0
         s% time_eval_eqns = 0
         s% time_set_newton_vars = 0
         s% time_newton_mtx = 0
         s% time_newton_self = 0
         s% time_newton_test = 0
         s% time_solve_burn_in_net = 0
         s% time_solve_burn_non_net = 0
         s% time_solve_mix = 0
         s% time_op_split_control = 0
         s% time_check_model = 0

         s% time_newton_xscale = 0
         s% time_newton_eval_eqn = 0
         s% time_newton_size_equ = 0
         s% time_newton_size_B = 0
         s% time_newton_enter_setmatrix = 0

         s% time_prep_new_step = 0
         s% time_prep_new_try = 0
         s% time_prep_for_retry = 0
         s% time_do_winds = 0
         s% time_save_for_d_dt = 0
         s% time_diffusion = 0
         s% time_evolve_set_vars = 0
         s% time_save_pre_hydro = 0
         s% time_check_newly_non_conv = 0
         s% time_do_brunt = 0
         s% time_struct_burn_mix = 0
         
         s% time_total = 0
         
         s% status_profilename = ''
         s% model_profilename = ''
         s% most_recent_profile_filename = ''
         s% most_recent_photo_name = ''
         
         s% doing_flash_wind = .false.
         s% doing_rlo_wind = .false.
         s% doing_nova_wind = .false.

         s% phase_of_evolution = phase_starting
         s% recent_log_header = -1000
         s% post_he_age = -1d0
         s% profile_age = -1d0
         s% prev_cntr_rho = 1d99
         s% helium_ignition = .false.
         s% carbon_ignition = .false.
         
         s% tau_base = 2d0/3d0
         s% tau_factor = 1

         s% hydro_matrix_type = -1
         
         s% TP_state = 0
         s% have_done_TP = .false.

         s% num_jacobians = 0
         s% num_solves = 0
         s% num_backups = 0
         s% model_number_for_last_jacobian = 0
         s% number_of_backups_in_a_row = 0
         
         s% mesh_call_number = 0
         s% hydro_call_number = 0
         s% diffusion_call_number = 0
         s% model_number = 0
         
         s% boost_mlt_alfa = 0
         
         s% q_for_recently_added = 1d0
         s% k_below_recently_added = 1
         
         s% k_below_surface_radiative_zone = 1
         
         s% why_Tlim = Tlim_struc
         
         s% len_extra_iwork = 0
         s% len_extra_work = 0
         
         s% dbg_control = 0

      end subroutine do_init_star_misc
      

      
      integer function alloc_star(ierr)
         use alert_lib,only:alert
         use rates_def, only: rates_NACRE_if_available
         integer, intent(out) :: ierr
         integer :: i
         type (star_info), pointer :: s
         
         ierr = 0
         alloc_star = -1
!$omp critical (star_handle)
         do i = 1, max_star_handles
            if (.not. star_handles(i)% in_use) then
               star_handles(i)% in_use = .true.
               alloc_star = i
               exit
            end if
         end do
!$omp end critical (star_handle)
         if (alloc_star == -1) then
            ierr = -1
            call alert(ierr, 'no available star handle')
            return
         end if
         if (star_handles(alloc_star)% id /= alloc_star) then
            ierr = -1
            call alert(ierr, 'broken handle for star')
            return
         end if
         s => star_handles(alloc_star)
         
         ! initialize various things
         s% net_name = ''
         s% species = 0
         s% num_reactions = 0
         s% AF_dble => null()
         s% AF_quad => null()
         
         s% M_center = 0
         s% R_center = 0
         s% L_center = 0
         
         nullify(s% profile_column_spec)
         nullify(s% log_column_spec)
         
         s% num_conv_boundaries = 0
         nullify(s% conv_bdy_q)
         nullify(s% conv_bdy_loc)
         nullify(s% top_conv_bdy)
         
         s% num_mix_boundaries = 0
         nullify(s% mix_bdy_q)
         nullify(s% mix_bdy_loc)
         nullify(s% top_mix_bdy)
         
         nullify(s% burn_h_conv_region)
         nullify(s% burn_he_conv_region)
         nullify(s% burn_z_conv_region)
         
         call do_init_star_misc(s)
         
      end function alloc_star
      
      
      subroutine free_star(s)
         type (star_info), pointer :: s
         star_handles(s% id)% in_use = .false.
      end subroutine free_star
      
      
      subroutine stardata_init( &
            data_dir, chem_isotopes_filename, &
            kappa_file_prefix, kappa_CO_prefix, kappa_lowT_prefix, &
            kappa_blend_logT_upper_bdy, kappa_blend_logT_lower_bdy, other_kappa_file_prefix, &
            eos_file_prefix, other_eos_prefix, eosDT_Z1_suffix, eosPT_Z1_suffix, &
            net_reaction_filename, rate_tables_dir, rates_cache_suffix, &
            ionization_file_prefix, ionization_Z1_suffix, &
            ierr)
         use colors_lib
         use eos_lib
         use kap_lib
         use rates_lib, only: rates_init
         use net_lib, only: net_init
         use weak_lib, only: weak_init
         use reaclib_lib, only: reaclib_init
         use ionization_lib, only: ionization_init
         use atm_lib
         use chem_lib
         use alert_lib
         use const_lib
         character (len=*), intent(in) :: &
            data_dir, chem_isotopes_filename, net_reaction_filename, rate_tables_dir, &
            kappa_file_prefix, kappa_CO_prefix, kappa_lowT_prefix, &
            other_kappa_file_prefix, &
            eosDT_Z1_suffix, eosPT_Z1_suffix, &
            eos_file_prefix, other_eos_prefix, rates_cache_suffix, &
            ionization_file_prefix, ionization_Z1_suffix
         real(dp), intent(in) :: kappa_blend_logT_upper_bdy, kappa_blend_logT_lower_bdy
         integer, intent(out) :: ierr

         logical, parameter :: use_cache = .true.

         ierr = 0
         
         data_dir_for_mesa = data_dir
         rate_tables_dir_for_star = rate_tables_dir
         rates_cache_suffix_for_star = rates_cache_suffix
         
         call const_init
           
         call star_private_def_init
         call result_reason_init

         call log_column_names_init(ierr)
      	if (ierr /= 0) then
            call alert(ierr, 'failed in log_column_names_init')
            return
      	end if
         call profile_column_names_init(ierr)
      	if (ierr /= 0) then
            call alert(ierr, 'failed in profile_column_names_init')
            return
      	end if
         
         call chem_init(data_dir, chem_isotopes_filename, ierr)
      	if (ierr /= 0) then
            call alert(ierr, 'failed in chem_init')
            return
      	end if

         call colors_init(data_dir, ierr)
         if (ierr /= 0) then
            call alert(ierr, 'failed in colors_init')
            return
         end if
         
         call eos_init(data_dir, eos_file_prefix, use_cache, ierr)
         if (ierr /= 0) then
            call alert(ierr, 'failed in eos_init')
            return
         end if
         
         call set_eos_Z1_suffix(eosDT_Z1_suffix, eosPT_Z1_suffix) 
         
         call kap_init( &
            data_dir, kappa_file_prefix, kappa_CO_prefix, kappa_lowT_prefix, &
            kappa_blend_logT_upper_bdy, kappa_blend_logT_lower_bdy, use_cache, ierr)
         if (ierr /= 0) then
            call alert(ierr, 'failed in kap_init')
            return
         end if
   	
         call weak_init(data_dir, ierr)
         if (ierr /= 0) then
            call alert(ierr, 'failed in weak_init')
            return
         end if
         
         call reaclib_init(data_dir, ierr)   
         if (ierr /= 0) then
            call alert(ierr, 'failed in reaclib_init')
            return
         end if
         
         call rates_init(data_dir, net_reaction_filename, ierr)
         if (ierr /= 0) then
            call alert(ierr, 'failed in rates_init')
            return
         end if
                  
         call net_init(data_dir, ierr)
         if (ierr /= 0) then
            call alert(ierr, 'failed in net_init')
            return
         end if
         
         call atm_init(data_dir, use_cache, ierr)
         if (ierr /= 0) then
            call alert(ierr, 'failed in atm_init')
            return
         end if
         
         call ionization_init( &
            data_dir, ionization_file_prefix, ionization_Z1_suffix, use_cache, ierr)
         if (ierr /= 0) then
            call alert(ierr, 'failed in ionization_init')
            return
         end if
         
      end subroutine stardata_init


      
      
      subroutine log_column_names_init(ierr)
         use utils_lib, only: integer_dict_define
         integer, intent(out) :: ierr
         
         integer :: i, cnt
         ierr = 0
         cnt = 0
         log_column_name(:) = ''

         log_column_name(l_model_number) = 'model_number'
         log_column_name(l_star_age) = 'star_age'
         log_column_name(l_star_mass) = 'star_mass'
         log_column_name(l_log_xmstar) = 'log_xmstar'
         log_column_name(l_delta_mass) = 'delta_mass'
         log_column_name(l_star_mdot) = 'star_mdot'
         log_column_name(l_log_abs_mdot) = 'log_abs_mdot'
         log_column_name(l_time_step) = 'time_step'
         log_column_name(l_e_thermal) = 'e_thermal'
         log_column_name(l_num_zones) = 'num_zones'
         
         log_column_name(l_conv_mx1_top) = 'conv_mx1_top'
         log_column_name(l_conv_mx1_bot) = 'conv_mx1_bot'
         log_column_name(l_conv_mx2_top) = 'conv_mx2_top'
         log_column_name(l_conv_mx2_bot) = 'conv_mx2_bot'
         log_column_name(l_mx1_top) = 'mx1_top'
         log_column_name(l_mx1_bot) = 'mx1_bot'
         log_column_name(l_mx2_top) = 'mx2_top'
         log_column_name(l_mx2_bot) = 'mx2_bot'
         
         log_column_name(l_conv_mx1_top_r) = 'conv_mx1_top_r'
         log_column_name(l_conv_mx1_bot_r) = 'conv_mx1_bot_r'
         log_column_name(l_conv_mx2_top_r) = 'conv_mx2_top_r'
         log_column_name(l_conv_mx2_bot_r) = 'conv_mx2_bot_r'
         log_column_name(l_mx1_top_r) = 'mx1_top_r'
         log_column_name(l_mx1_bot_r) = 'mx1_bot_r'
         log_column_name(l_mx2_top_r) = 'mx2_top_r'
         log_column_name(l_mx2_bot_r) = 'mx2_bot_r'
         
         log_column_name(l_mixing_regions) = 'mixing_regions'
         log_column_name(l_epsnuc_M_1) = 'epsnuc_M_1'
         log_column_name(l_epsnuc_M_2) = 'epsnuc_M_2'
         log_column_name(l_epsnuc_M_3) = 'epsnuc_M_3'
         log_column_name(l_epsnuc_M_4) = 'epsnuc_M_4'
         log_column_name(l_epsnuc_M_5) = 'epsnuc_M_5'
         log_column_name(l_epsnuc_M_6) = 'epsnuc_M_6'
         log_column_name(l_epsnuc_M_7) = 'epsnuc_M_7'
         log_column_name(l_epsnuc_M_8) = 'epsnuc_M_8'
         log_column_name(l_burning_regions) = 'burning_regions'
         log_column_name(l_h1_boundary_mass) = 'h1_boundary_mass'
         log_column_name(l_he4_boundary_mass) = 'he4_boundary_mass'
         log_column_name(l_power_h_burn) = 'power_h_burn'
         log_column_name(l_power_he_burn) = 'power_he_burn'
         log_column_name(l_log_center_T) = 'log_center_T'
         log_column_name(l_log_center_Rho) = 'log_center_Rho'
         log_column_name(l_center_mu) = 'center_mu'
         log_column_name(l_center_ye) = 'center_ye'
         log_column_name(l_center_entropy) = 'center_entropy'
         log_column_name(l_iron_core_infall) = 'iron_core_infall'
         log_column_name(l_v_div_csound_surf) = 'v_div_csound_surf'
         log_column_name(l_surface_accel_div_grav) = 'surface_accel_div_grav'
         log_column_name(l_log_dt) = 'log_dt'
         log_column_name(l_log_LH) = 'log_LH'
         log_column_name(l_log_LHe) = 'log_LHe'
         log_column_name(l_log_LZ) = 'log_LZ'
         log_column_name(l_luminosity) = 'luminosity'
         log_column_name(l_log_L) = 'log_L'
         log_column_name(l_log_Lneu) = 'log_Lneu'
         log_column_name(l_log_R) = 'log_R'
         log_column_name(l_radius) = 'radius'
         log_column_name(l_log_R_cm) = 'log_R_cm'
         log_column_name(l_radius_cm) = 'radius_cm'
         log_column_name(l_log_Teff) = 'log_Teff'
         log_column_name(l_effective_T) = 'effective_T'
         
         log_column_name(l_gravity) = 'gravity'
         log_column_name(l_log_g) = 'log_g'
         log_column_name(l_log_L_div_Ledd) = 'log_L_div_Ledd'
         log_column_name(l_log_Ledd) = 'log_Ledd'
         log_column_name(l_num_retries) = 'num_retries'
         log_column_name(l_num_backups) = 'num_backups'
         log_column_name(l_num_jacobians) = 'num_jacobians'
         log_column_name(l_total_num_jacobians) = 'total_num_jacobians'
         log_column_name(l_h1_czb_mass) = 'h1_czb_mass'
         log_column_name(l_surf_c12_minus_o16) = 'surf_c12_minus_o16'
         log_column_name(l_surf_num_c12_div_num_o16) = 'surf_num_c12_div_num_o16'

         log_column_name(l_min_Pgas_div_P) = 'min_Pgas_div_P'
         log_column_name(l_log_center_P) = 'log_center_P'
         log_column_name(l_center_degeneracy) = 'center_degeneracy'
         log_column_name(l_center_eps_grav) = 'center_eps_grav'
         log_column_name(l_center_gamma) = 'center_gamma'
         
         log_column_name(l_h1_boundary_radius) = 'h1_boundary_radius'
         log_column_name(l_h1_boundary_lgT) = 'h1_boundary_lgT'
         log_column_name(l_h1_boundary_lgRho) = 'h1_boundary_lgRho'
         log_column_name(l_h1_boundary_L) = 'h1_boundary_L'
         log_column_name(l_h1_boundary_v) = 'h1_boundary_v'
         log_column_name(l_h1_bdy_to_phot_sound_time) = 'h1_bdy_to_phot_sound_time'
         
         log_column_name(l_he4_boundary_radius) = 'he4_boundary_radius'
         log_column_name(l_he4_boundary_lgT) = 'he4_boundary_lgT'
         log_column_name(l_he4_boundary_lgRho) = 'he4_boundary_lgRho'
         log_column_name(l_he4_boundary_L) = 'he4_boundary_L'
         log_column_name(l_he4_boundary_v) = 'he4_boundary_v'
         log_column_name(l_he4_bdy_to_phot_sound_time) = 'he4_bdy_to_phot_sound_time'
         
         log_column_name(l_c12_boundary_mass) = 'c12_boundary_mass'
         log_column_name(l_c12_boundary_radius) = 'c12_boundary_radius'
         log_column_name(l_c12_boundary_lgT) = 'c12_boundary_lgT'
         log_column_name(l_c12_boundary_lgRho) = 'c12_boundary_lgRho'
         log_column_name(l_c12_boundary_L) = 'c12_boundary_L'
         log_column_name(l_c12_boundary_v) = 'c12_boundary_v'
         log_column_name(l_c12_bdy_to_phot_sound_time) = 'c12_bdy_to_phot_sound_time'
         
         log_column_name(l_envelope_mass) = 'envelope_mass'
         log_column_name(l_envelope_fraction_left) = 'envelope_fraction_left'
         
         log_column_name(l_tau10_mass) = &
            'tau10_mass' ! mass in solar units where optical depth = 10
         log_column_name(l_tau10_radius) = &
            'tau10_radius' ! radius in solar units where optical depth = 10
         log_column_name(l_tau10_lgP) = 'tau10_lgP' ! estimate for log10(P) at tau = 10
         log_column_name(l_tau10_T) = 'tau10_T' ! estimate for T at tau = 10
         log_column_name(l_tau10_lgT) = 'tau10_lgT' ! estimate for log10(T) at tau = 10
         log_column_name(l_tau10_lgRho) = 'tau10_lgRho' ! estimate for log10(density) at tau = 10
         log_column_name(l_tau10_L) = 'tau10_L' ! estimate for L/Lsun at tau = 10
         log_column_name(l_tau100_mass) = &
            'tau100_mass' ! location in solar units where optical depth = 100
         log_column_name(l_tau100_radius) = &
            'tau100_radius' ! location in solar units where optical depth = 100
         log_column_name(l_tau100_lgP) = 'tau100_lgP' ! estimates for values at tau = 100
         log_column_name(l_tau100_T) = 'tau100_T'
         log_column_name(l_tau100_lgT) = 'tau100_lgT'
         log_column_name(l_tau100_lgRho) = 'tau100_lgRho'
         log_column_name(l_tau100_L) = 'tau100_L'
         log_column_name(l_dynamic_timescale) = 'dynamic_timescale'
         log_column_name(l_kh_timescale) = 'kh_timescale'
         log_column_name(l_nuc_timescale) = 'nuc_timescale' 
         log_column_name(l_log_abs_Lgrav) = 'log_abs_Lgrav' 
         log_column_name(l_eps_grav_integral) = 'eps_grav_integral' 
         log_column_name(l_extra_L) = 'extra_L' 
         log_column_name(l_log_extra_L) = 'log_extra_L' 
         log_column_name(l_log_Lnuc) = 'log_Lnuc' 
         log_column_name(l_log_Lneu) = 'log_Lneu' 
         log_column_name(l_mass_loc_of_max_eps_nuc) = 'mass_loc_of_max_eps_nuc' 
         log_column_name(l_mass_ext_to_max_eps_nuc) = 'mass_ext_to_max_eps_nuc' 
         
         log_column_name(l_trace_mass_location) = 'trace_mass_location'
         log_column_name(l_trace_mass_radius) = 'trace_mass_radius'
         log_column_name(l_trace_mass_lgT) = 'trace_mass_lgT'
         log_column_name(l_trace_mass_lgRho) = 'trace_mass_lgRho'
         log_column_name(l_trace_mass_L) = 'trace_mass_L'
         log_column_name(l_trace_mass_v) = 'trace_mass_v'
         log_column_name(l_trace_mass_lgP) = 'trace_mass_lgP'
         log_column_name(l_trace_mass_g) = 'trace_mass_g'
         log_column_name(l_trace_mass_X) = 'trace_mass_X'
         log_column_name(l_trace_mass_Y) = 'trace_mass_Y'
         log_column_name(l_trace_mass_edv_H) = 'trace_mass_edv_H'
         log_column_name(l_trace_mass_edv_He) = 'trace_mass_edv_He'
         log_column_name(l_trace_mass_scale_height) = 'trace_mass_scale_height'
         log_column_name(l_trace_mass_dlnX_dr) = 'trace_mass_dlnX_dr'
         log_column_name(l_trace_mass_dlnY_dr) = 'trace_mass_dlnY_dr'
         log_column_name(l_trace_mass_dlnRho_dr) = 'trace_mass_dlnRho_dr'
         
         log_column_name(l_max_T_lgT) = 'max_T_lgT'
         log_column_name(l_max_T_mass) = 'max_T_mass'
         log_column_name(l_max_T_radius) = 'max_T_radius'
         log_column_name(l_max_T_lgRho) = 'max_T_lgRho'
         log_column_name(l_max_T_L) = 'max_T_L'
         log_column_name(l_max_T_eps_nuc) = 'max_T_eps_nuc'
         
         log_column_name(l_max_eps_h) = 'max_eps_h' ! erg/g/s
         log_column_name(l_max_eps_h_lgT) = &
            'max_eps_h_lgT' ! log10 temperature at location of max burn
         log_column_name(l_max_eps_h_lgRho) = &
            'max_eps_h_lgRho' ! log10 density at location of max burn
         log_column_name(l_max_eps_h_m) = &
            'max_eps_h_m' ! mass coordinate at location of max burn (Msun units)
         log_column_name(l_max_eps_h_xm) = &
            'max_eps_h_xm' ! mass exterior to loc of max burn (Msun units)
         log_column_name(l_max_eps_h_lgR) = 'max_eps_h_lgR'
         log_column_name(l_max_eps_h_lgP) = 'max_eps_h_lgP'
         log_column_name(l_max_eps_h_opacity) = 'max_eps_h_opacity'
         
         log_column_name(l_max_eps_he) = 'max_eps_he' ! erg/g/s
         log_column_name(l_max_eps_he_lgT) = &
            'max_eps_he_lgT' ! log10 temperature at location of max burn
         log_column_name(l_max_eps_he_lgRho) = &
            'max_eps_he_lgRho' ! log10 density at location of max burn
         log_column_name(l_max_eps_he_m) = &
            'max_eps_he_m' ! mass coordinate at location of max burn (Msun units)
         log_column_name(l_max_eps_he_xm) = &
            'max_eps_he_xm' ! mass exterior to loc of max burn (Msun units)
         log_column_name(l_max_eps_he_lgR) = 'max_eps_he_lgR'
         log_column_name(l_max_eps_he_lgP) = 'max_eps_he_lgP'
         log_column_name(l_max_eps_he_opacity) = 'max_eps_he_opacity'
         
         log_column_name(l_max_eps_z) = 'max_eps_z' ! erg/g/s
         log_column_name(l_max_eps_z_lgT) = &
            'max_eps_z_lgT' ! log10 temperature at location of max burn
         log_column_name(l_max_eps_z_lgRho) = &
            'max_eps_z_lgRho' ! log10 density at location of max burn
         log_column_name(l_max_eps_z_m) = &
            'max_eps_z_m' ! mass coordinate at location of max burn (Msun units)      
         log_column_name(l_max_eps_z_xm) = &
            'max_eps_z_xm' ! mass exterior to loc of max burn (Msun units)
         log_column_name(l_max_eps_z_lgR) = 'max_eps_z_lgR'
         log_column_name(l_max_eps_z_lgP) = 'max_eps_z_lgP'
         log_column_name(l_max_eps_z_opacity) = 'max_eps_z_opacity'
         
         log_column_name(l_max_eps_nuc) = 'max_eps_nuc' ! erg/g/s
         log_column_name(l_max_eps_nuc_lgT) = &
            'max_eps_nuc_lgT' ! log10 temperature at location of max burn
         log_column_name(l_max_eps_nuc_lgRho) = &
            'max_eps_nuc_lgRho' ! log10 density at location of max burn
         log_column_name(l_max_eps_nuc_m) = &
            'max_eps_nuc_m' ! mass coordinate at location of max burn (Msun units)      
         log_column_name(l_max_eps_nuc_xm) = &
            'max_eps_nuc_xm' ! mass exterior to loc of max burn (Msun units)
         log_column_name(l_max_eps_nuc_lgR) = 'max_eps_nuc_lgR'
         log_column_name(l_max_eps_nuc_lgP) = 'max_eps_nuc_lgP'
         log_column_name(l_max_eps_nuc_opacity) = 'max_eps_nuc_opacity'
         log_column_name(l_max_eps_nuc_cp) = 'max_eps_nuc_cp'
         log_column_name(l_max_eps_nuc_t_heat) = 'max_eps_nuc_t_heat'

         log_column_name(l_max_eps_nuc_csound) = 'max_eps_nuc_csound'
         log_column_name(l_max_eps_nuc_pi_r_div_cs) = 'max_eps_nuc_pi_r_div_cs'
         log_column_name(l_max_eps_nuc_H) = 'max_eps_nuc_H'
         log_column_name(l_max_eps_nuc_H_div_cs) = 'max_eps_nuc_H_div_cs'

         log_column_name(l_log_surf_opacity) = 'log_surf_opacity'
         log_column_name(l_log_surf_density) = 'log_surf_density'
         log_column_name(l_surface_temperature) = 'surface_temperature'
         log_column_name(l_log_surf_temperature) = 'log_surf_temperature'
         log_column_name(l_log_surf_pressure) = 'log_surf_pressure'
         log_column_name(l_log_surf_optical_depth) = 'log_surf_optical_depth'
         log_column_name(l_surface_optical_depth) = 'surface_optical_depth'
         log_column_name(l_log_surf_z) = 'log_surf_z'

         log_column_name(l_max_conv_vel_div_csound) = 'max_conv_vel_div_csound'

         log_column_name(l_dt_Courant) = 'dt_Courant'
         log_column_name(l_log_dt_Courant) = 'log_dt_Courant'
         log_column_name(l_dt_Courant_yr) = 'dt_Courant_yr'
         log_column_name(l_log_dt_Courant_yr) = 'log_dt_Courant_yr'
         log_column_name(l_dt_div_dt_Courant) = 'dt_div_dt_Courant'
         log_column_name(l_log_dt_div_dt_Courant) = 'log_dt_div_dt_Courant'

         log_column_name(l_cz_mass) = 'cz_mass'
         log_column_name(l_cz_log_xmsun) = 'cz_log_xmsun'
         log_column_name(l_cz_log_xmass) = 'cz_log_xmass'
         log_column_name(l_cz_xm) = 'cz_xm'
         log_column_name(l_cz_logT) = 'cz_logT'
         log_column_name(l_cz_logRho) = 'cz_logRho'
         log_column_name(l_cz_logP) = 'cz_logP'
         log_column_name(l_cz_log_column_depth) = 'cz_log_column_depth'
         log_column_name(l_cz_log_radial_depth) = 'cz_log_radial_depth'
         
         log_column_name(l_cz_log_tau) = 'cz_log_tau'
         log_column_name(l_cz_opacity) = 'cz_opacity'
         log_column_name(l_cz_eta) = 'cz_eta'
         log_column_name(l_cz_log_eps_nuc) = 'cz_log_eps_nuc'
         log_column_name(l_cz_t_heat) = 'cz_t_heat'
         log_column_name(l_cz_csound) = 'cz_csound'
         log_column_name(l_cz_scale_height) = 'cz_scale_height'
         log_column_name(l_cz_grav) = 'cz_grav'
         log_column_name(l_cz_luminosity) = 'cz_luminosity'
         log_column_name(l_cz_radius) = 'cz_radius'
         log_column_name(l_cz_zone) = 'cz_zone'
         log_column_name(l_cz_omega) = 'cz_omega'
         log_column_name(l_cz_omega_div_omega_crit) = 'cz_omega_div_omega_crit'

         log_column_name(l_cz_top_mass) = 'cz_top_mass'
         log_column_name(l_cz_top_log_xmsun) = 'cz_top_log_xmsun'
         log_column_name(l_cz_top_log_xmass) = 'cz_top_log_xmass'
         log_column_name(l_cz_top_xm) = 'cz_top_xm'
         log_column_name(l_cz_top_logT) = 'cz_top_logT'
         log_column_name(l_cz_top_logRho) = 'cz_top_logRho'
         log_column_name(l_cz_top_logP) = 'cz_top_logP'
         log_column_name(l_cz_top_log_column_depth) = 'cz_top_log_column_depth'
         log_column_name(l_cz_top_log_radial_depth) = 'cz_top_log_radial_depth'
         
         log_column_name(l_cz_top_log_tau) = 'cz_top_log_tau'
         log_column_name(l_cz_top_opacity) = 'cz_top_opacity'
         log_column_name(l_cz_top_eta) = 'cz_top_eta'
         log_column_name(l_cz_top_log_eps_nuc) = 'cz_top_log_eps_nuc'
         log_column_name(l_cz_top_t_heat) = 'cz_top_t_heat'
         log_column_name(l_cz_top_csound) = 'cz_top_csound'
         log_column_name(l_cz_top_scale_height) = 'cz_top_scale_height'
         log_column_name(l_cz_top_grav) = 'cz_top_grav'
         log_column_name(l_cz_top_luminosity) = 'cz_top_luminosity'
         log_column_name(l_cz_top_radius) = 'cz_top_radius'
         log_column_name(l_cz_top_zone) = 'cz_top_zone'
         log_column_name(l_cz_top_omega) = 'cz_top_omega'
         log_column_name(l_cz_top_omega_div_omega_crit) = 'cz_top_omega_div_omega_crit'

         log_column_name(l_trace_mass_omega) = 'trace_mass_omega'
         log_column_name(l_trace_mass_omega_div_omega_crit) = 'trace_mass_omega_div_omega_crit'
         log_column_name(l_h1_bdy_omega) = 'h1_bdy_omega'
         log_column_name(l_h1_bdy_omega_div_omega_crit) = 'h1_bdy_omega_div_omega_crit'
         log_column_name(l_he4_bdy_omega) = 'he4_bdy_omega'
         log_column_name(l_he4_bdy_omega_div_omega_crit) = 'he4_bdy_omega_div_omega_crit'
         log_column_name(l_c12_bdy_omega) = 'c12_bdy_omega'
         log_column_name(l_c12_bdy_omega_div_omega_crit) = 'c12_bdy_omega_div_omega_crit'
         log_column_name(l_log_rotational_mdot_boost) = 'log_rotational_mdot_boost'
         log_column_name(l_surf_omega) = 'surf_omega'
         log_column_name(l_surf_omega_crit) = 'surf_omega_crit'
         log_column_name(l_surf_v_crit) = 'surf_v_crit'
         log_column_name(l_surf_v_rot) = 'surf_v_rot'
         log_column_name(l_surf_omega_div_omega_crit) = 'surf_omega_div_omega_crit'
         log_column_name(l_center_omega) = 'center_omega'
         log_column_name(l_center_omega_div_omega_crit) = 'center_omega_div_omega_crit'

         log_column_name(l_surf_r_equitorial_div_r) = 'surf_r_equitorial_div_r'
         log_column_name(l_surf_r_polar_div_r) = 'surf_r_polar_div_r'

         log_column_name(l_log_total_angular_momentum) = 'log_total_angular_momentum'

         log_column_name(l_min_t_eddy) = 'min_t_eddy'
         log_column_name(l_elapsed_time) = 'elapsed_time'

         log_column_name(l_photosphere_L) = 'photosphere_L'
         log_column_name(l_photosphere_r) = 'photosphere_r'

         log_column_name(l_delta_nu) = 'delta_nu'
         log_column_name(l_delta_Pg) = 'delta_Pg'
         log_column_name(l_log_delta_Pg) = 'log_delta_Pg'
         log_column_name(l_nu_max_3_4th_div_delta_nu) = 'nu_max_3_4th_div_delta_nu'
         
         log_column_name(l_nu_max) = 'nu_max'
         log_column_name(l_acoustic_cutoff) = 'acoustic_cutoff'
         log_column_name(l_gs_per_delta_nu) = 'gs_per_delta_nu'
         log_column_name(l_ng_for_nu_max) = 'ng_for_nu_max'

         log_column_name(l_int_k_r_dr_nu_max_Sl1) = 'int_k_r_dr_nu_max_Sl1'
         log_column_name(l_int_k_r_dr_2pt0_nu_max_Sl1) = 'int_k_r_dr_2pt0_nu_max_Sl1'
         log_column_name(l_int_k_r_dr_0pt5_nu_max_Sl1) = 'int_k_r_dr_0pt5_nu_max_Sl1'

         log_column_name(l_int_k_r_dr_nu_max_Sl2) = 'int_k_r_dr_nu_max_Sl2'
         log_column_name(l_int_k_r_dr_2pt0_nu_max_Sl2) = 'int_k_r_dr_2pt0_nu_max_Sl2'
         log_column_name(l_int_k_r_dr_0pt5_nu_max_Sl2) = 'int_k_r_dr_0pt5_nu_max_Sl2'

         log_column_name(l_int_k_r_dr_nu_max_Sl3) = 'int_k_r_dr_nu_max_Sl3'
         log_column_name(l_int_k_r_dr_2pt0_nu_max_Sl3) = 'int_k_r_dr_2pt0_nu_max_Sl3'
         log_column_name(l_int_k_r_dr_0pt5_nu_max_Sl3) = 'int_k_r_dr_0pt5_nu_max_Sl3'
         
         log_column_name(l_cz_top_zone_logdq) = 'cz_top_zone_logdq'
         log_column_name(l_op_split_diff) = 'op_split_diff'
         log_column_name(l_log_Lnuc_sub_log_L) = 'log_Lnuc_sub_log_L'

         log_column_name(l_log_err_ratio_max) = 'log_err_ratio_max'
         log_column_name(l_log_err_ratio_avg) = 'log_err_ratio_avg'
         log_column_name(l_seulex_rows) = 'seulex_rows'

         log_column_name(l_min_L) = 'min_L'
         log_column_name(l_offset_FL) = 'offset_FL'

                  
         cnt = 0
         do i=1,l_col_id_max
            if (len_trim(log_column_name(i)) == 0) then
               write(*,*) 'missing name for log column id', i
               if (i > 1) write(*,*) 'following ' // trim(log_column_name(i-1))
               write(*,*) 
               cnt = cnt+1
            end if
         end do

         if (cnt > 0) then
            ierr = -1
            return
         end if
         
         nullify(log_column_names_dict)
         do i=1,l_col_id_max
            call integer_dict_define(log_column_names_dict, log_column_name(i), i, ierr)
            if (ierr /= 0) then
               write(*,*) 'FATAL ERROR: log_column_names_init failed in integer_dict_define'
               return
            end if
         end do

      end subroutine log_column_names_init         
            
      
		integer function do_get_log_id(cname)
         use utils_lib
			character (len=*), intent(in)  :: cname 
			! returns id for the log column if there is a matching name
			! returns 0 otherwise.
			integer :: ierr, value
			call integer_dict_lookup(log_column_names_dict, cname, value, ierr)
			if (ierr /= 0) value = 0
			do_get_log_id = value
		end function do_get_log_id
         
      
      
      
      subroutine profile_column_names_init(ierr)
         use utils_lib, only: integer_dict_define
         integer, intent(out) :: ierr
         integer :: i, cnt
         
         ierr = 0
         
         cnt = 0
         profile_column_name(:) = ''

         profile_column_name(p_zone) = 'zone'
         profile_column_name(p_luminosity) = 'luminosity'
         profile_column_name(p_log_Lrad_div_Ledd) = 'log_Lrad_div_Ledd'
         profile_column_name(p_log_Lrad_div_L) = 'log_Lrad_div_L'
         profile_column_name(p_luminosity_rad) = 'luminosity_rad'
         profile_column_name(p_luminosity_conv) = 'luminosity_conv'
         
         profile_column_name(p_lum_conv_div_lum_Edd) = 'lum_conv_div_lum_Edd'
         profile_column_name(p_lum_rad_div_lum_Edd) = 'lum_rad_div_lum_Edd'
         profile_column_name(p_lum_rad_div_L) = 'lum_rad_div_L'
         profile_column_name(p_lum_conv_div_L) = 'lum_conv_div_L'
         profile_column_name(p_lum_conv_div_lum_rad) = 'lum_conv_div_lum_rad'
         profile_column_name(p_log_Lrad) = 'log_Lrad'
         profile_column_name(p_grav) = 'grav'
         profile_column_name(p_r_div_g) = 'r_div_g'
         profile_column_name(p_g_div_r) = 'g_div_r'
         profile_column_name(p_net_nuclear_energy) = 'net_nuclear_energy'
         profile_column_name(p_net_energy) = 'net_energy'
         profile_column_name(p_logL) = 'logL'
         profile_column_name(p_log_Ledd) = 'log_Ledd'
         profile_column_name(p_log_L_div_Ledd) = 'log_L_div_Ledd'
         profile_column_name(p_signed_log_power) = 'signed_log_power'
         profile_column_name(p_velocity) = 'velocity'
         profile_column_name(p_radius) = 'radius'
         profile_column_name(p_rmid) = 'rmid'
         profile_column_name(p_logR) = 'logR'
         profile_column_name(p_q) = 'q'
         profile_column_name(p_dq) = 'dq'
         profile_column_name(p_logtau) = 'logtau'
         profile_column_name(p_lum_rad_div_lum_Edd_sub_fourPrad_div_PchiT) = &
            'lum_rad_div_lum_Edd_sub_fourPrad_div_PchiT'
         profile_column_name(p_fourPrad_div_PchiT) = 'fourPrad_div_PchiT'
         profile_column_name(p_pturbulence_div_ptotal) = 'pturbulence_div_ptotal'
         profile_column_name(p_pgas_div_ptotal) = 'pgas_div_ptotal'

         profile_column_name(p_mass) = 'mass'
         profile_column_name(p_mmid) = 'mmid'

         profile_column_name(p_avg_charge_H) = 'avg_charge_H'
         profile_column_name(p_avg_charge_He) = 'avg_charge_He'
         profile_column_name(p_avg_charge_C) = 'avg_charge_C'
         profile_column_name(p_avg_charge_N) = 'avg_charge_N'
         profile_column_name(p_avg_charge_O) = 'avg_charge_O'
         profile_column_name(p_avg_charge_Ne) = 'avg_charge_Ne'
         profile_column_name(p_avg_charge_Mg) = 'avg_charge_Mg'
         profile_column_name(p_avg_charge_Si) = 'avg_charge_Si'
         profile_column_name(p_avg_charge_Fe) = 'avg_charge_Fe'
         profile_column_name(p_neutral_fraction_H) = 'neutral_fraction_H'
         profile_column_name(p_neutral_fraction_He) = 'neutral_fraction_He'
         profile_column_name(p_neutral_fraction_C) = 'neutral_fraction_C'
         profile_column_name(p_neutral_fraction_N) = 'neutral_fraction_N'
         profile_column_name(p_neutral_fraction_O) = 'neutral_fraction_O'
         profile_column_name(p_neutral_fraction_Ne) = 'neutral_fraction_Ne'
         profile_column_name(p_neutral_fraction_Mg) = 'neutral_fraction_Mg'
         profile_column_name(p_neutral_fraction_Si) = 'neutral_fraction_Si'
         profile_column_name(p_neutral_fraction_Fe) = 'neutral_fraction_Fe'
         
         profile_column_name(p_log_x) = 'log_x'
         profile_column_name(p_x) = 'x'
         profile_column_name(p_log_y) = 'log_y'
         profile_column_name(p_y) = 'y'
         profile_column_name(p_log_z) = 'log_z'
         profile_column_name(p_z) = 'z'

         profile_column_name(p_xm) = 'xm'
         profile_column_name(p_logxm) = 'logxm'
         profile_column_name(p_logxq) = 'logxq'
         profile_column_name(p_logdq) = 'logdq'
         
         profile_column_name(p_log_radial_depth) = 'log_radial_depth'
         profile_column_name(p_log_column_depth) = 'log_column_depth'
         profile_column_name(p_r_div_R) = 'r_div_R'
         profile_column_name(p_dr) = 'dr'
         profile_column_name(p_log_dr) = 'log_dr'
         profile_column_name(p_dr_div_cs) = 'dr_div_cs'
         profile_column_name(p_log_dr_div_cs) = 'log_dr_div_cs'
         profile_column_name(p_dr_div_cs_yr) = 'dr_div_cs_yr'
         profile_column_name(p_log_dr_div_cs_yr) = 'log_dr_div_cs_yr'

         profile_column_name(p_acoustic_radius) = 'acoustic_radius'
         profile_column_name(p_acoustic_r_div_R_phot) = 'acoustic_r_div_R_phot'
         
         profile_column_name(p_grav_gr_factor) = 'grav_gr_factor'
         profile_column_name(p_log_grav_gr_factor) = 'log_grav_gr_factor'
         profile_column_name(p_gr_mass_excess) = 'gr_mass_excess'
         profile_column_name(p_gr_time_excess) = 'gr_time_excess'
         profile_column_name(p_gr_space_excess) = 'gr_space_excess'
         profile_column_name(p_gr_enthalpy_excess) = 'gr_enthalpy_excess'
         profile_column_name(p_dq_ratio) = 'dq_ratio'
         profile_column_name(p_tau) = 'tau'
         profile_column_name(p_log_opacity) = 'log_opacity'
         profile_column_name(p_energy) = 'energy'
         profile_column_name(p_logM) = 'logM'
         profile_column_name(p_temperature) = 'temperature'
         profile_column_name(p_logT) = 'logT'
         profile_column_name(p_rho) = 'rho'
         profile_column_name(p_logRho) = 'logRho'
         profile_column_name(p_pgas) = 'pgas'
         profile_column_name(p_logPgas) = 'logPgas'
         profile_column_name(p_prad) = 'prad'
         profile_column_name(p_pressure) = 'pressure'
         profile_column_name(p_logP) = 'logP'
         profile_column_name(p_logE) = 'logE'
         profile_column_name(p_grada) = 'grada'
         profile_column_name(p_dE_dRho) = 'dE_dRho'
         profile_column_name(p_cv) = 'cv'
         profile_column_name(p_cp) = 'cp'
         profile_column_name(p_logS) = 'logS'
         profile_column_name(p_logS_per_baryon) = 'logS_per_baryon'
         profile_column_name(p_gamma1) = 'gamma1'
         profile_column_name(p_gamma3) = 'gamma3'
         profile_column_name(p_eta) = 'eta'
         profile_column_name(p_theta_e) = 'theta_e'
         profile_column_name(p_gam) = 'gam'
         profile_column_name(p_mu) = 'mu'
         profile_column_name(p_v_div_r) = 'v_div_r'
         profile_column_name(p_v_div_csound) = 'v_div_csound'
         profile_column_name(p_csound) = 'csound'
         profile_column_name(p_csound_at_face) = 'csound_at_face'

         profile_column_name(p_omega) = 'omega'
         profile_column_name(p_log_omega) = 'log_omega'
         profile_column_name(p_log_j_rot) = 'log_j_rot'
         profile_column_name(p_log_J_div_M53) = 'log_J_div_M53'
         profile_column_name(p_log_J_inside) = 'log_J_inside'
         profile_column_name(p_shear) = 'shear'
         profile_column_name(p_log_abs_shear) = 'log_abs_shear'
         profile_column_name(p_i_rot) = 'i_rot'
         profile_column_name(p_j_rot) = 'j_rot'
         profile_column_name(p_v_rot) = 'v_rot'
         profile_column_name(p_fp_rot) = 'fp_rot'
         profile_column_name(p_ft_rot) = 'ft_rot'
         profile_column_name(p_log_am_nu) = 'log_am_nu'

         profile_column_name(p_r_polar) = 'r_polar'
         profile_column_name(p_log_r_polar) = 'log_r_polar'
         profile_column_name(p_r_equitorial) = 'r_equitorial'
         profile_column_name(p_log_r_equitorial) = 'log_r_equitorial'
         profile_column_name(p_r_e_div_r_p) = 'r_e_div_r_p'
         profile_column_name(p_omega_crit) = 'omega_crit'
         profile_column_name(p_omega_div_omega_crit) = 'omega_div_omega_crit'

         profile_column_name(p_am_log_sig) = 'am_log_sig'
         profile_column_name(p_am_domega_dlnR) = 'am_domega_dlnR'
         profile_column_name(p_am_log_D_DSI) = 'am_log_D_DSI'
         profile_column_name(p_am_log_D_SH) = 'am_log_D_SH'
         profile_column_name(p_am_log_D_SSI) = 'am_log_D_SSI'
         profile_column_name(p_am_log_D_ES) = 'am_log_D_ES'
         profile_column_name(p_am_log_D_GSF) = 'am_log_D_GSF'
         profile_column_name(p_am_log_D_ST) = 'am_log_D_ST'
         profile_column_name(p_am_log_nu_ST) = 'am_log_nu_ST'

         profile_column_name(p_dynamo_log_B_r) = 'dynamo_log_B_r'
         profile_column_name(p_dynamo_log_B_phi) = 'dynamo_log_B_phi'

         profile_column_name(p_gradr_sub_grada) = 'gradr_sub_grada'
         profile_column_name(p_scale_height) = 'scale_height'
         profile_column_name(p_entropy) = 'entropy'
         profile_column_name(p_free_e) = 'free_e'
         profile_column_name(p_logfree_e) = 'logfree_e'
         profile_column_name(p_chiRho) = 'chiRho'
         profile_column_name(p_chiT) = 'chiT'
         profile_column_name(p_dlnRho_dlnT_const_Pgas) = 'dlnRho_dlnT_const_Pgas'
         profile_column_name(p_dlnRho_dlnPgas_const_T) = 'dlnRho_dlnPgas_const_T'
         
         profile_column_name(p_abar) = 'abar'
         profile_column_name(p_zbar) = 'zbar'
         profile_column_name(p_z2bar) = 'z2bar'
         profile_column_name(p_ye) = 'ye'
         profile_column_name(p_opacity) = 'opacity'
         profile_column_name(p_dkap_dlnrho_at_face) = 'dkap_dlnrho_at_face'
         profile_column_name(p_dkap_dlnt_at_face) = 'dkap_dlnt_at_face'
         profile_column_name(p_eps_nuc) = 'eps_nuc'
         profile_column_name(p_d_epsnuc_dlnd) = 'd_epsnuc_dlnd'
         profile_column_name(p_d_epsnuc_dlnT) = 'd_epsnuc_dlnT'
         profile_column_name(p_d_lnepsnuc_dlnd) = 'd_lnepsnuc_dlnd'
         profile_column_name(p_d_lnepsnuc_dlnT) = 'd_lnepsnuc_dlnT'
         profile_column_name(p_deps_dlnd_at_face) = 'deps_dlnd_at_face'
         profile_column_name(p_deps_dlnT_at_face) = 'deps_dlnT_at_face'
         profile_column_name(p_eps_nuc_neu_total) = 'eps_nuc_neu_total'
         profile_column_name(p_non_nuc_neu) = 'non_nuc_neu'
         profile_column_name(p_nonnucneu_plas) = 'nonnucneu_plas'
         profile_column_name(p_nonnucneu_brem) = 'nonnucneu_brem'
         profile_column_name(p_nonnucneu_phot) = 'nonnucneu_phot'
         profile_column_name(p_nonnucneu_pair) = 'nonnucneu_pair'
         profile_column_name(p_nonnucneu_reco) = 'nonnucneu_reco'
         profile_column_name(p_log_irradiation_heat) = 'log_irradiation_heat'
         profile_column_name(p_extra_L) = 'extra_L'
         profile_column_name(p_log_extra_L) = 'log_extra_L'
         profile_column_name(p_extra_heat) = 'extra_heat'
         profile_column_name(p_cgrav_factor) = 'cgrav_factor'
         profile_column_name(p_logPvisc) = 'logPvisc'
         profile_column_name(p_eps_grav) = 'eps_grav'
         profile_column_name(p_env_eps_grav) = 'env_eps_grav'
         profile_column_name(p_rp_div_GMrho_face) = 'rp_div_GMrho_face'
         profile_column_name(p_signed_log_eps_grav) = 'signed_log_eps_grav'
         profile_column_name(p_mlt_mixing_length) = 'mlt_mixing_length'
         profile_column_name(p_mlt_Zeta) = 'mlt_Zeta'
         profile_column_name(p_mlt_Gamma) = 'mlt_Gamma'
         profile_column_name(p_mlt_mixing_type) = 'mlt_mixing_type'
         profile_column_name(p_gradT_sub_grada) = 'gradT_sub_grada'
         profile_column_name(p_super_ad) = 'super_ad'
         profile_column_name(p_log_D_conv) = 'log_D_conv'
         profile_column_name(p_log_D_semi) = 'log_D_semi'
         profile_column_name(p_log_D_ovr) = 'log_D_ovr'
         profile_column_name(p_log_D_th) = 'log_D_th'
         profile_column_name(p_log_D_mix_non_rotation) = 'log_D_mix_non_rotation'
         profile_column_name(p_log_D_mix) = 'log_D_mix'
         profile_column_name(p_log_sig_mix) = 'log_sig_mix'
         profile_column_name(p_log_sig_div_siglim) = 'log_sig_div_siglim'
         profile_column_name(p_log_conv_vel) = 'log_conv_vel'
         profile_column_name(p_log_conv_vel_frac_current) = 'log_conv_vel_frac_current'
         profile_column_name(p_conv_vel_div_csound) = 'conv_vel_div_csound'
         profile_column_name(p_conv_vel_div_L_vel) = 'conv_vel_div_L_vel'
         profile_column_name(p_newly_nonconvective) = 'newly_nonconvective'
         profile_column_name(p_conv_mixing_type) = 'conv_mixing_type'
         profile_column_name(p_conv_dP_term) = 'conv_dP_term'
         profile_column_name(p_mixing_type) = 'mixing_type'
         profile_column_name(p_log_mlt_D_mix) = 'log_mlt_D_mix'
         profile_column_name(p_pressure_scale_height) = 'pressure_scale_height'
         profile_column_name(p_gradT) = 'gradT'
         profile_column_name(p_gradr) = 'gradr'
         profile_column_name(p_dlnP_dm) = 'dlnP_dm'
         profile_column_name(p_dlnT_dm) = 'dlnT_dm'
         profile_column_name(p_dL_dm) = 'dL_dm'

         profile_column_name(p_dlnP_dlnm) = 'dlnP_dlnm'
         profile_column_name(p_dlnT_dlnm) = 'dlnT_dlnm'
         
         profile_column_name(p_accel_div_grav) = 'accel_div_grav'
         profile_column_name(p_dlnd_dt) = 'dlnd_dt'
         profile_column_name(p_lnddot) = 'lnddot'
         profile_column_name(p_dlnPgas_dt) = 'dlnPgas_dt'
         profile_column_name(p_dlnE_var_dt) = 'dlnE_dt'
         profile_column_name(p_dlnT_dt) = 'dlnT_dt'
         profile_column_name(p_lnTdot) = 'lnTdot'
         profile_column_name(p_dlnR_dt) = 'dlnR_dt'
         
         profile_column_name(p_dv_dt) = 'dv_dt'
         profile_column_name(p_cno_div_z) = 'cno_div_z'
         
         profile_column_name(p_signed_dlnd) = 'signed_dlnd'
         profile_column_name(p_signed_dlnT) = 'signed_dlnT'

         profile_column_name(p_delta_r) = 'delta_r'
         profile_column_name(p_delta_v) = 'delta_v'
         profile_column_name(p_dt_dv_div_dr) = 'dt_dv_div_dr'
         
         profile_column_name(p_dlnH1_dlnP) = 'dlog_h1_dlogP'
         profile_column_name(p_dlnHe3_dlnP) = 'dlog_he3_dlogP'
         profile_column_name(p_dlnHe4_dlnP) = 'dlog_he4_dlogP'
         profile_column_name(p_dlnC12_dlnP) = 'dlog_c12_dlogP'
         profile_column_name(p_dlnC13_dlnP) = 'dlog_c13_dlogP'
         profile_column_name(p_dlnN14_dlnP) = 'dlog_n14_dlogP'
         profile_column_name(p_dlnO16_dlnP) = 'dlog_o16_dlogP'
         profile_column_name(p_dlnNe20_dlnP) = 'dlog_ne20_dlogP'
         profile_column_name(p_dlnMg24_dlnP) = 'dlog_mg24_dlogP'
         profile_column_name(p_dlnSi28_dlnP) = 'dlog_si28_dlogP'

         profile_column_name(p_dlog_pp_dlogP) = 'dlog_pp_dlogP'
         profile_column_name(p_dlog_cno_dlogP) = 'dlog_cno_dlogP'
         profile_column_name(p_dlog_3alf_dlogP) = 'dlog_3alf_dlogP'
         
         profile_column_name(p_dlog_burn_c_dlogP) = 'dlog_burn_c_dlogP'
         profile_column_name(p_dlog_burn_n_dlogP) = 'dlog_burn_n_dlogP'
         profile_column_name(p_dlog_burn_o_dlogP) = 'dlog_burn_o_dlogP'
         
         profile_column_name(p_dlog_burn_ne_dlogP) = 'dlog_burn_ne_dlogP'
         profile_column_name(p_dlog_burn_na_dlogP) = 'dlog_burn_na_dlogP'
         profile_column_name(p_dlog_burn_mg_dlogP) = 'dlog_burn_mg_dlogP'
         
         profile_column_name(p_dlog_cc_dlogP) = 'dlog_cc_dlogP'
         profile_column_name(p_dlog_co_dlogP) = 'dlog_co_dlogP'
         profile_column_name(p_dlog_oo_dlogP) = 'dlog_oo_dlogP'
         
         profile_column_name(p_dlog_burn_si_dlogP) = 'dlog_burn_si_dlogP'
         profile_column_name(p_dlog_burn_s_dlogP) = 'dlog_burn_s_dlogP'
         profile_column_name(p_dlog_burn_ar_dlogP) = 'dlog_burn_ar_dlogP'
         profile_column_name(p_dlog_burn_ca_dlogP) = 'dlog_burn_ca_dlogP'
         profile_column_name(p_dlog_burn_ti_dlogP) = 'dlog_burn_ti_dlogP'
         profile_column_name(p_dlog_burn_cr_dlogP) = 'dlog_burn_cr_dlogP'
         profile_column_name(p_dlog_burn_fe_dlogP) = 'dlog_burn_fe_dlogP'
         
         profile_column_name(p_dlog_pnhe4_dlogP) = 'dlog_pnhe4_dlogP'
         profile_column_name(p_dlog_photo_dlogP) = 'dlog_photo_dlogP'
         profile_column_name(p_dlog_other_dlogP) = 'dlog_other_dlogP'

         profile_column_name(p_binding_energy) = 'binding_energy'
         profile_column_name(p_binding_energy_integral) = 'binding_energy_integral'

         profile_column_name(p_log_L_div_CpTMdot) = 'log_L_div_CpTMdot'
         profile_column_name(p_log_mdot_cs) = 'log_mdot_cs'
         profile_column_name(p_log_mdot_v) = 'log_mdot_v'
         profile_column_name(p_cs_at_cell_bdy) = 'cs_at_cell_bdy'
         profile_column_name(p_grad_density) = 'grad_density'
         profile_column_name(p_grad_temperature) = 'grad_temperature'
         profile_column_name(p_gradmu) = 'gradmu'
         profile_column_name(p_gradmu_alt) = 'gradmu_alt'
         profile_column_name(p_mu_alt) = 'mu_alt'

         profile_column_name(p_dlnmu_X) = 'dlnmu_X'
         profile_column_name(p_gradmu_X) = 'gradmu_X'

         profile_column_name(p_gradL) = 'gradL'
         profile_column_name(p_gradL_composition_term) = 'gradL_composition_term'
         profile_column_name(p_sch_stable) = 'sch_stable'
         profile_column_name(p_ledoux_stable) = 'ledoux_stable'
         profile_column_name(p_stability_type) = 'stability_type'

         profile_column_name(p_gradr_for_mixing) = 'gradr_for_mixing'
         profile_column_name(p_gradL_for_mixing) = 'gradL_for_mixing'
         profile_column_name(p_gradT_for_mixing) = 'gradT_for_mixing'
         profile_column_name(p_grada_for_mixing) = 'grada_for_mixing'
         
         profile_column_name(p_gradL_comp_for_mixing) = 'gradL_comp_pre_hydro'
         profile_column_name(p_gradmu_for_mixing) = 'gradmu_pre_hydro'
         profile_column_name(p_gradmu_alt_for_mixing) = 'gradmu_alt_pre_hydro'
         profile_column_name(p_gradmu_X_for_mixing) = 'gradmu_X_pre_hydro'

         profile_column_name(p_brunt_dlnRho_dlnR) = 'brunt_dlnRho_dlnR'
         profile_column_name(p_brunt_dlnY_dlnP) = 'brunt_dlnY_dlnP'
         profile_column_name(p_brunt_chiY) = 'brunt_chiY'
         profile_column_name(p_brunt_B) = 'brunt_B'
         profile_column_name(p_brunt_nonB) = 'brunt_nonB'
         profile_column_name(p_brunt_g_r_div_cs2) = 'brunt_g_r_div_cs2'
         
         profile_column_name(p_brunt_N2) = 'brunt_N2'
         profile_column_name(p_brunt_N2_structure_term) = 'brunt_N2_structure_term'
         profile_column_name(p_brunt_N2_composition_term) = 'brunt_N2_composition_term'
         
         profile_column_name(p_brunt_A) = 'brunt_A'
         profile_column_name(p_log_brunt_N2_dimensionless) = 'log_brunt_N2_dimensionless'
         profile_column_name(p_brunt_N2_dimensionless) = 'brunt_N2_dimensionless'
         profile_column_name(p_brunt_N_dimensionless) = 'brunt_N_dimensionless'
         profile_column_name(p_brunt_N) = 'brunt_N'
         profile_column_name(p_brunt_frequency) = 'brunt_frequency'
         profile_column_name(p_brunt_nu) = 'brunt_nu'
         profile_column_name(p_brunt_nu_composition_term) = 'brunt_nu_composition_term'
         profile_column_name(p_brunt_nu_structure_term) = 'brunt_nu_structure_term'
         profile_column_name(p_log_brunt_N) = 'log_brunt_N'
         profile_column_name(p_log_brunt_N2) = 'log_brunt_N2'
         profile_column_name(p_sign_brunt_N2) = 'sign_brunt_N2'
         profile_column_name(p_lamb_S2) = 'lamb_S2'
         profile_column_name(p_lamb_S) = 'lamb_S'
         profile_column_name(p_lamb_Sl1) = 'lamb_Sl1'
         profile_column_name(p_lamb_Sl2) = 'lamb_Sl2'
         profile_column_name(p_lamb_Sl3) = 'lamb_Sl3'
         profile_column_name(p_brunt_N_div_r_integral) = 'brunt_N_div_r_integral'
         profile_column_name(p_k_r_integral) = 'k_r_integral'

         profile_column_name(p_log_err_ratio_max) = 'log_err_ratio_max'

         profile_column_name(p_log_brunt_nu) = 'log_brunt_nu'
         profile_column_name(p_log_lamb_Sl1) = 'log_lamb_Sl1'
         profile_column_name(p_log_lamb_Sl2) = 'log_lamb_Sl2'
         profile_column_name(p_log_lamb_Sl3) = 'log_lamb_Sl3'
         profile_column_name(p_log_lamb_Sl10) = 'log_lamb_Sl10'

         profile_column_name(p_logQ) = 'logQ'

         profile_column_name(p_dlnX_dr) = 'dlnX_dr'
         profile_column_name(p_dlnY_dr) = 'dlnY_dr'
         profile_column_name(p_dlnRho_dr) = 'dlnRho_dr'
         
         cnt = 0
         do i=1,p_col_id_max
            if (len_trim(profile_column_name(i)) == 0) then
               write(*,*) 'missing name for profile column id', i
               if (i > 1) write(*,*) 'following ' // trim(profile_column_name(i-1))
               write(*,*) 
               cnt = cnt+1
            end if
         end do

         if (cnt > 0) then
            ierr = -1
            return
         end if
         
         nullify(profile_column_names_dict)
         do i=1,p_col_id_max
            call integer_dict_define(profile_column_names_dict, profile_column_name(i), i, ierr)
            if (ierr /= 0) then
               write(*,*) 'FATAL ERROR: profile_column_names_init failed in integer_dict_define'
               return
            end if
         end do

      end subroutine profile_column_names_init         
            
      
		integer function do_get_profile_id(cname)
         use utils_lib
			character (len=*), intent(in)  :: cname 
			! returns id for the profile column if there is a matching name
			! returns 0 otherwise.
			integer :: ierr, value
			call integer_dict_lookup(profile_column_names_dict, cname, value, ierr)
			if (ierr /= 0) value = 0
			do_get_profile_id = value
		end function do_get_profile_id
      


      end module star_private_def

