! ***********************************************************************
!
!   Copyright (C) 2010  Bill Paxton
!
!   MESA is free software; you can use it and/or modify
!   it under the combined terms and restrictions of the MESA MANIFESTO
!   and the GNU General Library Public License as published
!   by the Free Software Foundation; either version 2 of the License,
!   or (at your option) any later version.
!
!   You should have received a copy of the MESA MANIFESTO along with
!   this software; if not, it is available at the mesa website:
!   http://mesa.sourceforge.net/
!
!   MESA is distributed in the hope that it will be useful,
!   but WITHOUT ANY WARRANTY; without even the implied warranty of
!   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
!   See the GNU Library General Public License for more details.
!
!   You should have received a copy of the GNU Library General Public License
!   along with this software; if not, write to the Free Software
!   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
!
! ***********************************************************************

      module mod_pgstar_trho

      use star_private_def
      use const_def
      use mod_pgstar_support

      implicit none


      contains
      




      subroutine TRho_Plot(id, device_id, ierr)
         integer, intent(in) :: id, device_id
         integer, intent(out) :: ierr
         type (star_info), pointer :: s
         real :: xleft, xright, ybot, ytop
         ierr = 0
         call get_star_ptr(id, s, ierr)
         if (ierr /= 0) return
         xleft = 0.2
         xright = 0.90
         ybot = 0.2
         ytop = 0.90
         call pgslct(device_id)
         call pgbbuf()
         call pgeras()    
         call draw_TRho_Plot(s, xleft, xright, ybot, ytop, 1.0, ierr)
         if (ierr /= 0) return
         call pgebuf()
         if (s% show_TRho_cross_hair) call do_cross_hair
      end subroutine TRho_Plot



      subroutine draw_TRho_Plot(s, xleft, xright, ybot, ytop, txt_scale, ierr)
         use utils_lib
         use num_lib, only: safe_log10
         type (star_info), pointer :: s
         real, intent(in) :: xleft, xright, ybot, ytop, txt_scale
         integer, intent(out) :: ierr

         real :: xmin, xmax, ymin, ymax
         integer :: i
         real :: TRho_logT, TRho_logRho
         real :: TRho_logT_last, TRho_logRho_last
         real :: dx, dy
         real, dimension(:), pointer :: xvec, yvec
         character (len=256) :: str
         integer :: lw, lw_sav, k, kmin, kmax, id, cv_cur
         type (pgstar_data), dimension(:), pointer :: cv
         
         logical, parameter :: dbg = .false.
         
         include 'formats.dek'

         ierr = 0
         id = s% id
         cv_cur = cv_current(id)
         cv => cv_for_star(id)% cv_data
         allocate(xvec(cv_cur), yvec(cv_cur), stat=ierr)
         if (ierr /= 0) then
            write(*,*) 'allocate failed for PGSTAR TRho'
            return
         end if
         
         forall (i=1:cv_cur) xvec(i) = cv(i)% log_center_Rho
         forall (i=1:cv_cur) yvec(i) = cv(i)% log_center_T
         
         kmin = 0; kmax = 0
         do k = 1, cv_cur
            if (kmin == 0 .and. cv(k)% age >= s% TRho_age_min .and. &
                cv(k)% step >= s% TRho_step_min) kmin = k
            if(cv(k)% age > s% star_age .or. cv(k)% step > s% TRho_step_max) then
               kmax = k-1
               exit
            end if
            kmax = k
         end do
         kmin = max(1,kmin)

         xmin = minval(xvec(kmin:kmax))
         xmax = maxval(xvec(kmin:kmax))
         if (xmin == xmax) then
            xmax = xmax + 0.5
            xmin = xmin - 0.5
         end if
         dx = xmax - xmin
         dx = max(dx, 0.1)
         
         if (dbg) then
            write(*,*)
            write(*,2) 'kmax', kmax
            write(*,1) 'init xmin', dble(xmin)
            write(*,1) 'init xmax', dble(xmax)
            write(*,1) 'dx', dble(dx)
            write(*,1) 's% TRho_logRho_min', dble(s% TRho_logRho_min)
            write(*,1) 's% TRho_logRho_max', dble(s% TRho_logRho_max)
         end if
         xmin = xmin - dx*0.15
         xmax = xmax + dx*0.15
         if (s% TRho_logRho_min > -100) xmin = s% TRho_logRho_min
         if (s% TRho_logRho_max > -100) xmax = s% TRho_logRho_max
         if (dbg) then
            write(*,1) 'final xmin', dble(xmin)
            write(*,1) 'final xmax', dble(xmax)
         end if
         if (xmin > xmax) then
            if (dbg) write(*,1) 'TRho xmin > xmax', xmin, xmax
            deallocate(xvec, yvec)
            return
         end if
         if (xmin == xmax) then
            xmax = xmax + 0.5
            xmin = xmin - 0.5
         end if

         ymin = minval(yvec(kmin:kmax))
         ymax = maxval(yvec(kmin:kmax))
         if (ymin == ymax) then
            ymax = ymax + 0.5
            ymin = ymin - 0.5
         end if
         dy = ymax - ymin
         dy = max(dy, 0.1)
         
         if (dbg) then
            write(*,*)
            write(*,1) 'init ymin', dble(ymin)
            write(*,1) 'init ymax', dble(ymax)
            write(*,1) 'dy', dble(dy)
            write(*,1) 's% TRho_logRho_min', dble(s% TRho_logRho_min)
            write(*,1) 's% TRho_logRho_max', dble(s% TRho_logRho_max)
         end if
         ymin = ymin - dy*0.15
         ymax = ymax + dy*0.15
         if (s% TRho_logT_min > -100) ymin = s% TRho_logT_min
         if (s% TRho_logT_max > -100) ymax = s% TRho_logT_max
         if (dbg) then
            write(*,1) 'final ymin', dble(ymin)
            write(*,1) 'final ymax', dble(ymax)
         end if
         if (ymin >= ymax) then
            if (dbg) write(*,1) 'TRho ymin >= ymax', ymin, ymax
            deallocate(xvec, yvec)
            return
         end if

         call pgsave
         call pgsvp(xleft, xright, ybot, ytop)
         call pgswin(xmin, xmax, ymin, ymax)
         call pgscf(1)
         call pgsci(1)
         call pgsch(1.25*txt_scale)
         call pgbox('BCNST1',0.0,0,'BCNSTV1',0.0,0)
         call pgmtxt('B',3.0,0.5,0.5,"log Central Density (g cm\u-3\d)")
         call pgmtxt('L',3.3,0.5,0.5,"log Central Temperature (K)")
         call pgsch(1.2*txt_scale)
         write(str,'(i9)') s% model_number
         call pgmtxt('T',1.8,1.0,1.0,str)
         
         lw = 6
         call pgqlw(lw_sav)
         
         call pgsci(clr_Teal)
         call pgslw(lw)

         ierr = 0
         TRho_logRho_last = -999
         TRho_logT_last = -999
         do k = kmin, kmax
            TRho_logRho = xvec(k)
            TRho_logT = yvec(k)
            if(TRho_logRho_last > -99) then
               call pgmove(TRho_logRho_last, TRho_logT_last)
               call pgdraw(TRho_logRho,      TRho_logT)
            end if
            TRho_logRho_last = TRho_logRho
            TRho_logT_last = TRho_logT
         end do

         TRho_logT = cv(cv_cur)% log_center_T
         TRho_logRho = cv(cv_cur)% log_center_Rho
         if(TRho_logRho_last > -99) then
            call pgmove(TRho_logRho_last, TRho_logT_last)
            call pgdraw(TRho_logRho, TRho_logT)
         end if
         
         call pgsci(clr_Crimson)
         call pgsch(2.8*txt_scale)
         call pgpt1(TRho_logRho, TRho_logT, 0902)
         call pgunsa

         TRho_logRho_last = TRho_logRho
         TRho_logT_last = TRho_logT
         
         deallocate(xvec, yvec)
         
         call show_annotations(s, &
            s% show_TRho_annotation1, s% show_TRho_annotation2, s% show_TRho_annotation3)

      end subroutine draw_TRho_Plot


      end module mod_pgstar_trho

