! ***********************************************************************
!
!   Copyright (C) 2010  Bill Paxton
!
!   MESA is free software; you can use it and/or modify
!   it under the combined terms and restrictions of the MESA MANIFESTO
!   and the GNU General Library Public License as published
!   by the Free Software Foundation; either version 2 of the License,
!   or (at your option) any later version.
!
!   You should have received a copy of the MESA MANIFESTO along with
!   this software; if not, it is available at the mesa website:
!   http://mesa.sourceforge.net/
!
!   MESA is distributed in the hope that it will be useful,
!   but WITHOUT ANY WARRANTY; without even the implied warranty of
!   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
!   See the GNU Library General Public License for more details.
!
!   You should have received a copy of the GNU Library General Public License
!   along with this software; if not, write to the Free Software
!   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
!
! ***********************************************************************
 
      module mod_pgstar

      use star_def
      use const_def
      
      implicit none
      
      
      contains
      
      
      subroutine do_start_new_run_for_pgstar(s, ierr)
        type (star_info), pointer :: s
         integer, intent(out) :: ierr
         ierr = 0
      end subroutine do_start_new_run_for_pgstar
      
      
      subroutine do_restart_run_for_pgstar(s, ierr)
        type (star_info), pointer :: s
         integer, intent(out) :: ierr
         ierr = 0
      end subroutine do_restart_run_for_pgstar
      

      subroutine do_read_pgstar_controls(s, inlist_fname, ierr)
         type (star_info), pointer :: s
         character(*), intent(in) :: inlist_fname
         integer, intent(out) :: ierr
         ierr = 0
      end subroutine do_read_pgstar_controls
      

      subroutine do_pgstar_plots(s, ierr)
         type (star_info), pointer :: s
         integer, intent(out) :: ierr
         ierr = 0
      end subroutine do_pgstar_plots
      

      subroutine do_set_xaxis_bounds( &
            s, xaxis_by, win_xmin_in, win_xmax_in, xmargin, &
            xvec, xmin, xmax, xleft, xright, dx, &
            grid_min, grid_max, npts, ierr)
         type (star_info), pointer :: s
         character (len=*), intent(in) :: xaxis_by
         real, intent(in) :: win_xmin_in, win_xmax_in, xmargin
         real, pointer, dimension(:) :: xvec
         real, intent(out) :: xmin, xmax, xleft, xright, dx
         integer, intent(out) :: grid_min, grid_max, npts
         integer, intent(out) :: ierr
         xmin=0; xmax=0; xleft=0; xright=0; dx=0
         grid_min=0; grid_max=0; npts=0; ierr=0
      end subroutine do_set_xaxis_bounds
      
      
      subroutine do_show_xaxis_by(s,by,ierr)
         type (star_info), pointer :: s
         character (len=*), intent(in) :: by
         integer, intent(out) :: ierr
         ierr=0
      end subroutine do_show_xaxis_by
      

      end module mod_pgstar
      
