! ***********************************************************************
!
!   Copyright (C) 2010  Bill Paxton
!
!   MESA is free software; you can use it and/or modify
!   it under the combined terms and restrictions of the MESA MANIFESTO
!   and the GNU General Library Public License as published
!   by the Free Software Foundation; either version 2 of the License,
!   or (at your option) any later version.
!
!   You should have received a copy of the MESA MANIFESTO along with
!   this software; if not, it is available at the mesa website:
!   http://mesa.sourceforge.net/
!
!   MESA is distributed in the hope that it will be useful,
!   but WITHOUT ANY WARRANTY; without even the implied warranty of
!   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
!   See the GNU Library General Public License for more details.
!
!   You should have received a copy of the GNU Library General Public License
!   along with this software; if not, write to the Free Software
!   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
!
! ***********************************************************************

      module mod_pgstar_profile

      use star_private_def
      use const_def
      use mod_pgstar_support
      use mod_pgstar_trho_profile

      implicit none


      contains
      
      
      

      subroutine Profile_plot(id, device_id, ierr)
         use utils_lib
         implicit none
         integer, intent(in) :: id, device_id
         integer, intent(out) :: ierr
         type (star_info), pointer :: s
         ierr = 0
         call get_star_ptr(id, s, ierr)
         if (ierr /= 0) return
         call Pro_plot(s, device_id, &
            s% Profile_win_flag, s% Profile_file_flag, &
            s% do_Profile_win, s% do_Profile_file, &
            s% id_Profile_win, s% id_Profile_file, s% Profile_file_cnt, &
            s% Profile_file_dir, s% Profile_file_prefix, &
            s% show_Profile_legend, s% show_Profile_text_info, &
            s% show_HR_TRho_with_Profile, s% Profile_show_decorated_line, s% Profile_show_mass_locs, &
            s% show_Profile_cross_hair, s% Profile_xaxis_reversed, &
            s% Profile_yaxis_reversed, s% Profile_other_yaxis_reversed, &
            s% show_Profile_annotation1, s% show_Profile_annotation2, s% show_Profile_annotation3, &
            s% Profile_xaxis_name, s% Profile_yaxis_name, s% Profile_other_yaxis_name, &
            s% Profile_text_info_xfac, s% Profile_text_info_dxfac, &
            s% Profile_text_info_yfac, s% Profile_text_info_dyfac, &
            s% Profile_xmin, s% Profile_xmax, s% Profile_ymin, s% Profile_ymax, s% Profile_dymin, &
            s% Profile_other_ymin, s% Profile_other_ymax, s% Profile_other_dymin, &
            s% Profile_legend_coord, s% Profile_legend_fjust, &
            s% Profile_legend_disp1, s% Profile_legend_del_disp, &
            s% Profile_win_width, s% Profile_win_aspect_ratio, &
            s% prev_Profile_win_width, s% prev_Profile_win_ratio, &
            s% Profile_file_width, s% Profile_file_aspect_ratio, &
            s% prev_Profile_file_width, s% prev_Profile_file_ratio, ierr)
      end subroutine Profile_plot
      

      subroutine Profile2_plot(id, device_id, ierr)
         use utils_lib
         implicit none
         integer, intent(in) :: id, device_id
         integer, intent(out) :: ierr
         type (star_info), pointer :: s
         ierr = 0
         call get_star_ptr(id, s, ierr)
         if (ierr /= 0) return
         call Pro_plot(s, device_id, &
            s% Profile2_win_flag, s% Profile2_file_flag, &
            s% do_Profile2_win, s% do_Profile2_file, &
            s% id_Profile2_win, s% id_Profile2_file, s% Profile2_file_cnt, &
            s% Profile2_file_dir, s% Profile2_file_prefix, &
            s% show_Profile2_legend, s% show_Profile2_text_info, &
            s% show_HR_TRho_with_Profile2, s% Profile2_show_decorated_line, s% Profile2_show_mass_locs, &
            s% show_Profile2_cross_hair, s% Profile2_xaxis_reversed, &
            s% Profile2_yaxis_reversed, s% Profile2_other_yaxis_reversed, &
            s% show_Profile2_annotation1, s% show_Profile2_annotation2, s% show_Profile2_annotation3, &
            s% Profile2_xaxis_name, s% Profile2_yaxis_name, s% Profile2_other_yaxis_name, &
            s% Profile2_text_info_xfac, s% Profile2_text_info_dxfac, &
            s% Profile2_text_info_yfac, s% Profile2_text_info_dyfac, &
            s% Profile2_xmin, s% Profile2_xmax, s% Profile2_ymin, s% Profile2_ymax, s% Profile2_dymin, &
            s% Profile2_other_ymin, s% Profile2_other_ymax, s% Profile2_other_dymin, &
            s% Profile2_legend_coord, s% Profile2_legend_fjust, &
            s% Profile2_legend_disp1, s% Profile2_legend_del_disp, &
            s% Profile2_win_width, s% Profile2_win_aspect_ratio, &
            s% prev_Profile2_win_width, s% prev_Profile2_win_ratio, &
            s% Profile2_file_width, s% Profile2_file_aspect_ratio, &
            s% prev_Profile2_file_width, s% prev_Profile2_file_ratio, ierr)
      end subroutine Profile2_plot
      

      subroutine Profile3_plot(id, device_id, ierr)
         use utils_lib
         implicit none
         integer, intent(in) :: id, device_id
         integer, intent(out) :: ierr
         type (star_info), pointer :: s
         ierr = 0
         call get_star_ptr(id, s, ierr)
         if (ierr /= 0) return
         call Pro_plot(s, device_id, &
            s% Profile3_win_flag, s% Profile3_file_flag, &
            s% do_Profile3_win, s% do_Profile3_file, &
            s% id_Profile3_win, s% id_Profile3_file, s% Profile3_file_cnt, &
            s% Profile3_file_dir, s% Profile3_file_prefix, &
            s% show_Profile3_legend, s% show_Profile3_text_info, &
            s% show_HR_TRho_with_Profile3, s% Profile3_show_decorated_line, s% Profile3_show_mass_locs, &
            s% show_Profile3_cross_hair, s% Profile3_xaxis_reversed, &
            s% Profile3_yaxis_reversed, s% Profile3_other_yaxis_reversed, &
            s% show_Profile3_annotation1, s% show_Profile3_annotation2, s% show_Profile3_annotation3, &
            s% Profile3_xaxis_name, s% Profile3_yaxis_name, s% Profile3_other_yaxis_name, &
            s% Profile3_text_info_xfac, s% Profile3_text_info_dxfac, &
            s% Profile3_text_info_yfac, s% Profile3_text_info_dyfac, &
            s% Profile3_xmin, s% Profile3_xmax, s% Profile3_ymin, s% Profile3_ymax, s% Profile3_dymin, &
            s% Profile3_other_ymin, s% Profile3_other_ymax, s% Profile3_other_dymin, &
            s% Profile3_legend_coord, s% Profile3_legend_fjust, &
            s% Profile3_legend_disp1, s% Profile3_legend_del_disp, &
            s% Profile3_win_width, s% Profile3_win_aspect_ratio, &
            s% prev_Profile3_win_width, s% prev_Profile3_win_ratio, &
            s% Profile3_file_width, s% Profile3_file_aspect_ratio, &
            s% prev_Profile3_file_width, s% prev_Profile3_file_ratio, ierr)
      end subroutine Profile3_plot
      
      


      subroutine Pro_plot(s, device_id, &
            Pro_win_flag, Pro_file_flag, &
            do_Pro_win, do_Pro_file, &
            id_Pro_win, id_Pro_file, Pro_file_cnt, &
            Pro_file_dir, Pro_file_prefix, &
            show_Pro_legend, show_Pro_text_info, &
            show_HR_TRho_with_Pro, Pro_show_decorated_line, Pro_show_mass_locs, &
            show_Pro_cross_hair, Pro_xaxis_reversed, &
            Pro_yaxis_reversed, Pro_other_yaxis_reversed, &
            show_Pro_annotation1, show_Pro_annotation2, show_Pro_annotation3, &
            Pro_xaxis_name, Pro_yaxis_name, Pro_other_yaxis_name, &
            Pro_text_info_xfac, Pro_text_info_dxfac, &
            Pro_text_info_yfac, Pro_text_info_dyfac, &
            Pro_xmin, Pro_xmax, Pro_ymin, Pro_ymax, Pro_dymin, &
            Pro_other_ymin, Pro_other_ymax, Pro_other_dymin, &
            Pro_legend_coord, Pro_legend_fjust, &
            Pro_legend_disp1, Pro_legend_del_disp, &
            Pro_win_width, Pro_win_aspect_ratio, &
            prev_Pro_win_width, prev_Pro_win_ratio, &
            Pro_file_width, Pro_file_aspect_ratio, &
            prev_Pro_file_width, prev_Pro_file_ratio, ierr)
            
         use utils_lib
         use num_lib, only: safe_log10
         use mod_pgstar_hr, only: draw_HR_Plot
         use mod_pgstar_trho, only: draw_TRho_Plot
         implicit none

         type (star_info), pointer :: s
         integer, intent(in) :: device_id
         logical, intent(in) :: Pro_win_flag, Pro_file_flag
         logical, intent(in) :: do_Pro_win, do_Pro_file
         integer, intent(in) :: id_Pro_win, id_Pro_file, Pro_file_cnt
         character (len=256), intent(in) :: Pro_file_dir, Pro_file_prefix
         logical, intent(in) :: show_Pro_legend, show_Pro_text_info
         logical, intent(in) :: show_HR_TRho_with_Pro, Pro_show_decorated_line, Pro_show_mass_locs
         logical, intent(in) :: show_Pro_cross_hair, Pro_xaxis_reversed, &
            Pro_yaxis_reversed, Pro_other_yaxis_reversed
         logical, intent(in) :: show_Pro_annotation1, show_Pro_annotation2, show_Pro_annotation3
         character (len=*), intent(in) :: Pro_xaxis_name, Pro_yaxis_name, Pro_other_yaxis_name
         real, intent(in) :: &
            Pro_text_info_xfac, Pro_text_info_dxfac, &
            Pro_text_info_yfac, Pro_text_info_dyfac, &
            Pro_xmin, Pro_xmax, Pro_ymin, Pro_ymax, Pro_dymin, &
            Pro_other_ymin, Pro_other_ymax, Pro_other_dymin, &
            Pro_legend_coord, Pro_legend_fjust, &
            Pro_legend_disp1, Pro_legend_del_disp, &
            Pro_win_width, Pro_win_aspect_ratio, &
            prev_Pro_win_width, prev_Pro_win_ratio, &
            Pro_file_width, Pro_file_aspect_ratio, &
            prev_Pro_file_width, prev_Pro_file_ratio
         integer, intent(out) :: ierr
         
         real :: vp_xleft, vp_xright, vp_ybot, vp_ytop, txt_scale, &
               ymin, ymax, other_ymin, other_ymax, other_ytop, other_ybot, &
               ybot, ytop
         real :: xmin, xmax, xleft, xright
         integer :: yaxis_id, other_yaxis_id, nz
         real, pointer, dimension(:) :: xvec, yvec, other_yvec
         
         ierr = 0
         nz = s% nz
         
         if (show_HR_TRho_with_Pro) then
            txt_scale = 0.75
         else
            txt_scale = 1
         end if
         
         yaxis_id = get_axis_id(Pro_yaxis_name)
         if (yaxis_id <= 0) then
            write(*,*) 'failed to recognized requested yaxis for Profile plot ' // trim(Pro_yaxis_name)
            return
         end if
         if (len_trim(Pro_other_yaxis_name) > 0) then
            other_yaxis_id = get_axis_id(Pro_other_yaxis_name)
            if (other_yaxis_id <= 0) then
               write(*,*) 'failed to recognized requested other yaxis for Profile plot ' // &
                           trim(Pro_other_yaxis_name)
               return
            end if
         else
            other_yaxis_id = 0
         end if

         if (other_yaxis_id > 0) then
            vp_xright = 0.87
         else
            vp_xright = 0.93
         end if
         
         if (show_HR_TRho_with_Pro) then
            txt_scale = 0.75
            vp_xleft = 0.45
         else
            txt_scale = 0.9
            vp_xleft = 0.14
         end if
         
         vp_ybot = 0.1
         vp_ytop = 0.94
         
         call pgslct(device_id)
         call pgbbuf()
         call pgeras()
         
         call draw_Pro_plot(ierr)
         if (ierr /= 0) return
         
         call pgebuf()
                  
         if (show_Pro_cross_hair) call do_cross_hair
         
         
         contains
      

         subroutine draw_Pro_plot(ierr)
            use utils_lib
            use num_lib, only: safe_log10
            use mod_pgstar_hr, only: draw_HR_Plot
            use mod_pgstar_trho, only: draw_TRho_Plot
            integer, intent(out) :: ierr

            integer :: k, i, nz, kmin, kmax, cnt, y_color, clr_sav, &
               grid_min, grid_max, npts
            real :: del, xpos, ypos, xmargin, &
               dx, dy, xpos0, dxpos, dypos, dxval
            character (len=256) :: str, xname, yname, other_yname
         
            include 'formats.dek'
            ierr = 0
            y_color = clr_Goldenrod

            nz = s% nz        
            allocate (xvec(nz), yvec(nz), other_yvec(nz))
            
            do k=1,nz
               yvec(k) = get_val(s, yaxis_id, k, Pro_yaxis_name, yname)
            end do
            
            if (other_yaxis_id > 0) then
               do k=1,nz
                  other_yvec(k) = &
                     get_val(s, other_yaxis_id, k, Pro_other_yaxis_name, other_yname)
               end do
            end if
            
            xmargin = 0
            call set_xaxis_bounds( &
               s, Pro_xaxis_name, Pro_xmin, Pro_xmax, Pro_xaxis_reversed, xmargin, &
               xvec, xmin, xmax, xleft, xright, dx, &
               grid_min, grid_max, npts, ierr)
            if (ierr /= 0) then
               write(*,*) 'set_xaxis_bounds error in Profile -- please check '
               return
            end if
         
            call set_y_bounds_info
         
            if (show_HR_TRho_with_Pro) then
               call draw_HR_Plot(s,0.097,0.35,0.59,0.94,txt_scale,ierr)
               if (ierr /= 0) return
               call draw_TRho_Plot(s,0.097,0.35,0.1,0.43,txt_scale,ierr)
               if (ierr /= 0) return
            end if
         
            call pgsvp(vp_xleft, vp_xright, vp_ybot, vp_ytop)
         
            if (other_yaxis_id > 0) then
               if (other_ybot >= other_ytop) then
                  other_ytop = 1
                  other_ybot = 0
               end if
               call pgswin(xleft, xright, other_ybot, other_ytop)
               call pgscf(1)
               call pgsci(1)
               call pgsch(1.5*txt_scale)
               call pgbox('',0.0,0,'CMSTV',0.0,0)
               call pgsci(clr_Lilac)
               call pgmtxt('R',5.0,0.5,0.5,other_yname)
               call pgslw(6)
               call pgline(nz, xvec, other_yvec)
               call pgslw(1)
            end if

            if (ybot >= ytop) then
               write(*,1) 'ybot', ybot
               write(*,1) 'ytop', ytop
               write(*,*) 'draw_Pro_plot'
               ierr = -1
               return
            end if
            call pgswin(xleft, xright, ybot, ytop)
            call pgscf(1)
            call pgsci(1)
            call pgsch(1.5*txt_scale)
            if (other_yaxis_id <= 0) then
               call pgbox('BCNST1',0.0,0,'BCMNSTV1',0.0,0)
            else
               call pgbox('BCNST',0.0,0,'BNSTV',0.0,0)
            end if
            
            xname = trim(Pro_xaxis_name)
            if (xname == 'mass' .or. xname == 'h1_boundary_mass' .or. xname == 'he4_boundary_mass') &
               xname = 'mass (M\d\(2281)\u)'
            call pgmtxt('B',2.5,0.5,0.5,xname)
            call pgqci(clr_sav)
            call pgsci(y_color)
            call pgmtxt('L',4.5,0.5,0.5,yname)
            call pgsci(clr_sav)
         
            if (Pro_show_decorated_line) then
               call show_profile_line( &
                  s, xvec, yvec, txt_scale, xmin, xmax, ymin, ymax, &
                  show_Pro_legend, Pro_legend_coord, &
                  Pro_legend_disp1, Pro_legend_del_disp, Pro_legend_fjust, &
                  Pro_show_mass_locs)
            else
               call pgsci(y_color)
               call pgslw(10)
               call pgline(nz, xvec, yvec)
               call pgslw(1)
            end if

            call pgsci(1)
            call pgsch(1.2*txt_scale)
            write(str,'(i9)') s% model_number
            call pgmtxt('T',1.3,0.9,0.5,str)
         
            if (show_Pro_text_info) then
               call do_show_Profile_text_info(s, txt_scale, &
                        xmin, xmax, ymin, ymax, &
                        Pro_text_info_xfac, Pro_text_info_dxfac, &
                        Pro_text_info_yfac, Pro_text_info_dyfac, &
                        Pro_xaxis_reversed, Pro_yaxis_reversed)
            end if
         
            call show_annotations(s, &
               show_Pro_annotation1, show_Pro_annotation2, show_Pro_annotation3)

            deallocate(xvec, yvec, other_yvec)
         

         end subroutine draw_Pro_plot
      
      
         subroutine set_y_bounds_info
            integer :: grid_min, grid_max
            real :: ymargin
            include 'formats.dek'
            ymargin = 0.05
            call set_grid_minmax( &
               nz, yvec, ymin, ymax, ybot, ytop, &
               Pro_ymin, Pro_ymax, ymargin, Pro_yaxis_reversed, grid_min, grid_max, Pro_dymin)
            if (other_yaxis_id <= 0) return
            call set_grid_minmax( &
               nz, other_yvec, other_ymin, other_ymax, other_ybot, other_ytop, &
               Pro_other_ymin, Pro_other_ymax, ymargin, Pro_other_yaxis_reversed, &
               grid_min, grid_max, Pro_other_dymin)
         end subroutine set_y_bounds_info
         
         
      end subroutine Pro_plot
      

      end module mod_pgstar_profile

