! ***********************************************************************
!
!   Copyright (C) 2010  Bill Paxton
!
!   MESA is free software; you can use it and/or modify
!   it under the combined terms and restrictions of the MESA MANIFESTO
!   and the GNU General Library Public License as published
!   by the Free Software Foundation; either version 2 of the License,
!   or (at your option) any later version.
!
!   You should have received a copy of the MESA MANIFESTO along with
!   this software; if not, it is available at the mesa website:
!   http://mesa.sourceforge.net/
!
!   MESA is distributed in the hope that it will be useful,
!   but WITHOUT ANY WARRANTY; without even the implied warranty of
!   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
!   See the GNU Library General Public License for more details.
!
!   You should have received a copy of the GNU Library General Public License
!   along with this software; if not, write to the Free Software
!   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
!
! ***********************************************************************

      module mod_pgstar_mixing_Ds

      use star_private_def
      use const_def
      use mod_pgstar_support
      use mod_pgstar_trho_profile

      implicit none


      contains
      

      subroutine Mixing_Ds_plot(id, device_id, ierr)
         implicit none
         integer, intent(in) :: id, device_id
         integer, intent(out) :: ierr
         
         real :: winxmin, winxmax, winymin, winymax, label_scale

         type (star_info), pointer :: s

         ierr = 0
         call get_star_ptr(id, s, ierr)
         if (ierr /= 0) return

         call pgslct(device_id)
         call pgbbuf()
         call pgeras()
         
         winxmin = 0.14
         winxmax = 0.85
         winymin = 0.13
         winymax = 0.92
         label_scale = 1.2
         
         call do_Mixing_Ds_plot(id, device_id, &
            winxmin, winxmax, winymin, winymax, &
            s% Mixing_Ds_xaxis_by, s% Mixing_Ds_xmin, s% Mixing_Ds_xmax, &
            label_scale, ierr)

         call pgebuf()
         
      end subroutine Mixing_Ds_plot

      
      subroutine do_Mixing_Ds_plot(id, device_id, &
            winxmin, winxmax, winymin, winymax, &
            xaxis_by, xaxis_min, xaxis_max, label_scale, ierr)
         implicit none
         integer, intent(in) :: id, device_id
         real, intent(in) :: winxmin, winxmax, winymin, winymax
         character (len=256) :: xaxis_by
         real, intent(in) :: xaxis_min, xaxis_max, label_scale
         integer, intent(out) :: ierr
         
         type (star_info), pointer :: s

         ierr = 0
         call get_star_ptr(id, s, ierr)
         if (ierr /= 0) return
         
         call MixDs_plot(s, device_id, &
            s% Mixing_Ds_win_flag, s% Mixing_Ds_file_flag, &
            s% do_Mixing_Ds_win, s% do_Mixing_Ds_file, &
            s% id_Mixing_Ds_win, s% id_Mixing_Ds_file, s% Mixing_Ds_file_cnt, &
            s% Mixing_Ds_file_dir, s% Mixing_Ds_file_prefix, &
            s% show_Mixing_Ds_cross_hair, &
            s% show_Mixing_Ds_annotation1, s% show_Mixing_Ds_annotation2, &
            s% show_Mixing_Ds_annotation3, &
            xaxis_by, xaxis_min, xaxis_max, &
            s% Mixing_Ds_ymin, s% Mixing_Ds_ymax, s% Mixing_Ds_dymin, &
            s% Mixing_Ds_win_width, s% Mixing_Ds_win_aspect_ratio, &
            s% prev_Mixing_Ds_win_width, s% prev_Mixing_Ds_win_ratio, &
            s% Mixing_Ds_file_width, s% Mixing_Ds_file_aspect_ratio, &
            s% prev_Mixing_Ds_file_width, s% prev_Mixing_Ds_file_ratio, &
            winxmin, winxmax, winymin, winymax, label_scale, ierr)
         
      end subroutine do_Mixing_Ds_plot
      


      subroutine MixDs_plot(s, device_id, &
            MixDs_win_flag, MixDs_file_flag, &
            do_MixDs_win, do_MixDs_file, &
            id_MixDs_win, id_MixDs_file, MixDs_file_cnt, &
            MixDs_file_dir, MixDs_file_prefix, &
            show_MixDs_cross_hair, &
            show_MixDs_annotation1, show_MixDs_annotation2, show_MixDs_annotation3, &
            MixDs_xaxis_by, MixDs_xmin, MixDs_xmax, &
            MixDs_ymin, MixDs_ymax, MixDs_dymin, &
            MixDs_win_width, MixDs_win_aspect_ratio, &
            prev_MixDs_win_width, prev_MixDs_win_ratio, &
            MixDs_file_width, MixDs_file_aspect_ratio, &
            prev_MixDs_file_width, prev_MixDs_file_ratio, &
            winxmin, winxmax, winymin, winymax, label_scale, ierr)
            
         use utils_lib
         use num_lib, only: safe_log10
         implicit none

         type (star_info), pointer :: s
         integer, intent(in) :: device_id
         logical, intent(in) :: MixDs_win_flag, MixDs_file_flag
         logical, intent(in) :: do_MixDs_win, do_MixDs_file
         integer, intent(in) :: id_MixDs_win, id_MixDs_file, MixDs_file_cnt
         character (len=256), intent(in) :: MixDs_file_dir, MixDs_file_prefix
         logical, intent(in) :: show_MixDs_cross_hair
         logical, intent(in) :: show_MixDs_annotation1, show_MixDs_annotation2, show_MixDs_annotation3
         character (len=*), intent(in) :: MixDs_xaxis_by
         real, intent(in) :: &
            MixDs_xmin, MixDs_xmax, &
            MixDs_ymin, MixDs_ymax, MixDs_dymin, &
            MixDs_win_width, MixDs_win_aspect_ratio, &
            prev_MixDs_win_width, prev_MixDs_win_ratio, &
            MixDs_file_width, MixDs_file_aspect_ratio, &
            prev_MixDs_file_width, prev_MixDs_file_ratio
         real, intent(in) :: winxmin, winxmax, winymin, winymax, label_scale
         integer, intent(out) :: ierr
         
         real :: chScale, windy, xmargin
         real :: xmin, xmax, xleft, xright, dx, tmp, ymin, ymax, ymin2, ymax2, dy
         integer :: grid_min, grid_max, npts, nz
         real, pointer, dimension(:) :: xvec, yvec, y_conv, y_sc, y_ovr, y_th
         
         include 'formats.dek'
         ierr = 0
                  
         xmargin = 0

         chScale = label_scale

         nz = s% nz
         allocate (xvec(nz), yvec(nz), y_conv(nz), y_sc(nz), y_ovr(nz), y_th(nz))
         
         call set_xaxis_bounds( &
            s, MixDs_xaxis_by, MixDs_xmin, MixDs_xmax, .false., xmargin, &
            xvec, xmin, xmax, xleft, xright, dx, &
            grid_min, grid_max, npts, ierr)
         if (ierr /= 0) return

         call plot(ierr)
         if (ierr /= 0) return
         
         call show_annotations(s, &
            show_MixDs_annotation1, show_MixDs_annotation2, show_MixDs_annotation3)

         deallocate(xvec, yvec, y_conv, y_sc, y_ovr, y_th)
                  
         if (show_MixDs_cross_hair) call do_cross_hair
         
         
         contains
         
         
         subroutine plot(ierr)
            use mlt_def
            integer, intent(out) :: ierr
            
            integer :: lw, lw_sav
            real :: val
            character (len=128) :: str
            integer :: i, ii, k
            logical :: rotation
         
            include 'formats.dek'
            ierr = 0
            
            rotation = s% rotation_flag
            
            call pgsave
                       
            lw = 8
            call pgqlw(lw_sav)
            
            call pgsvp(winxmin, winxmax, winymin, winymax)
            
            ! title
            call pgsch(chScale*1.2)
            call pgmtxt('T',1.5,0.5,0.5,'Diffusion Coefficients')
         
            call pgsch(label_scale)
            write(str,'(i9)') s% model_number
            call pgmtxt('T',1.8,0.9,0.5,str)
            
            ! xlabel
            call pgsci(1)
            call pgsch(label_scale)
            call show_xaxis_by(s,MixDs_xaxis_by,ierr)
            if (ierr /= 0) return
            
            y_conv(:) = -100
            y_sc(:) = -100
            y_ovr(:) = -100
            y_th(:) = -100
            do k=grid_min, grid_max
               val = safe_log10(s% D_mix_non_rotation(k))
               select case (s% mixing_type(k))
                  case (convective_mixing)
                     y_conv(k) = val
                  case (semiconvective_mixing)
                     y_sc(k) = val
                  case (overshoot_mixing)
                     y_ovr(k) = val
                  case (thermo_haline_mixing)
                     y_th(k) = val
               end select
            end do

            if (MixDs_ymax > -100) then
               ymax = MixDs_ymax
            else
               ymax = max(18d0,maxval(y_conv(grid_min:grid_max)))
               ymax2 = max(18d0,maxval(y_sc(grid_min:grid_max)))
               if (ymax2 > ymax) ymax = ymax2
               ymax2 = max(18d0,maxval(y_ovr(grid_min:grid_max)))
               if (ymax2 > ymax) ymax = ymax2
               ymax2 = max(18d0,maxval(y_th(grid_min:grid_max)))
               if (ymax2 > ymax) ymax = ymax2
               if (rotation) then
                  ymax2 = max(18d0,safe_log10(maxval(s% D_DSI(grid_min:grid_max))))
                  if (ymax2 > ymax) ymax = ymax2
                  ymax2 = max(18d0,safe_log10(maxval(s% D_SH(grid_min:grid_max))))
                  if (ymax2 > ymax) ymax = ymax2
                  ymax2 = max(18d0,safe_log10(maxval(s% D_SSI(grid_min:grid_max))))
                  if (ymax2 > ymax) ymax = ymax2
                  ymax2 = max(18d0,safe_log10(maxval(s% D_ES(grid_min:grid_max))))
                  if (ymax2 > ymax) ymax = ymax2
                  ymax2 = max(18d0,safe_log10(maxval(s% D_GSF(grid_min:grid_max))))
                  if (ymax2 > ymax) ymax = ymax2
                  ymax2 = max(18d0,safe_log10(maxval(s% D_ST(grid_min:grid_max))))
                  if (ymax2 > ymax) ymax = ymax2
               end if
            end if
            
            if (MixDs_ymin > -100) then
               ymin = MixDs_ymin
            else
               ymin = max(0d0,minval(y_conv(grid_min:grid_max)))
               ymin2 = max(0d0,minval(y_sc(grid_min:grid_max)))
               if (ymin2 < ymin) ymin = ymin2
               ymin2 = max(0d0,minval(y_ovr(grid_min:grid_max)))
               if (ymin2 < ymin) ymin = ymin2
               ymin2 = max(0d0,minval(y_th(grid_min:grid_max)))
               if (ymin2 < ymin) ymin = ymin2
               if (rotation) then
                  ymin2 = max(0d0,safe_log10(minval(s% D_DSI(grid_min:grid_max))))
                  if (ymin2 < ymin) ymin = ymin2
                  ymin2 = max(0d0,safe_log10(minval(s% D_SH(grid_min:grid_max))))
                  if (ymin2 < ymin) ymin = ymin2
                  ymin2 = max(0d0,safe_log10(minval(s% D_SSI(grid_min:grid_max))))
                  if (ymin2 < ymin) ymin = ymin2
                  ymin2 = max(0d0,safe_log10(minval(s% D_ES(grid_min:grid_max))))
                  if (ymin2 < ymin) ymin = ymin2
                  ymin2 = max(0d0,safe_log10(minval(s% D_GSF(grid_min:grid_max))))
                  if (ymin2 < ymin) ymin = ymin2
                  ymin2 = max(0d0,safe_log10(minval(s% D_ST(grid_min:grid_max))))
                  if (ymin2 < ymin) ymin = ymin2
               end if
            end if
            
            dy = ymax-ymin
            if (MixDs_dymin > -100) dy = MixDs_dymin
            ymax = ymax + 0.05*dy
            ymin = ymin - 0.05*dy

            call pgswin(xleft, xright, ymin, ymax)
            
            call pgsci(1)         

            call pgsch(label_scale)
            call pgbox('BCNST',0.0,0,'BCNMSTV',0.0,0)
            call pgmtxt('L',3.5,0.5,0.5,'log D (cm\u2\d s\u-1\d)')
            
            call pgsch(label_scale*1.6)
            
            if (rotation) then
            
               yvec(grid_min:grid_max) = safe_log10(s% D_ST(grid_min:grid_max))
               call pgsci(clr_Teal)
               call pgmtxt('R',3.5,1.0,1.0,'ST')
               call pgslw(lw)
               call pgline(npts, xvec(grid_min:grid_max), yvec(grid_min:grid_max))
               call pgslw(lw_sav)
            
               yvec(grid_min:grid_max) = safe_log10(s% D_DSI(grid_min:grid_max))
               call pgsci(clr_Goldenrod)
               call pgmtxt('R',3.5,0.0,0.0,'DSI')
               call pgslw(lw)
               call pgline(npts, xvec(grid_min:grid_max), yvec(grid_min:grid_max))
               call pgslw(lw_sav)
            
               yvec(grid_min:grid_max) = safe_log10(s% D_SH(grid_min:grid_max))
               call pgsci(clr_Lilac)
               call pgmtxt('R',3.5,0.2,0.5,'SH')
               call pgslw(lw)
               call pgline(npts, xvec(grid_min:grid_max), yvec(grid_min:grid_max))
               call pgslw(lw_sav)
            
               yvec(grid_min:grid_max) = safe_log10(s% D_SSI(grid_min:grid_max))
               call pgsci(clr_Coral)
               call pgmtxt('R',3.5,0.4,0.5,'SSI')
               call pgslw(lw)
               call pgline(npts, xvec(grid_min:grid_max), yvec(grid_min:grid_max))
               call pgslw(lw_sav)
            
               yvec(grid_min:grid_max) = safe_log10(s% D_GSF(grid_min:grid_max))
               call pgsci(clr_MediumSlateBlue)
               call pgmtxt('R',3.5,0.8,0.5,'GSF')
               call pgslw(lw)
               call pgline(npts, xvec(grid_min:grid_max), yvec(grid_min:grid_max))
               call pgslw(lw_sav)
            
               yvec(grid_min:grid_max) = safe_log10(s% D_ES(grid_min:grid_max))
               call pgsci(clr_FireBrick)
               call pgmtxt('R',3.5,0.6,0.5,'ES')
               call pgslw(lw)
               call pgline(npts, xvec(grid_min:grid_max), yvec(grid_min:grid_max))
               call pgslw(lw_sav)
               
            end if
            
            call pgsci(clr_LightSkyBlue)
            call pgmtxt('R',2.3,0.0,0.0,'conv')
            call pgslw(lw)
            call pgline(npts, xvec(grid_min:grid_max), y_conv(grid_min:grid_max))
            call pgslw(lw_sav)

            call pgsci(clr_SlateGray)
            call pgmtxt('R',2.3,0.35,0.5,'semi')
            call pgslw(lw)
            call pgline(npts, xvec(grid_min:grid_max), y_sc(grid_min:grid_max))
            call pgslw(lw_sav)

            call pgsci(clr_Lilac)
            call pgmtxt('R',2.3,0.62,0.5,'thermo')
            call pgslw(lw)
            call pgline(npts, xvec(grid_min:grid_max), y_th(grid_min:grid_max))
            call pgslw(lw_sav)

            call pgsci(clr_Beige)
            call pgmtxt('R',2.3,1.0,1.0,'over')
            call pgslw(lw)
            call pgline(npts, xvec(grid_min:grid_max), y_ovr(grid_min:grid_max))
            call pgslw(lw_sav)

            call pgunsa
            
         end subroutine plot
      
         
      end subroutine MixDs_plot
      

      end module mod_pgstar_mixing_Ds

