! ***********************************************************************
!
!   Copyright (C) 2010  Bill Paxton
!
!   MESA is free software; you can use it and/or modify
!   it under the combined terms and restrictions of the MESA MANIFESTO
!   and the GNU General Library Public License as published
!   by the Free Software Foundation; either version 2 of the License,
!   or (at your option) any later version.
!
!   You should have received a copy of the MESA MANIFESTO along with
!   this software; if not, it is available at the mesa website:
!   http://mesa.sourceforge.net/
!
!   MESA is distributed in the hope that it will be useful,
!   but WITHOUT ANY WARRANTY; without even the implied warranty of
!   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
!   See the GNU Library General Public License for more details.
!
!   You should have received a copy of the GNU Library General Public License
!   along with this software; if not, write to the Free Software
!   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
!
! ***********************************************************************

      module mod_pgstar_logg_Teff

      use star_private_def
      use const_def
      use mod_pgstar_support

      implicit none


      contains
      




      subroutine loggTe_Plot(id, device_id, ierr)
         integer, intent(in) :: id, device_id
         integer, intent(out) :: ierr
         type (star_info), pointer :: s
         real :: xleft, xright, ybot, ytop
         ierr = 0
         call get_star_ptr(id, s, ierr)
         if (ierr /= 0) return
         xleft = 0.2
         xright = 0.90
         ybot = 0.2
         ytop = 0.90
         call pgslct(device_id)
         call pgbbuf()
         call pgeras()    
         call draw_loggTe_Plot(s, xleft, xright, ybot, ytop, 1.0,ierr)
         if (ierr /= 0) return
         call pgebuf()
         if (s% show_loggTe_cross_hair) call do_cross_hair
      end subroutine loggTe_Plot



      subroutine draw_loggTe_Plot(s, xleft, xright, ybot, ytop, txt_scale, ierr)
         use utils_lib
         use num_lib, only: safe_log10
         type (star_info), pointer :: s
         real, intent(in) :: xleft, xright, ybot, ytop, txt_scale
         integer, intent(out) :: ierr

         real :: xmin, xmax, ymin, ymax
         integer :: i
         real :: loggTe_logg, loggTe_Teff, dlogg, dTeff
         real :: loggTe_logg_last, loggTe_Teff_last
         real :: dx, dy
         real, dimension(:), pointer :: xvec, yvec
         character (len=256) :: str
         integer :: lw, lw_sav, k, kmin, kmax, id, cv_cur, n_sigma, &
            j_min, j_max, j
         type (pgstar_data), dimension(:), pointer :: cv
         
         logical, parameter :: dbg = .false.
         
         include 'formats.dek'
         
         ierr = 0
         id = s% id
         cv_cur = cv_current(id)
         cv => cv_for_star(id)% cv_data

         allocate(xvec(cv_cur), yvec(cv_cur), stat=ierr)
         if (ierr /= 0) then
            write(*,*) 'allocate failed for PGSTAR loggTe'
            return
         end if
         
         do i=1,cv_cur
            k = cv_cur+1-i
            xvec(k) = 10d0**cv(k)% log_Teff
            yvec(k) = &
               safe_log10(s% cgrav(k)*Msun*cv(k)% star_mass) - 2*(cv(k)% log_surface_R + log10(Rsun))
         end do
         
         kmin = 0; kmax = 0
         do k = 1, cv_cur
            if (kmin == 0 .and. cv(k)% age >= s% loggTe_age_min .and. &
                cv(k)% step >= s% loggTe_step_min) kmin = k
            if (cv(k)% age > s% star_age .or. cv(k)% step > s% loggTe_step_max) then
               kmax = k-1
               exit
            end if
            kmax = k
         end do
         kmin = max(1,kmin)

         xmin = minval(xvec(kmin:kmax))
         xmax = maxval(xvec(kmin:kmax))
         if (xmin == xmax) then
            xmax = xmax + 0.5
            xmin = xmin - 0.5
         end if
         dx = xmax - xmin
         
         if (dbg) then
            write(*,*)
            write(*,2) 'kmax', kmax
            write(*,1) 'init xmin', dble(xmin)
            write(*,1) 'init xmax', dble(xmax)
            write(*,1) 'dx', dble(dx)
            write(*,1) 'loggTe_Teff_min', dble(s% loggTe_Teff_min)
            write(*,1) 'loggTe_Teff_max', dble(s% loggTe_Teff_max)
         end if
         xmin = xmin - dx*0.15
         xmax = xmax + dx*0.15
         if (s% loggTe_Teff_min > -100) xmin = s% loggTe_Teff_min
         if (s% loggTe_Teff_max > -100) xmax = s% loggTe_Teff_max
         if (dbg) then
            write(*,1) 'final xmin', dble(xmin)
            write(*,1) 'final xmax', dble(xmax)
         end if
         if (xmin > xmax) then
            if (dbg) write(*,1) 'loggTe xmin > xmax', xmin, xmax
            deallocate(xvec, yvec)
            return
         end if
         if (xmin == xmax) then
            xmax = xmax + 0.5
            xmin = xmin - 0.5
         end if

         ymin = minval(yvec(kmin:kmax))
         ymax = maxval(yvec(kmin:kmax))
         if (ymin == ymax) then
            ymax = ymax + 0.5
            ymin = ymin - 0.5
         end if
         dy = ymax - ymin
         
         if (dbg) then
            write(*,*)
            write(*,1) 'init ymin', dble(ymin)
            write(*,1) 'init ymax', dble(ymax)
            write(*,1) 'dy', dble(dy)
            write(*,1) 'loggTe_Teff_min', dble(s% loggTe_Teff_min)
            write(*,1) 'loggTe_Teff_max', dble(s% loggTe_Teff_max)
         end if
         ymin = ymin - dy*0.15
         ymax = ymax + dy*0.15
         if (s% loggTe_logg_min > -100) ymin = s% loggTe_logg_min
         if (s% loggTe_logg_max > -100) ymax = s% loggTe_logg_max
         if (dbg) then
            write(*,1) 'final ymin', dble(ymin)
            write(*,1) 'final ymax', dble(ymax)
         end if
         if (ymin >= ymax) then
            if (dbg) write(*,1) 'loggTe ymin >= ymax', ymin, ymax
            deallocate(xvec, yvec)
            return
         end if

         call pgsave
         call pgsvp(xleft, xright, ybot, ytop)
         call pgswin(xmax, xmin, ymax, ymin)
         call pgscf(1)
         call pgsci(1)
         call pgsch(1.25*txt_scale)
         call pgbox('BCNST1',0.0,0,'BCNSTV1',0.0,0)
         call pgmtxt('B',3.0,0.5,0.5,"Teff")
         call pgmtxt('L',3.3,0.5,0.5,"log g")
         call pgsch(1.2*txt_scale)
         write(str,'(i9)') s% model_number
         call pgmtxt('T',1.8,1.0,1.0,str)
         
         call pgqlw(lw_sav)
         lw = 6
         call pgslw(lw)
         
         if (s% show_loggTe_target_box) then
            call pgsci(clr_Silver)
            loggTe_logg = s% loggTe_target_logg
            loggTe_Teff = s% loggTe_target_Teff
            n_sigma = s% loggTe_target_n_sigma
            if (n_sigma >= 0) then
               j_min = n_sigma
               j_max = n_sigma
            else
               j_min = 1
               j_max = -n_sigma
            end if
            do j=j_min, j_max
               dlogg = s% loggTe_target_logg_sigma * j
               dTeff = s% loggTe_target_Teff_sigma * j
               call pgmove(loggTe_Teff - dTeff, loggTe_logg - dlogg)
               call pgdraw(loggTe_Teff + dTeff, loggTe_logg - dlogg)
               call pgdraw(loggTe_Teff + dTeff, loggTe_logg + dlogg)
               call pgdraw(loggTe_Teff - dTeff, loggTe_logg + dlogg)
               call pgdraw(loggTe_Teff - dTeff, loggTe_logg - dlogg)
            end do
         end if
         
         call pgsci(clr_Teal)

         ierr = 0
         loggTe_Teff_last = -999
         loggTe_logg_last = -999
         do k = kmin, kmax
            loggTe_Teff = xvec(k)
            loggTe_logg = yvec(k)
            if(loggTe_Teff_last > -99) then
               call pgmove(loggTe_Teff_last, loggTe_logg_last)
               call pgdraw(loggTe_Teff, loggTe_logg)
            end if
            loggTe_Teff_last = loggTe_Teff
            loggTe_logg_last = loggTe_logg
         end do

         loggTe_logg = yvec(cv_cur)
         loggTe_Teff = xvec(cv_cur)
         if(loggTe_Teff_last > -99) then
            call pgmove(loggTe_Teff_last, loggTe_logg_last)
            call pgdraw(loggTe_Teff, loggTe_logg)
         end if
         
         call pgsci(clr_Crimson)
         call pgsch(2.8*txt_scale)
         call pgpt1(loggTe_Teff, loggTe_logg, 0902)
         call pgunsa

         loggTe_Teff_last = loggTe_Teff
         loggTe_logg_last = loggTe_logg
         
         deallocate(xvec, yvec)
         
         call show_annotations(s, &
            s% show_loggTe_annotation1, s% show_loggTe_annotation2, s% show_loggTe_annotation3)

      end subroutine draw_loggTe_Plot


      end module mod_pgstar_logg_Teff

