! ***********************************************************************
!
!   Copyright (C) 2010  Bill Paxton
!
!   MESA is free software; you can use it and/or modify
!   it under the combined terms and restrictions of the MESA MANIFESTO
!   and the GNU General Library Public License as published
!   by the Free Software Foundation; either version 2 of the License,
!   or (at your option) any later version.
!
!   You should have received a copy of the MESA MANIFESTO along with
!   this software; if not, it is available at the mesa website:
!   http://mesa.sourceforge.net/
!
!   MESA is distributed in the hope that it will be useful,
!   but WITHOUT ANY WARRANTY; without even the implied warranty of
!   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
!   See the GNU Library General Public License for more details.
!
!   You should have received a copy of the GNU Library General Public License
!   along with this software; if not, write to the Free Software
!   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
!
! ***********************************************************************

      module mod_pgstar_hr_trho

      use star_private_def
      use const_def
      use mod_pgstar_support

      implicit none


      contains
      

      subroutine HR_TRho_plot(id, device_id, ierr)
         use utils_lib
         use mod_pgstar_hr, only: draw_HR_Plot
         use mod_pgstar_trho, only: draw_TRho_Plot
         use mod_pgstar_conv, only: draw_Convection_Plot
         implicit none

         integer, intent(in) :: id, device_id
         integer, intent(out) :: ierr

         integer :: nplots
         real :: txt_scale, vpxmin, vpxmax, vpymin, vpymax, vpymargin, vpwinheight
         type (star_info), pointer :: s
         
         include 'formats.dek'
         ierr = 0
         call get_star_ptr(id, s, ierr)
         if (ierr /= 0) return

         call pgslct(device_id)
         call pgbbuf()
         call pgeras()
                  
         nplots = 2
         txt_scale = 0.75
         vpxmin = 0.2
         vpxmax = 0.95
         vpymin = 0.12
         vpymax = 0.96
         vpymargin = 0.12
         vpwinheight = (vpymax - vpymin - (nplots-1)*vpymargin)/nplots
         if (nplots == 2) then
            call draw_HR_Plot(s,vpxmin,vpxmax,vpymax-vpwinheight,vpymax,txt_scale,ierr)
            if (ierr /= 0) return
            call draw_TRho_Plot(s,vpxmin,vpxmax,vpymin,vpymin+vpwinheight,txt_scale,ierr)
            if (ierr /= 0) return
         else 
            call draw_Convection_Plot(s,vpxmin,vpxmax,vpymax-vpwinheight,vpymax,txt_scale,ierr)
            if (ierr /= 0) return
            call draw_HR_Plot(s,vpxmin,vpxmax, &
                     vpymin+vpwinheight+vpymargin,vpymax-vpwinheight-vpymargin,txt_scale,ierr)
            if (ierr /= 0) return
            call draw_TRho_Plot(s,vpxmin,vpxmax,vpymin,vpymin+vpwinheight,txt_scale,ierr)
            if (ierr /= 0) return
         end if 

         call pgebuf()
      
      end subroutine HR_TRho_plot
      

      end module mod_pgstar_hr_trho

