! ***********************************************************************
!
!   Copyright (C) 2010  Bill Paxton
!
!   MESA is free software; you can use it and/or modify
!   it under the combined terms and restrictions of the MESA MANIFESTO
!   and the GNU General Library Public License as published
!   by the Free Software Foundation; either version 2 of the License,
!   or (at your option) any later version.
!
!   You should have received a copy of the MESA MANIFESTO along with
!   this software; if not, it is available at the mesa website:
!   http://mesa.sourceforge.net/
!
!   MESA is distributed in the hope that it will be useful,
!   but WITHOUT ANY WARRANTY; without even the implied warranty of
!   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
!   See the GNU Library General Public License for more details.
!
!   You should have received a copy of the GNU Library General Public License
!   along with this software; if not, write to the Free Software
!   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
!
! ***********************************************************************

      module mod_pgstar_hr

      use star_private_def
      use const_def
      use mod_pgstar_support

      implicit none


      contains
      

      subroutine HR_Plot(id, device_id, ierr)
         integer, intent(in) :: id, device_id
         integer, intent(out) :: ierr
         type (star_info), pointer :: s
         real :: xleft, xright, ybot, ytop
         ierr = 0
         call get_star_ptr(id, s, ierr)
         if (ierr /= 0) return
         xleft = 0.2
         xright = 0.90
         ybot = 0.2
         ytop = 0.90
         call pgslct(device_id)
         call pgbbuf()
         call pgeras()    
         call draw_HR_Plot(s, xleft, xright, ybot, ytop, 1.0, ierr)
         if (ierr /= 0) return
         call pgebuf()
         if (s% show_HR_cross_hair) call do_cross_hair
      end subroutine HR_Plot
      

      subroutine draw_HR_Plot(s, xleft, xright, ybot, ytop, txt_scale, ierr)
         use utils_lib
         use num_lib, only: safe_log10
         type (star_info), pointer :: s
         real, intent(in) :: xleft, xright, ybot, ytop, txt_scale
         integer, intent(out) :: ierr
         
         real :: xmin, xmax, ymin, ymax
         real :: HR_logL, HR_logTeff, HR_Teff, dlogL, dTeff
         real :: HR_logL_last, HR_logTeff_last
         real :: del, dx, dy
         real, dimension(:), pointer :: xvec, yvec
         character (len=256) :: str
         integer :: i, lw, lw_sav, k, kmin, kmax, id, cv_cur, n_sigma, &
            j_min, j_max, j
         type (pgstar_data), dimension(:), pointer :: cv

         ! Spectral types for the top axis (ajc = Annie Jump Cannon!)
         integer, parameter :: najc = 9
         character (len=4) :: ajcname(najc)
         real :: ajclogT(najc)
         data ajcname /'O5','B0','B5','A0','F0','G0','K0','M0','RNS'/
         data ajclogT /4.6,4.447,4.182,3.996,3.869,3.780,3.690,3.542,3.4/
         
         logical, parameter :: dbg = .false.
         
         include 'formats.dek'
         
         ierr = 0
         id = s% id
         cv_cur = cv_current(id)
         cv => cv_for_star(id)% cv_data
         lw = 6
         call pgqlw(lw_sav)

         allocate(xvec(cv_cur), yvec(cv_cur), stat=ierr)
         if (ierr /= 0) then
            write(*,*) 'allocate failed for PGSTAR HR'
            return
         end if
         
         forall (i=1:cv_cur) xvec(i) = cv(i)% log_Teff
         forall (i=1:cv_cur) yvec(i) = cv(i)% log_L
         
         kmin = 0; kmax = 0
         do k = 1, cv_cur
            if (kmin == 0 .and. cv(k)% age >= s% HR_age_min .and. &
                cv(k)% step >= s% HR_step_min) kmin = k
            if (cv(k)% age > s% star_age .or. cv(k)% step > s% HR_step_max) then
               kmax = k-1
               exit
            end if
            kmax = k
         end do
         kmin = max(1,kmin)

         xmin = minval(xvec(kmin:kmax))
         xmax = maxval(xvec(kmin:kmax))
         if (xmin == xmax) then
            xmax = xmax + 0.5
            xmin = xmin - 0.5
         end if
         dx = xmax - xmin
         dx = max(dx, 0.1)
         
         xmin = xmin - dx*0.15
         xmax = xmax + dx*0.15
         if (s% HR_logT_min > -100) xmin = s% HR_logT_min
         if (s% HR_logT_max > -100) xmax = s% HR_logT_max
         if (xmin >= xmax) then
            if (dbg) write(*,1) 'HR xmin >= xmax', xmin, xmax
            deallocate(xvec, yvec)
            return
         end if

         ymin = minval(yvec(kmin:kmax))
         ymax = maxval(yvec(kmin:kmax))
         if (ymin == ymax) then
            ymax = ymax + 0.5
            ymin = ymin - 0.5
         end if
         dy = ymax - ymin
         dy = max(dy, 0.1)
         
         ymin = ymin - dy*0.15
         ymax = ymax + dy*0.15
         if (s% HR_logL_min > -100) ymin = s% HR_logL_min
         if (s% HR_logL_max > -100) ymax = s% HR_logL_max
         if (ymin >= ymax) then
            if (dbg) write(*,1) 'HR ymin >= ymax', ymin, ymax
            deallocate(xvec, yvec)
            return
         end if
         
         call pgsave
         call pgsvp(xleft, xright, ybot, ytop)
         call pgswin(xmax, xmin, ymin, ymax)
         call pgscf(1)
         call pgsci(1)
         call pgsch(1.25*txt_scale)
         call pgbox('BCNST1',0.0,0,'BCNSTV1',0.0,0)
         call pgmtxt('B',3.0,0.5,0.5,"log Teff")
         call pgmtxt('L',3.3,0.5,0.5,"log L/L\d\(2281)")
         
         if (txt_scale >= 1.0) then
            del = 0.02*(ymax-ymin) ! put ajc labels 2% above plot
            do i = 1, najc
               if (ajclogT(i)>xmin .and. ajclogT(i)<xmax) &
                  call pgptxt(ajclogT(i),ymax+del,0.0,0.5,trim(ajcname(i)))
            end do
         end if
         
         call pgsch(1.2*txt_scale)
         write(str,'(i9)') s% model_number
         call pgmtxt('T',1.8,1.0,1.0,str)

         call pgslw(lw)
         
         if (s% show_HR_target_box) then
            call pgsci(clr_Silver)
            HR_logL = s% HR_target_logL
            HR_Teff = s% HR_target_Teff
            n_sigma = s% HR_target_n_sigma
            if (n_sigma >= 0) then
               j_min = n_sigma
               j_max = n_sigma
            else
               j_min = 1
               j_max = -n_sigma
            end if
            do j=j_min, j_max
               dlogL = s% HR_target_logL_sigma * j
               dTeff = s% HR_target_Teff_sigma * j
               call pgmove(log10(HR_Teff - dTeff), HR_logL - dlogL)
               call pgdraw(log10(HR_Teff + dTeff), HR_logL - dlogL)
               call pgdraw(log10(HR_Teff + dTeff), HR_logL + dlogL)
               call pgdraw(log10(HR_Teff - dTeff), HR_logL + dlogL)
               call pgdraw(log10(HR_Teff - dTeff), HR_logL - dlogL)
            end do
         end if
         
         call pgsci(clr_Teal)

         ierr = 0
         HR_logTeff_last = -999
         HR_logL_last = -999
         do k = kmin, kmax
            HR_logTeff = xvec(k)
            HR_logL = yvec(k)
            if (HR_logTeff_last > -99) then
               call pgmove(HR_logTeff_last, HR_logL_last)
               call pgdraw(HR_logTeff, HR_logL)
            end if
            HR_logTeff_last = HR_logTeff
            HR_logL_last = HR_logL
         end do

         HR_logTeff = cv(cv_cur)% log_Teff
         HR_logL = cv(cv_cur)% log_L
         if (HR_logTeff_last > -99) then
            call pgmove(HR_logTeff_last, HR_logL_last)
            call pgdraw(HR_logTeff, HR_logL)
         end if
         
         call pgsci(clr_Crimson)
         call pgsch(2.8*txt_scale)
         call pgpt1(HR_logTeff, HR_logL, 0902)
         call pgunsa

         HR_logTeff_last = HR_logTeff
         HR_logL_last = HR_logL
         
         deallocate(xvec, yvec)
         
         call show_annotations(s, &
            s% show_HR_annotation1, s% show_HR_annotation2, s% show_HR_annotation3)


      end subroutine draw_HR_Plot


      end module mod_pgstar_hr

