! ***********************************************************************
!
!   Copyright (C) 2010  Bill Paxton
!
!   MESA is free software; you can use it and/or modify
!   it under the combined terms and restrictions of the MESA MANIFESTO
!   and the GNU General Library Public License as published
!   by the Free Software Foundation; either version 2 of the License,
!   or (at your option) any later version.
!
!   You should have received a copy of the MESA MANIFESTO along with
!   this software; if not, it is available at the mesa website:
!   http://mesa.sourceforge.net/
!
!   MESA is distributed in the hope that it will be useful,
!   but WITHOUT ANY WARRANTY; without even the implied warranty of
!   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
!   See the GNU Library General Public License for more details.
!
!   You should have received a copy of the GNU Library General Public License
!   along with this software; if not, write to the Free Software
!   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
!
! ***********************************************************************

      module pgstar_ctrls_io
      
      use const_def
      use star_private_def

      implicit none
      
      include "pgstar_controls.dek"

      namelist /pgstar/ &
   
            file_device, & 
            file_extension, & 
            pgstar_cnt, & 
            pause, & 
            save_data_at_model_num, & 
            read_data_at_model_num, & 
            save_data_filename, & 
            read_data_filename, & 
            delta_HR_limit_for_file_output, &
            profile_age_shift, &
            file_white_on_black_flag, & 
            win_white_on_black_flag, &             

            main_win_flag, & 
            main_file_flag, & 
            main_file_cnt, & 
            xaxis_by, & 
            num_abundance_line_labels, & 
            log_abund_vary, & ! OBSOLETE
            
            main_file_dir, & 
            main_file_prefix, & 
            show_main_annotation1, & 
            show_main_annotation2, & 
            show_main_annotation3, &             

            main_xmax, & 
            main_xmin, & 
            log_mass_frac_ymax, & 
            log_mass_frac_ymin, & 
            main_xtick, & 
            main_nxsub, & 
            logxq_cutoff, & 
            show_main_win_text_info, & 
            show_HR_TRho_with_main, & 
            show_loggTe_TRho_with_main, &
            show_TRho_Profile_with_main, & 
            main_logL_min, & 
            main_logL_max, & 
            main_win_width, & 
            main_win_aspect_ratio, & 
            main_file_width, & 
            main_file_aspect_ratio, &            

            loggTe_win_flag, & 
            loggTe_file_flag, & 
            show_loggTe_cross_hair, & 
            show_loggTe_target_box, &
            loggTe_target_n_sigma, &
            loggTe_target_logg, &
            loggTe_target_logg_sigma, &
            loggTe_target_Teff, &
            loggTe_target_Teff_sigma, &
            loggTe_file_cnt, & 
            loggTe_step_min, & 
            loggTe_step_max, & 
            loggTe_file_dir, & 
            loggTe_file_prefix, & 
            show_loggTe_annotation1, & 
            show_loggTe_annotation2, & 
            show_loggTe_annotation3, &             

            loggTe_logg_min, & 
            loggTe_logg_max, & 
            loggTe_Teff_min, & 
            loggTe_Teff_max, & 
            loggTe_age_min, & 
            loggTe_win_width, & 
            loggTe_win_aspect_ratio, & 
            loggTe_file_width, & 
            loggTe_file_aspect_ratio, &             

            HR_win_flag, & 
            HR_file_flag, & 
            show_HR_cross_hair, & 
            HR_file_cnt, & 
            HR_step_min, & 
            HR_step_max, & 

            show_HR_target_box, &
            HR_target_n_sigma, &
            HR_target_logL, &
            HR_target_logL_sigma, &
            HR_target_Teff, &
            HR_target_Teff_sigma, & 
            
            HR_file_dir, & 
            HR_file_prefix, & 
            show_HR_annotation1, & 
            show_HR_annotation2, & 
            show_HR_annotation3, &             

            HR_logT_min, & 
            HR_logT_max, & 
            HR_logL_min, & 
            HR_logL_max, & 
            HR_age_min, & 
            HR_win_width, & 
            HR_win_aspect_ratio, & 
            HR_file_width, & 
            HR_file_aspect_ratio, &            

            TRho_win_flag, & 
            TRho_file_flag, & 
            show_TRho_cross_hair, & 
            TRho_file_cnt, & 
            TRho_step_max, & 
            TRho_step_min, & 
            TRho_file_dir, & 
            TRho_file_prefix, & 
            show_TRho_annotation1, & 
            show_TRho_annotation2, & 
            show_TRho_annotation3, &             

            TRho_logT_min, & 
            TRho_logT_max, & 
            TRho_logRho_min, & 
            TRho_logRho_max, & 
            TRho_age_min, & 
            TRho_win_width, & 
            TRho_win_aspect_ratio, & 
            TRho_file_width, & 
            TRho_file_aspect_ratio, &            

            HR_TRho_win_flag, & 
            HR_TRho_file_flag, & 
            HR_TRho_file_cnt, & 
            HR_TRho_file_dir, & 
            HR_TRho_file_prefix, & 
            HR_TRho_win_width, & 
            HR_TRho_win_aspect_ratio, & 
            HR_TRho_file_width, & 
            HR_TRho_file_aspect_ratio, & 
            
            CONV_win_flag, & 
            CONV_file_flag, & 
            CONV_file_cnt, & 
            CONV_xmax, & 
            CONV_xmin, & 
            CONV_max_width, & 
            CONV_file_dir, & 
            CONV_file_prefix, & 
            show_CONV_annotation1, & 
            show_CONV_annotation2, & 
            show_CONV_annotation3, & 
            
            CONV_show_burn, & 
            CONV_show_mixing, & 
            CONV_show_log_radius, & 
            CONV_show_luminosities, & 
            CONV_show_mass_boundaries, & 
            
            CONV_mmax, & 
            CONV_mmin, & 
            CONV_lgLmax, & 
            CONV_lgLmin, & 
            CONV_win_width, & 
            CONV_win_aspect_ratio, & 
            CONV_file_width, & 
            CONV_file_aspect_ratio, & 
            
            TRho_Profile_win_flag, & 
            TRho_switch_to_Column_Depth, & 
            TRho_Profile_file_flag, & 
            TRho_Profile_file_cnt, & 
            TRho_Profile_file_dir, & 
            TRho_Profile_file_prefix, & 
            TRho_Pro_xtick, & 
            TRho_Pro_nxsub, & 
            TRho_Pro_ytick, & 
            TRho_Pro_nysub, & 
            show_TRho_Profile_text_info, & 
            show_TRho_Profile_legend, & 
            show_TRho_Profile_mass_locs, & 
            show_HR_TRho_with_TRho_Profile, & 
            show_TRho_Profile_burn_labels, & 
            show_TRho_Profile_kap_regions, & 
            show_TRho_Profile_eos_regions, & 
            show_TRho_Profile_burn_lines, & 
            show_TRho_Profile_degeneracy_line, & 
            show_TRho_Profile_Pgas_Prad_line, & 
            show_TRho_Profile_annotation1, & 
            show_TRho_Profile_annotation2, & 
            show_TRho_Profile_annotation3, & 
            show_TRho_Profile_cross_hair, & 
            TRho_Profile_show_logQ_limit, & 
            
            TRho_Profile_text_info_xfac, & 
            TRho_Profile_text_info_dxfac, & 
            TRho_Profile_text_info_yfac, & 
            TRho_Profile_text_info_dyfac, & 
            TRho_Profile_xmin, & 
            TRho_Profile_xmax, & 
            TRho_Profile_ymin, & 
            TRho_Profile_ymax, & 
            TRho_Profile_legend_coord, & 
            TRho_Profile_legend_fjust, & 
            TRho_Profile_legend_disp1, & 
            TRho_Profile_legend_del_disp, & 
            TRho_Profile_win_width, & 
            TRho_Profile_win_aspect_ratio, & 
            TRho_Profile_file_width, & 
            TRho_Profile_file_aspect_ratio, & 
            
            num_profile_mass_points, & 
            profile_mass_point_q, & 
            profile_mass_point_color_index, & 
            profile_mass_point_symbol, & 
            profile_mass_point_symbol_scale, & 
            profile_mass_point_str, & 
            profile_mass_point_str_clr, & 
            profile_mass_point_str_scale, & 
            
            Profile_win_flag, & 
            Profile_file_flag, & 
            Profile_file_cnt, & 
            Profile_file_dir, & 
            Profile_file_prefix, & 
            show_Profile_legend, & 
            show_HR_TRho_with_Profile, & 
            show_Profile_text_info, & 
            Profile_text_info_xfac, & 
            Profile_text_info_dxfac, & 
            Profile_text_info_yfac, & 
            Profile_text_info_dyfac, & 
            show_Profile_cross_hair, & 
            Profile_yaxis_reversed, & 
            Profile_xaxis_reversed, &
            Profile_other_yaxis_reversed, & 
            Profile_xaxis_name, & 
            Profile_yaxis_name, & 
            Profile_other_yaxis_name, & 
            
            Profile_xmin, & 
            Profile_xmax, & 
            Profile_ymin, & 
            Profile_ymax, & 
            Profile_dymin, & 
            Profile_other_ymin, & 
            Profile_other_ymax, & 
            Profile_other_dymin, & 
            Profile_legend_coord, & 
            Profile_legend_fjust, & 
            Profile_legend_disp1, & 
            Profile_legend_del_disp, & 
            Profile_show_decorated_line, & 
            Profile_show_mass_locs, & 
            Profile_win_width, & 
            Profile_win_aspect_ratio, & 
            Profile_file_width, & 
            Profile_file_aspect_ratio, & 
            show_Profile_annotation1, & 
            show_Profile_annotation2, & 
            show_Profile_annotation3, & 
            
            Profile2_win_flag, & 
            Profile2_file_flag, & 
            Profile2_file_cnt, & 
            Profile2_file_dir, & 
            Profile2_file_prefix, & 
            show_Profile2_legend, & 
            show_HR_TRho_with_Profile2, & 
            show_Profile2_text_info, & 
            Profile2_text_info_xfac, & 
            Profile2_text_info_dxfac, & 
            Profile2_text_info_yfac, & 
            Profile2_text_info_dyfac, & 
            show_Profile2_cross_hair, & 
            Profile2_yaxis_reversed, & 
            Profile2_xaxis_reversed, &
            Profile2_other_yaxis_reversed, & 
            Profile2_xaxis_name, & 
            Profile2_yaxis_name, & 
            Profile2_other_yaxis_name, & 
            
            Profile2_xmin, & 
            Profile2_xmax, & 
            Profile2_ymin, & 
            Profile2_ymax, & 
            Profile2_dymin, & 
            Profile2_other_ymin, & 
            Profile2_other_ymax, & 
            Profile2_other_dymin, & 
            Profile2_legend_coord, & 
            Profile2_legend_fjust, & 
            Profile2_legend_disp1, & 
            Profile2_legend_del_disp, & 
            Profile2_show_decorated_line, & 
            Profile2_show_mass_locs, & 
            Profile2_win_width, & 
            Profile2_win_aspect_ratio, & 
            Profile2_file_width, & 
            Profile2_file_aspect_ratio, & 
            show_Profile2_annotation1, & 
            show_Profile2_annotation2, & 
            show_Profile2_annotation3, & 
            
            Profile3_win_flag, & 
            Profile3_file_flag, & 
            Profile3_file_cnt, & 
            Profile3_file_dir, & 
            Profile3_file_prefix, & 
            show_Profile3_legend, & 
            show_HR_TRho_with_Profile3, & 
            show_Profile3_text_info, & 
            Profile3_text_info_xfac, & 
            Profile3_text_info_dxfac, & 
            Profile3_text_info_yfac, & 
            Profile3_text_info_dyfac, & 
            show_Profile3_cross_hair, & 
            Profile3_yaxis_reversed, & 
            Profile3_xaxis_reversed, &
            Profile3_other_yaxis_reversed, & 
            Profile3_xaxis_name, & 
            Profile3_yaxis_name, & 
            Profile3_other_yaxis_name, & 
            
            Profile3_xmin, & 
            Profile3_xmax, & 
            Profile3_ymin, & 
            Profile3_ymax, & 
            Profile3_dymin, & 
            Profile3_other_ymin, & 
            Profile3_other_ymax, & 
            Profile3_other_dymin, & 
            Profile3_legend_coord, & 
            Profile3_legend_fjust, & 
            Profile3_legend_disp1, & 
            Profile3_legend_del_disp, & 
            Profile3_show_decorated_line, & 
            Profile3_show_mass_locs, & 
            Profile3_win_width, & 
            Profile3_win_aspect_ratio, & 
            Profile3_file_width, & 
            Profile3_file_aspect_ratio, & 
            show_Profile3_annotation1, & 
            show_Profile3_annotation2, & 
            show_Profile3_annotation3, & 
            
            Dynamo_win_flag, & 
            Dynamo_file_flag, & 
            Dynamo_file_cnt, & 
            Dynamo_file_dir, & 
            Dynamo_file_prefix, & 
            show_Dynamo_annotation1, & 
            show_Dynamo_annotation2, & 
            show_Dynamo_annotation3, &
            show_Dynamo_cross_hair, & 
            Dynamo_xaxis_by, & 
            
            Dynamo_xmin, & 
            Dynamo_xmax, & 
            Dynamo_ymin_left, & 
            Dynamo_ymax_left, & 
            Dynamo_dymin_left, &
            Dynamo_ymin_right, & 
            Dynamo_ymax_right, & 
            Dynamo_dymin_right, &

            Dynamo_win_width, & 
            Dynamo_win_aspect_ratio, & 
            Dynamo_file_width, & 
            Dynamo_file_aspect_ratio, & 
            
            Mixing_Ds_win_flag, & 
            Mixing_Ds_file_flag, & 
            Mixing_Ds_file_cnt, & 
            Mixing_Ds_file_dir, & 
            Mixing_Ds_file_prefix, & 
            show_Mixing_Ds_annotation1, & 
            show_Mixing_Ds_annotation2, & 
            show_Mixing_Ds_annotation3, &
            show_Mixing_Ds_cross_hair, & 
            Mixing_Ds_xaxis_by, & 
            
            Mixing_Ds_xmin, & 
            Mixing_Ds_xmax, & 
            Mixing_Ds_ymin, & 
            Mixing_Ds_ymax, & 
            Mixing_Ds_dymin, &

            Mixing_Ds_win_width, & 
            Mixing_Ds_win_aspect_ratio, & 
            Mixing_Ds_file_width, & 
            Mixing_Ds_file_aspect_ratio, & 

            Mixing_Dynamo_win_flag, & 
            Mixing_Dynamo_file_flag, & 
            Mixing_Dynamo_file_cnt, & 
            Mixing_Dynamo_file_dir, & 
            Mixing_Dynamo_file_prefix, & 
            Mixing_Dynamo_win_width, & 
            Mixing_Dynamo_win_aspect_ratio, & 
            Mixing_Dynamo_xaxis_by, &
            Mixing_Dynamo_xmin, &
            Mixing_Dynamo_xmax, &
            Mixing_Dynamo_file_width, & 
            Mixing_Dynamo_file_aspect_ratio, & 
            
            Cntr_Hist_win_flag, & 
            Cntr_Hist_file_flag, & 
            Cntr_Hist_file_cnt, & 
            Cntr_Hist_max_width, & 
            Cntr_Hist_xmin, & 
            Cntr_Hist_xmax, & 
            Cntr_Hist_file_dir, & 
            Cntr_Hist_file_prefix, & 
            show_Cntr_Hist_annotation1, & 
            show_Cntr_Hist_annotation2, & 
            show_Cntr_Hist_annotation3, &             

            Cntr_Hist_mass_frac_min, & 
            Cntr_Hist_mass_frac_max, & 
            Cntr_Hist_win_width, & 
            Cntr_Hist_win_aspect_ratio, & 
            Cntr_Hist_file_width, & 
            Cntr_Hist_file_aspect_ratio, & 

            Surf_Hist_win_flag, & 
            Surf_Hist_file_flag, & 
            Surf_Hist_file_cnt, & 
            Surf_Hist_max_width, & 
            Surf_Hist_xmin, & 
            Surf_Hist_xmax, & 
            Surf_Hist_file_dir, & 
            Surf_Hist_file_prefix, & 
            show_Surf_Hist_annotation1, & 
            show_Surf_Hist_annotation2, & 
            show_Surf_Hist_annotation3, &            

            Surf_Hist_mass_frac_min, & 
            Surf_Hist_mass_frac_max, & 
            Surf_Hist_win_width, & 
            Surf_Hist_win_aspect_ratio, & 
            Surf_Hist_file_width, & 
            Surf_Hist_file_aspect_ratio, & 
            
            Mode_Prop_win_flag, & 
            Mode_Prop_file_flag, & 
            Mode_Prop_file_cnt, & 
            show_Mode_Prop_cross_hair, & 
            Mode_Prop_file_dir, & 
            Mode_Prop_file_prefix, & 
            Mode_Prop_xaxis_by, & 
            Mode_Prop_xmin, & 
            Mode_Prop_xmax, & 
            Mode_Prop_ymin, & 
            Mode_Prop_ymax, &             

            Mode_Prop_win_width, & 
            Mode_Prop_win_aspect_ratio, & 
            Mode_Prop_file_width, & 
            Mode_Prop_file_aspect_ratio, & 
            Mode_Prop_nu_max_obs, &
            
            Power_win_flag, & 
            Power_file_flag, & 
            Power_file_cnt, & 
            show_Power_cross_hair, & 
            Power_file_dir, & 
            Power_file_prefix, & 
            Power_xaxis_by, & 
            Power_xmin, & 
            Power_xmax, & 
            Power_ymin, & 
            Power_ymax, &             

            Power_win_width, & 
            Power_win_aspect_ratio, & 
            Power_file_width, & 
            Power_file_aspect_ratio, & 
            
            Abundance_win_flag, & 
            Abundance_file_flag, & 
            Abundance_file_cnt, & 
            show_Abundance_cross_hair, & 
            Abundance_file_dir, & 
            Abundance_file_prefix, & 
            Abundance_num_isos_to_show, &
            Adundance_which_isos_to_show, &
            Abundance_xaxis_by, & 
            Abundance_xmin, & 
            Abundance_xmax, & 
            Abundance_log_mass_frac_min, & 
            Abundance_log_mass_frac_max, &             

            Abundance_win_width, & 
            Abundance_win_aspect_ratio, & 
            Abundance_file_width, & 
            Abundance_file_aspect_ratio, &                   

            Abund_Power_win_flag, & 
            Abund_Power_file_flag, & 
            Abund_Power_file_cnt, & 
            Abund_Power_file_dir, & 
            Abund_Power_file_prefix, & 
            Abund_Power_win_width, & 
            Abund_Power_win_aspect_ratio, & 
            Abund_Power_xaxis_by, &
            Abund_Power_xmin, &
            Abund_Power_xmax, &
            Abund_Power_file_width, & 
            Abund_Power_file_aspect_ratio, & 

            Abund_Pwr_Dmix_win_flag, & 
            Abund_Pwr_Dmix_file_flag, & 
            Abund_Pwr_Dmix_file_cnt, & 
            Abund_Pwr_Dmix_file_dir, & 
            Abund_Pwr_Dmix_file_prefix, & 
            Abund_Pwr_Dmix_win_width, & 
            Abund_Pwr_Dmix_win_aspect_ratio, & 
            Abund_Pwr_Dmix_xaxis_by, &
            Abund_Pwr_Dmix_xmin, &
            Abund_Pwr_Dmix_xmax, &
            Abund_Pwr_Dmix_file_width, & 
            Abund_Pwr_Dmix_file_aspect_ratio, & 

            Abund_Pwr_Dmix_Dyn_win_flag, & 
            Abund_Pwr_Dmix_Dyn_file_flag, & 
            Abund_Pwr_Dmix_Dyn_file_cnt, & 
            Abund_Pwr_Dmix_Dyn_file_dir, & 
            Abund_Pwr_Dmix_Dyn_file_prefix, & 
            Abund_Pwr_Dmix_Dyn_win_width, & 
            Abund_Pwr_Dmix_Dyn_win_aspect_ratio, & 
            Abund_Pwr_Dmix_Dyn_xaxis_by, &
            Abund_Pwr_Dmix_Dyn_xmin, &
            Abund_Pwr_Dmix_Dyn_xmax, &
            Abund_Pwr_Dmix_Dyn_file_width, & 
            Abund_Pwr_Dmix_Dyn_file_aspect_ratio, & 
      
            annotation1_ci, & 
            annotation1_ch, & 
            annotation1_lw, & 
            annotation1_cf, & 
            annotation1_text, & 
            annotation1_side, & 
            annotation1_disp, & 
            annotation1_coord, & 
            annotation1_fjust, &           
      
            annotation2_ci, & 
            annotation2_ch, & 
            annotation2_lw, & 
            annotation2_cf, & 
            annotation2_text, & 
            annotation2_side, & 
            annotation2_disp, & 
            annotation2_coord, & 
            annotation2_fjust, &            
      
            annotation3_ci, & 
            annotation3_ch, & 
            annotation3_lw, & 
            annotation3_cf, & 
            annotation3_text, & 
            annotation3_side, & 
            annotation3_disp, & 
            annotation3_coord, & 
            annotation3_fjust, &          

            read_extra_pgstar_inlist1, & 
            extra_pgstar_inlist1_name, &              

            read_extra_pgstar_inlist2, & 
            extra_pgstar_inlist2_name, &              

            read_extra_pgstar_inlist3, & 
            extra_pgstar_inlist3_name, &             

            read_extra_pgstar_inlist4, & 
            extra_pgstar_inlist4_name, &              

            read_extra_pgstar_inlist5, & 
            extra_pgstar_inlist5_name 
   
      


      contains


      subroutine read_pgstar(s, filename, ierr)
         use star_private_def
         use alert_lib
         use utils_lib
         type (star_info), pointer :: s
         character(*), intent(in) :: filename
         integer, intent(out) :: ierr
         character (len=256) :: pgstar_namelist_name
         pgstar_namelist_name = ''         
         ierr = 0         
         call set_default_pgstar_controls
         call read_pgstar_file(s, filename, 1, ierr)
      end subroutine read_pgstar
         
         
      recursive subroutine read_pgstar_file(s, filename, level, ierr)
         use star_private_def
         use alert_lib
         use utils_lib
         character(*), intent(in) :: filename
         type (star_info), pointer :: s
         integer, intent(in) :: level  
         integer, intent(out) :: ierr
         logical :: read_extra1, read_extra2, read_extra3, read_extra4, read_extra5
         character (len=256) :: message, extra1, extra2, extra3, extra4, extra5
         integer :: unit 
         
         ierr = 0        
         
         if (level >= 10) then
            write(*,*) 'ERROR: too many levels of nested extra pgstar inlist files'
            ierr = -1
            return
         end if

         if (len_trim(filename) > 0) then
            unit=alloc_iounit(ierr); if (ierr /= 0) return
            open(unit=unit, file=trim(filename), action='read', delim='quote', status='old', iostat=ierr)
            if (ierr /= 0) then
               write(message, *) 'Failed to open control namelist file ', trim(filename)
               call alert(ierr, message)
               write(*, '(a)') trim(message)
               call free_iounit(unit)
               return
            end if
            read(unit, nml=pgstar, iostat=ierr)  
            close(unit)
            if (ierr /= 0) then
               write(*, *) 
               write(*, *) 
               write(*, *) 
               write(*, *) 
               write(message, '(a)') &
                  'Failed while trying to read control namelist file: ' // trim(filename)
               write(*, '(a)') trim(message)
               write(*, '(a)') &
                  'Perhaps the following runtime error message will help you find the problem.'
               write(*, *) 
               open(unit=unit, file=trim(filename), action='read', delim='quote', status='old', iostat=ierr)
               read(unit, nml=pgstar)
               close(unit)
               call free_iounit(unit)
               call alert(ierr, message)
               return
            end if
            call free_iounit(unit)
         end if
         
         call store_pgstar_controls(s, ierr)
         
         ! recursive calls to read other inlists
         
         read_extra1 = read_extra_pgstar_inlist1
         read_extra_pgstar_inlist1 = .false.
         extra1 = extra_pgstar_inlist1_name
         extra_pgstar_inlist1_name = 'undefined'
         
         read_extra2 = read_extra_pgstar_inlist2
         read_extra_pgstar_inlist2 = .false.
         extra2 = extra_pgstar_inlist2_name
         extra_pgstar_inlist2_name = 'undefined'
         
         read_extra3 = read_extra_pgstar_inlist3
         read_extra_pgstar_inlist3 = .false.
         extra3 = extra_pgstar_inlist3_name
         extra_pgstar_inlist3_name = 'undefined'
         
         read_extra4 = read_extra_pgstar_inlist4
         read_extra_pgstar_inlist4 = .false.
         extra4 = extra_pgstar_inlist4_name
         extra_pgstar_inlist4_name = 'undefined'
         
         read_extra5 = read_extra_pgstar_inlist5
         read_extra_pgstar_inlist5 = .false.
         extra5 = extra_pgstar_inlist5_name
         extra_pgstar_inlist5_name = 'undefined'
         
         if (read_extra1) then
            call read_pgstar_file(s, extra1, level+1, ierr)
            if (ierr /= 0) return
         end if
         
         if (read_extra2) then
            call read_pgstar_file(s, extra2, level+1, ierr)
            if (ierr /= 0) return
         end if
         
         if (read_extra3) then
            call read_pgstar_file(s, extra3, level+1, ierr)
            if (ierr /= 0) return
         end if
         
         if (read_extra4) then
            call read_pgstar_file(s, extra4, level+1, ierr)
            if (ierr /= 0) return
         end if
         
         if (read_extra5) then
            call read_pgstar_file(s, extra5, level+1, ierr)
            if (ierr /= 0) return
         end if
         
      end subroutine read_pgstar_file


      subroutine store_pgstar_controls(s, ierr)
         use star_private_def
         type (star_info), pointer :: s
         integer, intent(out) :: ierr
         
         ierr = 0

         s% file_device = file_device
         s% file_extension = file_extension
         s% pgstar_cnt = pgstar_cnt
         s% pause = pause
         s% save_data_at_model_num = save_data_at_model_num
         s% read_data_at_model_num = read_data_at_model_num
         s% save_data_filename = save_data_filename
         s% read_data_filename = read_data_filename
         s% file_white_on_black_flag = file_white_on_black_flag
         s% delta_HR_limit_for_file_output = delta_HR_limit_for_file_output
         s% profile_age_shift = profile_age_shift
         s% win_white_on_black_flag = win_white_on_black_flag            

         s% main_win_flag = main_win_flag
         s% main_file_flag = main_file_flag
         s% main_file_cnt = main_file_cnt
         s% xaxis_by = xaxis_by
         s% num_abundance_line_labels = num_abundance_line_labels
         s% main_file_dir = main_file_dir
         s% main_file_prefix = main_file_prefix
         s% show_main_annotation1 = show_main_annotation1
         s% show_main_annotation2 = show_main_annotation2
         s% show_main_annotation3 = show_main_annotation3            

         s% main_xmax = main_xmax
         s% main_xmin = main_xmin
         s% log_mass_frac_ymax = log_mass_frac_ymax
         s% log_mass_frac_ymin = log_mass_frac_ymin
         s% main_xtick = main_xtick
         s% main_nxsub = main_nxsub
         s% logxq_cutoff = logxq_cutoff
         s% show_main_win_text_info = show_main_win_text_info
         s% show_HR_TRho_with_main = show_HR_TRho_with_main
         s% show_loggTe_TRho_with_main = show_loggTe_TRho_with_main
         s% show_TRho_Profile_with_main = show_TRho_Profile_with_main
         s% main_logL_min = main_logL_min
         s% main_logL_max = main_logL_max
         s% main_win_width = main_win_width
         s% main_win_aspect_ratio = main_win_aspect_ratio
         s% main_file_width = main_file_width
         s% main_file_aspect_ratio = main_file_aspect_ratio           

         s% loggTe_win_flag = loggTe_win_flag
         s% loggTe_file_flag = loggTe_file_flag
         s% show_loggTe_cross_hair = show_loggTe_cross_hair
         s% show_loggTe_target_box = show_loggTe_target_box
         s% loggTe_target_n_sigma = loggTe_target_n_sigma
         s% loggTe_target_logg = loggTe_target_logg
         s% loggTe_target_logg_sigma = loggTe_target_logg_sigma
         s% loggTe_target_Teff = loggTe_target_Teff
         s% loggTe_target_Teff_sigma = loggTe_target_Teff_sigma
         s% loggTe_file_cnt = loggTe_file_cnt
         s% loggTe_step_min = loggTe_step_min
         s% loggTe_step_max = loggTe_step_max
         s% loggTe_file_dir = loggTe_file_dir
         s% loggTe_file_prefix = loggTe_file_prefix
         s% show_loggTe_annotation1 = show_loggTe_annotation1
         s% show_loggTe_annotation2 = show_loggTe_annotation2
         s% show_loggTe_annotation3 = show_loggTe_annotation3            

         s% loggTe_logg_min = loggTe_logg_min
         s% loggTe_logg_max = loggTe_logg_max
         s% loggTe_Teff_min = loggTe_Teff_min
         s% loggTe_Teff_max = loggTe_Teff_max
         s% loggTe_age_min = loggTe_age_min
         s% loggTe_win_width = loggTe_win_width
         s% loggTe_win_aspect_ratio = loggTe_win_aspect_ratio
         s% loggTe_file_width = loggTe_file_width
         s% loggTe_file_aspect_ratio = loggTe_file_aspect_ratio            

         s% HR_win_flag = HR_win_flag
         s% HR_file_flag = HR_file_flag
         s% show_HR_cross_hair = show_HR_cross_hair
         s% HR_file_cnt = HR_file_cnt
         s% HR_step_min = HR_step_min
         s% HR_step_max = HR_step_max

         s% show_HR_target_box = show_HR_target_box
         s% HR_target_n_sigma = HR_target_n_sigma
         s% HR_target_logL = HR_target_logL
         s% HR_target_logL_sigma = HR_target_logL_sigma
         s% HR_target_Teff = HR_target_Teff
         s% HR_target_Teff_sigma = HR_target_Teff_sigma

         s% HR_file_dir = HR_file_dir
         s% HR_file_prefix = HR_file_prefix
         s% show_HR_annotation1 = show_HR_annotation1
         s% show_HR_annotation2 = show_HR_annotation2
         s% show_HR_annotation3 = show_HR_annotation3            

         s% HR_logT_min = HR_logT_min
         s% HR_logT_max = HR_logT_max
         s% HR_logL_min = HR_logL_min
         s% HR_logL_max = HR_logL_max
         s% HR_age_min = HR_age_min
         s% HR_win_width = HR_win_width
         s% HR_win_aspect_ratio = HR_win_aspect_ratio
         s% HR_file_width = HR_file_width
         s% HR_file_aspect_ratio = HR_file_aspect_ratio           

         s% TRho_win_flag = TRho_win_flag
         s% TRho_file_flag = TRho_file_flag
         s% show_TRho_cross_hair = show_TRho_cross_hair
         s% TRho_file_cnt = TRho_file_cnt
         s% TRho_step_max = TRho_step_max
         s% TRho_step_min = TRho_step_min
         s% TRho_file_dir = TRho_file_dir
         s% TRho_file_prefix = TRho_file_prefix
         s% show_TRho_annotation1 = show_TRho_annotation1
         s% show_TRho_annotation2 = show_TRho_annotation2
         s% show_TRho_annotation3 = show_TRho_annotation3            

         s% TRho_logT_min = TRho_logT_min
         s% TRho_logT_max = TRho_logT_max
         s% TRho_logRho_min = TRho_logRho_min
         s% TRho_logRho_max = TRho_logRho_max
         s% TRho_age_min = TRho_age_min
         s% TRho_win_width = TRho_win_width
         s% TRho_win_aspect_ratio = TRho_win_aspect_ratio
         s% TRho_file_width = TRho_file_width
         s% TRho_file_aspect_ratio = TRho_file_aspect_ratio           

         s% HR_TRho_win_flag = HR_TRho_win_flag
         s% HR_TRho_file_flag = HR_TRho_file_flag
         s% HR_TRho_file_cnt = HR_TRho_file_cnt
         s% HR_TRho_file_dir = HR_TRho_file_dir
         s% HR_TRho_file_prefix = HR_TRho_file_prefix
         s% HR_TRho_win_width = HR_TRho_win_width
         s% HR_TRho_win_aspect_ratio = HR_TRho_win_aspect_ratio
         s% HR_TRho_file_width = HR_TRho_file_width
         s% HR_TRho_file_aspect_ratio = HR_TRho_file_aspect_ratio            
         
         s% Dynamo_win_flag = Dynamo_win_flag
         s% Dynamo_file_flag = Dynamo_file_flag
         s% Dynamo_file_cnt = Dynamo_file_cnt
         s% Dynamo_file_dir = Dynamo_file_dir
         s% Dynamo_file_prefix = Dynamo_file_prefix
         s% show_Dynamo_annotation1 = show_Dynamo_annotation1
         s% show_Dynamo_annotation2 = show_Dynamo_annotation2
         s% show_Dynamo_annotation3 = show_Dynamo_annotation3
         s% show_Dynamo_cross_hair = show_Dynamo_cross_hair
         s% Dynamo_xaxis_by = Dynamo_xaxis_by
         
         s% Dynamo_xmin = Dynamo_xmin
         s% Dynamo_xmax = Dynamo_xmax
         s% Dynamo_ymin_left = Dynamo_ymin_left
         s% Dynamo_ymax_left = Dynamo_ymax_left
         s% Dynamo_dymin_left = Dynamo_dymin_left
         s% Dynamo_ymin_right = Dynamo_ymin_right
         s% Dynamo_ymax_right = Dynamo_ymax_right
         s% Dynamo_dymin_right = Dynamo_dymin_right

         s% Dynamo_win_width = Dynamo_win_width
         s% Dynamo_win_aspect_ratio = Dynamo_win_aspect_ratio
         s% Dynamo_file_width = Dynamo_file_width
         s% Dynamo_file_aspect_ratio = Dynamo_file_aspect_ratio
         
         s% Mixing_Ds_win_flag = Mixing_Ds_win_flag
         s% Mixing_Ds_file_flag = Mixing_Ds_file_flag
         s% Mixing_Ds_file_cnt = Mixing_Ds_file_cnt
         s% Mixing_Ds_file_dir = Mixing_Ds_file_dir
         s% Mixing_Ds_file_prefix = Mixing_Ds_file_prefix
         s% show_Mixing_Ds_annotation1 = show_Mixing_Ds_annotation1
         s% show_Mixing_Ds_annotation2 = show_Mixing_Ds_annotation2
         s% show_Mixing_Ds_annotation3 = show_Mixing_Ds_annotation3
         s% show_Mixing_Ds_cross_hair = show_Mixing_Ds_cross_hair
         s% Mixing_Ds_xaxis_by = Mixing_Ds_xaxis_by
         
         s% Mixing_Ds_xmin = Mixing_Ds_xmin
         s% Mixing_Ds_xmax = Mixing_Ds_xmax
         s% Mixing_Ds_ymin = Mixing_Ds_ymin
         s% Mixing_Ds_ymax = Mixing_Ds_ymax
         s% Mixing_Ds_dymin = Mixing_Ds_dymin

         s% Mixing_Ds_win_width = Mixing_Ds_win_width
         s% Mixing_Ds_win_aspect_ratio = Mixing_Ds_win_aspect_ratio
         s% Mixing_Ds_file_width = Mixing_Ds_file_width
         s% Mixing_Ds_file_aspect_ratio = Mixing_Ds_file_aspect_ratio

         s% Mixing_Dynamo_win_flag = Mixing_Dynamo_win_flag
         s% Mixing_Dynamo_file_flag = Mixing_Dynamo_file_flag
         s% Mixing_Dynamo_file_cnt = Mixing_Dynamo_file_cnt
         s% Mixing_Dynamo_file_dir = Mixing_Dynamo_file_dir
         s% Mixing_Dynamo_file_prefix = Mixing_Dynamo_file_prefix
         s% Mixing_Dynamo_win_width = Mixing_Dynamo_win_width
         s% Mixing_Dynamo_win_aspect_ratio = Mixing_Dynamo_win_aspect_ratio
         s% Mixing_Dynamo_xaxis_by = Mixing_Dynamo_xaxis_by
         s% Mixing_Dynamo_xmin = Mixing_Dynamo_xmin
         s% Mixing_Dynamo_xmax = Mixing_Dynamo_xmax
         s% Mixing_Dynamo_file_width = Mixing_Dynamo_file_width
         s% Mixing_Dynamo_file_aspect_ratio = Mixing_Dynamo_file_aspect_ratio            

         s% CONV_win_flag = CONV_win_flag
         s% CONV_file_flag = CONV_file_flag
         s% CONV_file_cnt = CONV_file_cnt
         s% CONV_xmax = CONV_xmax
         s% CONV_xmin = CONV_xmin
         s% CONV_max_width = CONV_max_width
         s% CONV_file_dir = CONV_file_dir
         s% CONV_file_prefix = CONV_file_prefix
         s% show_CONV_annotation1 = show_CONV_annotation1
         s% show_CONV_annotation2 = show_CONV_annotation2
         s% show_CONV_annotation3 = show_CONV_annotation3            

         s% CONV_show_burn = CONV_show_burn
         s% CONV_show_mixing = CONV_show_mixing
         s% CONV_show_log_radius = CONV_show_log_radius
         s% CONV_show_log_Teff = CONV_show_log_Teff
         s% CONV_show_luminosities = CONV_show_luminosities
         s% CONV_show_mass_boundaries = CONV_show_mass_boundaries            

         s% CONV_mmax = CONV_mmax
         s% CONV_mmin = CONV_mmin
         s% CONV_lgLmax = CONV_lgLmax
         s% CONV_lgLmin = CONV_lgLmin
         s% CONV_win_width = CONV_win_width
         s% CONV_win_aspect_ratio = CONV_win_aspect_ratio
         s% CONV_file_width = CONV_file_width
         s% CONV_file_aspect_ratio = CONV_file_aspect_ratio            

         s% TRho_Profile_win_flag = TRho_Profile_win_flag
         s% TRho_switch_to_Column_Depth = TRho_switch_to_Column_Depth
         s% TRho_Profile_file_flag = TRho_Profile_file_flag
         s% TRho_Profile_file_cnt = TRho_Profile_file_cnt
         s% TRho_Profile_file_dir = TRho_Profile_file_dir
         s% TRho_Profile_file_prefix = TRho_Profile_file_prefix
         s% TRho_Pro_xtick = TRho_Pro_xtick
         s% TRho_Pro_nxsub = TRho_Pro_nxsub
         s% TRho_Pro_ytick = TRho_Pro_ytick
         s% TRho_Pro_nysub = TRho_Pro_nysub
         s% show_TRho_Profile_text_info = show_TRho_Profile_text_info
         s% show_TRho_Profile_legend = show_TRho_Profile_legend
         s% show_TRho_Profile_mass_locs = show_TRho_Profile_mass_locs
         s% show_HR_TRho_with_TRho_Profile = show_HR_TRho_with_TRho_Profile
         s% show_TRho_Profile_burn_labels = show_TRho_Profile_burn_labels
         s% show_TRho_Profile_kap_regions = show_TRho_Profile_kap_regions
         s% show_TRho_Profile_eos_regions = show_TRho_Profile_eos_regions
         s% show_TRho_Profile_burn_lines = show_TRho_Profile_burn_lines
         s% show_TRho_Profile_degeneracy_line = show_TRho_Profile_degeneracy_line
         s% show_TRho_Profile_Pgas_Prad_line = show_TRho_Profile_Pgas_Prad_line
         s% show_TRho_Profile_annotation1 = show_TRho_Profile_annotation1
         s% show_TRho_Profile_annotation2 = show_TRho_Profile_annotation2
         s% show_TRho_Profile_annotation3 = show_TRho_Profile_annotation3
         s% show_TRho_Profile_cross_hair = show_TRho_Profile_cross_hair
         s% TRho_Profile_show_logQ_limit = TRho_Profile_show_logQ_limit            

         s% TRho_Profile_text_info_xfac = TRho_Profile_text_info_xfac
         s% TRho_Profile_text_info_dxfac = TRho_Profile_text_info_dxfac
         s% TRho_Profile_text_info_yfac = TRho_Profile_text_info_yfac
         s% TRho_Profile_text_info_dyfac = TRho_Profile_text_info_dyfac
         s% TRho_Profile_xmin = TRho_Profile_xmin
         s% TRho_Profile_xmax = TRho_Profile_xmax
         s% TRho_Profile_ymin = TRho_Profile_ymin
         s% TRho_Profile_ymax = TRho_Profile_ymax
         s% TRho_Profile_legend_coord = TRho_Profile_legend_coord
         s% TRho_Profile_legend_fjust = TRho_Profile_legend_fjust
         s% TRho_Profile_legend_disp1 = TRho_Profile_legend_disp1
         s% TRho_Profile_legend_del_disp = TRho_Profile_legend_del_disp
         s% TRho_Profile_win_width = TRho_Profile_win_width
         s% TRho_Profile_win_aspect_ratio = TRho_Profile_win_aspect_ratio
         s% TRho_Profile_file_width = TRho_Profile_file_width
         s% TRho_Profile_file_aspect_ratio = TRho_Profile_file_aspect_ratio            

         s% num_profile_mass_points = num_profile_mass_points
         s% profile_mass_point_q = profile_mass_point_q
         s% profile_mass_point_color_index = profile_mass_point_color_index
         s% profile_mass_point_symbol = profile_mass_point_symbol
         s% profile_mass_point_symbol_scale = profile_mass_point_symbol_scale
         s% profile_mass_point_str = profile_mass_point_str
         s% profile_mass_point_str_clr = profile_mass_point_str_clr
         s% profile_mass_point_str_scale = profile_mass_point_str_scale            

         s% Profile_win_flag = Profile_win_flag
         s% Profile_file_flag = Profile_file_flag
         s% Profile_file_cnt = Profile_file_cnt
         s% Profile_file_dir = Profile_file_dir
         s% Profile_file_prefix = Profile_file_prefix
         s% show_Profile_legend = show_Profile_legend
         s% show_HR_TRho_with_Profile = show_HR_TRho_with_Profile
         s% show_Profile_text_info = show_Profile_text_info
         s% Profile_text_info_xfac = Profile_text_info_xfac
         s% Profile_text_info_dxfac = Profile_text_info_dxfac
         s% Profile_text_info_yfac = Profile_text_info_yfac
         s% Profile_text_info_dyfac = Profile_text_info_dyfac
         s% show_Profile_cross_hair = show_Profile_cross_hair
         s% Profile_xaxis_reversed = Profile_xaxis_reversed
         s% Profile_yaxis_reversed = Profile_yaxis_reversed
         s% Profile_other_yaxis_reversed = Profile_other_yaxis_reversed
         s% Profile_xaxis_name = Profile_xaxis_name
         s% Profile_yaxis_name = Profile_yaxis_name
         s% Profile_other_yaxis_name = Profile_other_yaxis_name           

         s% Profile_xmin = Profile_xmin
         s% Profile_xmax = Profile_xmax
         s% Profile_ymin = Profile_ymin
         s% Profile_ymax = Profile_ymax
         s% Profile_dymin = Profile_dymin
         s% Profile_other_ymin = Profile_other_ymin
         s% Profile_other_ymax = Profile_other_ymax
         s% Profile_other_dymin = Profile_other_dymin
         s% Profile_legend_coord = Profile_legend_coord
         s% Profile_legend_fjust = Profile_legend_fjust
         s% Profile_legend_disp1 = Profile_legend_disp1
         s% Profile_legend_del_disp = Profile_legend_del_disp
         s% Profile_show_decorated_line = Profile_show_decorated_line
         s% Profile_show_mass_locs = Profile_show_mass_locs
         s% Profile_win_width = Profile_win_width
         s% Profile_win_aspect_ratio = Profile_win_aspect_ratio
         s% Profile_file_width = Profile_file_width
         s% Profile_file_aspect_ratio = Profile_file_aspect_ratio            
         s% show_Profile_annotation1 = show_Profile_annotation1
         s% show_Profile_annotation2 = show_Profile_annotation2
         s% show_Profile_annotation3 = show_Profile_annotation3

         s% Profile2_win_flag = Profile2_win_flag
         s% Profile2_file_flag = Profile2_file_flag
         s% Profile2_file_cnt = Profile2_file_cnt
         s% Profile2_file_dir = Profile2_file_dir
         s% Profile2_file_prefix = Profile2_file_prefix
         s% show_Profile2_legend = show_Profile2_legend
         s% show_HR_TRho_with_Profile2 = show_HR_TRho_with_Profile2
         s% show_Profile2_text_info = show_Profile2_text_info
         s% Profile2_text_info_xfac = Profile2_text_info_xfac
         s% Profile2_text_info_dxfac = Profile2_text_info_dxfac
         s% Profile2_text_info_yfac = Profile2_text_info_yfac
         s% Profile2_text_info_dyfac = Profile2_text_info_dyfac
         s% show_Profile2_cross_hair = show_Profile2_cross_hair
         s% Profile2_xaxis_reversed = Profile2_xaxis_reversed
         s% Profile2_yaxis_reversed = Profile2_yaxis_reversed
         s% Profile2_other_yaxis_reversed = Profile2_other_yaxis_reversed
         s% Profile2_xaxis_name = Profile2_xaxis_name
         s% Profile2_yaxis_name = Profile2_yaxis_name
         s% Profile2_other_yaxis_name = Profile2_other_yaxis_name           

         s% Profile2_xmin = Profile2_xmin
         s% Profile2_xmax = Profile2_xmax
         s% Profile2_ymin = Profile2_ymin
         s% Profile2_ymax = Profile2_ymax
         s% Profile2_dymin = Profile2_dymin
         s% Profile2_other_ymin = Profile2_other_ymin
         s% Profile2_other_ymax = Profile2_other_ymax
         s% Profile2_other_dymin = Profile2_other_dymin
         s% Profile2_legend_coord = Profile2_legend_coord
         s% Profile2_legend_fjust = Profile2_legend_fjust
         s% Profile2_legend_disp1 = Profile2_legend_disp1
         s% Profile2_legend_del_disp = Profile2_legend_del_disp
         s% Profile2_show_decorated_line = Profile2_show_decorated_line
         s% Profile2_show_mass_locs = Profile2_show_mass_locs
         s% Profile2_win_width = Profile2_win_width
         s% Profile2_win_aspect_ratio = Profile2_win_aspect_ratio
         s% Profile2_file_width = Profile2_file_width
         s% Profile2_file_aspect_ratio = Profile2_file_aspect_ratio            
         s% show_Profile2_annotation1 = show_Profile2_annotation1
         s% show_Profile2_annotation2 = show_Profile2_annotation2
         s% show_Profile2_annotation3 = show_Profile2_annotation3

         s% Profile3_win_flag = Profile3_win_flag
         s% Profile3_file_flag = Profile3_file_flag
         s% Profile3_file_cnt = Profile3_file_cnt
         s% Profile3_file_dir = Profile3_file_dir
         s% Profile3_file_prefix = Profile3_file_prefix
         s% show_Profile3_legend = show_Profile3_legend
         s% show_HR_TRho_with_Profile3 = show_HR_TRho_with_Profile3
         s% show_Profile3_text_info = show_Profile3_text_info
         s% Profile3_text_info_xfac = Profile3_text_info_xfac
         s% Profile3_text_info_dxfac = Profile3_text_info_dxfac
         s% Profile3_text_info_yfac = Profile3_text_info_yfac
         s% Profile3_text_info_dyfac = Profile3_text_info_dyfac
         s% show_Profile3_cross_hair = show_Profile3_cross_hair
         s% Profile3_xaxis_reversed = Profile3_xaxis_reversed
         s% Profile3_yaxis_reversed = Profile3_yaxis_reversed
         s% Profile3_other_yaxis_reversed = Profile3_other_yaxis_reversed
         s% Profile3_xaxis_name = Profile3_xaxis_name
         s% Profile3_yaxis_name = Profile3_yaxis_name
         s% Profile3_other_yaxis_name = Profile3_other_yaxis_name           

         s% Profile3_xmin = Profile3_xmin
         s% Profile3_xmax = Profile3_xmax
         s% Profile3_ymin = Profile3_ymin
         s% Profile3_ymax = Profile3_ymax
         s% Profile3_dymin = Profile3_dymin
         s% Profile3_other_ymin = Profile3_other_ymin
         s% Profile3_other_ymax = Profile3_other_ymax
         s% Profile3_other_dymin = Profile3_other_dymin
         s% Profile3_legend_coord = Profile3_legend_coord
         s% Profile3_legend_fjust = Profile3_legend_fjust
         s% Profile3_legend_disp1 = Profile3_legend_disp1
         s% Profile3_legend_del_disp = Profile3_legend_del_disp
         s% Profile3_show_decorated_line = Profile3_show_decorated_line
         s% Profile3_show_mass_locs = Profile3_show_mass_locs
         s% Profile3_win_width = Profile3_win_width
         s% Profile3_win_aspect_ratio = Profile3_win_aspect_ratio
         s% Profile3_file_width = Profile3_file_width
         s% Profile3_file_aspect_ratio = Profile3_file_aspect_ratio            
         s% show_Profile3_annotation1 = show_Profile3_annotation1
         s% show_Profile3_annotation2 = show_Profile3_annotation2
         s% show_Profile3_annotation3 = show_Profile3_annotation3

         s% Cntr_Hist_win_flag = Cntr_Hist_win_flag
         s% Cntr_Hist_file_flag = Cntr_Hist_file_flag
         s% Cntr_Hist_file_cnt = Cntr_Hist_file_cnt
         s% Cntr_Hist_max_width = Cntr_Hist_max_width
         s% Cntr_Hist_xmin = Cntr_Hist_xmin
         s% Cntr_Hist_xmax = Cntr_Hist_xmax
         s% Cntr_Hist_file_dir = Cntr_Hist_file_dir
         s% Cntr_Hist_file_prefix = Cntr_Hist_file_prefix
         s% show_Cntr_Hist_annotation1 = show_Cntr_Hist_annotation1
         s% show_Cntr_Hist_annotation2 = show_Cntr_Hist_annotation2
         s% show_Cntr_Hist_annotation3 = show_Cntr_Hist_annotation3            

         s% Cntr_Hist_mass_frac_min = Cntr_Hist_mass_frac_min
         s% Cntr_Hist_mass_frac_max = Cntr_Hist_mass_frac_max
         s% Cntr_Hist_win_width = Cntr_Hist_win_width
         s% Cntr_Hist_win_aspect_ratio = Cntr_Hist_win_aspect_ratio
         s% Cntr_Hist_file_width = Cntr_Hist_file_width
         s% Cntr_Hist_file_aspect_ratio = Cntr_Hist_file_aspect_ratio

         s% Surf_Hist_win_flag = Surf_Hist_win_flag
         s% Surf_Hist_file_flag = Surf_Hist_file_flag
         s% Surf_Hist_file_cnt = Surf_Hist_file_cnt
         s% Surf_Hist_max_width = Surf_Hist_max_width
         s% Surf_Hist_xmin = Surf_Hist_xmin
         s% Surf_Hist_xmax = Surf_Hist_xmax
         s% Surf_Hist_file_dir = Surf_Hist_file_dir
         s% Surf_Hist_file_prefix = Surf_Hist_file_prefix
         s% show_Surf_Hist_annotation1 = show_Surf_Hist_annotation1
         s% show_Surf_Hist_annotation2 = show_Surf_Hist_annotation2
         s% show_Surf_Hist_annotation3 = show_Surf_Hist_annotation3           

         s% Surf_Hist_mass_frac_min = Surf_Hist_mass_frac_min
         s% Surf_Hist_mass_frac_max = Surf_Hist_mass_frac_max
         s% Surf_Hist_win_width = Surf_Hist_win_width
         s% Surf_Hist_win_aspect_ratio = Surf_Hist_win_aspect_ratio
         s% Surf_Hist_file_width = Surf_Hist_file_width
         s% Surf_Hist_file_aspect_ratio = Surf_Hist_file_aspect_ratio            

         s% Mode_Prop_win_flag = Mode_Prop_win_flag
         s% Mode_Prop_file_flag = Mode_Prop_file_flag
         s% Mode_Prop_file_cnt = Mode_Prop_file_cnt
         s% show_Mode_Prop_cross_hair = show_Mode_Prop_cross_hair
         s% Mode_Prop_file_dir = Mode_Prop_file_dir
         s% Mode_Prop_file_prefix = Mode_Prop_file_prefix
         s% Mode_Prop_xaxis_by = Mode_Prop_xaxis_by
         s% Mode_Prop_nu_max_obs = Mode_Prop_nu_max_obs
         s% Mode_Prop_xmin = Mode_Prop_xmin
         s% Mode_Prop_xmax = Mode_Prop_xmax
         s% Mode_Prop_ymin = Mode_Prop_ymin
         s% Mode_Prop_ymax = Mode_Prop_ymax            
         s% Mode_Prop_win_width = Mode_Prop_win_width
         s% Mode_Prop_win_aspect_ratio = Mode_Prop_win_aspect_ratio
         s% Mode_Prop_file_width = Mode_Prop_file_width
         s% Mode_Prop_file_aspect_ratio = Mode_Prop_file_aspect_ratio           

         s% Power_win_flag = Power_win_flag
         s% Power_file_flag = Power_file_flag
         s% Power_file_cnt = Power_file_cnt
         s% show_Power_cross_hair = show_Power_cross_hair
         s% Power_file_dir = Power_file_dir
         s% Power_file_prefix = Power_file_prefix
         s% Power_xaxis_by = Power_xaxis_by
         s% Power_xmin = Power_xmin
         s% Power_xmax = Power_xmax
         s% Power_ymin = Power_ymin
         s% Power_ymax = Power_ymax            
         s% Power_win_width = Power_win_width
         s% Power_win_aspect_ratio = Power_win_aspect_ratio
         s% Power_file_width = Power_file_width
         s% Power_file_aspect_ratio = Power_file_aspect_ratio           

         s% Abundance_win_flag = Abundance_win_flag
         s% Abundance_file_flag = Abundance_file_flag
         s% Abundance_file_cnt = Abundance_file_cnt
         s% show_Abundance_cross_hair = show_Abundance_cross_hair
         s% Abundance_file_dir = Abundance_file_dir
         s% Abundance_file_prefix = Abundance_file_prefix
         s% Abundance_num_isos_to_show = Abundance_num_isos_to_show
         s% Adundance_which_isos_to_show = Adundance_which_isos_to_show
         s% Abundance_xaxis_by = Abundance_xaxis_by
         s% Abundance_xmin = Abundance_xmin
         s% Abundance_xmax = Abundance_xmax
         s% Abundance_log_mass_frac_min = Abundance_log_mass_frac_min
         s% Abundance_log_mass_frac_max = Abundance_log_mass_frac_max            
         s% Abundance_win_width = Abundance_win_width
         s% Abundance_win_aspect_ratio = Abundance_win_aspect_ratio
         s% Abundance_file_width = Abundance_file_width
         s% Abundance_file_aspect_ratio = Abundance_file_aspect_ratio                        

         s% Abund_Power_win_flag = Abund_Power_win_flag
         s% Abund_Power_file_flag = Abund_Power_file_flag
         s% Abund_Power_file_cnt = Abund_Power_file_cnt
         s% Abund_Power_file_dir = Abund_Power_file_dir
         s% Abund_Power_file_prefix = Abund_Power_file_prefix
         s% Abund_Power_win_width = Abund_Power_win_width
         s% Abund_Power_win_aspect_ratio = Abund_Power_win_aspect_ratio
         s% Abund_Power_xaxis_by = Abund_Power_xaxis_by
         s% Abund_Power_xmin = Abund_Power_xmin
         s% Abund_Power_xmax = Abund_Power_xmax
         s% Abund_Power_file_width = Abund_Power_file_width
         s% Abund_Power_file_aspect_ratio = Abund_Power_file_aspect_ratio            

         s% Abund_Pwr_Dmix_win_flag = Abund_Pwr_Dmix_win_flag
         s% Abund_Pwr_Dmix_file_flag = Abund_Pwr_Dmix_file_flag
         s% Abund_Pwr_Dmix_file_cnt = Abund_Pwr_Dmix_file_cnt
         s% Abund_Pwr_Dmix_file_dir = Abund_Pwr_Dmix_file_dir
         s% Abund_Pwr_Dmix_file_prefix = Abund_Pwr_Dmix_file_prefix
         s% Abund_Pwr_Dmix_win_width = Abund_Pwr_Dmix_win_width
         s% Abund_Pwr_Dmix_win_aspect_ratio = Abund_Pwr_Dmix_win_aspect_ratio
         s% Abund_Pwr_Dmix_xaxis_by = Abund_Pwr_Dmix_xaxis_by
         s% Abund_Pwr_Dmix_xmin = Abund_Pwr_Dmix_xmin
         s% Abund_Pwr_Dmix_xmax = Abund_Pwr_Dmix_xmax
         s% Abund_Pwr_Dmix_file_width = Abund_Pwr_Dmix_file_width
         s% Abund_Pwr_Dmix_file_aspect_ratio = Abund_Pwr_Dmix_file_aspect_ratio            

         s% Abund_Pwr_Dmix_Dyn_win_flag = Abund_Pwr_Dmix_Dyn_win_flag
         s% Abund_Pwr_Dmix_Dyn_file_flag = Abund_Pwr_Dmix_Dyn_file_flag
         s% Abund_Pwr_Dmix_Dyn_file_cnt = Abund_Pwr_Dmix_Dyn_file_cnt
         s% Abund_Pwr_Dmix_Dyn_file_dir = Abund_Pwr_Dmix_Dyn_file_dir
         s% Abund_Pwr_Dmix_Dyn_file_prefix = Abund_Pwr_Dmix_Dyn_file_prefix
         s% Abund_Pwr_Dmix_Dyn_win_width = Abund_Pwr_Dmix_Dyn_win_width
         s% Abund_Pwr_Dmix_Dyn_win_aspect_ratio = Abund_Pwr_Dmix_Dyn_win_aspect_ratio
         s% Abund_Pwr_Dmix_Dyn_xaxis_by = Abund_Pwr_Dmix_Dyn_xaxis_by
         s% Abund_Pwr_Dmix_Dyn_xmin = Abund_Pwr_Dmix_Dyn_xmin
         s% Abund_Pwr_Dmix_Dyn_xmax = Abund_Pwr_Dmix_Dyn_xmax
         s% Abund_Pwr_Dmix_Dyn_file_width = Abund_Pwr_Dmix_Dyn_file_width
         s% Abund_Pwr_Dmix_Dyn_file_aspect_ratio = Abund_Pwr_Dmix_Dyn_file_aspect_ratio            

         s% annotation1_ci = annotation1_ci
         s% annotation1_ch = annotation1_ch
         s% annotation1_lw = annotation1_lw
         s% annotation1_cf = annotation1_cf
         s% annotation1_text = annotation1_text
         s% annotation1_side = annotation1_side
         s% annotation1_disp = annotation1_disp
         s% annotation1_coord = annotation1_coord
         s% annotation1_fjust = annotation1_fjust          
         
         s% annotation2_ci = annotation2_ci
         s% annotation2_ch = annotation2_ch
         s% annotation2_lw = annotation2_lw
         s% annotation2_cf = annotation2_cf
         s% annotation2_text = annotation2_text
         s% annotation2_side = annotation2_side
         s% annotation2_disp = annotation2_disp
         s% annotation2_coord = annotation2_coord
         s% annotation2_fjust = annotation2_fjust                 

         s% annotation3_ci = annotation3_ci
         s% annotation3_ch = annotation3_ch
         s% annotation3_lw = annotation3_lw
         s% annotation3_cf = annotation3_cf
         s% annotation3_text = annotation3_text
         s% annotation3_side = annotation3_side
         s% annotation3_disp = annotation3_disp
         s% annotation3_coord = annotation3_coord
         s% annotation3_fjust = annotation3_fjust         

         s% read_extra_pgstar_inlist1 = read_extra_pgstar_inlist1
         s% extra_pgstar_inlist1_name = extra_pgstar_inlist1_name             

         s% read_extra_pgstar_inlist2 = read_extra_pgstar_inlist2
         s% extra_pgstar_inlist2_name = extra_pgstar_inlist2_name             

         s% read_extra_pgstar_inlist3 = read_extra_pgstar_inlist3
         s% extra_pgstar_inlist3_name = extra_pgstar_inlist3_name            

         s% read_extra_pgstar_inlist4 = read_extra_pgstar_inlist4
         s% extra_pgstar_inlist4_name = extra_pgstar_inlist4_name             

         s% read_extra_pgstar_inlist5 = read_extra_pgstar_inlist5
         s% extra_pgstar_inlist5_name = extra_pgstar_inlist5_name 
   
         
      end subroutine store_pgstar_controls


      subroutine set_default_pgstar_controls
         include 'pgstar_defaults.dek'
      end subroutine set_default_pgstar_controls


      end module pgstar_ctrls_io

