! ***********************************************************************
!
!   Copyright (C) 2010  Bill Paxton
!
!   MESA is free software; you can use it and/or modify
!   it under the combined terms and restrictions of the MESA MANIFESTO
!   and the GNU General Library Public License as published
!   by the Free Software Foundation; either version 2 of the License,
!   or (at your option) any later version.
!
!   You should have received a copy of the MESA MANIFESTO along with
!   this software; if not, it is available at the mesa website:
!   http://mesa.sourceforge.net/
!
!   MESA is distributed in the hope that it will be useful,
!   but WITHOUT ANY WARRANTY; without even the implied warranty of
!   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
!   See the GNU Library General Public License for more details.
!
!   You should have received a copy of the GNU Library General Public License
!   along with this software; if not, write to the Free Software
!   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
!
! ***********************************************************************

      module mod_pgstar_conv

      use star_private_def
      use const_def
      use mod_pgstar_support

      implicit none


      contains
      

      subroutine Convection_Plot(id, device_id, ierr)
         integer, intent(in) :: id, device_id
         integer, intent(out) :: ierr
         real :: xleft, xright, ybot, ytop
         type (star_info), pointer :: s
         ierr = 0
         call get_star_ptr(id, s, ierr)
         if (ierr /= 0) return
         xleft = 0.2
         xright = 0.80
         ybot = 0.2
         ytop = 0.90
         call pgslct(device_id)
         call pgbbuf()
         call pgeras()
         call draw_Convection_Plot(s, xleft, xright, ybot, ytop, 1.0, ierr)
         if (ierr /= 0) return
         call pgebuf()
      end subroutine Convection_Plot
      

      subroutine draw_Convection_Plot(s, xleft, xright, ybot, ytop, txt_scale, ierr)
         use chem_def
         use net_def
         implicit none

         type (star_info), pointer :: s
         real, intent(in) :: xleft, xright, ybot, ytop, txt_scale
         integer, intent(out) :: ierr

         integer :: i, ii, id
         real, pointer, dimension(:) :: xvec, yvec
         real :: xmin, xmax, ymin, ymax
         integer :: grid_min, grid_max, numpts, lw, lw_sav, clr_lgR, clr_lgTeff
         type (pgstar_data), pointer :: cv_data, cv_data1
         
         include 'formats.dek'
         
         ierr = 0
         id = s% id
         cv_data => cv_for_star(id)% cv_data(cv_current(id))
         cv_data1 => cv_for_star(id)% cv_data(1)

         clr_lgR = clr_RoyalBlue
         clr_lgTeff = clr_IndianRed
         
         if (s% CONV_xmin >= cv_data% step) s% CONV_xmin = -1
         xmin = min(cv_data% step, max(cv_data1% step, s% CONV_xmin))
         xmax = s% CONV_xmax
         if (xmax <= xmin) xmax = cv_data% step
         if (s% CONV_max_width > 0) xmin = max(xmin, xmax - s% CONV_max_width)
         if (xmax <= xmin) xmax = cv_data% step
         
         if (xmin < xmax) then
            call set_grid_min_max(s, xmin, xmax, grid_min, grid_max, numpts, ierr)
            if (ierr /= 0) return       
            call init_convection_plot
            call show_conv_and_burn         
            call show_lines
         end if
         
         call show_annotations(s, &
            s% show_CONV_annotation1, s% show_CONV_annotation2, s% show_CONV_annotation3)
         

         contains
         
         
         subroutine show_conv_and_burn
            lw = 7
            call pgqlw(lw_sav)
            call pgslw(lw)
            ii = max(1, (grid_max-grid_min)/2000)
            do i = grid_min, grid_max, ii
               if (s% CONV_show_mixing) call plot_pgstar_data(i)
               if (s% CONV_show_burn) call plot_burn_data(i)
            end do
            call pgslw(lw_sav)
         end subroutine show_conv_and_burn
         
         
         subroutine show_lines
            type (pgstar_data), dimension(:), pointer :: cv
            ii = max(1, (grid_max-grid_min)/2000)
            do i = grid_min, grid_max, ii
               if (s% CONV_show_mixing) call plot_pgstar_data(i)
               if (s% CONV_show_burn) call plot_burn_data(i)
            end do            
            cv => cv_for_star(s% id)% cv_data
            allocate(xvec(grid_max), yvec(grid_max))
            forall (i=grid_min:grid_max) xvec(i) = cv(i)% step            
            call plot_mass_lines(xvec, yvec)         
            call setup_L_yaxis(s, &
               xmin, xmax, s% CONV_lgLmin, s% CONV_lgLmax, grid_min, grid_max, ymin, ymax, txt_scale)
            call plot_L_lines(xvec, yvec)
            deallocate(xvec,yvec)
         end subroutine show_lines
         

         subroutine init_convection_plot
            character (len=10) :: str
            call pgsvp(xleft, xright, ybot, ytop)
            call setup_L_yaxis(s, &
               xmin, xmax, s% CONV_lgLmin, s% CONV_lgLmax, grid_min, grid_max, ymin, ymax, txt_scale)
            call pgsch(1.3*txt_scale)
            call pgbox('',0.0,0,'CMSTV',0.0,0)
            call pgmtxt('R',4.0,0.5,0.5,'log luminosities/L\d\(2281)')
            if (s% CONV_show_log_radius) then
               call pgsci(clr_lgR)
               call pgmtxt('R',5.5,0.5,0.5,'log R/R\d\(2281)')
               call pgsci(1)
            end if
            if (s% CONV_show_log_Teff) then
               call pgsci(clr_lgTeff)
               call pgmtxt('R',7.0,0.5,0.5,'(log T\deff\u) - 4')
               call pgsci(1)
            end if
            call setup_mass_yaxis
            call pgbox('BCNST1',0.0,0,'BNSTV1',0.0,0)
            call pgmtxt('B',3.0,0.5,0.5,'model number')
            call pgmtxt('L',3.5,0.5,0.5,'M/M\d\(2281)')
            write(str,'(i9)') s% model_number
            call pgmtxt('T',1.0,1.0,0.0,str)
         end subroutine init_convection_plot
            
            
         subroutine setup_mass_yaxis
            include 'formats.dek'
            ymin = max(0.0,s% CONV_mmin)
            ymax = s% CONV_mmax
            if (ymax <= 0) ymax = s% initial_mass
            call pgswin(xmin, xmax, ymin, ymax)
            call pgscf(1)
            call pgsci(1)
            call pgsch(1.5*txt_scale)
         end subroutine setup_mass_yaxis


         subroutine plot_pgstar_data(k)
            integer :: k
            real :: xval
            type (pgstar_data), pointer :: cv_data
            call pgsci(clr_Silver)
            cv_data => cv_for_star(id)% cv_data(k)
            xval = cv_data% step
            call draw1(xval, cv_data% conv_mx1_top, cv_data% conv_mx1_bot)
            call draw1(xval, cv_data% conv_mx2_top, cv_data% conv_mx2_bot)
            call draw1(xval, cv_data% mx1_top, cv_data% mx1_bot)
            call draw1(xval, cv_data% mx2_top, cv_data% mx2_bot)
         end subroutine plot_pgstar_data
         

         subroutine plot_burn_data(k)
            integer :: k, i, clr1, clr2
            real :: xval, z1, z2, z3, z4
            logical, parameter :: dbg = .false.
            type (pgstar_data), pointer :: cv_data
            include 'formats.dek'
            cv_data => cv_for_star(id)% cv_data(k)
            xval = cv_data% step
            clr1 = clr_Tan ! lower epsnuc
            clr2 = clr_IndianRed ! higher epsnuc
            do i=1,3
               z1 = cv_data% burn_zone_mass(1,i)
               z2 = cv_data% burn_zone_mass(2,i)
               z3 = cv_data% burn_zone_mass(3,i)
               z4 = cv_data% burn_zone_mass(4,i)
               !if (dbg) write(*,2) 'burn', i, z1, z2, z3, z4
               if (z1 < 0) cycle
               if (z2 < 0) then
                  call pgsci(clr1)
                  call draw1(xval,z1,z4)
                  if (dbg) write(*,2) 'draw1', k, xval, z1, z4
               else
                  call pgsci(clr1)
                  if (z1 >= 0 .and. z1 < z2) then
                     call draw1(xval,z1,z2)
                     if (dbg) write(*,2) 'draw1', k, xval, z1, z2
                  end if
                  if (z4 > z3) then
                     call draw1(xval,z3,z4)
                     if (dbg) write(*,2) 'draw1', k, xval, z3, z4
                  end if
                  if (z2 > z1) then
                     call pgsci(clr2)
                     call draw1(xval,z2,z3)
                     if (dbg) write(*,2) 'draw2', k, xval, z2, z3
                  end if
               end if
            end do
         end subroutine plot_burn_data
         
         
         subroutine draw1(xval,y1,y2)
            real, intent(in) :: xval, y1, y2
            real :: top, bot
            if (y1 < y2) then
               bot = y1; top = y2
            else
               bot = y2; top = y1
            end if
            if (top < 0) return
            call pgmove(xval, bot)
            call pgdraw(xval, top)
         end subroutine draw1

         
         subroutine plot_L_lines(xvec, yvec) ! log_L, log_LH, log_LHe
            real, pointer, dimension(:) :: xvec, yvec
            integer :: i, lw, lw_sav
            integer :: ch
            real :: z
            
            logical, parameter :: dbg = .false.
            type (pgstar_data), dimension(:), pointer :: cv
            cv => cv_for_star(s% id)% cv_data
            
            include 'formats.dek'
            
            lw = 6
            call pgqlw(lw_sav)
            
            z = 0.95
            
            call pgqch(ch)
            call pgsch(1.5*txt_scale)
            
            if (s% CONV_show_luminosities) then
            
               call pgsci(clr_Coral)
               forall (i=grid_min:grid_max) yvec(i) = cv(i)% log_L
               if (dbg) write(*,1) 'maxval log_L', maxval(yvec)
               call pgmtxt('T',1.0,z,0.5,'lg_L')
               call plot_L_line(z,lw+4,lw_sav)
            
               call pgsci(clr_LightSkyGreen)
               forall (i=grid_min:grid_max) yvec(i) = cv(i)% log_LHe
               if (dbg) write(*,1) 'maxval log_LHe', maxval(yvec)
               call pgmtxt('T',1.0,z,0.5,'lg_L\dHe')
               call plot_L_line(z,lw,lw_sav)

               call pgsci(clr_Crimson)
               forall (i=grid_min:grid_max) yvec(i) = cv(i)% log_LH
               if (dbg) write(*,1) 'maxval log_LH', maxval(yvec)
               call pgmtxt('T',1.0,z,0.5,'lg_L\dH')
               call plot_L_line(z,lw,lw_sav)

               call pgsci(clr_SeaGreen)
               forall (i=grid_min:grid_max) yvec(i) = cv(i)% log_Lneu
               if (dbg) write(*,1) 'maxval log_Lneu', maxval(yvec)
               call pgmtxt('T',1.0,z,0.5,'log_L\d\gn')
               call plot_L_line(z,lw,lw_sav)
               
            end if
            
            if (s% CONV_show_log_radius) then
               call pgsci(clr_lgR)
               forall (i=grid_min:grid_max) yvec(i) = cv(i)% log_surface_R
               if (dbg) write(*,1) 'maxval log_surface_R', maxval(yvec)
               call plot_L_line(z,lw,lw_sav)
            end if
            
            if (s% CONV_show_log_Teff) then
               call pgsci(clr_lgTeff)
               forall (i=grid_min:grid_max) yvec(i) = cv(i)% log_Teff - 4
               if (dbg) write(*,1) 'maxval log_Teff - 4', maxval(yvec)
               call plot_L_line(z,lw,lw_sav)
            end if

            call pgsch(ch)
            
         end subroutine plot_L_lines
         
         
         subroutine plot_L_line(z,lw,lw_sav)
            real, intent(inout) :: z
            integer, intent(in) :: lw, lw_sav
            real, parameter :: dz = -0.12
            if (any(yvec > ymin)) then
               call pgslw(lw)
               call pgline(numpts, xvec(grid_min:grid_max), yvec(grid_min:grid_max))
               call pgslw(lw_sav)
            end if
            z = z + dz
         end subroutine plot_L_line

         
         subroutine plot_mass_lines(xvec, yvec) ! h1_bdy, he4_bdy, star_mass
            real, pointer, dimension(:) :: xvec, yvec

            integer :: i, lw, lw_sav
            integer :: ch
            real :: z
            
            logical, parameter :: dbg = .false.
            type (pgstar_data), dimension(:), pointer :: cv
            cv => cv_for_star(s% id)% cv_data
            
            include 'formats.dek'
            
            if (dbg) write(*,*) 'CONV_show_mass_boundaries', s% CONV_show_mass_boundaries
            
            if (.not. s% CONV_show_mass_boundaries) return
            
            lw = 6
            call pgqlw(lw_sav)
            lw_sav = 1
            
            z = 0.05
            
            call pgqch(ch)
            call pgsch(1.5*txt_scale)
            
            call pgsci(clr_LightSkyBlue)
            forall (i=grid_min:grid_max) yvec(i) = cv(i)% h1_mass
            if (dbg) write(*,1) 'maxval h1_mass', maxval(yvec)
            call pgmtxt('T',1.0,z,0.5,'H\dbdy')
            call plot_mass_line(z,lw,lw_sav)
            
            call pgsci(clr_Goldenrod)
            forall (i=grid_min:grid_max) yvec(i) = cv(i)% he4_mass
            if (dbg) write(*,1) 'maxval he4_mass', maxval(yvec)
            call pgmtxt('T',1.0,z,0.5,'He\dbdy')
            call plot_mass_line(z,lw,lw_sav)
            
            call pgsci(clr_Lilac)
            forall (i=grid_min:grid_max) yvec(i) = cv(i)% c12_mass
            if (dbg) write(*,1) 'maxval c12_mass', maxval(yvec)
            call pgmtxt('T',1.0,z,0.5,'C\dbdy')
            call plot_mass_line(z,lw,lw_sav)
            
            forall (i=grid_min:grid_max) yvec(i) = cv(i)% star_mass
            call pgsci(clr_Gray)
            call pgmtxt('T',1.0,z,0.5,"M\dtotal\u")
            call plot_mass_line(z,lw,lw_sav)
            
            call pgsch(ch)
            
         end subroutine plot_mass_lines
         
         
         subroutine plot_mass_line(z,lw,lw_sav)
            real, intent(inout) :: z
            integer, intent(in) :: lw, lw_sav
            real, parameter :: dz = 0.12
            if (any(yvec > 1e-2*ymax)) then
               call pgslw(lw)
               call pgline(numpts, xvec(grid_min:grid_max), yvec(grid_min:grid_max))
               call pgslw(lw_sav)
            end if
            z = z + dz
         end subroutine plot_mass_line
         

      end subroutine draw_Convection_Plot

         
      subroutine setup_L_yaxis(s, &
            xmin, xmax, lgLmin, lgLmax, grid_min, grid_max, ymin, ymax, txt_scale)
         type (star_info), pointer :: s
         real, intent(in) :: xmin, xmax, lgLmin, lgLmax, txt_scale
         integer, intent(in) :: grid_min, grid_max
         real, intent(out) :: ymin, ymax
         real :: dy
         type (pgstar_data), dimension(:), pointer :: cv
         cv => cv_for_star(s% id)% cv_data
         ymin = -4
         ymax = maxval(cv(grid_min:grid_max)% log_L)
         ymax = max(ymax, maxval(cv(grid_min:grid_max)% log_LH))
         ymax = max(ymax, maxval(cv(grid_min:grid_max)% log_LHe))
         if (s% CONV_show_log_radius) then
            ymax = max(ymax, maxval(cv(grid_min:grid_max)% log_surface_R))
            ymin = min(ymin, minval(cv(grid_min:grid_max)% log_surface_R))
         end if
         if (s% CONV_show_log_Teff) then
            ymax = max(ymax, maxval(cv(grid_min:grid_max)% log_Teff) - 4)
            ymin = min(ymin, minval(cv(grid_min:grid_max)% log_Teff) - 4)
         end if
         if (ymax <= ymin) ymax = ymin+1
         dy = ymax - ymin
         ymax = ymax + dy*0.1
         ymin = ymin - dy*0.1            
         if (lgLmin > -100) ymin = lgLmin
         if (lgLmax > -100) ymax = lgLmax                        
         call pgswin(xmin, xmax, ymin, ymax)
         call pgscf(1)
         call pgsci(1)
         call pgsch(1.5*txt_scale)
      end subroutine setup_L_yaxis



      end module mod_pgstar_conv

