! ***********************************************************************
!
!   Copyright (C) 2010  Bill Paxton
!
!   MESA is free software; you can use it and/or modify
!   it under the combined terms and restrictions of the MESA MANIFESTO
!   and the GNU General Library Public License as published
!   by the Free Software Foundation; either version 2 of the License,
!   or (at your option) any later version.
!
!   You should have received a copy of the MESA MANIFESTO along with
!   this software; if not, it is available at the mesa website:
!   http://mesa.sourceforge.net/
!
!   MESA is distributed in the hope that it will be useful,
!   but WITHOUT ANY WARRANTY; without even the implied warranty of
!   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
!   See the GNU Library General Public License for more details.
!
!   You should have received a copy of the GNU Library General Public License
!   along with this software; if not, write to the Free Software
!   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
!
! ***********************************************************************

      module mod_pgstar_abund_power

      use star_private_def
      use const_def
      use mod_pgstar_support

      implicit none


      contains
      

      subroutine Abundance_Power_plot(id, device_id, ierr)
         use utils_lib
         use mod_pgstar_abundance, only: do_abundance_plot
         use mod_pgstar_power, only: do_power_plot
         implicit none

         integer, intent(in) :: id, device_id
         integer, intent(out) :: ierr

         real :: txt_scale, vpxmin, vpxmax, vpymin, vpymax, vpymargin, vpwinheight
         character (len=256) :: abund_xaxis_by, power_xaxis_by
         real :: abund_xaxis_min, abund_xaxis_max, power_xaxis_min, power_xaxis_max
         
         type (star_info), pointer :: s

         ierr = 0
         call get_star_ptr(id, s, ierr)
         if (ierr /= 0) return

         call pgslct(device_id)
         call pgbbuf()
         call pgeras()
                  
         txt_scale = 0.75
         vpxmin = 0.12
         vpxmax = 0.85
         vpymin = 0.10
         vpymax = 0.92
         vpymargin = 0.12
         vpwinheight = (vpymax - vpymin - vpymargin)/2
         
         if (len_trim(s% Abund_Power_xaxis_by) > 0) then
            abund_xaxis_by = s% Abund_Power_xaxis_by
            power_xaxis_by = s% Abund_Power_xaxis_by
         else
            abund_xaxis_by = s% Abundance_xaxis_by
            power_xaxis_by = s% Power_xaxis_by
         end if
         
         if (s% Abund_Power_xmin > -100) then
            abund_xaxis_min = s% Abund_Power_xmin
            power_xaxis_min = s% Abund_Power_xmin
         else
            abund_xaxis_min = s% Abundance_xmin
            power_xaxis_min = s% Power_xmin
         end if
         
         if (s% Abund_Power_xmax > -100) then
            abund_xaxis_max = s% Abund_Power_xmax
            power_xaxis_max = s% Abund_Power_xmax
         else
            abund_xaxis_max = s% Abundance_xmax
            power_xaxis_max = s% Power_xmax
         end if

         call do_abundance_plot( &
            id, device_id, vpxmin, vpxmax, vpymax-vpwinheight, vpymax, &
            abund_xaxis_by, abund_xaxis_min, abund_xaxis_max, txt_scale, ierr)
         if (ierr /= 0) return
         
         call do_power_plot( &
            id, device_id, vpxmin, vpxmax, vpymin, vpymin+vpwinheight, &
            power_xaxis_by, power_xaxis_min, power_xaxis_max, txt_scale, ierr)
         if (ierr /= 0) return

         call pgebuf()
      
      end subroutine Abundance_Power_plot
      

      end module mod_pgstar_abund_power

