! ***********************************************************************
!
!   Copyright (C) 2010  Bill Paxton
!
!   MESA is free software; you can use it and/or modify
!   it under the combined terms and restrictions of the MESA MANIFESTO
!   and the GNU General Library Public License as published
!   by the Free Software Foundation; either version 2 of the License,
!   or (at your option) any later version.
!
!   You should have received a copy of the MESA MANIFESTO along with
!   this software; if not, it is available at the mesa website:
!   http://mesa.sourceforge.net/
!
!   MESA is distributed in the hope that it will be useful,
!   but WITHOUT ANY WARRANTY; without even the implied warranty of
!   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
!   See the GNU Library General Public License for more details.
!
!   You should have received a copy of the GNU Library General Public License
!   along with this software; if not, write to the Free Software
!   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
!
! ***********************************************************************

      module model_out

      use star_private_def
      use alert_lib

      implicit none     
      
      contains


      subroutine output_star_model(s,iounit)
         use rates_def,only:num_rvs
         use alloc
         type (star_info), pointer :: s
         integer, intent(in) :: iounit
         
         integer :: ierr, part_number, nz, nz_old, nz_older

         ierr = 0
         nz = s% nz
         nz_old = s% nz_old
         nz_older = s% nz_older
         part_number = 0 ! part_numbers are just a consistency check on the data file

         write(iounit) star_def_version
         
         ! for sanity sake, keep these in same order as in the star_data declarations.
         
         call write_part_number(iounit)
         write(iounit) &
            s% generations, s% total_num_jacobians, nz, nz_old, nz_older, &
            s% nvar_hydro, s% nvar_chem, s% nvar, &
            s% lnPgas_flag, s% lnE_flag, s% lnTdot_flag, s% lnddot_flag, s% v_flag, s% rotation_flag, &
            s% prev_Lmax, s% species, s% num_reactions, &
            s% model_number, s% model_number_old, s% model_number_older, &
            s% mstar, s% mstar_old, s% mstar_older, &
            s% xmstar, s% xmstar_old, s% xmstar_older, &
            s% time, s% time_old, s% time_older, &
            s% total_angular_momentum, s% total_angular_momentum_old, &
            s% total_angular_momentum_older, s% prev_create_atm_R0_div_R, &
            s% dt, s% dt_old, s% R_center, s% L_center
 
         write(iounit) s% net_name
         
         call write_part_number(iounit)
         write(iounit) &
            s% dq(1:nz), s% q(1:nz), s% xa(:,1:nz), s% xh(:,1:nz), s% omega(1:nz)
         
         call write_part_number(iounit)
         if (s% generations > 1) &
            write(iounit) s% conv_vel_old(1:nz_old), &
               s% mixing_type_old(1:nz_old), s% omega_old(1:nz_old), &
               s% dq_old(1:nz_old), s% q_old(1:nz_old), &
               s% xa_old(:,1:nz_old), s% xh_old(:,1:nz_old)
            
         call write_part_number(iounit)
         if (s% generations > 2) &
            write(iounit) s% conv_vel_older(1:nz_older), &
               s% mixing_type_older(1:nz_older), s% omega_older(1:nz_older), &
               s% dq_older(1:nz_older), s% q_older(1:nz_older), &
               s% xa_older(:,1:nz_older), s% xh_older(:,1:nz_older)

         call write_part_number(iounit)
         write(iounit) &
            s% mstar_dot, s% mstar_dot_old, s% mstar_dot_older, &
            s% v_surf, s% v_surf_old, s% v_surf_older, &
            s% omega_surf, s% omega_surf_old, s% omega_surf_older, &
            s% omega_crit_surf, s% omega_crit_surf_old, s% omega_crit_surf_older, &
            s% v_div_v_crit_surf, s% v_div_v_crit_surf_old, s% v_div_v_crit_surf_older, &
            s% L_nuc_burn_total, s% L_nuc_burn_total_old, s% L_nuc_burn_total_older, &
            s% L_by_category, s% L_by_category_old, s% L_by_category_older, &
            s% varcontrol, s% varcontrol_old, s% varcontrol_older, &
            s% D_norm_err_est, s% D_norm_err_est_old, s% D_norm_err_est_older, &
            s% err_ratio_max_hydro, s% err_ratio_max_hydro_old, s% err_ratio_max_hydro_older, &
            s% err_ratio_avg_hydro, s% err_ratio_avg_hydro_old, s% err_ratio_avg_hydro_older, &
            s% seulex_kopt, s% seulex_rows, &
            s% L_phot, s% L_phot_old, s% L_phot_older, s% T_surf, s% P_surf, &
            s% min_L, s% min_L_old, s% min_L_older, s% FL_offset, s% FL_offset_old, s% FL_offset_older, &
            s% h1_czb_mass, s% h1_czb_mass_old, s% h1_czb_mass_older, s% h1_czb_mass_prev, &
            s% h1_boundary_mass, s% h1_boundary_mass_old, s% h1_boundary_mass_older, &
            s% he4_boundary_mass, s% he4_boundary_mass_old, s% he4_boundary_mass_older, &
            s% Teff, s% Teff_old, s% Teff_older, &
            s% have_done_TP, s% TP_state, s% TP_state_old, s% TP_state_older, &
            s% TP_count, s% TP_count_old, s% TP_count_older, &
            s% TP_M_H_on, s% TP_M_H_on_old, s% TP_M_H_on_older, &
            s% TP_M_H_min, s% TP_M_H_min_old, s% TP_M_H_min_older, &
            s% n_conv_regions, s% n_conv_regions_old, s% n_conv_regions_older, &
            s% cz_bot_mass(:), s% cz_bot_mass_old(:), s% cz_bot_mass_older(:), &
            s% cz_top_mass(:), s% cz_top_mass_old(:), s% cz_top_mass_older(:)

         write(iounit) &
            s% dt_next, s% i_xlnd, s% i_lnT, s% i_lnR, s% i_FL, s% i_lnPgas, &
            s% i_lnE, s% i_lnTdot, s% i_lnddot, s% i_vel, &
            s% equP, s% equT, s% equR, s% equL, s% equv, s% equlnE, &
            s% equlnTdot, s% equlnddot
         
         write(iounit) s% status_profilename, s% model_profilename, s% most_recent_profile_filename
         
         call write_part_number(iounit)
         write(iounit) &
            s% helium_ignition, s% carbon_ignition, &
            s% recent_log_header, s% phase_of_evolution, &
            s% prev_Tcntr1, s% prev_age1, s% prev_Tcntr2, s% prev_age2, s% prev_Tsurf, &
            s% prv_log_luminosity, s% prv_log_surface_temp, s% prv_log_center_temp, s% prv_log_center_density, &
            s% profile_age, s% post_he_age, s% prev_luminosity, s% ignition_center_xhe, s% he_luminosity_limit, &
            s% prev_cntr_rho, s% next_cntr_rho

         call write_part_number(iounit)
         write(iounit) &
            s% hydro_matrix_type, &
            s% num_jacobians, s% num_solves, s% num_retries, s% num_backups, &
            s% number_of_backups_in_a_row, s% last_backup, &
            s% timestep_hold, s% model_number_for_last_jacobian, s% model_number_for_last_retry, &
            s% mesh_call_number, s% hydro_call_number, s% diffusion_call_number, &
            s% num_diffusion_solver_steps, s% initial_timestep, s% hydro_dt_next, s% why_Tlim, s% result_reason, &
            s% need_to_update_logfile_now, s% need_to_save_profiles_now, s% save_profiles_model_priority, &
            s% doing_flash_wind, s% doing_rlo_wind, s% doing_nova_wind, s% most_recent_photo_name

         call write_part_number(iounit)
         write(iounit) s% len_extra_iwork, s% len_extra_work
         if (s% len_extra_iwork > 0) write(iounit) s% extra_iwork(1:s% len_extra_iwork)
         if (s% len_extra_work > 0) write(iounit) s% extra_work(1:s% len_extra_work)
         if (associated(s% log_column_spec)) then
            write(iounit) size(s% log_column_spec)
            write(iounit) s% log_column_spec(:)
         else
            write(iounit) 0
         end if

         call write_part_number(iounit)
         
         contains
         
         subroutine write_part_number(iounit)
            integer, intent(in) :: iounit
            part_number = part_number + 1
            write(iounit) part_number
         end subroutine write_part_number
         
      
      end subroutine output_star_model


      end module model_out
